---
title: "Velero 1.6: Bring All Your Credentials"
excerpt: In this release, we've grown the team and continue to welcome new members to our community. We're excited to introduce new features such as multiple Backup Storage Location credentials, restore progress reporting, and restoring Kubernetes API groups by priority level, as well as many user and developer experience improvements. We're thrilled to have such significant contributions from the community and we're proud to deliver Velero 1.6.
author_name: Bridget McErlean
slug: Velero-1.6-Bring-All-Your-Credentials
categories: ['velero','release']
image: /img/posts/post-1.6.jpg
# Tag should match author to drive author pages
tags: ['Velero Team', 'Bridget McErlean', 'Velero Release']
---
A highly requested feature for Velero has been designed and implemented in the latest 1.6 release, and that is the ability for Velero to handle multiple credentials for providers.
We are very excited to deliver this feature, as well as other features such as progress reporting for restores and better restoring with the most accurate resource version.

The theme of the v1.6 release is most definitely more flexibility, not only with the features added, but also in terms of the Velero contribution, development, and quality assurance processes.
We worked very hard this cycle to implement an end-to-end testing framework and were able to automate a significant portion of our usually manual testing process.
We also made the day-to-day development process ridiculously easier and faster by integrating our code base with Tilt.

Lastly but no less important, the project has added an additional maintainer and a product manager, and in this post we celebrate this news alongside all the external contributions from our incredible community!

## Release Highlights

### Multiple Backup Storage Location Credentials

Before this release, Velero only supported one set of credentials which was used with all Backup Storage Locations.
Although it was possible to work around this limitation to use different credentials for different providers, it required users to edit the Velero Deployment and, since Velero was only able to recognize one set of credentials per provider, it was not possible to use different credentials for the same provider.
This prevented users from backing up to multiple storage locations with the same provider if different credentials were required.

With the release of Velero 1.6, users can now optionally configure credentials for each Backup Storage Location by creating a Kubernetes Secret in the Velero namespace and then associating the relevant key within that Secret with a new or existing Backup Storage Location.
Velero will then use those credentials when interacting with storage provider plugins.
The v1.2.0 releases of all the plugins maintained by the Velero team support this new way of handling credentials and we look forward to collaborating with more community plugin providers to grow adoption of this feature.

For more information, and detailed instructions on how to configure credentials for your Backup Storage Locations, please see our [documentation](https://velero.io/docs/v1.6/locations/#create-a-storage-location-that-uses-unique-credentials).

### Restore Progress Reporting

It's always been important for our users to have insight into long-running Velero operations.
Velero introduced support for reporting Backup progress in v1.4.0 and, with v1.6.0, this is now also available for Restores, thanks to [Pranav Gaikwad](https://github.com/pranavgaikwad) from Red Hat.
While a restore operation is in progress, users can now inspect the restore using `velero describe restore` to see how many items will be restored, and how many of them have been restored up to that point in time.

### Restoring API Groups by Priority Level

Many users rely on Velero to not only backup and restore their workloads, but also to migrate across clusters and perform Kubernetes upgrades.
When performing a migration or upgrade, it is not uncommon for the Kubernetes API group versions to differ between clusters.
This can result in backups where not all resources can be restored as the API group version for some resources may not be available for use in the new cluster because of Kubernetes API deprecations.

In Velero 1.4, a new feature was added to backup all versions of each resource, not just the cluster preferred version.
For Velero 1.6, [Frankie Gold](https://github.com/codegold79) from VMware adapted the restore flow to make use of this data, enabling Velero or the user to choose the most appropriate version of the resource to restore on the destination cluster.
This allows for much more flexibility when performing migrations into new clusters.

Using this new feature requires the `EnableAPIGroupVersions` feature flag to be enabled in your Velero instance.
For a detailed description of the feature, as well as more information about how Velero decides which version to restore, please see our [documentation](https://velero.io/docs/v1.6/enable-api-group-versions-feature/).

### Restic Upgrade

Velero has upgraded the version of restic it is using from v0.9.6 to the latest version, v0.12.0.
This is an exciting upgrade as it incorporates many bug fixes and performance improvements that will result in a better experience when using restic.

For more information about the improvements provided with this upgrade, please see the [restic changelog](https://github.com/restic/restic/blob/v0.12.0/CHANGELOG.md).

### Increased Stability with End-to-end Testing

As the Velero project continues to grow, it is important that our community of users can continue to trust and rely on Velero to support them in their disaster recovery and migration needs.
During this release cycle, we decided to focus on increased stability by adding a new suite of [end-to-end tests](https://github.com/vmware-tanzu/velero/tree/main/test/e2e).
Although Velero features have always been thoroughly tested, these new tests execute Velero workflows from the perspective of the user interacting with a Velero installation using the CLI.
This new test framework has enabled us to create tests that can be easily run across multiple Kubernetes providers, ensuring that we prevent regressions quickly and early in the development of new features.

We plan to expand on this work in our upcoming releases, including [adding more test cases](https://github.com/vmware-tanzu/velero/issues/3531) and running these tests as [part of our CI process](https://github.com/vmware-tanzu/velero/issues/3574).

### Growing the Velero Team

We're excited to announce that [JenTing Hsiao](https://github.com/jenting) from SUSE has joined the Velero team as a maintainer! Already a maintainer of the Velero Helm chart, JenTing has consistently contributed to the Velero community and we’d like to thank him for his continued support to the project and community.
Welcome, JenTing!

We are also glad to announce that [Eleanor Millman](https://github.com/eleanor-millman) from VMware has joined the project as our product manager.
She is working with the team and community to develop the Velero vision and roadmap.
Feel free to reach out to her with any product thoughts or feedback.
Welcome, Eleanor!

The Velero project welcomes contributors of all kinds.
If you are interested in contributing more, or finding out what is involved in becoming a maintainer, please see our documentation on [project governance](https://github.com/vmware-tanzu/velero/blob/main/GOVERNANCE.md).

### Improving Developer Experience

As we continue to grow our community of contributors, we want to lower the barrier to entry for making contributions to the Velero project.
We’ve made huge improvements to the developer experience during this release cycle by introducing Tilt to the developer workflow.
Using Tilt enables developers to make changes to Velero and its plugins, and have those changes automatically built and deployed to your cluster.
This removes the need for any manual building or pushing of images, and provides a faster and much simpler workflow.
Our Tilt configuration also enables contributors to more easily debug the Velero process using Delve, which has integrations with many editors and IDEs.
If you would like to try it out, please see our [documentation](https://velero.io/docs/v1.6/tilt/).

### Looking Forward

We have more exciting additions and improvements to Velero earmarked for future releases.
For v1.7, we are looking forward to adding the ability to install Velero with [Carvel](https://carvel.dev/), supporting plugin versioning, bringing the CSI snapshotting to GA, having a diagnostics tool, and other improvements.
See our [project roadmap](https://github.com/vmware-tanzu/velero/blob/main/ROADMAP.md#170-roadmap) for the complete list.


### Join the Community and Make Velero Better

Velero is better because of our contributors and maintainers.
It is because of you that we can bring great software to the community.
Please join us during our online [community meetings every Tuesday](https://hackmd.io/Jq6F5zqZR7S80CeDWUklkA?view) and catch up with past meetings on YouTube on the [Velero Community Meetings playlist](https://www.youtube.com/watch?v=nc48ocI-6go&list=PL7bmigfV0EqQRysvqvqOtRNk4L5S7uqwM).

You can always find the latest project information at [velero.io](https://velero.io).
Look for issues on GitHub marked ["Good first issue"](https://github.com/vmware-tanzu/velero/issues?q=is%3Aopen+is%3Aissue+label%3A%22Good+first+issue%22) or ["Help wanted"](https://github.com/vmware-tanzu/velero/issues?q=is%3Aopen+is%3Aissue+label%3A%22Help+wanted%22+) if you want to roll up your sleeves and write some code with us.

For opportunities to help and be helped, visit our [Community Support Q&A on GitHub](https://github.com/vmware-tanzu/velero/discussions/categories/community-support-q-a).

You can chat with us on [Kubernetes Slack in the #velero channel](https://kubernetes.slack.com/messages/C6VCGP4MT) and follow us on Twitter at [@projectvelero](https://twitter.com/projectvelero).
