// Copyright 2021 Google LLC.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// Code generated file. DO NOT EDIT.

// Package cloudsupport provides access to the Google Cloud Support API.
//
// For product documentation, see: https://cloud.google.com/support/docs/apis
//
// Creating a client
//
// Usage example:
//
//   import "google.golang.org/api/cloudsupport/v2beta"
//   ...
//   ctx := context.Background()
//   cloudsupportService, err := cloudsupport.NewService(ctx)
//
// In this example, Google Application Default Credentials are used for authentication.
//
// For information on how to create and obtain Application Default Credentials, see https://developers.google.com/identity/protocols/application-default-credentials.
//
// Other authentication options
//
// To use an API key for authentication (note: some APIs do not support API keys), use option.WithAPIKey:
//
//   cloudsupportService, err := cloudsupport.NewService(ctx, option.WithAPIKey("AIza..."))
//
// To use an OAuth token (e.g., a user token obtained via a three-legged OAuth flow), use option.WithTokenSource:
//
//   config := &oauth2.Config{...}
//   // ...
//   token, err := config.Exchange(ctx, ...)
//   cloudsupportService, err := cloudsupport.NewService(ctx, option.WithTokenSource(config.TokenSource(ctx, token)))
//
// See https://godoc.org/google.golang.org/api/option/ for details on options.
package cloudsupport // import "google.golang.org/api/cloudsupport/v2beta"

import (
	"bytes"
	"context"
	"encoding/json"
	"errors"
	"fmt"
	"io"
	"net/http"
	"net/url"
	"strconv"
	"strings"

	googleapi "google.golang.org/api/googleapi"
	gensupport "google.golang.org/api/internal/gensupport"
	option "google.golang.org/api/option"
	internaloption "google.golang.org/api/option/internaloption"
	htransport "google.golang.org/api/transport/http"
)

// Always reference these packages, just in case the auto-generated code
// below doesn't.
var _ = bytes.NewBuffer
var _ = strconv.Itoa
var _ = fmt.Sprintf
var _ = json.NewDecoder
var _ = io.Copy
var _ = url.Parse
var _ = gensupport.MarshalJSON
var _ = googleapi.Version
var _ = errors.New
var _ = strings.Replace
var _ = context.Canceled
var _ = internaloption.WithDefaultEndpoint

const apiId = "cloudsupport:v2beta"
const apiName = "cloudsupport"
const apiVersion = "v2beta"
const basePath = "https://cloudsupport.googleapis.com/"
const mtlsBasePath = "https://cloudsupport.mtls.googleapis.com/"

// OAuth2 scopes used by this API.
const (
	// See, edit, configure, and delete your Google Cloud data and see the
	// email address for your Google Account.
	CloudPlatformScope = "https://www.googleapis.com/auth/cloud-platform"
)

// NewService creates a new Service.
func NewService(ctx context.Context, opts ...option.ClientOption) (*Service, error) {
	scopesOption := option.WithScopes(
		"https://www.googleapis.com/auth/cloud-platform",
	)
	// NOTE: prepend, so we don't override user-specified scopes.
	opts = append([]option.ClientOption{scopesOption}, opts...)
	opts = append(opts, internaloption.WithDefaultEndpoint(basePath))
	opts = append(opts, internaloption.WithDefaultMTLSEndpoint(mtlsBasePath))
	client, endpoint, err := htransport.NewClient(ctx, opts...)
	if err != nil {
		return nil, err
	}
	s, err := New(client)
	if err != nil {
		return nil, err
	}
	if endpoint != "" {
		s.BasePath = endpoint
	}
	return s, nil
}

// New creates a new Service. It uses the provided http.Client for requests.
//
// Deprecated: please use NewService instead.
// To provide a custom HTTP client, use option.WithHTTPClient.
// If you are using google.golang.org/api/googleapis/transport.APIKey, use option.WithAPIKey with NewService instead.
func New(client *http.Client) (*Service, error) {
	if client == nil {
		return nil, errors.New("client is nil")
	}
	s := &Service{client: client, BasePath: basePath}
	s.Attachments = NewAttachmentsService(s)
	s.CaseClassifications = NewCaseClassificationsService(s)
	s.Cases = NewCasesService(s)
	s.Media = NewMediaService(s)
	return s, nil
}

type Service struct {
	client    *http.Client
	BasePath  string // API endpoint base URL
	UserAgent string // optional additional User-Agent fragment

	Attachments *AttachmentsService

	CaseClassifications *CaseClassificationsService

	Cases *CasesService

	Media *MediaService
}

func (s *Service) userAgent() string {
	if s.UserAgent == "" {
		return googleapi.UserAgent
	}
	return googleapi.UserAgent + " " + s.UserAgent
}

func NewAttachmentsService(s *Service) *AttachmentsService {
	rs := &AttachmentsService{s: s}
	return rs
}

type AttachmentsService struct {
	s *Service
}

func NewCaseClassificationsService(s *Service) *CaseClassificationsService {
	rs := &CaseClassificationsService{s: s}
	return rs
}

type CaseClassificationsService struct {
	s *Service
}

func NewCasesService(s *Service) *CasesService {
	rs := &CasesService{s: s}
	rs.Attachments = NewCasesAttachmentsService(s)
	rs.Comments = NewCasesCommentsService(s)
	return rs
}

type CasesService struct {
	s *Service

	Attachments *CasesAttachmentsService

	Comments *CasesCommentsService
}

func NewCasesAttachmentsService(s *Service) *CasesAttachmentsService {
	rs := &CasesAttachmentsService{s: s}
	return rs
}

type CasesAttachmentsService struct {
	s *Service
}

func NewCasesCommentsService(s *Service) *CasesCommentsService {
	rs := &CasesCommentsService{s: s}
	return rs
}

type CasesCommentsService struct {
	s *Service
}

func NewMediaService(s *Service) *MediaService {
	rs := &MediaService{s: s}
	return rs
}

type MediaService struct {
	s *Service
}

// Actor: An object containing information about the effective user and
// authenticated principal responsible for an action.
type Actor struct {
	// DisplayName: The name to display for the actor. If not provided, it
	// is inferred from credentials supplied during case creation. When an
	// email is provided, a display name must also be provided. This will be
	// obfuscated if the user is a Google Support agent.
	DisplayName string `json:"displayName,omitempty"`

	// Email: The email address of the actor. If not provided, it is
	// inferred from credentials supplied during case creation. If the
	// authenticated principal does not have an email address, one must be
	// provided. When a name is provided, an email must also be provided.
	// This will be obfuscated if the user is a Google Support agent.
	Email string `json:"email,omitempty"`

	// GoogleSupport: Output only. Whether the actor is a Google support
	// actor.
	GoogleSupport bool `json:"googleSupport,omitempty"`

	// PrincipalId: Output only. An ID representing the user that was
	// authenticated when the corresponding action was taken. This will be
	// an email address, if one is available, or some other unique ID. See
	// https://cloud.google.com/docs/authentication for more information on
	// types of authentication.
	PrincipalId string `json:"principalId,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Actor) MarshalJSON() ([]byte, error) {
	type NoMethod Actor
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Attachment: Represents a file attached to a support case.
type Attachment struct {
	// CreateTime: Output only. The time at which the attachment was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Creator: Output only. The user who uploaded the attachment. Note, the
	// name and email will be obfuscated if the attachment was uploaded by
	// Google support.
	Creator *Actor `json:"creator,omitempty"`

	// Filename: The filename of the attachment (e.g. "graph.jpg").
	Filename string `json:"filename,omitempty"`

	// MimeType: Output only. The MIME type of the attachment (e.g.
	// text/plain).
	MimeType string `json:"mimeType,omitempty"`

	// Name: Output only. The resource name of the attachment.
	Name string `json:"name,omitempty"`

	// SizeBytes: Output only. The size of the attachment in bytes.
	SizeBytes int64 `json:"sizeBytes,omitempty,string"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CreateTime") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CreateTime") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Attachment) MarshalJSON() ([]byte, error) {
	type NoMethod Attachment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Blobstore2Info: # gdata.* are outside protos with mising
// documentation
type Blobstore2Info struct {
	// BlobGeneration: # gdata.* are outside protos with mising
	// documentation
	BlobGeneration int64 `json:"blobGeneration,omitempty,string"`

	// BlobId: # gdata.* are outside protos with mising documentation
	BlobId string `json:"blobId,omitempty"`

	// DownloadReadHandle: # gdata.* are outside protos with mising
	// documentation
	DownloadReadHandle string `json:"downloadReadHandle,omitempty"`

	// ReadToken: # gdata.* are outside protos with mising documentation
	ReadToken string `json:"readToken,omitempty"`

	// UploadMetadataContainer: # gdata.* are outside protos with mising
	// documentation
	UploadMetadataContainer string `json:"uploadMetadataContainer,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlobGeneration") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlobGeneration") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Blobstore2Info) MarshalJSON() ([]byte, error) {
	type NoMethod Blobstore2Info
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Case: A support case.
type Case struct {
	// Classification: The issue classification applicable to this case.
	Classification *CaseClassification `json:"classification,omitempty"`

	// CreateTime: Output only. The time this case was created.
	CreateTime string `json:"createTime,omitempty"`

	// Creator: The user who created the case. Note: The name and email will
	// be obfuscated if the case was created by Google Support.
	Creator *Actor `json:"creator,omitempty"`

	// Description: A broad description of the issue.
	Description string `json:"description,omitempty"`

	// DisplayName: The short summary of the issue reported in this case.
	DisplayName string `json:"displayName,omitempty"`

	// Escalated: Whether the case is currently escalated.
	Escalated bool `json:"escalated,omitempty"`

	// Name: The resource name for the case.
	Name string `json:"name,omitempty"`

	// Severity: The severity of this case.
	//
	// Possible values:
	//   "SEVERITY_UNSPECIFIED" - Severity is undefined or has not been set
	// yet.
	//   "S0" - Extreme impact on a production service. Service is hard
	// down.
	//   "S1" - Critical impact on a production service. Service is
	// currently unusable.
	//   "S2" - Severe impact on a production service. Service is usable but
	// greatly impaired.
	//   "S3" - Medium impact on a production service. Service is available,
	// but moderately impaired.
	//   "S4" - General questions or minor issues. Production service is
	// fully available.
	Severity string `json:"severity,omitempty"`

	// State: Output only. The current status of the support case.
	//
	// Possible values:
	//   "STATE_UNSPECIFIED" - Case is in an unknown state.
	//   "NEW" - The case has been created but no one is assigned to work on
	// it yet.
	//   "IN_PROGRESS_GOOGLE_SUPPORT" - The case is currently being handled
	// by Google support.
	//   "ACTION_REQUIRED" - Google is waiting for a response.
	//   "SOLUTION_PROVIDED" - A solution has been offered for the case, but
	// it isn't yet closed.
	//   "CLOSED" - The case has been resolved.
	State string `json:"state,omitempty"`

	// SubscriberEmailAddresses: The email addresses to receive updates on
	// this case.
	SubscriberEmailAddresses []string `json:"subscriberEmailAddresses,omitempty"`

	// TestCase: Whether this case was created for internal API testing and
	// should not be acted on by the support team.
	TestCase bool `json:"testCase,omitempty"`

	// TimeZone: The timezone of the user who created the support case. It
	// should be in a format IANA recognizes:
	// https://www.iana.org/time-zones. There is no additional validation
	// done by the API.
	TimeZone string `json:"timeZone,omitempty"`

	// UpdateTime: Output only. The time this case was last updated.
	UpdateTime string `json:"updateTime,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Classification") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Classification") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *Case) MarshalJSON() ([]byte, error) {
	type NoMethod Case
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CaseClassification: A classification object with a product type and
// value.
type CaseClassification struct {
	// DisplayName: The display name of the classification.
	DisplayName string `json:"displayName,omitempty"`

	// Id: The unique ID for a classification. Must be specified for case
	// creation.
	Id string `json:"id,omitempty"`

	// ForceSendFields is a list of field names (e.g. "DisplayName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "DisplayName") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CaseClassification) MarshalJSON() ([]byte, error) {
	type NoMethod CaseClassification
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CloseCaseRequest: The request message for the CloseCase endpoint.
type CloseCaseRequest struct {
}

// Comment: A comment associated with a support case.
type Comment struct {
	// Body: The full comment body. Maximum of 120000 characters. This can
	// contain rich text syntax.
	Body string `json:"body,omitempty"`

	// CreateTime: Output only. The time when this comment was created.
	CreateTime string `json:"createTime,omitempty"`

	// Creator: Output only. The user or Google Support agent created this
	// comment.
	Creator *Actor `json:"creator,omitempty"`

	// Name: Output only. The resource name for the comment.
	Name string `json:"name,omitempty"`

	// PlainTextBody: Output only. An automatically generated plain text
	// version of body with all rich text syntax stripped.
	PlainTextBody string `json:"plainTextBody,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Body") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Body") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Comment) MarshalJSON() ([]byte, error) {
	type NoMethod Comment
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CompositeMedia: # gdata.* are outside protos with mising
// documentation
type CompositeMedia struct {
	// BlobRef: # gdata.* are outside protos with mising documentation
	BlobRef string `json:"blobRef,omitempty"`

	// Blobstore2Info: # gdata.* are outside protos with mising
	// documentation
	Blobstore2Info *Blobstore2Info `json:"blobstore2Info,omitempty"`

	// CosmoBinaryReference: # gdata.* are outside protos with mising
	// documentation
	CosmoBinaryReference string `json:"cosmoBinaryReference,omitempty"`

	// Crc32cHash: # gdata.* are outside protos with mising documentation
	Crc32cHash int64 `json:"crc32cHash,omitempty"`

	// Inline: # gdata.* are outside protos with mising documentation
	Inline string `json:"inline,omitempty"`

	// Length: # gdata.* are outside protos with mising documentation
	Length int64 `json:"length,omitempty,string"`

	// Md5Hash: # gdata.* are outside protos with mising documentation
	Md5Hash string `json:"md5Hash,omitempty"`

	// ObjectId: # gdata.* are outside protos with mising documentation
	ObjectId *ObjectId `json:"objectId,omitempty"`

	// Path: # gdata.* are outside protos with mising documentation
	Path string `json:"path,omitempty"`

	// ReferenceType: # gdata.* are outside protos with mising documentation
	//
	// Possible values:
	//   "PATH" - # gdata.* are outside protos with mising documentation
	//   "BLOB_REF" - # gdata.* are outside protos with mising documentation
	//   "INLINE" - # gdata.* are outside protos with mising documentation
	//   "BIGSTORE_REF" - # gdata.* are outside protos with mising
	// documentation
	//   "COSMO_BINARY_REFERENCE" - # gdata.* are outside protos with mising
	// documentation
	ReferenceType string `json:"referenceType,omitempty"`

	// Sha1Hash: # gdata.* are outside protos with mising documentation
	Sha1Hash string `json:"sha1Hash,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BlobRef") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BlobRef") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CompositeMedia) MarshalJSON() ([]byte, error) {
	type NoMethod CompositeMedia
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ContentTypeInfo: # gdata.* are outside protos with mising
// documentation
type ContentTypeInfo struct {
	// BestGuess: # gdata.* are outside protos with mising documentation
	BestGuess string `json:"bestGuess,omitempty"`

	// FromBytes: # gdata.* are outside protos with mising documentation
	FromBytes string `json:"fromBytes,omitempty"`

	// FromFileName: # gdata.* are outside protos with mising documentation
	FromFileName string `json:"fromFileName,omitempty"`

	// FromHeader: # gdata.* are outside protos with mising documentation
	FromHeader string `json:"fromHeader,omitempty"`

	// FromUrlPath: # gdata.* are outside protos with mising documentation
	FromUrlPath string `json:"fromUrlPath,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BestGuess") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BestGuess") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ContentTypeInfo) MarshalJSON() ([]byte, error) {
	type NoMethod ContentTypeInfo
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// CreateAttachmentRequest: The request message for the CreateAttachment
// endpoint.
type CreateAttachmentRequest struct {
	// Attachment: Required. The attachment to be created.
	Attachment *Attachment `json:"attachment,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Attachment") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attachment") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *CreateAttachmentRequest) MarshalJSON() ([]byte, error) {
	type NoMethod CreateAttachmentRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiffChecksumsResponse: # gdata.* are outside protos with mising
// documentation
type DiffChecksumsResponse struct {
	// ChecksumsLocation: # gdata.* are outside protos with mising
	// documentation
	ChecksumsLocation *CompositeMedia `json:"checksumsLocation,omitempty"`

	// ChunkSizeBytes: # gdata.* are outside protos with mising
	// documentation
	ChunkSizeBytes int64 `json:"chunkSizeBytes,omitempty,string"`

	// ObjectLocation: # gdata.* are outside protos with mising
	// documentation
	ObjectLocation *CompositeMedia `json:"objectLocation,omitempty"`

	// ObjectSizeBytes: # gdata.* are outside protos with mising
	// documentation
	ObjectSizeBytes int64 `json:"objectSizeBytes,omitempty,string"`

	// ObjectVersion: # gdata.* are outside protos with mising documentation
	ObjectVersion string `json:"objectVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChecksumsLocation")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChecksumsLocation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiffChecksumsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DiffChecksumsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiffDownloadResponse: # gdata.* are outside protos with mising
// documentation
type DiffDownloadResponse struct {
	// ObjectLocation: # gdata.* are outside protos with mising
	// documentation
	ObjectLocation *CompositeMedia `json:"objectLocation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ObjectLocation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ObjectLocation") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiffDownloadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DiffDownloadResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiffUploadRequest: # gdata.* are outside protos with mising
// documentation
type DiffUploadRequest struct {
	// ChecksumsInfo: # gdata.* are outside protos with mising documentation
	ChecksumsInfo *CompositeMedia `json:"checksumsInfo,omitempty"`

	// ObjectInfo: # gdata.* are outside protos with mising documentation
	ObjectInfo *CompositeMedia `json:"objectInfo,omitempty"`

	// ObjectVersion: # gdata.* are outside protos with mising documentation
	ObjectVersion string `json:"objectVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ChecksumsInfo") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ChecksumsInfo") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiffUploadRequest) MarshalJSON() ([]byte, error) {
	type NoMethod DiffUploadRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiffUploadResponse: # gdata.* are outside protos with mising
// documentation
type DiffUploadResponse struct {
	// ObjectVersion: # gdata.* are outside protos with mising documentation
	ObjectVersion string `json:"objectVersion,omitempty"`

	// OriginalObject: # gdata.* are outside protos with mising
	// documentation
	OriginalObject *CompositeMedia `json:"originalObject,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ObjectVersion") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ObjectVersion") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *DiffUploadResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DiffUploadResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DiffVersionResponse: # gdata.* are outside protos with mising
// documentation
type DiffVersionResponse struct {
	// ObjectSizeBytes: # gdata.* are outside protos with mising
	// documentation
	ObjectSizeBytes int64 `json:"objectSizeBytes,omitempty,string"`

	// ObjectVersion: # gdata.* are outside protos with mising documentation
	ObjectVersion string `json:"objectVersion,omitempty"`

	// ForceSendFields is a list of field names (e.g. "ObjectSizeBytes") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "ObjectSizeBytes") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DiffVersionResponse) MarshalJSON() ([]byte, error) {
	type NoMethod DiffVersionResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// DownloadParameters: # gdata.* are outside protos with mising
// documentation
type DownloadParameters struct {
	// AllowGzipCompression: # gdata.* are outside protos with mising
	// documentation
	AllowGzipCompression bool `json:"allowGzipCompression,omitempty"`

	// IgnoreRange: # gdata.* are outside protos with mising documentation
	IgnoreRange bool `json:"ignoreRange,omitempty"`

	// ForceSendFields is a list of field names (e.g.
	// "AllowGzipCompression") to unconditionally include in API requests.
	// By default, fields with empty or default values are omitted from API
	// requests. However, any non-pointer, non-interface field appearing in
	// ForceSendFields will be sent to the server regardless of whether the
	// field is empty or not. This may be used to include empty fields in
	// Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "AllowGzipCompression") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *DownloadParameters) MarshalJSON() ([]byte, error) {
	type NoMethod DownloadParameters
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// EscalateCaseRequest: The request message for the EscalateCase
// endpoint.
type EscalateCaseRequest struct {
	// Escalation: The escalation object to be sent with the escalation
	// request.
	Escalation *Escalation `json:"escalation,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Escalation") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Escalation") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *EscalateCaseRequest) MarshalJSON() ([]byte, error) {
	type NoMethod EscalateCaseRequest
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Escalation: An escalation of a support case.
type Escalation struct {
	// Actor: Output only. The user or Google Support agent initiated this
	// escalation.
	Actor *Actor `json:"actor,omitempty"`

	// CreateTime: Output only. The time when this escalation event was
	// created.
	CreateTime string `json:"createTime,omitempty"`

	// Justification: Required. A free text description to accompany the
	// `reason` field above. Provides additional context on why the case is
	// being escalated.
	Justification string `json:"justification,omitempty"`

	// Name: Output only. The resource name for the escalation event.
	Name string `json:"name,omitempty"`

	// Reason: Required. The reason why the Case is being escalated.
	//
	// Possible values:
	//   "REASON_UNSPECIFIED" - The escalation reason is in an unknown state
	// or has not been specified.
	//   "RESOLUTION_TIME" - The case is taking too long to resolve.
	//   "TECHNICAL_EXPERTISE" - The support agent does not have the
	// expertise required to successfully resolve the issue.
	//   "BUSINESS_IMPACT" - The issue is having a significant business
	// impact.
	Reason string `json:"reason,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Actor") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Actor") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Escalation) MarshalJSON() ([]byte, error) {
	type NoMethod Escalation
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListAttachmentsResponse: The response message for the ListAttachments
// endpoint.
type ListAttachmentsResponse struct {
	// Attachments: The list of attachments associated with the given case.
	Attachments []*Attachment `json:"attachments,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. This
	// should be set in the `page_token` field of subsequent
	// `cases.attachments.list` requests. If unspecified, there are no more
	// results to retrieve.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Attachments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Attachments") to include
	// in API requests with the JSON null value. By default, fields with
	// empty values are omitted from API requests. However, any field with
	// an empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListAttachmentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListAttachmentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListCasesResponse: The response message for the ListCases endpoint.
type ListCasesResponse struct {
	// Cases: The list of cases associated with the cloud resource, after
	// any filters have been applied.
	Cases []*Case `json:"cases,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. This
	// should be set in the `page_token` field of subsequent
	// `ListCasesRequest` message that is issued. If unspecified, there are
	// no more results to retrieve.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Cases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ListCommentsResponse: The response message for the ListComments
// endpoint.
type ListCommentsResponse struct {
	// Comments: The list of Comments associated with the given Case.
	Comments []*Comment `json:"comments,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. This
	// should be set in the `page_token` field of subsequent
	// `ListCommentsRequest` message that is issued. If unspecified, there
	// are no more results to retrieve.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Comments") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Comments") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ListCommentsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod ListCommentsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// Media: # gdata.* are outside protos with mising documentation
type Media struct {
	// Algorithm: # gdata.* are outside protos with mising documentation
	Algorithm string `json:"algorithm,omitempty"`

	// BigstoreObjectRef: # gdata.* are outside protos with mising
	// documentation
	BigstoreObjectRef string `json:"bigstoreObjectRef,omitempty"`

	// BlobRef: # gdata.* are outside protos with mising documentation
	BlobRef string `json:"blobRef,omitempty"`

	// Blobstore2Info: # gdata.* are outside protos with mising
	// documentation
	Blobstore2Info *Blobstore2Info `json:"blobstore2Info,omitempty"`

	// CompositeMedia: # gdata.* are outside protos with mising
	// documentation
	CompositeMedia []*CompositeMedia `json:"compositeMedia,omitempty"`

	// ContentType: # gdata.* are outside protos with mising documentation
	ContentType string `json:"contentType,omitempty"`

	// ContentTypeInfo: # gdata.* are outside protos with mising
	// documentation
	ContentTypeInfo *ContentTypeInfo `json:"contentTypeInfo,omitempty"`

	// CosmoBinaryReference: # gdata.* are outside protos with mising
	// documentation
	CosmoBinaryReference string `json:"cosmoBinaryReference,omitempty"`

	// Crc32cHash: # gdata.* are outside protos with mising documentation
	Crc32cHash int64 `json:"crc32cHash,omitempty"`

	// DiffChecksumsResponse: # gdata.* are outside protos with mising
	// documentation
	DiffChecksumsResponse *DiffChecksumsResponse `json:"diffChecksumsResponse,omitempty"`

	// DiffDownloadResponse: # gdata.* are outside protos with mising
	// documentation
	DiffDownloadResponse *DiffDownloadResponse `json:"diffDownloadResponse,omitempty"`

	// DiffUploadRequest: # gdata.* are outside protos with mising
	// documentation
	DiffUploadRequest *DiffUploadRequest `json:"diffUploadRequest,omitempty"`

	// DiffUploadResponse: # gdata.* are outside protos with mising
	// documentation
	DiffUploadResponse *DiffUploadResponse `json:"diffUploadResponse,omitempty"`

	// DiffVersionResponse: # gdata.* are outside protos with mising
	// documentation
	DiffVersionResponse *DiffVersionResponse `json:"diffVersionResponse,omitempty"`

	// DownloadParameters: # gdata.* are outside protos with mising
	// documentation
	DownloadParameters *DownloadParameters `json:"downloadParameters,omitempty"`

	// Filename: # gdata.* are outside protos with mising documentation
	Filename string `json:"filename,omitempty"`

	// Hash: # gdata.* are outside protos with mising documentation
	Hash string `json:"hash,omitempty"`

	// HashVerified: # gdata.* are outside protos with mising documentation
	HashVerified bool `json:"hashVerified,omitempty"`

	// Inline: # gdata.* are outside protos with mising documentation
	Inline string `json:"inline,omitempty"`

	// IsPotentialRetry: # gdata.* are outside protos with mising
	// documentation
	IsPotentialRetry bool `json:"isPotentialRetry,omitempty"`

	// Length: # gdata.* are outside protos with mising documentation
	Length int64 `json:"length,omitempty,string"`

	// Md5Hash: # gdata.* are outside protos with mising documentation
	Md5Hash string `json:"md5Hash,omitempty"`

	// MediaId: # gdata.* are outside protos with mising documentation
	MediaId string `json:"mediaId,omitempty"`

	// ObjectId: # gdata.* are outside protos with mising documentation
	ObjectId *ObjectId `json:"objectId,omitempty"`

	// Path: # gdata.* are outside protos with mising documentation
	Path string `json:"path,omitempty"`

	// ReferenceType: # gdata.* are outside protos with mising documentation
	//
	// Possible values:
	//   "PATH" - # gdata.* are outside protos with mising documentation
	//   "BLOB_REF" - # gdata.* are outside protos with mising documentation
	//   "INLINE" - # gdata.* are outside protos with mising documentation
	//   "GET_MEDIA" - # gdata.* are outside protos with mising
	// documentation
	//   "COMPOSITE_MEDIA" - # gdata.* are outside protos with mising
	// documentation
	//   "BIGSTORE_REF" - # gdata.* are outside protos with mising
	// documentation
	//   "DIFF_VERSION_RESPONSE" - # gdata.* are outside protos with mising
	// documentation
	//   "DIFF_CHECKSUMS_RESPONSE" - # gdata.* are outside protos with
	// mising documentation
	//   "DIFF_DOWNLOAD_RESPONSE" - # gdata.* are outside protos with mising
	// documentation
	//   "DIFF_UPLOAD_REQUEST" - # gdata.* are outside protos with mising
	// documentation
	//   "DIFF_UPLOAD_RESPONSE" - # gdata.* are outside protos with mising
	// documentation
	//   "COSMO_BINARY_REFERENCE" - # gdata.* are outside protos with mising
	// documentation
	//   "ARBITRARY_BYTES" - # gdata.* are outside protos with mising
	// documentation
	ReferenceType string `json:"referenceType,omitempty"`

	// Sha1Hash: # gdata.* are outside protos with mising documentation
	Sha1Hash string `json:"sha1Hash,omitempty"`

	// Sha256Hash: # gdata.* are outside protos with mising documentation
	Sha256Hash string `json:"sha256Hash,omitempty"`

	// Timestamp: # gdata.* are outside protos with mising documentation
	Timestamp uint64 `json:"timestamp,omitempty,string"`

	// Token: # gdata.* are outside protos with mising documentation
	Token string `json:"token,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Algorithm") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Algorithm") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *Media) MarshalJSON() ([]byte, error) {
	type NoMethod Media
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// ObjectId: # gdata.* are outside protos with mising documentation
type ObjectId struct {
	// BucketName: # gdata.* are outside protos with mising documentation
	BucketName string `json:"bucketName,omitempty"`

	// Generation: # gdata.* are outside protos with mising documentation
	Generation int64 `json:"generation,omitempty,string"`

	// ObjectName: # gdata.* are outside protos with mising documentation
	ObjectName string `json:"objectName,omitempty"`

	// ForceSendFields is a list of field names (e.g. "BucketName") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "BucketName") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *ObjectId) MarshalJSON() ([]byte, error) {
	type NoMethod ObjectId
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchCaseClassificationsResponse: The response message for
// SearchCaseClassifications endpoint.
type SearchCaseClassificationsResponse struct {
	// CaseClassifications: The classifications retrieved.
	CaseClassifications []*CaseClassification `json:"caseClassifications,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. This
	// should be set in the `page_token` field of subsequent
	// `SearchCaseClassificationsRequest` message that is issued. If
	// unspecified, there are no more results to retrieve.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "CaseClassifications")
	// to unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "CaseClassifications") to
	// include in API requests with the JSON null value. By default, fields
	// with empty values are omitted from API requests. However, any field
	// with an empty value appearing in NullFields will be sent to the
	// server as null. It is an error if a field in this list has a
	// non-empty value. This may be used to include null fields in Patch
	// requests.
	NullFields []string `json:"-"`
}

func (s *SearchCaseClassificationsResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchCaseClassificationsResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// SearchCasesResponse: The response message for the SearchCases
// endpoint.
type SearchCasesResponse struct {
	// Cases: The list of Case associated with the cloud resource, after any
	// filters have been applied.
	Cases []*Case `json:"cases,omitempty"`

	// NextPageToken: A token to retrieve the next page of results. This
	// should be set in the `page_token` field of subsequent
	// `SearchCaseRequest` message that is issued. If unspecified, there are
	// no more results to retrieve.
	NextPageToken string `json:"nextPageToken,omitempty"`

	// ServerResponse contains the HTTP response code and headers from the
	// server.
	googleapi.ServerResponse `json:"-"`

	// ForceSendFields is a list of field names (e.g. "Cases") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Cases") to include in API
	// requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *SearchCasesResponse) MarshalJSON() ([]byte, error) {
	type NoMethod SearchCasesResponse
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// WorkflowOperationMetadata: Metadata about the operation. Used to
// lookup the current status.
type WorkflowOperationMetadata struct {
	// Namespace: The namespace that the job was scheduled in. Must be
	// included in the workflow metadata so the workflow status can be
	// retrieved.
	Namespace string `json:"namespace,omitempty"`

	// OperationAction: The type of action the operation is classified as.
	//
	// Possible values:
	//   "OPERATION_ACTION_UNSPECIFIED" - Operation action is not specified.
	//   "CREATE_SUPPORT_ACCOUNT" - Operation pertains to the creation of a
	// new support account.
	//   "UPDATE_SUPPORT_ACCOUNT" - Operation pertains to the updating of an
	// existing support account.
	//   "PURCHASE_SUPPORT_ACCOUNT" - Operation pertains to the purchasing
	// of a support plan that may either create or update a support account.
	OperationAction string `json:"operationAction,omitempty"`

	// WorkflowOperationType: Which version of the workflow service this
	// operation came from.
	//
	// Possible values:
	//   "UNKNOWN_OPERATION_TYPE" - Unknown version.
	//   "WORKFLOWS_V1" - Version 1.
	//   "WORKFLOWS_V2" - Version 2.
	WorkflowOperationType string `json:"workflowOperationType,omitempty"`

	// ForceSendFields is a list of field names (e.g. "Namespace") to
	// unconditionally include in API requests. By default, fields with
	// empty or default values are omitted from API requests. However, any
	// non-pointer, non-interface field appearing in ForceSendFields will be
	// sent to the server regardless of whether the field is empty or not.
	// This may be used to include empty fields in Patch requests.
	ForceSendFields []string `json:"-"`

	// NullFields is a list of field names (e.g. "Namespace") to include in
	// API requests with the JSON null value. By default, fields with empty
	// values are omitted from API requests. However, any field with an
	// empty value appearing in NullFields will be sent to the server as
	// null. It is an error if a field in this list has a non-empty value.
	// This may be used to include null fields in Patch requests.
	NullFields []string `json:"-"`
}

func (s *WorkflowOperationMetadata) MarshalJSON() ([]byte, error) {
	type NoMethod WorkflowOperationMetadata
	raw := NoMethod(*s)
	return gensupport.MarshalJSON(raw, s.ForceSendFields, s.NullFields)
}

// method id "cloudsupport.attachments.create":

type AttachmentsCreateCall struct {
	s                       *Service
	parent                  string
	createattachmentrequest *CreateAttachmentRequest
	urlParams_              gensupport.URLParams
	ctx_                    context.Context
	header_                 http.Header
}

// Create: Create a file attachment on a case or Cloud resource.
//
// - parent: The resource name of the case to which attachment should be
//   attached.
func (r *AttachmentsService) Create(parent string, createattachmentrequest *CreateAttachmentRequest) *AttachmentsCreateCall {
	c := &AttachmentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.createattachmentrequest = createattachmentrequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *AttachmentsCreateCall) Fields(s ...googleapi.Field) *AttachmentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *AttachmentsCreateCall) Context(ctx context.Context) *AttachmentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *AttachmentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *AttachmentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.createattachmentrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+parent}/attachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.attachments.create" call.
// Exactly one of *Attachment or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Attachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *AttachmentsCreateCall) Do(opts ...googleapi.CallOption) (*Attachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Attachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a file attachment on a case or Cloud resource.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/attachments",
	//   "httpMethod": "POST",
	//   "id": "cloudsupport.attachments.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the case to which attachment should be attached.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+parent}/attachments",
	//   "request": {
	//     "$ref": "CreateAttachmentRequest"
	//   },
	//   "response": {
	//     "$ref": "Attachment"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudsupport.caseClassifications.search":

type CaseClassificationsSearchCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Retrieve valid classifications to be used when creating a
// support case. The classications are hierarchical, with each
// classification containing all levels of the hierarchy, separated by "
// > ". For example "Technical Issue > Compute > Compute Engine".
func (r *CaseClassificationsService) Search() *CaseClassificationsSearchCall {
	c := &CaseClassificationsSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of cases fetched with each request.
func (c *CaseClassificationsSearchCall) PageSize(pageSize int64) *CaseClassificationsSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying the page of results to return. If unspecified, the first
// page is retrieved.
func (c *CaseClassificationsSearchCall) PageToken(pageToken string) *CaseClassificationsSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": An expression written in
// the Cloud filter language. If non-empty, then only cases whose fields
// match the filter are returned. If empty, then no messages are
// filtered out.
func (c *CaseClassificationsSearchCall) Query(query string) *CaseClassificationsSearchCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CaseClassificationsSearchCall) Fields(s ...googleapi.Field) *CaseClassificationsSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CaseClassificationsSearchCall) IfNoneMatch(entityTag string) *CaseClassificationsSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CaseClassificationsSearchCall) Context(ctx context.Context) *CaseClassificationsSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CaseClassificationsSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CaseClassificationsSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/caseClassifications:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.caseClassifications.search" call.
// Exactly one of *SearchCaseClassificationsResponse or error will be
// non-nil. Any non-2xx status code is an error. Response headers are in
// either *SearchCaseClassificationsResponse.ServerResponse.Header or
// (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CaseClassificationsSearchCall) Do(opts ...googleapi.CallOption) (*SearchCaseClassificationsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SearchCaseClassificationsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieve valid classifications to be used when creating a support case. The classications are hierarchical, with each classification containing all levels of the hierarchy, separated by \" \u003e \". For example \"Technical Issue \u003e Compute \u003e Compute Engine\".",
	//   "flatPath": "v2beta/caseClassifications:search",
	//   "httpMethod": "GET",
	//   "id": "cloudsupport.caseClassifications.search",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of cases fetched with each request.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying the page of results to return. If unspecified, the first page is retrieved.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "An expression written in the Cloud filter language. If non-empty, then only cases whose fields match the filter are returned. If empty, then no messages are filtered out.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/caseClassifications:search",
	//   "response": {
	//     "$ref": "SearchCaseClassificationsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CaseClassificationsSearchCall) Pages(ctx context.Context, f func(*SearchCaseClassificationsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudsupport.cases.close":

type CasesCloseCall struct {
	s                *Service
	name             string
	closecaserequest *CloseCaseRequest
	urlParams_       gensupport.URLParams
	ctx_             context.Context
	header_          http.Header
}

// Close: Close the specified case.
//
// - name: The fully qualified name of the case resource to be closed.
func (r *CasesService) Close(name string, closecaserequest *CloseCaseRequest) *CasesCloseCall {
	c := &CasesCloseCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.closecaserequest = closecaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesCloseCall) Fields(s ...googleapi.Field) *CasesCloseCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesCloseCall) Context(ctx context.Context) *CasesCloseCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesCloseCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesCloseCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.closecaserequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+name}:close")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.close" call.
// Exactly one of *Case or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Case.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CasesCloseCall) Do(opts ...googleapi.CallOption) (*Case, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Case{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Close the specified case.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}:close",
	//   "httpMethod": "POST",
	//   "id": "cloudsupport.cases.close",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The fully qualified name of the case resource to be closed.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+name}:close",
	//   "request": {
	//     "$ref": "CloseCaseRequest"
	//   },
	//   "response": {
	//     "$ref": "Case"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudsupport.cases.create":

type CasesCreateCall struct {
	s          *Service
	parent     string
	case_      *Case
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Create a new case and associate it with the given Cloud
// resource.
//
// - parent: The name of the Cloud resource under which the case should
//   be created.
func (r *CasesService) Create(parent string, case_ *Case) *CasesCreateCall {
	c := &CasesCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.case_ = case_
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesCreateCall) Fields(s ...googleapi.Field) *CasesCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesCreateCall) Context(ctx context.Context) *CasesCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.case_)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+parent}/cases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.create" call.
// Exactly one of *Case or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Case.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CasesCreateCall) Do(opts ...googleapi.CallOption) (*Case, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Case{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a new case and associate it with the given Cloud resource.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases",
	//   "httpMethod": "POST",
	//   "id": "cloudsupport.cases.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The name of the Cloud resource under which the case should be created.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+parent}/cases",
	//   "request": {
	//     "$ref": "Case"
	//   },
	//   "response": {
	//     "$ref": "Case"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudsupport.cases.escalate":

type CasesEscalateCall struct {
	s                   *Service
	name                string
	escalatecaserequest *EscalateCaseRequest
	urlParams_          gensupport.URLParams
	ctx_                context.Context
	header_             http.Header
}

// Escalate: Escalate a case. Escalating a case will initiate the Cloud
// Support escalation management process. This operation is only
// available to certain Customer Care tiers. Go to
// https://cloud.google.com/support and look for 'Technical support
// escalations' in the feature list to find out which tiers are able to
// perform escalations.
//
// - name: The fully qualified name of the Case resource to be
//   escalated.
func (r *CasesService) Escalate(name string, escalatecaserequest *EscalateCaseRequest) *CasesEscalateCall {
	c := &CasesEscalateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.escalatecaserequest = escalatecaserequest
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesEscalateCall) Fields(s ...googleapi.Field) *CasesEscalateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesEscalateCall) Context(ctx context.Context) *CasesEscalateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesEscalateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesEscalateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.escalatecaserequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+name}:escalate")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.escalate" call.
// Exactly one of *Case or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Case.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CasesEscalateCall) Do(opts ...googleapi.CallOption) (*Case, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Case{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Escalate a case. Escalating a case will initiate the Cloud Support escalation management process. This operation is only available to certain Customer Care tiers. Go to https://cloud.google.com/support and look for 'Technical support escalations' in the feature list to find out which tiers are able to perform escalations.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}:escalate",
	//   "httpMethod": "POST",
	//   "id": "cloudsupport.cases.escalate",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The fully qualified name of the Case resource to be escalated.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+name}:escalate",
	//   "request": {
	//     "$ref": "EscalateCaseRequest"
	//   },
	//   "response": {
	//     "$ref": "Case"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudsupport.cases.get":

type CasesGetCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Get: Retrieve the specified case.
//
// - name: The fully qualified name of a case to be retrieved.
func (r *CasesService) Get(name string) *CasesGetCall {
	c := &CasesGetCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesGetCall) Fields(s ...googleapi.Field) *CasesGetCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CasesGetCall) IfNoneMatch(entityTag string) *CasesGetCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesGetCall) Context(ctx context.Context) *CasesGetCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesGetCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesGetCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.get" call.
// Exactly one of *Case or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Case.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CasesGetCall) Do(opts ...googleapi.CallOption) (*Case, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Case{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieve the specified case.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}",
	//   "httpMethod": "GET",
	//   "id": "cloudsupport.cases.get",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "Required. The fully qualified name of a case to be retrieved.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+name}",
	//   "response": {
	//     "$ref": "Case"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudsupport.cases.list":

type CasesListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve all cases under the specified parent.
//
// - parent: The fully qualified name of parent resource to list cases
//   under.
func (r *CasesService) List(parent string) *CasesListCall {
	c := &CasesListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// Filter sets the optional parameter "filter": An expression written in
// the Cloud filter language. If non-empty, then only cases whose fields
// match the filter are returned. If empty, then no messages are
// filtered out. Filter strings can use the following fields: - status
// (Accepted values: OPEN or CLOSED) - severity (Accepted values: S0,
// S1, S2, S3, or S4) - creator.email with the operators equals (=) and
// AND. Additionally, a global restriction (with no operator) can be
// used to search across displayName, description, and comments (e.g.
// "my search").
func (c *CasesListCall) Filter(filter string) *CasesListCall {
	c.urlParams_.Set("filter", filter)
	return c
}

// OrderBy sets the optional parameter "orderBy": A comma separated list
// of fields to order by, followed by `asc` or `desc` postfix. This list
// is case-insensitive, default sorting order is ascending, redundant
// space characters are insignificant. Example: `name asc,update_time,
// create_time desc`
func (c *CasesListCall) OrderBy(orderBy string) *CasesListCall {
	c.urlParams_.Set("orderBy", orderBy)
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of cases fetched with each request. Defaults to 10.
func (c *CasesListCall) PageSize(pageSize int64) *CasesListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying the page of results to return. If unspecified, the first
// page is retrieved.
func (c *CasesListCall) PageToken(pageToken string) *CasesListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesListCall) Fields(s ...googleapi.Field) *CasesListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CasesListCall) IfNoneMatch(entityTag string) *CasesListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesListCall) Context(ctx context.Context) *CasesListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+parent}/cases")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.list" call.
// Exactly one of *ListCasesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListCasesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CasesListCall) Do(opts ...googleapi.CallOption) (*ListCasesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListCasesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieve all cases under the specified parent.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases",
	//   "httpMethod": "GET",
	//   "id": "cloudsupport.cases.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "filter": {
	//       "description": "An expression written in the Cloud filter language. If non-empty, then only cases whose fields match the filter are returned. If empty, then no messages are filtered out. Filter strings can use the following fields: - status (Accepted values: OPEN or CLOSED) - severity (Accepted values: S0, S1, S2, S3, or S4) - creator.email with the operators equals (=) and AND. Additionally, a global restriction (with no operator) can be used to search across displayName, description, and comments (e.g. \"my search\").",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "orderBy": {
	//       "description": "A comma separated list of fields to order by, followed by `asc` or `desc` postfix. This list is case-insensitive, default sorting order is ascending, redundant space characters are insignificant. Example: `name asc,update_time, create_time desc`",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "pageSize": {
	//       "description": "The maximum number of cases fetched with each request. Defaults to 10.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying the page of results to return. If unspecified, the first page is retrieved.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The fully qualified name of parent resource to list cases under.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+parent}/cases",
	//   "response": {
	//     "$ref": "ListCasesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CasesListCall) Pages(ctx context.Context, f func(*ListCasesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudsupport.cases.patch":

type CasesPatchCall struct {
	s          *Service
	name       string
	case_      *Case
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Patch: Update the specified case. Only a subset of fields
// (display_name, description, time_zone, subscriber_email_addresses,
// related_resources, severity, primary_contact, and labels) can be
// updated.
//
// - name: The resource name for the case.
func (r *CasesService) Patch(name string, case_ *Case) *CasesPatchCall {
	c := &CasesPatchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	c.case_ = case_
	return c
}

// UpdateMask sets the optional parameter "updateMask": A field that
// represents attributes of a case object that should be updated as part
// of this request. Supported values are severity, display_name, and
// subscriber_email_addresses. If no fields are specified, all supported
// fields will be updated. WARNING: If you do not provide a field mask
// then you may accidentally clear some fields. For example, if you
// leave field mask empty and do not provide a value for
// subscriber_email_addresses then subscriber_email_addresses will be
// updated to empty.
func (c *CasesPatchCall) UpdateMask(updateMask string) *CasesPatchCall {
	c.urlParams_.Set("updateMask", updateMask)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesPatchCall) Fields(s ...googleapi.Field) *CasesPatchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesPatchCall) Context(ctx context.Context) *CasesPatchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesPatchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesPatchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.case_)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+name}")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("PATCH", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.patch" call.
// Exactly one of *Case or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Case.ServerResponse.Header or (if a response was returned at all) in
// error.(*googleapi.Error).Header. Use googleapi.IsNotModified to check
// whether the returned error was because http.StatusNotModified was
// returned.
func (c *CasesPatchCall) Do(opts ...googleapi.CallOption) (*Case, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Case{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Update the specified case. Only a subset of fields (display_name, description, time_zone, subscriber_email_addresses, related_resources, severity, primary_contact, and labels) can be updated.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}",
	//   "httpMethod": "PATCH",
	//   "id": "cloudsupport.cases.patch",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name for the case.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     },
	//     "updateMask": {
	//       "description": "A field that represents attributes of a case object that should be updated as part of this request. Supported values are severity, display_name, and subscriber_email_addresses. If no fields are specified, all supported fields will be updated. WARNING: If you do not provide a field mask then you may accidentally clear some fields. For example, if you leave field mask empty and do not provide a value for subscriber_email_addresses then subscriber_email_addresses will be updated to empty.",
	//       "format": "google-fieldmask",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+name}",
	//   "request": {
	//     "$ref": "Case"
	//   },
	//   "response": {
	//     "$ref": "Case"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudsupport.cases.search":

type CasesSearchCall struct {
	s            *Service
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Search: Search cases using the specified query.
func (r *CasesService) Search() *CasesSearchCall {
	c := &CasesSearchCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of cases fetched with each request. The default page size is 10.
func (c *CasesSearchCall) PageSize(pageSize int64) *CasesSearchCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying the page of results to return. If unspecified, the first
// page is retrieved.
func (c *CasesSearchCall) PageToken(pageToken string) *CasesSearchCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Query sets the optional parameter "query": An expression written in
// the Cloud filter language. Filter strings can use the following
// fields: - organization (A name of the form organizations/) - project
// (A name of the form projects/) - customer (A name of the form
// customers/) - state (Accepted values: OPEN or CLOSED) - severity
// (Accepted values: S0, S1, S2, S3, or S4) - creator.email with the
// operators equals (=) and AND. Additionally, a global restriction
// (with no key/operator) can be used to search across display_name,
// description, and comments (e.g. "my search"). One of organization,
// project, or customer field must be specified.
func (c *CasesSearchCall) Query(query string) *CasesSearchCall {
	c.urlParams_.Set("query", query)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesSearchCall) Fields(s ...googleapi.Field) *CasesSearchCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CasesSearchCall) IfNoneMatch(entityTag string) *CasesSearchCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesSearchCall) Context(ctx context.Context) *CasesSearchCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesSearchCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesSearchCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/cases:search")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.search" call.
// Exactly one of *SearchCasesResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *SearchCasesResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CasesSearchCall) Do(opts ...googleapi.CallOption) (*SearchCasesResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &SearchCasesResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Search cases using the specified query.",
	//   "flatPath": "v2beta/cases:search",
	//   "httpMethod": "GET",
	//   "id": "cloudsupport.cases.search",
	//   "parameterOrder": [],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of cases fetched with each request. The default page size is 10.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying the page of results to return. If unspecified, the first page is retrieved.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "query": {
	//       "description": "An expression written in the Cloud filter language. Filter strings can use the following fields: - organization (A name of the form organizations/) - project (A name of the form projects/) - customer (A name of the form customers/) - state (Accepted values: OPEN or CLOSED) - severity (Accepted values: S0, S1, S2, S3, or S4) - creator.email with the operators equals (=) and AND. Additionally, a global restriction (with no key/operator) can be used to search across display_name, description, and comments (e.g. \"my search\"). One of organization, project, or customer field must be specified.",
	//       "location": "query",
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/cases:search",
	//   "response": {
	//     "$ref": "SearchCasesResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CasesSearchCall) Pages(ctx context.Context, f func(*SearchCasesResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudsupport.cases.attachments.list":

type CasesAttachmentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve all attachments associated with a support case.
//
// - parent: The resource name of Case object for which attachments
//   should be listed.
func (r *CasesAttachmentsService) List(parent string) *CasesAttachmentsListCall {
	c := &CasesAttachmentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of attachments fetched with each request. If not provided, the
// default is 10. The maximum page size that will be returned is 100.
func (c *CasesAttachmentsListCall) PageSize(pageSize int64) *CasesAttachmentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying the page of results to return. If unspecified, the first
// page is retrieved.
func (c *CasesAttachmentsListCall) PageToken(pageToken string) *CasesAttachmentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesAttachmentsListCall) Fields(s ...googleapi.Field) *CasesAttachmentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CasesAttachmentsListCall) IfNoneMatch(entityTag string) *CasesAttachmentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesAttachmentsListCall) Context(ctx context.Context) *CasesAttachmentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesAttachmentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesAttachmentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+parent}/attachments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.attachments.list" call.
// Exactly one of *ListAttachmentsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListAttachmentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CasesAttachmentsListCall) Do(opts ...googleapi.CallOption) (*ListAttachmentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListAttachmentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieve all attachments associated with a support case.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}/attachments",
	//   "httpMethod": "GET",
	//   "id": "cloudsupport.cases.attachments.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of attachments fetched with each request. If not provided, the default is 10. The maximum page size that will be returned is 100.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying the page of results to return. If unspecified, the first page is retrieved.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of Case object for which attachments should be listed.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+parent}/attachments",
	//   "response": {
	//     "$ref": "ListAttachmentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CasesAttachmentsListCall) Pages(ctx context.Context, f func(*ListAttachmentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudsupport.cases.comments.create":

type CasesCommentsCreateCall struct {
	s          *Service
	parent     string
	comment    *Comment
	urlParams_ gensupport.URLParams
	ctx_       context.Context
	header_    http.Header
}

// Create: Add a new comment to the specified Case.
//
// - parent: The resource name of Case to which this comment should be
//   added.
func (r *CasesCommentsService) Create(parent string, comment *Comment) *CasesCommentsCreateCall {
	c := &CasesCommentsCreateCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.comment = comment
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesCommentsCreateCall) Fields(s ...googleapi.Field) *CasesCommentsCreateCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesCommentsCreateCall) Context(ctx context.Context) *CasesCommentsCreateCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesCommentsCreateCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesCommentsCreateCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.comment)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+parent}/comments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.comments.create" call.
// Exactly one of *Comment or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Comment.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *CasesCommentsCreateCall) Do(opts ...googleapi.CallOption) (*Comment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Comment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Add a new comment to the specified Case.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}/comments",
	//   "httpMethod": "POST",
	//   "id": "cloudsupport.cases.comments.create",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of Case to which this comment should be added.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+parent}/comments",
	//   "request": {
	//     "$ref": "Comment"
	//   },
	//   "response": {
	//     "$ref": "Comment"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// method id "cloudsupport.cases.comments.list":

type CasesCommentsListCall struct {
	s            *Service
	parent       string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// List: Retrieve all Comments associated with the Case object.
//
// - parent: The resource name of Case object for which comments should
//   be listed.
func (r *CasesCommentsService) List(parent string) *CasesCommentsListCall {
	c := &CasesCommentsListCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	return c
}

// PageSize sets the optional parameter "pageSize": The maximum number
// of comments fetched with each request. Defaults to 10.
func (c *CasesCommentsListCall) PageSize(pageSize int64) *CasesCommentsListCall {
	c.urlParams_.Set("pageSize", fmt.Sprint(pageSize))
	return c
}

// PageToken sets the optional parameter "pageToken": A token
// identifying the page of results to return. If unspecified, the first
// page is retrieved.
func (c *CasesCommentsListCall) PageToken(pageToken string) *CasesCommentsListCall {
	c.urlParams_.Set("pageToken", pageToken)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *CasesCommentsListCall) Fields(s ...googleapi.Field) *CasesCommentsListCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *CasesCommentsListCall) IfNoneMatch(entityTag string) *CasesCommentsListCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
func (c *CasesCommentsListCall) Context(ctx context.Context) *CasesCommentsListCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *CasesCommentsListCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *CasesCommentsListCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+parent}/comments")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.cases.comments.list" call.
// Exactly one of *ListCommentsResponse or error will be non-nil. Any
// non-2xx status code is an error. Response headers are in either
// *ListCommentsResponse.ServerResponse.Header or (if a response was
// returned at all) in error.(*googleapi.Error).Header. Use
// googleapi.IsNotModified to check whether the returned error was
// because http.StatusNotModified was returned.
func (c *CasesCommentsListCall) Do(opts ...googleapi.CallOption) (*ListCommentsResponse, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &ListCommentsResponse{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Retrieve all Comments associated with the Case object.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}/comments",
	//   "httpMethod": "GET",
	//   "id": "cloudsupport.cases.comments.list",
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "pageSize": {
	//       "description": "The maximum number of comments fetched with each request. Defaults to 10.",
	//       "format": "int32",
	//       "location": "query",
	//       "type": "integer"
	//     },
	//     "pageToken": {
	//       "description": "A token identifying the page of results to return. If unspecified, the first page is retrieved.",
	//       "location": "query",
	//       "type": "string"
	//     },
	//     "parent": {
	//       "description": "Required. The resource name of Case object for which comments should be listed.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+parent}/comments",
	//   "response": {
	//     "$ref": "ListCommentsResponse"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ]
	// }

}

// Pages invokes f for each page of results.
// A non-nil error returned from f will halt the iteration.
// The provided context supersedes any context provided to the Context method.
func (c *CasesCommentsListCall) Pages(ctx context.Context, f func(*ListCommentsResponse) error) error {
	c.ctx_ = ctx
	defer c.PageToken(c.urlParams_.Get("pageToken")) // reset paging to original point
	for {
		x, err := c.Do()
		if err != nil {
			return err
		}
		if err := f(x); err != nil {
			return err
		}
		if x.NextPageToken == "" {
			return nil
		}
		c.PageToken(x.NextPageToken)
	}
}

// method id "cloudsupport.media.download":

type MediaDownloadCall struct {
	s            *Service
	name         string
	urlParams_   gensupport.URLParams
	ifNoneMatch_ string
	ctx_         context.Context
	header_      http.Header
}

// Download: Download a file attachment on a case. Note: HTTP requests
// must append "?alt=media" to the URL.
//
// - name: The resource name of the attachment to be downloaded.
func (r *MediaService) Download(name string) *MediaDownloadCall {
	c := &MediaDownloadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.name = name
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MediaDownloadCall) Fields(s ...googleapi.Field) *MediaDownloadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// IfNoneMatch sets the optional parameter which makes the operation
// fail if the object's ETag matches the given value. This is useful for
// getting updates only after the object has changed since the last
// request. Use googleapi.IsNotModified to check whether the response
// error from Do is the result of In-None-Match.
func (c *MediaDownloadCall) IfNoneMatch(entityTag string) *MediaDownloadCall {
	c.ifNoneMatch_ = entityTag
	return c
}

// Context sets the context to be used in this call's Do and Download
// methods. Any pending HTTP request will be aborted if the provided
// context is canceled.
func (c *MediaDownloadCall) Context(ctx context.Context) *MediaDownloadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MediaDownloadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaDownloadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	if c.ifNoneMatch_ != "" {
		reqHeaders.Set("If-None-Match", c.ifNoneMatch_)
	}
	var body io.Reader = nil
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+name}:download")
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("GET", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	googleapi.Expand(req.URL, map[string]string{
		"name": c.name,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Download fetches the API endpoint's "media" value, instead of the normal
// API response value. If the returned error is nil, the Response is guaranteed to
// have a 2xx status code. Callers must close the Response.Body as usual.
func (c *MediaDownloadCall) Download(opts ...googleapi.CallOption) (*http.Response, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("media")
	if err != nil {
		return nil, err
	}
	if err := googleapi.CheckResponse(res); err != nil {
		res.Body.Close()
		return nil, err
	}
	return res, nil
}

// Do executes the "cloudsupport.media.download" call.
// Exactly one of *Media or error will be non-nil. Any non-2xx status
// code is an error. Response headers are in either
// *Media.ServerResponse.Header or (if a response was returned at all)
// in error.(*googleapi.Error).Header. Use googleapi.IsNotModified to
// check whether the returned error was because http.StatusNotModified
// was returned.
func (c *MediaDownloadCall) Do(opts ...googleapi.CallOption) (*Media, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	ret := &Media{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Download a file attachment on a case. Note: HTTP requests must append \"?alt=media\" to the URL.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}/attachments/{attachmentsId}:download",
	//   "httpMethod": "GET",
	//   "id": "cloudsupport.media.download",
	//   "parameterOrder": [
	//     "name"
	//   ],
	//   "parameters": {
	//     "name": {
	//       "description": "The resource name of the attachment to be downloaded.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+/attachments/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+name}:download",
	//   "response": {
	//     "$ref": "Media"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ],
	//   "supportsMediaDownload": true,
	//   "useMediaDownloadService": true
	// }

}

// method id "cloudsupport.media.upload":

type MediaUploadCall struct {
	s                       *Service
	parent                  string
	createattachmentrequest *CreateAttachmentRequest
	urlParams_              gensupport.URLParams
	mediaInfo_              *gensupport.MediaInfo
	ctx_                    context.Context
	header_                 http.Header
}

// Upload: Create a file attachment on a case or Cloud resource.
//
// - parent: The resource name of the case to which attachment should be
//   attached.
func (r *MediaService) Upload(parent string, createattachmentrequest *CreateAttachmentRequest) *MediaUploadCall {
	c := &MediaUploadCall{s: r.s, urlParams_: make(gensupport.URLParams)}
	c.parent = parent
	c.createattachmentrequest = createattachmentrequest
	return c
}

// Media specifies the media to upload in one or more chunks. The chunk
// size may be controlled by supplying a MediaOption generated by
// googleapi.ChunkSize. The chunk size defaults to
// googleapi.DefaultUploadChunkSize.The Content-Type header used in the
// upload request will be determined by sniffing the contents of r,
// unless a MediaOption generated by googleapi.ContentType is
// supplied.
// At most one of Media and ResumableMedia may be set.
func (c *MediaUploadCall) Media(r io.Reader, options ...googleapi.MediaOption) *MediaUploadCall {
	c.mediaInfo_ = gensupport.NewInfoFromMedia(r, options)
	return c
}

// ResumableMedia specifies the media to upload in chunks and can be
// canceled with ctx.
//
// Deprecated: use Media instead.
//
// At most one of Media and ResumableMedia may be set. mediaType
// identifies the MIME media type of the upload, such as "image/png". If
// mediaType is "", it will be auto-detected. The provided ctx will
// supersede any context previously provided to the Context method.
func (c *MediaUploadCall) ResumableMedia(ctx context.Context, r io.ReaderAt, size int64, mediaType string) *MediaUploadCall {
	c.ctx_ = ctx
	c.mediaInfo_ = gensupport.NewInfoFromResumableMedia(r, size, mediaType)
	return c
}

// ProgressUpdater provides a callback function that will be called
// after every chunk. It should be a low-latency function in order to
// not slow down the upload operation. This should only be called when
// using ResumableMedia (as opposed to Media).
func (c *MediaUploadCall) ProgressUpdater(pu googleapi.ProgressUpdater) *MediaUploadCall {
	c.mediaInfo_.SetProgressUpdater(pu)
	return c
}

// Fields allows partial responses to be retrieved. See
// https://developers.google.com/gdata/docs/2.0/basics#PartialResponse
// for more information.
func (c *MediaUploadCall) Fields(s ...googleapi.Field) *MediaUploadCall {
	c.urlParams_.Set("fields", googleapi.CombineFields(s))
	return c
}

// Context sets the context to be used in this call's Do method. Any
// pending HTTP request will be aborted if the provided context is
// canceled.
// This context will supersede any context previously provided to the
// ResumableMedia method.
func (c *MediaUploadCall) Context(ctx context.Context) *MediaUploadCall {
	c.ctx_ = ctx
	return c
}

// Header returns an http.Header that can be modified by the caller to
// add HTTP headers to the request.
func (c *MediaUploadCall) Header() http.Header {
	if c.header_ == nil {
		c.header_ = make(http.Header)
	}
	return c.header_
}

func (c *MediaUploadCall) doRequest(alt string) (*http.Response, error) {
	reqHeaders := make(http.Header)
	reqHeaders.Set("x-goog-api-client", "gl-go/"+gensupport.GoVersion()+" gdcl/20211212")
	for k, v := range c.header_ {
		reqHeaders[k] = v
	}
	reqHeaders.Set("User-Agent", c.s.userAgent())
	var body io.Reader = nil
	body, err := googleapi.WithoutDataWrapper.JSONReader(c.createattachmentrequest)
	if err != nil {
		return nil, err
	}
	reqHeaders.Set("Content-Type", "application/json")
	c.urlParams_.Set("alt", alt)
	c.urlParams_.Set("prettyPrint", "false")
	urls := googleapi.ResolveRelative(c.s.BasePath, "v2beta/{+parent}/attachments")
	if c.mediaInfo_ != nil {
		urls = googleapi.ResolveRelative(c.s.BasePath, "/upload/v2beta/{+parent}/attachments")
		c.urlParams_.Set("uploadType", c.mediaInfo_.UploadType())
	}
	if body == nil {
		body = new(bytes.Buffer)
		reqHeaders.Set("Content-Type", "application/json")
	}
	body, getBody, cleanup := c.mediaInfo_.UploadRequest(reqHeaders, body)
	defer cleanup()
	urls += "?" + c.urlParams_.Encode()
	req, err := http.NewRequest("POST", urls, body)
	if err != nil {
		return nil, err
	}
	req.Header = reqHeaders
	req.GetBody = getBody
	googleapi.Expand(req.URL, map[string]string{
		"parent": c.parent,
	})
	return gensupport.SendRequest(c.ctx_, c.s.client, req)
}

// Do executes the "cloudsupport.media.upload" call.
// Exactly one of *Attachment or error will be non-nil. Any non-2xx
// status code is an error. Response headers are in either
// *Attachment.ServerResponse.Header or (if a response was returned at
// all) in error.(*googleapi.Error).Header. Use googleapi.IsNotModified
// to check whether the returned error was because
// http.StatusNotModified was returned.
func (c *MediaUploadCall) Do(opts ...googleapi.CallOption) (*Attachment, error) {
	gensupport.SetOptions(c.urlParams_, opts...)
	res, err := c.doRequest("json")
	if res != nil && res.StatusCode == http.StatusNotModified {
		if res.Body != nil {
			res.Body.Close()
		}
		return nil, &googleapi.Error{
			Code:   res.StatusCode,
			Header: res.Header,
		}
	}
	if err != nil {
		return nil, err
	}
	defer googleapi.CloseBody(res)
	if err := googleapi.CheckResponse(res); err != nil {
		return nil, err
	}
	rx := c.mediaInfo_.ResumableUpload(res.Header.Get("Location"))
	if rx != nil {
		rx.Client = c.s.client
		rx.UserAgent = c.s.userAgent()
		ctx := c.ctx_
		if ctx == nil {
			ctx = context.TODO()
		}
		res, err = rx.Upload(ctx)
		if err != nil {
			return nil, err
		}
		defer res.Body.Close()
		if err := googleapi.CheckResponse(res); err != nil {
			return nil, err
		}
	}
	ret := &Attachment{
		ServerResponse: googleapi.ServerResponse{
			Header:         res.Header,
			HTTPStatusCode: res.StatusCode,
		},
	}
	target := &ret
	if err := gensupport.DecodeResponse(target, res); err != nil {
		return nil, err
	}
	return ret, nil
	// {
	//   "description": "Create a file attachment on a case or Cloud resource.",
	//   "flatPath": "v2beta/{v2betaId}/{v2betaId1}/cases/{casesId}/attachments",
	//   "httpMethod": "POST",
	//   "id": "cloudsupport.media.upload",
	//   "mediaUpload": {
	//     "accept": [
	//       "*/*"
	//     ],
	//     "protocols": {
	//       "simple": {
	//         "multipart": true,
	//         "path": "/upload/v2beta/{+parent}/attachments"
	//       }
	//     }
	//   },
	//   "parameterOrder": [
	//     "parent"
	//   ],
	//   "parameters": {
	//     "parent": {
	//       "description": "Required. The resource name of the case to which attachment should be attached.",
	//       "location": "path",
	//       "pattern": "^[^/]+/[^/]+/cases/[^/]+$",
	//       "required": true,
	//       "type": "string"
	//     }
	//   },
	//   "path": "v2beta/{+parent}/attachments",
	//   "request": {
	//     "$ref": "CreateAttachmentRequest"
	//   },
	//   "response": {
	//     "$ref": "Attachment"
	//   },
	//   "scopes": [
	//     "https://www.googleapis.com/auth/cloud-platform"
	//   ],
	//   "supportsMediaUpload": true
	// }

}
