// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opCreateByteMatchSet = "CreateByteMatchSet"

// CreateByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateByteMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateByteMatchSet for more information on using the CreateByteMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateByteMatchSetRequest method.
//    req, resp := client.CreateByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateByteMatchSet
func (c *WAF) CreateByteMatchSetRequest(input *CreateByteMatchSetInput) (req *request.Request, output *CreateByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateByteMatchSetInput{}
	}

	output = &CreateByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateByteMatchSet API operation for AWS WAF.
//
// Creates a ByteMatchSet. You then use UpdateByteMatchSet to identify the part
// of a web request that you want AWS WAF to inspect, such as the values of
// the User-Agent header or the query string. For example, you can create a
// ByteMatchSet that matches any requests with User-Agent headers that contain
// the string BadBot. You can then configure AWS WAF to reject those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateByteMatchSet request.
//
// Submit a CreateByteMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request.
//
// Submit an UpdateByteMatchSet request to specify the part of the request that
// you want AWS WAF to inspect (for example, the header or the URI) and the
// value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateByteMatchSet for usage and error information.
//
// Returned Error Types:
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateByteMatchSet
func (c *WAF) CreateByteMatchSet(input *CreateByteMatchSetInput) (*CreateByteMatchSetOutput, error) {
	req, out := c.CreateByteMatchSetRequest(input)
	return out, req.Send()
}

// CreateByteMatchSetWithContext is the same as CreateByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateByteMatchSetWithContext(ctx aws.Context, input *CreateByteMatchSetInput, opts ...request.Option) (*CreateByteMatchSetOutput, error) {
	req, out := c.CreateByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateGeoMatchSet = "CreateGeoMatchSet"

// CreateGeoMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateGeoMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateGeoMatchSet for more information on using the CreateGeoMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateGeoMatchSetRequest method.
//    req, resp := client.CreateGeoMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateGeoMatchSet
func (c *WAF) CreateGeoMatchSetRequest(input *CreateGeoMatchSetInput) (req *request.Request, output *CreateGeoMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateGeoMatchSetInput{}
	}

	output = &CreateGeoMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateGeoMatchSet API operation for AWS WAF.
//
// Creates an GeoMatchSet, which you use to specify which web requests you want
// to allow or block based on the country that the requests originate from.
// For example, if you're receiving a lot of requests from one or more countries
// and you want to block the requests, you can create an GeoMatchSet that contains
// those countries and then configure AWS WAF to block the requests.
//
// To create and configure a GeoMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateGeoMatchSet request.
//
// Submit a CreateGeoMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateGeoMatchSet request.
//
// Submit an UpdateGeoMatchSetSet request to specify the countries that you
// want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateGeoMatchSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateGeoMatchSet
func (c *WAF) CreateGeoMatchSet(input *CreateGeoMatchSetInput) (*CreateGeoMatchSetOutput, error) {
	req, out := c.CreateGeoMatchSetRequest(input)
	return out, req.Send()
}

// CreateGeoMatchSetWithContext is the same as CreateGeoMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateGeoMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateGeoMatchSetWithContext(ctx aws.Context, input *CreateGeoMatchSetInput, opts ...request.Option) (*CreateGeoMatchSetOutput, error) {
	req, out := c.CreateGeoMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIPSet = "CreateIPSet"

// CreateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIPSet for more information on using the CreateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIPSetRequest method.
//    req, resp := client.CreateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateIPSet
func (c *WAF) CreateIPSetRequest(input *CreateIPSetInput) (req *request.Request, output *CreateIPSetOutput) {
	op := &request.Operation{
		Name:       opCreateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIPSetInput{}
	}

	output = &CreateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIPSet API operation for AWS WAF.
//
// Creates an IPSet, which you use to specify which web requests that you want
// to allow or block based on the IP addresses that the requests originate from.
// For example, if you're receiving a lot of requests from one or more individual
// IP addresses or one or more ranges of IP addresses and you want to block
// the requests, you can create an IPSet that contains those IP addresses and
// then configure AWS WAF to block the requests.
//
// To create and configure an IPSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateIPSet request.
//
// Submit a CreateIPSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateIPSet request to specify the IP addresses that you want AWS
// WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateIPSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateIPSet
func (c *WAF) CreateIPSet(input *CreateIPSetInput) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	return out, req.Send()
}

// CreateIPSetWithContext is the same as CreateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateIPSetWithContext(ctx aws.Context, input *CreateIPSetInput, opts ...request.Option) (*CreateIPSetOutput, error) {
	req, out := c.CreateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRateBasedRule = "CreateRateBasedRule"

// CreateRateBasedRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRateBasedRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRateBasedRule for more information on using the CreateRateBasedRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRateBasedRuleRequest method.
//    req, resp := client.CreateRateBasedRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRateBasedRule
func (c *WAF) CreateRateBasedRuleRequest(input *CreateRateBasedRuleInput) (req *request.Request, output *CreateRateBasedRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRateBasedRuleInput{}
	}

	output = &CreateRateBasedRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRateBasedRule API operation for AWS WAF.
//
// Creates a RateBasedRule. The RateBasedRule contains a RateLimit, which specifies
// the maximum number of requests that AWS WAF allows from a specified IP address
// in a five-minute period. The RateBasedRule also contains the IPSet objects,
// ByteMatchSet objects, and other predicates that identify the requests that
// you want to count or block if these requests exceed the RateLimit.
//
// If you add more than one predicate to a RateBasedRule, a request not only
// must exceed the RateLimit, but it also must match all the specifications
// to be counted or blocked. For example, suppose you add the following to a
// RateBasedRule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// Further, you specify a RateLimit of 15,000.
//
// You then add the RateBasedRule to a WebACL and specify that you want to block
// requests that meet the conditions in the rule. For a request to be blocked,
// it must come from the IP address 192.0.2.44 and the User-Agent header in
// the request must contain the value BadBot. Further, requests that match these
// two conditions must be received at a rate of more than 15,000 requests every
// five minutes. If both conditions are met and the rate is exceeded, AWS WAF
// blocks the requests. If the rate drops below 15,000 for a five-minute period,
// AWS WAF no longer blocks the requests.
//
// As a second example, suppose you want to limit requests to a particular page
// on your site. To do this, you could add the following to a RateBasedRule:
//
//    * A ByteMatchSet with FieldToMatch of URI
//
//    * A PositionalConstraint of STARTS_WITH
//
//    * A TargetString of login
//
// Further, you specify a RateLimit of 15,000.
//
// By adding this RateBasedRule to a WebACL, you could limit requests to your
// login page without affecting the rest of your site.
//
// To create and configure a RateBasedRule, perform the following steps:
//
// Create and update the predicates that you want to include in the rule. For
// more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRule request.
//
// Submit a CreateRateBasedRule request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRateBasedRule request to specify the predicates that you
// want to include in the rule.
//
// Create and update a WebACL that contains the RateBasedRule. For more information,
// see CreateWebACL.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateRateBasedRule for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
//   * BadRequestException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRateBasedRule
func (c *WAF) CreateRateBasedRule(input *CreateRateBasedRuleInput) (*CreateRateBasedRuleOutput, error) {
	req, out := c.CreateRateBasedRuleRequest(input)
	return out, req.Send()
}

// CreateRateBasedRuleWithContext is the same as CreateRateBasedRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRateBasedRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateRateBasedRuleWithContext(ctx aws.Context, input *CreateRateBasedRuleInput, opts ...request.Option) (*CreateRateBasedRuleOutput, error) {
	req, out := c.CreateRateBasedRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRegexMatchSet = "CreateRegexMatchSet"

// CreateRegexMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateRegexMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRegexMatchSet for more information on using the CreateRegexMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRegexMatchSetRequest method.
//    req, resp := client.CreateRegexMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRegexMatchSet
func (c *WAF) CreateRegexMatchSetRequest(input *CreateRegexMatchSetInput) (req *request.Request, output *CreateRegexMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateRegexMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRegexMatchSetInput{}
	}

	output = &CreateRegexMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRegexMatchSet API operation for AWS WAF.
//
// Creates a RegexMatchSet. You then use UpdateRegexMatchSet to identify the
// part of a web request that you want AWS WAF to inspect, such as the values
// of the User-Agent header or the query string. For example, you can create
// a RegexMatchSet that contains a RegexMatchTuple that looks for any requests
// with User-Agent headers that match a RegexPatternSet with pattern B[a@]dB[o0]t.
// You can then configure AWS WAF to reject those requests.
//
// To create and configure a RegexMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRegexMatchSet request.
//
// Submit a CreateRegexMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRegexMatchSet request.
//
// Submit an UpdateRegexMatchSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the value, using a RegexPatternSet, that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateRegexMatchSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRegexMatchSet
func (c *WAF) CreateRegexMatchSet(input *CreateRegexMatchSetInput) (*CreateRegexMatchSetOutput, error) {
	req, out := c.CreateRegexMatchSetRequest(input)
	return out, req.Send()
}

// CreateRegexMatchSetWithContext is the same as CreateRegexMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRegexMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateRegexMatchSetWithContext(ctx aws.Context, input *CreateRegexMatchSetInput, opts ...request.Option) (*CreateRegexMatchSetOutput, error) {
	req, out := c.CreateRegexMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRegexPatternSet = "CreateRegexPatternSet"

// CreateRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRegexPatternSet for more information on using the CreateRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRegexPatternSetRequest method.
//    req, resp := client.CreateRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRegexPatternSet
func (c *WAF) CreateRegexPatternSetRequest(input *CreateRegexPatternSetInput) (req *request.Request, output *CreateRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opCreateRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRegexPatternSetInput{}
	}

	output = &CreateRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRegexPatternSet API operation for AWS WAF.
//
// Creates a RegexPatternSet. You then use UpdateRegexPatternSet to specify
// the regular expression (regex) pattern that you want AWS WAF to search for,
// such as B[a@]dB[o0]t. You can then configure AWS WAF to reject those requests.
//
// To create and configure a RegexPatternSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRegexPatternSet request.
//
// Submit a CreateRegexPatternSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRegexPatternSet request.
//
// Submit an UpdateRegexPatternSet request to specify the string that you want
// AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateRegexPatternSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRegexPatternSet
func (c *WAF) CreateRegexPatternSet(input *CreateRegexPatternSetInput) (*CreateRegexPatternSetOutput, error) {
	req, out := c.CreateRegexPatternSetRequest(input)
	return out, req.Send()
}

// CreateRegexPatternSetWithContext is the same as CreateRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateRegexPatternSetWithContext(ctx aws.Context, input *CreateRegexPatternSetInput, opts ...request.Option) (*CreateRegexPatternSetOutput, error) {
	req, out := c.CreateRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRuleRequest method.
//    req, resp := client.CreateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRule
func (c *WAF) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	output = &CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for AWS WAF.
//
// Creates a Rule, which contains the IPSet objects, ByteMatchSet objects, and
// other predicates that identify the requests that you want to block. If you
// add more than one predicate to a Rule, a request must match all of the specifications
// to be allowed or blocked. For example, suppose that you add the following
// to a Rule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// You then add the Rule to a WebACL and specify that you want to blocks requests
// that satisfy the Rule. For a request to be blocked, it must come from the
// IP address 192.0.2.44 and the User-Agent header in the request must contain
// the value BadBot.
//
// To create and configure a Rule, perform the following steps:
//
// Create and update the predicates that you want to include in the Rule. For
// more information, see CreateByteMatchSet, CreateIPSet, and CreateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateRule request.
//
// Submit a CreateRule request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRule request to specify the predicates that you want to include
// in the Rule.
//
// Create and update a WebACL that contains the Rule. For more information,
// see CreateWebACL.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateRule for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
//   * BadRequestException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRule
func (c *WAF) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateRuleWithContext(ctx aws.Context, input *CreateRuleInput, opts ...request.Option) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRuleGroup = "CreateRuleGroup"

// CreateRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRuleGroup for more information on using the CreateRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateRuleGroupRequest method.
//    req, resp := client.CreateRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRuleGroup
func (c *WAF) CreateRuleGroupRequest(input *CreateRuleGroupInput) (req *request.Request, output *CreateRuleGroupOutput) {
	op := &request.Operation{
		Name:       opCreateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleGroupInput{}
	}

	output = &CreateRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRuleGroup API operation for AWS WAF.
//
// Creates a RuleGroup. A rule group is a collection of predefined rules that
// you add to a web ACL. You use UpdateRuleGroup to add rules to the rule group.
//
// Rule groups are subject to the following limits:
//
//    * Three rule groups per account. You can request an increase to this limit
//    by contacting customer support.
//
//    * One rule group per web ACL.
//
//    * Ten rules per rule group.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateRuleGroup for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
//   * BadRequestException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateRuleGroup
func (c *WAF) CreateRuleGroup(input *CreateRuleGroupInput) (*CreateRuleGroupOutput, error) {
	req, out := c.CreateRuleGroupRequest(input)
	return out, req.Send()
}

// CreateRuleGroupWithContext is the same as CreateRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateRuleGroupWithContext(ctx aws.Context, input *CreateRuleGroupInput, opts ...request.Option) (*CreateRuleGroupOutput, error) {
	req, out := c.CreateRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSizeConstraintSet = "CreateSizeConstraintSet"

// CreateSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSizeConstraintSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSizeConstraintSet for more information on using the CreateSizeConstraintSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSizeConstraintSetRequest method.
//    req, resp := client.CreateSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateSizeConstraintSet
func (c *WAF) CreateSizeConstraintSetRequest(input *CreateSizeConstraintSetInput) (req *request.Request, output *CreateSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opCreateSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSizeConstraintSetInput{}
	}

	output = &CreateSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSizeConstraintSet API operation for AWS WAF.
//
// Creates a SizeConstraintSet. You then use UpdateSizeConstraintSet to identify
// the part of a web request that you want AWS WAF to check for length, such
// as the length of the User-Agent header or the length of the query string.
// For example, you can create a SizeConstraintSet that matches any requests
// that have a query string that is longer than 100 bytes. You can then configure
// AWS WAF to reject those requests.
//
// To create and configure a SizeConstraintSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateSizeConstraintSet request.
//
// Submit a CreateSizeConstraintSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSizeConstraintSet request.
//
// Submit an UpdateSizeConstraintSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateSizeConstraintSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateSizeConstraintSet
func (c *WAF) CreateSizeConstraintSet(input *CreateSizeConstraintSetInput) (*CreateSizeConstraintSetOutput, error) {
	req, out := c.CreateSizeConstraintSetRequest(input)
	return out, req.Send()
}

// CreateSizeConstraintSetWithContext is the same as CreateSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateSizeConstraintSetWithContext(ctx aws.Context, input *CreateSizeConstraintSetInput, opts ...request.Option) (*CreateSizeConstraintSetOutput, error) {
	req, out := c.CreateSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSqlInjectionMatchSet = "CreateSqlInjectionMatchSet"

// CreateSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateSqlInjectionMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSqlInjectionMatchSet for more information on using the CreateSqlInjectionMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateSqlInjectionMatchSetRequest method.
//    req, resp := client.CreateSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateSqlInjectionMatchSet
func (c *WAF) CreateSqlInjectionMatchSetRequest(input *CreateSqlInjectionMatchSetInput) (req *request.Request, output *CreateSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateSqlInjectionMatchSetInput{}
	}

	output = &CreateSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSqlInjectionMatchSet API operation for AWS WAF.
//
// Creates a SqlInjectionMatchSet, which you use to allow, block, or count requests
// that contain snippets of SQL code in a specified part of web requests. AWS
// WAF searches for character sequences that are likely to be malicious strings.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateSqlInjectionMatchSet request.
//
// Submit a CreateSqlInjectionMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSqlInjectionMatchSet request.
//
// Submit an UpdateSqlInjectionMatchSet request to specify the parts of web
// requests in which you want to allow, block, or count malicious SQL code.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateSqlInjectionMatchSet for usage and error information.
//
// Returned Error Types:
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateSqlInjectionMatchSet
func (c *WAF) CreateSqlInjectionMatchSet(input *CreateSqlInjectionMatchSetInput) (*CreateSqlInjectionMatchSetOutput, error) {
	req, out := c.CreateSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// CreateSqlInjectionMatchSetWithContext is the same as CreateSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateSqlInjectionMatchSetWithContext(ctx aws.Context, input *CreateSqlInjectionMatchSetInput, opts ...request.Option) (*CreateSqlInjectionMatchSetOutput, error) {
	req, out := c.CreateSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWebACL = "CreateWebACL"

// CreateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the CreateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWebACL for more information on using the CreateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWebACLRequest method.
//    req, resp := client.CreateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateWebACL
func (c *WAF) CreateWebACLRequest(input *CreateWebACLInput) (req *request.Request, output *CreateWebACLOutput) {
	op := &request.Operation{
		Name:       opCreateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWebACLInput{}
	}

	output = &CreateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWebACL API operation for AWS WAF.
//
// Creates a WebACL, which contains the Rules that identify the CloudFront web
// requests that you want to allow, block, or count. AWS WAF evaluates Rules
// in order based on the value of Priority for each Rule.
//
// You also specify a default action, either ALLOW or BLOCK. If a web request
// doesn't match any of the Rules in a WebACL, AWS WAF responds to the request
// with the default action.
//
// To create and configure a WebACL, perform the following steps:
//
// Create and update the ByteMatchSet objects and other predicates that you
// want to include in Rules. For more information, see CreateByteMatchSet, UpdateByteMatchSet,
// CreateIPSet, UpdateIPSet, CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
//
// Create and update the Rules that you want to include in the WebACL. For more
// information, see CreateRule and UpdateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateWebACL request.
//
// Submit a CreateWebACL request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateWebACL request.
//
// Submit an UpdateWebACL request to specify the Rules that you want to include
// in the WebACL, to specify the default action, and to associate the WebACL
// with a CloudFront distribution.
//
// For more information about how to use the AWS WAF API, see the AWS WAF Developer
// Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateWebACL for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
//   * BadRequestException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateWebACL
func (c *WAF) CreateWebACL(input *CreateWebACLInput) (*CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	return out, req.Send()
}

// CreateWebACLWithContext is the same as CreateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateWebACLWithContext(ctx aws.Context, input *CreateWebACLInput, opts ...request.Option) (*CreateWebACLOutput, error) {
	req, out := c.CreateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateXssMatchSet = "CreateXssMatchSet"

// CreateXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the CreateXssMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateXssMatchSet for more information on using the CreateXssMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateXssMatchSetRequest method.
//    req, resp := client.CreateXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateXssMatchSet
func (c *WAF) CreateXssMatchSetRequest(input *CreateXssMatchSetInput) (req *request.Request, output *CreateXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opCreateXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateXssMatchSetInput{}
	}

	output = &CreateXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateXssMatchSet API operation for AWS WAF.
//
// Creates an XssMatchSet, which you use to allow, block, or count requests
// that contain cross-site scripting attacks in the specified part of web requests.
// AWS WAF searches for character sequences that are likely to be malicious
// strings.
//
// To create and configure an XssMatchSet, perform the following steps:
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a CreateXssMatchSet request.
//
// Submit a CreateXssMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateXssMatchSet request.
//
// Submit an UpdateXssMatchSet request to specify the parts of web requests
// in which you want to allow, block, or count cross-site scripting attacks.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation CreateXssMatchSet for usage and error information.
//
// Returned Error Types:
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/CreateXssMatchSet
func (c *WAF) CreateXssMatchSet(input *CreateXssMatchSetInput) (*CreateXssMatchSetOutput, error) {
	req, out := c.CreateXssMatchSetRequest(input)
	return out, req.Send()
}

// CreateXssMatchSetWithContext is the same as CreateXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See CreateXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) CreateXssMatchSetWithContext(ctx aws.Context, input *CreateXssMatchSetInput, opts ...request.Option) (*CreateXssMatchSetOutput, error) {
	req, out := c.CreateXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteByteMatchSet = "DeleteByteMatchSet"

// DeleteByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteByteMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteByteMatchSet for more information on using the DeleteByteMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteByteMatchSetRequest method.
//    req, resp := client.DeleteByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteByteMatchSet
func (c *WAF) DeleteByteMatchSetRequest(input *DeleteByteMatchSetInput) (req *request.Request, output *DeleteByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteByteMatchSetInput{}
	}

	output = &DeleteByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteByteMatchSet API operation for AWS WAF.
//
// Permanently deletes a ByteMatchSet. You can't delete a ByteMatchSet if it's
// still used in any Rules or if it still includes any ByteMatchTuple objects
// (any filters).
//
// If you just want to remove a ByteMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a ByteMatchSet, perform the following steps:
//
// Update the ByteMatchSet to remove filters, if any. For more information,
// see UpdateByteMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteByteMatchSet request.
//
// Submit a DeleteByteMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteByteMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteByteMatchSet
func (c *WAF) DeleteByteMatchSet(input *DeleteByteMatchSetInput) (*DeleteByteMatchSetOutput, error) {
	req, out := c.DeleteByteMatchSetRequest(input)
	return out, req.Send()
}

// DeleteByteMatchSetWithContext is the same as DeleteByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteByteMatchSetWithContext(ctx aws.Context, input *DeleteByteMatchSetInput, opts ...request.Option) (*DeleteByteMatchSetOutput, error) {
	req, out := c.DeleteByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteGeoMatchSet = "DeleteGeoMatchSet"

// DeleteGeoMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteGeoMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteGeoMatchSet for more information on using the DeleteGeoMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteGeoMatchSetRequest method.
//    req, resp := client.DeleteGeoMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteGeoMatchSet
func (c *WAF) DeleteGeoMatchSetRequest(input *DeleteGeoMatchSetInput) (req *request.Request, output *DeleteGeoMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteGeoMatchSetInput{}
	}

	output = &DeleteGeoMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteGeoMatchSet API operation for AWS WAF.
//
// Permanently deletes a GeoMatchSet. You can't delete a GeoMatchSet if it's
// still used in any Rules or if it still includes any countries.
//
// If you just want to remove a GeoMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a GeoMatchSet from AWS WAF, perform the following steps:
//
// Update the GeoMatchSet to remove any countries. For more information, see
// UpdateGeoMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteGeoMatchSet request.
//
// Submit a DeleteGeoMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteGeoMatchSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteGeoMatchSet
func (c *WAF) DeleteGeoMatchSet(input *DeleteGeoMatchSetInput) (*DeleteGeoMatchSetOutput, error) {
	req, out := c.DeleteGeoMatchSetRequest(input)
	return out, req.Send()
}

// DeleteGeoMatchSetWithContext is the same as DeleteGeoMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteGeoMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteGeoMatchSetWithContext(ctx aws.Context, input *DeleteGeoMatchSetInput, opts ...request.Option) (*DeleteGeoMatchSetOutput, error) {
	req, out := c.DeleteGeoMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIPSet = "DeleteIPSet"

// DeleteIPSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIPSet for more information on using the DeleteIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIPSetRequest method.
//    req, resp := client.DeleteIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteIPSet
func (c *WAF) DeleteIPSetRequest(input *DeleteIPSetInput) (req *request.Request, output *DeleteIPSetOutput) {
	op := &request.Operation{
		Name:       opDeleteIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIPSetInput{}
	}

	output = &DeleteIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteIPSet API operation for AWS WAF.
//
// Permanently deletes an IPSet. You can't delete an IPSet if it's still used
// in any Rules or if it still includes any IP addresses.
//
// If you just want to remove an IPSet from a Rule, use UpdateRule.
//
// To permanently delete an IPSet from AWS WAF, perform the following steps:
//
// Update the IPSet to remove IP address ranges, if any. For more information,
// see UpdateIPSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteIPSet request.
//
// Submit a DeleteIPSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteIPSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteIPSet
func (c *WAF) DeleteIPSet(input *DeleteIPSetInput) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	return out, req.Send()
}

// DeleteIPSetWithContext is the same as DeleteIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteIPSetWithContext(ctx aws.Context, input *DeleteIPSetInput, opts ...request.Option) (*DeleteIPSetOutput, error) {
	req, out := c.DeleteIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteLoggingConfiguration = "DeleteLoggingConfiguration"

// DeleteLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteLoggingConfiguration for more information on using the DeleteLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteLoggingConfigurationRequest method.
//    req, resp := client.DeleteLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteLoggingConfiguration
func (c *WAF) DeleteLoggingConfigurationRequest(input *DeleteLoggingConfigurationInput) (req *request.Request, output *DeleteLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opDeleteLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteLoggingConfigurationInput{}
	}

	output = &DeleteLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteLoggingConfiguration API operation for AWS WAF.
//
// Permanently deletes the LoggingConfiguration from the specified web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteLoggingConfiguration
func (c *WAF) DeleteLoggingConfiguration(input *DeleteLoggingConfigurationInput) (*DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	return out, req.Send()
}

// DeleteLoggingConfigurationWithContext is the same as DeleteLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteLoggingConfigurationWithContext(ctx aws.Context, input *DeleteLoggingConfigurationInput, opts ...request.Option) (*DeleteLoggingConfigurationOutput, error) {
	req, out := c.DeleteLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeletePermissionPolicy = "DeletePermissionPolicy"

// DeletePermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the DeletePermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeletePermissionPolicy for more information on using the DeletePermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeletePermissionPolicyRequest method.
//    req, resp := client.DeletePermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeletePermissionPolicy
func (c *WAF) DeletePermissionPolicyRequest(input *DeletePermissionPolicyInput) (req *request.Request, output *DeletePermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opDeletePermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeletePermissionPolicyInput{}
	}

	output = &DeletePermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeletePermissionPolicy API operation for AWS WAF.
//
// Permanently deletes an IAM policy from the specified RuleGroup.
//
// The user making the request must be the owner of the RuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeletePermissionPolicy for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeletePermissionPolicy
func (c *WAF) DeletePermissionPolicy(input *DeletePermissionPolicyInput) (*DeletePermissionPolicyOutput, error) {
	req, out := c.DeletePermissionPolicyRequest(input)
	return out, req.Send()
}

// DeletePermissionPolicyWithContext is the same as DeletePermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See DeletePermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeletePermissionPolicyWithContext(ctx aws.Context, input *DeletePermissionPolicyInput, opts ...request.Option) (*DeletePermissionPolicyOutput, error) {
	req, out := c.DeletePermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRateBasedRule = "DeleteRateBasedRule"

// DeleteRateBasedRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRateBasedRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRateBasedRule for more information on using the DeleteRateBasedRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRateBasedRuleRequest method.
//    req, resp := client.DeleteRateBasedRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRateBasedRule
func (c *WAF) DeleteRateBasedRuleRequest(input *DeleteRateBasedRuleInput) (req *request.Request, output *DeleteRateBasedRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRateBasedRuleInput{}
	}

	output = &DeleteRateBasedRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRateBasedRule API operation for AWS WAF.
//
// Permanently deletes a RateBasedRule. You can't delete a rule if it's still
// used in any WebACL objects or if it still includes any predicates, such as
// ByteMatchSet objects.
//
// If you just want to remove a rule from a WebACL, use UpdateWebACL.
//
// To permanently delete a RateBasedRule from AWS WAF, perform the following
// steps:
//
// Update the RateBasedRule to remove predicates, if any. For more information,
// see UpdateRateBasedRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRateBasedRule request.
//
// Submit a DeleteRateBasedRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteRateBasedRule for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRateBasedRule
func (c *WAF) DeleteRateBasedRule(input *DeleteRateBasedRuleInput) (*DeleteRateBasedRuleOutput, error) {
	req, out := c.DeleteRateBasedRuleRequest(input)
	return out, req.Send()
}

// DeleteRateBasedRuleWithContext is the same as DeleteRateBasedRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRateBasedRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteRateBasedRuleWithContext(ctx aws.Context, input *DeleteRateBasedRuleInput, opts ...request.Option) (*DeleteRateBasedRuleOutput, error) {
	req, out := c.DeleteRateBasedRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegexMatchSet = "DeleteRegexMatchSet"

// DeleteRegexMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegexMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegexMatchSet for more information on using the DeleteRegexMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegexMatchSetRequest method.
//    req, resp := client.DeleteRegexMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRegexMatchSet
func (c *WAF) DeleteRegexMatchSetRequest(input *DeleteRegexMatchSetInput) (req *request.Request, output *DeleteRegexMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteRegexMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRegexMatchSetInput{}
	}

	output = &DeleteRegexMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRegexMatchSet API operation for AWS WAF.
//
// Permanently deletes a RegexMatchSet. You can't delete a RegexMatchSet if
// it's still used in any Rules or if it still includes any RegexMatchTuples
// objects (any filters).
//
// If you just want to remove a RegexMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a RegexMatchSet, perform the following steps:
//
// Update the RegexMatchSet to remove filters, if any. For more information,
// see UpdateRegexMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRegexMatchSet request.
//
// Submit a DeleteRegexMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteRegexMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRegexMatchSet
func (c *WAF) DeleteRegexMatchSet(input *DeleteRegexMatchSetInput) (*DeleteRegexMatchSetOutput, error) {
	req, out := c.DeleteRegexMatchSetRequest(input)
	return out, req.Send()
}

// DeleteRegexMatchSetWithContext is the same as DeleteRegexMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegexMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteRegexMatchSetWithContext(ctx aws.Context, input *DeleteRegexMatchSetInput, opts ...request.Option) (*DeleteRegexMatchSetOutput, error) {
	req, out := c.DeleteRegexMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRegexPatternSet = "DeleteRegexPatternSet"

// DeleteRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRegexPatternSet for more information on using the DeleteRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRegexPatternSetRequest method.
//    req, resp := client.DeleteRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRegexPatternSet
func (c *WAF) DeleteRegexPatternSetRequest(input *DeleteRegexPatternSetInput) (req *request.Request, output *DeleteRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opDeleteRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRegexPatternSetInput{}
	}

	output = &DeleteRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRegexPatternSet API operation for AWS WAF.
//
// Permanently deletes a RegexPatternSet. You can't delete a RegexPatternSet
// if it's still used in any RegexMatchSet or if the RegexPatternSet is not
// empty.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteRegexPatternSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRegexPatternSet
func (c *WAF) DeleteRegexPatternSet(input *DeleteRegexPatternSetInput) (*DeleteRegexPatternSetOutput, error) {
	req, out := c.DeleteRegexPatternSetRequest(input)
	return out, req.Send()
}

// DeleteRegexPatternSetWithContext is the same as DeleteRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteRegexPatternSetWithContext(ctx aws.Context, input *DeleteRegexPatternSetInput, opts ...request.Option) (*DeleteRegexPatternSetOutput, error) {
	req, out := c.DeleteRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRuleRequest method.
//    req, resp := client.DeleteRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRule
func (c *WAF) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRule API operation for AWS WAF.
//
// Permanently deletes a Rule. You can't delete a Rule if it's still used in
// any WebACL objects or if it still includes any predicates, such as ByteMatchSet
// objects.
//
// If you just want to remove a Rule from a WebACL, use UpdateWebACL.
//
// To permanently delete a Rule from AWS WAF, perform the following steps:
//
// Update the Rule to remove predicates, if any. For more information, see UpdateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRule request.
//
// Submit a DeleteRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteRule for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRule
func (c *WAF) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRuleGroup = "DeleteRuleGroup"

// DeleteRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRuleGroup for more information on using the DeleteRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteRuleGroupRequest method.
//    req, resp := client.DeleteRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRuleGroup
func (c *WAF) DeleteRuleGroupRequest(input *DeleteRuleGroupInput) (req *request.Request, output *DeleteRuleGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRuleGroupInput{}
	}

	output = &DeleteRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteRuleGroup API operation for AWS WAF.
//
// Permanently deletes a RuleGroup. You can't delete a RuleGroup if it's still
// used in any WebACL objects or if it still includes any rules.
//
// If you just want to remove a RuleGroup from a WebACL, use UpdateWebACL.
//
// To permanently delete a RuleGroup from AWS WAF, perform the following steps:
//
// Update the RuleGroup to remove rules, if any. For more information, see UpdateRuleGroup.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteRuleGroup request.
//
// Submit a DeleteRuleGroup request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteRuleGroup for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteRuleGroup
func (c *WAF) DeleteRuleGroup(input *DeleteRuleGroupInput) (*DeleteRuleGroupOutput, error) {
	req, out := c.DeleteRuleGroupRequest(input)
	return out, req.Send()
}

// DeleteRuleGroupWithContext is the same as DeleteRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteRuleGroupWithContext(ctx aws.Context, input *DeleteRuleGroupInput, opts ...request.Option) (*DeleteRuleGroupOutput, error) {
	req, out := c.DeleteRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSizeConstraintSet = "DeleteSizeConstraintSet"

// DeleteSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSizeConstraintSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSizeConstraintSet for more information on using the DeleteSizeConstraintSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSizeConstraintSetRequest method.
//    req, resp := client.DeleteSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteSizeConstraintSet
func (c *WAF) DeleteSizeConstraintSetRequest(input *DeleteSizeConstraintSetInput) (req *request.Request, output *DeleteSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opDeleteSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSizeConstraintSetInput{}
	}

	output = &DeleteSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSizeConstraintSet API operation for AWS WAF.
//
// Permanently deletes a SizeConstraintSet. You can't delete a SizeConstraintSet
// if it's still used in any Rules or if it still includes any SizeConstraint
// objects (any filters).
//
// If you just want to remove a SizeConstraintSet from a Rule, use UpdateRule.
//
// To permanently delete a SizeConstraintSet, perform the following steps:
//
// Update the SizeConstraintSet to remove filters, if any. For more information,
// see UpdateSizeConstraintSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteSizeConstraintSet request.
//
// Submit a DeleteSizeConstraintSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteSizeConstraintSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteSizeConstraintSet
func (c *WAF) DeleteSizeConstraintSet(input *DeleteSizeConstraintSetInput) (*DeleteSizeConstraintSetOutput, error) {
	req, out := c.DeleteSizeConstraintSetRequest(input)
	return out, req.Send()
}

// DeleteSizeConstraintSetWithContext is the same as DeleteSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteSizeConstraintSetWithContext(ctx aws.Context, input *DeleteSizeConstraintSetInput, opts ...request.Option) (*DeleteSizeConstraintSetOutput, error) {
	req, out := c.DeleteSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSqlInjectionMatchSet = "DeleteSqlInjectionMatchSet"

// DeleteSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSqlInjectionMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSqlInjectionMatchSet for more information on using the DeleteSqlInjectionMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteSqlInjectionMatchSetRequest method.
//    req, resp := client.DeleteSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteSqlInjectionMatchSet
func (c *WAF) DeleteSqlInjectionMatchSetRequest(input *DeleteSqlInjectionMatchSetInput) (req *request.Request, output *DeleteSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteSqlInjectionMatchSetInput{}
	}

	output = &DeleteSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteSqlInjectionMatchSet API operation for AWS WAF.
//
// Permanently deletes a SqlInjectionMatchSet. You can't delete a SqlInjectionMatchSet
// if it's still used in any Rules or if it still contains any SqlInjectionMatchTuple
// objects.
//
// If you just want to remove a SqlInjectionMatchSet from a Rule, use UpdateRule.
//
// To permanently delete a SqlInjectionMatchSet from AWS WAF, perform the following
// steps:
//
// Update the SqlInjectionMatchSet to remove filters, if any. For more information,
// see UpdateSqlInjectionMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteSqlInjectionMatchSet request.
//
// Submit a DeleteSqlInjectionMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteSqlInjectionMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteSqlInjectionMatchSet
func (c *WAF) DeleteSqlInjectionMatchSet(input *DeleteSqlInjectionMatchSetInput) (*DeleteSqlInjectionMatchSetOutput, error) {
	req, out := c.DeleteSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// DeleteSqlInjectionMatchSetWithContext is the same as DeleteSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteSqlInjectionMatchSetWithContext(ctx aws.Context, input *DeleteSqlInjectionMatchSetInput, opts ...request.Option) (*DeleteSqlInjectionMatchSetOutput, error) {
	req, out := c.DeleteSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWebACL = "DeleteWebACL"

// DeleteWebACLRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWebACL for more information on using the DeleteWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWebACLRequest method.
//    req, resp := client.DeleteWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteWebACL
func (c *WAF) DeleteWebACLRequest(input *DeleteWebACLInput) (req *request.Request, output *DeleteWebACLOutput) {
	op := &request.Operation{
		Name:       opDeleteWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWebACLInput{}
	}

	output = &DeleteWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteWebACL API operation for AWS WAF.
//
// Permanently deletes a WebACL. You can't delete a WebACL if it still contains
// any Rules.
//
// To delete a WebACL, perform the following steps:
//
// Update the WebACL to remove Rules, if any. For more information, see UpdateWebACL.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteWebACL request.
//
// Submit a DeleteWebACL request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteWebACL for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteWebACL
func (c *WAF) DeleteWebACL(input *DeleteWebACLInput) (*DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	return out, req.Send()
}

// DeleteWebACLWithContext is the same as DeleteWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteWebACLWithContext(ctx aws.Context, input *DeleteWebACLInput, opts ...request.Option) (*DeleteWebACLOutput, error) {
	req, out := c.DeleteWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteXssMatchSet = "DeleteXssMatchSet"

// DeleteXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the DeleteXssMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteXssMatchSet for more information on using the DeleteXssMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteXssMatchSetRequest method.
//    req, resp := client.DeleteXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteXssMatchSet
func (c *WAF) DeleteXssMatchSetRequest(input *DeleteXssMatchSetInput) (req *request.Request, output *DeleteXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opDeleteXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteXssMatchSetInput{}
	}

	output = &DeleteXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteXssMatchSet API operation for AWS WAF.
//
// Permanently deletes an XssMatchSet. You can't delete an XssMatchSet if it's
// still used in any Rules or if it still contains any XssMatchTuple objects.
//
// If you just want to remove an XssMatchSet from a Rule, use UpdateRule.
//
// To permanently delete an XssMatchSet from AWS WAF, perform the following
// steps:
//
// Update the XssMatchSet to remove filters, if any. For more information, see
// UpdateXssMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of a DeleteXssMatchSet request.
//
// Submit a DeleteXssMatchSet request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation DeleteXssMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * NonEmptyEntityException
//   The operation failed because you tried to delete an object that isn't empty.
//   For example:
//
//      * You tried to delete a WebACL that still contains one or more Rule objects.
//
//      * You tried to delete a Rule that still contains one or more ByteMatchSet
//      objects or other predicates.
//
//      * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//      objects.
//
//      * You tried to delete an IPSet that references one or more IP addresses.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/DeleteXssMatchSet
func (c *WAF) DeleteXssMatchSet(input *DeleteXssMatchSetInput) (*DeleteXssMatchSetOutput, error) {
	req, out := c.DeleteXssMatchSetRequest(input)
	return out, req.Send()
}

// DeleteXssMatchSetWithContext is the same as DeleteXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) DeleteXssMatchSetWithContext(ctx aws.Context, input *DeleteXssMatchSetInput, opts ...request.Option) (*DeleteXssMatchSetOutput, error) {
	req, out := c.DeleteXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetByteMatchSet = "GetByteMatchSet"

// GetByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetByteMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetByteMatchSet for more information on using the GetByteMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetByteMatchSetRequest method.
//    req, resp := client.GetByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetByteMatchSet
func (c *WAF) GetByteMatchSetRequest(input *GetByteMatchSetInput) (req *request.Request, output *GetByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetByteMatchSetInput{}
	}

	output = &GetByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetByteMatchSet API operation for AWS WAF.
//
// Returns the ByteMatchSet specified by ByteMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetByteMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetByteMatchSet
func (c *WAF) GetByteMatchSet(input *GetByteMatchSetInput) (*GetByteMatchSetOutput, error) {
	req, out := c.GetByteMatchSetRequest(input)
	return out, req.Send()
}

// GetByteMatchSetWithContext is the same as GetByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetByteMatchSetWithContext(ctx aws.Context, input *GetByteMatchSetInput, opts ...request.Option) (*GetByteMatchSetOutput, error) {
	req, out := c.GetByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChangeToken = "GetChangeToken"

// GetChangeTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetChangeToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChangeToken for more information on using the GetChangeToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChangeTokenRequest method.
//    req, resp := client.GetChangeTokenRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetChangeToken
func (c *WAF) GetChangeTokenRequest(input *GetChangeTokenInput) (req *request.Request, output *GetChangeTokenOutput) {
	op := &request.Operation{
		Name:       opGetChangeToken,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetChangeTokenInput{}
	}

	output = &GetChangeTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChangeToken API operation for AWS WAF.
//
// When you want to create, update, or delete AWS WAF objects, get a change
// token and include the change token in the create, update, or delete request.
// Change tokens ensure that your application doesn't submit conflicting requests
// to AWS WAF.
//
// Each create, update, or delete request must use a unique change token. If
// your application submits a GetChangeToken request and then submits a second
// GetChangeToken request before submitting a create, update, or delete request,
// the second GetChangeToken request returns the same value as the first GetChangeToken
// request.
//
// When you use a change token in a create, update, or delete request, the status
// of the change token changes to PENDING, which indicates that AWS WAF is propagating
// the change to all AWS WAF servers. Use GetChangeTokenStatus to determine
// the status of your change token.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetChangeToken for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetChangeToken
func (c *WAF) GetChangeToken(input *GetChangeTokenInput) (*GetChangeTokenOutput, error) {
	req, out := c.GetChangeTokenRequest(input)
	return out, req.Send()
}

// GetChangeTokenWithContext is the same as GetChangeToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetChangeToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetChangeTokenWithContext(ctx aws.Context, input *GetChangeTokenInput, opts ...request.Option) (*GetChangeTokenOutput, error) {
	req, out := c.GetChangeTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetChangeTokenStatus = "GetChangeTokenStatus"

// GetChangeTokenStatusRequest generates a "aws/request.Request" representing the
// client's request for the GetChangeTokenStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetChangeTokenStatus for more information on using the GetChangeTokenStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetChangeTokenStatusRequest method.
//    req, resp := client.GetChangeTokenStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetChangeTokenStatus
func (c *WAF) GetChangeTokenStatusRequest(input *GetChangeTokenStatusInput) (req *request.Request, output *GetChangeTokenStatusOutput) {
	op := &request.Operation{
		Name:       opGetChangeTokenStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetChangeTokenStatusInput{}
	}

	output = &GetChangeTokenStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetChangeTokenStatus API operation for AWS WAF.
//
// Returns the status of a ChangeToken that you got by calling GetChangeToken.
// ChangeTokenStatus is one of the following values:
//
//    * PROVISIONED: You requested the change token by calling GetChangeToken,
//    but you haven't used it yet in a call to create, update, or delete an
//    AWS WAF object.
//
//    * PENDING: AWS WAF is propagating the create, update, or delete request
//    to all AWS WAF servers.
//
//    * INSYNC: Propagation is complete.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetChangeTokenStatus for usage and error information.
//
// Returned Error Types:
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetChangeTokenStatus
func (c *WAF) GetChangeTokenStatus(input *GetChangeTokenStatusInput) (*GetChangeTokenStatusOutput, error) {
	req, out := c.GetChangeTokenStatusRequest(input)
	return out, req.Send()
}

// GetChangeTokenStatusWithContext is the same as GetChangeTokenStatus with the addition of
// the ability to pass a context and additional request options.
//
// See GetChangeTokenStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetChangeTokenStatusWithContext(ctx aws.Context, input *GetChangeTokenStatusInput, opts ...request.Option) (*GetChangeTokenStatusOutput, error) {
	req, out := c.GetChangeTokenStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetGeoMatchSet = "GetGeoMatchSet"

// GetGeoMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetGeoMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetGeoMatchSet for more information on using the GetGeoMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetGeoMatchSetRequest method.
//    req, resp := client.GetGeoMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetGeoMatchSet
func (c *WAF) GetGeoMatchSetRequest(input *GetGeoMatchSetInput) (req *request.Request, output *GetGeoMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetGeoMatchSetInput{}
	}

	output = &GetGeoMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetGeoMatchSet API operation for AWS WAF.
//
// Returns the GeoMatchSet that is specified by GeoMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetGeoMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetGeoMatchSet
func (c *WAF) GetGeoMatchSet(input *GetGeoMatchSetInput) (*GetGeoMatchSetOutput, error) {
	req, out := c.GetGeoMatchSetRequest(input)
	return out, req.Send()
}

// GetGeoMatchSetWithContext is the same as GetGeoMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetGeoMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetGeoMatchSetWithContext(ctx aws.Context, input *GetGeoMatchSetInput, opts ...request.Option) (*GetGeoMatchSetOutput, error) {
	req, out := c.GetGeoMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetIPSet = "GetIPSet"

// GetIPSetRequest generates a "aws/request.Request" representing the
// client's request for the GetIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetIPSet for more information on using the GetIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetIPSetRequest method.
//    req, resp := client.GetIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetIPSet
func (c *WAF) GetIPSetRequest(input *GetIPSetInput) (req *request.Request, output *GetIPSetOutput) {
	op := &request.Operation{
		Name:       opGetIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIPSetInput{}
	}

	output = &GetIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetIPSet API operation for AWS WAF.
//
// Returns the IPSet that is specified by IPSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetIPSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetIPSet
func (c *WAF) GetIPSet(input *GetIPSetInput) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	return out, req.Send()
}

// GetIPSetWithContext is the same as GetIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetIPSetWithContext(ctx aws.Context, input *GetIPSetInput, opts ...request.Option) (*GetIPSetOutput, error) {
	req, out := c.GetIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetLoggingConfiguration = "GetLoggingConfiguration"

// GetLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the GetLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetLoggingConfiguration for more information on using the GetLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetLoggingConfigurationRequest method.
//    req, resp := client.GetLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetLoggingConfiguration
func (c *WAF) GetLoggingConfigurationRequest(input *GetLoggingConfigurationInput) (req *request.Request, output *GetLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opGetLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetLoggingConfigurationInput{}
	}

	output = &GetLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetLoggingConfiguration API operation for AWS WAF.
//
// Returns the LoggingConfiguration for the specified web ACL.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetLoggingConfiguration
func (c *WAF) GetLoggingConfiguration(input *GetLoggingConfigurationInput) (*GetLoggingConfigurationOutput, error) {
	req, out := c.GetLoggingConfigurationRequest(input)
	return out, req.Send()
}

// GetLoggingConfigurationWithContext is the same as GetLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See GetLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetLoggingConfigurationWithContext(ctx aws.Context, input *GetLoggingConfigurationInput, opts ...request.Option) (*GetLoggingConfigurationOutput, error) {
	req, out := c.GetLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPermissionPolicy = "GetPermissionPolicy"

// GetPermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the GetPermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetPermissionPolicy for more information on using the GetPermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetPermissionPolicyRequest method.
//    req, resp := client.GetPermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetPermissionPolicy
func (c *WAF) GetPermissionPolicyRequest(input *GetPermissionPolicyInput) (req *request.Request, output *GetPermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opGetPermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPermissionPolicyInput{}
	}

	output = &GetPermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetPermissionPolicy API operation for AWS WAF.
//
// Returns the IAM policy attached to the RuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetPermissionPolicy for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetPermissionPolicy
func (c *WAF) GetPermissionPolicy(input *GetPermissionPolicyInput) (*GetPermissionPolicyOutput, error) {
	req, out := c.GetPermissionPolicyRequest(input)
	return out, req.Send()
}

// GetPermissionPolicyWithContext is the same as GetPermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See GetPermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetPermissionPolicyWithContext(ctx aws.Context, input *GetPermissionPolicyInput, opts ...request.Option) (*GetPermissionPolicyOutput, error) {
	req, out := c.GetPermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRateBasedRule = "GetRateBasedRule"

// GetRateBasedRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetRateBasedRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRateBasedRule for more information on using the GetRateBasedRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRateBasedRuleRequest method.
//    req, resp := client.GetRateBasedRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRateBasedRule
func (c *WAF) GetRateBasedRuleRequest(input *GetRateBasedRuleInput) (req *request.Request, output *GetRateBasedRuleOutput) {
	op := &request.Operation{
		Name:       opGetRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRateBasedRuleInput{}
	}

	output = &GetRateBasedRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRateBasedRule API operation for AWS WAF.
//
// Returns the RateBasedRule that is specified by the RuleId that you included
// in the GetRateBasedRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetRateBasedRule for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRateBasedRule
func (c *WAF) GetRateBasedRule(input *GetRateBasedRuleInput) (*GetRateBasedRuleOutput, error) {
	req, out := c.GetRateBasedRuleRequest(input)
	return out, req.Send()
}

// GetRateBasedRuleWithContext is the same as GetRateBasedRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetRateBasedRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetRateBasedRuleWithContext(ctx aws.Context, input *GetRateBasedRuleInput, opts ...request.Option) (*GetRateBasedRuleOutput, error) {
	req, out := c.GetRateBasedRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRateBasedRuleManagedKeys = "GetRateBasedRuleManagedKeys"

// GetRateBasedRuleManagedKeysRequest generates a "aws/request.Request" representing the
// client's request for the GetRateBasedRuleManagedKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRateBasedRuleManagedKeys for more information on using the GetRateBasedRuleManagedKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRateBasedRuleManagedKeysRequest method.
//    req, resp := client.GetRateBasedRuleManagedKeysRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRateBasedRuleManagedKeys
func (c *WAF) GetRateBasedRuleManagedKeysRequest(input *GetRateBasedRuleManagedKeysInput) (req *request.Request, output *GetRateBasedRuleManagedKeysOutput) {
	op := &request.Operation{
		Name:       opGetRateBasedRuleManagedKeys,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRateBasedRuleManagedKeysInput{}
	}

	output = &GetRateBasedRuleManagedKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRateBasedRuleManagedKeys API operation for AWS WAF.
//
// Returns an array of IP addresses currently being blocked by the RateBasedRule
// that is specified by the RuleId. The maximum number of managed keys that
// will be blocked is 10,000. If more than 10,000 addresses exceed the rate
// limit, the 10,000 addresses with the highest rates will be blocked.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetRateBasedRuleManagedKeys for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRateBasedRuleManagedKeys
func (c *WAF) GetRateBasedRuleManagedKeys(input *GetRateBasedRuleManagedKeysInput) (*GetRateBasedRuleManagedKeysOutput, error) {
	req, out := c.GetRateBasedRuleManagedKeysRequest(input)
	return out, req.Send()
}

// GetRateBasedRuleManagedKeysWithContext is the same as GetRateBasedRuleManagedKeys with the addition of
// the ability to pass a context and additional request options.
//
// See GetRateBasedRuleManagedKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetRateBasedRuleManagedKeysWithContext(ctx aws.Context, input *GetRateBasedRuleManagedKeysInput, opts ...request.Option) (*GetRateBasedRuleManagedKeysOutput, error) {
	req, out := c.GetRateBasedRuleManagedKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegexMatchSet = "GetRegexMatchSet"

// GetRegexMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetRegexMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegexMatchSet for more information on using the GetRegexMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegexMatchSetRequest method.
//    req, resp := client.GetRegexMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRegexMatchSet
func (c *WAF) GetRegexMatchSetRequest(input *GetRegexMatchSetInput) (req *request.Request, output *GetRegexMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetRegexMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegexMatchSetInput{}
	}

	output = &GetRegexMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegexMatchSet API operation for AWS WAF.
//
// Returns the RegexMatchSet specified by RegexMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetRegexMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRegexMatchSet
func (c *WAF) GetRegexMatchSet(input *GetRegexMatchSetInput) (*GetRegexMatchSetOutput, error) {
	req, out := c.GetRegexMatchSetRequest(input)
	return out, req.Send()
}

// GetRegexMatchSetWithContext is the same as GetRegexMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegexMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetRegexMatchSetWithContext(ctx aws.Context, input *GetRegexMatchSetInput, opts ...request.Option) (*GetRegexMatchSetOutput, error) {
	req, out := c.GetRegexMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRegexPatternSet = "GetRegexPatternSet"

// GetRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the GetRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRegexPatternSet for more information on using the GetRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRegexPatternSetRequest method.
//    req, resp := client.GetRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRegexPatternSet
func (c *WAF) GetRegexPatternSetRequest(input *GetRegexPatternSetInput) (req *request.Request, output *GetRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opGetRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRegexPatternSetInput{}
	}

	output = &GetRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRegexPatternSet API operation for AWS WAF.
//
// Returns the RegexPatternSet specified by RegexPatternSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetRegexPatternSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRegexPatternSet
func (c *WAF) GetRegexPatternSet(input *GetRegexPatternSetInput) (*GetRegexPatternSetOutput, error) {
	req, out := c.GetRegexPatternSetRequest(input)
	return out, req.Send()
}

// GetRegexPatternSetWithContext is the same as GetRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetRegexPatternSetWithContext(ctx aws.Context, input *GetRegexPatternSetInput, opts ...request.Option) (*GetRegexPatternSetOutput, error) {
	req, out := c.GetRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRule = "GetRule"

// GetRuleRequest generates a "aws/request.Request" representing the
// client's request for the GetRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRule for more information on using the GetRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRuleRequest method.
//    req, resp := client.GetRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRule
func (c *WAF) GetRuleRequest(input *GetRuleInput) (req *request.Request, output *GetRuleOutput) {
	op := &request.Operation{
		Name:       opGetRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRuleInput{}
	}

	output = &GetRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRule API operation for AWS WAF.
//
// Returns the Rule that is specified by the RuleId that you included in the
// GetRule request.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetRule for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRule
func (c *WAF) GetRule(input *GetRuleInput) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	return out, req.Send()
}

// GetRuleWithContext is the same as GetRule with the addition of
// the ability to pass a context and additional request options.
//
// See GetRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetRuleWithContext(ctx aws.Context, input *GetRuleInput, opts ...request.Option) (*GetRuleOutput, error) {
	req, out := c.GetRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetRuleGroup = "GetRuleGroup"

// GetRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetRuleGroup for more information on using the GetRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetRuleGroupRequest method.
//    req, resp := client.GetRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRuleGroup
func (c *WAF) GetRuleGroupRequest(input *GetRuleGroupInput) (req *request.Request, output *GetRuleGroupOutput) {
	op := &request.Operation{
		Name:       opGetRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetRuleGroupInput{}
	}

	output = &GetRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetRuleGroup API operation for AWS WAF.
//
// Returns the RuleGroup that is specified by the RuleGroupId that you included
// in the GetRuleGroup request.
//
// To view the rules in a rule group, use ListActivatedRulesInRuleGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetRuleGroup for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetRuleGroup
func (c *WAF) GetRuleGroup(input *GetRuleGroupInput) (*GetRuleGroupOutput, error) {
	req, out := c.GetRuleGroupRequest(input)
	return out, req.Send()
}

// GetRuleGroupWithContext is the same as GetRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetRuleGroupWithContext(ctx aws.Context, input *GetRuleGroupInput, opts ...request.Option) (*GetRuleGroupOutput, error) {
	req, out := c.GetRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSampledRequests = "GetSampledRequests"

// GetSampledRequestsRequest generates a "aws/request.Request" representing the
// client's request for the GetSampledRequests operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSampledRequests for more information on using the GetSampledRequests
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSampledRequestsRequest method.
//    req, resp := client.GetSampledRequestsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetSampledRequests
func (c *WAF) GetSampledRequestsRequest(input *GetSampledRequestsInput) (req *request.Request, output *GetSampledRequestsOutput) {
	op := &request.Operation{
		Name:       opGetSampledRequests,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSampledRequestsInput{}
	}

	output = &GetSampledRequestsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSampledRequests API operation for AWS WAF.
//
// Gets detailed information about a specified number of requests--a sample--that
// AWS WAF randomly selects from among the first 5,000 requests that your AWS
// resource received during a time range that you choose. You can specify a
// sample size of up to 500 requests, and you can specify any time range in
// the previous three hours.
//
// GetSampledRequests returns a time range, which is usually the time range
// that you specified. However, if your resource (such as a CloudFront distribution)
// received 5,000 requests before the specified time range elapsed, GetSampledRequests
// returns an updated time range. This new time range indicates the actual period
// during which AWS WAF selected the requests in the sample.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetSampledRequests for usage and error information.
//
// Returned Error Types:
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetSampledRequests
func (c *WAF) GetSampledRequests(input *GetSampledRequestsInput) (*GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	return out, req.Send()
}

// GetSampledRequestsWithContext is the same as GetSampledRequests with the addition of
// the ability to pass a context and additional request options.
//
// See GetSampledRequests for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetSampledRequestsWithContext(ctx aws.Context, input *GetSampledRequestsInput, opts ...request.Option) (*GetSampledRequestsOutput, error) {
	req, out := c.GetSampledRequestsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSizeConstraintSet = "GetSizeConstraintSet"

// GetSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the GetSizeConstraintSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSizeConstraintSet for more information on using the GetSizeConstraintSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSizeConstraintSetRequest method.
//    req, resp := client.GetSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetSizeConstraintSet
func (c *WAF) GetSizeConstraintSetRequest(input *GetSizeConstraintSetInput) (req *request.Request, output *GetSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opGetSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSizeConstraintSetInput{}
	}

	output = &GetSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSizeConstraintSet API operation for AWS WAF.
//
// Returns the SizeConstraintSet specified by SizeConstraintSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetSizeConstraintSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetSizeConstraintSet
func (c *WAF) GetSizeConstraintSet(input *GetSizeConstraintSetInput) (*GetSizeConstraintSetOutput, error) {
	req, out := c.GetSizeConstraintSetRequest(input)
	return out, req.Send()
}

// GetSizeConstraintSetWithContext is the same as GetSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetSizeConstraintSetWithContext(ctx aws.Context, input *GetSizeConstraintSetInput, opts ...request.Option) (*GetSizeConstraintSetOutput, error) {
	req, out := c.GetSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSqlInjectionMatchSet = "GetSqlInjectionMatchSet"

// GetSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetSqlInjectionMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetSqlInjectionMatchSet for more information on using the GetSqlInjectionMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetSqlInjectionMatchSetRequest method.
//    req, resp := client.GetSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetSqlInjectionMatchSet
func (c *WAF) GetSqlInjectionMatchSetRequest(input *GetSqlInjectionMatchSetInput) (req *request.Request, output *GetSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSqlInjectionMatchSetInput{}
	}

	output = &GetSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetSqlInjectionMatchSet API operation for AWS WAF.
//
// Returns the SqlInjectionMatchSet that is specified by SqlInjectionMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetSqlInjectionMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetSqlInjectionMatchSet
func (c *WAF) GetSqlInjectionMatchSet(input *GetSqlInjectionMatchSetInput) (*GetSqlInjectionMatchSetOutput, error) {
	req, out := c.GetSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// GetSqlInjectionMatchSetWithContext is the same as GetSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetSqlInjectionMatchSetWithContext(ctx aws.Context, input *GetSqlInjectionMatchSetInput, opts ...request.Option) (*GetSqlInjectionMatchSetOutput, error) {
	req, out := c.GetSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetWebACL = "GetWebACL"

// GetWebACLRequest generates a "aws/request.Request" representing the
// client's request for the GetWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetWebACL for more information on using the GetWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetWebACLRequest method.
//    req, resp := client.GetWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetWebACL
func (c *WAF) GetWebACLRequest(input *GetWebACLInput) (req *request.Request, output *GetWebACLOutput) {
	op := &request.Operation{
		Name:       opGetWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWebACLInput{}
	}

	output = &GetWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetWebACL API operation for AWS WAF.
//
// Returns the WebACL that is specified by WebACLId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetWebACL for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetWebACL
func (c *WAF) GetWebACL(input *GetWebACLInput) (*GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	return out, req.Send()
}

// GetWebACLWithContext is the same as GetWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See GetWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetWebACLWithContext(ctx aws.Context, input *GetWebACLInput, opts ...request.Option) (*GetWebACLOutput, error) {
	req, out := c.GetWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetXssMatchSet = "GetXssMatchSet"

// GetXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the GetXssMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetXssMatchSet for more information on using the GetXssMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetXssMatchSetRequest method.
//    req, resp := client.GetXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetXssMatchSet
func (c *WAF) GetXssMatchSetRequest(input *GetXssMatchSetInput) (req *request.Request, output *GetXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opGetXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetXssMatchSetInput{}
	}

	output = &GetXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetXssMatchSet API operation for AWS WAF.
//
// Returns the XssMatchSet that is specified by XssMatchSetId.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation GetXssMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetXssMatchSet
func (c *WAF) GetXssMatchSet(input *GetXssMatchSetInput) (*GetXssMatchSetOutput, error) {
	req, out := c.GetXssMatchSetRequest(input)
	return out, req.Send()
}

// GetXssMatchSetWithContext is the same as GetXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See GetXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) GetXssMatchSetWithContext(ctx aws.Context, input *GetXssMatchSetInput, opts ...request.Option) (*GetXssMatchSetOutput, error) {
	req, out := c.GetXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListActivatedRulesInRuleGroup = "ListActivatedRulesInRuleGroup"

// ListActivatedRulesInRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the ListActivatedRulesInRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListActivatedRulesInRuleGroup for more information on using the ListActivatedRulesInRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListActivatedRulesInRuleGroupRequest method.
//    req, resp := client.ListActivatedRulesInRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListActivatedRulesInRuleGroup
func (c *WAF) ListActivatedRulesInRuleGroupRequest(input *ListActivatedRulesInRuleGroupInput) (req *request.Request, output *ListActivatedRulesInRuleGroupOutput) {
	op := &request.Operation{
		Name:       opListActivatedRulesInRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListActivatedRulesInRuleGroupInput{}
	}

	output = &ListActivatedRulesInRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListActivatedRulesInRuleGroup API operation for AWS WAF.
//
// Returns an array of ActivatedRule objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListActivatedRulesInRuleGroup for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListActivatedRulesInRuleGroup
func (c *WAF) ListActivatedRulesInRuleGroup(input *ListActivatedRulesInRuleGroupInput) (*ListActivatedRulesInRuleGroupOutput, error) {
	req, out := c.ListActivatedRulesInRuleGroupRequest(input)
	return out, req.Send()
}

// ListActivatedRulesInRuleGroupWithContext is the same as ListActivatedRulesInRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See ListActivatedRulesInRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListActivatedRulesInRuleGroupWithContext(ctx aws.Context, input *ListActivatedRulesInRuleGroupInput, opts ...request.Option) (*ListActivatedRulesInRuleGroupOutput, error) {
	req, out := c.ListActivatedRulesInRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListByteMatchSets = "ListByteMatchSets"

// ListByteMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListByteMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListByteMatchSets for more information on using the ListByteMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListByteMatchSetsRequest method.
//    req, resp := client.ListByteMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListByteMatchSets
func (c *WAF) ListByteMatchSetsRequest(input *ListByteMatchSetsInput) (req *request.Request, output *ListByteMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListByteMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListByteMatchSetsInput{}
	}

	output = &ListByteMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListByteMatchSets API operation for AWS WAF.
//
// Returns an array of ByteMatchSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListByteMatchSets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListByteMatchSets
func (c *WAF) ListByteMatchSets(input *ListByteMatchSetsInput) (*ListByteMatchSetsOutput, error) {
	req, out := c.ListByteMatchSetsRequest(input)
	return out, req.Send()
}

// ListByteMatchSetsWithContext is the same as ListByteMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListByteMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListByteMatchSetsWithContext(ctx aws.Context, input *ListByteMatchSetsInput, opts ...request.Option) (*ListByteMatchSetsOutput, error) {
	req, out := c.ListByteMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGeoMatchSets = "ListGeoMatchSets"

// ListGeoMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListGeoMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListGeoMatchSets for more information on using the ListGeoMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListGeoMatchSetsRequest method.
//    req, resp := client.ListGeoMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListGeoMatchSets
func (c *WAF) ListGeoMatchSetsRequest(input *ListGeoMatchSetsInput) (req *request.Request, output *ListGeoMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListGeoMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGeoMatchSetsInput{}
	}

	output = &ListGeoMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListGeoMatchSets API operation for AWS WAF.
//
// Returns an array of GeoMatchSetSummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListGeoMatchSets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListGeoMatchSets
func (c *WAF) ListGeoMatchSets(input *ListGeoMatchSetsInput) (*ListGeoMatchSetsOutput, error) {
	req, out := c.ListGeoMatchSetsRequest(input)
	return out, req.Send()
}

// ListGeoMatchSetsWithContext is the same as ListGeoMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListGeoMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListGeoMatchSetsWithContext(ctx aws.Context, input *ListGeoMatchSetsInput, opts ...request.Option) (*ListGeoMatchSetsOutput, error) {
	req, out := c.ListGeoMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListIPSets = "ListIPSets"

// ListIPSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListIPSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIPSets for more information on using the ListIPSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListIPSetsRequest method.
//    req, resp := client.ListIPSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListIPSets
func (c *WAF) ListIPSetsRequest(input *ListIPSetsInput) (req *request.Request, output *ListIPSetsOutput) {
	op := &request.Operation{
		Name:       opListIPSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListIPSetsInput{}
	}

	output = &ListIPSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIPSets API operation for AWS WAF.
//
// Returns an array of IPSetSummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListIPSets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListIPSets
func (c *WAF) ListIPSets(input *ListIPSetsInput) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	return out, req.Send()
}

// ListIPSetsWithContext is the same as ListIPSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListIPSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListIPSetsWithContext(ctx aws.Context, input *ListIPSetsInput, opts ...request.Option) (*ListIPSetsOutput, error) {
	req, out := c.ListIPSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListLoggingConfigurations = "ListLoggingConfigurations"

// ListLoggingConfigurationsRequest generates a "aws/request.Request" representing the
// client's request for the ListLoggingConfigurations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLoggingConfigurations for more information on using the ListLoggingConfigurations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListLoggingConfigurationsRequest method.
//    req, resp := client.ListLoggingConfigurationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListLoggingConfigurations
func (c *WAF) ListLoggingConfigurationsRequest(input *ListLoggingConfigurationsInput) (req *request.Request, output *ListLoggingConfigurationsOutput) {
	op := &request.Operation{
		Name:       opListLoggingConfigurations,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListLoggingConfigurationsInput{}
	}

	output = &ListLoggingConfigurationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLoggingConfigurations API operation for AWS WAF.
//
// Returns an array of LoggingConfiguration objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListLoggingConfigurations for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListLoggingConfigurations
func (c *WAF) ListLoggingConfigurations(input *ListLoggingConfigurationsInput) (*ListLoggingConfigurationsOutput, error) {
	req, out := c.ListLoggingConfigurationsRequest(input)
	return out, req.Send()
}

// ListLoggingConfigurationsWithContext is the same as ListLoggingConfigurations with the addition of
// the ability to pass a context and additional request options.
//
// See ListLoggingConfigurations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListLoggingConfigurationsWithContext(ctx aws.Context, input *ListLoggingConfigurationsInput, opts ...request.Option) (*ListLoggingConfigurationsOutput, error) {
	req, out := c.ListLoggingConfigurationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRateBasedRules = "ListRateBasedRules"

// ListRateBasedRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRateBasedRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRateBasedRules for more information on using the ListRateBasedRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRateBasedRulesRequest method.
//    req, resp := client.ListRateBasedRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRateBasedRules
func (c *WAF) ListRateBasedRulesRequest(input *ListRateBasedRulesInput) (req *request.Request, output *ListRateBasedRulesOutput) {
	op := &request.Operation{
		Name:       opListRateBasedRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRateBasedRulesInput{}
	}

	output = &ListRateBasedRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRateBasedRules API operation for AWS WAF.
//
// Returns an array of RuleSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListRateBasedRules for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRateBasedRules
func (c *WAF) ListRateBasedRules(input *ListRateBasedRulesInput) (*ListRateBasedRulesOutput, error) {
	req, out := c.ListRateBasedRulesRequest(input)
	return out, req.Send()
}

// ListRateBasedRulesWithContext is the same as ListRateBasedRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRateBasedRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListRateBasedRulesWithContext(ctx aws.Context, input *ListRateBasedRulesInput, opts ...request.Option) (*ListRateBasedRulesOutput, error) {
	req, out := c.ListRateBasedRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRegexMatchSets = "ListRegexMatchSets"

// ListRegexMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListRegexMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegexMatchSets for more information on using the ListRegexMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRegexMatchSetsRequest method.
//    req, resp := client.ListRegexMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRegexMatchSets
func (c *WAF) ListRegexMatchSetsRequest(input *ListRegexMatchSetsInput) (req *request.Request, output *ListRegexMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListRegexMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRegexMatchSetsInput{}
	}

	output = &ListRegexMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRegexMatchSets API operation for AWS WAF.
//
// Returns an array of RegexMatchSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListRegexMatchSets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRegexMatchSets
func (c *WAF) ListRegexMatchSets(input *ListRegexMatchSetsInput) (*ListRegexMatchSetsOutput, error) {
	req, out := c.ListRegexMatchSetsRequest(input)
	return out, req.Send()
}

// ListRegexMatchSetsWithContext is the same as ListRegexMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegexMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListRegexMatchSetsWithContext(ctx aws.Context, input *ListRegexMatchSetsInput, opts ...request.Option) (*ListRegexMatchSetsOutput, error) {
	req, out := c.ListRegexMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRegexPatternSets = "ListRegexPatternSets"

// ListRegexPatternSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListRegexPatternSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRegexPatternSets for more information on using the ListRegexPatternSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRegexPatternSetsRequest method.
//    req, resp := client.ListRegexPatternSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRegexPatternSets
func (c *WAF) ListRegexPatternSetsRequest(input *ListRegexPatternSetsInput) (req *request.Request, output *ListRegexPatternSetsOutput) {
	op := &request.Operation{
		Name:       opListRegexPatternSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRegexPatternSetsInput{}
	}

	output = &ListRegexPatternSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRegexPatternSets API operation for AWS WAF.
//
// Returns an array of RegexPatternSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListRegexPatternSets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRegexPatternSets
func (c *WAF) ListRegexPatternSets(input *ListRegexPatternSetsInput) (*ListRegexPatternSetsOutput, error) {
	req, out := c.ListRegexPatternSetsRequest(input)
	return out, req.Send()
}

// ListRegexPatternSetsWithContext is the same as ListRegexPatternSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListRegexPatternSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListRegexPatternSetsWithContext(ctx aws.Context, input *ListRegexPatternSetsInput, opts ...request.Option) (*ListRegexPatternSetsOutput, error) {
	req, out := c.ListRegexPatternSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRuleGroups = "ListRuleGroups"

// ListRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRuleGroups for more information on using the ListRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRuleGroupsRequest method.
//    req, resp := client.ListRuleGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRuleGroups
func (c *WAF) ListRuleGroupsRequest(input *ListRuleGroupsInput) (req *request.Request, output *ListRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opListRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRuleGroupsInput{}
	}

	output = &ListRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRuleGroups API operation for AWS WAF.
//
// Returns an array of RuleGroup objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListRuleGroups for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRuleGroups
func (c *WAF) ListRuleGroups(input *ListRuleGroupsInput) (*ListRuleGroupsOutput, error) {
	req, out := c.ListRuleGroupsRequest(input)
	return out, req.Send()
}

// ListRuleGroupsWithContext is the same as ListRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListRuleGroupsWithContext(ctx aws.Context, input *ListRuleGroupsInput, opts ...request.Option) (*ListRuleGroupsOutput, error) {
	req, out := c.ListRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRules for more information on using the ListRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListRulesRequest method.
//    req, resp := client.ListRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRules
func (c *WAF) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for AWS WAF.
//
// Returns an array of RuleSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListRules for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListRules
func (c *WAF) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListRulesWithContext(ctx aws.Context, input *ListRulesInput, opts ...request.Option) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSizeConstraintSets = "ListSizeConstraintSets"

// ListSizeConstraintSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListSizeConstraintSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSizeConstraintSets for more information on using the ListSizeConstraintSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSizeConstraintSetsRequest method.
//    req, resp := client.ListSizeConstraintSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListSizeConstraintSets
func (c *WAF) ListSizeConstraintSetsRequest(input *ListSizeConstraintSetsInput) (req *request.Request, output *ListSizeConstraintSetsOutput) {
	op := &request.Operation{
		Name:       opListSizeConstraintSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSizeConstraintSetsInput{}
	}

	output = &ListSizeConstraintSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSizeConstraintSets API operation for AWS WAF.
//
// Returns an array of SizeConstraintSetSummary objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListSizeConstraintSets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListSizeConstraintSets
func (c *WAF) ListSizeConstraintSets(input *ListSizeConstraintSetsInput) (*ListSizeConstraintSetsOutput, error) {
	req, out := c.ListSizeConstraintSetsRequest(input)
	return out, req.Send()
}

// ListSizeConstraintSetsWithContext is the same as ListSizeConstraintSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSizeConstraintSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListSizeConstraintSetsWithContext(ctx aws.Context, input *ListSizeConstraintSetsInput, opts ...request.Option) (*ListSizeConstraintSetsOutput, error) {
	req, out := c.ListSizeConstraintSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSqlInjectionMatchSets = "ListSqlInjectionMatchSets"

// ListSqlInjectionMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListSqlInjectionMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSqlInjectionMatchSets for more information on using the ListSqlInjectionMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSqlInjectionMatchSetsRequest method.
//    req, resp := client.ListSqlInjectionMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListSqlInjectionMatchSets
func (c *WAF) ListSqlInjectionMatchSetsRequest(input *ListSqlInjectionMatchSetsInput) (req *request.Request, output *ListSqlInjectionMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListSqlInjectionMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSqlInjectionMatchSetsInput{}
	}

	output = &ListSqlInjectionMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSqlInjectionMatchSets API operation for AWS WAF.
//
// Returns an array of SqlInjectionMatchSet objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListSqlInjectionMatchSets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListSqlInjectionMatchSets
func (c *WAF) ListSqlInjectionMatchSets(input *ListSqlInjectionMatchSetsInput) (*ListSqlInjectionMatchSetsOutput, error) {
	req, out := c.ListSqlInjectionMatchSetsRequest(input)
	return out, req.Send()
}

// ListSqlInjectionMatchSetsWithContext is the same as ListSqlInjectionMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListSqlInjectionMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListSqlInjectionMatchSetsWithContext(ctx aws.Context, input *ListSqlInjectionMatchSetsInput, opts ...request.Option) (*ListSqlInjectionMatchSetsOutput, error) {
	req, out := c.ListSqlInjectionMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListSubscribedRuleGroups = "ListSubscribedRuleGroups"

// ListSubscribedRuleGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListSubscribedRuleGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSubscribedRuleGroups for more information on using the ListSubscribedRuleGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSubscribedRuleGroupsRequest method.
//    req, resp := client.ListSubscribedRuleGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListSubscribedRuleGroups
func (c *WAF) ListSubscribedRuleGroupsRequest(input *ListSubscribedRuleGroupsInput) (req *request.Request, output *ListSubscribedRuleGroupsOutput) {
	op := &request.Operation{
		Name:       opListSubscribedRuleGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListSubscribedRuleGroupsInput{}
	}

	output = &ListSubscribedRuleGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSubscribedRuleGroups API operation for AWS WAF.
//
// Returns an array of RuleGroup objects that you are subscribed to.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListSubscribedRuleGroups for usage and error information.
//
// Returned Error Types:
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListSubscribedRuleGroups
func (c *WAF) ListSubscribedRuleGroups(input *ListSubscribedRuleGroupsInput) (*ListSubscribedRuleGroupsOutput, error) {
	req, out := c.ListSubscribedRuleGroupsRequest(input)
	return out, req.Send()
}

// ListSubscribedRuleGroupsWithContext is the same as ListSubscribedRuleGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListSubscribedRuleGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListSubscribedRuleGroupsWithContext(ctx aws.Context, input *ListSubscribedRuleGroupsInput, opts ...request.Option) (*ListSubscribedRuleGroupsOutput, error) {
	req, out := c.ListSubscribedRuleGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListTagsForResource
func (c *WAF) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS WAF.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * BadRequestException
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListTagsForResource
func (c *WAF) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListWebACLs = "ListWebACLs"

// ListWebACLsRequest generates a "aws/request.Request" representing the
// client's request for the ListWebACLs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListWebACLs for more information on using the ListWebACLs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListWebACLsRequest method.
//    req, resp := client.ListWebACLsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListWebACLs
func (c *WAF) ListWebACLsRequest(input *ListWebACLsInput) (req *request.Request, output *ListWebACLsOutput) {
	op := &request.Operation{
		Name:       opListWebACLs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListWebACLsInput{}
	}

	output = &ListWebACLsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListWebACLs API operation for AWS WAF.
//
// Returns an array of WebACLSummary objects in the response.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListWebACLs for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListWebACLs
func (c *WAF) ListWebACLs(input *ListWebACLsInput) (*ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	return out, req.Send()
}

// ListWebACLsWithContext is the same as ListWebACLs with the addition of
// the ability to pass a context and additional request options.
//
// See ListWebACLs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListWebACLsWithContext(ctx aws.Context, input *ListWebACLsInput, opts ...request.Option) (*ListWebACLsOutput, error) {
	req, out := c.ListWebACLsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListXssMatchSets = "ListXssMatchSets"

// ListXssMatchSetsRequest generates a "aws/request.Request" representing the
// client's request for the ListXssMatchSets operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListXssMatchSets for more information on using the ListXssMatchSets
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListXssMatchSetsRequest method.
//    req, resp := client.ListXssMatchSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListXssMatchSets
func (c *WAF) ListXssMatchSetsRequest(input *ListXssMatchSetsInput) (req *request.Request, output *ListXssMatchSetsOutput) {
	op := &request.Operation{
		Name:       opListXssMatchSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListXssMatchSetsInput{}
	}

	output = &ListXssMatchSetsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListXssMatchSets API operation for AWS WAF.
//
// Returns an array of XssMatchSet objects.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation ListXssMatchSets for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/ListXssMatchSets
func (c *WAF) ListXssMatchSets(input *ListXssMatchSetsInput) (*ListXssMatchSetsOutput, error) {
	req, out := c.ListXssMatchSetsRequest(input)
	return out, req.Send()
}

// ListXssMatchSetsWithContext is the same as ListXssMatchSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListXssMatchSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) ListXssMatchSetsWithContext(ctx aws.Context, input *ListXssMatchSetsInput, opts ...request.Option) (*ListXssMatchSetsOutput, error) {
	req, out := c.ListXssMatchSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutLoggingConfiguration = "PutLoggingConfiguration"

// PutLoggingConfigurationRequest generates a "aws/request.Request" representing the
// client's request for the PutLoggingConfiguration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutLoggingConfiguration for more information on using the PutLoggingConfiguration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutLoggingConfigurationRequest method.
//    req, resp := client.PutLoggingConfigurationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/PutLoggingConfiguration
func (c *WAF) PutLoggingConfigurationRequest(input *PutLoggingConfigurationInput) (req *request.Request, output *PutLoggingConfigurationOutput) {
	op := &request.Operation{
		Name:       opPutLoggingConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutLoggingConfigurationInput{}
	}

	output = &PutLoggingConfigurationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// PutLoggingConfiguration API operation for AWS WAF.
//
// Associates a LoggingConfiguration with a specified web ACL.
//
// You can access information about all traffic that AWS WAF inspects using
// the following steps:
//
// Create an Amazon Kinesis Data Firehose.
//
// Create the data firehose with a PUT source and in the region that you are
// operating. However, if you are capturing logs for Amazon CloudFront, always
// create the firehose in US East (N. Virginia).
//
// Do not create the data firehose using a Kinesis stream as your source.
//
// Associate that firehose to your web ACL using a PutLoggingConfiguration request.
//
// When you successfully enable logging using a PutLoggingConfiguration request,
// AWS WAF will create a service linked role with the necessary permissions
// to write logs to the Amazon Kinesis Data Firehose. For more information,
// see Logging Web ACL Traffic Information (https://docs.aws.amazon.com/waf/latest/developerguide/logging.html)
// in the AWS WAF Developer Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation PutLoggingConfiguration for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * ServiceLinkedRoleErrorException
//   AWS WAF is not able to access the service linked role. This can be caused
//   by a previous PutLoggingConfiguration request, which can lock the service
//   linked role for about 20 seconds. Please try your request again. The service
//   linked role can also be locked by a previous DeleteServiceLinkedRole request,
//   which can lock the role for 15 minutes or more. If you recently made a DeleteServiceLinkedRole,
//   wait at least 15 minutes and try the request again. If you receive this same
//   exception again, you will have to wait additional time until the role is
//   unlocked.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/PutLoggingConfiguration
func (c *WAF) PutLoggingConfiguration(input *PutLoggingConfigurationInput) (*PutLoggingConfigurationOutput, error) {
	req, out := c.PutLoggingConfigurationRequest(input)
	return out, req.Send()
}

// PutLoggingConfigurationWithContext is the same as PutLoggingConfiguration with the addition of
// the ability to pass a context and additional request options.
//
// See PutLoggingConfiguration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) PutLoggingConfigurationWithContext(ctx aws.Context, input *PutLoggingConfigurationInput, opts ...request.Option) (*PutLoggingConfigurationOutput, error) {
	req, out := c.PutLoggingConfigurationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutPermissionPolicy = "PutPermissionPolicy"

// PutPermissionPolicyRequest generates a "aws/request.Request" representing the
// client's request for the PutPermissionPolicy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutPermissionPolicy for more information on using the PutPermissionPolicy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the PutPermissionPolicyRequest method.
//    req, resp := client.PutPermissionPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/PutPermissionPolicy
func (c *WAF) PutPermissionPolicyRequest(input *PutPermissionPolicyInput) (req *request.Request, output *PutPermissionPolicyOutput) {
	op := &request.Operation{
		Name:       opPutPermissionPolicy,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &PutPermissionPolicyInput{}
	}

	output = &PutPermissionPolicyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutPermissionPolicy API operation for AWS WAF.
//
// Attaches a IAM policy to the specified resource. The only supported use for
// this action is to share a RuleGroup across accounts.
//
// The PutPermissionPolicy is subject to the following restrictions:
//
//    * You can attach only one policy with each PutPermissionPolicy request.
//
//    * The policy must include an Effect, Action and Principal.
//
//    * Effect must specify Allow.
//
//    * The Action in the policy must be waf:UpdateWebACL, waf-regional:UpdateWebACL,
//    waf:GetRuleGroup and waf-regional:GetRuleGroup . Any extra or wildcard
//    actions in the policy will be rejected.
//
//    * The policy cannot include a Resource parameter.
//
//    * The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup
//    must exist in the same region.
//
//    * The user making the request must be the owner of the RuleGroup.
//
//    * Your policy must be composed using IAM Policy version 2012-10-17.
//
// For more information, see IAM Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html).
//
// An example of a valid policy parameter is shown in the Examples section below.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation PutPermissionPolicy for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * InvalidPermissionPolicyException
//   The operation failed because the specified policy is not in the proper format.
//
//   The policy is subject to the following restrictions:
//
//      * You can attach only one policy with each PutPermissionPolicy request.
//
//      * The policy must include an Effect, Action and Principal.
//
//      * Effect must specify Allow.
//
//      * The Action in the policy must be waf:UpdateWebACL, waf-regional:UpdateWebACL,
//      waf:GetRuleGroup and waf-regional:GetRuleGroup . Any extra or wildcard
//      actions in the policy will be rejected.
//
//      * The policy cannot include a Resource parameter.
//
//      * The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup
//      must exist in the same region.
//
//      * The user making the request must be the owner of the RuleGroup.
//
//      * Your policy must be composed using IAM Policy version 2012-10-17.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/PutPermissionPolicy
func (c *WAF) PutPermissionPolicy(input *PutPermissionPolicyInput) (*PutPermissionPolicyOutput, error) {
	req, out := c.PutPermissionPolicyRequest(input)
	return out, req.Send()
}

// PutPermissionPolicyWithContext is the same as PutPermissionPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See PutPermissionPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) PutPermissionPolicyWithContext(ctx aws.Context, input *PutPermissionPolicyInput, opts ...request.Option) (*PutPermissionPolicyOutput, error) {
	req, out := c.PutPermissionPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/TagResource
func (c *WAF) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS WAF.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * BadRequestException
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/TagResource
func (c *WAF) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UntagResource
func (c *WAF) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS WAF.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * BadRequestException
//
//   * TagOperationException
//
//   * TagOperationInternalErrorException
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UntagResource
func (c *WAF) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateByteMatchSet = "UpdateByteMatchSet"

// UpdateByteMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateByteMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateByteMatchSet for more information on using the UpdateByteMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateByteMatchSetRequest method.
//    req, resp := client.UpdateByteMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateByteMatchSet
func (c *WAF) UpdateByteMatchSetRequest(input *UpdateByteMatchSetInput) (req *request.Request, output *UpdateByteMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateByteMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateByteMatchSetInput{}
	}

	output = &UpdateByteMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateByteMatchSet API operation for AWS WAF.
//
// Inserts or deletes ByteMatchTuple objects (filters) in a ByteMatchSet. For
// each ByteMatchTuple object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a ByteMatchSetUpdate object, you delete the existing object and
//    add a new one.
//
//    * The part of a web request that you want AWS WAF to inspect, such as
//    a query string or the value of the User-Agent header.
//
//    * The bytes (typically a string that corresponds with ASCII characters)
//    that you want AWS WAF to look for. For more information, including how
//    you specify the values for the AWS WAF API and the AWS CLI or SDKs, see
//    TargetString in the ByteMatchTuple data type.
//
//    * Where to look, such as at the beginning or the end of a query string.
//
//    * Whether to perform any conversions on the request, such as converting
//    it to lowercase, before inspecting it for the specified string.
//
// For example, you can add a ByteMatchSetUpdate object that matches web requests
// in which User-Agent headers contain the string BadBot. You can then configure
// AWS WAF to block those requests.
//
// To create and configure a ByteMatchSet, perform the following steps:
//
// Create a ByteMatchSet. For more information, see CreateByteMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateByteMatchSet request.
//
// Submit an UpdateByteMatchSet request to specify the part of the request that
// you want AWS WAF to inspect (for example, the header or the URI) and the
// value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateByteMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateByteMatchSet
func (c *WAF) UpdateByteMatchSet(input *UpdateByteMatchSetInput) (*UpdateByteMatchSetOutput, error) {
	req, out := c.UpdateByteMatchSetRequest(input)
	return out, req.Send()
}

// UpdateByteMatchSetWithContext is the same as UpdateByteMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateByteMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateByteMatchSetWithContext(ctx aws.Context, input *UpdateByteMatchSetInput, opts ...request.Option) (*UpdateByteMatchSetOutput, error) {
	req, out := c.UpdateByteMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGeoMatchSet = "UpdateGeoMatchSet"

// UpdateGeoMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateGeoMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateGeoMatchSet for more information on using the UpdateGeoMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateGeoMatchSetRequest method.
//    req, resp := client.UpdateGeoMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateGeoMatchSet
func (c *WAF) UpdateGeoMatchSetRequest(input *UpdateGeoMatchSetInput) (req *request.Request, output *UpdateGeoMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateGeoMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGeoMatchSetInput{}
	}

	output = &UpdateGeoMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateGeoMatchSet API operation for AWS WAF.
//
// Inserts or deletes GeoMatchConstraint objects in an GeoMatchSet. For each
// GeoMatchConstraint object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change an GeoMatchConstraint object, you delete the existing object and
//    add a new one.
//
//    * The Type. The only valid value for Type is Country.
//
//    * The Value, which is a two character code for the country to add to the
//    GeoMatchConstraint object. Valid codes are listed in GeoMatchConstraint$Value.
//
// To create and configure an GeoMatchSet, perform the following steps:
//
// Submit a CreateGeoMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateGeoMatchSet request.
//
// Submit an UpdateGeoMatchSet request to specify the country that you want
// AWS WAF to watch for.
//
// When you update an GeoMatchSet, you specify the country that you want to
// add and/or the country that you want to delete. If you want to change a country,
// you delete the existing country and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateGeoMatchSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateGeoMatchSet
func (c *WAF) UpdateGeoMatchSet(input *UpdateGeoMatchSetInput) (*UpdateGeoMatchSetOutput, error) {
	req, out := c.UpdateGeoMatchSetRequest(input)
	return out, req.Send()
}

// UpdateGeoMatchSetWithContext is the same as UpdateGeoMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGeoMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateGeoMatchSetWithContext(ctx aws.Context, input *UpdateGeoMatchSetInput, opts ...request.Option) (*UpdateGeoMatchSetOutput, error) {
	req, out := c.UpdateGeoMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateIPSet = "UpdateIPSet"

// UpdateIPSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateIPSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateIPSet for more information on using the UpdateIPSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateIPSetRequest method.
//    req, resp := client.UpdateIPSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateIPSet
func (c *WAF) UpdateIPSetRequest(input *UpdateIPSetInput) (req *request.Request, output *UpdateIPSetOutput) {
	op := &request.Operation{
		Name:       opUpdateIPSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateIPSetInput{}
	}

	output = &UpdateIPSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateIPSet API operation for AWS WAF.
//
// Inserts or deletes IPSetDescriptor objects in an IPSet. For each IPSetDescriptor
// object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change an IPSetDescriptor object, you delete the existing object and add
//    a new one.
//
//    * The IP address version, IPv4 or IPv6.
//
//    * The IP address in CIDR notation, for example, 192.0.2.0/24 (for the
//    range of IP addresses from 192.0.2.0 to 192.0.2.255) or 192.0.2.44/32
//    (for the individual IP address 192.0.2.44).
//
// AWS WAF supports IPv4 address ranges: /8 and any range between /16 through
// /32. AWS WAF supports IPv6 address ranges: /24, /32, /48, /56, /64, and /128.
// For more information about CIDR notation, see the Wikipedia entry Classless
// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
//
// IPv6 addresses can be represented using any of the following formats:
//
//    * 1111:0000:0000:0000:0000:0000:0000:0111/128
//
//    * 1111:0:0:0:0:0:0:0111/128
//
//    * 1111::0111/128
//
//    * 1111::111/128
//
// You use an IPSet to specify which web requests you want to allow or block
// based on the IP addresses that the requests originated from. For example,
// if you're receiving a lot of requests from one or a small number of IP addresses
// and you want to block the requests, you can create an IPSet that specifies
// those IP addresses, and then configure AWS WAF to block the requests.
//
// To create and configure an IPSet, perform the following steps:
//
// Submit a CreateIPSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateIPSet request to specify the IP addresses that you want AWS
// WAF to watch for.
//
// When you update an IPSet, you specify the IP addresses that you want to add
// and/or the IP addresses that you want to delete. If you want to change an
// IP address, you delete the existing IP address and add the new one.
//
// You can insert a maximum of 1000 addresses in a single request.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateIPSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateIPSet
func (c *WAF) UpdateIPSet(input *UpdateIPSetInput) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	return out, req.Send()
}

// UpdateIPSetWithContext is the same as UpdateIPSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateIPSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateIPSetWithContext(ctx aws.Context, input *UpdateIPSetInput, opts ...request.Option) (*UpdateIPSetOutput, error) {
	req, out := c.UpdateIPSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRateBasedRule = "UpdateRateBasedRule"

// UpdateRateBasedRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRateBasedRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRateBasedRule for more information on using the UpdateRateBasedRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRateBasedRuleRequest method.
//    req, resp := client.UpdateRateBasedRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRateBasedRule
func (c *WAF) UpdateRateBasedRuleRequest(input *UpdateRateBasedRuleInput) (req *request.Request, output *UpdateRateBasedRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRateBasedRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRateBasedRuleInput{}
	}

	output = &UpdateRateBasedRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRateBasedRule API operation for AWS WAF.
//
// Inserts or deletes Predicate objects in a rule and updates the RateLimit
// in the rule.
//
// Each Predicate object identifies a predicate, such as a ByteMatchSet or an
// IPSet, that specifies the web requests that you want to block or count. The
// RateLimit specifies the number of requests every five minutes that triggers
// the rule.
//
// If you add more than one predicate to a RateBasedRule, a request must match
// all the predicates and exceed the RateLimit to be counted or blocked. For
// example, suppose you add the following to a RateBasedRule:
//
//    * An IPSet that matches the IP address 192.0.2.44/32
//
//    * A ByteMatchSet that matches BadBot in the User-Agent header
//
// Further, you specify a RateLimit of 15,000.
//
// You then add the RateBasedRule to a WebACL and specify that you want to block
// requests that satisfy the rule. For a request to be blocked, it must come
// from the IP address 192.0.2.44 and the User-Agent header in the request must
// contain the value BadBot. Further, requests that match these two conditions
// much be received at a rate of more than 15,000 every five minutes. If the
// rate drops below this limit, AWS WAF no longer blocks the requests.
//
// As a second example, suppose you want to limit requests to a particular page
// on your site. To do this, you could add the following to a RateBasedRule:
//
//    * A ByteMatchSet with FieldToMatch of URI
//
//    * A PositionalConstraint of STARTS_WITH
//
//    * A TargetString of login
//
// Further, you specify a RateLimit of 15,000.
//
// By adding this RateBasedRule to a WebACL, you could limit requests to your
// login page without affecting the rest of your site.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateRateBasedRule for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRateBasedRule
func (c *WAF) UpdateRateBasedRule(input *UpdateRateBasedRuleInput) (*UpdateRateBasedRuleOutput, error) {
	req, out := c.UpdateRateBasedRuleRequest(input)
	return out, req.Send()
}

// UpdateRateBasedRuleWithContext is the same as UpdateRateBasedRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRateBasedRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateRateBasedRuleWithContext(ctx aws.Context, input *UpdateRateBasedRuleInput, opts ...request.Option) (*UpdateRateBasedRuleOutput, error) {
	req, out := c.UpdateRateBasedRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRegexMatchSet = "UpdateRegexMatchSet"

// UpdateRegexMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRegexMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRegexMatchSet for more information on using the UpdateRegexMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRegexMatchSetRequest method.
//    req, resp := client.UpdateRegexMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRegexMatchSet
func (c *WAF) UpdateRegexMatchSetRequest(input *UpdateRegexMatchSetInput) (req *request.Request, output *UpdateRegexMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateRegexMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRegexMatchSetInput{}
	}

	output = &UpdateRegexMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRegexMatchSet API operation for AWS WAF.
//
// Inserts or deletes RegexMatchTuple objects (filters) in a RegexMatchSet.
// For each RegexMatchSetUpdate object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a RegexMatchSetUpdate object, you delete the existing object and
//    add a new one.
//
//    * The part of a web request that you want AWS WAF to inspectupdate, such
//    as a query string or the value of the User-Agent header.
//
//    * The identifier of the pattern (a regular expression) that you want AWS
//    WAF to look for. For more information, see RegexPatternSet.
//
//    * Whether to perform any conversions on the request, such as converting
//    it to lowercase, before inspecting it for the specified string.
//
// For example, you can create a RegexPatternSet that matches any requests with
// User-Agent headers that contain the string B[a@]dB[o0]t. You can then configure
// AWS WAF to reject those requests.
//
// To create and configure a RegexMatchSet, perform the following steps:
//
// Create a RegexMatchSet. For more information, see CreateRegexMatchSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRegexMatchSet request.
//
// Submit an UpdateRegexMatchSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the identifier of the RegexPatternSet that contain the regular expression
// patters you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateRegexMatchSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * DisallowedNameException
//   The name specified is invalid.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRegexMatchSet
func (c *WAF) UpdateRegexMatchSet(input *UpdateRegexMatchSetInput) (*UpdateRegexMatchSetOutput, error) {
	req, out := c.UpdateRegexMatchSetRequest(input)
	return out, req.Send()
}

// UpdateRegexMatchSetWithContext is the same as UpdateRegexMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRegexMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateRegexMatchSetWithContext(ctx aws.Context, input *UpdateRegexMatchSetInput, opts ...request.Option) (*UpdateRegexMatchSetOutput, error) {
	req, out := c.UpdateRegexMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRegexPatternSet = "UpdateRegexPatternSet"

// UpdateRegexPatternSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRegexPatternSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRegexPatternSet for more information on using the UpdateRegexPatternSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRegexPatternSetRequest method.
//    req, resp := client.UpdateRegexPatternSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRegexPatternSet
func (c *WAF) UpdateRegexPatternSetRequest(input *UpdateRegexPatternSetInput) (req *request.Request, output *UpdateRegexPatternSetOutput) {
	op := &request.Operation{
		Name:       opUpdateRegexPatternSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRegexPatternSetInput{}
	}

	output = &UpdateRegexPatternSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRegexPatternSet API operation for AWS WAF.
//
// Inserts or deletes RegexPatternString objects in a RegexPatternSet. For each
// RegexPatternString object, you specify the following values:
//
//    * Whether to insert or delete the RegexPatternString.
//
//    * The regular expression pattern that you want to insert or delete. For
//    more information, see RegexPatternSet.
//
// For example, you can create a RegexPatternString such as B[a@]dB[o0]t. AWS
// WAF will match this RegexPatternString to:
//
//    * BadBot
//
//    * BadB0t
//
//    * B@dBot
//
//    * B@dB0t
//
// To create and configure a RegexPatternSet, perform the following steps:
//
// Create a RegexPatternSet. For more information, see CreateRegexPatternSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRegexPatternSet request.
//
// Submit an UpdateRegexPatternSet request to specify the regular expression
// pattern that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateRegexPatternSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidRegexPatternException
//   The regular expression (regex) you specified in RegexPatternString is invalid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRegexPatternSet
func (c *WAF) UpdateRegexPatternSet(input *UpdateRegexPatternSetInput) (*UpdateRegexPatternSetOutput, error) {
	req, out := c.UpdateRegexPatternSetRequest(input)
	return out, req.Send()
}

// UpdateRegexPatternSetWithContext is the same as UpdateRegexPatternSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRegexPatternSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateRegexPatternSetWithContext(ctx aws.Context, input *UpdateRegexPatternSetInput, opts ...request.Option) (*UpdateRegexPatternSetOutput, error) {
	req, out := c.UpdateRegexPatternSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRule = "UpdateRule"

// UpdateRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRule for more information on using the UpdateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleRequest method.
//    req, resp := client.UpdateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRule
func (c *WAF) UpdateRuleRequest(input *UpdateRuleInput) (req *request.Request, output *UpdateRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleInput{}
	}

	output = &UpdateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRule API operation for AWS WAF.
//
// Inserts or deletes Predicate objects in a Rule. Each Predicate object identifies
// a predicate, such as a ByteMatchSet or an IPSet, that specifies the web requests
// that you want to allow, block, or count. If you add more than one predicate
// to a Rule, a request must match all of the specifications to be allowed,
// blocked, or counted. For example, suppose that you add the following to a
// Rule:
//
//    * A ByteMatchSet that matches the value BadBot in the User-Agent header
//
//    * An IPSet that matches the IP address 192.0.2.44
//
// You then add the Rule to a WebACL and specify that you want to block requests
// that satisfy the Rule. For a request to be blocked, the User-Agent header
// in the request must contain the value BadBot and the request must originate
// from the IP address 192.0.2.44.
//
// To create and configure a Rule, perform the following steps:
//
// Create and update the predicates that you want to include in the Rule.
//
// Create the Rule. See CreateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRule request.
//
// Submit an UpdateRule request to add predicates to the Rule.
//
// Create and update a WebACL that contains the Rule. See CreateWebACL.
//
// If you want to replace one ByteMatchSet or IPSet with another, you delete
// the existing one and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateRule for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRule
func (c *WAF) UpdateRule(input *UpdateRuleInput) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	return out, req.Send()
}

// UpdateRuleWithContext is the same as UpdateRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateRuleWithContext(ctx aws.Context, input *UpdateRuleInput, opts ...request.Option) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRuleGroup = "UpdateRuleGroup"

// UpdateRuleGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRuleGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRuleGroup for more information on using the UpdateRuleGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRuleGroupRequest method.
//    req, resp := client.UpdateRuleGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRuleGroup
func (c *WAF) UpdateRuleGroupRequest(input *UpdateRuleGroupInput) (req *request.Request, output *UpdateRuleGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRuleGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRuleGroupInput{}
	}

	output = &UpdateRuleGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateRuleGroup API operation for AWS WAF.
//
// Inserts or deletes ActivatedRule objects in a RuleGroup.
//
// You can only insert REGULAR rules into a rule group.
//
// You can have a maximum of ten rules per rule group.
//
// To create and configure a RuleGroup, perform the following steps:
//
// Create and update the Rules that you want to include in the RuleGroup. See
// CreateRule.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateRuleGroup request.
//
// Submit an UpdateRuleGroup request to add Rules to the RuleGroup.
//
// Create and update a WebACL that contains the RuleGroup. See CreateWebACL.
//
// If you want to replace one Rule with another, you delete the existing one
// and add the new one.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateRuleGroup for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateRuleGroup
func (c *WAF) UpdateRuleGroup(input *UpdateRuleGroupInput) (*UpdateRuleGroupOutput, error) {
	req, out := c.UpdateRuleGroupRequest(input)
	return out, req.Send()
}

// UpdateRuleGroupWithContext is the same as UpdateRuleGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRuleGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateRuleGroupWithContext(ctx aws.Context, input *UpdateRuleGroupInput, opts ...request.Option) (*UpdateRuleGroupOutput, error) {
	req, out := c.UpdateRuleGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSizeConstraintSet = "UpdateSizeConstraintSet"

// UpdateSizeConstraintSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSizeConstraintSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSizeConstraintSet for more information on using the UpdateSizeConstraintSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSizeConstraintSetRequest method.
//    req, resp := client.UpdateSizeConstraintSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateSizeConstraintSet
func (c *WAF) UpdateSizeConstraintSetRequest(input *UpdateSizeConstraintSetInput) (req *request.Request, output *UpdateSizeConstraintSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSizeConstraintSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSizeConstraintSetInput{}
	}

	output = &UpdateSizeConstraintSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSizeConstraintSet API operation for AWS WAF.
//
// Inserts or deletes SizeConstraint objects (filters) in a SizeConstraintSet.
// For each SizeConstraint object, you specify the following values:
//
//    * Whether to insert or delete the object from the array. If you want to
//    change a SizeConstraintSetUpdate object, you delete the existing object
//    and add a new one.
//
//    * The part of a web request that you want AWS WAF to evaluate, such as
//    the length of a query string or the length of the User-Agent header.
//
//    * Whether to perform any transformations on the request, such as converting
//    it to lowercase, before checking its length. Note that transformations
//    of the request body are not supported because the AWS resource forwards
//    only the first 8192 bytes of your request to AWS WAF. You can only specify
//    a single type of TextTransformation.
//
//    * A ComparisonOperator used for evaluating the selected part of the request
//    against the specified Size, such as equals, greater than, less than, and
//    so on.
//
//    * The length, in bytes, that you want AWS WAF to watch for in selected
//    part of the request. The length is computed after applying the transformation.
//
// For example, you can add a SizeConstraintSetUpdate object that matches web
// requests in which the length of the User-Agent header is greater than 100
// bytes. You can then configure AWS WAF to block those requests.
//
// To create and configure a SizeConstraintSet, perform the following steps:
//
// Create a SizeConstraintSet. For more information, see CreateSizeConstraintSet.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateSizeConstraintSet request.
//
// Submit an UpdateSizeConstraintSet request to specify the part of the request
// that you want AWS WAF to inspect (for example, the header or the URI) and
// the value that you want AWS WAF to watch for.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateSizeConstraintSet for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateSizeConstraintSet
func (c *WAF) UpdateSizeConstraintSet(input *UpdateSizeConstraintSetInput) (*UpdateSizeConstraintSetOutput, error) {
	req, out := c.UpdateSizeConstraintSetRequest(input)
	return out, req.Send()
}

// UpdateSizeConstraintSetWithContext is the same as UpdateSizeConstraintSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSizeConstraintSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateSizeConstraintSetWithContext(ctx aws.Context, input *UpdateSizeConstraintSetInput, opts ...request.Option) (*UpdateSizeConstraintSetOutput, error) {
	req, out := c.UpdateSizeConstraintSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSqlInjectionMatchSet = "UpdateSqlInjectionMatchSet"

// UpdateSqlInjectionMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSqlInjectionMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSqlInjectionMatchSet for more information on using the UpdateSqlInjectionMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateSqlInjectionMatchSetRequest method.
//    req, resp := client.UpdateSqlInjectionMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateSqlInjectionMatchSet
func (c *WAF) UpdateSqlInjectionMatchSetRequest(input *UpdateSqlInjectionMatchSetInput) (req *request.Request, output *UpdateSqlInjectionMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSqlInjectionMatchSetInput{}
	}

	output = &UpdateSqlInjectionMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateSqlInjectionMatchSet API operation for AWS WAF.
//
// Inserts or deletes SqlInjectionMatchTuple objects (filters) in a SqlInjectionMatchSet.
// For each SqlInjectionMatchTuple object, you specify the following values:
//
//    * Action: Whether to insert the object into or delete the object from
//    the array. To change a SqlInjectionMatchTuple, you delete the existing
//    object and add a new one.
//
//    * FieldToMatch: The part of web requests that you want AWS WAF to inspect
//    and, if you want AWS WAF to inspect a header or custom query parameter,
//    the name of the header or parameter.
//
//    * TextTransformation: Which text transformation, if any, to perform on
//    the web request before inspecting the request for snippets of malicious
//    SQL code. You can only specify a single type of TextTransformation.
//
// You use SqlInjectionMatchSet objects to specify which CloudFront requests
// that you want to allow, block, or count. For example, if you're receiving
// requests that contain snippets of SQL code in the query string and you want
// to block the requests, you can create a SqlInjectionMatchSet with the applicable
// settings, and then configure AWS WAF to block the requests.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
// Submit a CreateSqlInjectionMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateSqlInjectionMatchSet request to specify the parts of web
// requests that you want AWS WAF to inspect for snippets of SQL code.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateSqlInjectionMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateSqlInjectionMatchSet
func (c *WAF) UpdateSqlInjectionMatchSet(input *UpdateSqlInjectionMatchSetInput) (*UpdateSqlInjectionMatchSetOutput, error) {
	req, out := c.UpdateSqlInjectionMatchSetRequest(input)
	return out, req.Send()
}

// UpdateSqlInjectionMatchSetWithContext is the same as UpdateSqlInjectionMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSqlInjectionMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateSqlInjectionMatchSetWithContext(ctx aws.Context, input *UpdateSqlInjectionMatchSetInput, opts ...request.Option) (*UpdateSqlInjectionMatchSetOutput, error) {
	req, out := c.UpdateSqlInjectionMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWebACL = "UpdateWebACL"

// UpdateWebACLRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWebACL operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWebACL for more information on using the UpdateWebACL
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWebACLRequest method.
//    req, resp := client.UpdateWebACLRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateWebACL
func (c *WAF) UpdateWebACLRequest(input *UpdateWebACLInput) (req *request.Request, output *UpdateWebACLOutput) {
	op := &request.Operation{
		Name:       opUpdateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWebACLInput{}
	}

	output = &UpdateWebACLOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateWebACL API operation for AWS WAF.
//
// Inserts or deletes ActivatedRule objects in a WebACL. Each Rule identifies
// web requests that you want to allow, block, or count. When you update a WebACL,
// you specify the following values:
//
//    * A default action for the WebACL, either ALLOW or BLOCK. AWS WAF performs
//    the default action if a request doesn't match the criteria in any of the
//    Rules in a WebACL.
//
//    * The Rules that you want to add or delete. If you want to replace one
//    Rule with another, you delete the existing Rule and add the new one.
//
//    * For each Rule, whether you want AWS WAF to allow requests, block requests,
//    or count requests that match the conditions in the Rule.
//
//    * The order in which you want AWS WAF to evaluate the Rules in a WebACL.
//    If you add more than one Rule to a WebACL, AWS WAF evaluates each request
//    against the Rules in order based on the value of Priority. (The Rule that
//    has the lowest value for Priority is evaluated first.) When a web request
//    matches all the predicates (such as ByteMatchSets and IPSets) in a Rule,
//    AWS WAF immediately takes the corresponding action, allow or block, and
//    doesn't evaluate the request against the remaining Rules in the WebACL,
//    if any.
//
// To create and configure a WebACL, perform the following steps:
//
// Create and update the predicates that you want to include in Rules. For more
// information, see CreateByteMatchSet, UpdateByteMatchSet, CreateIPSet, UpdateIPSet,
// CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
//
// Create and update the Rules that you want to include in the WebACL. For more
// information, see CreateRule and UpdateRule.
//
// Create a WebACL. See CreateWebACL.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateWebACL request.
//
// Submit an UpdateWebACL request to specify the Rules that you want to include
// in the WebACL, to specify the default action, and to associate the WebACL
// with a CloudFront distribution.
//
// The ActivatedRule can be a rule group. If you specify a rule group as your
// ActivatedRule, you can exclude specific rules from that rule group.
//
// If you already have a rule group associated with a web ACL and want to submit
// an UpdateWebACL request to exclude certain rules from that rule group, you
// must first remove the rule group from the web ACL, the re-insert it again,
// specifying the excluded rules. For details, see ActivatedRule$ExcludedRules.
//
// Be aware that if you try to add a RATE_BASED rule to a web ACL without setting
// the rule type when first creating the rule, the UpdateWebACL request will
// fail because the request tries to add a REGULAR rule (the default rule type)
// with the specified ID, which does not exist.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateWebACL for usage and error information.
//
// Returned Error Types:
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * ReferencedItemException
//   The operation failed because you tried to delete an object that is still
//   in use. For example:
//
//      * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//      * You tried to delete a Rule that is still referenced by a WebACL.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
//   * SubscriptionNotFoundException
//   The specified subscription does not exist.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateWebACL
func (c *WAF) UpdateWebACL(input *UpdateWebACLInput) (*UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	return out, req.Send()
}

// UpdateWebACLWithContext is the same as UpdateWebACL with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWebACL for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateWebACLWithContext(ctx aws.Context, input *UpdateWebACLInput, opts ...request.Option) (*UpdateWebACLOutput, error) {
	req, out := c.UpdateWebACLRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateXssMatchSet = "UpdateXssMatchSet"

// UpdateXssMatchSetRequest generates a "aws/request.Request" representing the
// client's request for the UpdateXssMatchSet operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateXssMatchSet for more information on using the UpdateXssMatchSet
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateXssMatchSetRequest method.
//    req, resp := client.UpdateXssMatchSetRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateXssMatchSet
func (c *WAF) UpdateXssMatchSetRequest(input *UpdateXssMatchSetInput) (req *request.Request, output *UpdateXssMatchSetOutput) {
	op := &request.Operation{
		Name:       opUpdateXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateXssMatchSetInput{}
	}

	output = &UpdateXssMatchSetOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateXssMatchSet API operation for AWS WAF.
//
// Inserts or deletes XssMatchTuple objects (filters) in an XssMatchSet. For
// each XssMatchTuple object, you specify the following values:
//
//    * Action: Whether to insert the object into or delete the object from
//    the array. To change an XssMatchTuple, you delete the existing object
//    and add a new one.
//
//    * FieldToMatch: The part of web requests that you want AWS WAF to inspect
//    and, if you want AWS WAF to inspect a header or custom query parameter,
//    the name of the header or parameter.
//
//    * TextTransformation: Which text transformation, if any, to perform on
//    the web request before inspecting the request for cross-site scripting
//    attacks. You can only specify a single type of TextTransformation.
//
// You use XssMatchSet objects to specify which CloudFront requests that you
// want to allow, block, or count. For example, if you're receiving requests
// that contain cross-site scripting attacks in the request body and you want
// to block the requests, you can create an XssMatchSet with the applicable
// settings, and then configure AWS WAF to block the requests.
//
// To create and configure an XssMatchSet, perform the following steps:
//
// Submit a CreateXssMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateXssMatchSet request to specify the parts of web requests
// that you want AWS WAF to inspect for cross-site scripting attacks.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS WAF's
// API operation UpdateXssMatchSet for usage and error information.
//
// Returned Error Types:
//   * InternalErrorException
//   The operation failed because of a system problem, even though the request
//   was valid. Retry your request.
//
//   * InvalidAccountException
//   The operation failed because you tried to create, update, or delete an object
//   by using an invalid account identifier.
//
//   * InvalidOperationException
//   The operation failed because there was nothing to do. For example:
//
//      * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//      specified WebACL.
//
//      * You tried to remove an IP address from an IPSet, but the IP address
//      isn't in the specified IPSet.
//
//      * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//      isn't in the specified WebACL.
//
//      * You tried to add a Rule to a WebACL, but the Rule already exists in
//      the specified WebACL.
//
//      * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//      already exists in the specified WebACL.
//
//   * InvalidParameterException
//   The operation failed because AWS WAF didn't recognize a parameter in the
//   request. For example:
//
//      * You specified an invalid parameter name.
//
//      * You specified an invalid value.
//
//      * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//      using an action other than INSERT or DELETE.
//
//      * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to create a RateBasedRule with a RateKey value other than
//      IP.
//
//      * You tried to update a WebACL with a WafAction Type other than ALLOW,
//      BLOCK, or COUNT.
//
//      * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//      HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//      * You tried to update a ByteMatchSet with a Field of HEADER but no value
//      for Data.
//
//      * Your request references an ARN that is malformed, or corresponds to
//      a resource with which a web ACL cannot be associated.
//
//   * NonexistentContainerException
//   The operation failed because you tried to add an object to or delete an object
//   from another object that doesn't exist. For example:
//
//      * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//      exist.
//
//      * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//      that doesn't exist.
//
//      * You tried to add an IP address to or delete an IP address from an IPSet
//      that doesn't exist.
//
//      * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//      a ByteMatchSet that doesn't exist.
//
//   * NonexistentItemException
//   The operation failed because the referenced object doesn't exist.
//
//   * StaleDataException
//   The operation failed because you tried to create, update, or delete an object
//   by using a change token that has already been used.
//
//   * LimitsExceededException
//   The operation exceeds a resource limit, for example, the maximum number of
//   WebACL objects that you can create for an AWS account. For more information,
//   see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
//   in the AWS WAF Developer Guide.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/UpdateXssMatchSet
func (c *WAF) UpdateXssMatchSet(input *UpdateXssMatchSetInput) (*UpdateXssMatchSetOutput, error) {
	req, out := c.UpdateXssMatchSetRequest(input)
	return out, req.Send()
}

// UpdateXssMatchSetWithContext is the same as UpdateXssMatchSet with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateXssMatchSet for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WAF) UpdateXssMatchSetWithContext(ctx aws.Context, input *UpdateXssMatchSetInput, opts ...request.Option) (*UpdateXssMatchSetOutput, error) {
	req, out := c.UpdateXssMatchSetRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The ActivatedRule object in an UpdateWebACL request specifies a Rule that
// you want to insert or delete, the priority of the Rule in the WebACL, and
// the action that you want AWS WAF to take when a web request matches the Rule
// (ALLOW, BLOCK, or COUNT).
//
// To specify whether to insert or delete a Rule, use the Action parameter in
// the WebACLUpdate data type.
type ActivatedRule struct {
	_ struct{} `type:"structure"`

	// Specifies the action that CloudFront or AWS WAF takes when a web request
	// matches the conditions in the Rule. Valid values for Action include the following:
	//
	//    * ALLOW: CloudFront responds with the requested object.
	//
	//    * BLOCK: CloudFront responds with an HTTP 403 (Forbidden) status code.
	//
	//    * COUNT: AWS WAF increments a counter of requests that match the conditions
	//    in the rule and then continues to inspect the web request based on the
	//    remaining rules in the web ACL.
	//
	// ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup
	// to a WebACL. In this case, you do not use ActivatedRule|Action. For all other
	// update requests, ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.
	Action *WafAction `type:"structure"`

	// An array of rules to exclude from a rule group. This is applicable only when
	// the ActivatedRule refers to a RuleGroup.
	//
	// Sometimes it is necessary to troubleshoot rule groups that are blocking traffic
	// unexpectedly (false positives). One troubleshooting technique is to identify
	// the specific rule within the rule group that is blocking the legitimate traffic
	// and then disable (exclude) that particular rule. You can exclude rules from
	// both your own rule groups and AWS Marketplace rule groups that have been
	// associated with a web ACL.
	//
	// Specifying ExcludedRules does not remove those rules from the rule group.
	// Rather, it changes the action for the rules to COUNT. Therefore, requests
	// that match an ExcludedRule are counted but not blocked. The RuleGroup owner
	// will receive COUNT metrics for each ExcludedRule.
	//
	// If you want to exclude rules from a rule group that is already associated
	// with a web ACL, perform the following steps:
	//
	// Use the AWS WAF logs to identify the IDs of the rules that you want to exclude.
	// For more information about the logs, see Logging Web ACL Traffic Information
	// (https://docs.aws.amazon.com/waf/latest/developerguide/logging.html).
	//
	// Submit an UpdateWebACL request that has two actions:
	//
	//    * The first action deletes the existing rule group from the web ACL. That
	//    is, in the UpdateWebACL request, the first Updates:Action should be DELETE
	//    and Updates:ActivatedRule:RuleId should be the rule group that contains
	//    the rules that you want to exclude.
	//
	//    * The second action inserts the same rule group back in, but specifying
	//    the rules to exclude. That is, the second Updates:Action should be INSERT,
	//    Updates:ActivatedRule:RuleId should be the rule group that you just removed,
	//    and ExcludedRules should contain the rules that you want to exclude.
	ExcludedRules []*ExcludedRule `type:"list"`

	// Use the OverrideAction to test your RuleGroup.
	//
	// Any rule in a RuleGroup can potentially block a request. If you set the OverrideAction
	// to None, the RuleGroup will block a request if any individual rule in the
	// RuleGroup matches the request and is configured to block that request. However
	// if you first want to test the RuleGroup, set the OverrideAction to Count.
	// The RuleGroup will then override any block action specified by individual
	// rules contained within the group. Instead of blocking matching requests,
	// those requests will be counted. You can view a record of counted requests
	// using GetSampledRequests.
	//
	// ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup
	// to a WebACL. In this case you do not use ActivatedRule|Action. For all other
	// update requests, ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.
	OverrideAction *WafOverrideAction `type:"structure"`

	// Specifies the order in which the Rules in a WebACL are evaluated. Rules with
	// a lower value for Priority are evaluated before Rules with a higher value.
	// The value must be a unique integer. If you add multiple Rules to a WebACL,
	// the values don't need to be consecutive.
	//
	// Priority is a required field
	Priority *int64 `type:"integer" required:"true"`

	// The RuleId for a Rule. You use RuleId to get more information about a Rule
	// (see GetRule), update a Rule (see UpdateRule), insert a Rule into a WebACL
	// or delete a one from a WebACL (see UpdateWebACL), or delete a Rule from AWS
	// WAF (see DeleteRule).
	//
	// RuleId is returned by CreateRule and by ListRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`

	// The rule type, either REGULAR, as defined by Rule, RATE_BASED, as defined
	// by RateBasedRule, or GROUP, as defined by RuleGroup. The default is REGULAR.
	// Although this field is optional, be aware that if you try to add a RATE_BASED
	// rule to a web ACL without setting the type, the UpdateWebACL request will
	// fail because the request tries to add a REGULAR rule with the specified ID,
	// which does not exist.
	Type *string `type:"string" enum:"WafRuleType"`
}

// String returns the string representation
func (s ActivatedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ActivatedRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivatedRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivatedRule"}
	if s.Priority == nil {
		invalidParams.Add(request.NewErrParamRequired("Priority"))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.Action != nil {
		if err := s.Action.Validate(); err != nil {
			invalidParams.AddNested("Action", err.(request.ErrInvalidParams))
		}
	}
	if s.ExcludedRules != nil {
		for i, v := range s.ExcludedRules {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ExcludedRules", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.OverrideAction != nil {
		if err := s.OverrideAction.Validate(); err != nil {
			invalidParams.AddNested("OverrideAction", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ActivatedRule) SetAction(v *WafAction) *ActivatedRule {
	s.Action = v
	return s
}

// SetExcludedRules sets the ExcludedRules field's value.
func (s *ActivatedRule) SetExcludedRules(v []*ExcludedRule) *ActivatedRule {
	s.ExcludedRules = v
	return s
}

// SetOverrideAction sets the OverrideAction field's value.
func (s *ActivatedRule) SetOverrideAction(v *WafOverrideAction) *ActivatedRule {
	s.OverrideAction = v
	return s
}

// SetPriority sets the Priority field's value.
func (s *ActivatedRule) SetPriority(v int64) *ActivatedRule {
	s.Priority = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *ActivatedRule) SetRuleId(v string) *ActivatedRule {
	s.RuleId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ActivatedRule) SetType(v string) *ActivatedRule {
	s.Type = &v
	return s
}

type BadRequestException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s BadRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s BadRequestException) GoString() string {
	return s.String()
}

func newErrorBadRequestException(v protocol.ResponseMetadata) error {
	return &BadRequestException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s BadRequestException) Code() string {
	return "WAFBadRequestException"
}

// Message returns the exception's message.
func (s BadRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s BadRequestException) OrigErr() error {
	return nil
}

func (s BadRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s BadRequestException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s BadRequestException) RequestID() string {
	return s.respMetadata.RequestID
}

// In a GetByteMatchSet request, ByteMatchSet is a complex type that contains
// the ByteMatchSetId and Name of a ByteMatchSet, and the values that you specified
// when you updated the ByteMatchSet.
//
// A complex type that contains ByteMatchTuple objects, which specify the parts
// of web requests that you want AWS WAF to inspect and the values that you
// want AWS WAF to search for. If a ByteMatchSet contains more than one ByteMatchTuple
// object, a request needs to match the settings in only one ByteMatchTuple
// to be considered a match.
type ByteMatchSet struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId for a ByteMatchSet. You use ByteMatchSetId to get information
	// about a ByteMatchSet (see GetByteMatchSet), update a ByteMatchSet (see UpdateByteMatchSet),
	// insert a ByteMatchSet into a Rule or delete one from a Rule (see UpdateRule),
	// and delete a ByteMatchSet from AWS WAF (see DeleteByteMatchSet).
	//
	// ByteMatchSetId is returned by CreateByteMatchSet and by ListByteMatchSets.
	//
	// ByteMatchSetId is a required field
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// Specifies the bytes (typically a string that corresponds with ASCII characters)
	// that you want AWS WAF to search for in web requests, the location in requests
	// that you want AWS WAF to search, and other settings.
	//
	// ByteMatchTuples is a required field
	ByteMatchTuples []*ByteMatchTuple `type:"list" required:"true"`

	// A friendly name or description of the ByteMatchSet. You can't change Name
	// after you create a ByteMatchSet.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ByteMatchSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchSet) GoString() string {
	return s.String()
}

// SetByteMatchSetId sets the ByteMatchSetId field's value.
func (s *ByteMatchSet) SetByteMatchSetId(v string) *ByteMatchSet {
	s.ByteMatchSetId = &v
	return s
}

// SetByteMatchTuples sets the ByteMatchTuples field's value.
func (s *ByteMatchSet) SetByteMatchTuples(v []*ByteMatchTuple) *ByteMatchSet {
	s.ByteMatchTuples = v
	return s
}

// SetName sets the Name field's value.
func (s *ByteMatchSet) SetName(v string) *ByteMatchSet {
	s.Name = &v
	return s
}

// Returned by ListByteMatchSets. Each ByteMatchSetSummary object includes the
// Name and ByteMatchSetId for one ByteMatchSet.
type ByteMatchSetSummary struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId for a ByteMatchSet. You use ByteMatchSetId to get information
	// about a ByteMatchSet, update a ByteMatchSet, remove a ByteMatchSet from a
	// Rule, and delete a ByteMatchSet from AWS WAF.
	//
	// ByteMatchSetId is returned by CreateByteMatchSet and by ListByteMatchSets.
	//
	// ByteMatchSetId is a required field
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the ByteMatchSet. You can't change Name
	// after you create a ByteMatchSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ByteMatchSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchSetSummary) GoString() string {
	return s.String()
}

// SetByteMatchSetId sets the ByteMatchSetId field's value.
func (s *ByteMatchSetSummary) SetByteMatchSetId(v string) *ByteMatchSetSummary {
	s.ByteMatchSetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ByteMatchSetSummary) SetName(v string) *ByteMatchSetSummary {
	s.Name = &v
	return s
}

// In an UpdateByteMatchSet request, ByteMatchSetUpdate specifies whether to
// insert or delete a ByteMatchTuple and includes the settings for the ByteMatchTuple.
type ByteMatchSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert or delete a ByteMatchTuple.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Information about the part of a web request that you want AWS WAF to inspect
	// and the value that you want AWS WAF to search for. If you specify DELETE
	// for the value of Action, the ByteMatchTuple values must exactly match the
	// values in the ByteMatchTuple that you want to delete from the ByteMatchSet.
	//
	// ByteMatchTuple is a required field
	ByteMatchTuple *ByteMatchTuple `type:"structure" required:"true"`
}

// String returns the string representation
func (s ByteMatchSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchSetUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ByteMatchSetUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ByteMatchSetUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ByteMatchTuple == nil {
		invalidParams.Add(request.NewErrParamRequired("ByteMatchTuple"))
	}
	if s.ByteMatchTuple != nil {
		if err := s.ByteMatchTuple.Validate(); err != nil {
			invalidParams.AddNested("ByteMatchTuple", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *ByteMatchSetUpdate) SetAction(v string) *ByteMatchSetUpdate {
	s.Action = &v
	return s
}

// SetByteMatchTuple sets the ByteMatchTuple field's value.
func (s *ByteMatchSetUpdate) SetByteMatchTuple(v *ByteMatchTuple) *ByteMatchSetUpdate {
	s.ByteMatchTuple = v
	return s
}

// The bytes (typically a string that corresponds with ASCII characters) that
// you want AWS WAF to search for in web requests, the location in requests
// that you want AWS WAF to search, and other settings.
type ByteMatchTuple struct {
	_ struct{} `type:"structure"`

	// The part of a web request that you want AWS WAF to search, such as a specified
	// header or a query string. For more information, see FieldToMatch.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Within the portion of a web request that you want to search (for example,
	// in the query string, if any), specify where you want AWS WAF to search. Valid
	// values include the following:
	//
	// CONTAINS
	//
	// The specified part of the web request must include the value of TargetString,
	// but the location doesn't matter.
	//
	// CONTAINS_WORD
	//
	// The specified part of the web request must include the value of TargetString,
	// and TargetString must contain only alphanumeric characters or underscore
	// (A-Z, a-z, 0-9, or _). In addition, TargetString must be a word, which means
	// one of the following:
	//
	//    * TargetString exactly matches the value of the specified part of the
	//    web request, such as the value of a header.
	//
	//    * TargetString is at the beginning of the specified part of the web request
	//    and is followed by a character other than an alphanumeric character or
	//    underscore (_), for example, BadBot;.
	//
	//    * TargetString is at the end of the specified part of the web request
	//    and is preceded by a character other than an alphanumeric character or
	//    underscore (_), for example, ;BadBot.
	//
	//    * TargetString is in the middle of the specified part of the web request
	//    and is preceded and followed by characters other than alphanumeric characters
	//    or underscore (_), for example, -BadBot;.
	//
	// EXACTLY
	//
	// The value of the specified part of the web request must exactly match the
	// value of TargetString.
	//
	// STARTS_WITH
	//
	// The value of TargetString must appear at the beginning of the specified part
	// of the web request.
	//
	// ENDS_WITH
	//
	// The value of TargetString must appear at the end of the specified part of
	// the web request.
	//
	// PositionalConstraint is a required field
	PositionalConstraint *string `type:"string" required:"true" enum:"PositionalConstraint"`

	// The value that you want AWS WAF to search for. AWS WAF searches for the specified
	// string in the part of web requests that you specified in FieldToMatch. The
	// maximum length of the value is 50 bytes.
	//
	// Valid values depend on the values that you specified for FieldToMatch:
	//
	//    * HEADER: The value that you want AWS WAF to search for in the request
	//    header that you specified in FieldToMatch, for example, the value of the
	//    User-Agent or Referer header.
	//
	//    * METHOD: The HTTP method, which indicates the type of operation specified
	//    in the request. CloudFront supports the following methods: DELETE, GET,
	//    HEAD, OPTIONS, PATCH, POST, and PUT.
	//
	//    * QUERY_STRING: The value that you want AWS WAF to search for in the query
	//    string, which is the part of a URL that appears after a ? character.
	//
	//    * URI: The value that you want AWS WAF to search for in the part of a
	//    URL that identifies a resource, for example, /images/daily-ad.jpg.
	//
	//    * BODY: The part of a request that contains any additional data that you
	//    want to send to your web server as the HTTP request body, such as data
	//    from a form. The request body immediately follows the request headers.
	//    Note that only the first 8192 bytes of the request body are forwarded
	//    to AWS WAF for inspection. To allow or block requests based on the length
	//    of the body, you can create a size constraint set. For more information,
	//    see CreateSizeConstraintSet.
	//
	//    * SINGLE_QUERY_ARG: The parameter in the query string that you will inspect,
	//    such as UserName or SalesRegion. The maximum length for SINGLE_QUERY_ARG
	//    is 30 characters.
	//
	//    * ALL_QUERY_ARGS: Similar to SINGLE_QUERY_ARG, but instead of inspecting
	//    a single parameter, AWS WAF inspects all parameters within the query string
	//    for the value or regex pattern that you specify in TargetString.
	//
	// If TargetString includes alphabetic characters A-Z and a-z, note that the
	// value is case sensitive.
	//
	// If you're using the AWS WAF API
	//
	// Specify a base64-encoded version of the value. The maximum length of the
	// value before you base64-encode it is 50 bytes.
	//
	// For example, suppose the value of Type is HEADER and the value of Data is
	// User-Agent. If you want to search the User-Agent header for the value BadBot,
	// you base64-encode BadBot using MIME base64-encoding and include the resulting
	// value, QmFkQm90, in the value of TargetString.
	//
	// If you're using the AWS CLI or one of the AWS SDKs
	//
	// The value that you want AWS WAF to search for. The SDK automatically base64
	// encodes the value.
	//
	// TargetString is automatically base64 encoded/decoded by the SDK.
	//
	// TargetString is a required field
	TargetString []byte `type:"blob" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass AWS WAF. If you specify a transformation,
	// AWS WAF performs the transformation on TargetString before inspecting a request
	// for a match.
	//
	// You can only specify a single type of TextTransformation.
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system command
	// line command and using unusual formatting to disguise some or all of the
	// command, use this option to perform the following transformations:
	//
	//    * Delete the following characters: \ " ' ^
	//
	//    * Delete spaces before the following characters: / (
	//
	//    * Replace the following characters with a space: , ;
	//
	//    * Replace multiple spaces with one space
	//
	//    * Convert uppercase letters (A-Z) to lowercase (a-z)
	//
	// COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//    * \f, formfeed, decimal 12
	//
	//    * \t, tab, decimal 9
	//
	//    * \n, newline, decimal 10
	//
	//    * \r, carriage return, decimal 13
	//
	//    * \v, vertical tab, decimal 11
	//
	//    * non-breaking space, decimal 160
	//
	// COMPRESS_WHITE_SPACE also replaces multiple spaces with one space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//    * Replaces (ampersand)quot; with "
	//
	//    * Replaces (ampersand)nbsp; with a non-breaking space, decimal 160
	//
	//    * Replaces (ampersand)lt; with a "less than" symbol
	//
	//    * Replaces (ampersand)gt; with >
	//
	//    * Replaces characters that are represented in hexadecimal format, (ampersand)#xhhhh;,
	//    with the corresponding characters
	//
	//    * Replaces characters that are represented in decimal format, (ampersand)#nnnn;,
	//    with the corresponding characters
	//
	// LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	//
	// NONE
	//
	// Specify NONE if you don't want to perform any text transformations.
	//
	// TextTransformation is a required field
	TextTransformation *string `type:"string" required:"true" enum:"TextTransformation"`
}

// String returns the string representation
func (s ByteMatchTuple) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ByteMatchTuple) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ByteMatchTuple) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ByteMatchTuple"}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.PositionalConstraint == nil {
		invalidParams.Add(request.NewErrParamRequired("PositionalConstraint"))
	}
	if s.TargetString == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetString"))
	}
	if s.TextTransformation == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformation"))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *ByteMatchTuple) SetFieldToMatch(v *FieldToMatch) *ByteMatchTuple {
	s.FieldToMatch = v
	return s
}

// SetPositionalConstraint sets the PositionalConstraint field's value.
func (s *ByteMatchTuple) SetPositionalConstraint(v string) *ByteMatchTuple {
	s.PositionalConstraint = &v
	return s
}

// SetTargetString sets the TargetString field's value.
func (s *ByteMatchTuple) SetTargetString(v []byte) *ByteMatchTuple {
	s.TargetString = v
	return s
}

// SetTextTransformation sets the TextTransformation field's value.
func (s *ByteMatchTuple) SetTextTransformation(v string) *ByteMatchTuple {
	s.TextTransformation = &v
	return s
}

type CreateByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the ByteMatchSet. You can't change Name
	// after you create a ByteMatchSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateByteMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateByteMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateByteMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateByteMatchSetInput) SetChangeToken(v string) *CreateByteMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateByteMatchSetInput) SetName(v string) *CreateByteMatchSetInput {
	s.Name = &v
	return s
}

type CreateByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// A ByteMatchSet that contains no ByteMatchTuple objects.
	ByteMatchSet *ByteMatchSet `type:"structure"`

	// The ChangeToken that you used to submit the CreateByteMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s CreateByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateByteMatchSetOutput) GoString() string {
	return s.String()
}

// SetByteMatchSet sets the ByteMatchSet field's value.
func (s *CreateByteMatchSetOutput) SetByteMatchSet(v *ByteMatchSet) *CreateByteMatchSetOutput {
	s.ByteMatchSet = v
	return s
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateByteMatchSetOutput) SetChangeToken(v string) *CreateByteMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type CreateGeoMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the GeoMatchSet. You can't change Name
	// after you create the GeoMatchSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateGeoMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGeoMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateGeoMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateGeoMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateGeoMatchSetInput) SetChangeToken(v string) *CreateGeoMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateGeoMatchSetInput) SetName(v string) *CreateGeoMatchSetInput {
	s.Name = &v
	return s
}

type CreateGeoMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateGeoMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// The GeoMatchSet returned in the CreateGeoMatchSet response. The GeoMatchSet
	// contains no GeoMatchConstraints.
	GeoMatchSet *GeoMatchSet `type:"structure"`
}

// String returns the string representation
func (s CreateGeoMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateGeoMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateGeoMatchSetOutput) SetChangeToken(v string) *CreateGeoMatchSetOutput {
	s.ChangeToken = &v
	return s
}

// SetGeoMatchSet sets the GeoMatchSet field's value.
func (s *CreateGeoMatchSetOutput) SetGeoMatchSet(v *GeoMatchSet) *CreateGeoMatchSetOutput {
	s.GeoMatchSet = v
	return s
}

type CreateIPSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the IPSet. You can't change Name after
	// you create the IPSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIPSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateIPSetInput) SetChangeToken(v string) *CreateIPSetInput {
	s.ChangeToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateIPSetInput) SetName(v string) *CreateIPSetInput {
	s.Name = &v
	return s
}

type CreateIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateIPSet request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// The IPSet returned in the CreateIPSet response.
	IPSet *IPSet `type:"structure"`
}

// String returns the string representation
func (s CreateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateIPSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateIPSetOutput) SetChangeToken(v string) *CreateIPSetOutput {
	s.ChangeToken = &v
	return s
}

// SetIPSet sets the IPSet field's value.
func (s *CreateIPSetOutput) SetIPSet(v *IPSet) *CreateIPSetOutput {
	s.IPSet = v
	return s
}

type CreateRateBasedRuleInput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateRateBasedRule request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description for the metrics for this RateBasedRule. The
	// name can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum
	// length 128 and minimum length one. It can't contain whitespace or metric
	// names reserved for AWS WAF, including "All" and "Default_Action." You can't
	// change the name of the metric after you create the RateBasedRule.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// A friendly name or description of the RateBasedRule. You can't change the
	// name of a RateBasedRule after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The field that AWS WAF uses to determine if requests are likely arriving
	// from a single source and thus subject to rate monitoring. The only valid
	// value for RateKey is IP. IP indicates that requests that arrive from the
	// same IP address are subject to the RateLimit that is specified in the RateBasedRule.
	//
	// RateKey is a required field
	RateKey *string `type:"string" required:"true" enum:"RateKey"`

	// The maximum number of requests, which have an identical value in the field
	// that is specified by RateKey, allowed in a five-minute period. If the number
	// of requests exceeds the RateLimit and the other predicates specified in the
	// rule are also met, AWS WAF triggers the action that is specified for this
	// rule.
	//
	// RateLimit is a required field
	RateLimit *int64 `min:"100" type:"long" required:"true"`

	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateRateBasedRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRateBasedRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRateBasedRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRateBasedRuleInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.RateKey == nil {
		invalidParams.Add(request.NewErrParamRequired("RateKey"))
	}
	if s.RateLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("RateLimit"))
	}
	if s.RateLimit != nil && *s.RateLimit < 100 {
		invalidParams.Add(request.NewErrParamMinValue("RateLimit", 100))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRateBasedRuleInput) SetChangeToken(v string) *CreateRateBasedRuleInput {
	s.ChangeToken = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CreateRateBasedRuleInput) SetMetricName(v string) *CreateRateBasedRuleInput {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRateBasedRuleInput) SetName(v string) *CreateRateBasedRuleInput {
	s.Name = &v
	return s
}

// SetRateKey sets the RateKey field's value.
func (s *CreateRateBasedRuleInput) SetRateKey(v string) *CreateRateBasedRuleInput {
	s.RateKey = &v
	return s
}

// SetRateLimit sets the RateLimit field's value.
func (s *CreateRateBasedRuleInput) SetRateLimit(v int64) *CreateRateBasedRuleInput {
	s.RateLimit = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRateBasedRuleInput) SetTags(v []*Tag) *CreateRateBasedRuleInput {
	s.Tags = v
	return s
}

type CreateRateBasedRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateRateBasedRule request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// The RateBasedRule that is returned in the CreateRateBasedRule response.
	Rule *RateBasedRule `type:"structure"`
}

// String returns the string representation
func (s CreateRateBasedRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRateBasedRuleOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRateBasedRuleOutput) SetChangeToken(v string) *CreateRateBasedRuleOutput {
	s.ChangeToken = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *CreateRateBasedRuleOutput) SetRule(v *RateBasedRule) *CreateRateBasedRuleOutput {
	s.Rule = v
	return s
}

type CreateRegexMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the RegexMatchSet. You can't change Name
	// after you create a RegexMatchSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRegexMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRegexMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRegexMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRegexMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRegexMatchSetInput) SetChangeToken(v string) *CreateRegexMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRegexMatchSetInput) SetName(v string) *CreateRegexMatchSetInput {
	s.Name = &v
	return s
}

type CreateRegexMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateRegexMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// A RegexMatchSet that contains no RegexMatchTuple objects.
	RegexMatchSet *RegexMatchSet `type:"structure"`
}

// String returns the string representation
func (s CreateRegexMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRegexMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRegexMatchSetOutput) SetChangeToken(v string) *CreateRegexMatchSetOutput {
	s.ChangeToken = &v
	return s
}

// SetRegexMatchSet sets the RegexMatchSet field's value.
func (s *CreateRegexMatchSetOutput) SetRegexMatchSet(v *RegexMatchSet) *CreateRegexMatchSetOutput {
	s.RegexMatchSet = v
	return s
}

type CreateRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the RegexPatternSet. You can't change Name
	// after you create a RegexPatternSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRegexPatternSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRegexPatternSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRegexPatternSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRegexPatternSetInput) SetChangeToken(v string) *CreateRegexPatternSetInput {
	s.ChangeToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRegexPatternSetInput) SetName(v string) *CreateRegexPatternSetInput {
	s.Name = &v
	return s
}

type CreateRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateRegexPatternSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// A RegexPatternSet that contains no objects.
	RegexPatternSet *RegexPatternSet `type:"structure"`
}

// String returns the string representation
func (s CreateRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRegexPatternSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRegexPatternSetOutput) SetChangeToken(v string) *CreateRegexPatternSetOutput {
	s.ChangeToken = &v
	return s
}

// SetRegexPatternSet sets the RegexPatternSet field's value.
func (s *CreateRegexPatternSetOutput) SetRegexPatternSet(v *RegexPatternSet) *CreateRegexPatternSetOutput {
	s.RegexPatternSet = v
	return s
}

type CreateRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description for the metrics for this RuleGroup. The name
	// can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change the name
	// of the metric after you create the RuleGroup.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// A friendly name or description of the RuleGroup. You can't change Name after
	// you create a RuleGroup.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleGroupInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRuleGroupInput) SetChangeToken(v string) *CreateRuleGroupInput {
	s.ChangeToken = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CreateRuleGroupInput) SetMetricName(v string) *CreateRuleGroupInput {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRuleGroupInput) SetName(v string) *CreateRuleGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleGroupInput) SetTags(v []*Tag) *CreateRuleGroupInput {
	s.Tags = v
	return s
}

type CreateRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateRuleGroup request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// An empty RuleGroup.
	RuleGroup *RuleGroup `type:"structure"`
}

// String returns the string representation
func (s CreateRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleGroupOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRuleGroupOutput) SetChangeToken(v string) *CreateRuleGroupOutput {
	s.ChangeToken = &v
	return s
}

// SetRuleGroup sets the RuleGroup field's value.
func (s *CreateRuleGroupOutput) SetRuleGroup(v *RuleGroup) *CreateRuleGroupOutput {
	s.RuleGroup = v
	return s
}

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description for the metrics for this Rule. The name can
	// contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change the name
	// of the metric after you create the Rule.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// A friendly name or description of the Rule. You can't change the name of
	// a Rule after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRuleInput) SetChangeToken(v string) *CreateRuleInput {
	s.ChangeToken = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CreateRuleInput) SetMetricName(v string) *CreateRuleInput {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRuleInput) SetName(v string) *CreateRuleInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleInput) SetTags(v []*Tag) *CreateRuleInput {
	s.Tags = v
	return s
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateRule request. You can also
	// use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// The Rule returned in the CreateRule response.
	Rule *Rule `type:"structure"`
}

// String returns the string representation
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateRuleOutput) SetChangeToken(v string) *CreateRuleOutput {
	s.ChangeToken = &v
	return s
}

// SetRule sets the Rule field's value.
func (s *CreateRuleOutput) SetRule(v *Rule) *CreateRuleOutput {
	s.Rule = v
	return s
}

type CreateSizeConstraintSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the SizeConstraintSet. You can't change
	// Name after you create a SizeConstraintSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSizeConstraintSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSizeConstraintSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSizeConstraintSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSizeConstraintSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateSizeConstraintSetInput) SetChangeToken(v string) *CreateSizeConstraintSetInput {
	s.ChangeToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSizeConstraintSetInput) SetName(v string) *CreateSizeConstraintSetInput {
	s.Name = &v
	return s
}

type CreateSizeConstraintSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateSizeConstraintSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// A SizeConstraintSet that contains no SizeConstraint objects.
	SizeConstraintSet *SizeConstraintSet `type:"structure"`
}

// String returns the string representation
func (s CreateSizeConstraintSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSizeConstraintSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateSizeConstraintSetOutput) SetChangeToken(v string) *CreateSizeConstraintSetOutput {
	s.ChangeToken = &v
	return s
}

// SetSizeConstraintSet sets the SizeConstraintSet field's value.
func (s *CreateSizeConstraintSetOutput) SetSizeConstraintSet(v *SizeConstraintSet) *CreateSizeConstraintSetOutput {
	s.SizeConstraintSet = v
	return s
}

// A request to create a SqlInjectionMatchSet.
type CreateSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description for the SqlInjectionMatchSet that you're creating.
	// You can't change Name after you create the SqlInjectionMatchSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSqlInjectionMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSqlInjectionMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSqlInjectionMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateSqlInjectionMatchSetInput) SetChangeToken(v string) *CreateSqlInjectionMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateSqlInjectionMatchSetInput) SetName(v string) *CreateSqlInjectionMatchSetInput {
	s.Name = &v
	return s
}

// The response to a CreateSqlInjectionMatchSet request.
type CreateSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateSqlInjectionMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// A SqlInjectionMatchSet.
	SqlInjectionMatchSet *SqlInjectionMatchSet `type:"structure"`
}

// String returns the string representation
func (s CreateSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateSqlInjectionMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateSqlInjectionMatchSetOutput) SetChangeToken(v string) *CreateSqlInjectionMatchSetOutput {
	s.ChangeToken = &v
	return s
}

// SetSqlInjectionMatchSet sets the SqlInjectionMatchSet field's value.
func (s *CreateSqlInjectionMatchSetOutput) SetSqlInjectionMatchSet(v *SqlInjectionMatchSet) *CreateSqlInjectionMatchSetOutput {
	s.SqlInjectionMatchSet = v
	return s
}

type CreateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The action that you want AWS WAF to take when a request doesn't match the
	// criteria specified in any of the Rule objects that are associated with the
	// WebACL.
	//
	// DefaultAction is a required field
	DefaultAction *WafAction `type:"structure" required:"true"`

	// A friendly name or description for the metrics for this WebACL.The name can
	// contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change MetricName
	// after you create the WebACL.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// A friendly name or description of the WebACL. You can't change Name after
	// you create the WebACL.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	Tags []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s CreateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWebACLInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.DefaultAction == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultAction"))
	}
	if s.MetricName == nil {
		invalidParams.Add(request.NewErrParamRequired("MetricName"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.DefaultAction != nil {
		if err := s.DefaultAction.Validate(); err != nil {
			invalidParams.AddNested("DefaultAction", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateWebACLInput) SetChangeToken(v string) *CreateWebACLInput {
	s.ChangeToken = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *CreateWebACLInput) SetDefaultAction(v *WafAction) *CreateWebACLInput {
	s.DefaultAction = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *CreateWebACLInput) SetMetricName(v string) *CreateWebACLInput {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateWebACLInput) SetName(v string) *CreateWebACLInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWebACLInput) SetTags(v []*Tag) *CreateWebACLInput {
	s.Tags = v
	return s
}

type CreateWebACLOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateWebACL request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// The WebACL returned in the CreateWebACL response.
	WebACL *WebACL `type:"structure"`
}

// String returns the string representation
func (s CreateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebACLOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateWebACLOutput) SetChangeToken(v string) *CreateWebACLOutput {
	s.ChangeToken = &v
	return s
}

// SetWebACL sets the WebACL field's value.
func (s *CreateWebACLOutput) SetWebACL(v *WebACL) *CreateWebACLOutput {
	s.WebACL = v
	return s
}

// A request to create an XssMatchSet.
type CreateXssMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A friendly name or description for the XssMatchSet that you're creating.
	// You can't change Name after you create the XssMatchSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateXssMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateXssMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateXssMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateXssMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateXssMatchSetInput) SetChangeToken(v string) *CreateXssMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateXssMatchSetInput) SetName(v string) *CreateXssMatchSetInput {
	s.Name = &v
	return s
}

// The response to a CreateXssMatchSet request.
type CreateXssMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the CreateXssMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`

	// An XssMatchSet.
	XssMatchSet *XssMatchSet `type:"structure"`
}

// String returns the string representation
func (s CreateXssMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateXssMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *CreateXssMatchSetOutput) SetChangeToken(v string) *CreateXssMatchSetOutput {
	s.ChangeToken = &v
	return s
}

// SetXssMatchSet sets the XssMatchSet field's value.
func (s *CreateXssMatchSetOutput) SetXssMatchSet(v *XssMatchSet) *CreateXssMatchSetOutput {
	s.XssMatchSet = v
	return s
}

type DeleteByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId of the ByteMatchSet that you want to delete. ByteMatchSetId
	// is returned by CreateByteMatchSet and by ListByteMatchSets.
	//
	// ByteMatchSetId is a required field
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteByteMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteByteMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteByteMatchSetInput"}
	if s.ByteMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ByteMatchSetId"))
	}
	if s.ByteMatchSetId != nil && len(*s.ByteMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ByteMatchSetId", 1))
	}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByteMatchSetId sets the ByteMatchSetId field's value.
func (s *DeleteByteMatchSetInput) SetByteMatchSetId(v string) *DeleteByteMatchSetInput {
	s.ByteMatchSetId = &v
	return s
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteByteMatchSetInput) SetChangeToken(v string) *DeleteByteMatchSetInput {
	s.ChangeToken = &v
	return s
}

type DeleteByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteByteMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteByteMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteByteMatchSetOutput) SetChangeToken(v string) *DeleteByteMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type DeleteGeoMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The GeoMatchSetID of the GeoMatchSet that you want to delete. GeoMatchSetId
	// is returned by CreateGeoMatchSet and by ListGeoMatchSets.
	//
	// GeoMatchSetId is a required field
	GeoMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteGeoMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGeoMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteGeoMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteGeoMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.GeoMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeoMatchSetId"))
	}
	if s.GeoMatchSetId != nil && len(*s.GeoMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeoMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteGeoMatchSetInput) SetChangeToken(v string) *DeleteGeoMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetGeoMatchSetId sets the GeoMatchSetId field's value.
func (s *DeleteGeoMatchSetInput) SetGeoMatchSetId(v string) *DeleteGeoMatchSetInput {
	s.GeoMatchSetId = &v
	return s
}

type DeleteGeoMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteGeoMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteGeoMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteGeoMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteGeoMatchSetOutput) SetChangeToken(v string) *DeleteGeoMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type DeleteIPSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The IPSetId of the IPSet that you want to delete. IPSetId is returned by
	// CreateIPSet and by ListIPSets.
	//
	// IPSetId is a required field
	IPSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIPSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.IPSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IPSetId"))
	}
	if s.IPSetId != nil && len(*s.IPSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IPSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteIPSetInput) SetChangeToken(v string) *DeleteIPSetInput {
	s.ChangeToken = &v
	return s
}

// SetIPSetId sets the IPSetId field's value.
func (s *DeleteIPSetInput) SetIPSetId(v string) *DeleteIPSetInput {
	s.IPSetId = &v
	return s
}

type DeleteIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteIPSet request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteIPSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteIPSetOutput) SetChangeToken(v string) *DeleteIPSetOutput {
	s.ChangeToken = &v
	return s
}

type DeleteLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the web ACL from which you want to delete
	// the LoggingConfiguration.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteLoggingConfigurationInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeleteLoggingConfigurationInput) SetResourceArn(v string) *DeleteLoggingConfigurationInput {
	s.ResourceArn = &v
	return s
}

type DeleteLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteLoggingConfigurationOutput) GoString() string {
	return s.String()
}

type DeletePermissionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RuleGroup from which you want to delete
	// the policy.
	//
	// The user making the request must be the owner of the RuleGroup.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeletePermissionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePermissionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeletePermissionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeletePermissionPolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DeletePermissionPolicyInput) SetResourceArn(v string) *DeletePermissionPolicyInput {
	s.ResourceArn = &v
	return s
}

type DeletePermissionPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeletePermissionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeletePermissionPolicyOutput) GoString() string {
	return s.String()
}

type DeleteRateBasedRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RuleId of the RateBasedRule that you want to delete. RuleId is returned
	// by CreateRateBasedRule and by ListRateBasedRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRateBasedRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRateBasedRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRateBasedRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRateBasedRuleInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRateBasedRuleInput) SetChangeToken(v string) *DeleteRateBasedRuleInput {
	s.ChangeToken = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *DeleteRateBasedRuleInput) SetRuleId(v string) *DeleteRateBasedRuleInput {
	s.RuleId = &v
	return s
}

type DeleteRateBasedRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteRateBasedRule request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteRateBasedRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRateBasedRuleOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRateBasedRuleOutput) SetChangeToken(v string) *DeleteRateBasedRuleOutput {
	s.ChangeToken = &v
	return s
}

type DeleteRegexMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RegexMatchSetId of the RegexMatchSet that you want to delete. RegexMatchSetId
	// is returned by CreateRegexMatchSet and by ListRegexMatchSets.
	//
	// RegexMatchSetId is a required field
	RegexMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRegexMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegexMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRegexMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRegexMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RegexMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexMatchSetId"))
	}
	if s.RegexMatchSetId != nil && len(*s.RegexMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRegexMatchSetInput) SetChangeToken(v string) *DeleteRegexMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetRegexMatchSetId sets the RegexMatchSetId field's value.
func (s *DeleteRegexMatchSetInput) SetRegexMatchSetId(v string) *DeleteRegexMatchSetInput {
	s.RegexMatchSetId = &v
	return s
}

type DeleteRegexMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteRegexMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteRegexMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegexMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRegexMatchSetOutput) SetChangeToken(v string) *DeleteRegexMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type DeleteRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RegexPatternSetId of the RegexPatternSet that you want to delete. RegexPatternSetId
	// is returned by CreateRegexPatternSet and by ListRegexPatternSets.
	//
	// RegexPatternSetId is a required field
	RegexPatternSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegexPatternSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRegexPatternSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRegexPatternSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RegexPatternSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexPatternSetId"))
	}
	if s.RegexPatternSetId != nil && len(*s.RegexPatternSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexPatternSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRegexPatternSetInput) SetChangeToken(v string) *DeleteRegexPatternSetInput {
	s.ChangeToken = &v
	return s
}

// SetRegexPatternSetId sets the RegexPatternSetId field's value.
func (s *DeleteRegexPatternSetInput) SetRegexPatternSetId(v string) *DeleteRegexPatternSetInput {
	s.RegexPatternSetId = &v
	return s
}

type DeleteRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteRegexPatternSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRegexPatternSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRegexPatternSetOutput) SetChangeToken(v string) *DeleteRegexPatternSetOutput {
	s.ChangeToken = &v
	return s
}

type DeleteRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RuleGroupId of the RuleGroup that you want to delete. RuleGroupId is
	// returned by CreateRuleGroup and by ListRuleGroups.
	//
	// RuleGroupId is a required field
	RuleGroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleGroupInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleGroupId"))
	}
	if s.RuleGroupId != nil && len(*s.RuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRuleGroupInput) SetChangeToken(v string) *DeleteRuleGroupInput {
	s.ChangeToken = &v
	return s
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *DeleteRuleGroupInput) SetRuleGroupId(v string) *DeleteRuleGroupInput {
	s.RuleGroupId = &v
	return s
}

type DeleteRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteRuleGroup request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleGroupOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRuleGroupOutput) SetChangeToken(v string) *DeleteRuleGroupOutput {
	s.ChangeToken = &v
	return s
}

type DeleteRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RuleId of the Rule that you want to delete. RuleId is returned by CreateRule
	// and by ListRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteRuleInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRuleInput) SetChangeToken(v string) *DeleteRuleInput {
	s.ChangeToken = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *DeleteRuleInput) SetRuleId(v string) *DeleteRuleInput {
	s.RuleId = &v
	return s
}

type DeleteRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteRule request. You can also
	// use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteRuleOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteRuleOutput) SetChangeToken(v string) *DeleteRuleOutput {
	s.ChangeToken = &v
	return s
}

type DeleteSizeConstraintSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The SizeConstraintSetId of the SizeConstraintSet that you want to delete.
	// SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	//
	// SizeConstraintSetId is a required field
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSizeConstraintSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSizeConstraintSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSizeConstraintSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSizeConstraintSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.SizeConstraintSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeConstraintSetId"))
	}
	if s.SizeConstraintSetId != nil && len(*s.SizeConstraintSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SizeConstraintSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteSizeConstraintSetInput) SetChangeToken(v string) *DeleteSizeConstraintSetInput {
	s.ChangeToken = &v
	return s
}

// SetSizeConstraintSetId sets the SizeConstraintSetId field's value.
func (s *DeleteSizeConstraintSetInput) SetSizeConstraintSetId(v string) *DeleteSizeConstraintSetInput {
	s.SizeConstraintSetId = &v
	return s
}

type DeleteSizeConstraintSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteSizeConstraintSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSizeConstraintSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSizeConstraintSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteSizeConstraintSetOutput) SetChangeToken(v string) *DeleteSizeConstraintSetOutput {
	s.ChangeToken = &v
	return s
}

// A request to delete a SqlInjectionMatchSet from AWS WAF.
type DeleteSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The SqlInjectionMatchSetId of the SqlInjectionMatchSet that you want to delete.
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	//
	// SqlInjectionMatchSetId is a required field
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSqlInjectionMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteSqlInjectionMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteSqlInjectionMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.SqlInjectionMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlInjectionMatchSetId"))
	}
	if s.SqlInjectionMatchSetId != nil && len(*s.SqlInjectionMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqlInjectionMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteSqlInjectionMatchSetInput) SetChangeToken(v string) *DeleteSqlInjectionMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetSqlInjectionMatchSetId sets the SqlInjectionMatchSetId field's value.
func (s *DeleteSqlInjectionMatchSetInput) SetSqlInjectionMatchSetId(v string) *DeleteSqlInjectionMatchSetInput {
	s.SqlInjectionMatchSetId = &v
	return s
}

// The response to a request to delete a SqlInjectionMatchSet from AWS WAF.
type DeleteSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteSqlInjectionMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteSqlInjectionMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteSqlInjectionMatchSetOutput) SetChangeToken(v string) *DeleteSqlInjectionMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type DeleteWebACLInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The WebACLId of the WebACL that you want to delete. WebACLId is returned
	// by CreateWebACL and by ListWebACLs.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWebACLInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteWebACLInput) SetChangeToken(v string) *DeleteWebACLInput {
	s.ChangeToken = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *DeleteWebACLInput) SetWebACLId(v string) *DeleteWebACLInput {
	s.WebACLId = &v
	return s
}

type DeleteWebACLOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteWebACL request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteWebACLOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteWebACLOutput) SetChangeToken(v string) *DeleteWebACLOutput {
	s.ChangeToken = &v
	return s
}

// A request to delete an XssMatchSet from AWS WAF.
type DeleteXssMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The XssMatchSetId of the XssMatchSet that you want to delete. XssMatchSetId
	// is returned by CreateXssMatchSet and by ListXssMatchSets.
	//
	// XssMatchSetId is a required field
	XssMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteXssMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteXssMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteXssMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteXssMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.XssMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("XssMatchSetId"))
	}
	if s.XssMatchSetId != nil && len(*s.XssMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("XssMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteXssMatchSetInput) SetChangeToken(v string) *DeleteXssMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetXssMatchSetId sets the XssMatchSetId field's value.
func (s *DeleteXssMatchSetInput) SetXssMatchSetId(v string) *DeleteXssMatchSetInput {
	s.XssMatchSetId = &v
	return s
}

// The response to a request to delete an XssMatchSet from AWS WAF.
type DeleteXssMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the DeleteXssMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s DeleteXssMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DeleteXssMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *DeleteXssMatchSetOutput) SetChangeToken(v string) *DeleteXssMatchSetOutput {
	s.ChangeToken = &v
	return s
}

// The name specified is invalid.
type DisallowedNameException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s DisallowedNameException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s DisallowedNameException) GoString() string {
	return s.String()
}

func newErrorDisallowedNameException(v protocol.ResponseMetadata) error {
	return &DisallowedNameException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s DisallowedNameException) Code() string {
	return "WAFDisallowedNameException"
}

// Message returns the exception's message.
func (s DisallowedNameException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s DisallowedNameException) OrigErr() error {
	return nil
}

func (s DisallowedNameException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s DisallowedNameException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s DisallowedNameException) RequestID() string {
	return s.respMetadata.RequestID
}

// The rule to exclude from a rule group. This is applicable only when the ActivatedRule
// refers to a RuleGroup. The rule must belong to the RuleGroup that is specified
// by the ActivatedRule.
type ExcludedRule struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the rule to exclude from the rule group.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ExcludedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ExcludedRule) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExcludedRule) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExcludedRule"}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleId sets the RuleId field's value.
func (s *ExcludedRule) SetRuleId(v string) *ExcludedRule {
	s.RuleId = &v
	return s
}

// Specifies where in a web request to look for TargetString.
type FieldToMatch struct {
	_ struct{} `type:"structure"`

	// When the value of Type is HEADER, enter the name of the header that you want
	// AWS WAF to search, for example, User-Agent or Referer. The name of the header
	// is not case sensitive.
	//
	// When the value of Type is SINGLE_QUERY_ARG, enter the name of the parameter
	// that you want AWS WAF to search, for example, UserName or SalesRegion. The
	// parameter name is not case sensitive.
	//
	// If the value of Type is any other value, omit Data.
	Data *string `type:"string"`

	// The part of the web request that you want AWS WAF to search for a specified
	// string. Parts of a request that you can search include the following:
	//
	//    * HEADER: A specified request header, for example, the value of the User-Agent
	//    or Referer header. If you choose HEADER for the type, specify the name
	//    of the header in Data.
	//
	//    * METHOD: The HTTP method, which indicated the type of operation that
	//    the request is asking the origin to perform. Amazon CloudFront supports
	//    the following methods: DELETE, GET, HEAD, OPTIONS, PATCH, POST, and PUT.
	//
	//    * QUERY_STRING: A query string, which is the part of a URL that appears
	//    after a ? character, if any.
	//
	//    * URI: The part of a web request that identifies a resource, for example,
	//    /images/daily-ad.jpg.
	//
	//    * BODY: The part of a request that contains any additional data that you
	//    want to send to your web server as the HTTP request body, such as data
	//    from a form. The request body immediately follows the request headers.
	//    Note that only the first 8192 bytes of the request body are forwarded
	//    to AWS WAF for inspection. To allow or block requests based on the length
	//    of the body, you can create a size constraint set. For more information,
	//    see CreateSizeConstraintSet.
	//
	//    * SINGLE_QUERY_ARG: The parameter in the query string that you will inspect,
	//    such as UserName or SalesRegion. The maximum length for SINGLE_QUERY_ARG
	//    is 30 characters.
	//
	//    * ALL_QUERY_ARGS: Similar to SINGLE_QUERY_ARG, but rather than inspecting
	//    a single parameter, AWS WAF will inspect all parameters within the query
	//    for the value or regex pattern that you specify in TargetString.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"MatchFieldType"`
}

// String returns the string representation
func (s FieldToMatch) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s FieldToMatch) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *FieldToMatch) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "FieldToMatch"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetData sets the Data field's value.
func (s *FieldToMatch) SetData(v string) *FieldToMatch {
	s.Data = &v
	return s
}

// SetType sets the Type field's value.
func (s *FieldToMatch) SetType(v string) *FieldToMatch {
	s.Type = &v
	return s
}

// The country from which web requests originate that you want AWS WAF to search
// for.
type GeoMatchConstraint struct {
	_ struct{} `type:"structure"`

	// The type of geographical area you want AWS WAF to search for. Currently Country
	// is the only valid value.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"GeoMatchConstraintType"`

	// The country that you want AWS WAF to search for.
	//
	// Value is a required field
	Value *string `type:"string" required:"true" enum:"GeoMatchConstraintValue"`
}

// String returns the string representation
func (s GeoMatchConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoMatchConstraint) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoMatchConstraint) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoMatchConstraint"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *GeoMatchConstraint) SetType(v string) *GeoMatchConstraint {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *GeoMatchConstraint) SetValue(v string) *GeoMatchConstraint {
	s.Value = &v
	return s
}

// Contains one or more countries that AWS WAF will search for.
type GeoMatchSet struct {
	_ struct{} `type:"structure"`

	// An array of GeoMatchConstraint objects, which contain the country that you
	// want AWS WAF to search for.
	//
	// GeoMatchConstraints is a required field
	GeoMatchConstraints []*GeoMatchConstraint `type:"list" required:"true"`

	// The GeoMatchSetId for an GeoMatchSet. You use GeoMatchSetId to get information
	// about a GeoMatchSet (see GeoMatchSet), update a GeoMatchSet (see UpdateGeoMatchSet),
	// insert a GeoMatchSet into a Rule or delete one from a Rule (see UpdateRule),
	// and delete a GeoMatchSet from AWS WAF (see DeleteGeoMatchSet).
	//
	// GeoMatchSetId is returned by CreateGeoMatchSet and by ListGeoMatchSets.
	//
	// GeoMatchSetId is a required field
	GeoMatchSetId *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the GeoMatchSet. You can't change the name
	// of an GeoMatchSet after you create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GeoMatchSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoMatchSet) GoString() string {
	return s.String()
}

// SetGeoMatchConstraints sets the GeoMatchConstraints field's value.
func (s *GeoMatchSet) SetGeoMatchConstraints(v []*GeoMatchConstraint) *GeoMatchSet {
	s.GeoMatchConstraints = v
	return s
}

// SetGeoMatchSetId sets the GeoMatchSetId field's value.
func (s *GeoMatchSet) SetGeoMatchSetId(v string) *GeoMatchSet {
	s.GeoMatchSetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GeoMatchSet) SetName(v string) *GeoMatchSet {
	s.Name = &v
	return s
}

// Contains the identifier and the name of the GeoMatchSet.
type GeoMatchSetSummary struct {
	_ struct{} `type:"structure"`

	// The GeoMatchSetId for an GeoMatchSet. You can use GeoMatchSetId in a GetGeoMatchSet
	// request to get detailed information about an GeoMatchSet.
	//
	// GeoMatchSetId is a required field
	GeoMatchSetId *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the GeoMatchSet. You can't change the name
	// of an GeoMatchSet after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GeoMatchSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoMatchSetSummary) GoString() string {
	return s.String()
}

// SetGeoMatchSetId sets the GeoMatchSetId field's value.
func (s *GeoMatchSetSummary) SetGeoMatchSetId(v string) *GeoMatchSetSummary {
	s.GeoMatchSetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GeoMatchSetSummary) SetName(v string) *GeoMatchSetSummary {
	s.Name = &v
	return s
}

// Specifies the type of update to perform to an GeoMatchSet with UpdateGeoMatchSet.
type GeoMatchSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert or delete a country with UpdateGeoMatchSet.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// The country from which web requests originate that you want AWS WAF to search
	// for.
	//
	// GeoMatchConstraint is a required field
	GeoMatchConstraint *GeoMatchConstraint `type:"structure" required:"true"`
}

// String returns the string representation
func (s GeoMatchSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GeoMatchSetUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GeoMatchSetUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GeoMatchSetUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.GeoMatchConstraint == nil {
		invalidParams.Add(request.NewErrParamRequired("GeoMatchConstraint"))
	}
	if s.GeoMatchConstraint != nil {
		if err := s.GeoMatchConstraint.Validate(); err != nil {
			invalidParams.AddNested("GeoMatchConstraint", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *GeoMatchSetUpdate) SetAction(v string) *GeoMatchSetUpdate {
	s.Action = &v
	return s
}

// SetGeoMatchConstraint sets the GeoMatchConstraint field's value.
func (s *GeoMatchSetUpdate) SetGeoMatchConstraint(v *GeoMatchConstraint) *GeoMatchSetUpdate {
	s.GeoMatchConstraint = v
	return s
}

type GetByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId of the ByteMatchSet that you want to get. ByteMatchSetId
	// is returned by CreateByteMatchSet and by ListByteMatchSets.
	//
	// ByteMatchSetId is a required field
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetByteMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetByteMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetByteMatchSetInput"}
	if s.ByteMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ByteMatchSetId"))
	}
	if s.ByteMatchSetId != nil && len(*s.ByteMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ByteMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByteMatchSetId sets the ByteMatchSetId field's value.
func (s *GetByteMatchSetInput) SetByteMatchSetId(v string) *GetByteMatchSetInput {
	s.ByteMatchSetId = &v
	return s
}

type GetByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the ByteMatchSet that you specified in the GetByteMatchSet
	// request. For more information, see the following topics:
	//
	//    * ByteMatchSet: Contains ByteMatchSetId, ByteMatchTuples, and Name
	//
	//    * ByteMatchTuples: Contains an array of ByteMatchTuple objects. Each ByteMatchTuple
	//    object contains FieldToMatch, PositionalConstraint, TargetString, and
	//    TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	ByteMatchSet *ByteMatchSet `type:"structure"`
}

// String returns the string representation
func (s GetByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetByteMatchSetOutput) GoString() string {
	return s.String()
}

// SetByteMatchSet sets the ByteMatchSet field's value.
func (s *GetByteMatchSetOutput) SetByteMatchSet(v *ByteMatchSet) *GetByteMatchSetOutput {
	s.ByteMatchSet = v
	return s
}

type GetChangeTokenInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetChangeTokenInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeTokenInput) GoString() string {
	return s.String()
}

type GetChangeTokenOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used in the request. Use this value in a GetChangeTokenStatus
	// request to get the current status of the request.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetChangeTokenOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeTokenOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *GetChangeTokenOutput) SetChangeToken(v string) *GetChangeTokenOutput {
	s.ChangeToken = &v
	return s
}

type GetChangeTokenStatusInput struct {
	_ struct{} `type:"structure"`

	// The change token for which you want to get the status. This change token
	// was previously returned in the GetChangeToken response.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetChangeTokenStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeTokenStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetChangeTokenStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetChangeTokenStatusInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *GetChangeTokenStatusInput) SetChangeToken(v string) *GetChangeTokenStatusInput {
	s.ChangeToken = &v
	return s
}

type GetChangeTokenStatusOutput struct {
	_ struct{} `type:"structure"`

	// The status of the change token.
	ChangeTokenStatus *string `type:"string" enum:"ChangeTokenStatus"`
}

// String returns the string representation
func (s GetChangeTokenStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetChangeTokenStatusOutput) GoString() string {
	return s.String()
}

// SetChangeTokenStatus sets the ChangeTokenStatus field's value.
func (s *GetChangeTokenStatusOutput) SetChangeTokenStatus(v string) *GetChangeTokenStatusOutput {
	s.ChangeTokenStatus = &v
	return s
}

type GetGeoMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The GeoMatchSetId of the GeoMatchSet that you want to get. GeoMatchSetId
	// is returned by CreateGeoMatchSet and by ListGeoMatchSets.
	//
	// GeoMatchSetId is a required field
	GeoMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGeoMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGeoMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetGeoMatchSetInput"}
	if s.GeoMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeoMatchSetId"))
	}
	if s.GeoMatchSetId != nil && len(*s.GeoMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeoMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGeoMatchSetId sets the GeoMatchSetId field's value.
func (s *GetGeoMatchSetInput) SetGeoMatchSetId(v string) *GetGeoMatchSetInput {
	s.GeoMatchSetId = &v
	return s
}

type GetGeoMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the GeoMatchSet that you specified in the GetGeoMatchSet
	// request. This includes the Type, which for a GeoMatchContraint is always
	// Country, as well as the Value, which is the identifier for a specific country.
	GeoMatchSet *GeoMatchSet `type:"structure"`
}

// String returns the string representation
func (s GetGeoMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetGeoMatchSetOutput) GoString() string {
	return s.String()
}

// SetGeoMatchSet sets the GeoMatchSet field's value.
func (s *GetGeoMatchSetOutput) SetGeoMatchSet(v *GeoMatchSet) *GetGeoMatchSetOutput {
	s.GeoMatchSet = v
	return s
}

type GetIPSetInput struct {
	_ struct{} `type:"structure"`

	// The IPSetId of the IPSet that you want to get. IPSetId is returned by CreateIPSet
	// and by ListIPSets.
	//
	// IPSetId is a required field
	IPSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetIPSetInput"}
	if s.IPSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IPSetId"))
	}
	if s.IPSetId != nil && len(*s.IPSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IPSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIPSetId sets the IPSetId field's value.
func (s *GetIPSetInput) SetIPSetId(v string) *GetIPSetInput {
	s.IPSetId = &v
	return s
}

type GetIPSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the IPSet that you specified in the GetIPSet request. For
	// more information, see the following topics:
	//
	//    * IPSet: Contains IPSetDescriptors, IPSetId, and Name
	//
	//    * IPSetDescriptors: Contains an array of IPSetDescriptor objects. Each
	//    IPSetDescriptor object contains Type and Value
	IPSet *IPSet `type:"structure"`
}

// String returns the string representation
func (s GetIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetIPSetOutput) GoString() string {
	return s.String()
}

// SetIPSet sets the IPSet field's value.
func (s *GetIPSetOutput) SetIPSet(v *IPSet) *GetIPSetOutput {
	s.IPSet = v
	return s
}

type GetLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the web ACL for which you want to get the
	// LoggingConfiguration.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetLoggingConfigurationInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetLoggingConfigurationInput) SetResourceArn(v string) *GetLoggingConfigurationInput {
	s.ResourceArn = &v
	return s
}

type GetLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The LoggingConfiguration for the specified web ACL.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation
func (s GetLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *GetLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *GetLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type GetPermissionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the RuleGroup for which you want to get
	// the policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetPermissionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPermissionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPermissionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPermissionPolicyInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *GetPermissionPolicyInput) SetResourceArn(v string) *GetPermissionPolicyInput {
	s.ResourceArn = &v
	return s
}

type GetPermissionPolicyOutput struct {
	_ struct{} `type:"structure"`

	// The IAM policy attached to the specified RuleGroup.
	Policy *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetPermissionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPermissionPolicyOutput) GoString() string {
	return s.String()
}

// SetPolicy sets the Policy field's value.
func (s *GetPermissionPolicyOutput) SetPolicy(v string) *GetPermissionPolicyOutput {
	s.Policy = &v
	return s
}

type GetRateBasedRuleInput struct {
	_ struct{} `type:"structure"`

	// The RuleId of the RateBasedRule that you want to get. RuleId is returned
	// by CreateRateBasedRule and by ListRateBasedRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRateBasedRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRateBasedRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRateBasedRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRateBasedRuleInput"}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleId sets the RuleId field's value.
func (s *GetRateBasedRuleInput) SetRuleId(v string) *GetRateBasedRuleInput {
	s.RuleId = &v
	return s
}

type GetRateBasedRuleManagedKeysInput struct {
	_ struct{} `type:"structure"`

	// A null value and not currently used. Do not include this in your request.
	NextMarker *string `min:"1" type:"string"`

	// The RuleId of the RateBasedRule for which you want to get a list of ManagedKeys.
	// RuleId is returned by CreateRateBasedRule and by ListRateBasedRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRateBasedRuleManagedKeysInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRateBasedRuleManagedKeysInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRateBasedRuleManagedKeysInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRateBasedRuleManagedKeysInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextMarker sets the NextMarker field's value.
func (s *GetRateBasedRuleManagedKeysInput) SetNextMarker(v string) *GetRateBasedRuleManagedKeysInput {
	s.NextMarker = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *GetRateBasedRuleManagedKeysInput) SetRuleId(v string) *GetRateBasedRuleManagedKeysInput {
	s.RuleId = &v
	return s
}

type GetRateBasedRuleManagedKeysOutput struct {
	_ struct{} `type:"structure"`

	// An array of IP addresses that currently are blocked by the specified RateBasedRule.
	ManagedKeys []*string `type:"list"`

	// A null value and not currently used.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetRateBasedRuleManagedKeysOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRateBasedRuleManagedKeysOutput) GoString() string {
	return s.String()
}

// SetManagedKeys sets the ManagedKeys field's value.
func (s *GetRateBasedRuleManagedKeysOutput) SetManagedKeys(v []*string) *GetRateBasedRuleManagedKeysOutput {
	s.ManagedKeys = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *GetRateBasedRuleManagedKeysOutput) SetNextMarker(v string) *GetRateBasedRuleManagedKeysOutput {
	s.NextMarker = &v
	return s
}

type GetRateBasedRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the RateBasedRule that you specified in the GetRateBasedRule
	// request.
	Rule *RateBasedRule `type:"structure"`
}

// String returns the string representation
func (s GetRateBasedRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRateBasedRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *GetRateBasedRuleOutput) SetRule(v *RateBasedRule) *GetRateBasedRuleOutput {
	s.Rule = v
	return s
}

type GetRegexMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The RegexMatchSetId of the RegexMatchSet that you want to get. RegexMatchSetId
	// is returned by CreateRegexMatchSet and by ListRegexMatchSets.
	//
	// RegexMatchSetId is a required field
	RegexMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRegexMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegexMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRegexMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRegexMatchSetInput"}
	if s.RegexMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexMatchSetId"))
	}
	if s.RegexMatchSetId != nil && len(*s.RegexMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegexMatchSetId sets the RegexMatchSetId field's value.
func (s *GetRegexMatchSetInput) SetRegexMatchSetId(v string) *GetRegexMatchSetInput {
	s.RegexMatchSetId = &v
	return s
}

type GetRegexMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the RegexMatchSet that you specified in the GetRegexMatchSet
	// request. For more information, see RegexMatchTuple.
	RegexMatchSet *RegexMatchSet `type:"structure"`
}

// String returns the string representation
func (s GetRegexMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegexMatchSetOutput) GoString() string {
	return s.String()
}

// SetRegexMatchSet sets the RegexMatchSet field's value.
func (s *GetRegexMatchSetOutput) SetRegexMatchSet(v *RegexMatchSet) *GetRegexMatchSetOutput {
	s.RegexMatchSet = v
	return s
}

type GetRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// The RegexPatternSetId of the RegexPatternSet that you want to get. RegexPatternSetId
	// is returned by CreateRegexPatternSet and by ListRegexPatternSets.
	//
	// RegexPatternSetId is a required field
	RegexPatternSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegexPatternSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRegexPatternSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRegexPatternSetInput"}
	if s.RegexPatternSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexPatternSetId"))
	}
	if s.RegexPatternSetId != nil && len(*s.RegexPatternSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexPatternSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRegexPatternSetId sets the RegexPatternSetId field's value.
func (s *GetRegexPatternSetInput) SetRegexPatternSetId(v string) *GetRegexPatternSetInput {
	s.RegexPatternSetId = &v
	return s
}

type GetRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the RegexPatternSet that you specified in the GetRegexPatternSet
	// request, including the identifier of the pattern set and the regular expression
	// patterns you want AWS WAF to search for.
	RegexPatternSet *RegexPatternSet `type:"structure"`
}

// String returns the string representation
func (s GetRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRegexPatternSetOutput) GoString() string {
	return s.String()
}

// SetRegexPatternSet sets the RegexPatternSet field's value.
func (s *GetRegexPatternSetOutput) SetRegexPatternSet(v *RegexPatternSet) *GetRegexPatternSetOutput {
	s.RegexPatternSet = v
	return s
}

type GetRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The RuleGroupId of the RuleGroup that you want to get. RuleGroupId is returned
	// by CreateRuleGroup and by ListRuleGroups.
	//
	// RuleGroupId is a required field
	RuleGroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRuleGroupInput"}
	if s.RuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleGroupId"))
	}
	if s.RuleGroupId != nil && len(*s.RuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *GetRuleGroupInput) SetRuleGroupId(v string) *GetRuleGroupInput {
	s.RuleGroupId = &v
	return s
}

type GetRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the RuleGroup that you specified in the GetRuleGroup request.
	RuleGroup *RuleGroup `type:"structure"`
}

// String returns the string representation
func (s GetRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleGroupOutput) GoString() string {
	return s.String()
}

// SetRuleGroup sets the RuleGroup field's value.
func (s *GetRuleGroupOutput) SetRuleGroup(v *RuleGroup) *GetRuleGroupOutput {
	s.RuleGroup = v
	return s
}

type GetRuleInput struct {
	_ struct{} `type:"structure"`

	// The RuleId of the Rule that you want to get. RuleId is returned by CreateRule
	// and by ListRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetRuleInput"}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRuleId sets the RuleId field's value.
func (s *GetRuleInput) SetRuleId(v string) *GetRuleInput {
	s.RuleId = &v
	return s
}

type GetRuleOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Rule that you specified in the GetRule request. For
	// more information, see the following topics:
	//
	//    * Rule: Contains MetricName, Name, an array of Predicate objects, and
	//    RuleId
	//
	//    * Predicate: Each Predicate object contains DataId, Negated, and Type
	Rule *Rule `type:"structure"`
}

// String returns the string representation
func (s GetRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetRuleOutput) GoString() string {
	return s.String()
}

// SetRule sets the Rule field's value.
func (s *GetRuleOutput) SetRule(v *Rule) *GetRuleOutput {
	s.Rule = v
	return s
}

type GetSampledRequestsInput struct {
	_ struct{} `type:"structure"`

	// The number of requests that you want AWS WAF to return from among the first
	// 5,000 requests that your AWS resource received during the time range. If
	// your resource received fewer requests than the value of MaxItems, GetSampledRequests
	// returns information about all of them.
	//
	// MaxItems is a required field
	MaxItems *int64 `min:"1" type:"long" required:"true"`

	// RuleId is one of three values:
	//
	//    * The RuleId of the Rule or the RuleGroupId of the RuleGroup for which
	//    you want GetSampledRequests to return a sample of requests.
	//
	//    * Default_Action, which causes GetSampledRequests to return a sample of
	//    the requests that didn't match any of the rules in the specified WebACL.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`

	// The start date and time and the end date and time of the range for which
	// you want GetSampledRequests to return a sample of requests. Specify the date
	// and time in the following format: "2016-09-27T14:50Z". You can specify any
	// time range in the previous three hours.
	//
	// TimeWindow is a required field
	TimeWindow *TimeWindow `type:"structure" required:"true"`

	// The WebACLId of the WebACL for which you want GetSampledRequests to return
	// a sample of requests.
	//
	// WebAclId is a required field
	WebAclId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSampledRequestsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSampledRequestsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSampledRequestsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSampledRequestsInput"}
	if s.MaxItems == nil {
		invalidParams.Add(request.NewErrParamRequired("MaxItems"))
	}
	if s.MaxItems != nil && *s.MaxItems < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxItems", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.TimeWindow == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeWindow"))
	}
	if s.WebAclId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebAclId"))
	}
	if s.WebAclId != nil && len(*s.WebAclId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebAclId", 1))
	}
	if s.TimeWindow != nil {
		if err := s.TimeWindow.Validate(); err != nil {
			invalidParams.AddNested("TimeWindow", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxItems sets the MaxItems field's value.
func (s *GetSampledRequestsInput) SetMaxItems(v int64) *GetSampledRequestsInput {
	s.MaxItems = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *GetSampledRequestsInput) SetRuleId(v string) *GetSampledRequestsInput {
	s.RuleId = &v
	return s
}

// SetTimeWindow sets the TimeWindow field's value.
func (s *GetSampledRequestsInput) SetTimeWindow(v *TimeWindow) *GetSampledRequestsInput {
	s.TimeWindow = v
	return s
}

// SetWebAclId sets the WebAclId field's value.
func (s *GetSampledRequestsInput) SetWebAclId(v string) *GetSampledRequestsInput {
	s.WebAclId = &v
	return s
}

type GetSampledRequestsOutput struct {
	_ struct{} `type:"structure"`

	// The total number of requests from which GetSampledRequests got a sample of
	// MaxItems requests. If PopulationSize is less than MaxItems, the sample includes
	// every request that your AWS resource received during the specified time range.
	PopulationSize *int64 `type:"long"`

	// A complex type that contains detailed information about each of the requests
	// in the sample.
	SampledRequests []*SampledHTTPRequest `type:"list"`

	// Usually, TimeWindow is the time range that you specified in the GetSampledRequests
	// request. However, if your AWS resource received more than 5,000 requests
	// during the time range that you specified in the request, GetSampledRequests
	// returns the time range for the first 5,000 requests.
	TimeWindow *TimeWindow `type:"structure"`
}

// String returns the string representation
func (s GetSampledRequestsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSampledRequestsOutput) GoString() string {
	return s.String()
}

// SetPopulationSize sets the PopulationSize field's value.
func (s *GetSampledRequestsOutput) SetPopulationSize(v int64) *GetSampledRequestsOutput {
	s.PopulationSize = &v
	return s
}

// SetSampledRequests sets the SampledRequests field's value.
func (s *GetSampledRequestsOutput) SetSampledRequests(v []*SampledHTTPRequest) *GetSampledRequestsOutput {
	s.SampledRequests = v
	return s
}

// SetTimeWindow sets the TimeWindow field's value.
func (s *GetSampledRequestsOutput) SetTimeWindow(v *TimeWindow) *GetSampledRequestsOutput {
	s.TimeWindow = v
	return s
}

type GetSizeConstraintSetInput struct {
	_ struct{} `type:"structure"`

	// The SizeConstraintSetId of the SizeConstraintSet that you want to get. SizeConstraintSetId
	// is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	//
	// SizeConstraintSetId is a required field
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSizeConstraintSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSizeConstraintSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSizeConstraintSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSizeConstraintSetInput"}
	if s.SizeConstraintSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeConstraintSetId"))
	}
	if s.SizeConstraintSetId != nil && len(*s.SizeConstraintSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SizeConstraintSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSizeConstraintSetId sets the SizeConstraintSetId field's value.
func (s *GetSizeConstraintSetInput) SetSizeConstraintSetId(v string) *GetSizeConstraintSetInput {
	s.SizeConstraintSetId = &v
	return s
}

type GetSizeConstraintSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SizeConstraintSet that you specified in the GetSizeConstraintSet
	// request. For more information, see the following topics:
	//
	//    * SizeConstraintSet: Contains SizeConstraintSetId, SizeConstraints, and
	//    Name
	//
	//    * SizeConstraints: Contains an array of SizeConstraint objects. Each SizeConstraint
	//    object contains FieldToMatch, TextTransformation, ComparisonOperator,
	//    and Size
	//
	//    * FieldToMatch: Contains Data and Type
	SizeConstraintSet *SizeConstraintSet `type:"structure"`
}

// String returns the string representation
func (s GetSizeConstraintSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSizeConstraintSetOutput) GoString() string {
	return s.String()
}

// SetSizeConstraintSet sets the SizeConstraintSet field's value.
func (s *GetSizeConstraintSetOutput) SetSizeConstraintSet(v *SizeConstraintSet) *GetSizeConstraintSetOutput {
	s.SizeConstraintSet = v
	return s
}

// A request to get a SqlInjectionMatchSet.
type GetSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The SqlInjectionMatchSetId of the SqlInjectionMatchSet that you want to get.
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	//
	// SqlInjectionMatchSetId is a required field
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSqlInjectionMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSqlInjectionMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSqlInjectionMatchSetInput"}
	if s.SqlInjectionMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlInjectionMatchSetId"))
	}
	if s.SqlInjectionMatchSetId != nil && len(*s.SqlInjectionMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqlInjectionMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSqlInjectionMatchSetId sets the SqlInjectionMatchSetId field's value.
func (s *GetSqlInjectionMatchSetInput) SetSqlInjectionMatchSetId(v string) *GetSqlInjectionMatchSetInput {
	s.SqlInjectionMatchSetId = &v
	return s
}

// The response to a GetSqlInjectionMatchSet request.
type GetSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the SqlInjectionMatchSet that you specified in the GetSqlInjectionMatchSet
	// request. For more information, see the following topics:
	//
	//    * SqlInjectionMatchSet: Contains Name, SqlInjectionMatchSetId, and an
	//    array of SqlInjectionMatchTuple objects
	//
	//    * SqlInjectionMatchTuple: Each SqlInjectionMatchTuple object contains
	//    FieldToMatch and TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	SqlInjectionMatchSet *SqlInjectionMatchSet `type:"structure"`
}

// String returns the string representation
func (s GetSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSqlInjectionMatchSetOutput) GoString() string {
	return s.String()
}

// SetSqlInjectionMatchSet sets the SqlInjectionMatchSet field's value.
func (s *GetSqlInjectionMatchSetOutput) SetSqlInjectionMatchSet(v *SqlInjectionMatchSet) *GetSqlInjectionMatchSetOutput {
	s.SqlInjectionMatchSet = v
	return s
}

type GetWebACLInput struct {
	_ struct{} `type:"structure"`

	// The WebACLId of the WebACL that you want to get. WebACLId is returned by
	// CreateWebACL and by ListWebACLs.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetWebACLInput"}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWebACLId sets the WebACLId field's value.
func (s *GetWebACLInput) SetWebACLId(v string) *GetWebACLInput {
	s.WebACLId = &v
	return s
}

type GetWebACLOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WebACL that you specified in the GetWebACL request.
	// For more information, see the following topics:
	//
	//    * WebACL: Contains DefaultAction, MetricName, Name, an array of Rule objects,
	//    and WebACLId
	//
	//    * DefaultAction (Data type is WafAction): Contains Type
	//
	//    * Rules: Contains an array of ActivatedRule objects, which contain Action,
	//    Priority, and RuleId
	//
	//    * Action: Contains Type
	WebACL *WebACL `type:"structure"`
}

// String returns the string representation
func (s GetWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetWebACLOutput) GoString() string {
	return s.String()
}

// SetWebACL sets the WebACL field's value.
func (s *GetWebACLOutput) SetWebACL(v *WebACL) *GetWebACLOutput {
	s.WebACL = v
	return s
}

// A request to get an XssMatchSet.
type GetXssMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The XssMatchSetId of the XssMatchSet that you want to get. XssMatchSetId
	// is returned by CreateXssMatchSet and by ListXssMatchSets.
	//
	// XssMatchSetId is a required field
	XssMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetXssMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetXssMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetXssMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetXssMatchSetInput"}
	if s.XssMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("XssMatchSetId"))
	}
	if s.XssMatchSetId != nil && len(*s.XssMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("XssMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetXssMatchSetId sets the XssMatchSetId field's value.
func (s *GetXssMatchSetInput) SetXssMatchSetId(v string) *GetXssMatchSetInput {
	s.XssMatchSetId = &v
	return s
}

// The response to a GetXssMatchSet request.
type GetXssMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the XssMatchSet that you specified in the GetXssMatchSet
	// request. For more information, see the following topics:
	//
	//    * XssMatchSet: Contains Name, XssMatchSetId, and an array of XssMatchTuple
	//    objects
	//
	//    * XssMatchTuple: Each XssMatchTuple object contains FieldToMatch and TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	XssMatchSet *XssMatchSet `type:"structure"`
}

// String returns the string representation
func (s GetXssMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetXssMatchSetOutput) GoString() string {
	return s.String()
}

// SetXssMatchSet sets the XssMatchSet field's value.
func (s *GetXssMatchSetOutput) SetXssMatchSet(v *XssMatchSet) *GetXssMatchSetOutput {
	s.XssMatchSet = v
	return s
}

// The response from a GetSampledRequests request includes an HTTPHeader complex
// type that appears as Headers in the response syntax. HTTPHeader contains
// the names and values of all of the headers that appear in one of the web
// requests that were returned by GetSampledRequests.
type HTTPHeader struct {
	_ struct{} `type:"structure"`

	// The name of one of the headers in the sampled web request.
	Name *string `type:"string"`

	// The value of one of the headers in the sampled web request.
	Value *string `type:"string"`
}

// String returns the string representation
func (s HTTPHeader) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPHeader) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *HTTPHeader) SetName(v string) *HTTPHeader {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HTTPHeader) SetValue(v string) *HTTPHeader {
	s.Value = &v
	return s
}

// The response from a GetSampledRequests request includes an HTTPRequest complex
// type that appears as Request in the response syntax. HTTPRequest contains
// information about one of the web requests that were returned by GetSampledRequests.
type HTTPRequest struct {
	_ struct{} `type:"structure"`

	// The IP address that the request originated from. If the WebACL is associated
	// with a CloudFront distribution, this is the value of one of the following
	// fields in CloudFront access logs:
	//
	//    * c-ip, if the viewer did not use an HTTP proxy or a load balancer to
	//    send the request
	//
	//    * x-forwarded-for, if the viewer did use an HTTP proxy or a load balancer
	//    to send the request
	ClientIP *string `type:"string"`

	// The two-letter country code for the country that the request originated from.
	// For a current list of country codes, see the Wikipedia entry ISO 3166-1 alpha-2
	// (https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2).
	Country *string `type:"string"`

	// The HTTP version specified in the sampled web request, for example, HTTP/1.1.
	HTTPVersion *string `type:"string"`

	// A complex type that contains two values for each header in the sampled web
	// request: the name of the header and the value of the header.
	Headers []*HTTPHeader `type:"list"`

	// The HTTP method specified in the sampled web request. CloudFront supports
	// the following methods: DELETE, GET, HEAD, OPTIONS, PATCH, POST, and PUT.
	Method *string `type:"string"`

	// The part of a web request that identifies the resource, for example, /images/daily-ad.jpg.
	URI *string `type:"string"`
}

// String returns the string representation
func (s HTTPRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPRequest) GoString() string {
	return s.String()
}

// SetClientIP sets the ClientIP field's value.
func (s *HTTPRequest) SetClientIP(v string) *HTTPRequest {
	s.ClientIP = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *HTTPRequest) SetCountry(v string) *HTTPRequest {
	s.Country = &v
	return s
}

// SetHTTPVersion sets the HTTPVersion field's value.
func (s *HTTPRequest) SetHTTPVersion(v string) *HTTPRequest {
	s.HTTPVersion = &v
	return s
}

// SetHeaders sets the Headers field's value.
func (s *HTTPRequest) SetHeaders(v []*HTTPHeader) *HTTPRequest {
	s.Headers = v
	return s
}

// SetMethod sets the Method field's value.
func (s *HTTPRequest) SetMethod(v string) *HTTPRequest {
	s.Method = &v
	return s
}

// SetURI sets the URI field's value.
func (s *HTTPRequest) SetURI(v string) *HTTPRequest {
	s.URI = &v
	return s
}

// Contains one or more IP addresses or blocks of IP addresses specified in
// Classless Inter-Domain Routing (CIDR) notation. AWS WAF supports IPv4 address
// ranges: /8 and any range between /16 through /32. AWS WAF supports IPv6 address
// ranges: /24, /32, /48, /56, /64, and /128.
//
// To specify an individual IP address, you specify the four-part IP address
// followed by a /32, for example, 192.0.2.0/32. To block a range of IP addresses,
// you can specify /8 or any range between /16 through /32 (for IPv4) or /24,
// /32, /48, /56, /64, or /128 (for IPv6). For more information about CIDR notation,
// see the Wikipedia entry Classless Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
type IPSet struct {
	_ struct{} `type:"structure"`

	// The IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation)
	// that web requests originate from. If the WebACL is associated with a CloudFront
	// distribution and the viewer did not use an HTTP proxy or a load balancer
	// to send the request, this is the value of the c-ip field in the CloudFront
	// access logs.
	//
	// IPSetDescriptors is a required field
	IPSetDescriptors []*IPSetDescriptor `type:"list" required:"true"`

	// The IPSetId for an IPSet. You use IPSetId to get information about an IPSet
	// (see GetIPSet), update an IPSet (see UpdateIPSet), insert an IPSet into a
	// Rule or delete one from a Rule (see UpdateRule), and delete an IPSet from
	// AWS WAF (see DeleteIPSet).
	//
	// IPSetId is returned by CreateIPSet and by ListIPSets.
	//
	// IPSetId is a required field
	IPSetId *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the IPSet. You can't change the name of
	// an IPSet after you create it.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation
func (s IPSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSet) GoString() string {
	return s.String()
}

// SetIPSetDescriptors sets the IPSetDescriptors field's value.
func (s *IPSet) SetIPSetDescriptors(v []*IPSetDescriptor) *IPSet {
	s.IPSetDescriptors = v
	return s
}

// SetIPSetId sets the IPSetId field's value.
func (s *IPSet) SetIPSetId(v string) *IPSet {
	s.IPSetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *IPSet) SetName(v string) *IPSet {
	s.Name = &v
	return s
}

// Specifies the IP address type (IPV4 or IPV6) and the IP address range (in
// CIDR format) that web requests originate from.
type IPSetDescriptor struct {
	_ struct{} `type:"structure"`

	// Specify IPV4 or IPV6.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"IPSetDescriptorType"`

	// Specify an IPv4 address by using CIDR notation. For example:
	//
	//    * To configure AWS WAF to allow, block, or count requests that originated
	//    from the IP address 192.0.2.44, specify 192.0.2.44/32.
	//
	//    * To configure AWS WAF to allow, block, or count requests that originated
	//    from IP addresses from 192.0.2.0 to 192.0.2.255, specify 192.0.2.0/24.
	//
	// For more information about CIDR notation, see the Wikipedia entry Classless
	// Inter-Domain Routing (https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing).
	//
	// Specify an IPv6 address by using CIDR notation. For example:
	//
	//    * To configure AWS WAF to allow, block, or count requests that originated
	//    from the IP address 1111:0000:0000:0000:0000:0000:0000:0111, specify 1111:0000:0000:0000:0000:0000:0000:0111/128.
	//
	//    * To configure AWS WAF to allow, block, or count requests that originated
	//    from IP addresses 1111:0000:0000:0000:0000:0000:0000:0000 to 1111:0000:0000:0000:ffff:ffff:ffff:ffff,
	//    specify 1111:0000:0000:0000:0000:0000:0000:0000/64.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation
func (s IPSetDescriptor) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetDescriptor) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPSetDescriptor) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IPSetDescriptor"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *IPSetDescriptor) SetType(v string) *IPSetDescriptor {
	s.Type = &v
	return s
}

// SetValue sets the Value field's value.
func (s *IPSetDescriptor) SetValue(v string) *IPSetDescriptor {
	s.Value = &v
	return s
}

// Contains the identifier and the name of the IPSet.
type IPSetSummary struct {
	_ struct{} `type:"structure"`

	// The IPSetId for an IPSet. You can use IPSetId in a GetIPSet request to get
	// detailed information about an IPSet.
	//
	// IPSetId is a required field
	IPSetId *string `min:"1" type:"string" required:"true"`

	// A friendly name or description of the IPSet. You can't change the name of
	// an IPSet after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s IPSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetSummary) GoString() string {
	return s.String()
}

// SetIPSetId sets the IPSetId field's value.
func (s *IPSetSummary) SetIPSetId(v string) *IPSetSummary {
	s.IPSetId = &v
	return s
}

// SetName sets the Name field's value.
func (s *IPSetSummary) SetName(v string) *IPSetSummary {
	s.Name = &v
	return s
}

// Specifies the type of update to perform to an IPSet with UpdateIPSet.
type IPSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert or delete an IP address with UpdateIPSet.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// The IP address type (IPV4 or IPV6) and the IP address range (in CIDR notation)
	// that web requests originate from.
	//
	// IPSetDescriptor is a required field
	IPSetDescriptor *IPSetDescriptor `type:"structure" required:"true"`
}

// String returns the string representation
func (s IPSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s IPSetUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *IPSetUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "IPSetUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.IPSetDescriptor == nil {
		invalidParams.Add(request.NewErrParamRequired("IPSetDescriptor"))
	}
	if s.IPSetDescriptor != nil {
		if err := s.IPSetDescriptor.Validate(); err != nil {
			invalidParams.AddNested("IPSetDescriptor", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *IPSetUpdate) SetAction(v string) *IPSetUpdate {
	s.Action = &v
	return s
}

// SetIPSetDescriptor sets the IPSetDescriptor field's value.
func (s *IPSetUpdate) SetIPSetDescriptor(v *IPSetDescriptor) *IPSetUpdate {
	s.IPSetDescriptor = v
	return s
}

// The operation failed because of a system problem, even though the request
// was valid. Retry your request.
type InternalErrorException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalErrorException) GoString() string {
	return s.String()
}

func newErrorInternalErrorException(v protocol.ResponseMetadata) error {
	return &InternalErrorException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalErrorException) Code() string {
	return "WAFInternalErrorException"
}

// Message returns the exception's message.
func (s InternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalErrorException) OrigErr() error {
	return nil
}

func (s InternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalErrorException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalErrorException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation failed because you tried to create, update, or delete an object
// by using an invalid account identifier.
type InvalidAccountException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata
}

// String returns the string representation
func (s InvalidAccountException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidAccountException) GoString() string {
	return s.String()
}

func newErrorInvalidAccountException(v protocol.ResponseMetadata) error {
	return &InvalidAccountException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidAccountException) Code() string {
	return "WAFInvalidAccountException"
}

// Message returns the exception's message.
func (s InvalidAccountException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidAccountException) OrigErr() error {
	return nil
}

func (s InvalidAccountException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidAccountException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidAccountException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation failed because there was nothing to do. For example:
//
//    * You tried to remove a Rule from a WebACL, but the Rule isn't in the
//    specified WebACL.
//
//    * You tried to remove an IP address from an IPSet, but the IP address
//    isn't in the specified IPSet.
//
//    * You tried to remove a ByteMatchTuple from a ByteMatchSet, but the ByteMatchTuple
//    isn't in the specified WebACL.
//
//    * You tried to add a Rule to a WebACL, but the Rule already exists in
//    the specified WebACL.
//
//    * You tried to add a ByteMatchTuple to a ByteMatchSet, but the ByteMatchTuple
//    already exists in the specified WebACL.
type InvalidOperationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidOperationException) GoString() string {
	return s.String()
}

func newErrorInvalidOperationException(v protocol.ResponseMetadata) error {
	return &InvalidOperationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidOperationException) Code() string {
	return "WAFInvalidOperationException"
}

// Message returns the exception's message.
func (s InvalidOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidOperationException) OrigErr() error {
	return nil
}

func (s InvalidOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidOperationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidOperationException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation failed because AWS WAF didn't recognize a parameter in the
// request. For example:
//
//    * You specified an invalid parameter name.
//
//    * You specified an invalid value.
//
//    * You tried to update an object (ByteMatchSet, IPSet, Rule, or WebACL)
//    using an action other than INSERT or DELETE.
//
//    * You tried to create a WebACL with a DefaultAction Type other than ALLOW,
//    BLOCK, or COUNT.
//
//    * You tried to create a RateBasedRule with a RateKey value other than
//    IP.
//
//    * You tried to update a WebACL with a WafAction Type other than ALLOW,
//    BLOCK, or COUNT.
//
//    * You tried to update a ByteMatchSet with a FieldToMatch Type other than
//    HEADER, METHOD, QUERY_STRING, URI, or BODY.
//
//    * You tried to update a ByteMatchSet with a Field of HEADER but no value
//    for Data.
//
//    * Your request references an ARN that is malformed, or corresponds to
//    a resource with which a web ACL cannot be associated.
type InvalidParameterException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Field *string `locationName:"field" type:"string" enum:"ParameterExceptionField"`

	Parameter *string `locationName:"parameter" min:"1" type:"string"`

	Reason *string `locationName:"reason" type:"string" enum:"ParameterExceptionReason"`
}

// String returns the string representation
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidParameterException) Code() string {
	return "WAFInvalidParameterException"
}

// Message returns the exception's message.
func (s InvalidParameterException) Message() string {
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidParameterException) OrigErr() error {
	return nil
}

func (s InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidParameterException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidParameterException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation failed because the specified policy is not in the proper format.
//
// The policy is subject to the following restrictions:
//
//    * You can attach only one policy with each PutPermissionPolicy request.
//
//    * The policy must include an Effect, Action and Principal.
//
//    * Effect must specify Allow.
//
//    * The Action in the policy must be waf:UpdateWebACL, waf-regional:UpdateWebACL,
//    waf:GetRuleGroup and waf-regional:GetRuleGroup . Any extra or wildcard
//    actions in the policy will be rejected.
//
//    * The policy cannot include a Resource parameter.
//
//    * The ARN in the request must be a valid WAF RuleGroup ARN and the RuleGroup
//    must exist in the same region.
//
//    * The user making the request must be the owner of the RuleGroup.
//
//    * Your policy must be composed using IAM Policy version 2012-10-17.
type InvalidPermissionPolicyException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidPermissionPolicyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidPermissionPolicyException) GoString() string {
	return s.String()
}

func newErrorInvalidPermissionPolicyException(v protocol.ResponseMetadata) error {
	return &InvalidPermissionPolicyException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidPermissionPolicyException) Code() string {
	return "WAFInvalidPermissionPolicyException"
}

// Message returns the exception's message.
func (s InvalidPermissionPolicyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidPermissionPolicyException) OrigErr() error {
	return nil
}

func (s InvalidPermissionPolicyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidPermissionPolicyException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidPermissionPolicyException) RequestID() string {
	return s.respMetadata.RequestID
}

// The regular expression (regex) you specified in RegexPatternString is invalid.
type InvalidRegexPatternException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s InvalidRegexPatternException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InvalidRegexPatternException) GoString() string {
	return s.String()
}

func newErrorInvalidRegexPatternException(v protocol.ResponseMetadata) error {
	return &InvalidRegexPatternException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InvalidRegexPatternException) Code() string {
	return "WAFInvalidRegexPatternException"
}

// Message returns the exception's message.
func (s InvalidRegexPatternException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InvalidRegexPatternException) OrigErr() error {
	return nil
}

func (s InvalidRegexPatternException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InvalidRegexPatternException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InvalidRegexPatternException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation exceeds a resource limit, for example, the maximum number of
// WebACL objects that you can create for an AWS account. For more information,
// see Limits (https://docs.aws.amazon.com/waf/latest/developerguide/limits.html)
// in the AWS WAF Developer Guide.
type LimitsExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s LimitsExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LimitsExceededException) GoString() string {
	return s.String()
}

func newErrorLimitsExceededException(v protocol.ResponseMetadata) error {
	return &LimitsExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s LimitsExceededException) Code() string {
	return "WAFLimitsExceededException"
}

// Message returns the exception's message.
func (s LimitsExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s LimitsExceededException) OrigErr() error {
	return nil
}

func (s LimitsExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s LimitsExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s LimitsExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListActivatedRulesInRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of ActivatedRules that you want AWS WAF to return for
	// this request. If you have more ActivatedRules than the number that you specify
	// for Limit, the response includes a NextMarker value that you can use to get
	// another batch of ActivatedRules.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more ActivatedRules than the
	// value of Limit, AWS WAF returns a NextMarker value in the response that allows
	// you to list another group of ActivatedRules. For the second and subsequent
	// ListActivatedRulesInRuleGroup requests, specify the value of NextMarker from
	// the previous response to get information about another batch of ActivatedRules.
	NextMarker *string `min:"1" type:"string"`

	// The RuleGroupId of the RuleGroup for which you want to get a list of ActivatedRule
	// objects.
	RuleGroupId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListActivatedRulesInRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivatedRulesInRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListActivatedRulesInRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListActivatedRulesInRuleGroupInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.RuleGroupId != nil && len(*s.RuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListActivatedRulesInRuleGroupInput) SetLimit(v int64) *ListActivatedRulesInRuleGroupInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListActivatedRulesInRuleGroupInput) SetNextMarker(v string) *ListActivatedRulesInRuleGroupInput {
	s.NextMarker = &v
	return s
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *ListActivatedRulesInRuleGroupInput) SetRuleGroupId(v string) *ListActivatedRulesInRuleGroupInput {
	s.RuleGroupId = &v
	return s
}

type ListActivatedRulesInRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// An array of ActivatedRules objects.
	ActivatedRules []*ActivatedRule `type:"list"`

	// If you have more ActivatedRules than the number that you specified for Limit
	// in the request, the response includes a NextMarker value. To list more ActivatedRules,
	// submit another ListActivatedRulesInRuleGroup request, and specify the NextMarker
	// value from the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListActivatedRulesInRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListActivatedRulesInRuleGroupOutput) GoString() string {
	return s.String()
}

// SetActivatedRules sets the ActivatedRules field's value.
func (s *ListActivatedRulesInRuleGroupOutput) SetActivatedRules(v []*ActivatedRule) *ListActivatedRulesInRuleGroupOutput {
	s.ActivatedRules = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListActivatedRulesInRuleGroupOutput) SetNextMarker(v string) *ListActivatedRulesInRuleGroupOutput {
	s.NextMarker = &v
	return s
}

type ListByteMatchSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of ByteMatchSet objects that you want AWS WAF to return
	// for this request. If you have more ByteMatchSets objects than the number
	// you specify for Limit, the response includes a NextMarker value that you
	// can use to get another batch of ByteMatchSet objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more ByteMatchSets than the
	// value of Limit, AWS WAF returns a NextMarker value in the response that allows
	// you to list another group of ByteMatchSets. For the second and subsequent
	// ListByteMatchSets requests, specify the value of NextMarker from the previous
	// response to get information about another batch of ByteMatchSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListByteMatchSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListByteMatchSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListByteMatchSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListByteMatchSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListByteMatchSetsInput) SetLimit(v int64) *ListByteMatchSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListByteMatchSetsInput) SetNextMarker(v string) *ListByteMatchSetsInput {
	s.NextMarker = &v
	return s
}

type ListByteMatchSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of ByteMatchSetSummary objects.
	ByteMatchSets []*ByteMatchSetSummary `type:"list"`

	// If you have more ByteMatchSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more ByteMatchSet objects, submit another ListByteMatchSets request, and
	// specify the NextMarker value from the response in the NextMarker value in
	// the next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListByteMatchSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListByteMatchSetsOutput) GoString() string {
	return s.String()
}

// SetByteMatchSets sets the ByteMatchSets field's value.
func (s *ListByteMatchSetsOutput) SetByteMatchSets(v []*ByteMatchSetSummary) *ListByteMatchSetsOutput {
	s.ByteMatchSets = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListByteMatchSetsOutput) SetNextMarker(v string) *ListByteMatchSetsOutput {
	s.NextMarker = &v
	return s
}

type ListGeoMatchSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of GeoMatchSet objects that you want AWS WAF to return
	// for this request. If you have more GeoMatchSet objects than the number you
	// specify for Limit, the response includes a NextMarker value that you can
	// use to get another batch of GeoMatchSet objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more GeoMatchSets than the
	// value of Limit, AWS WAF returns a NextMarker value in the response that allows
	// you to list another group of GeoMatchSet objects. For the second and subsequent
	// ListGeoMatchSets requests, specify the value of NextMarker from the previous
	// response to get information about another batch of GeoMatchSet objects.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoMatchSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoMatchSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGeoMatchSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGeoMatchSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListGeoMatchSetsInput) SetLimit(v int64) *ListGeoMatchSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListGeoMatchSetsInput) SetNextMarker(v string) *ListGeoMatchSetsInput {
	s.NextMarker = &v
	return s
}

type ListGeoMatchSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of GeoMatchSetSummary objects.
	GeoMatchSets []*GeoMatchSetSummary `type:"list"`

	// If you have more GeoMatchSet objects than the number that you specified for
	// Limit in the request, the response includes a NextMarker value. To list more
	// GeoMatchSet objects, submit another ListGeoMatchSets request, and specify
	// the NextMarker value from the response in the NextMarker value in the next
	// request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListGeoMatchSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGeoMatchSetsOutput) GoString() string {
	return s.String()
}

// SetGeoMatchSets sets the GeoMatchSets field's value.
func (s *ListGeoMatchSetsOutput) SetGeoMatchSets(v []*GeoMatchSetSummary) *ListGeoMatchSetsOutput {
	s.GeoMatchSets = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListGeoMatchSetsOutput) SetNextMarker(v string) *ListGeoMatchSetsOutput {
	s.NextMarker = &v
	return s
}

type ListIPSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of IPSet objects that you want AWS WAF to return for
	// this request. If you have more IPSet objects than the number you specify
	// for Limit, the response includes a NextMarker value that you can use to get
	// another batch of IPSet objects.
	Limit *int64 `type:"integer"`

	// AWS WAF returns a NextMarker value in the response that allows you to list
	// another group of IPSets. For the second and subsequent ListIPSets requests,
	// specify the value of NextMarker from the previous response to get information
	// about another batch of IPSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIPSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListIPSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListIPSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListIPSetsInput) SetLimit(v int64) *ListIPSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListIPSetsInput) SetNextMarker(v string) *ListIPSetsInput {
	s.NextMarker = &v
	return s
}

type ListIPSetsOutput struct {
	_ struct{} `type:"structure"`

	// An array of IPSetSummary objects.
	IPSets []*IPSetSummary `type:"list"`

	// To list more IPSet objects, submit another ListIPSets request, and in the
	// next request use the NextMarker response value as the NextMarker value.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListIPSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListIPSetsOutput) GoString() string {
	return s.String()
}

// SetIPSets sets the IPSets field's value.
func (s *ListIPSetsOutput) SetIPSets(v []*IPSetSummary) *ListIPSetsOutput {
	s.IPSets = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListIPSetsOutput) SetNextMarker(v string) *ListIPSetsOutput {
	s.NextMarker = &v
	return s
}

type ListLoggingConfigurationsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of LoggingConfigurations that you want AWS WAF to return
	// for this request. If you have more LoggingConfigurations than the number
	// that you specify for Limit, the response includes a NextMarker value that
	// you can use to get another batch of LoggingConfigurations.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more LoggingConfigurations
	// than the value of Limit, AWS WAF returns a NextMarker value in the response
	// that allows you to list another group of LoggingConfigurations. For the second
	// and subsequent ListLoggingConfigurations requests, specify the value of NextMarker
	// from the previous response to get information about another batch of ListLoggingConfigurations.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListLoggingConfigurationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggingConfigurationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListLoggingConfigurationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListLoggingConfigurationsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListLoggingConfigurationsInput) SetLimit(v int64) *ListLoggingConfigurationsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListLoggingConfigurationsInput) SetNextMarker(v string) *ListLoggingConfigurationsInput {
	s.NextMarker = &v
	return s
}

type ListLoggingConfigurationsOutput struct {
	_ struct{} `type:"structure"`

	// An array of LoggingConfiguration objects.
	LoggingConfigurations []*LoggingConfiguration `type:"list"`

	// If you have more LoggingConfigurations than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more LoggingConfigurations, submit another ListLoggingConfigurations request,
	// and specify the NextMarker value from the response in the NextMarker value
	// in the next request.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListLoggingConfigurationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListLoggingConfigurationsOutput) GoString() string {
	return s.String()
}

// SetLoggingConfigurations sets the LoggingConfigurations field's value.
func (s *ListLoggingConfigurationsOutput) SetLoggingConfigurations(v []*LoggingConfiguration) *ListLoggingConfigurationsOutput {
	s.LoggingConfigurations = v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListLoggingConfigurationsOutput) SetNextMarker(v string) *ListLoggingConfigurationsOutput {
	s.NextMarker = &v
	return s
}

type ListRateBasedRulesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of Rules that you want AWS WAF to return for this request.
	// If you have more Rules than the number that you specify for Limit, the response
	// includes a NextMarker value that you can use to get another batch of Rules.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more Rules than the value of
	// Limit, AWS WAF returns a NextMarker value in the response that allows you
	// to list another group of Rules. For the second and subsequent ListRateBasedRules
	// requests, specify the value of NextMarker from the previous response to get
	// information about another batch of Rules.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRateBasedRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRateBasedRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRateBasedRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRateBasedRulesInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRateBasedRulesInput) SetLimit(v int64) *ListRateBasedRulesInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRateBasedRulesInput) SetNextMarker(v string) *ListRateBasedRulesInput {
	s.NextMarker = &v
	return s
}

type ListRateBasedRulesOutput struct {
	_ struct{} `type:"structure"`

	// If you have more Rules than the number that you specified for Limit in the
	// request, the response includes a NextMarker value. To list more Rules, submit
	// another ListRateBasedRules request, and specify the NextMarker value from
	// the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of RuleSummary objects.
	Rules []*RuleSummary `type:"list"`
}

// String returns the string representation
func (s ListRateBasedRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRateBasedRulesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRateBasedRulesOutput) SetNextMarker(v string) *ListRateBasedRulesOutput {
	s.NextMarker = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListRateBasedRulesOutput) SetRules(v []*RuleSummary) *ListRateBasedRulesOutput {
	s.Rules = v
	return s
}

type ListRegexMatchSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of RegexMatchSet objects that you want AWS WAF to return
	// for this request. If you have more RegexMatchSet objects than the number
	// you specify for Limit, the response includes a NextMarker value that you
	// can use to get another batch of RegexMatchSet objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more RegexMatchSet objects
	// than the value of Limit, AWS WAF returns a NextMarker value in the response
	// that allows you to list another group of ByteMatchSets. For the second and
	// subsequent ListRegexMatchSets requests, specify the value of NextMarker from
	// the previous response to get information about another batch of RegexMatchSet
	// objects.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRegexMatchSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegexMatchSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRegexMatchSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRegexMatchSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRegexMatchSetsInput) SetLimit(v int64) *ListRegexMatchSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRegexMatchSetsInput) SetNextMarker(v string) *ListRegexMatchSetsInput {
	s.NextMarker = &v
	return s
}

type ListRegexMatchSetsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more RegexMatchSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more RegexMatchSet objects, submit another ListRegexMatchSets request, and
	// specify the NextMarker value from the response in the NextMarker value in
	// the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of RegexMatchSetSummary objects.
	RegexMatchSets []*RegexMatchSetSummary `type:"list"`
}

// String returns the string representation
func (s ListRegexMatchSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegexMatchSetsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRegexMatchSetsOutput) SetNextMarker(v string) *ListRegexMatchSetsOutput {
	s.NextMarker = &v
	return s
}

// SetRegexMatchSets sets the RegexMatchSets field's value.
func (s *ListRegexMatchSetsOutput) SetRegexMatchSets(v []*RegexMatchSetSummary) *ListRegexMatchSetsOutput {
	s.RegexMatchSets = v
	return s
}

type ListRegexPatternSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of RegexPatternSet objects that you want AWS WAF to
	// return for this request. If you have more RegexPatternSet objects than the
	// number you specify for Limit, the response includes a NextMarker value that
	// you can use to get another batch of RegexPatternSet objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more RegexPatternSet objects
	// than the value of Limit, AWS WAF returns a NextMarker value in the response
	// that allows you to list another group of RegexPatternSet objects. For the
	// second and subsequent ListRegexPatternSets requests, specify the value of
	// NextMarker from the previous response to get information about another batch
	// of RegexPatternSet objects.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRegexPatternSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegexPatternSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRegexPatternSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRegexPatternSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRegexPatternSetsInput) SetLimit(v int64) *ListRegexPatternSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRegexPatternSetsInput) SetNextMarker(v string) *ListRegexPatternSetsInput {
	s.NextMarker = &v
	return s
}

type ListRegexPatternSetsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more RegexPatternSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more RegexPatternSet objects, submit another ListRegexPatternSets request,
	// and specify the NextMarker value from the response in the NextMarker value
	// in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of RegexPatternSetSummary objects.
	RegexPatternSets []*RegexPatternSetSummary `type:"list"`
}

// String returns the string representation
func (s ListRegexPatternSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRegexPatternSetsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRegexPatternSetsOutput) SetNextMarker(v string) *ListRegexPatternSetsOutput {
	s.NextMarker = &v
	return s
}

// SetRegexPatternSets sets the RegexPatternSets field's value.
func (s *ListRegexPatternSetsOutput) SetRegexPatternSets(v []*RegexPatternSetSummary) *ListRegexPatternSetsOutput {
	s.RegexPatternSets = v
	return s
}

type ListRuleGroupsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of RuleGroups that you want AWS WAF to return for this
	// request. If you have more RuleGroups than the number that you specify for
	// Limit, the response includes a NextMarker value that you can use to get another
	// batch of RuleGroups.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more RuleGroups than the value
	// of Limit, AWS WAF returns a NextMarker value in the response that allows
	// you to list another group of RuleGroups. For the second and subsequent ListRuleGroups
	// requests, specify the value of NextMarker from the previous response to get
	// information about another batch of RuleGroups.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRuleGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRuleGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRuleGroupsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRuleGroupsInput) SetLimit(v int64) *ListRuleGroupsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRuleGroupsInput) SetNextMarker(v string) *ListRuleGroupsInput {
	s.NextMarker = &v
	return s
}

type ListRuleGroupsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more RuleGroups than the number that you specified for Limit
	// in the request, the response includes a NextMarker value. To list more RuleGroups,
	// submit another ListRuleGroups request, and specify the NextMarker value from
	// the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of RuleGroup objects.
	RuleGroups []*RuleGroupSummary `type:"list"`
}

// String returns the string representation
func (s ListRuleGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRuleGroupsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRuleGroupsOutput) SetNextMarker(v string) *ListRuleGroupsOutput {
	s.NextMarker = &v
	return s
}

// SetRuleGroups sets the RuleGroups field's value.
func (s *ListRuleGroupsOutput) SetRuleGroups(v []*RuleGroupSummary) *ListRuleGroupsOutput {
	s.RuleGroups = v
	return s
}

type ListRulesInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of Rules that you want AWS WAF to return for this request.
	// If you have more Rules than the number that you specify for Limit, the response
	// includes a NextMarker value that you can use to get another batch of Rules.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more Rules than the value of
	// Limit, AWS WAF returns a NextMarker value in the response that allows you
	// to list another group of Rules. For the second and subsequent ListRules requests,
	// specify the value of NextMarker from the previous response to get information
	// about another batch of Rules.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListRulesInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListRulesInput) SetLimit(v int64) *ListRulesInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRulesInput) SetNextMarker(v string) *ListRulesInput {
	s.NextMarker = &v
	return s
}

type ListRulesOutput struct {
	_ struct{} `type:"structure"`

	// If you have more Rules than the number that you specified for Limit in the
	// request, the response includes a NextMarker value. To list more Rules, submit
	// another ListRules request, and specify the NextMarker value from the response
	// in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of RuleSummary objects.
	Rules []*RuleSummary `type:"list"`
}

// String returns the string representation
func (s ListRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListRulesOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListRulesOutput) SetNextMarker(v string) *ListRulesOutput {
	s.NextMarker = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ListRulesOutput) SetRules(v []*RuleSummary) *ListRulesOutput {
	s.Rules = v
	return s
}

type ListSizeConstraintSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of SizeConstraintSet objects that you want AWS WAF to
	// return for this request. If you have more SizeConstraintSets objects than
	// the number you specify for Limit, the response includes a NextMarker value
	// that you can use to get another batch of SizeConstraintSet objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more SizeConstraintSets than
	// the value of Limit, AWS WAF returns a NextMarker value in the response that
	// allows you to list another group of SizeConstraintSets. For the second and
	// subsequent ListSizeConstraintSets requests, specify the value of NextMarker
	// from the previous response to get information about another batch of SizeConstraintSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSizeConstraintSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSizeConstraintSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSizeConstraintSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSizeConstraintSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListSizeConstraintSetsInput) SetLimit(v int64) *ListSizeConstraintSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListSizeConstraintSetsInput) SetNextMarker(v string) *ListSizeConstraintSetsInput {
	s.NextMarker = &v
	return s
}

type ListSizeConstraintSetsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more SizeConstraintSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more SizeConstraintSet objects, submit another ListSizeConstraintSets request,
	// and specify the NextMarker value from the response in the NextMarker value
	// in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of SizeConstraintSetSummary objects.
	SizeConstraintSets []*SizeConstraintSetSummary `type:"list"`
}

// String returns the string representation
func (s ListSizeConstraintSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSizeConstraintSetsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListSizeConstraintSetsOutput) SetNextMarker(v string) *ListSizeConstraintSetsOutput {
	s.NextMarker = &v
	return s
}

// SetSizeConstraintSets sets the SizeConstraintSets field's value.
func (s *ListSizeConstraintSetsOutput) SetSizeConstraintSets(v []*SizeConstraintSetSummary) *ListSizeConstraintSetsOutput {
	s.SizeConstraintSets = v
	return s
}

// A request to list the SqlInjectionMatchSet objects created by the current
// AWS account.
type ListSqlInjectionMatchSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of SqlInjectionMatchSet objects that you want AWS WAF
	// to return for this request. If you have more SqlInjectionMatchSet objects
	// than the number you specify for Limit, the response includes a NextMarker
	// value that you can use to get another batch of Rules.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more SqlInjectionMatchSet objects
	// than the value of Limit, AWS WAF returns a NextMarker value in the response
	// that allows you to list another group of SqlInjectionMatchSets. For the second
	// and subsequent ListSqlInjectionMatchSets requests, specify the value of NextMarker
	// from the previous response to get information about another batch of SqlInjectionMatchSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSqlInjectionMatchSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSqlInjectionMatchSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSqlInjectionMatchSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSqlInjectionMatchSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListSqlInjectionMatchSetsInput) SetLimit(v int64) *ListSqlInjectionMatchSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListSqlInjectionMatchSetsInput) SetNextMarker(v string) *ListSqlInjectionMatchSetsInput {
	s.NextMarker = &v
	return s
}

// The response to a ListSqlInjectionMatchSets request.
type ListSqlInjectionMatchSetsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more SqlInjectionMatchSet objects than the number that you specified
	// for Limit in the request, the response includes a NextMarker value. To list
	// more SqlInjectionMatchSet objects, submit another ListSqlInjectionMatchSets
	// request, and specify the NextMarker value from the response in the NextMarker
	// value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of SqlInjectionMatchSetSummary objects.
	SqlInjectionMatchSets []*SqlInjectionMatchSetSummary `type:"list"`
}

// String returns the string representation
func (s ListSqlInjectionMatchSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSqlInjectionMatchSetsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListSqlInjectionMatchSetsOutput) SetNextMarker(v string) *ListSqlInjectionMatchSetsOutput {
	s.NextMarker = &v
	return s
}

// SetSqlInjectionMatchSets sets the SqlInjectionMatchSets field's value.
func (s *ListSqlInjectionMatchSetsOutput) SetSqlInjectionMatchSets(v []*SqlInjectionMatchSetSummary) *ListSqlInjectionMatchSetsOutput {
	s.SqlInjectionMatchSets = v
	return s
}

type ListSubscribedRuleGroupsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of subscribed rule groups that you want AWS WAF to return
	// for this request. If you have more objects than the number you specify for
	// Limit, the response includes a NextMarker value that you can use to get another
	// batch of objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more ByteMatchSetssubscribed
	// rule groups than the value of Limit, AWS WAF returns a NextMarker value in
	// the response that allows you to list another group of subscribed rule groups.
	// For the second and subsequent ListSubscribedRuleGroupsRequest requests, specify
	// the value of NextMarker from the previous response to get information about
	// another batch of subscribed rule groups.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListSubscribedRuleGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscribedRuleGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSubscribedRuleGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSubscribedRuleGroupsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListSubscribedRuleGroupsInput) SetLimit(v int64) *ListSubscribedRuleGroupsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListSubscribedRuleGroupsInput) SetNextMarker(v string) *ListSubscribedRuleGroupsInput {
	s.NextMarker = &v
	return s
}

type ListSubscribedRuleGroupsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more objects than the number that you specified for Limit in
	// the request, the response includes a NextMarker value. To list more objects,
	// submit another ListSubscribedRuleGroups request, and specify the NextMarker
	// value from the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of RuleGroup objects.
	RuleGroups []*SubscribedRuleGroupSummary `type:"list"`
}

// String returns the string representation
func (s ListSubscribedRuleGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSubscribedRuleGroupsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListSubscribedRuleGroupsOutput) SetNextMarker(v string) *ListSubscribedRuleGroupsOutput {
	s.NextMarker = &v
	return s
}

// SetRuleGroups sets the RuleGroups field's value.
func (s *ListSubscribedRuleGroupsOutput) SetRuleGroups(v []*SubscribedRuleGroupSummary) *ListSubscribedRuleGroupsOutput {
	s.RuleGroups = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	Limit *int64 `type:"integer"`

	NextMarker *string `min:"1" type:"string"`

	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListTagsForResourceInput) SetLimit(v int64) *ListTagsForResourceInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListTagsForResourceInput) SetNextMarker(v string) *ListTagsForResourceInput {
	s.NextMarker = &v
	return s
}

// SetResourceARN sets the ResourceARN field's value.
func (s *ListTagsForResourceInput) SetResourceARN(v string) *ListTagsForResourceInput {
	s.ResourceARN = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	NextMarker *string `min:"1" type:"string"`

	TagInfoForResource *TagInfoForResource `type:"structure"`
}

// String returns the string representation
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListTagsForResourceOutput) SetNextMarker(v string) *ListTagsForResourceOutput {
	s.NextMarker = &v
	return s
}

// SetTagInfoForResource sets the TagInfoForResource field's value.
func (s *ListTagsForResourceOutput) SetTagInfoForResource(v *TagInfoForResource) *ListTagsForResourceOutput {
	s.TagInfoForResource = v
	return s
}

type ListWebACLsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of WebACL objects that you want AWS WAF to return for
	// this request. If you have more WebACL objects than the number that you specify
	// for Limit, the response includes a NextMarker value that you can use to get
	// another batch of WebACL objects.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more WebACL objects than the
	// number that you specify for Limit, AWS WAF returns a NextMarker value in
	// the response that allows you to list another group of WebACL objects. For
	// the second and subsequent ListWebACLs requests, specify the value of NextMarker
	// from the previous response to get information about another batch of WebACL
	// objects.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListWebACLsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebACLsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListWebACLsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListWebACLsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListWebACLsInput) SetLimit(v int64) *ListWebACLsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListWebACLsInput) SetNextMarker(v string) *ListWebACLsInput {
	s.NextMarker = &v
	return s
}

type ListWebACLsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more WebACL objects than the number that you specified for Limit
	// in the request, the response includes a NextMarker value. To list more WebACL
	// objects, submit another ListWebACLs request, and specify the NextMarker value
	// from the response in the NextMarker value in the next request.
	NextMarker *string `min:"1" type:"string"`

	// An array of WebACLSummary objects.
	WebACLs []*WebACLSummary `type:"list"`
}

// String returns the string representation
func (s ListWebACLsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListWebACLsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListWebACLsOutput) SetNextMarker(v string) *ListWebACLsOutput {
	s.NextMarker = &v
	return s
}

// SetWebACLs sets the WebACLs field's value.
func (s *ListWebACLsOutput) SetWebACLs(v []*WebACLSummary) *ListWebACLsOutput {
	s.WebACLs = v
	return s
}

// A request to list the XssMatchSet objects created by the current AWS account.
type ListXssMatchSetsInput struct {
	_ struct{} `type:"structure"`

	// Specifies the number of XssMatchSet objects that you want AWS WAF to return
	// for this request. If you have more XssMatchSet objects than the number you
	// specify for Limit, the response includes a NextMarker value that you can
	// use to get another batch of Rules.
	Limit *int64 `type:"integer"`

	// If you specify a value for Limit and you have more XssMatchSet objects than
	// the value of Limit, AWS WAF returns a NextMarker value in the response that
	// allows you to list another group of XssMatchSets. For the second and subsequent
	// ListXssMatchSets requests, specify the value of NextMarker from the previous
	// response to get information about another batch of XssMatchSets.
	NextMarker *string `min:"1" type:"string"`
}

// String returns the string representation
func (s ListXssMatchSetsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListXssMatchSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListXssMatchSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListXssMatchSetsInput"}
	if s.NextMarker != nil && len(*s.NextMarker) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextMarker", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLimit sets the Limit field's value.
func (s *ListXssMatchSetsInput) SetLimit(v int64) *ListXssMatchSetsInput {
	s.Limit = &v
	return s
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListXssMatchSetsInput) SetNextMarker(v string) *ListXssMatchSetsInput {
	s.NextMarker = &v
	return s
}

// The response to a ListXssMatchSets request.
type ListXssMatchSetsOutput struct {
	_ struct{} `type:"structure"`

	// If you have more XssMatchSet objects than the number that you specified for
	// Limit in the request, the response includes a NextMarker value. To list more
	// XssMatchSet objects, submit another ListXssMatchSets request, and specify
	// the NextMarker value from the response in the NextMarker value in the next
	// request.
	NextMarker *string `min:"1" type:"string"`

	// An array of XssMatchSetSummary objects.
	XssMatchSets []*XssMatchSetSummary `type:"list"`
}

// String returns the string representation
func (s ListXssMatchSetsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListXssMatchSetsOutput) GoString() string {
	return s.String()
}

// SetNextMarker sets the NextMarker field's value.
func (s *ListXssMatchSetsOutput) SetNextMarker(v string) *ListXssMatchSetsOutput {
	s.NextMarker = &v
	return s
}

// SetXssMatchSets sets the XssMatchSets field's value.
func (s *ListXssMatchSetsOutput) SetXssMatchSets(v []*XssMatchSetSummary) *ListXssMatchSetsOutput {
	s.XssMatchSets = v
	return s
}

// The Amazon Kinesis Data Firehose, RedactedFields information, and the web
// ACL Amazon Resource Name (ARN).
type LoggingConfiguration struct {
	_ struct{} `type:"structure"`

	// An array of Amazon Kinesis Data Firehose ARNs.
	//
	// LogDestinationConfigs is a required field
	LogDestinationConfigs []*string `min:"1" type:"list" required:"true"`

	// The parts of the request that you want redacted from the logs. For example,
	// if you redact the cookie field, the cookie field in the firehose will be
	// xxx.
	RedactedFields []*FieldToMatch `type:"list"`

	// The Amazon Resource Name (ARN) of the web ACL that you want to associate
	// with LogDestinationConfigs.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s LoggingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s LoggingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *LoggingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "LoggingConfiguration"}
	if s.LogDestinationConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("LogDestinationConfigs"))
	}
	if s.LogDestinationConfigs != nil && len(s.LogDestinationConfigs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LogDestinationConfigs", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.RedactedFields != nil {
		for i, v := range s.RedactedFields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RedactedFields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLogDestinationConfigs sets the LogDestinationConfigs field's value.
func (s *LoggingConfiguration) SetLogDestinationConfigs(v []*string) *LoggingConfiguration {
	s.LogDestinationConfigs = v
	return s
}

// SetRedactedFields sets the RedactedFields field's value.
func (s *LoggingConfiguration) SetRedactedFields(v []*FieldToMatch) *LoggingConfiguration {
	s.RedactedFields = v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *LoggingConfiguration) SetResourceArn(v string) *LoggingConfiguration {
	s.ResourceArn = &v
	return s
}

// The operation failed because you tried to delete an object that isn't empty.
// For example:
//
//    * You tried to delete a WebACL that still contains one or more Rule objects.
//
//    * You tried to delete a Rule that still contains one or more ByteMatchSet
//    objects or other predicates.
//
//    * You tried to delete a ByteMatchSet that contains one or more ByteMatchTuple
//    objects.
//
//    * You tried to delete an IPSet that references one or more IP addresses.
type NonEmptyEntityException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NonEmptyEntityException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NonEmptyEntityException) GoString() string {
	return s.String()
}

func newErrorNonEmptyEntityException(v protocol.ResponseMetadata) error {
	return &NonEmptyEntityException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s NonEmptyEntityException) Code() string {
	return "WAFNonEmptyEntityException"
}

// Message returns the exception's message.
func (s NonEmptyEntityException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s NonEmptyEntityException) OrigErr() error {
	return nil
}

func (s NonEmptyEntityException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s NonEmptyEntityException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s NonEmptyEntityException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation failed because you tried to add an object to or delete an object
// from another object that doesn't exist. For example:
//
//    * You tried to add a Rule to or delete a Rule from a WebACL that doesn't
//    exist.
//
//    * You tried to add a ByteMatchSet to or delete a ByteMatchSet from a Rule
//    that doesn't exist.
//
//    * You tried to add an IP address to or delete an IP address from an IPSet
//    that doesn't exist.
//
//    * You tried to add a ByteMatchTuple to or delete a ByteMatchTuple from
//    a ByteMatchSet that doesn't exist.
type NonexistentContainerException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NonexistentContainerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NonexistentContainerException) GoString() string {
	return s.String()
}

func newErrorNonexistentContainerException(v protocol.ResponseMetadata) error {
	return &NonexistentContainerException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s NonexistentContainerException) Code() string {
	return "WAFNonexistentContainerException"
}

// Message returns the exception's message.
func (s NonexistentContainerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s NonexistentContainerException) OrigErr() error {
	return nil
}

func (s NonexistentContainerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s NonexistentContainerException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s NonexistentContainerException) RequestID() string {
	return s.respMetadata.RequestID
}

// The operation failed because the referenced object doesn't exist.
type NonexistentItemException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s NonexistentItemException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NonexistentItemException) GoString() string {
	return s.String()
}

func newErrorNonexistentItemException(v protocol.ResponseMetadata) error {
	return &NonexistentItemException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s NonexistentItemException) Code() string {
	return "WAFNonexistentItemException"
}

// Message returns the exception's message.
func (s NonexistentItemException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s NonexistentItemException) OrigErr() error {
	return nil
}

func (s NonexistentItemException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s NonexistentItemException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s NonexistentItemException) RequestID() string {
	return s.respMetadata.RequestID
}

// Specifies the ByteMatchSet, IPSet, SqlInjectionMatchSet, XssMatchSet, RegexMatchSet,
// GeoMatchSet, and SizeConstraintSet objects that you want to add to a Rule
// and, for each object, indicates whether you want to negate the settings,
// for example, requests that do NOT originate from the IP address 192.0.2.44.
type Predicate struct {
	_ struct{} `type:"structure"`

	// A unique identifier for a predicate in a Rule, such as ByteMatchSetId or
	// IPSetId. The ID is returned by the corresponding Create or List command.
	//
	// DataId is a required field
	DataId *string `min:"1" type:"string" required:"true"`

	// Set Negated to False if you want AWS WAF to allow, block, or count requests
	// based on the settings in the specified ByteMatchSet, IPSet, SqlInjectionMatchSet,
	// XssMatchSet, RegexMatchSet, GeoMatchSet, or SizeConstraintSet. For example,
	// if an IPSet includes the IP address 192.0.2.44, AWS WAF will allow or block
	// requests based on that IP address.
	//
	// Set Negated to True if you want AWS WAF to allow or block a request based
	// on the negation of the settings in the ByteMatchSet, IPSet, SqlInjectionMatchSet,
	// XssMatchSet, RegexMatchSet, GeoMatchSet, or SizeConstraintSet. For example,
	// if an IPSet includes the IP address 192.0.2.44, AWS WAF will allow, block,
	// or count requests based on all IP addresses except 192.0.2.44.
	//
	// Negated is a required field
	Negated *bool `type:"boolean" required:"true"`

	// The type of predicate in a Rule, such as ByteMatch or IPSet.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"PredicateType"`
}

// String returns the string representation
func (s Predicate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Predicate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Predicate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Predicate"}
	if s.DataId == nil {
		invalidParams.Add(request.NewErrParamRequired("DataId"))
	}
	if s.DataId != nil && len(*s.DataId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataId", 1))
	}
	if s.Negated == nil {
		invalidParams.Add(request.NewErrParamRequired("Negated"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataId sets the DataId field's value.
func (s *Predicate) SetDataId(v string) *Predicate {
	s.DataId = &v
	return s
}

// SetNegated sets the Negated field's value.
func (s *Predicate) SetNegated(v bool) *Predicate {
	s.Negated = &v
	return s
}

// SetType sets the Type field's value.
func (s *Predicate) SetType(v string) *Predicate {
	s.Type = &v
	return s
}

type PutLoggingConfigurationInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Kinesis Data Firehose that contains the inspected traffic information,
	// the redacted fields details, and the Amazon Resource Name (ARN) of the web
	// ACL to monitor.
	//
	// When specifying Type in RedactedFields, you must use one of the following
	// values: URI, QUERY_STRING, HEADER, or METHOD.
	//
	// LoggingConfiguration is a required field
	LoggingConfiguration *LoggingConfiguration `type:"structure" required:"true"`
}

// String returns the string representation
func (s PutLoggingConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingConfigurationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutLoggingConfigurationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutLoggingConfigurationInput"}
	if s.LoggingConfiguration == nil {
		invalidParams.Add(request.NewErrParamRequired("LoggingConfiguration"))
	}
	if s.LoggingConfiguration != nil {
		if err := s.LoggingConfiguration.Validate(); err != nil {
			invalidParams.AddNested("LoggingConfiguration", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *PutLoggingConfigurationInput) SetLoggingConfiguration(v *LoggingConfiguration) *PutLoggingConfigurationInput {
	s.LoggingConfiguration = v
	return s
}

type PutLoggingConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// The LoggingConfiguration that you submitted in the request.
	LoggingConfiguration *LoggingConfiguration `type:"structure"`
}

// String returns the string representation
func (s PutLoggingConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutLoggingConfigurationOutput) GoString() string {
	return s.String()
}

// SetLoggingConfiguration sets the LoggingConfiguration field's value.
func (s *PutLoggingConfigurationOutput) SetLoggingConfiguration(v *LoggingConfiguration) *PutLoggingConfigurationOutput {
	s.LoggingConfiguration = v
	return s
}

type PutPermissionPolicyInput struct {
	_ struct{} `type:"structure"`

	// The policy to attach to the specified RuleGroup.
	//
	// Policy is a required field
	Policy *string `min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the RuleGroup to which you want to attach
	// the policy.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s PutPermissionPolicyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPermissionPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PutPermissionPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PutPermissionPolicyInput"}
	if s.Policy == nil {
		invalidParams.Add(request.NewErrParamRequired("Policy"))
	}
	if s.Policy != nil && len(*s.Policy) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Policy", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPolicy sets the Policy field's value.
func (s *PutPermissionPolicyInput) SetPolicy(v string) *PutPermissionPolicyInput {
	s.Policy = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *PutPermissionPolicyInput) SetResourceArn(v string) *PutPermissionPolicyInput {
	s.ResourceArn = &v
	return s
}

type PutPermissionPolicyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s PutPermissionPolicyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s PutPermissionPolicyOutput) GoString() string {
	return s.String()
}

// A RateBasedRule is identical to a regular Rule, with one addition: a RateBasedRule
// counts the number of requests that arrive from a specified IP address every
// five minutes. For example, based on recent requests that you've seen from
// an attacker, you might create a RateBasedRule that includes the following
// conditions:
//
//    * The requests come from 192.0.2.44.
//
//    * They contain the value BadBot in the User-Agent header.
//
// In the rule, you also define the rate limit as 15,000.
//
// Requests that meet both of these conditions and exceed 15,000 requests every
// five minutes trigger the rule's action (block or count), which is defined
// in the web ACL.
type RateBasedRule struct {
	_ struct{} `type:"structure"`

	// The Predicates object contains one Predicate element for each ByteMatchSet,
	// IPSet, or SqlInjectionMatchSet object that you want to include in a RateBasedRule.
	//
	// MatchPredicates is a required field
	MatchPredicates []*Predicate `type:"list" required:"true"`

	// A friendly name or description for the metrics for a RateBasedRule. The name
	// can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change the name
	// of the metric after you create the RateBasedRule.
	MetricName *string `type:"string"`

	// A friendly name or description for a RateBasedRule. You can't change the
	// name of a RateBasedRule after you create it.
	Name *string `min:"1" type:"string"`

	// The field that AWS WAF uses to determine if requests are likely arriving
	// from single source and thus subject to rate monitoring. The only valid value
	// for RateKey is IP. IP indicates that requests arriving from the same IP address
	// are subject to the RateLimit that is specified in the RateBasedRule.
	//
	// RateKey is a required field
	RateKey *string `type:"string" required:"true" enum:"RateKey"`

	// The maximum number of requests, which have an identical value in the field
	// specified by the RateKey, allowed in a five-minute period. If the number
	// of requests exceeds the RateLimit and the other predicates specified in the
	// rule are also met, AWS WAF triggers the action that is specified for this
	// rule.
	//
	// RateLimit is a required field
	RateLimit *int64 `min:"100" type:"long" required:"true"`

	// A unique identifier for a RateBasedRule. You use RuleId to get more information
	// about a RateBasedRule (see GetRateBasedRule), update a RateBasedRule (see
	// UpdateRateBasedRule), insert a RateBasedRule into a WebACL or delete one
	// from a WebACL (see UpdateWebACL), or delete a RateBasedRule from AWS WAF
	// (see DeleteRateBasedRule).
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RateBasedRule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RateBasedRule) GoString() string {
	return s.String()
}

// SetMatchPredicates sets the MatchPredicates field's value.
func (s *RateBasedRule) SetMatchPredicates(v []*Predicate) *RateBasedRule {
	s.MatchPredicates = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *RateBasedRule) SetMetricName(v string) *RateBasedRule {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *RateBasedRule) SetName(v string) *RateBasedRule {
	s.Name = &v
	return s
}

// SetRateKey sets the RateKey field's value.
func (s *RateBasedRule) SetRateKey(v string) *RateBasedRule {
	s.RateKey = &v
	return s
}

// SetRateLimit sets the RateLimit field's value.
func (s *RateBasedRule) SetRateLimit(v int64) *RateBasedRule {
	s.RateLimit = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *RateBasedRule) SetRuleId(v string) *RateBasedRule {
	s.RuleId = &v
	return s
}

// The operation failed because you tried to delete an object that is still
// in use. For example:
//
//    * You tried to delete a ByteMatchSet that is still referenced by a Rule.
//
//    * You tried to delete a Rule that is still referenced by a WebACL.
type ReferencedItemException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ReferencedItemException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ReferencedItemException) GoString() string {
	return s.String()
}

func newErrorReferencedItemException(v protocol.ResponseMetadata) error {
	return &ReferencedItemException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ReferencedItemException) Code() string {
	return "WAFReferencedItemException"
}

// Message returns the exception's message.
func (s ReferencedItemException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ReferencedItemException) OrigErr() error {
	return nil
}

func (s ReferencedItemException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ReferencedItemException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ReferencedItemException) RequestID() string {
	return s.respMetadata.RequestID
}

// In a GetRegexMatchSet request, RegexMatchSet is a complex type that contains
// the RegexMatchSetId and Name of a RegexMatchSet, and the values that you
// specified when you updated the RegexMatchSet.
//
// The values are contained in a RegexMatchTuple object, which specify the parts
// of web requests that you want AWS WAF to inspect and the values that you
// want AWS WAF to search for. If a RegexMatchSet contains more than one RegexMatchTuple
// object, a request needs to match the settings in only one ByteMatchTuple
// to be considered a match.
type RegexMatchSet struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the RegexMatchSet. You can't change Name
	// after you create a RegexMatchSet.
	Name *string `min:"1" type:"string"`

	// The RegexMatchSetId for a RegexMatchSet. You use RegexMatchSetId to get information
	// about a RegexMatchSet (see GetRegexMatchSet), update a RegexMatchSet (see
	// UpdateRegexMatchSet), insert a RegexMatchSet into a Rule or delete one from
	// a Rule (see UpdateRule), and delete a RegexMatchSet from AWS WAF (see DeleteRegexMatchSet).
	//
	// RegexMatchSetId is returned by CreateRegexMatchSet and by ListRegexMatchSets.
	RegexMatchSetId *string `min:"1" type:"string"`

	// Contains an array of RegexMatchTuple objects. Each RegexMatchTuple object
	// contains:
	//
	//    * The part of a web request that you want AWS WAF to inspect, such as
	//    a query string or the value of the User-Agent header.
	//
	//    * The identifier of the pattern (a regular expression) that you want AWS
	//    WAF to look for. For more information, see RegexPatternSet.
	//
	//    * Whether to perform any conversions on the request, such as converting
	//    it to lowercase, before inspecting it for the specified string.
	RegexMatchTuples []*RegexMatchTuple `type:"list"`
}

// String returns the string representation
func (s RegexMatchSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexMatchSet) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RegexMatchSet) SetName(v string) *RegexMatchSet {
	s.Name = &v
	return s
}

// SetRegexMatchSetId sets the RegexMatchSetId field's value.
func (s *RegexMatchSet) SetRegexMatchSetId(v string) *RegexMatchSet {
	s.RegexMatchSetId = &v
	return s
}

// SetRegexMatchTuples sets the RegexMatchTuples field's value.
func (s *RegexMatchSet) SetRegexMatchTuples(v []*RegexMatchTuple) *RegexMatchSet {
	s.RegexMatchTuples = v
	return s
}

// Returned by ListRegexMatchSets. Each RegexMatchSetSummary object includes
// the Name and RegexMatchSetId for one RegexMatchSet.
type RegexMatchSetSummary struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the RegexMatchSet. You can't change Name
	// after you create a RegexMatchSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The RegexMatchSetId for a RegexMatchSet. You use RegexMatchSetId to get information
	// about a RegexMatchSet, update a RegexMatchSet, remove a RegexMatchSet from
	// a Rule, and delete a RegexMatchSet from AWS WAF.
	//
	// RegexMatchSetId is returned by CreateRegexMatchSet and by ListRegexMatchSets.
	//
	// RegexMatchSetId is a required field
	RegexMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegexMatchSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexMatchSetSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RegexMatchSetSummary) SetName(v string) *RegexMatchSetSummary {
	s.Name = &v
	return s
}

// SetRegexMatchSetId sets the RegexMatchSetId field's value.
func (s *RegexMatchSetSummary) SetRegexMatchSetId(v string) *RegexMatchSetSummary {
	s.RegexMatchSetId = &v
	return s
}

// In an UpdateRegexMatchSet request, RegexMatchSetUpdate specifies whether
// to insert or delete a RegexMatchTuple and includes the settings for the RegexMatchTuple.
type RegexMatchSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert or delete a RegexMatchTuple.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Information about the part of a web request that you want AWS WAF to inspect
	// and the identifier of the regular expression (regex) pattern that you want
	// AWS WAF to search for. If you specify DELETE for the value of Action, the
	// RegexMatchTuple values must exactly match the values in the RegexMatchTuple
	// that you want to delete from the RegexMatchSet.
	//
	// RegexMatchTuple is a required field
	RegexMatchTuple *RegexMatchTuple `type:"structure" required:"true"`
}

// String returns the string representation
func (s RegexMatchSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexMatchSetUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegexMatchSetUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegexMatchSetUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.RegexMatchTuple == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexMatchTuple"))
	}
	if s.RegexMatchTuple != nil {
		if err := s.RegexMatchTuple.Validate(); err != nil {
			invalidParams.AddNested("RegexMatchTuple", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *RegexMatchSetUpdate) SetAction(v string) *RegexMatchSetUpdate {
	s.Action = &v
	return s
}

// SetRegexMatchTuple sets the RegexMatchTuple field's value.
func (s *RegexMatchSetUpdate) SetRegexMatchTuple(v *RegexMatchTuple) *RegexMatchSetUpdate {
	s.RegexMatchTuple = v
	return s
}

// The regular expression pattern that you want AWS WAF to search for in web
// requests, the location in requests that you want AWS WAF to search, and other
// settings. Each RegexMatchTuple object contains:
//
//    * The part of a web request that you want AWS WAF to inspect, such as
//    a query string or the value of the User-Agent header.
//
//    * The identifier of the pattern (a regular expression) that you want AWS
//    WAF to look for. For more information, see RegexPatternSet.
//
//    * Whether to perform any conversions on the request, such as converting
//    it to lowercase, before inspecting it for the specified string.
type RegexMatchTuple struct {
	_ struct{} `type:"structure"`

	// Specifies where in a web request to look for the RegexPatternSet.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// The RegexPatternSetId for a RegexPatternSet. You use RegexPatternSetId to
	// get information about a RegexPatternSet (see GetRegexPatternSet), update
	// a RegexPatternSet (see UpdateRegexPatternSet), insert a RegexPatternSet into
	// a RegexMatchSet or delete one from a RegexMatchSet (see UpdateRegexMatchSet),
	// and delete an RegexPatternSet from AWS WAF (see DeleteRegexPatternSet).
	//
	// RegexPatternSetId is returned by CreateRegexPatternSet and by ListRegexPatternSets.
	//
	// RegexPatternSetId is a required field
	RegexPatternSetId *string `min:"1" type:"string" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass AWS WAF. If you specify a transformation,
	// AWS WAF performs the transformation on RegexPatternSet before inspecting
	// a request for a match.
	//
	// You can only specify a single type of TextTransformation.
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system commandline
	// command and using unusual formatting to disguise some or all of the command,
	// use this option to perform the following transformations:
	//
	//    * Delete the following characters: \ " ' ^
	//
	//    * Delete spaces before the following characters: / (
	//
	//    * Replace the following characters with a space: , ;
	//
	//    * Replace multiple spaces with one space
	//
	//    * Convert uppercase letters (A-Z) to lowercase (a-z)
	//
	// COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//    * \f, formfeed, decimal 12
	//
	//    * \t, tab, decimal 9
	//
	//    * \n, newline, decimal 10
	//
	//    * \r, carriage return, decimal 13
	//
	//    * \v, vertical tab, decimal 11
	//
	//    * non-breaking space, decimal 160
	//
	// COMPRESS_WHITE_SPACE also replaces multiple spaces with one space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//    * Replaces (ampersand)quot; with "
	//
	//    * Replaces (ampersand)nbsp; with a non-breaking space, decimal 160
	//
	//    * Replaces (ampersand)lt; with a "less than" symbol
	//
	//    * Replaces (ampersand)gt; with >
	//
	//    * Replaces characters that are represented in hexadecimal format, (ampersand)#xhhhh;,
	//    with the corresponding characters
	//
	//    * Replaces characters that are represented in decimal format, (ampersand)#nnnn;,
	//    with the corresponding characters
	//
	// LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	//
	// NONE
	//
	// Specify NONE if you don't want to perform any text transformations.
	//
	// TextTransformation is a required field
	TextTransformation *string `type:"string" required:"true" enum:"TextTransformation"`
}

// String returns the string representation
func (s RegexMatchTuple) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexMatchTuple) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegexMatchTuple) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegexMatchTuple"}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.RegexPatternSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexPatternSetId"))
	}
	if s.RegexPatternSetId != nil && len(*s.RegexPatternSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexPatternSetId", 1))
	}
	if s.TextTransformation == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformation"))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *RegexMatchTuple) SetFieldToMatch(v *FieldToMatch) *RegexMatchTuple {
	s.FieldToMatch = v
	return s
}

// SetRegexPatternSetId sets the RegexPatternSetId field's value.
func (s *RegexMatchTuple) SetRegexPatternSetId(v string) *RegexMatchTuple {
	s.RegexPatternSetId = &v
	return s
}

// SetTextTransformation sets the TextTransformation field's value.
func (s *RegexMatchTuple) SetTextTransformation(v string) *RegexMatchTuple {
	s.TextTransformation = &v
	return s
}

// The RegexPatternSet specifies the regular expression (regex) pattern that
// you want AWS WAF to search for, such as B[a@]dB[o0]t. You can then configure
// AWS WAF to reject those requests.
type RegexPatternSet struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the RegexPatternSet. You can't change Name
	// after you create a RegexPatternSet.
	Name *string `min:"1" type:"string"`

	// The identifier for the RegexPatternSet. You use RegexPatternSetId to get
	// information about a RegexPatternSet, update a RegexPatternSet, remove a RegexPatternSet
	// from a RegexMatchSet, and delete a RegexPatternSet from AWS WAF.
	//
	// RegexMatchSetId is returned by CreateRegexPatternSet and by ListRegexPatternSets.
	//
	// RegexPatternSetId is a required field
	RegexPatternSetId *string `min:"1" type:"string" required:"true"`

	// Specifies the regular expression (regex) patterns that you want AWS WAF to
	// search for, such as B[a@]dB[o0]t.
	//
	// RegexPatternStrings is a required field
	RegexPatternStrings []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s RegexPatternSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexPatternSet) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RegexPatternSet) SetName(v string) *RegexPatternSet {
	s.Name = &v
	return s
}

// SetRegexPatternSetId sets the RegexPatternSetId field's value.
func (s *RegexPatternSet) SetRegexPatternSetId(v string) *RegexPatternSet {
	s.RegexPatternSetId = &v
	return s
}

// SetRegexPatternStrings sets the RegexPatternStrings field's value.
func (s *RegexPatternSet) SetRegexPatternStrings(v []*string) *RegexPatternSet {
	s.RegexPatternStrings = v
	return s
}

// Returned by ListRegexPatternSets. Each RegexPatternSetSummary object includes
// the Name and RegexPatternSetId for one RegexPatternSet.
type RegexPatternSetSummary struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the RegexPatternSet. You can't change Name
	// after you create a RegexPatternSet.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The RegexPatternSetId for a RegexPatternSet. You use RegexPatternSetId to
	// get information about a RegexPatternSet, update a RegexPatternSet, remove
	// a RegexPatternSet from a RegexMatchSet, and delete a RegexPatternSet from
	// AWS WAF.
	//
	// RegexPatternSetId is returned by CreateRegexPatternSet and by ListRegexPatternSets.
	//
	// RegexPatternSetId is a required field
	RegexPatternSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegexPatternSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexPatternSetSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RegexPatternSetSummary) SetName(v string) *RegexPatternSetSummary {
	s.Name = &v
	return s
}

// SetRegexPatternSetId sets the RegexPatternSetId field's value.
func (s *RegexPatternSetSummary) SetRegexPatternSetId(v string) *RegexPatternSetSummary {
	s.RegexPatternSetId = &v
	return s
}

// In an UpdateRegexPatternSet request, RegexPatternSetUpdate specifies whether
// to insert or delete a RegexPatternString and includes the settings for the
// RegexPatternString.
type RegexPatternSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert or delete a RegexPatternString.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Specifies the regular expression (regex) pattern that you want AWS WAF to
	// search for, such as B[a@]dB[o0]t.
	//
	// RegexPatternString is a required field
	RegexPatternString *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RegexPatternSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RegexPatternSetUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegexPatternSetUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegexPatternSetUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.RegexPatternString == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexPatternString"))
	}
	if s.RegexPatternString != nil && len(*s.RegexPatternString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexPatternString", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *RegexPatternSetUpdate) SetAction(v string) *RegexPatternSetUpdate {
	s.Action = &v
	return s
}

// SetRegexPatternString sets the RegexPatternString field's value.
func (s *RegexPatternSetUpdate) SetRegexPatternString(v string) *RegexPatternSetUpdate {
	s.RegexPatternString = &v
	return s
}

// A combination of ByteMatchSet, IPSet, and/or SqlInjectionMatchSet objects
// that identify the web requests that you want to allow, block, or count. For
// example, you might create a Rule that includes the following predicates:
//
//    * An IPSet that causes AWS WAF to search for web requests that originate
//    from the IP address 192.0.2.44
//
//    * A ByteMatchSet that causes AWS WAF to search for web requests for which
//    the value of the User-Agent header is BadBot.
//
// To match the settings in this Rule, a request must originate from 192.0.2.44
// AND include a User-Agent header for which the value is BadBot.
type Rule struct {
	_ struct{} `type:"structure"`

	// A friendly name or description for the metrics for this Rule. The name can
	// contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change MetricName
	// after you create the Rule.
	MetricName *string `type:"string"`

	// The friendly name or description for the Rule. You can't change the name
	// of a Rule after you create it.
	Name *string `min:"1" type:"string"`

	// The Predicates object contains one Predicate element for each ByteMatchSet,
	// IPSet, or SqlInjectionMatchSet object that you want to include in a Rule.
	//
	// Predicates is a required field
	Predicates []*Predicate `type:"list" required:"true"`

	// A unique identifier for a Rule. You use RuleId to get more information about
	// a Rule (see GetRule), update a Rule (see UpdateRule), insert a Rule into
	// a WebACL or delete a one from a WebACL (see UpdateWebACL), or delete a Rule
	// from AWS WAF (see DeleteRule).
	//
	// RuleId is returned by CreateRule and by ListRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s Rule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Rule) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *Rule) SetMetricName(v string) *Rule {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *Rule) SetName(v string) *Rule {
	s.Name = &v
	return s
}

// SetPredicates sets the Predicates field's value.
func (s *Rule) SetPredicates(v []*Predicate) *Rule {
	s.Predicates = v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *Rule) SetRuleId(v string) *Rule {
	s.RuleId = &v
	return s
}

// A collection of predefined rules that you can add to a web ACL.
//
// Rule groups are subject to the following limits:
//
//    * Three rule groups per account. You can request an increase to this limit
//    by contacting customer support.
//
//    * One rule group per web ACL.
//
//    * Ten rules per rule group.
type RuleGroup struct {
	_ struct{} `type:"structure"`

	// A friendly name or description for the metrics for this RuleGroup. The name
	// can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change the name
	// of the metric after you create the RuleGroup.
	MetricName *string `type:"string"`

	// The friendly name or description for the RuleGroup. You can't change the
	// name of a RuleGroup after you create it.
	Name *string `min:"1" type:"string"`

	// A unique identifier for a RuleGroup. You use RuleGroupId to get more information
	// about a RuleGroup (see GetRuleGroup), update a RuleGroup (see UpdateRuleGroup),
	// insert a RuleGroup into a WebACL or delete a one from a WebACL (see UpdateWebACL),
	// or delete a RuleGroup from AWS WAF (see DeleteRuleGroup).
	//
	// RuleGroupId is returned by CreateRuleGroup and by ListRuleGroups.
	//
	// RuleGroupId is a required field
	RuleGroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RuleGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleGroup) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *RuleGroup) SetMetricName(v string) *RuleGroup {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *RuleGroup) SetName(v string) *RuleGroup {
	s.Name = &v
	return s
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *RuleGroup) SetRuleGroupId(v string) *RuleGroup {
	s.RuleGroupId = &v
	return s
}

// Contains the identifier and the friendly name or description of the RuleGroup.
type RuleGroupSummary struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the RuleGroup. You can't change the name
	// of a RuleGroup after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a RuleGroup. You use RuleGroupId to get more information
	// about a RuleGroup (see GetRuleGroup), update a RuleGroup (see UpdateRuleGroup),
	// insert a RuleGroup into a WebACL or delete one from a WebACL (see UpdateWebACL),
	// or delete a RuleGroup from AWS WAF (see DeleteRuleGroup).
	//
	// RuleGroupId is returned by CreateRuleGroup and by ListRuleGroups.
	//
	// RuleGroupId is a required field
	RuleGroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RuleGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleGroupSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RuleGroupSummary) SetName(v string) *RuleGroupSummary {
	s.Name = &v
	return s
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *RuleGroupSummary) SetRuleGroupId(v string) *RuleGroupSummary {
	s.RuleGroupId = &v
	return s
}

// Specifies an ActivatedRule and indicates whether you want to add it to a
// RuleGroup or delete it from a RuleGroup.
type RuleGroupUpdate struct {
	_ struct{} `type:"structure"`

	// Specify INSERT to add an ActivatedRule to a RuleGroup. Use DELETE to remove
	// an ActivatedRule from a RuleGroup.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// The ActivatedRule object specifies a Rule that you want to insert or delete,
	// the priority of the Rule in the WebACL, and the action that you want AWS
	// WAF to take when a web request matches the Rule (ALLOW, BLOCK, or COUNT).
	//
	// ActivatedRule is a required field
	ActivatedRule *ActivatedRule `type:"structure" required:"true"`
}

// String returns the string representation
func (s RuleGroupUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleGroupUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleGroupUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleGroupUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ActivatedRule == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivatedRule"))
	}
	if s.ActivatedRule != nil {
		if err := s.ActivatedRule.Validate(); err != nil {
			invalidParams.AddNested("ActivatedRule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *RuleGroupUpdate) SetAction(v string) *RuleGroupUpdate {
	s.Action = &v
	return s
}

// SetActivatedRule sets the ActivatedRule field's value.
func (s *RuleGroupUpdate) SetActivatedRule(v *ActivatedRule) *RuleGroupUpdate {
	s.ActivatedRule = v
	return s
}

// Contains the identifier and the friendly name or description of the Rule.
type RuleSummary struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the Rule. You can't change the name of
	// a Rule after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a Rule. You use RuleId to get more information about
	// a Rule (see GetRule), update a Rule (see UpdateRule), insert a Rule into
	// a WebACL or delete one from a WebACL (see UpdateWebACL), or delete a Rule
	// from AWS WAF (see DeleteRule).
	//
	// RuleId is returned by CreateRule and by ListRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s RuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RuleSummary) SetName(v string) *RuleSummary {
	s.Name = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *RuleSummary) SetRuleId(v string) *RuleSummary {
	s.RuleId = &v
	return s
}

// Specifies a Predicate (such as an IPSet) and indicates whether you want to
// add it to a Rule or delete it from a Rule.
type RuleUpdate struct {
	_ struct{} `type:"structure"`

	// Specify INSERT to add a Predicate to a Rule. Use DELETE to remove a Predicate
	// from a Rule.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// The ID of the Predicate (such as an IPSet) that you want to add to a Rule.
	//
	// Predicate is a required field
	Predicate *Predicate `type:"structure" required:"true"`
}

// String returns the string representation
func (s RuleUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RuleUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RuleUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.Predicate == nil {
		invalidParams.Add(request.NewErrParamRequired("Predicate"))
	}
	if s.Predicate != nil {
		if err := s.Predicate.Validate(); err != nil {
			invalidParams.AddNested("Predicate", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *RuleUpdate) SetAction(v string) *RuleUpdate {
	s.Action = &v
	return s
}

// SetPredicate sets the Predicate field's value.
func (s *RuleUpdate) SetPredicate(v *Predicate) *RuleUpdate {
	s.Predicate = v
	return s
}

// The response from a GetSampledRequests request includes a SampledHTTPRequests
// complex type that appears as SampledRequests in the response syntax. SampledHTTPRequests
// contains one SampledHTTPRequest object for each web request that is returned
// by GetSampledRequests.
type SampledHTTPRequest struct {
	_ struct{} `type:"structure"`

	// The action for the Rule that the request matched: ALLOW, BLOCK, or COUNT.
	Action *string `type:"string"`

	// A complex type that contains detailed information about the request.
	//
	// Request is a required field
	Request *HTTPRequest `type:"structure" required:"true"`

	// This value is returned if the GetSampledRequests request specifies the ID
	// of a RuleGroup rather than the ID of an individual rule. RuleWithinRuleGroup
	// is the rule within the specified RuleGroup that matched the request listed
	// in the response.
	RuleWithinRuleGroup *string `min:"1" type:"string"`

	// The time at which AWS WAF received the request from your AWS resource, in
	// Unix time format (in seconds).
	Timestamp *time.Time `type:"timestamp"`

	// A value that indicates how one result in the response relates proportionally
	// to other results in the response. A result that has a weight of 2 represents
	// roughly twice as many CloudFront web requests as a result that has a weight
	// of 1.
	//
	// Weight is a required field
	Weight *int64 `type:"long" required:"true"`
}

// String returns the string representation
func (s SampledHTTPRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SampledHTTPRequest) GoString() string {
	return s.String()
}

// SetAction sets the Action field's value.
func (s *SampledHTTPRequest) SetAction(v string) *SampledHTTPRequest {
	s.Action = &v
	return s
}

// SetRequest sets the Request field's value.
func (s *SampledHTTPRequest) SetRequest(v *HTTPRequest) *SampledHTTPRequest {
	s.Request = v
	return s
}

// SetRuleWithinRuleGroup sets the RuleWithinRuleGroup field's value.
func (s *SampledHTTPRequest) SetRuleWithinRuleGroup(v string) *SampledHTTPRequest {
	s.RuleWithinRuleGroup = &v
	return s
}

// SetTimestamp sets the Timestamp field's value.
func (s *SampledHTTPRequest) SetTimestamp(v time.Time) *SampledHTTPRequest {
	s.Timestamp = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *SampledHTTPRequest) SetWeight(v int64) *SampledHTTPRequest {
	s.Weight = &v
	return s
}

// AWS WAF is not able to access the service linked role. This can be caused
// by a previous PutLoggingConfiguration request, which can lock the service
// linked role for about 20 seconds. Please try your request again. The service
// linked role can also be locked by a previous DeleteServiceLinkedRole request,
// which can lock the role for 15 minutes or more. If you recently made a DeleteServiceLinkedRole,
// wait at least 15 minutes and try the request again. If you receive this same
// exception again, you will have to wait additional time until the role is
// unlocked.
type ServiceLinkedRoleErrorException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s ServiceLinkedRoleErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceLinkedRoleErrorException) GoString() string {
	return s.String()
}

func newErrorServiceLinkedRoleErrorException(v protocol.ResponseMetadata) error {
	return &ServiceLinkedRoleErrorException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ServiceLinkedRoleErrorException) Code() string {
	return "WAFServiceLinkedRoleErrorException"
}

// Message returns the exception's message.
func (s ServiceLinkedRoleErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ServiceLinkedRoleErrorException) OrigErr() error {
	return nil
}

func (s ServiceLinkedRoleErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ServiceLinkedRoleErrorException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ServiceLinkedRoleErrorException) RequestID() string {
	return s.respMetadata.RequestID
}

// Specifies a constraint on the size of a part of the web request. AWS WAF
// uses the Size, ComparisonOperator, and FieldToMatch to build an expression
// in the form of "Size ComparisonOperator size in bytes of FieldToMatch". If
// that expression is true, the SizeConstraint is considered to match.
type SizeConstraint struct {
	_ struct{} `type:"structure"`

	// The type of comparison you want AWS WAF to perform. AWS WAF uses this in
	// combination with the provided Size and FieldToMatch to build an expression
	// in the form of "Size ComparisonOperator size in bytes of FieldToMatch". If
	// that expression is true, the SizeConstraint is considered to match.
	//
	// EQ: Used to test if the Size is equal to the size of the FieldToMatch
	//
	// NE: Used to test if the Size is not equal to the size of the FieldToMatch
	//
	// LE: Used to test if the Size is less than or equal to the size of the FieldToMatch
	//
	// LT: Used to test if the Size is strictly less than the size of the FieldToMatch
	//
	// GE: Used to test if the Size is greater than or equal to the size of the
	// FieldToMatch
	//
	// GT: Used to test if the Size is strictly greater than the size of the FieldToMatch
	//
	// ComparisonOperator is a required field
	ComparisonOperator *string `type:"string" required:"true" enum:"ComparisonOperator"`

	// Specifies where in a web request to look for the size constraint.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// The size in bytes that you want AWS WAF to compare against the size of the
	// specified FieldToMatch. AWS WAF uses this in combination with ComparisonOperator
	// and FieldToMatch to build an expression in the form of "Size ComparisonOperator
	// size in bytes of FieldToMatch". If that expression is true, the SizeConstraint
	// is considered to match.
	//
	// Valid values for size are 0 - 21474836480 bytes (0 - 20 GB).
	//
	// If you specify URI for the value of Type, the / in the URI counts as one
	// character. For example, the URI /logo.jpg is nine characters long.
	//
	// Size is a required field
	Size *int64 `type:"long" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass AWS WAF. If you specify a transformation,
	// AWS WAF performs the transformation on FieldToMatch before inspecting a request
	// for a match.
	//
	// You can only specify a single type of TextTransformation.
	//
	// Note that if you choose BODY for the value of Type, you must choose NONE
	// for TextTransformation because CloudFront forwards only the first 8192 bytes
	// for inspection.
	//
	// NONE
	//
	// Specify NONE if you don't want to perform any text transformations.
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system command
	// line command and using unusual formatting to disguise some or all of the
	// command, use this option to perform the following transformations:
	//
	//    * Delete the following characters: \ " ' ^
	//
	//    * Delete spaces before the following characters: / (
	//
	//    * Replace the following characters with a space: , ;
	//
	//    * Replace multiple spaces with one space
	//
	//    * Convert uppercase letters (A-Z) to lowercase (a-z)
	//
	// COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//    * \f, formfeed, decimal 12
	//
	//    * \t, tab, decimal 9
	//
	//    * \n, newline, decimal 10
	//
	//    * \r, carriage return, decimal 13
	//
	//    * \v, vertical tab, decimal 11
	//
	//    * non-breaking space, decimal 160
	//
	// COMPRESS_WHITE_SPACE also replaces multiple spaces with one space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//    * Replaces (ampersand)quot; with "
	//
	//    * Replaces (ampersand)nbsp; with a non-breaking space, decimal 160
	//
	//    * Replaces (ampersand)lt; with a "less than" symbol
	//
	//    * Replaces (ampersand)gt; with >
	//
	//    * Replaces characters that are represented in hexadecimal format, (ampersand)#xhhhh;,
	//    with the corresponding characters
	//
	//    * Replaces characters that are represented in decimal format, (ampersand)#nnnn;,
	//    with the corresponding characters
	//
	// LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	//
	// TextTransformation is a required field
	TextTransformation *string `type:"string" required:"true" enum:"TextTransformation"`
}

// String returns the string representation
func (s SizeConstraint) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraint) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SizeConstraint) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SizeConstraint"}
	if s.ComparisonOperator == nil {
		invalidParams.Add(request.NewErrParamRequired("ComparisonOperator"))
	}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}
	if s.TextTransformation == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformation"))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *SizeConstraint) SetComparisonOperator(v string) *SizeConstraint {
	s.ComparisonOperator = &v
	return s
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *SizeConstraint) SetFieldToMatch(v *FieldToMatch) *SizeConstraint {
	s.FieldToMatch = v
	return s
}

// SetSize sets the Size field's value.
func (s *SizeConstraint) SetSize(v int64) *SizeConstraint {
	s.Size = &v
	return s
}

// SetTextTransformation sets the TextTransformation field's value.
func (s *SizeConstraint) SetTextTransformation(v string) *SizeConstraint {
	s.TextTransformation = &v
	return s
}

// A complex type that contains SizeConstraint objects, which specify the parts
// of web requests that you want AWS WAF to inspect the size of. If a SizeConstraintSet
// contains more than one SizeConstraint object, a request only needs to match
// one constraint to be considered a match.
type SizeConstraintSet struct {
	_ struct{} `type:"structure"`

	// The name, if any, of the SizeConstraintSet.
	Name *string `min:"1" type:"string"`

	// A unique identifier for a SizeConstraintSet. You use SizeConstraintSetId
	// to get information about a SizeConstraintSet (see GetSizeConstraintSet),
	// update a SizeConstraintSet (see UpdateSizeConstraintSet), insert a SizeConstraintSet
	// into a Rule or delete one from a Rule (see UpdateRule), and delete a SizeConstraintSet
	// from AWS WAF (see DeleteSizeConstraintSet).
	//
	// SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	//
	// SizeConstraintSetId is a required field
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`

	// Specifies the parts of web requests that you want to inspect the size of.
	//
	// SizeConstraints is a required field
	SizeConstraints []*SizeConstraint `type:"list" required:"true"`
}

// String returns the string representation
func (s SizeConstraintSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraintSet) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SizeConstraintSet) SetName(v string) *SizeConstraintSet {
	s.Name = &v
	return s
}

// SetSizeConstraintSetId sets the SizeConstraintSetId field's value.
func (s *SizeConstraintSet) SetSizeConstraintSetId(v string) *SizeConstraintSet {
	s.SizeConstraintSetId = &v
	return s
}

// SetSizeConstraints sets the SizeConstraints field's value.
func (s *SizeConstraintSet) SetSizeConstraints(v []*SizeConstraint) *SizeConstraintSet {
	s.SizeConstraints = v
	return s
}

// The Id and Name of a SizeConstraintSet.
type SizeConstraintSetSummary struct {
	_ struct{} `type:"structure"`

	// The name of the SizeConstraintSet, if any.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a SizeConstraintSet. You use SizeConstraintSetId
	// to get information about a SizeConstraintSet (see GetSizeConstraintSet),
	// update a SizeConstraintSet (see UpdateSizeConstraintSet), insert a SizeConstraintSet
	// into a Rule or delete one from a Rule (see UpdateRule), and delete a SizeConstraintSet
	// from AWS WAF (see DeleteSizeConstraintSet).
	//
	// SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	//
	// SizeConstraintSetId is a required field
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SizeConstraintSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraintSetSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SizeConstraintSetSummary) SetName(v string) *SizeConstraintSetSummary {
	s.Name = &v
	return s
}

// SetSizeConstraintSetId sets the SizeConstraintSetId field's value.
func (s *SizeConstraintSetSummary) SetSizeConstraintSetId(v string) *SizeConstraintSetSummary {
	s.SizeConstraintSetId = &v
	return s
}

// Specifies the part of a web request that you want to inspect the size of
// and indicates whether you want to add the specification to a SizeConstraintSet
// or delete it from a SizeConstraintSet.
type SizeConstraintSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specify INSERT to add a SizeConstraintSetUpdate to a SizeConstraintSet. Use
	// DELETE to remove a SizeConstraintSetUpdate from a SizeConstraintSet.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Specifies a constraint on the size of a part of the web request. AWS WAF
	// uses the Size, ComparisonOperator, and FieldToMatch to build an expression
	// in the form of "Size ComparisonOperator size in bytes of FieldToMatch". If
	// that expression is true, the SizeConstraint is considered to match.
	//
	// SizeConstraint is a required field
	SizeConstraint *SizeConstraint `type:"structure" required:"true"`
}

// String returns the string representation
func (s SizeConstraintSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SizeConstraintSetUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SizeConstraintSetUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SizeConstraintSetUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.SizeConstraint == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeConstraint"))
	}
	if s.SizeConstraint != nil {
		if err := s.SizeConstraint.Validate(); err != nil {
			invalidParams.AddNested("SizeConstraint", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *SizeConstraintSetUpdate) SetAction(v string) *SizeConstraintSetUpdate {
	s.Action = &v
	return s
}

// SetSizeConstraint sets the SizeConstraint field's value.
func (s *SizeConstraintSetUpdate) SetSizeConstraint(v *SizeConstraint) *SizeConstraintSetUpdate {
	s.SizeConstraint = v
	return s
}

// A complex type that contains SqlInjectionMatchTuple objects, which specify
// the parts of web requests that you want AWS WAF to inspect for snippets of
// malicious SQL code and, if you want AWS WAF to inspect a header, the name
// of the header. If a SqlInjectionMatchSet contains more than one SqlInjectionMatchTuple
// object, a request needs to include snippets of SQL code in only one of the
// specified parts of the request to be considered a match.
type SqlInjectionMatchSet struct {
	_ struct{} `type:"structure"`

	// The name, if any, of the SqlInjectionMatchSet.
	Name *string `min:"1" type:"string"`

	// A unique identifier for a SqlInjectionMatchSet. You use SqlInjectionMatchSetId
	// to get information about a SqlInjectionMatchSet (see GetSqlInjectionMatchSet),
	// update a SqlInjectionMatchSet (see UpdateSqlInjectionMatchSet), insert a
	// SqlInjectionMatchSet into a Rule or delete one from a Rule (see UpdateRule),
	// and delete a SqlInjectionMatchSet from AWS WAF (see DeleteSqlInjectionMatchSet).
	//
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	//
	// SqlInjectionMatchSetId is a required field
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`

	// Specifies the parts of web requests that you want to inspect for snippets
	// of malicious SQL code.
	//
	// SqlInjectionMatchTuples is a required field
	SqlInjectionMatchTuples []*SqlInjectionMatchTuple `type:"list" required:"true"`
}

// String returns the string representation
func (s SqlInjectionMatchSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlInjectionMatchSet) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SqlInjectionMatchSet) SetName(v string) *SqlInjectionMatchSet {
	s.Name = &v
	return s
}

// SetSqlInjectionMatchSetId sets the SqlInjectionMatchSetId field's value.
func (s *SqlInjectionMatchSet) SetSqlInjectionMatchSetId(v string) *SqlInjectionMatchSet {
	s.SqlInjectionMatchSetId = &v
	return s
}

// SetSqlInjectionMatchTuples sets the SqlInjectionMatchTuples field's value.
func (s *SqlInjectionMatchSet) SetSqlInjectionMatchTuples(v []*SqlInjectionMatchTuple) *SqlInjectionMatchSet {
	s.SqlInjectionMatchTuples = v
	return s
}

// The Id and Name of a SqlInjectionMatchSet.
type SqlInjectionMatchSetSummary struct {
	_ struct{} `type:"structure"`

	// The name of the SqlInjectionMatchSet, if any, specified by Id.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a SqlInjectionMatchSet. You use SqlInjectionMatchSetId
	// to get information about a SqlInjectionMatchSet (see GetSqlInjectionMatchSet),
	// update a SqlInjectionMatchSet (see UpdateSqlInjectionMatchSet), insert a
	// SqlInjectionMatchSet into a Rule or delete one from a Rule (see UpdateRule),
	// and delete a SqlInjectionMatchSet from AWS WAF (see DeleteSqlInjectionMatchSet).
	//
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	//
	// SqlInjectionMatchSetId is a required field
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SqlInjectionMatchSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlInjectionMatchSetSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *SqlInjectionMatchSetSummary) SetName(v string) *SqlInjectionMatchSetSummary {
	s.Name = &v
	return s
}

// SetSqlInjectionMatchSetId sets the SqlInjectionMatchSetId field's value.
func (s *SqlInjectionMatchSetSummary) SetSqlInjectionMatchSetId(v string) *SqlInjectionMatchSetSummary {
	s.SqlInjectionMatchSetId = &v
	return s
}

// Specifies the part of a web request that you want to inspect for snippets
// of malicious SQL code and indicates whether you want to add the specification
// to a SqlInjectionMatchSet or delete it from a SqlInjectionMatchSet.
type SqlInjectionMatchSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specify INSERT to add a SqlInjectionMatchSetUpdate to a SqlInjectionMatchSet.
	// Use DELETE to remove a SqlInjectionMatchSetUpdate from a SqlInjectionMatchSet.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Specifies the part of a web request that you want AWS WAF to inspect for
	// snippets of malicious SQL code and, if you want AWS WAF to inspect a header,
	// the name of the header.
	//
	// SqlInjectionMatchTuple is a required field
	SqlInjectionMatchTuple *SqlInjectionMatchTuple `type:"structure" required:"true"`
}

// String returns the string representation
func (s SqlInjectionMatchSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlInjectionMatchSetUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlInjectionMatchSetUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqlInjectionMatchSetUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.SqlInjectionMatchTuple == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlInjectionMatchTuple"))
	}
	if s.SqlInjectionMatchTuple != nil {
		if err := s.SqlInjectionMatchTuple.Validate(); err != nil {
			invalidParams.AddNested("SqlInjectionMatchTuple", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *SqlInjectionMatchSetUpdate) SetAction(v string) *SqlInjectionMatchSetUpdate {
	s.Action = &v
	return s
}

// SetSqlInjectionMatchTuple sets the SqlInjectionMatchTuple field's value.
func (s *SqlInjectionMatchSetUpdate) SetSqlInjectionMatchTuple(v *SqlInjectionMatchTuple) *SqlInjectionMatchSetUpdate {
	s.SqlInjectionMatchTuple = v
	return s
}

// Specifies the part of a web request that you want AWS WAF to inspect for
// snippets of malicious SQL code and, if you want AWS WAF to inspect a header,
// the name of the header.
type SqlInjectionMatchTuple struct {
	_ struct{} `type:"structure"`

	// Specifies where in a web request to look for snippets of malicious SQL code.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass AWS WAF. If you specify a transformation,
	// AWS WAF performs the transformation on FieldToMatch before inspecting a request
	// for a match.
	//
	// You can only specify a single type of TextTransformation.
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system command
	// line command and using unusual formatting to disguise some or all of the
	// command, use this option to perform the following transformations:
	//
	//    * Delete the following characters: \ " ' ^
	//
	//    * Delete spaces before the following characters: / (
	//
	//    * Replace the following characters with a space: , ;
	//
	//    * Replace multiple spaces with one space
	//
	//    * Convert uppercase letters (A-Z) to lowercase (a-z)
	//
	// COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//    * \f, formfeed, decimal 12
	//
	//    * \t, tab, decimal 9
	//
	//    * \n, newline, decimal 10
	//
	//    * \r, carriage return, decimal 13
	//
	//    * \v, vertical tab, decimal 11
	//
	//    * non-breaking space, decimal 160
	//
	// COMPRESS_WHITE_SPACE also replaces multiple spaces with one space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//    * Replaces (ampersand)quot; with "
	//
	//    * Replaces (ampersand)nbsp; with a non-breaking space, decimal 160
	//
	//    * Replaces (ampersand)lt; with a "less than" symbol
	//
	//    * Replaces (ampersand)gt; with >
	//
	//    * Replaces characters that are represented in hexadecimal format, (ampersand)#xhhhh;,
	//    with the corresponding characters
	//
	//    * Replaces characters that are represented in decimal format, (ampersand)#nnnn;,
	//    with the corresponding characters
	//
	// LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	//
	// NONE
	//
	// Specify NONE if you don't want to perform any text transformations.
	//
	// TextTransformation is a required field
	TextTransformation *string `type:"string" required:"true" enum:"TextTransformation"`
}

// String returns the string representation
func (s SqlInjectionMatchTuple) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SqlInjectionMatchTuple) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SqlInjectionMatchTuple) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SqlInjectionMatchTuple"}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.TextTransformation == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformation"))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *SqlInjectionMatchTuple) SetFieldToMatch(v *FieldToMatch) *SqlInjectionMatchTuple {
	s.FieldToMatch = v
	return s
}

// SetTextTransformation sets the TextTransformation field's value.
func (s *SqlInjectionMatchTuple) SetTextTransformation(v string) *SqlInjectionMatchTuple {
	s.TextTransformation = &v
	return s
}

// The operation failed because you tried to create, update, or delete an object
// by using a change token that has already been used.
type StaleDataException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s StaleDataException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s StaleDataException) GoString() string {
	return s.String()
}

func newErrorStaleDataException(v protocol.ResponseMetadata) error {
	return &StaleDataException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s StaleDataException) Code() string {
	return "WAFStaleDataException"
}

// Message returns the exception's message.
func (s StaleDataException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s StaleDataException) OrigErr() error {
	return nil
}

func (s StaleDataException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s StaleDataException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s StaleDataException) RequestID() string {
	return s.respMetadata.RequestID
}

// A summary of the rule groups you are subscribed to.
type SubscribedRuleGroupSummary struct {
	_ struct{} `type:"structure"`

	// A friendly name or description for the metrics for this RuleGroup. The name
	// can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change the name
	// of the metric after you create the RuleGroup.
	//
	// MetricName is a required field
	MetricName *string `type:"string" required:"true"`

	// A friendly name or description of the RuleGroup. You can't change the name
	// of a RuleGroup after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a RuleGroup.
	//
	// RuleGroupId is a required field
	RuleGroupId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s SubscribedRuleGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscribedRuleGroupSummary) GoString() string {
	return s.String()
}

// SetMetricName sets the MetricName field's value.
func (s *SubscribedRuleGroupSummary) SetMetricName(v string) *SubscribedRuleGroupSummary {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *SubscribedRuleGroupSummary) SetName(v string) *SubscribedRuleGroupSummary {
	s.Name = &v
	return s
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *SubscribedRuleGroupSummary) SetRuleGroupId(v string) *SubscribedRuleGroupSummary {
	s.RuleGroupId = &v
	return s
}

// The specified subscription does not exist.
type SubscriptionNotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s SubscriptionNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s SubscriptionNotFoundException) GoString() string {
	return s.String()
}

func newErrorSubscriptionNotFoundException(v protocol.ResponseMetadata) error {
	return &SubscriptionNotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s SubscriptionNotFoundException) Code() string {
	return "WAFSubscriptionNotFoundException"
}

// Message returns the exception's message.
func (s SubscriptionNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s SubscriptionNotFoundException) OrigErr() error {
	return nil
}

func (s SubscriptionNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s SubscriptionNotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s SubscriptionNotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

type Tag struct {
	_ struct{} `type:"structure"`

	Key *string `min:"1" type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagInfoForResource struct {
	_ struct{} `type:"structure"`

	ResourceARN *string `min:"1" type:"string"`

	TagList []*Tag `min:"1" type:"list"`
}

// String returns the string representation
func (s TagInfoForResource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagInfoForResource) GoString() string {
	return s.String()
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagInfoForResource) SetResourceARN(v string) *TagInfoForResource {
	s.ResourceARN = &v
	return s
}

// SetTagList sets the TagList field's value.
func (s *TagInfoForResource) SetTagList(v []*Tag) *TagInfoForResource {
	s.TagList = v
	return s
}

type TagOperationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TagOperationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagOperationException) GoString() string {
	return s.String()
}

func newErrorTagOperationException(v protocol.ResponseMetadata) error {
	return &TagOperationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s TagOperationException) Code() string {
	return "WAFTagOperationException"
}

// Message returns the exception's message.
func (s TagOperationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s TagOperationException) OrigErr() error {
	return nil
}

func (s TagOperationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s TagOperationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s TagOperationException) RequestID() string {
	return s.respMetadata.RequestID
}

type TagOperationInternalErrorException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation
func (s TagOperationInternalErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagOperationInternalErrorException) GoString() string {
	return s.String()
}

func newErrorTagOperationInternalErrorException(v protocol.ResponseMetadata) error {
	return &TagOperationInternalErrorException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s TagOperationInternalErrorException) Code() string {
	return "WAFTagOperationInternalErrorException"
}

// Message returns the exception's message.
func (s TagOperationInternalErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s TagOperationInternalErrorException) OrigErr() error {
	return nil
}

func (s TagOperationInternalErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s TagOperationInternalErrorException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s TagOperationInternalErrorException) RequestID() string {
	return s.respMetadata.RequestID
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// Tags is a required field
	Tags []*Tag `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *TagResourceInput) SetResourceARN(v string) *TagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v []*Tag) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// In a GetSampledRequests request, the StartTime and EndTime objects specify
// the time range for which you want AWS WAF to return a sample of web requests.
//
// In a GetSampledRequests response, the StartTime and EndTime objects specify
// the time range for which AWS WAF actually returned a sample of web requests.
// AWS WAF gets the specified number of requests from among the first 5,000
// requests that your AWS resource receives during the specified time period.
// If your resource receives more than 5,000 requests during that period, AWS
// WAF stops sampling after the 5,000th request. In that case, EndTime is the
// time that AWS WAF received the 5,000th request.
type TimeWindow struct {
	_ struct{} `type:"structure"`

	// The end of the time range from which you want GetSampledRequests to return
	// a sample of the requests that your AWS resource received. Specify the date
	// and time in the following format: "2016-09-27T14:50Z". You can specify any
	// time range in the previous three hours.
	//
	// EndTime is a required field
	EndTime *time.Time `type:"timestamp" required:"true"`

	// The beginning of the time range from which you want GetSampledRequests to
	// return a sample of the requests that your AWS resource received. Specify
	// the date and time in the following format: "2016-09-27T14:50Z". You can specify
	// any time range in the previous three hours.
	//
	// StartTime is a required field
	StartTime *time.Time `type:"timestamp" required:"true"`
}

// String returns the string representation
func (s TimeWindow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeWindow) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TimeWindow) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TimeWindow"}
	if s.EndTime == nil {
		invalidParams.Add(request.NewErrParamRequired("EndTime"))
	}
	if s.StartTime == nil {
		invalidParams.Add(request.NewErrParamRequired("StartTime"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndTime sets the EndTime field's value.
func (s *TimeWindow) SetEndTime(v time.Time) *TimeWindow {
	s.EndTime = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeWindow) SetStartTime(v time.Time) *TimeWindow {
	s.StartTime = &v
	return s
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// ResourceARN is a required field
	ResourceARN *string `min:"1" type:"string" required:"true"`

	// TagKeys is a required field
	TagKeys []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceARN == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceARN"))
	}
	if s.ResourceARN != nil && len(*s.ResourceARN) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceARN", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceARN sets the ResourceARN field's value.
func (s *UntagResourceInput) SetResourceARN(v string) *UntagResourceInput {
	s.ResourceARN = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateByteMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The ByteMatchSetId of the ByteMatchSet that you want to update. ByteMatchSetId
	// is returned by CreateByteMatchSet and by ListByteMatchSets.
	//
	// ByteMatchSetId is a required field
	ByteMatchSetId *string `min:"1" type:"string" required:"true"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// An array of ByteMatchSetUpdate objects that you want to insert into or delete
	// from a ByteMatchSet. For more information, see the applicable data types:
	//
	//    * ByteMatchSetUpdate: Contains Action and ByteMatchTuple
	//
	//    * ByteMatchTuple: Contains FieldToMatch, PositionalConstraint, TargetString,
	//    and TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	//
	// Updates is a required field
	Updates []*ByteMatchSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateByteMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateByteMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateByteMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateByteMatchSetInput"}
	if s.ByteMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("ByteMatchSetId"))
	}
	if s.ByteMatchSetId != nil && len(*s.ByteMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ByteMatchSetId", 1))
	}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetByteMatchSetId sets the ByteMatchSetId field's value.
func (s *UpdateByteMatchSetInput) SetByteMatchSetId(v string) *UpdateByteMatchSetInput {
	s.ByteMatchSetId = &v
	return s
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateByteMatchSetInput) SetChangeToken(v string) *UpdateByteMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateByteMatchSetInput) SetUpdates(v []*ByteMatchSetUpdate) *UpdateByteMatchSetInput {
	s.Updates = v
	return s
}

type UpdateByteMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateByteMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateByteMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateByteMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateByteMatchSetOutput) SetChangeToken(v string) *UpdateByteMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type UpdateGeoMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The GeoMatchSetId of the GeoMatchSet that you want to update. GeoMatchSetId
	// is returned by CreateGeoMatchSet and by ListGeoMatchSets.
	//
	// GeoMatchSetId is a required field
	GeoMatchSetId *string `min:"1" type:"string" required:"true"`

	// An array of GeoMatchSetUpdate objects that you want to insert into or delete
	// from an GeoMatchSet. For more information, see the applicable data types:
	//
	//    * GeoMatchSetUpdate: Contains Action and GeoMatchConstraint
	//
	//    * GeoMatchConstraint: Contains Type and Value You can have only one Type
	//    and Value per GeoMatchConstraint. To add multiple countries, include multiple
	//    GeoMatchSetUpdate objects in your request.
	//
	// Updates is a required field
	Updates []*GeoMatchSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateGeoMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGeoMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGeoMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGeoMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.GeoMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("GeoMatchSetId"))
	}
	if s.GeoMatchSetId != nil && len(*s.GeoMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("GeoMatchSetId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateGeoMatchSetInput) SetChangeToken(v string) *UpdateGeoMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetGeoMatchSetId sets the GeoMatchSetId field's value.
func (s *UpdateGeoMatchSetInput) SetGeoMatchSetId(v string) *UpdateGeoMatchSetInput {
	s.GeoMatchSetId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateGeoMatchSetInput) SetUpdates(v []*GeoMatchSetUpdate) *UpdateGeoMatchSetInput {
	s.Updates = v
	return s
}

type UpdateGeoMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateGeoMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateGeoMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGeoMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateGeoMatchSetOutput) SetChangeToken(v string) *UpdateGeoMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type UpdateIPSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The IPSetId of the IPSet that you want to update. IPSetId is returned by
	// CreateIPSet and by ListIPSets.
	//
	// IPSetId is a required field
	IPSetId *string `min:"1" type:"string" required:"true"`

	// An array of IPSetUpdate objects that you want to insert into or delete from
	// an IPSet. For more information, see the applicable data types:
	//
	//    * IPSetUpdate: Contains Action and IPSetDescriptor
	//
	//    * IPSetDescriptor: Contains Type and Value
	//
	// You can insert a maximum of 1000 addresses in a single request.
	//
	// Updates is a required field
	Updates []*IPSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateIPSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateIPSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateIPSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.IPSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("IPSetId"))
	}
	if s.IPSetId != nil && len(*s.IPSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IPSetId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateIPSetInput) SetChangeToken(v string) *UpdateIPSetInput {
	s.ChangeToken = &v
	return s
}

// SetIPSetId sets the IPSetId field's value.
func (s *UpdateIPSetInput) SetIPSetId(v string) *UpdateIPSetInput {
	s.IPSetId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateIPSetInput) SetUpdates(v []*IPSetUpdate) *UpdateIPSetInput {
	s.Updates = v
	return s
}

type UpdateIPSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateIPSet request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateIPSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateIPSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateIPSetOutput) SetChangeToken(v string) *UpdateIPSetOutput {
	s.ChangeToken = &v
	return s
}

type UpdateRateBasedRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The maximum number of requests, which have an identical value in the field
	// specified by the RateKey, allowed in a five-minute period. If the number
	// of requests exceeds the RateLimit and the other predicates specified in the
	// rule are also met, AWS WAF triggers the action that is specified for this
	// rule.
	//
	// RateLimit is a required field
	RateLimit *int64 `min:"100" type:"long" required:"true"`

	// The RuleId of the RateBasedRule that you want to update. RuleId is returned
	// by CreateRateBasedRule and by ListRateBasedRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`

	// An array of RuleUpdate objects that you want to insert into or delete from
	// a RateBasedRule.
	//
	// Updates is a required field
	Updates []*RuleUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRateBasedRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRateBasedRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRateBasedRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRateBasedRuleInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RateLimit == nil {
		invalidParams.Add(request.NewErrParamRequired("RateLimit"))
	}
	if s.RateLimit != nil && *s.RateLimit < 100 {
		invalidParams.Add(request.NewErrParamMinValue("RateLimit", 100))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRateBasedRuleInput) SetChangeToken(v string) *UpdateRateBasedRuleInput {
	s.ChangeToken = &v
	return s
}

// SetRateLimit sets the RateLimit field's value.
func (s *UpdateRateBasedRuleInput) SetRateLimit(v int64) *UpdateRateBasedRuleInput {
	s.RateLimit = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *UpdateRateBasedRuleInput) SetRuleId(v string) *UpdateRateBasedRuleInput {
	s.RuleId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateRateBasedRuleInput) SetUpdates(v []*RuleUpdate) *UpdateRateBasedRuleInput {
	s.Updates = v
	return s
}

type UpdateRateBasedRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateRateBasedRule request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRateBasedRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRateBasedRuleOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRateBasedRuleOutput) SetChangeToken(v string) *UpdateRateBasedRuleOutput {
	s.ChangeToken = &v
	return s
}

type UpdateRegexMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RegexMatchSetId of the RegexMatchSet that you want to update. RegexMatchSetId
	// is returned by CreateRegexMatchSet and by ListRegexMatchSets.
	//
	// RegexMatchSetId is a required field
	RegexMatchSetId *string `min:"1" type:"string" required:"true"`

	// An array of RegexMatchSetUpdate objects that you want to insert into or delete
	// from a RegexMatchSet. For more information, see RegexMatchTuple.
	//
	// Updates is a required field
	Updates []*RegexMatchSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRegexMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRegexMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRegexMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRegexMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RegexMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexMatchSetId"))
	}
	if s.RegexMatchSetId != nil && len(*s.RegexMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexMatchSetId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRegexMatchSetInput) SetChangeToken(v string) *UpdateRegexMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetRegexMatchSetId sets the RegexMatchSetId field's value.
func (s *UpdateRegexMatchSetInput) SetRegexMatchSetId(v string) *UpdateRegexMatchSetInput {
	s.RegexMatchSetId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateRegexMatchSetInput) SetUpdates(v []*RegexMatchSetUpdate) *UpdateRegexMatchSetInput {
	s.Updates = v
	return s
}

type UpdateRegexMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateRegexMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRegexMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRegexMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRegexMatchSetOutput) SetChangeToken(v string) *UpdateRegexMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type UpdateRegexPatternSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RegexPatternSetId of the RegexPatternSet that you want to update. RegexPatternSetId
	// is returned by CreateRegexPatternSet and by ListRegexPatternSets.
	//
	// RegexPatternSetId is a required field
	RegexPatternSetId *string `min:"1" type:"string" required:"true"`

	// An array of RegexPatternSetUpdate objects that you want to insert into or
	// delete from a RegexPatternSet.
	//
	// Updates is a required field
	Updates []*RegexPatternSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRegexPatternSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRegexPatternSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRegexPatternSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRegexPatternSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RegexPatternSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("RegexPatternSetId"))
	}
	if s.RegexPatternSetId != nil && len(*s.RegexPatternSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RegexPatternSetId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRegexPatternSetInput) SetChangeToken(v string) *UpdateRegexPatternSetInput {
	s.ChangeToken = &v
	return s
}

// SetRegexPatternSetId sets the RegexPatternSetId field's value.
func (s *UpdateRegexPatternSetInput) SetRegexPatternSetId(v string) *UpdateRegexPatternSetInput {
	s.RegexPatternSetId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateRegexPatternSetInput) SetUpdates(v []*RegexPatternSetUpdate) *UpdateRegexPatternSetInput {
	s.Updates = v
	return s
}

type UpdateRegexPatternSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateRegexPatternSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRegexPatternSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRegexPatternSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRegexPatternSetOutput) SetChangeToken(v string) *UpdateRegexPatternSetOutput {
	s.ChangeToken = &v
	return s
}

type UpdateRuleGroupInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RuleGroupId of the RuleGroup that you want to update. RuleGroupId is
	// returned by CreateRuleGroup and by ListRuleGroups.
	//
	// RuleGroupId is a required field
	RuleGroupId *string `min:"1" type:"string" required:"true"`

	// An array of RuleGroupUpdate objects that you want to insert into or delete
	// from a RuleGroup.
	//
	// You can only insert REGULAR rules into a rule group.
	//
	// ActivatedRule|OverrideAction applies only when updating or adding a RuleGroup
	// to a WebACL. In this case you do not use ActivatedRule|Action. For all other
	// update requests, ActivatedRule|Action is used instead of ActivatedRule|OverrideAction.
	//
	// Updates is a required field
	Updates []*RuleGroupUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRuleGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleGroupInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RuleGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleGroupId"))
	}
	if s.RuleGroupId != nil && len(*s.RuleGroupId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleGroupId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRuleGroupInput) SetChangeToken(v string) *UpdateRuleGroupInput {
	s.ChangeToken = &v
	return s
}

// SetRuleGroupId sets the RuleGroupId field's value.
func (s *UpdateRuleGroupInput) SetRuleGroupId(v string) *UpdateRuleGroupInput {
	s.RuleGroupId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateRuleGroupInput) SetUpdates(v []*RuleGroupUpdate) *UpdateRuleGroupInput {
	s.Updates = v
	return s
}

type UpdateRuleGroupOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateRuleGroup request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRuleGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleGroupOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRuleGroupOutput) SetChangeToken(v string) *UpdateRuleGroupOutput {
	s.ChangeToken = &v
	return s
}

type UpdateRuleInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The RuleId of the Rule that you want to update. RuleId is returned by CreateRule
	// and by ListRules.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`

	// An array of RuleUpdate objects that you want to insert into or delete from
	// a Rule. For more information, see the applicable data types:
	//
	//    * RuleUpdate: Contains Action and Predicate
	//
	//    * Predicate: Contains DataId, Negated, and Type
	//
	//    * FieldToMatch: Contains Data and Type
	//
	// Updates is a required field
	Updates []*RuleUpdate `type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRuleInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.RuleId == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleId"))
	}
	if s.RuleId != nil && len(*s.RuleId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RuleId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRuleInput) SetChangeToken(v string) *UpdateRuleInput {
	s.ChangeToken = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *UpdateRuleInput) SetRuleId(v string) *UpdateRuleInput {
	s.RuleId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateRuleInput) SetUpdates(v []*RuleUpdate) *UpdateRuleInput {
	s.Updates = v
	return s
}

type UpdateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateRule request. You can also
	// use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateRuleOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateRuleOutput) SetChangeToken(v string) *UpdateRuleOutput {
	s.ChangeToken = &v
	return s
}

type UpdateSizeConstraintSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The SizeConstraintSetId of the SizeConstraintSet that you want to update.
	// SizeConstraintSetId is returned by CreateSizeConstraintSet and by ListSizeConstraintSets.
	//
	// SizeConstraintSetId is a required field
	SizeConstraintSetId *string `min:"1" type:"string" required:"true"`

	// An array of SizeConstraintSetUpdate objects that you want to insert into
	// or delete from a SizeConstraintSet. For more information, see the applicable
	// data types:
	//
	//    * SizeConstraintSetUpdate: Contains Action and SizeConstraint
	//
	//    * SizeConstraint: Contains FieldToMatch, TextTransformation, ComparisonOperator,
	//    and Size
	//
	//    * FieldToMatch: Contains Data and Type
	//
	// Updates is a required field
	Updates []*SizeConstraintSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateSizeConstraintSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSizeConstraintSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSizeConstraintSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSizeConstraintSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.SizeConstraintSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SizeConstraintSetId"))
	}
	if s.SizeConstraintSetId != nil && len(*s.SizeConstraintSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SizeConstraintSetId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateSizeConstraintSetInput) SetChangeToken(v string) *UpdateSizeConstraintSetInput {
	s.ChangeToken = &v
	return s
}

// SetSizeConstraintSetId sets the SizeConstraintSetId field's value.
func (s *UpdateSizeConstraintSetInput) SetSizeConstraintSetId(v string) *UpdateSizeConstraintSetInput {
	s.SizeConstraintSetId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateSizeConstraintSetInput) SetUpdates(v []*SizeConstraintSetUpdate) *UpdateSizeConstraintSetInput {
	s.Updates = v
	return s
}

type UpdateSizeConstraintSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateSizeConstraintSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSizeConstraintSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSizeConstraintSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateSizeConstraintSetOutput) SetChangeToken(v string) *UpdateSizeConstraintSetOutput {
	s.ChangeToken = &v
	return s
}

// A request to update a SqlInjectionMatchSet.
type UpdateSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The SqlInjectionMatchSetId of the SqlInjectionMatchSet that you want to update.
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	//
	// SqlInjectionMatchSetId is a required field
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`

	// An array of SqlInjectionMatchSetUpdate objects that you want to insert into
	// or delete from a SqlInjectionMatchSet. For more information, see the applicable
	// data types:
	//
	//    * SqlInjectionMatchSetUpdate: Contains Action and SqlInjectionMatchTuple
	//
	//    * SqlInjectionMatchTuple: Contains FieldToMatch and TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	//
	// Updates is a required field
	Updates []*SqlInjectionMatchSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSqlInjectionMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSqlInjectionMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateSqlInjectionMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.SqlInjectionMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SqlInjectionMatchSetId"))
	}
	if s.SqlInjectionMatchSetId != nil && len(*s.SqlInjectionMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SqlInjectionMatchSetId", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateSqlInjectionMatchSetInput) SetChangeToken(v string) *UpdateSqlInjectionMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetSqlInjectionMatchSetId sets the SqlInjectionMatchSetId field's value.
func (s *UpdateSqlInjectionMatchSetInput) SetSqlInjectionMatchSetId(v string) *UpdateSqlInjectionMatchSetInput {
	s.SqlInjectionMatchSetId = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateSqlInjectionMatchSetInput) SetUpdates(v []*SqlInjectionMatchSetUpdate) *UpdateSqlInjectionMatchSetInput {
	s.Updates = v
	return s
}

// The response to an UpdateSqlInjectionMatchSets request.
type UpdateSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateSqlInjectionMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateSqlInjectionMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateSqlInjectionMatchSetOutput) SetChangeToken(v string) *UpdateSqlInjectionMatchSetOutput {
	s.ChangeToken = &v
	return s
}

type UpdateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// A default action for the web ACL, either ALLOW or BLOCK. AWS WAF performs
	// the default action if a request doesn't match the criteria in any of the
	// rules in a web ACL.
	DefaultAction *WafAction `type:"structure"`

	// An array of updates to make to the WebACL.
	//
	// An array of WebACLUpdate objects that you want to insert into or delete from
	// a WebACL. For more information, see the applicable data types:
	//
	//    * WebACLUpdate: Contains Action and ActivatedRule
	//
	//    * ActivatedRule: Contains Action, OverrideAction, Priority, RuleId, and
	//    Type. ActivatedRule|OverrideAction applies only when updating or adding
	//    a RuleGroup to a WebACL. In this case, you do not use ActivatedRule|Action.
	//    For all other update requests, ActivatedRule|Action is used instead of
	//    ActivatedRule|OverrideAction.
	//
	//    * WafAction: Contains Type
	Updates []*WebACLUpdate `type:"list"`

	// The WebACLId of the WebACL that you want to update. WebACLId is returned
	// by CreateWebACL and by ListWebACLs.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWebACLInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWebACLInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWebACLInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.WebACLId == nil {
		invalidParams.Add(request.NewErrParamRequired("WebACLId"))
	}
	if s.WebACLId != nil && len(*s.WebACLId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WebACLId", 1))
	}
	if s.DefaultAction != nil {
		if err := s.DefaultAction.Validate(); err != nil {
			invalidParams.AddNested("DefaultAction", err.(request.ErrInvalidParams))
		}
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateWebACLInput) SetChangeToken(v string) *UpdateWebACLInput {
	s.ChangeToken = &v
	return s
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *UpdateWebACLInput) SetDefaultAction(v *WafAction) *UpdateWebACLInput {
	s.DefaultAction = v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateWebACLInput) SetUpdates(v []*WebACLUpdate) *UpdateWebACLInput {
	s.Updates = v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *UpdateWebACLInput) SetWebACLId(v string) *UpdateWebACLInput {
	s.WebACLId = &v
	return s
}

type UpdateWebACLOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateWebACL request. You can
	// also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateWebACLOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateWebACLOutput) SetChangeToken(v string) *UpdateWebACLOutput {
	s.ChangeToken = &v
	return s
}

// A request to update an XssMatchSet.
type UpdateXssMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// An array of XssMatchSetUpdate objects that you want to insert into or delete
	// from an XssMatchSet. For more information, see the applicable data types:
	//
	//    * XssMatchSetUpdate: Contains Action and XssMatchTuple
	//
	//    * XssMatchTuple: Contains FieldToMatch and TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	//
	// Updates is a required field
	Updates []*XssMatchSetUpdate `min:"1" type:"list" required:"true"`

	// The XssMatchSetId of the XssMatchSet that you want to update. XssMatchSetId
	// is returned by CreateXssMatchSet and by ListXssMatchSets.
	//
	// XssMatchSetId is a required field
	XssMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateXssMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateXssMatchSetInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateXssMatchSetInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateXssMatchSetInput"}
	if s.ChangeToken == nil {
		invalidParams.Add(request.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ChangeToken", 1))
	}
	if s.Updates == nil {
		invalidParams.Add(request.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Updates", 1))
	}
	if s.XssMatchSetId == nil {
		invalidParams.Add(request.NewErrParamRequired("XssMatchSetId"))
	}
	if s.XssMatchSetId != nil && len(*s.XssMatchSetId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("XssMatchSetId", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateXssMatchSetInput) SetChangeToken(v string) *UpdateXssMatchSetInput {
	s.ChangeToken = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *UpdateXssMatchSetInput) SetUpdates(v []*XssMatchSetUpdate) *UpdateXssMatchSetInput {
	s.Updates = v
	return s
}

// SetXssMatchSetId sets the XssMatchSetId field's value.
func (s *UpdateXssMatchSetInput) SetXssMatchSetId(v string) *UpdateXssMatchSetInput {
	s.XssMatchSetId = &v
	return s
}

// The response to an UpdateXssMatchSets request.
type UpdateXssMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateXssMatchSet request. You
	// can also use this value to query the status of the request. For more information,
	// see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateXssMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateXssMatchSetOutput) GoString() string {
	return s.String()
}

// SetChangeToken sets the ChangeToken field's value.
func (s *UpdateXssMatchSetOutput) SetChangeToken(v string) *UpdateXssMatchSetOutput {
	s.ChangeToken = &v
	return s
}

// For the action that is associated with a rule in a WebACL, specifies the
// action that you want AWS WAF to perform when a web request matches all of
// the conditions in a rule. For the default action in a WebACL, specifies the
// action that you want AWS WAF to take when a web request doesn't match all
// of the conditions in any of the rules in a WebACL.
type WafAction struct {
	_ struct{} `type:"structure"`

	// Specifies how you want AWS WAF to respond to requests that match the settings
	// in a Rule. Valid settings include the following:
	//
	//    * ALLOW: AWS WAF allows requests
	//
	//    * BLOCK: AWS WAF blocks requests
	//
	//    * COUNT: AWS WAF increments a counter of the requests that match all of
	//    the conditions in the rule. AWS WAF then continues to inspect the web
	//    request based on the remaining rules in the web ACL. You can't specify
	//    COUNT for the default action for a WebACL.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"WafActionType"`
}

// String returns the string representation
func (s WafAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WafAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WafAction"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *WafAction) SetType(v string) *WafAction {
	s.Type = &v
	return s
}

// The action to take if any rule within the RuleGroup matches a request.
type WafOverrideAction struct {
	_ struct{} `type:"structure"`

	// COUNT overrides the action specified by the individual rule within a RuleGroup
	// . If set to NONE, the rule's action will take place.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"WafOverrideActionType"`
}

// String returns the string representation
func (s WafOverrideAction) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WafOverrideAction) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WafOverrideAction) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WafOverrideAction"}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetType sets the Type field's value.
func (s *WafOverrideAction) SetType(v string) *WafOverrideAction {
	s.Type = &v
	return s
}

// Contains the Rules that identify the requests that you want to allow, block,
// or count. In a WebACL, you also specify a default action (ALLOW or BLOCK),
// and the action for each Rule that you add to a WebACL, for example, block
// requests from specified IP addresses or block requests from specified referrers.
// You also associate the WebACL with a CloudFront distribution to identify
// the requests that you want AWS WAF to filter. If you add more than one Rule
// to a WebACL, a request needs to match only one of the specifications to be
// allowed, blocked, or counted. For more information, see UpdateWebACL.
type WebACL struct {
	_ struct{} `type:"structure"`

	// The action to perform if none of the Rules contained in the WebACL match.
	// The action is specified by the WafAction object.
	//
	// DefaultAction is a required field
	DefaultAction *WafAction `type:"structure" required:"true"`

	// A friendly name or description for the metrics for this WebACL. The name
	// can contain only alphanumeric characters (A-Z, a-z, 0-9), with maximum length
	// 128 and minimum length one. It can't contain whitespace or metric names reserved
	// for AWS WAF, including "All" and "Default_Action." You can't change MetricName
	// after you create the WebACL.
	MetricName *string `type:"string"`

	// A friendly name or description of the WebACL. You can't change the name of
	// a WebACL after you create it.
	Name *string `min:"1" type:"string"`

	// An array that contains the action for each Rule in a WebACL, the priority
	// of the Rule, and the ID of the Rule.
	//
	// Rules is a required field
	Rules []*ActivatedRule `type:"list" required:"true"`

	// Tha Amazon Resource Name (ARN) of the web ACL.
	WebACLArn *string `min:"1" type:"string"`

	// A unique identifier for a WebACL. You use WebACLId to get information about
	// a WebACL (see GetWebACL), update a WebACL (see UpdateWebACL), and delete
	// a WebACL from AWS WAF (see DeleteWebACL).
	//
	// WebACLId is returned by CreateWebACL and by ListWebACLs.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WebACL) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebACL) GoString() string {
	return s.String()
}

// SetDefaultAction sets the DefaultAction field's value.
func (s *WebACL) SetDefaultAction(v *WafAction) *WebACL {
	s.DefaultAction = v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *WebACL) SetMetricName(v string) *WebACL {
	s.MetricName = &v
	return s
}

// SetName sets the Name field's value.
func (s *WebACL) SetName(v string) *WebACL {
	s.Name = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *WebACL) SetRules(v []*ActivatedRule) *WebACL {
	s.Rules = v
	return s
}

// SetWebACLArn sets the WebACLArn field's value.
func (s *WebACL) SetWebACLArn(v string) *WebACL {
	s.WebACLArn = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *WebACL) SetWebACLId(v string) *WebACL {
	s.WebACLId = &v
	return s
}

// Contains the identifier and the name or description of the WebACL.
type WebACLSummary struct {
	_ struct{} `type:"structure"`

	// A friendly name or description of the WebACL. You can't change the name of
	// a WebACL after you create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for a WebACL. You use WebACLId to get information about
	// a WebACL (see GetWebACL), update a WebACL (see UpdateWebACL), and delete
	// a WebACL from AWS WAF (see DeleteWebACL).
	//
	// WebACLId is returned by CreateWebACL and by ListWebACLs.
	//
	// WebACLId is a required field
	WebACLId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s WebACLSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebACLSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *WebACLSummary) SetName(v string) *WebACLSummary {
	s.Name = &v
	return s
}

// SetWebACLId sets the WebACLId field's value.
func (s *WebACLSummary) SetWebACLId(v string) *WebACLSummary {
	s.WebACLId = &v
	return s
}

// Specifies whether to insert a Rule into or delete a Rule from a WebACL.
type WebACLUpdate struct {
	_ struct{} `type:"structure"`

	// Specifies whether to insert a Rule into or delete a Rule from a WebACL.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// The ActivatedRule object in an UpdateWebACL request specifies a Rule that
	// you want to insert or delete, the priority of the Rule in the WebACL, and
	// the action that you want AWS WAF to take when a web request matches the Rule
	// (ALLOW, BLOCK, or COUNT).
	//
	// ActivatedRule is a required field
	ActivatedRule *ActivatedRule `type:"structure" required:"true"`
}

// String returns the string representation
func (s WebACLUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s WebACLUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WebACLUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WebACLUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.ActivatedRule == nil {
		invalidParams.Add(request.NewErrParamRequired("ActivatedRule"))
	}
	if s.ActivatedRule != nil {
		if err := s.ActivatedRule.Validate(); err != nil {
			invalidParams.AddNested("ActivatedRule", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *WebACLUpdate) SetAction(v string) *WebACLUpdate {
	s.Action = &v
	return s
}

// SetActivatedRule sets the ActivatedRule field's value.
func (s *WebACLUpdate) SetActivatedRule(v *ActivatedRule) *WebACLUpdate {
	s.ActivatedRule = v
	return s
}

// A complex type that contains XssMatchTuple objects, which specify the parts
// of web requests that you want AWS WAF to inspect for cross-site scripting
// attacks and, if you want AWS WAF to inspect a header, the name of the header.
// If a XssMatchSet contains more than one XssMatchTuple object, a request needs
// to include cross-site scripting attacks in only one of the specified parts
// of the request to be considered a match.
type XssMatchSet struct {
	_ struct{} `type:"structure"`

	// The name, if any, of the XssMatchSet.
	Name *string `min:"1" type:"string"`

	// A unique identifier for an XssMatchSet. You use XssMatchSetId to get information
	// about an XssMatchSet (see GetXssMatchSet), update an XssMatchSet (see UpdateXssMatchSet),
	// insert an XssMatchSet into a Rule or delete one from a Rule (see UpdateRule),
	// and delete an XssMatchSet from AWS WAF (see DeleteXssMatchSet).
	//
	// XssMatchSetId is returned by CreateXssMatchSet and by ListXssMatchSets.
	//
	// XssMatchSetId is a required field
	XssMatchSetId *string `min:"1" type:"string" required:"true"`

	// Specifies the parts of web requests that you want to inspect for cross-site
	// scripting attacks.
	//
	// XssMatchTuples is a required field
	XssMatchTuples []*XssMatchTuple `type:"list" required:"true"`
}

// String returns the string representation
func (s XssMatchSet) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s XssMatchSet) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *XssMatchSet) SetName(v string) *XssMatchSet {
	s.Name = &v
	return s
}

// SetXssMatchSetId sets the XssMatchSetId field's value.
func (s *XssMatchSet) SetXssMatchSetId(v string) *XssMatchSet {
	s.XssMatchSetId = &v
	return s
}

// SetXssMatchTuples sets the XssMatchTuples field's value.
func (s *XssMatchSet) SetXssMatchTuples(v []*XssMatchTuple) *XssMatchSet {
	s.XssMatchTuples = v
	return s
}

// The Id and Name of an XssMatchSet.
type XssMatchSetSummary struct {
	_ struct{} `type:"structure"`

	// The name of the XssMatchSet, if any, specified by Id.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// A unique identifier for an XssMatchSet. You use XssMatchSetId to get information
	// about a XssMatchSet (see GetXssMatchSet), update an XssMatchSet (see UpdateXssMatchSet),
	// insert an XssMatchSet into a Rule or delete one from a Rule (see UpdateRule),
	// and delete an XssMatchSet from AWS WAF (see DeleteXssMatchSet).
	//
	// XssMatchSetId is returned by CreateXssMatchSet and by ListXssMatchSets.
	//
	// XssMatchSetId is a required field
	XssMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s XssMatchSetSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s XssMatchSetSummary) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *XssMatchSetSummary) SetName(v string) *XssMatchSetSummary {
	s.Name = &v
	return s
}

// SetXssMatchSetId sets the XssMatchSetId field's value.
func (s *XssMatchSetSummary) SetXssMatchSetId(v string) *XssMatchSetSummary {
	s.XssMatchSetId = &v
	return s
}

// Specifies the part of a web request that you want to inspect for cross-site
// scripting attacks and indicates whether you want to add the specification
// to an XssMatchSet or delete it from an XssMatchSet.
type XssMatchSetUpdate struct {
	_ struct{} `type:"structure"`

	// Specify INSERT to add an XssMatchSetUpdate to an XssMatchSet. Use DELETE
	// to remove an XssMatchSetUpdate from an XssMatchSet.
	//
	// Action is a required field
	Action *string `type:"string" required:"true" enum:"ChangeAction"`

	// Specifies the part of a web request that you want AWS WAF to inspect for
	// cross-site scripting attacks and, if you want AWS WAF to inspect a header,
	// the name of the header.
	//
	// XssMatchTuple is a required field
	XssMatchTuple *XssMatchTuple `type:"structure" required:"true"`
}

// String returns the string representation
func (s XssMatchSetUpdate) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s XssMatchSetUpdate) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *XssMatchSetUpdate) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "XssMatchSetUpdate"}
	if s.Action == nil {
		invalidParams.Add(request.NewErrParamRequired("Action"))
	}
	if s.XssMatchTuple == nil {
		invalidParams.Add(request.NewErrParamRequired("XssMatchTuple"))
	}
	if s.XssMatchTuple != nil {
		if err := s.XssMatchTuple.Validate(); err != nil {
			invalidParams.AddNested("XssMatchTuple", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAction sets the Action field's value.
func (s *XssMatchSetUpdate) SetAction(v string) *XssMatchSetUpdate {
	s.Action = &v
	return s
}

// SetXssMatchTuple sets the XssMatchTuple field's value.
func (s *XssMatchSetUpdate) SetXssMatchTuple(v *XssMatchTuple) *XssMatchSetUpdate {
	s.XssMatchTuple = v
	return s
}

// Specifies the part of a web request that you want AWS WAF to inspect for
// cross-site scripting attacks and, if you want AWS WAF to inspect a header,
// the name of the header.
type XssMatchTuple struct {
	_ struct{} `type:"structure"`

	// Specifies where in a web request to look for cross-site scripting attacks.
	//
	// FieldToMatch is a required field
	FieldToMatch *FieldToMatch `type:"structure" required:"true"`

	// Text transformations eliminate some of the unusual formatting that attackers
	// use in web requests in an effort to bypass AWS WAF. If you specify a transformation,
	// AWS WAF performs the transformation on FieldToMatch before inspecting a request
	// for a match.
	//
	// You can only specify a single type of TextTransformation.
	//
	// CMD_LINE
	//
	// When you're concerned that attackers are injecting an operating system command
	// line command and using unusual formatting to disguise some or all of the
	// command, use this option to perform the following transformations:
	//
	//    * Delete the following characters: \ " ' ^
	//
	//    * Delete spaces before the following characters: / (
	//
	//    * Replace the following characters with a space: , ;
	//
	//    * Replace multiple spaces with one space
	//
	//    * Convert uppercase letters (A-Z) to lowercase (a-z)
	//
	// COMPRESS_WHITE_SPACE
	//
	// Use this option to replace the following characters with a space character
	// (decimal 32):
	//
	//    * \f, formfeed, decimal 12
	//
	//    * \t, tab, decimal 9
	//
	//    * \n, newline, decimal 10
	//
	//    * \r, carriage return, decimal 13
	//
	//    * \v, vertical tab, decimal 11
	//
	//    * non-breaking space, decimal 160
	//
	// COMPRESS_WHITE_SPACE also replaces multiple spaces with one space.
	//
	// HTML_ENTITY_DECODE
	//
	// Use this option to replace HTML-encoded characters with unencoded characters.
	// HTML_ENTITY_DECODE performs the following operations:
	//
	//    * Replaces (ampersand)quot; with "
	//
	//    * Replaces (ampersand)nbsp; with a non-breaking space, decimal 160
	//
	//    * Replaces (ampersand)lt; with a "less than" symbol
	//
	//    * Replaces (ampersand)gt; with >
	//
	//    * Replaces characters that are represented in hexadecimal format, (ampersand)#xhhhh;,
	//    with the corresponding characters
	//
	//    * Replaces characters that are represented in decimal format, (ampersand)#nnnn;,
	//    with the corresponding characters
	//
	// LOWERCASE
	//
	// Use this option to convert uppercase letters (A-Z) to lowercase (a-z).
	//
	// URL_DECODE
	//
	// Use this option to decode a URL-encoded value.
	//
	// NONE
	//
	// Specify NONE if you don't want to perform any text transformations.
	//
	// TextTransformation is a required field
	TextTransformation *string `type:"string" required:"true" enum:"TextTransformation"`
}

// String returns the string representation
func (s XssMatchTuple) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s XssMatchTuple) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *XssMatchTuple) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "XssMatchTuple"}
	if s.FieldToMatch == nil {
		invalidParams.Add(request.NewErrParamRequired("FieldToMatch"))
	}
	if s.TextTransformation == nil {
		invalidParams.Add(request.NewErrParamRequired("TextTransformation"))
	}
	if s.FieldToMatch != nil {
		if err := s.FieldToMatch.Validate(); err != nil {
			invalidParams.AddNested("FieldToMatch", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFieldToMatch sets the FieldToMatch field's value.
func (s *XssMatchTuple) SetFieldToMatch(v *FieldToMatch) *XssMatchTuple {
	s.FieldToMatch = v
	return s
}

// SetTextTransformation sets the TextTransformation field's value.
func (s *XssMatchTuple) SetTextTransformation(v string) *XssMatchTuple {
	s.TextTransformation = &v
	return s
}

const (
	// ChangeActionInsert is a ChangeAction enum value
	ChangeActionInsert = "INSERT"

	// ChangeActionDelete is a ChangeAction enum value
	ChangeActionDelete = "DELETE"
)

const (
	// ChangeTokenStatusProvisioned is a ChangeTokenStatus enum value
	ChangeTokenStatusProvisioned = "PROVISIONED"

	// ChangeTokenStatusPending is a ChangeTokenStatus enum value
	ChangeTokenStatusPending = "PENDING"

	// ChangeTokenStatusInsync is a ChangeTokenStatus enum value
	ChangeTokenStatusInsync = "INSYNC"
)

const (
	// ComparisonOperatorEq is a ComparisonOperator enum value
	ComparisonOperatorEq = "EQ"

	// ComparisonOperatorNe is a ComparisonOperator enum value
	ComparisonOperatorNe = "NE"

	// ComparisonOperatorLe is a ComparisonOperator enum value
	ComparisonOperatorLe = "LE"

	// ComparisonOperatorLt is a ComparisonOperator enum value
	ComparisonOperatorLt = "LT"

	// ComparisonOperatorGe is a ComparisonOperator enum value
	ComparisonOperatorGe = "GE"

	// ComparisonOperatorGt is a ComparisonOperator enum value
	ComparisonOperatorGt = "GT"
)

const (
	// GeoMatchConstraintTypeCountry is a GeoMatchConstraintType enum value
	GeoMatchConstraintTypeCountry = "Country"
)

const (
	// GeoMatchConstraintValueAf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAf = "AF"

	// GeoMatchConstraintValueAx is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAx = "AX"

	// GeoMatchConstraintValueAl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAl = "AL"

	// GeoMatchConstraintValueDz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDz = "DZ"

	// GeoMatchConstraintValueAs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAs = "AS"

	// GeoMatchConstraintValueAd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAd = "AD"

	// GeoMatchConstraintValueAo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAo = "AO"

	// GeoMatchConstraintValueAi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAi = "AI"

	// GeoMatchConstraintValueAq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAq = "AQ"

	// GeoMatchConstraintValueAg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAg = "AG"

	// GeoMatchConstraintValueAr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAr = "AR"

	// GeoMatchConstraintValueAm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAm = "AM"

	// GeoMatchConstraintValueAw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAw = "AW"

	// GeoMatchConstraintValueAu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAu = "AU"

	// GeoMatchConstraintValueAt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAt = "AT"

	// GeoMatchConstraintValueAz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAz = "AZ"

	// GeoMatchConstraintValueBs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBs = "BS"

	// GeoMatchConstraintValueBh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBh = "BH"

	// GeoMatchConstraintValueBd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBd = "BD"

	// GeoMatchConstraintValueBb is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBb = "BB"

	// GeoMatchConstraintValueBy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBy = "BY"

	// GeoMatchConstraintValueBe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBe = "BE"

	// GeoMatchConstraintValueBz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBz = "BZ"

	// GeoMatchConstraintValueBj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBj = "BJ"

	// GeoMatchConstraintValueBm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBm = "BM"

	// GeoMatchConstraintValueBt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBt = "BT"

	// GeoMatchConstraintValueBo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBo = "BO"

	// GeoMatchConstraintValueBq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBq = "BQ"

	// GeoMatchConstraintValueBa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBa = "BA"

	// GeoMatchConstraintValueBw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBw = "BW"

	// GeoMatchConstraintValueBv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBv = "BV"

	// GeoMatchConstraintValueBr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBr = "BR"

	// GeoMatchConstraintValueIo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIo = "IO"

	// GeoMatchConstraintValueBn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBn = "BN"

	// GeoMatchConstraintValueBg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBg = "BG"

	// GeoMatchConstraintValueBf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBf = "BF"

	// GeoMatchConstraintValueBi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBi = "BI"

	// GeoMatchConstraintValueKh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKh = "KH"

	// GeoMatchConstraintValueCm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCm = "CM"

	// GeoMatchConstraintValueCa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCa = "CA"

	// GeoMatchConstraintValueCv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCv = "CV"

	// GeoMatchConstraintValueKy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKy = "KY"

	// GeoMatchConstraintValueCf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCf = "CF"

	// GeoMatchConstraintValueTd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTd = "TD"

	// GeoMatchConstraintValueCl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCl = "CL"

	// GeoMatchConstraintValueCn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCn = "CN"

	// GeoMatchConstraintValueCx is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCx = "CX"

	// GeoMatchConstraintValueCc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCc = "CC"

	// GeoMatchConstraintValueCo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCo = "CO"

	// GeoMatchConstraintValueKm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKm = "KM"

	// GeoMatchConstraintValueCg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCg = "CG"

	// GeoMatchConstraintValueCd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCd = "CD"

	// GeoMatchConstraintValueCk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCk = "CK"

	// GeoMatchConstraintValueCr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCr = "CR"

	// GeoMatchConstraintValueCi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCi = "CI"

	// GeoMatchConstraintValueHr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHr = "HR"

	// GeoMatchConstraintValueCu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCu = "CU"

	// GeoMatchConstraintValueCw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCw = "CW"

	// GeoMatchConstraintValueCy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCy = "CY"

	// GeoMatchConstraintValueCz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCz = "CZ"

	// GeoMatchConstraintValueDk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDk = "DK"

	// GeoMatchConstraintValueDj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDj = "DJ"

	// GeoMatchConstraintValueDm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDm = "DM"

	// GeoMatchConstraintValueDo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDo = "DO"

	// GeoMatchConstraintValueEc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEc = "EC"

	// GeoMatchConstraintValueEg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEg = "EG"

	// GeoMatchConstraintValueSv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSv = "SV"

	// GeoMatchConstraintValueGq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGq = "GQ"

	// GeoMatchConstraintValueEr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEr = "ER"

	// GeoMatchConstraintValueEe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEe = "EE"

	// GeoMatchConstraintValueEt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEt = "ET"

	// GeoMatchConstraintValueFk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFk = "FK"

	// GeoMatchConstraintValueFo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFo = "FO"

	// GeoMatchConstraintValueFj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFj = "FJ"

	// GeoMatchConstraintValueFi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFi = "FI"

	// GeoMatchConstraintValueFr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFr = "FR"

	// GeoMatchConstraintValueGf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGf = "GF"

	// GeoMatchConstraintValuePf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePf = "PF"

	// GeoMatchConstraintValueTf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTf = "TF"

	// GeoMatchConstraintValueGa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGa = "GA"

	// GeoMatchConstraintValueGm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGm = "GM"

	// GeoMatchConstraintValueGe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGe = "GE"

	// GeoMatchConstraintValueDe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueDe = "DE"

	// GeoMatchConstraintValueGh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGh = "GH"

	// GeoMatchConstraintValueGi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGi = "GI"

	// GeoMatchConstraintValueGr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGr = "GR"

	// GeoMatchConstraintValueGl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGl = "GL"

	// GeoMatchConstraintValueGd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGd = "GD"

	// GeoMatchConstraintValueGp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGp = "GP"

	// GeoMatchConstraintValueGu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGu = "GU"

	// GeoMatchConstraintValueGt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGt = "GT"

	// GeoMatchConstraintValueGg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGg = "GG"

	// GeoMatchConstraintValueGn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGn = "GN"

	// GeoMatchConstraintValueGw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGw = "GW"

	// GeoMatchConstraintValueGy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGy = "GY"

	// GeoMatchConstraintValueHt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHt = "HT"

	// GeoMatchConstraintValueHm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHm = "HM"

	// GeoMatchConstraintValueVa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVa = "VA"

	// GeoMatchConstraintValueHn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHn = "HN"

	// GeoMatchConstraintValueHk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHk = "HK"

	// GeoMatchConstraintValueHu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueHu = "HU"

	// GeoMatchConstraintValueIs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIs = "IS"

	// GeoMatchConstraintValueIn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIn = "IN"

	// GeoMatchConstraintValueId is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueId = "ID"

	// GeoMatchConstraintValueIr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIr = "IR"

	// GeoMatchConstraintValueIq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIq = "IQ"

	// GeoMatchConstraintValueIe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIe = "IE"

	// GeoMatchConstraintValueIm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIm = "IM"

	// GeoMatchConstraintValueIl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIl = "IL"

	// GeoMatchConstraintValueIt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueIt = "IT"

	// GeoMatchConstraintValueJm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueJm = "JM"

	// GeoMatchConstraintValueJp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueJp = "JP"

	// GeoMatchConstraintValueJe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueJe = "JE"

	// GeoMatchConstraintValueJo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueJo = "JO"

	// GeoMatchConstraintValueKz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKz = "KZ"

	// GeoMatchConstraintValueKe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKe = "KE"

	// GeoMatchConstraintValueKi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKi = "KI"

	// GeoMatchConstraintValueKp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKp = "KP"

	// GeoMatchConstraintValueKr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKr = "KR"

	// GeoMatchConstraintValueKw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKw = "KW"

	// GeoMatchConstraintValueKg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKg = "KG"

	// GeoMatchConstraintValueLa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLa = "LA"

	// GeoMatchConstraintValueLv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLv = "LV"

	// GeoMatchConstraintValueLb is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLb = "LB"

	// GeoMatchConstraintValueLs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLs = "LS"

	// GeoMatchConstraintValueLr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLr = "LR"

	// GeoMatchConstraintValueLy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLy = "LY"

	// GeoMatchConstraintValueLi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLi = "LI"

	// GeoMatchConstraintValueLt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLt = "LT"

	// GeoMatchConstraintValueLu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLu = "LU"

	// GeoMatchConstraintValueMo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMo = "MO"

	// GeoMatchConstraintValueMk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMk = "MK"

	// GeoMatchConstraintValueMg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMg = "MG"

	// GeoMatchConstraintValueMw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMw = "MW"

	// GeoMatchConstraintValueMy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMy = "MY"

	// GeoMatchConstraintValueMv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMv = "MV"

	// GeoMatchConstraintValueMl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMl = "ML"

	// GeoMatchConstraintValueMt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMt = "MT"

	// GeoMatchConstraintValueMh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMh = "MH"

	// GeoMatchConstraintValueMq is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMq = "MQ"

	// GeoMatchConstraintValueMr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMr = "MR"

	// GeoMatchConstraintValueMu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMu = "MU"

	// GeoMatchConstraintValueYt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueYt = "YT"

	// GeoMatchConstraintValueMx is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMx = "MX"

	// GeoMatchConstraintValueFm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueFm = "FM"

	// GeoMatchConstraintValueMd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMd = "MD"

	// GeoMatchConstraintValueMc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMc = "MC"

	// GeoMatchConstraintValueMn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMn = "MN"

	// GeoMatchConstraintValueMe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMe = "ME"

	// GeoMatchConstraintValueMs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMs = "MS"

	// GeoMatchConstraintValueMa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMa = "MA"

	// GeoMatchConstraintValueMz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMz = "MZ"

	// GeoMatchConstraintValueMm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMm = "MM"

	// GeoMatchConstraintValueNa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNa = "NA"

	// GeoMatchConstraintValueNr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNr = "NR"

	// GeoMatchConstraintValueNp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNp = "NP"

	// GeoMatchConstraintValueNl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNl = "NL"

	// GeoMatchConstraintValueNc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNc = "NC"

	// GeoMatchConstraintValueNz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNz = "NZ"

	// GeoMatchConstraintValueNi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNi = "NI"

	// GeoMatchConstraintValueNe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNe = "NE"

	// GeoMatchConstraintValueNg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNg = "NG"

	// GeoMatchConstraintValueNu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNu = "NU"

	// GeoMatchConstraintValueNf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNf = "NF"

	// GeoMatchConstraintValueMp is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMp = "MP"

	// GeoMatchConstraintValueNo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueNo = "NO"

	// GeoMatchConstraintValueOm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueOm = "OM"

	// GeoMatchConstraintValuePk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePk = "PK"

	// GeoMatchConstraintValuePw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePw = "PW"

	// GeoMatchConstraintValuePs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePs = "PS"

	// GeoMatchConstraintValuePa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePa = "PA"

	// GeoMatchConstraintValuePg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePg = "PG"

	// GeoMatchConstraintValuePy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePy = "PY"

	// GeoMatchConstraintValuePe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePe = "PE"

	// GeoMatchConstraintValuePh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePh = "PH"

	// GeoMatchConstraintValuePn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePn = "PN"

	// GeoMatchConstraintValuePl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePl = "PL"

	// GeoMatchConstraintValuePt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePt = "PT"

	// GeoMatchConstraintValuePr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePr = "PR"

	// GeoMatchConstraintValueQa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueQa = "QA"

	// GeoMatchConstraintValueRe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRe = "RE"

	// GeoMatchConstraintValueRo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRo = "RO"

	// GeoMatchConstraintValueRu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRu = "RU"

	// GeoMatchConstraintValueRw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRw = "RW"

	// GeoMatchConstraintValueBl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueBl = "BL"

	// GeoMatchConstraintValueSh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSh = "SH"

	// GeoMatchConstraintValueKn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueKn = "KN"

	// GeoMatchConstraintValueLc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLc = "LC"

	// GeoMatchConstraintValueMf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueMf = "MF"

	// GeoMatchConstraintValuePm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValuePm = "PM"

	// GeoMatchConstraintValueVc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVc = "VC"

	// GeoMatchConstraintValueWs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueWs = "WS"

	// GeoMatchConstraintValueSm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSm = "SM"

	// GeoMatchConstraintValueSt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSt = "ST"

	// GeoMatchConstraintValueSa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSa = "SA"

	// GeoMatchConstraintValueSn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSn = "SN"

	// GeoMatchConstraintValueRs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueRs = "RS"

	// GeoMatchConstraintValueSc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSc = "SC"

	// GeoMatchConstraintValueSl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSl = "SL"

	// GeoMatchConstraintValueSg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSg = "SG"

	// GeoMatchConstraintValueSx is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSx = "SX"

	// GeoMatchConstraintValueSk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSk = "SK"

	// GeoMatchConstraintValueSi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSi = "SI"

	// GeoMatchConstraintValueSb is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSb = "SB"

	// GeoMatchConstraintValueSo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSo = "SO"

	// GeoMatchConstraintValueZa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueZa = "ZA"

	// GeoMatchConstraintValueGs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGs = "GS"

	// GeoMatchConstraintValueSs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSs = "SS"

	// GeoMatchConstraintValueEs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEs = "ES"

	// GeoMatchConstraintValueLk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueLk = "LK"

	// GeoMatchConstraintValueSd is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSd = "SD"

	// GeoMatchConstraintValueSr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSr = "SR"

	// GeoMatchConstraintValueSj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSj = "SJ"

	// GeoMatchConstraintValueSz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSz = "SZ"

	// GeoMatchConstraintValueSe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSe = "SE"

	// GeoMatchConstraintValueCh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueCh = "CH"

	// GeoMatchConstraintValueSy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueSy = "SY"

	// GeoMatchConstraintValueTw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTw = "TW"

	// GeoMatchConstraintValueTj is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTj = "TJ"

	// GeoMatchConstraintValueTz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTz = "TZ"

	// GeoMatchConstraintValueTh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTh = "TH"

	// GeoMatchConstraintValueTl is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTl = "TL"

	// GeoMatchConstraintValueTg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTg = "TG"

	// GeoMatchConstraintValueTk is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTk = "TK"

	// GeoMatchConstraintValueTo is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTo = "TO"

	// GeoMatchConstraintValueTt is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTt = "TT"

	// GeoMatchConstraintValueTn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTn = "TN"

	// GeoMatchConstraintValueTr is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTr = "TR"

	// GeoMatchConstraintValueTm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTm = "TM"

	// GeoMatchConstraintValueTc is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTc = "TC"

	// GeoMatchConstraintValueTv is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueTv = "TV"

	// GeoMatchConstraintValueUg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUg = "UG"

	// GeoMatchConstraintValueUa is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUa = "UA"

	// GeoMatchConstraintValueAe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueAe = "AE"

	// GeoMatchConstraintValueGb is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueGb = "GB"

	// GeoMatchConstraintValueUs is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUs = "US"

	// GeoMatchConstraintValueUm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUm = "UM"

	// GeoMatchConstraintValueUy is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUy = "UY"

	// GeoMatchConstraintValueUz is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueUz = "UZ"

	// GeoMatchConstraintValueVu is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVu = "VU"

	// GeoMatchConstraintValueVe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVe = "VE"

	// GeoMatchConstraintValueVn is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVn = "VN"

	// GeoMatchConstraintValueVg is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVg = "VG"

	// GeoMatchConstraintValueVi is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueVi = "VI"

	// GeoMatchConstraintValueWf is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueWf = "WF"

	// GeoMatchConstraintValueEh is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueEh = "EH"

	// GeoMatchConstraintValueYe is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueYe = "YE"

	// GeoMatchConstraintValueZm is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueZm = "ZM"

	// GeoMatchConstraintValueZw is a GeoMatchConstraintValue enum value
	GeoMatchConstraintValueZw = "ZW"
)

const (
	// IPSetDescriptorTypeIpv4 is a IPSetDescriptorType enum value
	IPSetDescriptorTypeIpv4 = "IPV4"

	// IPSetDescriptorTypeIpv6 is a IPSetDescriptorType enum value
	IPSetDescriptorTypeIpv6 = "IPV6"
)

const (
	// MatchFieldTypeUri is a MatchFieldType enum value
	MatchFieldTypeUri = "URI"

	// MatchFieldTypeQueryString is a MatchFieldType enum value
	MatchFieldTypeQueryString = "QUERY_STRING"

	// MatchFieldTypeHeader is a MatchFieldType enum value
	MatchFieldTypeHeader = "HEADER"

	// MatchFieldTypeMethod is a MatchFieldType enum value
	MatchFieldTypeMethod = "METHOD"

	// MatchFieldTypeBody is a MatchFieldType enum value
	MatchFieldTypeBody = "BODY"

	// MatchFieldTypeSingleQueryArg is a MatchFieldType enum value
	MatchFieldTypeSingleQueryArg = "SINGLE_QUERY_ARG"

	// MatchFieldTypeAllQueryArgs is a MatchFieldType enum value
	MatchFieldTypeAllQueryArgs = "ALL_QUERY_ARGS"
)

const (
	// ParameterExceptionFieldChangeAction is a ParameterExceptionField enum value
	ParameterExceptionFieldChangeAction = "CHANGE_ACTION"

	// ParameterExceptionFieldWafAction is a ParameterExceptionField enum value
	ParameterExceptionFieldWafAction = "WAF_ACTION"

	// ParameterExceptionFieldWafOverrideAction is a ParameterExceptionField enum value
	ParameterExceptionFieldWafOverrideAction = "WAF_OVERRIDE_ACTION"

	// ParameterExceptionFieldPredicateType is a ParameterExceptionField enum value
	ParameterExceptionFieldPredicateType = "PREDICATE_TYPE"

	// ParameterExceptionFieldIpsetType is a ParameterExceptionField enum value
	ParameterExceptionFieldIpsetType = "IPSET_TYPE"

	// ParameterExceptionFieldByteMatchFieldType is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchFieldType = "BYTE_MATCH_FIELD_TYPE"

	// ParameterExceptionFieldSqlInjectionMatchFieldType is a ParameterExceptionField enum value
	ParameterExceptionFieldSqlInjectionMatchFieldType = "SQL_INJECTION_MATCH_FIELD_TYPE"

	// ParameterExceptionFieldByteMatchTextTransformation is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchTextTransformation = "BYTE_MATCH_TEXT_TRANSFORMATION"

	// ParameterExceptionFieldByteMatchPositionalConstraint is a ParameterExceptionField enum value
	ParameterExceptionFieldByteMatchPositionalConstraint = "BYTE_MATCH_POSITIONAL_CONSTRAINT"

	// ParameterExceptionFieldSizeConstraintComparisonOperator is a ParameterExceptionField enum value
	ParameterExceptionFieldSizeConstraintComparisonOperator = "SIZE_CONSTRAINT_COMPARISON_OPERATOR"

	// ParameterExceptionFieldGeoMatchLocationType is a ParameterExceptionField enum value
	ParameterExceptionFieldGeoMatchLocationType = "GEO_MATCH_LOCATION_TYPE"

	// ParameterExceptionFieldGeoMatchLocationValue is a ParameterExceptionField enum value
	ParameterExceptionFieldGeoMatchLocationValue = "GEO_MATCH_LOCATION_VALUE"

	// ParameterExceptionFieldRateKey is a ParameterExceptionField enum value
	ParameterExceptionFieldRateKey = "RATE_KEY"

	// ParameterExceptionFieldRuleType is a ParameterExceptionField enum value
	ParameterExceptionFieldRuleType = "RULE_TYPE"

	// ParameterExceptionFieldNextMarker is a ParameterExceptionField enum value
	ParameterExceptionFieldNextMarker = "NEXT_MARKER"

	// ParameterExceptionFieldResourceArn is a ParameterExceptionField enum value
	ParameterExceptionFieldResourceArn = "RESOURCE_ARN"

	// ParameterExceptionFieldTags is a ParameterExceptionField enum value
	ParameterExceptionFieldTags = "TAGS"

	// ParameterExceptionFieldTagKeys is a ParameterExceptionField enum value
	ParameterExceptionFieldTagKeys = "TAG_KEYS"
)

const (
	// ParameterExceptionReasonInvalidOption is a ParameterExceptionReason enum value
	ParameterExceptionReasonInvalidOption = "INVALID_OPTION"

	// ParameterExceptionReasonIllegalCombination is a ParameterExceptionReason enum value
	ParameterExceptionReasonIllegalCombination = "ILLEGAL_COMBINATION"

	// ParameterExceptionReasonIllegalArgument is a ParameterExceptionReason enum value
	ParameterExceptionReasonIllegalArgument = "ILLEGAL_ARGUMENT"

	// ParameterExceptionReasonInvalidTagKey is a ParameterExceptionReason enum value
	ParameterExceptionReasonInvalidTagKey = "INVALID_TAG_KEY"
)

const (
	// PositionalConstraintExactly is a PositionalConstraint enum value
	PositionalConstraintExactly = "EXACTLY"

	// PositionalConstraintStartsWith is a PositionalConstraint enum value
	PositionalConstraintStartsWith = "STARTS_WITH"

	// PositionalConstraintEndsWith is a PositionalConstraint enum value
	PositionalConstraintEndsWith = "ENDS_WITH"

	// PositionalConstraintContains is a PositionalConstraint enum value
	PositionalConstraintContains = "CONTAINS"

	// PositionalConstraintContainsWord is a PositionalConstraint enum value
	PositionalConstraintContainsWord = "CONTAINS_WORD"
)

const (
	// PredicateTypeIpmatch is a PredicateType enum value
	PredicateTypeIpmatch = "IPMatch"

	// PredicateTypeByteMatch is a PredicateType enum value
	PredicateTypeByteMatch = "ByteMatch"

	// PredicateTypeSqlInjectionMatch is a PredicateType enum value
	PredicateTypeSqlInjectionMatch = "SqlInjectionMatch"

	// PredicateTypeGeoMatch is a PredicateType enum value
	PredicateTypeGeoMatch = "GeoMatch"

	// PredicateTypeSizeConstraint is a PredicateType enum value
	PredicateTypeSizeConstraint = "SizeConstraint"

	// PredicateTypeXssMatch is a PredicateType enum value
	PredicateTypeXssMatch = "XssMatch"

	// PredicateTypeRegexMatch is a PredicateType enum value
	PredicateTypeRegexMatch = "RegexMatch"
)

const (
	// RateKeyIp is a RateKey enum value
	RateKeyIp = "IP"
)

const (
	// TextTransformationNone is a TextTransformation enum value
	TextTransformationNone = "NONE"

	// TextTransformationCompressWhiteSpace is a TextTransformation enum value
	TextTransformationCompressWhiteSpace = "COMPRESS_WHITE_SPACE"

	// TextTransformationHtmlEntityDecode is a TextTransformation enum value
	TextTransformationHtmlEntityDecode = "HTML_ENTITY_DECODE"

	// TextTransformationLowercase is a TextTransformation enum value
	TextTransformationLowercase = "LOWERCASE"

	// TextTransformationCmdLine is a TextTransformation enum value
	TextTransformationCmdLine = "CMD_LINE"

	// TextTransformationUrlDecode is a TextTransformation enum value
	TextTransformationUrlDecode = "URL_DECODE"
)

const (
	// WafActionTypeBlock is a WafActionType enum value
	WafActionTypeBlock = "BLOCK"

	// WafActionTypeAllow is a WafActionType enum value
	WafActionTypeAllow = "ALLOW"

	// WafActionTypeCount is a WafActionType enum value
	WafActionTypeCount = "COUNT"
)

const (
	// WafOverrideActionTypeNone is a WafOverrideActionType enum value
	WafOverrideActionTypeNone = "NONE"

	// WafOverrideActionTypeCount is a WafOverrideActionType enum value
	WafOverrideActionTypeCount = "COUNT"
)

const (
	// WafRuleTypeRegular is a WafRuleType enum value
	WafRuleTypeRegular = "REGULAR"

	// WafRuleTypeRateBased is a WafRuleType enum value
	WafRuleTypeRateBased = "RATE_BASED"

	// WafRuleTypeGroup is a WafRuleType enum value
	WafRuleTypeGroup = "GROUP"
)
