/*
Copyright the Velero contributors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/vmware-tanzu/velero/pkg/apis/velero/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// PodVolumeBackupLister helps list PodVolumeBackups.
type PodVolumeBackupLister interface {
	// List lists all PodVolumeBackups in the indexer.
	List(selector labels.Selector) (ret []*v1.PodVolumeBackup, err error)
	// PodVolumeBackups returns an object that can list and get PodVolumeBackups.
	PodVolumeBackups(namespace string) PodVolumeBackupNamespaceLister
	PodVolumeBackupListerExpansion
}

// podVolumeBackupLister implements the PodVolumeBackupLister interface.
type podVolumeBackupLister struct {
	indexer cache.Indexer
}

// NewPodVolumeBackupLister returns a new PodVolumeBackupLister.
func NewPodVolumeBackupLister(indexer cache.Indexer) PodVolumeBackupLister {
	return &podVolumeBackupLister{indexer: indexer}
}

// List lists all PodVolumeBackups in the indexer.
func (s *podVolumeBackupLister) List(selector labels.Selector) (ret []*v1.PodVolumeBackup, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PodVolumeBackup))
	})
	return ret, err
}

// PodVolumeBackups returns an object that can list and get PodVolumeBackups.
func (s *podVolumeBackupLister) PodVolumeBackups(namespace string) PodVolumeBackupNamespaceLister {
	return podVolumeBackupNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// PodVolumeBackupNamespaceLister helps list and get PodVolumeBackups.
type PodVolumeBackupNamespaceLister interface {
	// List lists all PodVolumeBackups in the indexer for a given namespace.
	List(selector labels.Selector) (ret []*v1.PodVolumeBackup, err error)
	// Get retrieves the PodVolumeBackup from the indexer for a given namespace and name.
	Get(name string) (*v1.PodVolumeBackup, error)
	PodVolumeBackupNamespaceListerExpansion
}

// podVolumeBackupNamespaceLister implements the PodVolumeBackupNamespaceLister
// interface.
type podVolumeBackupNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all PodVolumeBackups in the indexer for a given namespace.
func (s podVolumeBackupNamespaceLister) List(selector labels.Selector) (ret []*v1.PodVolumeBackup, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.PodVolumeBackup))
	})
	return ret, err
}

// Get retrieves the PodVolumeBackup from the indexer for a given namespace and name.
func (s podVolumeBackupNamespaceLister) Get(name string) (*v1.PodVolumeBackup, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("podvolumebackup"), name)
	}
	return obj.(*v1.PodVolumeBackup), nil
}
