# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AvailableServiceTier(Model):
    """Service Tier details.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar service_tier: The name of the Service Tier. Possible values include:
     'Free', 'Standard', 'Premium', 'PerNode', 'PerGB2018', 'Standalone',
     'CapacityReservation'
    :vartype service_tier: str or ~azure.mgmt.loganalytics.models.SkuNameEnum
    :ivar enabled: True if the Service Tier is enabled for the workspace.
    :vartype enabled: bool
    :ivar minimum_retention: The minimum retention for the Service Tier, in
     days.
    :vartype minimum_retention: long
    :ivar maximum_retention: The maximum retention for the Service Tier, in
     days.
    :vartype maximum_retention: long
    :ivar default_retention: The default retention for the Service Tier, in
     days.
    :vartype default_retention: long
    :ivar capacity_reservation_level: The capacity reservation level in GB per
     day. Returned for the Capacity Reservation Service Tier.
    :vartype capacity_reservation_level: long
    :ivar last_sku_update: Time when the sku was last updated for the
     workspace. Returned for the Capacity Reservation Service Tier.
    :vartype last_sku_update: str
    """

    _validation = {
        'service_tier': {'readonly': True},
        'enabled': {'readonly': True},
        'minimum_retention': {'readonly': True},
        'maximum_retention': {'readonly': True},
        'default_retention': {'readonly': True},
        'capacity_reservation_level': {'readonly': True},
        'last_sku_update': {'readonly': True},
    }

    _attribute_map = {
        'service_tier': {'key': 'serviceTier', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'minimum_retention': {'key': 'minimumRetention', 'type': 'long'},
        'maximum_retention': {'key': 'maximumRetention', 'type': 'long'},
        'default_retention': {'key': 'defaultRetention', 'type': 'long'},
        'capacity_reservation_level': {'key': 'capacityReservationLevel', 'type': 'long'},
        'last_sku_update': {'key': 'lastSkuUpdate', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AvailableServiceTier, self).__init__(**kwargs)
        self.service_tier = None
        self.enabled = None
        self.minimum_retention = None
        self.maximum_retention = None
        self.default_retention = None
        self.capacity_reservation_level = None
        self.last_sku_update = None


class Resource(Model):
    """Resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class AzureEntityResource(Resource):
    """The resource model definition for a Azure Resource Manager resource with an
    etag.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(AzureEntityResource, self).__init__(**kwargs)
        self.etag = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class TrackedResource(Resource):
    """The resource model definition for a ARM tracked top level resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, **kwargs) -> None:
        super(TrackedResource, self).__init__(**kwargs)
        self.tags = tags
        self.location = location


class Cluster(TrackedResource):
    """The top level Log Analytics cluster resource container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param identity: The identity of the resource.
    :type identity: ~azure.mgmt.loganalytics.models.Identity
    :param sku: The sku properties.
    :type sku: ~azure.mgmt.loganalytics.models.ClusterSku
    :param next_link: The link used to get the next page of recommendations.
    :type next_link: str
    :ivar cluster_id: The ID associated with the cluster.
    :vartype cluster_id: str
    :ivar provisioning_state: The provisioning state of the cluster. Possible
     values include: 'Creating', 'Succeeded', 'Failed', 'Canceled', 'Deleting',
     'ProvisioningAccount', 'Updating'
    :vartype provisioning_state: str or
     ~azure.mgmt.loganalytics.models.ClusterEntityStatus
    :param key_vault_properties: The associated key properties.
    :type key_vault_properties:
     ~azure.mgmt.loganalytics.models.KeyVaultProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'cluster_id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'sku': {'key': 'sku', 'type': 'ClusterSku'},
        'next_link': {'key': 'properties.nextLink', 'type': 'str'},
        'cluster_id': {'key': 'properties.clusterId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'KeyVaultProperties'},
    }

    def __init__(self, *, location: str, tags=None, identity=None, sku=None, next_link: str=None, key_vault_properties=None, **kwargs) -> None:
        super(Cluster, self).__init__(tags=tags, location=location, **kwargs)
        self.identity = identity
        self.sku = sku
        self.next_link = next_link
        self.cluster_id = None
        self.provisioning_state = None
        self.key_vault_properties = key_vault_properties


class ClusterErrorResponse(Model):
    """Error response indicates that the service is not able to process the
    incoming request. The reason is provided in the error message.

    :param error: The details of the error.
    :type error: ~azure.mgmt.loganalytics.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(ClusterErrorResponse, self).__init__(**kwargs)
        self.error = error


class ClusterErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ClusterErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ClusterErrorResponseException, self).__init__(deserialize, response, 'ClusterErrorResponse', *args)


class ClusterPatch(Model):
    """The top level Log Analytics cluster resource container.

    :param key_vault_properties: The associated key properties.
    :type key_vault_properties:
     ~azure.mgmt.loganalytics.models.KeyVaultProperties
    :param sku: The sku properties.
    :type sku: ~azure.mgmt.loganalytics.models.ClusterSku
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'key_vault_properties': {'key': 'properties.keyVaultProperties', 'type': 'KeyVaultProperties'},
        'sku': {'key': 'sku', 'type': 'ClusterSku'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, key_vault_properties=None, sku=None, tags=None, **kwargs) -> None:
        super(ClusterPatch, self).__init__(**kwargs)
        self.key_vault_properties = key_vault_properties
        self.sku = sku
        self.tags = tags


class ClusterSku(Model):
    """The cluster sku definition.

    :param capacity: The capacity value
    :type capacity: long
    :param name: The name of the SKU. Possible values include:
     'CapacityReservation'
    :type name: str or ~azure.mgmt.loganalytics.models.ClusterSkuNameEnum
    """

    _attribute_map = {
        'capacity': {'key': 'capacity', 'type': 'long'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, *, capacity: int=None, name=None, **kwargs) -> None:
        super(ClusterSku, self).__init__(**kwargs)
        self.capacity = capacity
        self.name = name


class CoreSummary(Model):
    """The core summary of a search.

    All required parameters must be populated in order to send to Azure.

    :param status: The status of a core summary.
    :type status: str
    :param number_of_documents: Required. The number of documents of a core
     summary.
    :type number_of_documents: long
    """

    _validation = {
        'number_of_documents': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'number_of_documents': {'key': 'numberOfDocuments', 'type': 'long'},
    }

    def __init__(self, *, number_of_documents: int, status: str=None, **kwargs) -> None:
        super(CoreSummary, self).__init__(**kwargs)
        self.status = status
        self.number_of_documents = number_of_documents


class ProxyResource(Resource):
    """The resource model definition for a ARM proxy resource. It will have
    everything other than required location and tags.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs) -> None:
        super(ProxyResource, self).__init__(**kwargs)


class DataExport(ProxyResource):
    """The top level data export resource container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param data_export_id: The data export rule ID.
    :type data_export_id: str
    :param all_tables: When ‘true’, all workspace's tables are exported.
    :type all_tables: bool
    :param table_names: An array of tables to export, for example:
     [“Heartbeat, SecurityEvent”].
    :type table_names: list[str]
    :param resource_id: Required. The destination resource ID. This can be
     copied from the Properties entry of the destination resource in Azure.
    :type resource_id: str
    :ivar data_export_type: The type of the destination resource. Possible
     values include: 'StorageAccount', 'EventHub'
    :vartype data_export_type: str or ~azure.mgmt.loganalytics.models.Type
    :param event_hub_name: Optional. Allows to define an Event Hub name. Not
     applicable when destination is Storage Account.
    :type event_hub_name: str
    :param enable: Active when enabled.
    :type enable: bool
    :param created_date: The latest data export rule modification time.
    :type created_date: str
    :param last_modified_date: Date and time when the export was last
     modified.
    :type last_modified_date: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'resource_id': {'required': True},
        'data_export_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_export_id': {'key': 'properties.dataExportId', 'type': 'str'},
        'all_tables': {'key': 'properties.allTables', 'type': 'bool'},
        'table_names': {'key': 'properties.tableNames', 'type': '[str]'},
        'resource_id': {'key': 'properties.destination.resourceId', 'type': 'str'},
        'data_export_type': {'key': 'properties.destination.type', 'type': 'str'},
        'event_hub_name': {'key': 'properties.destination.metaData.eventHubName', 'type': 'str'},
        'enable': {'key': 'properties.enable', 'type': 'bool'},
        'created_date': {'key': 'properties.createdDate', 'type': 'str'},
        'last_modified_date': {'key': 'properties.lastModifiedDate', 'type': 'str'},
    }

    def __init__(self, *, resource_id: str, data_export_id: str=None, all_tables: bool=None, table_names=None, event_hub_name: str=None, enable: bool=None, created_date: str=None, last_modified_date: str=None, **kwargs) -> None:
        super(DataExport, self).__init__(**kwargs)
        self.data_export_id = data_export_id
        self.all_tables = all_tables
        self.table_names = table_names
        self.resource_id = resource_id
        self.data_export_type = None
        self.event_hub_name = event_hub_name
        self.enable = enable
        self.created_date = created_date
        self.last_modified_date = last_modified_date


class DataExportErrorResponse(Model):
    """Error response indicates that the service is not able to process the
    incoming request. The reason is provided in the error message.

    :param error: The details of the error.
    :type error: ~azure.mgmt.loganalytics.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(DataExportErrorResponse, self).__init__(**kwargs)
        self.error = error


class DataExportErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'DataExportErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(DataExportErrorResponseException, self).__init__(deserialize, response, 'DataExportErrorResponse', *args)


class DataSource(ProxyResource):
    """Datasources under OMS Workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param properties: Required. The data source properties in raw json
     format, each kind of data source have it's own schema.
    :type properties: object
    :param etag: The ETag of the data source.
    :type etag: str
    :param kind: Required. Possible values include: 'WindowsEvent',
     'WindowsPerformanceCounter', 'IISLogs', 'LinuxSyslog',
     'LinuxSyslogCollection', 'LinuxPerformanceObject',
     'LinuxPerformanceCollection', 'CustomLog', 'CustomLogCollection',
     'AzureAuditLog', 'AzureActivityLog', 'GenericDataSource',
     'ChangeTrackingCustomPath', 'ChangeTrackingPath',
     'ChangeTrackingServices', 'ChangeTrackingDataTypeConfiguration',
     'ChangeTrackingDefaultRegistry', 'ChangeTrackingRegistry',
     'ChangeTrackingLinuxPath', 'LinuxChangeTrackingPath',
     'ChangeTrackingContentLocation', 'WindowsTelemetry', 'Office365',
     'SecurityWindowsBaselineConfiguration',
     'SecurityCenterSecurityWindowsBaselineConfiguration',
     'SecurityEventCollectionConfiguration',
     'SecurityInsightsSecurityEventCollectionConfiguration',
     'ImportComputerGroup', 'NetworkMonitoring', 'Itsm', 'DnsAnalytics',
     'ApplicationInsights', 'SqlDataClassification'
    :type kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'properties': {'required': True},
        'kind': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'object'},
        'etag': {'key': 'etag', 'type': 'str'},
        'kind': {'key': 'kind', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, properties, kind, etag: str=None, tags=None, **kwargs) -> None:
        super(DataSource, self).__init__(**kwargs)
        self.properties = properties
        self.etag = etag
        self.kind = kind
        self.tags = tags


class DataSourceFilter(Model):
    """DataSource filter. Right now, only filter by kind is supported.

    :param kind: Possible values include: 'WindowsEvent',
     'WindowsPerformanceCounter', 'IISLogs', 'LinuxSyslog',
     'LinuxSyslogCollection', 'LinuxPerformanceObject',
     'LinuxPerformanceCollection', 'CustomLog', 'CustomLogCollection',
     'AzureAuditLog', 'AzureActivityLog', 'GenericDataSource',
     'ChangeTrackingCustomPath', 'ChangeTrackingPath',
     'ChangeTrackingServices', 'ChangeTrackingDataTypeConfiguration',
     'ChangeTrackingDefaultRegistry', 'ChangeTrackingRegistry',
     'ChangeTrackingLinuxPath', 'LinuxChangeTrackingPath',
     'ChangeTrackingContentLocation', 'WindowsTelemetry', 'Office365',
     'SecurityWindowsBaselineConfiguration',
     'SecurityCenterSecurityWindowsBaselineConfiguration',
     'SecurityEventCollectionConfiguration',
     'SecurityInsightsSecurityEventCollectionConfiguration',
     'ImportComputerGroup', 'NetworkMonitoring', 'Itsm', 'DnsAnalytics',
     'ApplicationInsights', 'SqlDataClassification'
    :type kind: str or ~azure.mgmt.loganalytics.models.DataSourceKind
    """

    _attribute_map = {
        'kind': {'key': 'kind', 'type': 'str'},
    }

    def __init__(self, *, kind=None, **kwargs) -> None:
        super(DataSourceFilter, self).__init__(**kwargs)
        self.kind = kind


class ErrorAdditionalInfo(Model):
    """The resource management error additional info.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: object
    """

    _validation = {
        'type': {'readonly': True},
        'info': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'info': {'key': 'info', 'type': 'object'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorAdditionalInfo, self).__init__(**kwargs)
        self.type = None
        self.info = None


class ErrorContract(Model):
    """Error details.

    Contains details when the response code indicates an error.

    :param error: The details of the error.
    :type error: ~azure.mgmt.loganalytics.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, *, error=None, **kwargs) -> None:
        super(ErrorContract, self).__init__(**kwargs)
        self.error = error


class ErrorContractException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorContract'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorContractException, self).__init__(deserialize, response, 'ErrorContract', *args)


class ErrorResponse(Model):
    """The resource management error response.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.loganalytics.models.ErrorResponse]
    :ivar additional_info: The error additional info.
    :vartype additional_info:
     list[~azure.mgmt.loganalytics.models.ErrorAdditionalInfo]
    """

    _validation = {
        'code': {'readonly': True},
        'message': {'readonly': True},
        'target': {'readonly': True},
        'details': {'readonly': True},
        'additional_info': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'details': {'key': 'details', 'type': '[ErrorResponse]'},
        'additional_info': {'key': 'additionalInfo', 'type': '[ErrorAdditionalInfo]'},
    }

    def __init__(self, **kwargs) -> None:
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = None
        self.message = None
        self.target = None
        self.details = None
        self.additional_info = None


class Identity(Model):
    """Identity for the resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar principal_id: The principal ID of resource identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant ID of resource.
    :vartype tenant_id: str
    :param type: Required. The identity type. Possible values include:
     'SystemAssigned', 'None'
    :type type: str or ~azure.mgmt.loganalytics.models.IdentityType
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'IdentityType'},
    }

    def __init__(self, *, type, **kwargs) -> None:
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type


class IntelligencePack(Model):
    """Intelligence Pack containing a string name and boolean indicating if it's
    enabled.

    :param name: The name of the intelligence pack.
    :type name: str
    :param enabled: The enabled boolean for the intelligence pack.
    :type enabled: bool
    :param display_name: The display name of the intelligence pack.
    :type display_name: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'display_name': {'key': 'displayName', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, enabled: bool=None, display_name: str=None, **kwargs) -> None:
        super(IntelligencePack, self).__init__(**kwargs)
        self.name = name
        self.enabled = enabled
        self.display_name = display_name


class KeyVaultProperties(Model):
    """The key vault properties.

    :param key_vault_uri: The Key Vault uri which holds they key associated
     with the Log Analytics cluster.
    :type key_vault_uri: str
    :param key_name: The name of the key associated with the Log Analytics
     cluster.
    :type key_name: str
    :param key_version: The version of the key associated with the Log
     Analytics cluster.
    :type key_version: str
    """

    _attribute_map = {
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
    }

    def __init__(self, *, key_vault_uri: str=None, key_name: str=None, key_version: str=None, **kwargs) -> None:
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_vault_uri = key_vault_uri
        self.key_name = key_name
        self.key_version = key_version


class LinkedService(ProxyResource):
    """The top level Linked service resource container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param resource_id: The resource id of the resource that will be linked to
     the workspace. This should be used for linking resources which require
     read access
    :type resource_id: str
    :param write_access_resource_id: The resource id of the resource that will
     be linked to the workspace. This should be used for linking resources
     which require write access
    :type write_access_resource_id: str
    :param provisioning_state: The provisioning state of the linked service.
     Possible values include: 'Succeeded', 'Deleting', 'ProvisioningAccount',
     'Updating'
    :type provisioning_state: str or
     ~azure.mgmt.loganalytics.models.LinkedServiceEntityStatus
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'resource_id': {'key': 'properties.resourceId', 'type': 'str'},
        'write_access_resource_id': {'key': 'properties.writeAccessResourceId', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, resource_id: str=None, write_access_resource_id: str=None, provisioning_state=None, tags=None, **kwargs) -> None:
        super(LinkedService, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.write_access_resource_id = write_access_resource_id
        self.provisioning_state = provisioning_state
        self.tags = tags


class LinkedStorageAccountsResource(ProxyResource):
    """Linked storage accounts top level resource container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar data_source_type: Linked storage accounts type. Possible values
     include: 'CustomLogs', 'AzureWatson', 'Query', 'Alerts'
    :vartype data_source_type: str or
     ~azure.mgmt.loganalytics.models.DataSourceType
    :param storage_account_ids: Linked storage accounts resources ids.
    :type storage_account_ids: list[str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'data_source_type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'data_source_type': {'key': 'properties.dataSourceType', 'type': 'DataSourceType'},
        'storage_account_ids': {'key': 'properties.storageAccountIds', 'type': '[str]'},
    }

    def __init__(self, *, storage_account_ids=None, **kwargs) -> None:
        super(LinkedStorageAccountsResource, self).__init__(**kwargs)
        self.data_source_type = None
        self.storage_account_ids = storage_account_ids


class ManagementGroup(Model):
    """A management group that is connected to a workspace.

    :param server_count: The number of servers connected to the management
     group.
    :type server_count: int
    :param is_gateway: Gets or sets a value indicating whether the management
     group is a gateway.
    :type is_gateway: bool
    :param name: The name of the management group.
    :type name: str
    :param id: The unique ID of the management group.
    :type id: str
    :param created: The datetime that the management group was created.
    :type created: datetime
    :param data_received: The last datetime that the management group received
     data.
    :type data_received: datetime
    :param version: The version of System Center that is managing the
     management group.
    :type version: str
    :param sku: The SKU of System Center that is managing the management
     group.
    :type sku: str
    """

    _attribute_map = {
        'server_count': {'key': 'properties.serverCount', 'type': 'int'},
        'is_gateway': {'key': 'properties.isGateway', 'type': 'bool'},
        'name': {'key': 'properties.name', 'type': 'str'},
        'id': {'key': 'properties.id', 'type': 'str'},
        'created': {'key': 'properties.created', 'type': 'iso-8601'},
        'data_received': {'key': 'properties.dataReceived', 'type': 'iso-8601'},
        'version': {'key': 'properties.version', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'str'},
    }

    def __init__(self, *, server_count: int=None, is_gateway: bool=None, name: str=None, id: str=None, created=None, data_received=None, version: str=None, sku: str=None, **kwargs) -> None:
        super(ManagementGroup, self).__init__(**kwargs)
        self.server_count = server_count
        self.is_gateway = is_gateway
        self.name = name
        self.id = id
        self.created = created
        self.data_received = data_received
        self.version = version
        self.sku = sku


class MetricName(Model):
    """The name of a metric.

    :param value: The system name of the metric.
    :type value: str
    :param localized_value: The localized name of the metric.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(self, *, value: str=None, localized_value: str=None, **kwargs) -> None:
        super(MetricName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class Operation(Model):
    """Supported operation of OperationalInsights resource provider.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: Display metadata associated with the operation.
    :type display: ~azure.mgmt.loganalytics.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, *, name: str=None, display=None, **kwargs) -> None:
        super(Operation, self).__init__(**kwargs)
        self.name = name
        self.display = display


class OperationDisplay(Model):
    """Display metadata associated with the operation.

    :param provider: Service provider: Microsoft OperationsManagement.
    :type provider: str
    :param resource: Resource on which the operation is performed etc.
    :type resource: str
    :param operation: Type of operation: get, read, delete, etc.
    :type operation: str
    :param description: Description of operation
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, provider: str=None, resource: str=None, operation: str=None, description: str=None, **kwargs) -> None:
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = provider
        self.resource = resource
        self.operation = operation
        self.description = description


class OperationStatus(Model):
    """The status of operation.

    :param id: The operation Id.
    :type id: str
    :param name: The operation name.
    :type name: str
    :param start_time: The start time of the operation.
    :type start_time: str
    :param end_time: The end time of the operation.
    :type end_time: str
    :param status: The status of the operation.
    :type status: str
    :param error: The error detail of the operation if any.
    :type error: ~azure.mgmt.loganalytics.models.ErrorResponse
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'str'},
        'end_time': {'key': 'endTime', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, *, id: str=None, name: str=None, start_time: str=None, end_time: str=None, status: str=None, error=None, **kwargs) -> None:
        super(OperationStatus, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.start_time = start_time
        self.end_time = end_time
        self.status = status
        self.error = error


class PrivateLinkScopedResource(Model):
    """The private link scope resource reference.

    :param resource_id: The full resource Id of the private link scope
     resource.
    :type resource_id: str
    :param scope_id: The private link scope unique Identifier.
    :type scope_id: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'scope_id': {'key': 'scopeId', 'type': 'str'},
    }

    def __init__(self, *, resource_id: str=None, scope_id: str=None, **kwargs) -> None:
        super(PrivateLinkScopedResource, self).__init__(**kwargs)
        self.resource_id = resource_id
        self.scope_id = scope_id


class SavedSearch(ProxyResource):
    """Value object for saved search results.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param etag: The ETag of the saved search.
    :type etag: str
    :param category: Required. The category of the saved search. This helps
     the user to find a saved search faster.
    :type category: str
    :param display_name: Required. Saved search display name.
    :type display_name: str
    :param query: Required. The query expression for the saved search.
    :type query: str
    :param function_alias: The function alias if query serves as a function.
    :type function_alias: str
    :param function_parameters: The optional function parameters if query
     serves as a function. Value should be in the following format:
     'param-name1:type1 = default_value1, param-name2:type2 = default_value2'.
     For more examples and proper syntax please refer to
     https://docs.microsoft.com/en-us/azure/kusto/query/functions/user-defined-functions.
    :type function_parameters: str
    :param version: The version number of the query language. The current
     version is 2 and is the default.
    :type version: long
    :param tags: The tags attached to the saved search.
    :type tags: list[~azure.mgmt.loganalytics.models.Tag]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'category': {'required': True},
        'display_name': {'required': True},
        'query': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'category': {'key': 'properties.category', 'type': 'str'},
        'display_name': {'key': 'properties.displayName', 'type': 'str'},
        'query': {'key': 'properties.query', 'type': 'str'},
        'function_alias': {'key': 'properties.functionAlias', 'type': 'str'},
        'function_parameters': {'key': 'properties.functionParameters', 'type': 'str'},
        'version': {'key': 'properties.version', 'type': 'long'},
        'tags': {'key': 'properties.tags', 'type': '[Tag]'},
    }

    def __init__(self, *, category: str, display_name: str, query: str, etag: str=None, function_alias: str=None, function_parameters: str=None, version: int=None, tags=None, **kwargs) -> None:
        super(SavedSearch, self).__init__(**kwargs)
        self.etag = etag
        self.category = category
        self.display_name = display_name
        self.query = query
        self.function_alias = function_alias
        self.function_parameters = function_parameters
        self.version = version
        self.tags = tags


class SavedSearchesListResult(Model):
    """The saved search list operation response.

    :param value: The array of result values.
    :type value: list[~azure.mgmt.loganalytics.models.SavedSearch]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[SavedSearch]'},
    }

    def __init__(self, *, value=None, **kwargs) -> None:
        super(SavedSearchesListResult, self).__init__(**kwargs)
        self.value = value


class SearchGetSchemaResponse(Model):
    """The get schema operation response.

    :param metadata: The metadata from search results.
    :type metadata: ~azure.mgmt.loganalytics.models.SearchMetadata
    :param value: The array of result values.
    :type value: list[~azure.mgmt.loganalytics.models.SearchSchemaValue]
    """

    _attribute_map = {
        'metadata': {'key': 'metadata', 'type': 'SearchMetadata'},
        'value': {'key': 'value', 'type': '[SearchSchemaValue]'},
    }

    def __init__(self, *, metadata=None, value=None, **kwargs) -> None:
        super(SearchGetSchemaResponse, self).__init__(**kwargs)
        self.metadata = metadata
        self.value = value


class SearchMetadata(Model):
    """Metadata for search results.

    :param search_id: The request id of the search.
    :type search_id: str
    :param result_type: The search result type.
    :type result_type: str
    :param total: The total number of search results.
    :type total: long
    :param top: The number of top search results.
    :type top: long
    :param id: The id of the search results request.
    :type id: str
    :param core_summaries: The core summaries.
    :type core_summaries: list[~azure.mgmt.loganalytics.models.CoreSummary]
    :param status: The status of the search results.
    :type status: str
    :param start_time: The start time for the search.
    :type start_time: datetime
    :param last_updated: The time of last update.
    :type last_updated: datetime
    :param e_tag: The ETag of the search results.
    :type e_tag: str
    :param sort: How the results are sorted.
    :type sort: list[~azure.mgmt.loganalytics.models.SearchSort]
    :param request_time: The request time.
    :type request_time: long
    :param aggregated_value_field: The aggregated value field.
    :type aggregated_value_field: str
    :param aggregated_grouping_fields: The aggregated grouping fields.
    :type aggregated_grouping_fields: str
    :param sum: The sum of all aggregates returned in the result set.
    :type sum: long
    :param max: The max of all aggregates returned in the result set.
    :type max: long
    :param schema: The schema.
    :type schema: ~azure.mgmt.loganalytics.models.SearchMetadataSchema
    """

    _attribute_map = {
        'search_id': {'key': 'requestId', 'type': 'str'},
        'result_type': {'key': 'resultType', 'type': 'str'},
        'total': {'key': 'total', 'type': 'long'},
        'top': {'key': 'top', 'type': 'long'},
        'id': {'key': 'id', 'type': 'str'},
        'core_summaries': {'key': 'coreSummaries', 'type': '[CoreSummary]'},
        'status': {'key': 'status', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_updated': {'key': 'lastUpdated', 'type': 'iso-8601'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'sort': {'key': 'sort', 'type': '[SearchSort]'},
        'request_time': {'key': 'requestTime', 'type': 'long'},
        'aggregated_value_field': {'key': 'aggregatedValueField', 'type': 'str'},
        'aggregated_grouping_fields': {'key': 'aggregatedGroupingFields', 'type': 'str'},
        'sum': {'key': 'sum', 'type': 'long'},
        'max': {'key': 'max', 'type': 'long'},
        'schema': {'key': 'schema', 'type': 'SearchMetadataSchema'},
    }

    def __init__(self, *, search_id: str=None, result_type: str=None, total: int=None, top: int=None, id: str=None, core_summaries=None, status: str=None, start_time=None, last_updated=None, e_tag: str=None, sort=None, request_time: int=None, aggregated_value_field: str=None, aggregated_grouping_fields: str=None, sum: int=None, max: int=None, schema=None, **kwargs) -> None:
        super(SearchMetadata, self).__init__(**kwargs)
        self.search_id = search_id
        self.result_type = result_type
        self.total = total
        self.top = top
        self.id = id
        self.core_summaries = core_summaries
        self.status = status
        self.start_time = start_time
        self.last_updated = last_updated
        self.e_tag = e_tag
        self.sort = sort
        self.request_time = request_time
        self.aggregated_value_field = aggregated_value_field
        self.aggregated_grouping_fields = aggregated_grouping_fields
        self.sum = sum
        self.max = max
        self.schema = schema


class SearchMetadataSchema(Model):
    """Schema metadata for search.

    :param name: The name of the metadata schema.
    :type name: str
    :param version: The version of the metadata schema.
    :type version: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'version': {'key': 'version', 'type': 'int'},
    }

    def __init__(self, *, name: str=None, version: int=None, **kwargs) -> None:
        super(SearchMetadataSchema, self).__init__(**kwargs)
        self.name = name
        self.version = version


class SearchSchemaValue(Model):
    """Value object for schema results.

    All required parameters must be populated in order to send to Azure.

    :param name: The name of the schema.
    :type name: str
    :param display_name: The display name of the schema.
    :type display_name: str
    :param type: The type.
    :type type: str
    :param indexed: Required. The boolean that indicates the field is
     searchable as free text.
    :type indexed: bool
    :param stored: Required. The boolean that indicates whether or not the
     field is stored.
    :type stored: bool
    :param facet: Required. The boolean that indicates whether or not the
     field is a facet.
    :type facet: bool
    :param owner_type: The array of workflows containing the field.
    :type owner_type: list[str]
    """

    _validation = {
        'indexed': {'required': True},
        'stored': {'required': True},
        'facet': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'indexed': {'key': 'indexed', 'type': 'bool'},
        'stored': {'key': 'stored', 'type': 'bool'},
        'facet': {'key': 'facet', 'type': 'bool'},
        'owner_type': {'key': 'ownerType', 'type': '[str]'},
    }

    def __init__(self, *, indexed: bool, stored: bool, facet: bool, name: str=None, display_name: str=None, type: str=None, owner_type=None, **kwargs) -> None:
        super(SearchSchemaValue, self).__init__(**kwargs)
        self.name = name
        self.display_name = display_name
        self.type = type
        self.indexed = indexed
        self.stored = stored
        self.facet = facet
        self.owner_type = owner_type


class SearchSort(Model):
    """The sort parameters for search.

    :param name: The name of the field the search query is sorted on.
    :type name: str
    :param order: The sort order of the search. Possible values include:
     'asc', 'desc'
    :type order: str or ~azure.mgmt.loganalytics.models.SearchSortEnum
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'order': {'key': 'order', 'type': 'str'},
    }

    def __init__(self, *, name: str=None, order=None, **kwargs) -> None:
        super(SearchSort, self).__init__(**kwargs)
        self.name = name
        self.order = order


class SharedKeys(Model):
    """The shared keys for a workspace.

    :param primary_shared_key: The primary shared key of a workspace.
    :type primary_shared_key: str
    :param secondary_shared_key: The secondary shared key of a workspace.
    :type secondary_shared_key: str
    """

    _attribute_map = {
        'primary_shared_key': {'key': 'primarySharedKey', 'type': 'str'},
        'secondary_shared_key': {'key': 'secondarySharedKey', 'type': 'str'},
    }

    def __init__(self, *, primary_shared_key: str=None, secondary_shared_key: str=None, **kwargs) -> None:
        super(SharedKeys, self).__init__(**kwargs)
        self.primary_shared_key = primary_shared_key
        self.secondary_shared_key = secondary_shared_key


class StorageAccount(Model):
    """Describes a storage account connection.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The Azure Resource Manager ID of the storage account
     resource.
    :type id: str
    :param key: Required. The storage account key.
    :type key: str
    """

    _validation = {
        'id': {'required': True},
        'key': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(self, *, id: str, key: str, **kwargs) -> None:
        super(StorageAccount, self).__init__(**kwargs)
        self.id = id
        self.key = key


class StorageInsight(ProxyResource):
    """The top level storage insight resource container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param containers: The names of the blob containers that the workspace
     should read
    :type containers: list[str]
    :param tables: The names of the Azure tables that the workspace should
     read
    :type tables: list[str]
    :param storage_account: Required. The storage account connection details
    :type storage_account: ~azure.mgmt.loganalytics.models.StorageAccount
    :ivar status: The status of the storage insight
    :vartype status: ~azure.mgmt.loganalytics.models.StorageInsightStatus
    :param e_tag: The ETag of the storage insight.
    :type e_tag: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'storage_account': {'required': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'containers': {'key': 'properties.containers', 'type': '[str]'},
        'tables': {'key': 'properties.tables', 'type': '[str]'},
        'storage_account': {'key': 'properties.storageAccount', 'type': 'StorageAccount'},
        'status': {'key': 'properties.status', 'type': 'StorageInsightStatus'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, storage_account, containers=None, tables=None, e_tag: str=None, tags=None, **kwargs) -> None:
        super(StorageInsight, self).__init__(**kwargs)
        self.containers = containers
        self.tables = tables
        self.storage_account = storage_account
        self.status = None
        self.e_tag = e_tag
        self.tags = tags


class StorageInsightStatus(Model):
    """The status of the storage insight.

    All required parameters must be populated in order to send to Azure.

    :param state: Required. The state of the storage insight connection to the
     workspace. Possible values include: 'OK', 'ERROR'
    :type state: str or ~azure.mgmt.loganalytics.models.StorageInsightState
    :param description: Description of the state of the storage insight.
    :type description: str
    """

    _validation = {
        'state': {'required': True},
    }

    _attribute_map = {
        'state': {'key': 'state', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, *, state, description: str=None, **kwargs) -> None:
        super(StorageInsightStatus, self).__init__(**kwargs)
        self.state = state
        self.description = description


class Table(ProxyResource):
    """Workspace data table definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param retention_in_days: The data table data retention in days, between
     30 and 730. Setting this property to null will default to the workspace
     retention.
    :type retention_in_days: int
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'retention_in_days': {'maximum': 730, 'minimum': 30},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
    }

    def __init__(self, *, retention_in_days: int=None, **kwargs) -> None:
        super(Table, self).__init__(**kwargs)
        self.retention_in_days = retention_in_days


class Tag(Model):
    """A tag of a saved search.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The tag name.
    :type name: str
    :param value: Required. The tag value.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, *, name: str, value: str, **kwargs) -> None:
        super(Tag, self).__init__(**kwargs)
        self.name = name
        self.value = value


class UsageMetric(Model):
    """A metric describing the usage of a resource.

    :param name: The name of the metric.
    :type name: ~azure.mgmt.loganalytics.models.MetricName
    :param unit: The units used for the metric.
    :type unit: str
    :param current_value: The current value of the metric.
    :type current_value: float
    :param limit: The quota limit for the metric.
    :type limit: float
    :param next_reset_time: The time that the metric's value will reset.
    :type next_reset_time: datetime
    :param quota_period: The quota period that determines the length of time
     between value resets.
    :type quota_period: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'MetricName'},
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'float'},
        'limit': {'key': 'limit', 'type': 'float'},
        'next_reset_time': {'key': 'nextResetTime', 'type': 'iso-8601'},
        'quota_period': {'key': 'quotaPeriod', 'type': 'str'},
    }

    def __init__(self, *, name=None, unit: str=None, current_value: float=None, limit: float=None, next_reset_time=None, quota_period: str=None, **kwargs) -> None:
        super(UsageMetric, self).__init__(**kwargs)
        self.name = name
        self.unit = unit
        self.current_value = current_value
        self.limit = limit
        self.next_reset_time = next_reset_time
        self.quota_period = quota_period


class Workspace(TrackedResource):
    """The top level Workspace resource container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param location: Required. The geo-location where the resource lives
    :type location: str
    :param provisioning_state: The provisioning state of the workspace.
     Possible values include: 'Creating', 'Succeeded', 'Failed', 'Canceled',
     'Deleting', 'ProvisioningAccount', 'Updating'
    :type provisioning_state: str or
     ~azure.mgmt.loganalytics.models.WorkspaceEntityStatus
    :ivar customer_id: This is a read-only property. Represents the ID
     associated with the workspace.
    :vartype customer_id: str
    :param sku: The SKU of the workspace.
    :type sku: ~azure.mgmt.loganalytics.models.WorkspaceSku
    :param retention_in_days: The workspace data retention in days, between 30
     and 730.
    :type retention_in_days: int
    :param workspace_capping: The daily volume cap for ingestion.
    :type workspace_capping: ~azure.mgmt.loganalytics.models.WorkspaceCapping
    :param public_network_access_for_ingestion: The network access type for
     accessing Log Analytics ingestion. Possible values include: 'Enabled',
     'Disabled'. Default value: "Enabled" .
    :type public_network_access_for_ingestion: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :param public_network_access_for_query: The network access type for
     accessing Log Analytics query. Possible values include: 'Enabled',
     'Disabled'. Default value: "Enabled" .
    :type public_network_access_for_query: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :ivar private_link_scoped_resources: List of linked private link scope
     resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.loganalytics.models.PrivateLinkScopedResource]
    :param e_tag: The ETag of the workspace.
    :type e_tag: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'customer_id': {'readonly': True},
        'retention_in_days': {'maximum': 730, 'minimum': 30},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'location': {'key': 'location', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'WorkspaceSku'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
        'workspace_capping': {'key': 'properties.workspaceCapping', 'type': 'WorkspaceCapping'},
        'public_network_access_for_ingestion': {'key': 'properties.publicNetworkAccessForIngestion', 'type': 'str'},
        'public_network_access_for_query': {'key': 'properties.publicNetworkAccessForQuery', 'type': 'str'},
        'private_link_scoped_resources': {'key': 'properties.privateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'e_tag': {'key': 'eTag', 'type': 'str'},
    }

    def __init__(self, *, location: str, tags=None, provisioning_state=None, sku=None, retention_in_days: int=None, workspace_capping=None, public_network_access_for_ingestion="Enabled", public_network_access_for_query="Enabled", e_tag: str=None, **kwargs) -> None:
        super(Workspace, self).__init__(tags=tags, location=location, **kwargs)
        self.provisioning_state = provisioning_state
        self.customer_id = None
        self.sku = sku
        self.retention_in_days = retention_in_days
        self.workspace_capping = workspace_capping
        self.public_network_access_for_ingestion = public_network_access_for_ingestion
        self.public_network_access_for_query = public_network_access_for_query
        self.private_link_scoped_resources = None
        self.e_tag = e_tag


class WorkspaceCapping(Model):
    """The daily volume cap for ingestion.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :param daily_quota_gb: The workspace daily quota for ingestion.
    :type daily_quota_gb: float
    :ivar quota_next_reset_time: The time when the quota will be rest.
    :vartype quota_next_reset_time: str
    :ivar data_ingestion_status: The status of data ingestion for this
     workspace. Possible values include: 'RespectQuota', 'ForceOn', 'ForceOff',
     'OverQuota', 'SubscriptionSuspended', 'ApproachingQuota'
    :vartype data_ingestion_status: str or
     ~azure.mgmt.loganalytics.models.DataIngestionStatus
    """

    _validation = {
        'quota_next_reset_time': {'readonly': True},
        'data_ingestion_status': {'readonly': True},
    }

    _attribute_map = {
        'daily_quota_gb': {'key': 'dailyQuotaGb', 'type': 'float'},
        'quota_next_reset_time': {'key': 'quotaNextResetTime', 'type': 'str'},
        'data_ingestion_status': {'key': 'dataIngestionStatus', 'type': 'str'},
    }

    def __init__(self, *, daily_quota_gb: float=None, **kwargs) -> None:
        super(WorkspaceCapping, self).__init__(**kwargs)
        self.daily_quota_gb = daily_quota_gb
        self.quota_next_reset_time = None
        self.data_ingestion_status = None


class WorkspacePatch(AzureEntityResource):
    """The top level Workspace resource container.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified resource Id for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
    :vartype id: str
    :ivar name: The name of the resource
    :vartype name: str
    :ivar type: The type of the resource. Ex-
     Microsoft.Compute/virtualMachines or Microsoft.Storage/storageAccounts.
    :vartype type: str
    :ivar etag: Resource Etag.
    :vartype etag: str
    :param provisioning_state: The provisioning state of the workspace.
     Possible values include: 'Creating', 'Succeeded', 'Failed', 'Canceled',
     'Deleting', 'ProvisioningAccount', 'Updating'
    :type provisioning_state: str or
     ~azure.mgmt.loganalytics.models.WorkspaceEntityStatus
    :ivar customer_id: This is a read-only property. Represents the ID
     associated with the workspace.
    :vartype customer_id: str
    :param sku: The SKU of the workspace.
    :type sku: ~azure.mgmt.loganalytics.models.WorkspaceSku
    :param retention_in_days: The workspace data retention in days, between 30
     and 730.
    :type retention_in_days: int
    :param workspace_capping: The daily volume cap for ingestion.
    :type workspace_capping: ~azure.mgmt.loganalytics.models.WorkspaceCapping
    :param public_network_access_for_ingestion: The network access type for
     accessing Log Analytics ingestion. Possible values include: 'Enabled',
     'Disabled'. Default value: "Enabled" .
    :type public_network_access_for_ingestion: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :param public_network_access_for_query: The network access type for
     accessing Log Analytics query. Possible values include: 'Enabled',
     'Disabled'. Default value: "Enabled" .
    :type public_network_access_for_query: str or
     ~azure.mgmt.loganalytics.models.PublicNetworkAccessType
    :ivar private_link_scoped_resources: List of linked private link scope
     resources.
    :vartype private_link_scoped_resources:
     list[~azure.mgmt.loganalytics.models.PrivateLinkScopedResource]
    :param tags: Resource tags. Optional.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'etag': {'readonly': True},
        'customer_id': {'readonly': True},
        'retention_in_days': {'maximum': 730, 'minimum': 30},
        'private_link_scoped_resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'etag': {'key': 'etag', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'customer_id': {'key': 'properties.customerId', 'type': 'str'},
        'sku': {'key': 'properties.sku', 'type': 'WorkspaceSku'},
        'retention_in_days': {'key': 'properties.retentionInDays', 'type': 'int'},
        'workspace_capping': {'key': 'properties.workspaceCapping', 'type': 'WorkspaceCapping'},
        'public_network_access_for_ingestion': {'key': 'properties.publicNetworkAccessForIngestion', 'type': 'str'},
        'public_network_access_for_query': {'key': 'properties.publicNetworkAccessForQuery', 'type': 'str'},
        'private_link_scoped_resources': {'key': 'properties.privateLinkScopedResources', 'type': '[PrivateLinkScopedResource]'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, *, provisioning_state=None, sku=None, retention_in_days: int=None, workspace_capping=None, public_network_access_for_ingestion="Enabled", public_network_access_for_query="Enabled", tags=None, **kwargs) -> None:
        super(WorkspacePatch, self).__init__(**kwargs)
        self.provisioning_state = provisioning_state
        self.customer_id = None
        self.sku = sku
        self.retention_in_days = retention_in_days
        self.workspace_capping = workspace_capping
        self.public_network_access_for_ingestion = public_network_access_for_ingestion
        self.public_network_access_for_query = public_network_access_for_query
        self.private_link_scoped_resources = None
        self.tags = tags


class WorkspacePurgeBody(Model):
    """Describes the body of a purge request for an App Insights Workspace.

    All required parameters must be populated in order to send to Azure.

    :param table: Required. Table from which to purge data.
    :type table: str
    :param filters: Required. The set of columns and filters (queries) to run
     over them to purge the resulting data.
    :type filters:
     list[~azure.mgmt.loganalytics.models.WorkspacePurgeBodyFilters]
    """

    _validation = {
        'table': {'required': True},
        'filters': {'required': True},
    }

    _attribute_map = {
        'table': {'key': 'table', 'type': 'str'},
        'filters': {'key': 'filters', 'type': '[WorkspacePurgeBodyFilters]'},
    }

    def __init__(self, *, table: str, filters, **kwargs) -> None:
        super(WorkspacePurgeBody, self).__init__(**kwargs)
        self.table = table
        self.filters = filters


class WorkspacePurgeBodyFilters(Model):
    """User-defined filters to return data which will be purged from the table.

    :param column: The column of the table over which the given query should
     run
    :type column: str
    :param operator: A query operator to evaluate over the provided column and
     value(s). Supported operators are ==, =~, in, in~, >, >=, <, <=, between,
     and have the same behavior as they would in a KQL query.
    :type operator: str
    :param value: the value for the operator to function over. This can be a
     number (e.g., > 100), a string (timestamp >= '2017-09-01') or array of
     values.
    :type value: object
    :param key: When filtering over custom dimensions, this key will be used
     as the name of the custom dimension.
    :type key: str
    """

    _attribute_map = {
        'column': {'key': 'column', 'type': 'str'},
        'operator': {'key': 'operator', 'type': 'str'},
        'value': {'key': 'value', 'type': 'object'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(self, *, column: str=None, operator: str=None, value=None, key: str=None, **kwargs) -> None:
        super(WorkspacePurgeBodyFilters, self).__init__(**kwargs)
        self.column = column
        self.operator = operator
        self.value = value
        self.key = key


class WorkspacePurgeResponse(Model):
    """Response containing operationId for a specific purge action.

    All required parameters must be populated in order to send to Azure.

    :param operation_id: Required. Id to use when querying for status for a
     particular purge operation.
    :type operation_id: str
    """

    _validation = {
        'operation_id': {'required': True},
    }

    _attribute_map = {
        'operation_id': {'key': 'operationId', 'type': 'str'},
    }

    def __init__(self, *, operation_id: str, **kwargs) -> None:
        super(WorkspacePurgeResponse, self).__init__(**kwargs)
        self.operation_id = operation_id


class WorkspacePurgeStatusResponse(Model):
    """Response containing status for a specific purge operation.

    All required parameters must be populated in order to send to Azure.

    :param status: Required. Status of the operation represented by the
     requested Id. Possible values include: 'pending', 'completed'
    :type status: str or ~azure.mgmt.loganalytics.models.PurgeState
    """

    _validation = {
        'status': {'required': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
    }

    def __init__(self, *, status, **kwargs) -> None:
        super(WorkspacePurgeStatusResponse, self).__init__(**kwargs)
        self.status = status


class WorkspaceSku(Model):
    """The SKU (tier) of a workspace.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the SKU. Possible values include:
     'Free', 'Standard', 'Premium', 'PerNode', 'PerGB2018', 'Standalone',
     'CapacityReservation'
    :type name: str or ~azure.mgmt.loganalytics.models.WorkspaceSkuNameEnum
    :param capacity_reservation_level: The capacity reservation level for this
     workspace, when CapacityReservation sku is selected.
    :type capacity_reservation_level: int
    :ivar max_capacity_reservation_level: The maximum capacity reservation
     level available for this workspace, when CapacityReservation sku is
     selected.
    :vartype max_capacity_reservation_level: int
    :ivar last_sku_update: The last time when the sku was updated.
    :vartype last_sku_update: str
    """

    _validation = {
        'name': {'required': True},
        'max_capacity_reservation_level': {'readonly': True},
        'last_sku_update': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'capacity_reservation_level': {'key': 'capacityReservationLevel', 'type': 'int'},
        'max_capacity_reservation_level': {'key': 'maxCapacityReservationLevel', 'type': 'int'},
        'last_sku_update': {'key': 'lastSkuUpdate', 'type': 'str'},
    }

    def __init__(self, *, name, capacity_reservation_level: int=None, **kwargs) -> None:
        super(WorkspaceSku, self).__init__(**kwargs)
        self.name = name
        self.capacity_reservation_level = capacity_reservation_level
        self.max_capacity_reservation_level = None
        self.last_sku_update = None
