# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class SubnetOverride(Model):
    """Property overrides on a subnet of a virtual network.

    :param resource_id: The resource ID of the subnet.
    :type resource_id: str
    :param lab_subnet_name: The name given to the subnet within the lab.
    :type lab_subnet_name: str
    :param use_in_vm_creation_permission: Indicates whether this subnet can be
     used during virtual machine creation (i.e. Allow, Deny). Possible values
     include: 'Default', 'Deny', 'Allow'
    :type use_in_vm_creation_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param use_public_ip_address_permission: Indicates whether public IP
     addresses can be assigned to virtual machines on this subnet (i.e. Allow,
     Deny). Possible values include: 'Default', 'Deny', 'Allow'
    :type use_public_ip_address_permission: str or
     ~azure.mgmt.devtestlabs.models.UsagePermissionType
    :param shared_public_ip_address_configuration: Properties that virtual
     machines on this subnet will share.
    :type shared_public_ip_address_configuration:
     ~azure.mgmt.devtestlabs.models.SubnetSharedPublicIpAddressConfiguration
    :param virtual_network_pool_name: The virtual network pool associated with
     this subnet.
    :type virtual_network_pool_name: str
    """

    _attribute_map = {
        'resource_id': {'key': 'resourceId', 'type': 'str'},
        'lab_subnet_name': {'key': 'labSubnetName', 'type': 'str'},
        'use_in_vm_creation_permission': {'key': 'useInVmCreationPermission', 'type': 'str'},
        'use_public_ip_address_permission': {'key': 'usePublicIpAddressPermission', 'type': 'str'},
        'shared_public_ip_address_configuration': {'key': 'sharedPublicIpAddressConfiguration', 'type': 'SubnetSharedPublicIpAddressConfiguration'},
        'virtual_network_pool_name': {'key': 'virtualNetworkPoolName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubnetOverride, self).__init__(**kwargs)
        self.resource_id = kwargs.get('resource_id', None)
        self.lab_subnet_name = kwargs.get('lab_subnet_name', None)
        self.use_in_vm_creation_permission = kwargs.get('use_in_vm_creation_permission', None)
        self.use_public_ip_address_permission = kwargs.get('use_public_ip_address_permission', None)
        self.shared_public_ip_address_configuration = kwargs.get('shared_public_ip_address_configuration', None)
        self.virtual_network_pool_name = kwargs.get('virtual_network_pool_name', None)
