# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CustomImagePropertiesFromVm(Model):
    """Properties for creating a custom image from a virtual machine.

    :param source_vm_id: The source vm identifier.
    :type source_vm_id: str
    :param windows_os_info: The Windows OS information of the VM.
    :type windows_os_info: ~azure.mgmt.devtestlabs.models.WindowsOsInfo
    :param linux_os_info: The Linux OS information of the VM.
    :type linux_os_info: ~azure.mgmt.devtestlabs.models.LinuxOsInfo
    """

    _attribute_map = {
        'source_vm_id': {'key': 'sourceVmId', 'type': 'str'},
        'windows_os_info': {'key': 'windowsOsInfo', 'type': 'WindowsOsInfo'},
        'linux_os_info': {'key': 'linuxOsInfo', 'type': 'LinuxOsInfo'},
    }

    def __init__(self, *, source_vm_id: str=None, windows_os_info=None, linux_os_info=None, **kwargs) -> None:
        super(CustomImagePropertiesFromVm, self).__init__(**kwargs)
        self.source_vm_id = source_vm_id
        self.windows_os_info = windows_os_info
        self.linux_os_info = linux_os_info
