# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .update_resource import UpdateResource


class NotificationChannelFragment(UpdateResource):
    """A notification.

    :param tags: The tags of the resource.
    :type tags: dict[str, str]
    :param web_hook_url: The webhook URL to send notifications to.
    :type web_hook_url: str
    :param email_recipient: The email recipient to send notifications to (can
     be a list of semi-colon separated email addresses).
    :type email_recipient: str
    :param notification_locale: The locale to use when sending a notification
     (fallback for unsupported languages is EN).
    :type notification_locale: str
    :param description: Description of notification.
    :type description: str
    :param events: The list of event for which this notification is enabled.
    :type events: list[~azure.mgmt.devtestlabs.models.EventFragment]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'web_hook_url': {'key': 'properties.webHookUrl', 'type': 'str'},
        'email_recipient': {'key': 'properties.emailRecipient', 'type': 'str'},
        'notification_locale': {'key': 'properties.notificationLocale', 'type': 'str'},
        'description': {'key': 'properties.description', 'type': 'str'},
        'events': {'key': 'properties.events', 'type': '[EventFragment]'},
    }

    def __init__(self, **kwargs):
        super(NotificationChannelFragment, self).__init__(**kwargs)
        self.web_hook_url = kwargs.get('web_hook_url', None)
        self.email_recipient = kwargs.get('email_recipient', None)
        self.notification_locale = kwargs.get('notification_locale', None)
        self.description = kwargs.get('description', None)
        self.events = kwargs.get('events', None)
