# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------
from msrest import Serializer, Deserializer


class SubscriptionClientOperationsMixin(object):


    def check_resource_name(self, name, type, custom_headers=None, raw=False, **operation_config):
        """Checks resource name validity.

        A resource name is valid if it is not a reserved word, does not
        contains a reserved word and does not start with a reserved word.

        :param name: Name of the resource
        :type name: str
        :param type: The type of the resource
        :type type: str
        :param dict custom_headers: headers that will be added to the request
        :param bool raw: returns the direct response alongside the
         deserialized response
        :param operation_config: :ref:`Operation configuration
         overrides<msrest:optionsforoperations>`.
        :return: CheckResourceNameResult or ClientRawResponse if raw=true
        :rtype:
         ~azure.mgmt.resource.subscriptions.v2019_11_01.models.CheckResourceNameResult
         or ~msrest.pipeline.ClientRawResponse
        :raises:
         :class:`ErrorResponseException<azure.mgmt.resource.subscriptions.v2019_11_01.models.ErrorResponseException>`
        
        """
        api_version = self._get_api_version('check_resource_name')
        if api_version == '2016-06-01':
            from .v2016_06_01.operations import SubscriptionClientOperationsMixin as OperationClass
        elif api_version == '2018-06-01':
            from .v2018_06_01.operations import SubscriptionClientOperationsMixin as OperationClass
        elif api_version == '2019-06-01':
            from .v2019_06_01.operations import SubscriptionClientOperationsMixin as OperationClass
        elif api_version == '2019-11-01':
            from .v2019_11_01.operations import SubscriptionClientOperationsMixin as OperationClass
        else:
            raise NotImplementedError("APIVersion {} is not available".format(api_version))
        mixin_instance = OperationClass()
        mixin_instance._client = self._client
        mixin_instance.config = self.config
        mixin_instance._serialize = Serializer(self._models_dict(api_version))
        mixin_instance._deserialize = Deserializer(self._models_dict(api_version))
        mixin_instance.api_version = api_version
        return mixin_instance.check_resource_name(name, type, custom_headers, raw, **operation_config)
