// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	"time"

	v1 "github.com/openshift/machine-config-operator/pkg/apis/machineconfiguration.openshift.io/v1"
	scheme "github.com/openshift/machine-config-operator/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ContainerRuntimeConfigsGetter has a method to return a ContainerRuntimeConfigInterface.
// A group's client should implement this interface.
type ContainerRuntimeConfigsGetter interface {
	ContainerRuntimeConfigs() ContainerRuntimeConfigInterface
}

// ContainerRuntimeConfigInterface has methods to work with ContainerRuntimeConfig resources.
type ContainerRuntimeConfigInterface interface {
	Create(*v1.ContainerRuntimeConfig) (*v1.ContainerRuntimeConfig, error)
	Update(*v1.ContainerRuntimeConfig) (*v1.ContainerRuntimeConfig, error)
	UpdateStatus(*v1.ContainerRuntimeConfig) (*v1.ContainerRuntimeConfig, error)
	Delete(name string, options *metav1.DeleteOptions) error
	DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error
	Get(name string, options metav1.GetOptions) (*v1.ContainerRuntimeConfig, error)
	List(opts metav1.ListOptions) (*v1.ContainerRuntimeConfigList, error)
	Watch(opts metav1.ListOptions) (watch.Interface, error)
	Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ContainerRuntimeConfig, err error)
	ContainerRuntimeConfigExpansion
}

// containerRuntimeConfigs implements ContainerRuntimeConfigInterface
type containerRuntimeConfigs struct {
	client rest.Interface
}

// newContainerRuntimeConfigs returns a ContainerRuntimeConfigs
func newContainerRuntimeConfigs(c *MachineconfigurationV1Client) *containerRuntimeConfigs {
	return &containerRuntimeConfigs{
		client: c.RESTClient(),
	}
}

// Get takes name of the containerRuntimeConfig, and returns the corresponding containerRuntimeConfig object, and an error if there is any.
func (c *containerRuntimeConfigs) Get(name string, options metav1.GetOptions) (result *v1.ContainerRuntimeConfig, err error) {
	result = &v1.ContainerRuntimeConfig{}
	err = c.client.Get().
		Resource("containerruntimeconfigs").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do().
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ContainerRuntimeConfigs that match those selectors.
func (c *containerRuntimeConfigs) List(opts metav1.ListOptions) (result *v1.ContainerRuntimeConfigList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &v1.ContainerRuntimeConfigList{}
	err = c.client.Get().
		Resource("containerruntimeconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do().
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested containerRuntimeConfigs.
func (c *containerRuntimeConfigs) Watch(opts metav1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Resource("containerruntimeconfigs").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch()
}

// Create takes the representation of a containerRuntimeConfig and creates it.  Returns the server's representation of the containerRuntimeConfig, and an error, if there is any.
func (c *containerRuntimeConfigs) Create(containerRuntimeConfig *v1.ContainerRuntimeConfig) (result *v1.ContainerRuntimeConfig, err error) {
	result = &v1.ContainerRuntimeConfig{}
	err = c.client.Post().
		Resource("containerruntimeconfigs").
		Body(containerRuntimeConfig).
		Do().
		Into(result)
	return
}

// Update takes the representation of a containerRuntimeConfig and updates it. Returns the server's representation of the containerRuntimeConfig, and an error, if there is any.
func (c *containerRuntimeConfigs) Update(containerRuntimeConfig *v1.ContainerRuntimeConfig) (result *v1.ContainerRuntimeConfig, err error) {
	result = &v1.ContainerRuntimeConfig{}
	err = c.client.Put().
		Resource("containerruntimeconfigs").
		Name(containerRuntimeConfig.Name).
		Body(containerRuntimeConfig).
		Do().
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().

func (c *containerRuntimeConfigs) UpdateStatus(containerRuntimeConfig *v1.ContainerRuntimeConfig) (result *v1.ContainerRuntimeConfig, err error) {
	result = &v1.ContainerRuntimeConfig{}
	err = c.client.Put().
		Resource("containerruntimeconfigs").
		Name(containerRuntimeConfig.Name).
		SubResource("status").
		Body(containerRuntimeConfig).
		Do().
		Into(result)
	return
}

// Delete takes name of the containerRuntimeConfig and deletes it. Returns an error if one occurs.
func (c *containerRuntimeConfigs) Delete(name string, options *metav1.DeleteOptions) error {
	return c.client.Delete().
		Resource("containerruntimeconfigs").
		Name(name).
		Body(options).
		Do().
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *containerRuntimeConfigs) DeleteCollection(options *metav1.DeleteOptions, listOptions metav1.ListOptions) error {
	var timeout time.Duration
	if listOptions.TimeoutSeconds != nil {
		timeout = time.Duration(*listOptions.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Resource("containerruntimeconfigs").
		VersionedParams(&listOptions, scheme.ParameterCodec).
		Timeout(timeout).
		Body(options).
		Do().
		Error()
}

// Patch applies the patch and returns the patched containerRuntimeConfig.
func (c *containerRuntimeConfigs) Patch(name string, pt types.PatchType, data []byte, subresources ...string) (result *v1.ContainerRuntimeConfig, err error) {
	result = &v1.ContainerRuntimeConfig{}
	err = c.client.Patch(pt).
		Resource("containerruntimeconfigs").
		SubResource(subresources...).
		Name(name).
		Body(data).
		Do().
		Into(result)
	return
}
