// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/ads/googleads/v1/services/merchant_center_link_service.proto

package services // import "google.golang.org/genproto/googleapis/ads/googleads/v1/services"

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import resources "google.golang.org/genproto/googleapis/ads/googleads/v1/resources"
import _ "google.golang.org/genproto/googleapis/api/annotations"
import field_mask "google.golang.org/genproto/protobuf/field_mask"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Request message for [MerchantCenterLinkService.ListMerchantCenterLinks][google.ads.googleads.v1.services.MerchantCenterLinkService.ListMerchantCenterLinks].
type ListMerchantCenterLinksRequest struct {
	// The ID of the customer onto which to apply the Merchant Center link list
	// operation.
	CustomerId           string   `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListMerchantCenterLinksRequest) Reset()         { *m = ListMerchantCenterLinksRequest{} }
func (m *ListMerchantCenterLinksRequest) String() string { return proto.CompactTextString(m) }
func (*ListMerchantCenterLinksRequest) ProtoMessage()    {}
func (*ListMerchantCenterLinksRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_merchant_center_link_service_21e19ec8285c21ff, []int{0}
}
func (m *ListMerchantCenterLinksRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMerchantCenterLinksRequest.Unmarshal(m, b)
}
func (m *ListMerchantCenterLinksRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMerchantCenterLinksRequest.Marshal(b, m, deterministic)
}
func (dst *ListMerchantCenterLinksRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMerchantCenterLinksRequest.Merge(dst, src)
}
func (m *ListMerchantCenterLinksRequest) XXX_Size() int {
	return xxx_messageInfo_ListMerchantCenterLinksRequest.Size(m)
}
func (m *ListMerchantCenterLinksRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMerchantCenterLinksRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListMerchantCenterLinksRequest proto.InternalMessageInfo

func (m *ListMerchantCenterLinksRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

// Response message for [MerchantCenterLinkService.ListMerchantCenterLinks][google.ads.googleads.v1.services.MerchantCenterLinkService.ListMerchantCenterLinks].
type ListMerchantCenterLinksResponse struct {
	// Merchant Center links available for the requested customer
	MerchantCenterLinks  []*resources.MerchantCenterLink `protobuf:"bytes,1,rep,name=merchant_center_links,json=merchantCenterLinks,proto3" json:"merchant_center_links,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *ListMerchantCenterLinksResponse) Reset()         { *m = ListMerchantCenterLinksResponse{} }
func (m *ListMerchantCenterLinksResponse) String() string { return proto.CompactTextString(m) }
func (*ListMerchantCenterLinksResponse) ProtoMessage()    {}
func (*ListMerchantCenterLinksResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_merchant_center_link_service_21e19ec8285c21ff, []int{1}
}
func (m *ListMerchantCenterLinksResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListMerchantCenterLinksResponse.Unmarshal(m, b)
}
func (m *ListMerchantCenterLinksResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListMerchantCenterLinksResponse.Marshal(b, m, deterministic)
}
func (dst *ListMerchantCenterLinksResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListMerchantCenterLinksResponse.Merge(dst, src)
}
func (m *ListMerchantCenterLinksResponse) XXX_Size() int {
	return xxx_messageInfo_ListMerchantCenterLinksResponse.Size(m)
}
func (m *ListMerchantCenterLinksResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListMerchantCenterLinksResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListMerchantCenterLinksResponse proto.InternalMessageInfo

func (m *ListMerchantCenterLinksResponse) GetMerchantCenterLinks() []*resources.MerchantCenterLink {
	if m != nil {
		return m.MerchantCenterLinks
	}
	return nil
}

// Request message for [MerchantCenterLinkService.GetMerchantCenterLink][google.ads.googleads.v1.services.MerchantCenterLinkService.GetMerchantCenterLink].
type GetMerchantCenterLinkRequest struct {
	// Resource name of the Merchant Center link.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetMerchantCenterLinkRequest) Reset()         { *m = GetMerchantCenterLinkRequest{} }
func (m *GetMerchantCenterLinkRequest) String() string { return proto.CompactTextString(m) }
func (*GetMerchantCenterLinkRequest) ProtoMessage()    {}
func (*GetMerchantCenterLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_merchant_center_link_service_21e19ec8285c21ff, []int{2}
}
func (m *GetMerchantCenterLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetMerchantCenterLinkRequest.Unmarshal(m, b)
}
func (m *GetMerchantCenterLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetMerchantCenterLinkRequest.Marshal(b, m, deterministic)
}
func (dst *GetMerchantCenterLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetMerchantCenterLinkRequest.Merge(dst, src)
}
func (m *GetMerchantCenterLinkRequest) XXX_Size() int {
	return xxx_messageInfo_GetMerchantCenterLinkRequest.Size(m)
}
func (m *GetMerchantCenterLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetMerchantCenterLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetMerchantCenterLinkRequest proto.InternalMessageInfo

func (m *GetMerchantCenterLinkRequest) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

// Request message for [MerchantCenterLinkService.MutateMerchantCenterLink][google.ads.googleads.v1.services.MerchantCenterLinkService.MutateMerchantCenterLink].
type MutateMerchantCenterLinkRequest struct {
	// The ID of the customer being modified.
	CustomerId string `protobuf:"bytes,1,opt,name=customer_id,json=customerId,proto3" json:"customer_id,omitempty"`
	// The operation to perform on the link
	Operation            *MerchantCenterLinkOperation `protobuf:"bytes,2,opt,name=operation,proto3" json:"operation,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                     `json:"-"`
	XXX_unrecognized     []byte                       `json:"-"`
	XXX_sizecache        int32                        `json:"-"`
}

func (m *MutateMerchantCenterLinkRequest) Reset()         { *m = MutateMerchantCenterLinkRequest{} }
func (m *MutateMerchantCenterLinkRequest) String() string { return proto.CompactTextString(m) }
func (*MutateMerchantCenterLinkRequest) ProtoMessage()    {}
func (*MutateMerchantCenterLinkRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_merchant_center_link_service_21e19ec8285c21ff, []int{3}
}
func (m *MutateMerchantCenterLinkRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateMerchantCenterLinkRequest.Unmarshal(m, b)
}
func (m *MutateMerchantCenterLinkRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateMerchantCenterLinkRequest.Marshal(b, m, deterministic)
}
func (dst *MutateMerchantCenterLinkRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateMerchantCenterLinkRequest.Merge(dst, src)
}
func (m *MutateMerchantCenterLinkRequest) XXX_Size() int {
	return xxx_messageInfo_MutateMerchantCenterLinkRequest.Size(m)
}
func (m *MutateMerchantCenterLinkRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateMerchantCenterLinkRequest.DiscardUnknown(m)
}

var xxx_messageInfo_MutateMerchantCenterLinkRequest proto.InternalMessageInfo

func (m *MutateMerchantCenterLinkRequest) GetCustomerId() string {
	if m != nil {
		return m.CustomerId
	}
	return ""
}

func (m *MutateMerchantCenterLinkRequest) GetOperation() *MerchantCenterLinkOperation {
	if m != nil {
		return m.Operation
	}
	return nil
}

// A single update on a Merchant Center link.
type MerchantCenterLinkOperation struct {
	// FieldMask that determines which resource fields are modified in an update.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// The operation to perform
	//
	// Types that are valid to be assigned to Operation:
	//	*MerchantCenterLinkOperation_Update
	//	*MerchantCenterLinkOperation_Remove
	Operation            isMerchantCenterLinkOperation_Operation `protobuf_oneof:"operation"`
	XXX_NoUnkeyedLiteral struct{}                                `json:"-"`
	XXX_unrecognized     []byte                                  `json:"-"`
	XXX_sizecache        int32                                   `json:"-"`
}

func (m *MerchantCenterLinkOperation) Reset()         { *m = MerchantCenterLinkOperation{} }
func (m *MerchantCenterLinkOperation) String() string { return proto.CompactTextString(m) }
func (*MerchantCenterLinkOperation) ProtoMessage()    {}
func (*MerchantCenterLinkOperation) Descriptor() ([]byte, []int) {
	return fileDescriptor_merchant_center_link_service_21e19ec8285c21ff, []int{4}
}
func (m *MerchantCenterLinkOperation) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MerchantCenterLinkOperation.Unmarshal(m, b)
}
func (m *MerchantCenterLinkOperation) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MerchantCenterLinkOperation.Marshal(b, m, deterministic)
}
func (dst *MerchantCenterLinkOperation) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MerchantCenterLinkOperation.Merge(dst, src)
}
func (m *MerchantCenterLinkOperation) XXX_Size() int {
	return xxx_messageInfo_MerchantCenterLinkOperation.Size(m)
}
func (m *MerchantCenterLinkOperation) XXX_DiscardUnknown() {
	xxx_messageInfo_MerchantCenterLinkOperation.DiscardUnknown(m)
}

var xxx_messageInfo_MerchantCenterLinkOperation proto.InternalMessageInfo

func (m *MerchantCenterLinkOperation) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

type isMerchantCenterLinkOperation_Operation interface {
	isMerchantCenterLinkOperation_Operation()
}

type MerchantCenterLinkOperation_Update struct {
	Update *resources.MerchantCenterLink `protobuf:"bytes,1,opt,name=update,proto3,oneof"`
}

type MerchantCenterLinkOperation_Remove struct {
	Remove string `protobuf:"bytes,2,opt,name=remove,proto3,oneof"`
}

func (*MerchantCenterLinkOperation_Update) isMerchantCenterLinkOperation_Operation() {}

func (*MerchantCenterLinkOperation_Remove) isMerchantCenterLinkOperation_Operation() {}

func (m *MerchantCenterLinkOperation) GetOperation() isMerchantCenterLinkOperation_Operation {
	if m != nil {
		return m.Operation
	}
	return nil
}

func (m *MerchantCenterLinkOperation) GetUpdate() *resources.MerchantCenterLink {
	if x, ok := m.GetOperation().(*MerchantCenterLinkOperation_Update); ok {
		return x.Update
	}
	return nil
}

func (m *MerchantCenterLinkOperation) GetRemove() string {
	if x, ok := m.GetOperation().(*MerchantCenterLinkOperation_Remove); ok {
		return x.Remove
	}
	return ""
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*MerchantCenterLinkOperation) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _MerchantCenterLinkOperation_OneofMarshaler, _MerchantCenterLinkOperation_OneofUnmarshaler, _MerchantCenterLinkOperation_OneofSizer, []interface{}{
		(*MerchantCenterLinkOperation_Update)(nil),
		(*MerchantCenterLinkOperation_Remove)(nil),
	}
}

func _MerchantCenterLinkOperation_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*MerchantCenterLinkOperation)
	// operation
	switch x := m.Operation.(type) {
	case *MerchantCenterLinkOperation_Update:
		b.EncodeVarint(1<<3 | proto.WireBytes)
		if err := b.EncodeMessage(x.Update); err != nil {
			return err
		}
	case *MerchantCenterLinkOperation_Remove:
		b.EncodeVarint(2<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.Remove)
	case nil:
	default:
		return fmt.Errorf("MerchantCenterLinkOperation.Operation has unexpected type %T", x)
	}
	return nil
}

func _MerchantCenterLinkOperation_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*MerchantCenterLinkOperation)
	switch tag {
	case 1: // operation.update
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		msg := new(resources.MerchantCenterLink)
		err := b.DecodeMessage(msg)
		m.Operation = &MerchantCenterLinkOperation_Update{msg}
		return true, err
	case 2: // operation.remove
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Operation = &MerchantCenterLinkOperation_Remove{x}
		return true, err
	default:
		return false, nil
	}
}

func _MerchantCenterLinkOperation_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*MerchantCenterLinkOperation)
	// operation
	switch x := m.Operation.(type) {
	case *MerchantCenterLinkOperation_Update:
		s := proto.Size(x.Update)
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(s))
		n += s
	case *MerchantCenterLinkOperation_Remove:
		n += 1 // tag and wire
		n += proto.SizeVarint(uint64(len(x.Remove)))
		n += len(x.Remove)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Response message for Merchant Center link mutate.
type MutateMerchantCenterLinkResponse struct {
	// Result for the mutate.
	Result               *MutateMerchantCenterLinkResult `protobuf:"bytes,2,opt,name=result,proto3" json:"result,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *MutateMerchantCenterLinkResponse) Reset()         { *m = MutateMerchantCenterLinkResponse{} }
func (m *MutateMerchantCenterLinkResponse) String() string { return proto.CompactTextString(m) }
func (*MutateMerchantCenterLinkResponse) ProtoMessage()    {}
func (*MutateMerchantCenterLinkResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_merchant_center_link_service_21e19ec8285c21ff, []int{5}
}
func (m *MutateMerchantCenterLinkResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateMerchantCenterLinkResponse.Unmarshal(m, b)
}
func (m *MutateMerchantCenterLinkResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateMerchantCenterLinkResponse.Marshal(b, m, deterministic)
}
func (dst *MutateMerchantCenterLinkResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateMerchantCenterLinkResponse.Merge(dst, src)
}
func (m *MutateMerchantCenterLinkResponse) XXX_Size() int {
	return xxx_messageInfo_MutateMerchantCenterLinkResponse.Size(m)
}
func (m *MutateMerchantCenterLinkResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateMerchantCenterLinkResponse.DiscardUnknown(m)
}

var xxx_messageInfo_MutateMerchantCenterLinkResponse proto.InternalMessageInfo

func (m *MutateMerchantCenterLinkResponse) GetResult() *MutateMerchantCenterLinkResult {
	if m != nil {
		return m.Result
	}
	return nil
}

// The result for the Merchant Center link mutate.
type MutateMerchantCenterLinkResult struct {
	// Returned for successful operations.
	ResourceName         string   `protobuf:"bytes,1,opt,name=resource_name,json=resourceName,proto3" json:"resource_name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *MutateMerchantCenterLinkResult) Reset()         { *m = MutateMerchantCenterLinkResult{} }
func (m *MutateMerchantCenterLinkResult) String() string { return proto.CompactTextString(m) }
func (*MutateMerchantCenterLinkResult) ProtoMessage()    {}
func (*MutateMerchantCenterLinkResult) Descriptor() ([]byte, []int) {
	return fileDescriptor_merchant_center_link_service_21e19ec8285c21ff, []int{6}
}
func (m *MutateMerchantCenterLinkResult) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_MutateMerchantCenterLinkResult.Unmarshal(m, b)
}
func (m *MutateMerchantCenterLinkResult) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_MutateMerchantCenterLinkResult.Marshal(b, m, deterministic)
}
func (dst *MutateMerchantCenterLinkResult) XXX_Merge(src proto.Message) {
	xxx_messageInfo_MutateMerchantCenterLinkResult.Merge(dst, src)
}
func (m *MutateMerchantCenterLinkResult) XXX_Size() int {
	return xxx_messageInfo_MutateMerchantCenterLinkResult.Size(m)
}
func (m *MutateMerchantCenterLinkResult) XXX_DiscardUnknown() {
	xxx_messageInfo_MutateMerchantCenterLinkResult.DiscardUnknown(m)
}

var xxx_messageInfo_MutateMerchantCenterLinkResult proto.InternalMessageInfo

func (m *MutateMerchantCenterLinkResult) GetResourceName() string {
	if m != nil {
		return m.ResourceName
	}
	return ""
}

func init() {
	proto.RegisterType((*ListMerchantCenterLinksRequest)(nil), "google.ads.googleads.v1.services.ListMerchantCenterLinksRequest")
	proto.RegisterType((*ListMerchantCenterLinksResponse)(nil), "google.ads.googleads.v1.services.ListMerchantCenterLinksResponse")
	proto.RegisterType((*GetMerchantCenterLinkRequest)(nil), "google.ads.googleads.v1.services.GetMerchantCenterLinkRequest")
	proto.RegisterType((*MutateMerchantCenterLinkRequest)(nil), "google.ads.googleads.v1.services.MutateMerchantCenterLinkRequest")
	proto.RegisterType((*MerchantCenterLinkOperation)(nil), "google.ads.googleads.v1.services.MerchantCenterLinkOperation")
	proto.RegisterType((*MutateMerchantCenterLinkResponse)(nil), "google.ads.googleads.v1.services.MutateMerchantCenterLinkResponse")
	proto.RegisterType((*MutateMerchantCenterLinkResult)(nil), "google.ads.googleads.v1.services.MutateMerchantCenterLinkResult")
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// MerchantCenterLinkServiceClient is the client API for MerchantCenterLinkService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type MerchantCenterLinkServiceClient interface {
	// Returns Merchant Center links available tor this customer.
	ListMerchantCenterLinks(ctx context.Context, in *ListMerchantCenterLinksRequest, opts ...grpc.CallOption) (*ListMerchantCenterLinksResponse, error)
	// Returns the Merchant Center link in full detail.
	GetMerchantCenterLink(ctx context.Context, in *GetMerchantCenterLinkRequest, opts ...grpc.CallOption) (*resources.MerchantCenterLink, error)
	// Updates status or removes a Merchant Center link.
	MutateMerchantCenterLink(ctx context.Context, in *MutateMerchantCenterLinkRequest, opts ...grpc.CallOption) (*MutateMerchantCenterLinkResponse, error)
}

type merchantCenterLinkServiceClient struct {
	cc *grpc.ClientConn
}

func NewMerchantCenterLinkServiceClient(cc *grpc.ClientConn) MerchantCenterLinkServiceClient {
	return &merchantCenterLinkServiceClient{cc}
}

func (c *merchantCenterLinkServiceClient) ListMerchantCenterLinks(ctx context.Context, in *ListMerchantCenterLinksRequest, opts ...grpc.CallOption) (*ListMerchantCenterLinksResponse, error) {
	out := new(ListMerchantCenterLinksResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.MerchantCenterLinkService/ListMerchantCenterLinks", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merchantCenterLinkServiceClient) GetMerchantCenterLink(ctx context.Context, in *GetMerchantCenterLinkRequest, opts ...grpc.CallOption) (*resources.MerchantCenterLink, error) {
	out := new(resources.MerchantCenterLink)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.MerchantCenterLinkService/GetMerchantCenterLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *merchantCenterLinkServiceClient) MutateMerchantCenterLink(ctx context.Context, in *MutateMerchantCenterLinkRequest, opts ...grpc.CallOption) (*MutateMerchantCenterLinkResponse, error) {
	out := new(MutateMerchantCenterLinkResponse)
	err := c.cc.Invoke(ctx, "/google.ads.googleads.v1.services.MerchantCenterLinkService/MutateMerchantCenterLink", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// MerchantCenterLinkServiceServer is the server API for MerchantCenterLinkService service.
type MerchantCenterLinkServiceServer interface {
	// Returns Merchant Center links available tor this customer.
	ListMerchantCenterLinks(context.Context, *ListMerchantCenterLinksRequest) (*ListMerchantCenterLinksResponse, error)
	// Returns the Merchant Center link in full detail.
	GetMerchantCenterLink(context.Context, *GetMerchantCenterLinkRequest) (*resources.MerchantCenterLink, error)
	// Updates status or removes a Merchant Center link.
	MutateMerchantCenterLink(context.Context, *MutateMerchantCenterLinkRequest) (*MutateMerchantCenterLinkResponse, error)
}

func RegisterMerchantCenterLinkServiceServer(s *grpc.Server, srv MerchantCenterLinkServiceServer) {
	s.RegisterService(&_MerchantCenterLinkService_serviceDesc, srv)
}

func _MerchantCenterLinkService_ListMerchantCenterLinks_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListMerchantCenterLinksRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantCenterLinkServiceServer).ListMerchantCenterLinks(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.MerchantCenterLinkService/ListMerchantCenterLinks",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantCenterLinkServiceServer).ListMerchantCenterLinks(ctx, req.(*ListMerchantCenterLinksRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MerchantCenterLinkService_GetMerchantCenterLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetMerchantCenterLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantCenterLinkServiceServer).GetMerchantCenterLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.MerchantCenterLinkService/GetMerchantCenterLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantCenterLinkServiceServer).GetMerchantCenterLink(ctx, req.(*GetMerchantCenterLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _MerchantCenterLinkService_MutateMerchantCenterLink_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MutateMerchantCenterLinkRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(MerchantCenterLinkServiceServer).MutateMerchantCenterLink(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.ads.googleads.v1.services.MerchantCenterLinkService/MutateMerchantCenterLink",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(MerchantCenterLinkServiceServer).MutateMerchantCenterLink(ctx, req.(*MutateMerchantCenterLinkRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _MerchantCenterLinkService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.ads.googleads.v1.services.MerchantCenterLinkService",
	HandlerType: (*MerchantCenterLinkServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ListMerchantCenterLinks",
			Handler:    _MerchantCenterLinkService_ListMerchantCenterLinks_Handler,
		},
		{
			MethodName: "GetMerchantCenterLink",
			Handler:    _MerchantCenterLinkService_GetMerchantCenterLink_Handler,
		},
		{
			MethodName: "MutateMerchantCenterLink",
			Handler:    _MerchantCenterLinkService_MutateMerchantCenterLink_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/ads/googleads/v1/services/merchant_center_link_service.proto",
}

func init() {
	proto.RegisterFile("google/ads/googleads/v1/services/merchant_center_link_service.proto", fileDescriptor_merchant_center_link_service_21e19ec8285c21ff)
}

var fileDescriptor_merchant_center_link_service_21e19ec8285c21ff = []byte{
	// 679 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xa4, 0x55, 0xcf, 0x6b, 0x13, 0x4f,
	0x14, 0xff, 0x4e, 0xca, 0xb7, 0xd0, 0x89, 0x5e, 0x46, 0x8a, 0x31, 0x96, 0x36, 0xac, 0x3d, 0x94,
	0x1c, 0x66, 0x49, 0x4b, 0x51, 0xb7, 0x46, 0xdc, 0x04, 0x6d, 0x85, 0xd6, 0x96, 0x15, 0x8a, 0x68,
	0x20, 0x4c, 0xb3, 0xd3, 0xb8, 0x34, 0xbb, 0xb3, 0xee, 0xcc, 0xe6, 0x52, 0x7b, 0x11, 0xbc, 0x79,
	0xf3, 0x0f, 0x10, 0x3c, 0x7a, 0xf2, 0xef, 0x10, 0xbc, 0xe8, 0xc9, 0xbb, 0x78, 0xf0, 0xaf, 0x90,
	0x9d, 0x1f, 0x69, 0xa5, 0xbb, 0x49, 0x6d, 0x6e, 0x6f, 0x66, 0xde, 0x7c, 0xde, 0xfb, 0xbc, 0xf7,
	0x79, 0x33, 0xb0, 0xdd, 0x67, 0xac, 0x3f, 0xa0, 0x36, 0xf1, 0xb9, 0xad, 0xcc, 0xcc, 0x1a, 0x36,
	0x6c, 0x4e, 0x93, 0x61, 0xd0, 0xa3, 0xdc, 0x0e, 0x69, 0xd2, 0x7b, 0x49, 0x22, 0xd1, 0xed, 0xd1,
	0x48, 0xd0, 0xa4, 0x3b, 0x08, 0xa2, 0xa3, 0xae, 0x3e, 0xc5, 0x71, 0xc2, 0x04, 0x43, 0x35, 0x75,
	0x13, 0x13, 0x9f, 0xe3, 0x11, 0x08, 0x1e, 0x36, 0xb0, 0x01, 0xa9, 0xde, 0x2b, 0x0a, 0x93, 0x50,
	0xce, 0xd2, 0xa4, 0x28, 0x8e, 0xc2, 0xaf, 0x2e, 0x98, 0xdb, 0x71, 0x60, 0x93, 0x28, 0x62, 0x82,
	0x88, 0x80, 0x45, 0x5c, 0x9f, 0xea, 0xe8, 0xb6, 0x5c, 0x1d, 0xa4, 0x87, 0xf6, 0x61, 0x40, 0x07,
	0x7e, 0x37, 0x24, 0x5c, 0xdf, 0xb7, 0x5c, 0xb8, 0xb8, 0x1d, 0x70, 0xb1, 0xa3, 0x23, 0xb4, 0x65,
	0x80, 0xed, 0x20, 0x3a, 0xe2, 0x1e, 0x7d, 0x95, 0x52, 0x2e, 0xd0, 0x12, 0x2c, 0xf7, 0x52, 0x2e,
	0x58, 0x48, 0x93, 0x6e, 0xe0, 0x57, 0x40, 0x0d, 0xac, 0xcc, 0x79, 0xd0, 0x6c, 0x3d, 0xf6, 0xad,
	0x77, 0x00, 0x2e, 0x15, 0x62, 0xf0, 0x98, 0x45, 0x9c, 0xa2, 0x00, 0xce, 0xe7, 0x91, 0xe0, 0x15,
	0x50, 0x9b, 0x59, 0x29, 0xaf, 0xae, 0xe3, 0xa2, 0x32, 0x8d, 0x8a, 0x80, 0xcf, 0xc3, 0x7b, 0xd7,
	0xc2, 0xf3, 0x21, 0xad, 0x36, 0x5c, 0xd8, 0xa4, 0x39, 0xc9, 0x18, 0x3e, 0xb7, 0xe0, 0x55, 0x03,
	0xda, 0x8d, 0x48, 0x48, 0x35, 0xa3, 0x2b, 0x66, 0xf3, 0x09, 0x09, 0xa9, 0xf5, 0x01, 0xc0, 0xa5,
	0x9d, 0x54, 0x10, 0x41, 0x8b, 0x81, 0x26, 0x15, 0x06, 0xbd, 0x80, 0x73, 0x2c, 0xa6, 0x89, 0xec,
	0x48, 0xa5, 0x54, 0x03, 0x2b, 0xe5, 0xd5, 0x26, 0x9e, 0xa4, 0x87, 0x1c, 0x9e, 0xbb, 0x06, 0xc4,
	0x3b, 0xc5, 0xb3, 0xbe, 0x01, 0x78, 0x73, 0x8c, 0x2b, 0xda, 0x80, 0xe5, 0x34, 0xf6, 0x89, 0xa0,
	0xb2, 0xdb, 0x95, 0x19, 0x19, 0xbe, 0x6a, 0xc2, 0x1b, 0x41, 0xe0, 0x47, 0x99, 0x20, 0x76, 0x08,
	0x3f, 0xf2, 0xa0, 0x72, 0xcf, 0x6c, 0xb4, 0x0b, 0x67, 0xd5, 0x4a, 0xb2, 0xba, 0x6c, 0x7f, 0xb6,
	0xfe, 0xf3, 0x34, 0x0c, 0xaa, 0xc0, 0xd9, 0x84, 0x86, 0x6c, 0x48, 0x65, 0x1d, 0xe6, 0xb2, 0x13,
	0xb5, 0x6e, 0x95, 0xcf, 0x14, 0xc9, 0x7a, 0x0d, 0x6b, 0xc5, 0x55, 0xd7, 0x52, 0x7a, 0x96, 0x41,
	0xf1, 0x74, 0x20, 0x74, 0x49, 0x1f, 0x5c, 0xa0, 0xa4, 0xc5, 0x98, 0xe9, 0x40, 0x78, 0x1a, 0xcf,
	0x7a, 0x08, 0x17, 0xc7, 0x7b, 0x5e, 0x48, 0x3b, 0xab, 0x9f, 0xff, 0x87, 0x37, 0xce, 0x23, 0x3c,
	0x55, 0xc9, 0xa0, 0x1f, 0x00, 0x5e, 0x2f, 0x98, 0x16, 0x74, 0x01, 0x2a, 0xe3, 0x87, 0xb5, 0xea,
	0x4e, 0x81, 0xa0, 0xea, 0x6b, 0xdd, 0x7d, 0xf3, 0xfd, 0xe7, 0xfb, 0xd2, 0x1a, 0x6a, 0x64, 0x6f,
	0x90, 0x51, 0x33, 0xb7, 0x8f, 0xcf, 0x68, 0xbd, 0x59, 0x3f, 0xb1, 0x73, 0x46, 0x0f, 0x7d, 0x05,
	0x70, 0x3e, 0x77, 0xf6, 0xd0, 0xfd, 0xc9, 0x79, 0x8d, 0x1b, 0xda, 0xea, 0xe5, 0x04, 0x68, 0x35,
	0x25, 0x97, 0xdb, 0x68, 0x3d, 0xe3, 0x72, 0xfc, 0x57, 0xeb, 0x9a, 0xa7, 0xd4, 0xea, 0x79, 0x64,
	0xec, 0xfa, 0x09, 0xfa, 0x05, 0x60, 0xa5, 0x48, 0x11, 0xc8, 0x9d, 0x46, 0x77, 0x8a, 0x55, 0x6b,
	0x2a, 0xe9, 0xaa, 0x76, 0xb5, 0x25, 0xc5, 0xa6, 0x75, 0xe7, 0x9f, 0xdb, 0xe5, 0x84, 0x12, 0xdb,
	0x01, 0xf5, 0xd6, 0xdb, 0x12, 0x5c, 0xee, 0xb1, 0x70, 0x62, 0x3a, 0xad, 0xc5, 0x42, 0x61, 0xef,
	0x65, 0x2f, 0xca, 0x1e, 0x78, 0xbe, 0xa5, 0x31, 0xfa, 0x6c, 0x40, 0xa2, 0x3e, 0x66, 0x49, 0xdf,
	0xee, 0xd3, 0x48, 0xbe, 0x37, 0xe6, 0x7b, 0x8b, 0x03, 0x5e, 0xfc, 0xa9, 0x6e, 0x18, 0xe3, 0x63,
	0x69, 0x66, 0xd3, 0x75, 0x3f, 0x95, 0x6a, 0x9b, 0x0a, 0xd0, 0xf5, 0x39, 0x56, 0x66, 0x66, 0xed,
	0x37, 0xb0, 0x0e, 0xcc, 0xbf, 0x18, 0x97, 0x8e, 0xeb, 0xf3, 0xce, 0xc8, 0xa5, 0xb3, 0xdf, 0xe8,
	0x18, 0x97, 0xdf, 0xa5, 0x65, 0xb5, 0xef, 0x38, 0xae, 0xcf, 0x1d, 0x67, 0xe4, 0xe4, 0x38, 0xfb,
	0x0d, 0xc7, 0x31, 0x6e, 0x07, 0xb3, 0x32, 0xcf, 0xb5, 0x3f, 0x01, 0x00, 0x00, 0xff, 0xff, 0x7e,
	0xe0, 0x79, 0xc5, 0xfb, 0x07, 0x00, 0x00,
}
