// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/api/auth.proto

/*
Package serviceconfig is a generated protocol buffer package.

It is generated from these files:
	google/api/auth.proto
	google/api/backend.proto
	google/api/billing.proto
	google/api/consumer.proto
	google/api/context.proto
	google/api/control.proto
	google/api/documentation.proto
	google/api/endpoint.proto
	google/api/log.proto
	google/api/logging.proto
	google/api/monitoring.proto
	google/api/quota.proto
	google/api/service.proto
	google/api/source_info.proto
	google/api/system_parameter.proto
	google/api/usage.proto

It has these top-level messages:
	Authentication
	AuthenticationRule
	AuthProvider
	OAuthRequirements
	AuthRequirement
	Backend
	BackendRule
	Billing
	BillingStatusRule
	ProjectProperties
	Property
	Context
	ContextRule
	Control
	Documentation
	DocumentationRule
	Page
	Endpoint
	LogDescriptor
	Logging
	Monitoring
	Quota
	MetricRule
	QuotaLimit
	Service
	SourceInfo
	SystemParameters
	SystemParameterRule
	SystemParameter
	Usage
	UsageRule
*/
package serviceconfig

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "google.golang.org/genproto/googleapis/api/annotations"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// `Authentication` defines the authentication configuration for an API.
//
// Example for an API targeted for external use:
//
//     name: calendar.googleapis.com
//     authentication:
//       providers:
//       - id: google_calendar_auth
//         jwks_uri: https://www.googleapis.com/oauth2/v1/certs
//         issuer: https://securetoken.google.com
//       rules:
//       - selector: "*"
//         requirements:
//           provider_id: google_calendar_auth
type Authentication struct {
	// A list of authentication rules that apply to individual API methods.
	//
	// **NOTE:** All service configuration rules follow "last one wins" order.
	Rules []*AuthenticationRule `protobuf:"bytes,3,rep,name=rules" json:"rules,omitempty"`
	// Defines a set of authentication providers that a service supports.
	Providers []*AuthProvider `protobuf:"bytes,4,rep,name=providers" json:"providers,omitempty"`
}

func (m *Authentication) Reset()                    { *m = Authentication{} }
func (m *Authentication) String() string            { return proto.CompactTextString(m) }
func (*Authentication) ProtoMessage()               {}
func (*Authentication) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *Authentication) GetRules() []*AuthenticationRule {
	if m != nil {
		return m.Rules
	}
	return nil
}

func (m *Authentication) GetProviders() []*AuthProvider {
	if m != nil {
		return m.Providers
	}
	return nil
}

// Authentication rules for the service.
//
// By default, if a method has any authentication requirements, every request
// must include a valid credential matching one of the requirements.
// It's an error to include more than one kind of credential in a single
// request.
//
// If a method doesn't have any auth requirements, request credentials will be
// ignored.
type AuthenticationRule struct {
	// Selects the methods to which this rule applies.
	//
	// Refer to [selector][google.api.DocumentationRule.selector] for syntax details.
	Selector string `protobuf:"bytes,1,opt,name=selector" json:"selector,omitempty"`
	// The requirements for OAuth credentials.
	Oauth *OAuthRequirements `protobuf:"bytes,2,opt,name=oauth" json:"oauth,omitempty"`
	// Whether to allow requests without a credential. The credential can be
	// an OAuth token, Google cookies (first-party auth) or EndUserCreds.
	//
	// For requests without credentials, if the service control environment is
	// specified, each incoming request **must** be associated with a service
	// consumer. This can be done by passing an API key that belongs to a consumer
	// project.
	AllowWithoutCredential bool `protobuf:"varint,5,opt,name=allow_without_credential,json=allowWithoutCredential" json:"allow_without_credential,omitempty"`
	// Requirements for additional authentication providers.
	Requirements []*AuthRequirement `protobuf:"bytes,7,rep,name=requirements" json:"requirements,omitempty"`
}

func (m *AuthenticationRule) Reset()                    { *m = AuthenticationRule{} }
func (m *AuthenticationRule) String() string            { return proto.CompactTextString(m) }
func (*AuthenticationRule) ProtoMessage()               {}
func (*AuthenticationRule) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *AuthenticationRule) GetSelector() string {
	if m != nil {
		return m.Selector
	}
	return ""
}

func (m *AuthenticationRule) GetOauth() *OAuthRequirements {
	if m != nil {
		return m.Oauth
	}
	return nil
}

func (m *AuthenticationRule) GetAllowWithoutCredential() bool {
	if m != nil {
		return m.AllowWithoutCredential
	}
	return false
}

func (m *AuthenticationRule) GetRequirements() []*AuthRequirement {
	if m != nil {
		return m.Requirements
	}
	return nil
}

// Configuration for an anthentication provider, including support for
// [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
type AuthProvider struct {
	// The unique identifier of the auth provider. It will be referred to by
	// `AuthRequirement.provider_id`.
	//
	// Example: "bookstore_auth".
	Id string `protobuf:"bytes,1,opt,name=id" json:"id,omitempty"`
	// Identifies the principal that issued the JWT. See
	// https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.1
	// Usually a URL or an email address.
	//
	// Example: https://securetoken.google.com
	// Example: 1234567-compute@developer.gserviceaccount.com
	Issuer string `protobuf:"bytes,2,opt,name=issuer" json:"issuer,omitempty"`
	// URL of the provider's public key set to validate signature of the JWT. See
	// [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html#ProviderMetadata).
	// Optional if the key set document:
	//  - can be retrieved from
	//    [OpenID Discovery](https://openid.net/specs/openid-connect-discovery-1_0.html
	//    of the issuer.
	//  - can be inferred from the email domain of the issuer (e.g. a Google service account).
	//
	// Example: https://www.googleapis.com/oauth2/v1/certs
	JwksUri string `protobuf:"bytes,3,opt,name=jwks_uri,json=jwksUri" json:"jwks_uri,omitempty"`
	// The list of JWT
	// [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
	// that are allowed to access. A JWT containing any of these audiences will
	// be accepted. When this setting is absent, only JWTs with audience
	// "https://[Service_name][google.api.Service.name]/[API_name][google.protobuf.Api.name]"
	// will be accepted. For example, if no audiences are in the setting,
	// LibraryService API will only accept JWTs with the following audience
	// "https://library-example.googleapis.com/google.example.library.v1.LibraryService".
	//
	// Example:
	//
	//     audiences: bookstore_android.apps.googleusercontent.com,
	//                bookstore_web.apps.googleusercontent.com
	Audiences string `protobuf:"bytes,4,opt,name=audiences" json:"audiences,omitempty"`
}

func (m *AuthProvider) Reset()                    { *m = AuthProvider{} }
func (m *AuthProvider) String() string            { return proto.CompactTextString(m) }
func (*AuthProvider) ProtoMessage()               {}
func (*AuthProvider) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *AuthProvider) GetId() string {
	if m != nil {
		return m.Id
	}
	return ""
}

func (m *AuthProvider) GetIssuer() string {
	if m != nil {
		return m.Issuer
	}
	return ""
}

func (m *AuthProvider) GetJwksUri() string {
	if m != nil {
		return m.JwksUri
	}
	return ""
}

func (m *AuthProvider) GetAudiences() string {
	if m != nil {
		return m.Audiences
	}
	return ""
}

// OAuth scopes are a way to define data and permissions on data. For example,
// there are scopes defined for "Read-only access to Google Calendar" and
// "Access to Cloud Platform". Users can consent to a scope for an application,
// giving it permission to access that data on their behalf.
//
// OAuth scope specifications should be fairly coarse grained; a user will need
// to see and understand the text description of what your scope means.
//
// In most cases: use one or at most two OAuth scopes for an entire family of
// products. If your product has multiple APIs, you should probably be sharing
// the OAuth scope across all of those APIs.
//
// When you need finer grained OAuth consent screens: talk with your product
// management about how developers will use them in practice.
//
// Please note that even though each of the canonical scopes is enough for a
// request to be accepted and passed to the backend, a request can still fail
// due to the backend requiring additional scopes or permissions.
type OAuthRequirements struct {
	// The list of publicly documented OAuth scopes that are allowed access. An
	// OAuth token containing any of these scopes will be accepted.
	//
	// Example:
	//
	//      canonical_scopes: https://www.googleapis.com/auth/calendar,
	//                        https://www.googleapis.com/auth/calendar.read
	CanonicalScopes string `protobuf:"bytes,1,opt,name=canonical_scopes,json=canonicalScopes" json:"canonical_scopes,omitempty"`
}

func (m *OAuthRequirements) Reset()                    { *m = OAuthRequirements{} }
func (m *OAuthRequirements) String() string            { return proto.CompactTextString(m) }
func (*OAuthRequirements) ProtoMessage()               {}
func (*OAuthRequirements) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *OAuthRequirements) GetCanonicalScopes() string {
	if m != nil {
		return m.CanonicalScopes
	}
	return ""
}

// User-defined authentication requirements, including support for
// [JSON Web Token (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
type AuthRequirement struct {
	// [id][google.api.AuthProvider.id] from authentication provider.
	//
	// Example:
	//
	//     provider_id: bookstore_auth
	ProviderId string `protobuf:"bytes,1,opt,name=provider_id,json=providerId" json:"provider_id,omitempty"`
	// NOTE: This will be deprecated soon, once AuthProvider.audiences is
	// implemented and accepted in all the runtime components.
	//
	// The list of JWT
	// [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
	// that are allowed to access. A JWT containing any of these audiences will
	// be accepted. When this setting is absent, only JWTs with audience
	// "https://[Service_name][google.api.Service.name]/[API_name][google.protobuf.Api.name]"
	// will be accepted. For example, if no audiences are in the setting,
	// LibraryService API will only accept JWTs with the following audience
	// "https://library-example.googleapis.com/google.example.library.v1.LibraryService".
	//
	// Example:
	//
	//     audiences: bookstore_android.apps.googleusercontent.com,
	//                bookstore_web.apps.googleusercontent.com
	Audiences string `protobuf:"bytes,2,opt,name=audiences" json:"audiences,omitempty"`
}

func (m *AuthRequirement) Reset()                    { *m = AuthRequirement{} }
func (m *AuthRequirement) String() string            { return proto.CompactTextString(m) }
func (*AuthRequirement) ProtoMessage()               {}
func (*AuthRequirement) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *AuthRequirement) GetProviderId() string {
	if m != nil {
		return m.ProviderId
	}
	return ""
}

func (m *AuthRequirement) GetAudiences() string {
	if m != nil {
		return m.Audiences
	}
	return ""
}

func init() {
	proto.RegisterType((*Authentication)(nil), "google.api.Authentication")
	proto.RegisterType((*AuthenticationRule)(nil), "google.api.AuthenticationRule")
	proto.RegisterType((*AuthProvider)(nil), "google.api.AuthProvider")
	proto.RegisterType((*OAuthRequirements)(nil), "google.api.OAuthRequirements")
	proto.RegisterType((*AuthRequirement)(nil), "google.api.AuthRequirement")
}

func init() { proto.RegisterFile("google/api/auth.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 437 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x64, 0x52, 0xcd, 0x6e, 0xd3, 0x40,
	0x10, 0x96, 0x9d, 0xa6, 0x8d, 0x27, 0x55, 0x0a, 0x2b, 0x51, 0x99, 0x52, 0x20, 0xf2, 0x29, 0x5c,
	0x1c, 0xa9, 0x45, 0x08, 0x09, 0x09, 0xd4, 0x22, 0x84, 0x7a, 0x22, 0x32, 0x42, 0x48, 0x5c, 0xac,
	0x65, 0x3d, 0x38, 0x4b, 0xdd, 0x1d, 0xb3, 0x3f, 0xcd, 0x8d, 0x87, 0xe1, 0xc9, 0x78, 0x94, 0xca,
	0x6b, 0x37, 0x71, 0xd2, 0xe3, 0x7c, 0x3f, 0x33, 0xf3, 0xcd, 0x2e, 0x3c, 0x29, 0x89, 0xca, 0x0a,
	0xe7, 0xbc, 0x96, 0x73, 0xee, 0xec, 0x32, 0xad, 0x35, 0x59, 0x62, 0xd0, 0xc2, 0x29, 0xaf, 0xe5,
	0xc9, 0x69, 0x5f, 0xa2, 0x14, 0x59, 0x6e, 0x25, 0x29, 0xd3, 0x2a, 0x93, 0xbf, 0x30, 0xb9, 0x70,
	0x76, 0x89, 0xca, 0x4a, 0xe1, 0x09, 0xf6, 0x1a, 0x86, 0xda, 0x55, 0x68, 0xe2, 0xc1, 0x74, 0x30,
	0x1b, 0x9f, 0xbd, 0x48, 0x37, 0xbd, 0xd2, 0x6d, 0x69, 0xe6, 0x2a, 0xcc, 0x5a, 0x31, 0x7b, 0x03,
	0x51, 0xad, 0xe9, 0x56, 0x16, 0xa8, 0x4d, 0xbc, 0xe7, 0x9d, 0xf1, 0xae, 0x73, 0xd1, 0x09, 0xb2,
	0x8d, 0x34, 0xf9, 0x1f, 0x00, 0x7b, 0xd8, 0x95, 0x9d, 0xc0, 0xc8, 0x60, 0x85, 0xc2, 0x92, 0x8e,
	0x83, 0x69, 0x30, 0x8b, 0xb2, 0x75, 0xcd, 0xce, 0x61, 0x48, 0x4d, 0xd6, 0x38, 0x9c, 0x06, 0xb3,
	0xf1, 0xd9, 0xf3, 0xfe, 0x98, 0x2f, 0x4d, 0xaf, 0x0c, 0xff, 0x38, 0xa9, 0xf1, 0x06, 0x95, 0x35,
	0x59, 0xab, 0x65, 0x6f, 0x21, 0xe6, 0x55, 0x45, 0xab, 0x7c, 0x25, 0xed, 0x92, 0x9c, 0xcd, 0x85,
	0xc6, 0xa2, 0x19, 0xca, 0xab, 0x78, 0x38, 0x0d, 0x66, 0xa3, 0xec, 0xd8, 0xf3, 0xdf, 0x5b, 0xfa,
	0xe3, 0x9a, 0x65, 0x1f, 0xe0, 0x50, 0xf7, 0x1a, 0xc6, 0x07, 0x3e, 0xdc, 0xb3, 0xdd, 0x70, 0xbd,
	0xa1, 0xd9, 0x96, 0x21, 0x21, 0x38, 0xec, 0xa7, 0x67, 0x13, 0x08, 0x65, 0xd1, 0xa5, 0x0a, 0x65,
	0xc1, 0x8e, 0x61, 0x5f, 0x1a, 0xe3, 0x50, 0xfb, 0x40, 0x51, 0xd6, 0x55, 0xec, 0x29, 0x8c, 0x7e,
	0xaf, 0xae, 0x4d, 0xee, 0xb4, 0x8c, 0x07, 0x9e, 0x39, 0x68, 0xea, 0x6f, 0x5a, 0xb2, 0x53, 0x88,
	0xb8, 0x2b, 0x24, 0x2a, 0x81, 0xcd, 0xb5, 0x1b, 0x6e, 0x03, 0x24, 0xef, 0xe1, 0xf1, 0x83, 0x3b,
	0xb0, 0x57, 0xf0, 0x48, 0x70, 0x45, 0x4a, 0x0a, 0x5e, 0xe5, 0x46, 0x50, 0x8d, 0xa6, 0xdb, 0xe1,
	0x68, 0x8d, 0x7f, 0xf5, 0x70, 0xb2, 0x80, 0xa3, 0x1d, 0x3b, 0x7b, 0x09, 0xe3, 0xfb, 0x37, 0xcb,
	0xd7, 0xcb, 0xc3, 0x3d, 0x74, 0x55, 0x6c, 0x6f, 0x14, 0xee, 0x6c, 0x74, 0x79, 0x0d, 0x13, 0x41,
	0x37, 0xbd, 0x93, 0x5d, 0x46, 0xdd, 0x49, 0x2c, 0x2d, 0x82, 0x1f, 0x9f, 0x3a, 0xa2, 0xa4, 0x8a,
	0xab, 0x32, 0x25, 0x5d, 0xce, 0x4b, 0x54, 0xfe, 0x83, 0xce, 0x5b, 0x8a, 0xd7, 0xd2, 0xf8, 0x1f,
	0x6c, 0x50, 0xdf, 0x4a, 0x81, 0x82, 0xd4, 0x2f, 0x59, 0xbe, 0xdb, 0xaa, 0xfe, 0x85, 0x7b, 0x9f,
	0x2f, 0x16, 0x57, 0x3f, 0xf7, 0xbd, 0xf1, 0xfc, 0x2e, 0x00, 0x00, 0xff, 0xff, 0xb9, 0x6d, 0xc6,
	0x5e, 0x1c, 0x03, 0x00, 0x00,
}
