// Code generated by go-bindata. DO NOT EDIT.
// sources:
// assets/dns/cluster-role-binding.yaml (223B)
// assets/dns/cluster-role.yaml (210B)
// assets/dns/configmap.yaml (390B)
// assets/dns/daemonset.yaml (4.414kB)
// assets/dns/metrics/cluster-role-binding.yaml (279B)
// assets/dns/metrics/cluster-role.yaml (246B)
// assets/dns/metrics/role-binding.yaml (293B)
// assets/dns/metrics/role.yaml (284B)
// assets/dns/namespace.yaml (369B)
// assets/dns/service-account.yaml (85B)
// assets/dns/service.yaml (381B)

package manifests

import (
	"bytes"
	"compress/gzip"
	"crypto/sha256"
	"fmt"
	"io"
	"io/ioutil"
	"os"
	"path/filepath"
	"strings"
	"time"
)

func bindataRead(data []byte, name string) ([]byte, error) {
	gz, err := gzip.NewReader(bytes.NewBuffer(data))
	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}

	var buf bytes.Buffer
	_, err = io.Copy(&buf, gz)
	clErr := gz.Close()

	if err != nil {
		return nil, fmt.Errorf("Read %q: %v", name, err)
	}
	if clErr != nil {
		return nil, err
	}

	return buf.Bytes(), nil
}

type asset struct {
	bytes  []byte
	info   os.FileInfo
	digest [sha256.Size]byte
}

type bindataFileInfo struct {
	name    string
	size    int64
	mode    os.FileMode
	modTime time.Time
}

func (fi bindataFileInfo) Name() string {
	return fi.name
}
func (fi bindataFileInfo) Size() int64 {
	return fi.size
}
func (fi bindataFileInfo) Mode() os.FileMode {
	return fi.mode
}
func (fi bindataFileInfo) ModTime() time.Time {
	return fi.modTime
}
func (fi bindataFileInfo) IsDir() bool {
	return false
}
func (fi bindataFileInfo) Sys() interface{} {
	return nil
}

var _assetsDnsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\xce\x31\x8e\x83\x40\x0c\x05\xd0\x7e\x4e\xe1\x0b\xc0\x6a\xbb\xd5\x74\x9b\xdc\x80\x48\xe9\xcd\x8c\x09\x0e\x60\xa3\xb1\x87\x22\xa7\x8f\x10\x4a\x45\x3a\x17\xfe\xff\xfd\x89\x25\x47\xb8\xce\xd5\x9c\x4a\xa7\x33\x5d\x58\x32\xcb\x23\xe0\xca\x77\x2a\xc6\x2a\x11\x4a\x8f\xa9\xc5\xea\xa3\x16\x7e\xa1\xb3\x4a\x3b\xfd\x59\xcb\xfa\xb3\xfd\x86\x85\x1c\x33\x3a\xc6\x00\x00\x20\xb8\x50\x04\x5d\x49\x6c\xe4\xc1\x9b\x2c\x16\xac\xf6\x4f\x4a\x6e\x31\x34\x70\x78\x37\x2a\x1b\x27\xfa\x4f\x49\xab\x78\xf8\xc4\xf6\xe7\xe3\xb6\x15\xd3\xa9\xa7\xe8\x4c\x1d\x0d\x3b\x74\x9a\x1d\xbe\xd3\xef\x00\x00\x00\xff\xff\xfa\x62\xe7\x50\xdf\x00\x00\x00")

func assetsDnsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleBindingYaml,
		"assets/dns/cluster-role-binding.yaml",
	)
}

func assetsDnsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role-binding.yaml", size: 223, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xd9, 0xf6, 0x2a, 0x3b, 0x84, 0xd7, 0x3e, 0xc4, 0xe1, 0x70, 0x66, 0x31, 0xda, 0xc4, 0x2f, 0x53, 0x27, 0x29, 0x13, 0xfe, 0x80, 0x36, 0xc5, 0xa1, 0x70, 0xdc, 0x2d, 0xef, 0xcf, 0xe0, 0xc4, 0xeb}}
	return a, nil
}

var _assetsDnsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\x8d\xbd\x6e\xc5\x30\x08\x46\x77\x3f\x05\xba\x7b\x52\x75\xab\xbc\x76\xe8\xde\xa1\x3b\xd7\xa6\x0a\x8a\x03\x16\xe0\x54\xea\xd3\x5f\xe5\x67\x3b\xe7\x08\xf4\xad\x2c\x35\xc3\x67\x1b\x1e\x64\xdf\xda\x28\x61\xe7\x1f\x32\x67\x95\x0c\xf6\xc4\x32\xe3\x88\x45\x8d\xff\x31\x58\x65\x5e\x3f\x7c\x66\x7d\xdb\xdf\xd3\x46\x81\x15\x03\x73\x02\x10\xdc\x28\x83\x76\x12\x5f\xf8\x37\xa6\x2a\x9e\x6c\x34\xf2\x9c\x26\xc0\xce\x5f\xa6\xa3\xfb\x71\x39\xc1\xe3\x91\x00\x8c\x5c\x87\x15\xba\x1b\x49\xed\xca\x12\x7e\x9a\x93\xed\x5c\xe8\x92\xae\xf5\x82\x63\xc3\x3b\x5e\x7d\x27\x7b\xde\xbf\x8d\x3d\x4e\xf8\xc3\x28\x4b\x7a\x05\x00\x00\xff\xff\xcb\xdd\xd7\x2a\xd2\x00\x00\x00")

func assetsDnsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsClusterRoleYaml,
		"assets/dns/cluster-role.yaml",
	)
}

func assetsDnsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/cluster-role.yaml", size: 210, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x37, 0xb2, 0x0, 0x7d, 0x4a, 0xd9, 0xf, 0x8, 0x44, 0xe7, 0xab, 0x82, 0xe4, 0x50, 0x94, 0xaa, 0x4e, 0xfd, 0xa0, 0x63, 0xba, 0x18, 0xcf, 0xeb, 0xa6, 0xe4, 0x2d, 0x4, 0x35, 0xd5, 0xc7, 0xd}}
	return a, nil
}

var _assetsDnsConfigmapYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x6c\x8c\x4f\x4b\x33\x31\x18\xc4\xef\xfb\x29\x06\xde\xf3\xbb\xb5\x2c\x2b\xb8\xd7\x9e\xbd\x7a\x7f\x4c\x66\x9b\xd0\x6c\x12\x9e\x24\x45\x51\xbf\xbb\xb4\x85\x68\xc1\x39\xcd\x3f\x7e\x27\x1f\xed\x82\x43\x8a\xab\x3f\x3e\x4b\x1e\x24\xfb\x17\x6a\xf1\x29\x2e\x38\xef\x87\x7f\x88\xb2\x11\x12\xed\xd5\x94\x2c\x86\x10\x25\x0a\x2b\xa4\x42\x5b\xac\x7e\xe3\x60\xa5\xca\x32\x00\x87\xa4\x5c\x7d\xe0\x82\xcf\x01\x00\xc6\x65\x9e\xe6\x09\x1f\xd7\x70\x11\x55\x93\x96\x1e\x1d\x25\x54\xd7\xe3\xa9\xbd\x52\x23\x2b\x0b\x4c\x68\xa5\x52\xc7\x90\x8c\x04\xf8\xf8\x5f\xac\xd5\x51\x34\x0b\x7c\x7e\xbc\x99\x1f\xec\x45\x39\xd9\x02\x1f\x0b\x4d\x53\xde\x2d\x2d\x97\xaa\x94\xed\xae\x5c\x25\x84\xea\x34\xb5\xa3\xfb\x1b\xdf\xdf\x5f\xdd\x65\x4d\x1b\xab\x63\x2b\x58\x9e\xf6\xf3\xf4\x7b\x78\x7b\xc7\x88\x1d\xab\xd9\x29\x4b\x0a\xe7\xd1\xa4\xb8\xf6\x83\x11\xe3\x88\xe9\xa1\x17\xca\x90\xc4\x0e\x37\xfe\x77\x00\x00\x00\xff\xff\xef\xe8\x25\x0a\x86\x01\x00\x00")

func assetsDnsConfigmapYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsConfigmapYaml,
		"assets/dns/configmap.yaml",
	)
}

func assetsDnsConfigmapYaml() (*asset, error) {
	bytes, err := assetsDnsConfigmapYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/configmap.yaml", size: 390, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x60, 0x35, 0x3d, 0x20, 0x71, 0xe4, 0x2d, 0x28, 0xd6, 0xac, 0xd6, 0xef, 0x59, 0x0, 0x1, 0x68, 0xee, 0x6, 0x5b, 0xde, 0x33, 0x4d, 0xdf, 0xf1, 0x31, 0xbd, 0x16, 0xd1, 0xfc, 0xec, 0x7e, 0x62}}
	return a, nil
}

var _assetsDnsDaemonsetYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\xcc\x57\x51\x73\xdb\xb8\x11\x7e\xd7\xaf\xd8\xa3\x3c\x71\x32\x35\x6d\xb9\x37\xb9\x5e\x99\xf8\x7a\xae\x2d\x37\x9e\x46\xb6\xc6\x52\xae\x0f\x1e\x4f\x06\x02\x97\x22\x6a\x10\xc0\x01\x4b\x2a\x1a\xc7\xff\xbd\x03\xd2\x94\x40\x4a\xf5\x4d\xdf\xea\x07\x4b\xc2\xee\x7e\xd8\x5d\xec\xb7\x58\x3c\x0a\x95\x26\x70\xc9\xb0\xd0\x6a\x86\x34\x60\x46\xfc\x86\xd6\x09\xad\x12\x60\xc6\xb8\x93\xea\x74\x30\x04\xc5\x0a\x3c\xaa\xff\x3b\xc3\x38\x02\x53\x29\x48\xb6\x40\xe9\x80\x59\x04\x87\x04\x8c\xc0\x96\x8a\x44\x81\x03\x67\x90\x27\x03\x00\xc2\xc2\x48\x46\xe8\xbf\x03\xb4\xab\xf5\x77\xb4\x95\xe0\x78\xce\xb9\x2e\x15\xdd\xb0\x02\x13\x48\x95\x7b\x91\x1a\x2b\xb4\x15\xb4\xbe\x90\xcc\xb9\x46\xe8\xd6\x8e\xb0\x88\x95\x4e\x31\xe6\x56\x90\xe0\x4c\xbe\x68\x73\xad\x88\x09\x85\xd6\xb5\xe8\x71\xed\x69\x88\x08\x30\x04\x51\xb0\x25\x82\x70\x7d\x6f\x5b\x8d\x5a\x3e\x2d\xa5\x9c\x6a\x29\xf8\x3a\x81\xeb\xec\x46\xd3\xd4\xa2\x43\x45\x1b\x2d\x42\x5b\x08\xc5\x48\x68\x35\x41\xe7\xbc\xc9\x8b\xfa\x15\x93\x72\xc1\xf8\xe3\x5c\x7f\xd6\x4b\x77\xab\xc6\xd6\x6a\xbb\xb1\xe3\xba\x28\x98\x4f\xf5\x3d\x44\x5c\x5b\x4c\x95\x8b\xe0\x61\x23\x66\x76\xe9\x6a\x59\xcc\xb5\xca\xa2\x23\x88\x4e\x90\xf8\xc9\x8b\xe6\xc9\x85\xb6\x98\x09\x89\xa1\x49\xa5\x65\x59\xe0\xc4\x27\x70\x13\xf9\x36\x76\x0f\x23\x96\x71\xa3\xb4\x91\x02\x14\x5e\x7f\xca\x28\x4f\x20\xdc\x21\xd0\xb0\xc8\xd2\x5b\x25\xd7\x09\x90\x2d\xb7\xa6\x46\xdb\xee\x3e\x9b\xbc\x4f\xb5\xa5\x04\xde\xff\xf8\xfe\xc7\x00\x65\xf7\x04\xfc\xb9\x6a\xd2\x5c\xcb\x04\xbe\x5c\x4e\xff\x77\xa4\x98\xb8\xd9\x8b\x36\xbf\x78\x05\xed\xaf\xa7\x7b\xd0\x0a\x24\x2b\xf8\x7e\xdf\x42\x34\x29\x2a\x54\xe8\xdc\xd4\xea\x05\x26\x81\x7a\x4e\x64\xfe\x81\x14\x2e\x01\x98\x26\xad\x39\x32\x49\x79\x57\x52\xbb\xf2\xf3\xe8\xe7\x51\x67\xd9\xf1\x1c\xbd\x3b\x9f\xe6\xf3\x69\x20\x10\x4a\x90\x60\xf2\x12\x25\x5b\xcf\x90\x6b\x95\xba\x04\x7e\x0a\x4d\x7d\xe1\xea\x92\x36\xc2\xf7\x81\xcc\x95\x9c\xa3\x73\xf3\xdc\xa2\xcb\xb5\x4c\x13\x38\x0d\xa4\x19\x13\xb2\xb4\x18\x48\xb7\xb6\x16\x9d\x2e\x2d\x47\x17\x86\x25\x45\x21\xc8\x75\x03\x2d\xb0\xd0\x76\x9d\xc0\xfb\xd3\x3f\x4f\x44\xa7\x74\x7e\x2f\xd1\xf5\xb5\xb9\x29\x13\x38\x1d\x8d\x8a\xbd\x18\x7f\x19\x6d\x20\x02\xde\x36\x4c\xf7\x0e\xc9\x0a\xed\xff\x0d\x8b\x1d\xf2\xb2\xee\x4c\x5a\x11\x7e\xeb\x1c\xbf\xb1\xa2\x12\x12\x97\x98\xf6\x88\xf3\x3a\x4f\x73\xed\xc8\xc5\x9e\xdb\xaf\x90\xb4\x56\x0a\x92\x80\xaa\x82\x9b\xf3\xc9\x78\x36\xbe\xfb\x6d\x7c\x57\x77\xe3\x8b\xcf\x5f\x66\xf3\xf1\xdd\xd7\xcb\xdb\xc9\xf9\xf5\xcd\xbe\xae\xdc\x9a\xa3\xaa\x76\xdd\xf0\x48\xd7\x17\xe3\x59\xe0\xc4\x10\x2e\x7c\xcf\x02\x6d\xa1\x69\xfa\x0e\x0d\xb3\x8c\x30\x05\x29\x1c\x81\xce\xda\x36\xee\x3a\x56\x37\xb7\xf3\x71\x02\x57\xda\x82\xd2\xab\x23\x40\xe5\x4a\x8b\x40\x39\x3a\xac\xdd\xb2\x28\x19\x89\x0a\x9b\xeb\xe4\x03\x64\xda\x02\x32\x9e\x77\x05\x47\x1d\x4c\xa6\x80\x49\xc1\x1c\xac\x04\xe5\x1e\xab\x1f\xaf\x2b\xb3\x4c\x7c\x83\x95\x90\x12\x98\x74\x1a\x16\x08\x2c\x4d\x31\x3d\x0e\x70\x2a\x26\x4b\x4c\x20\xaa\x6b\x24\xb6\xb8\x14\x8e\xec\xfa\x58\x1b\x54\x2e\x17\x19\xc5\x3d\x81\xab\x78\xb4\xd3\xc0\x83\xd4\x9d\x2c\x84\x3a\x59\x30\x97\x07\x6b\x31\x0f\x7e\x7c\x0f\x83\xf8\x61\x57\x1d\xea\x33\x8a\x4b\x0d\x46\x18\xf4\xd4\x1c\x84\x24\xb7\xcc\xc0\xe1\xa3\x0f\xe9\xe0\xed\xbf\xf5\xc2\x41\x6c\xde\x7d\x00\xfc\x26\x08\x46\x87\x30\x1f\xdf\x4d\x42\xf5\xdb\xe9\xf8\x66\xf6\xe9\xfa\x6a\xfe\x75\x72\x7e\xf7\xcf\xf1\xdd\x59\xb4\x0d\x6c\x89\x0a\xeb\xa3\xeb\xf2\x2a\x0a\xcc\x3f\xdd\xce\xe6\xb3\xaf\x57\xd7\x9f\xc7\x67\xd1\xb6\xe8\x42\x8d\xf9\x78\x32\xdd\x51\x38\xa6\xc2\x44\xa1\x1b\xd7\x57\xb3\xb3\xc3\x23\x38\xac\xef\x11\x88\x2d\xc4\x6c\x53\x27\xf0\xf1\xe3\x47\x88\x0e\x9e\xda\x6a\x7b\xee\x58\x0e\x61\xc2\x1e\x11\x58\x3d\x37\x68\xcb\xec\x1a\x3c\x2f\xb6\x67\xae\x65\xda\xf0\xa5\x5e\x3f\x74\xc0\x88\xac\x58\x94\x84\x2e\x3c\x66\x6e\x20\xce\x20\x8e\xb7\xd2\x58\x2b\xb9\xf6\x1b\x6f\x83\x7c\x8e\xfc\xef\x4d\x48\x5d\x4f\x56\xb9\xdf\xd7\xb3\xf8\x03\xa4\xba\xd3\xb6\x52\xe4\xd2\x57\x71\x7c\x0e\xae\xe2\x5f\x85\x71\x1d\xb1\x2f\x66\x57\x71\x10\xca\xc3\xb7\x71\xdf\xff\xfa\xf0\x1c\xed\x40\xf9\x88\xaf\x90\x78\xde\xe6\x07\xae\xa7\x90\x59\x5d\x00\x97\xa5\x23\xb4\xbe\x11\x82\xc8\xc0\xf4\xba\x57\xf3\x27\x8c\x3b\x7b\x7b\xf0\x36\x15\x4b\xf8\x35\x3a\x78\xda\xf6\x83\xe7\x08\xfe\xe4\x72\x6d\xa9\x76\xa1\xe2\xcf\xc7\x07\x4f\x5d\xba\x3c\x47\xef\xde\x0d\xfa\x70\x19\xdc\xdf\x43\x74\xf0\xb7\x08\x62\xfc\x1d\x46\xf0\xe6\x8d\xb7\x1f\x0a\xd3\xb8\x0f\xb1\x42\x18\xc1\xc3\xc3\x07\x7f\x16\xaa\x67\x0d\x6d\x36\xee\x5f\xf6\x8c\x1e\xce\xa2\x83\xa7\xd6\xb8\xa7\x9d\x89\x6e\x4e\xb5\xc2\xae\x3b\x43\xf8\x62\x52\x46\x18\xb4\x3f\xa8\xcf\x50\x64\xb0\x42\x58\x22\x79\x32\x8b\x34\xc8\x9c\xeb\x01\xfc\x0b\x9b\x6e\xa0\x34\x41\xb9\x03\xb6\xca\x51\xf9\x38\x6c\x7d\x97\xbc\x0c\x41\x1b\x34\x5d\x92\xbf\x65\xb4\x05\x66\x04\x94\x8a\x55\x4c\x48\xb6\x10\x52\xd0\xba\xb7\xcd\x8c\x98\x44\x40\x45\x56\xa0\x07\x2a\x65\xea\x19\xea\xc8\x97\x40\xb0\xa1\xc8\xea\x12\x6e\x77\x10\x0e\x52\x94\x48\x98\x0e\xf6\x1d\xc2\xd3\xb0\x4d\xe7\x1f\xa7\x7e\x08\x7f\x2f\x85\x4c\x81\x81\xc2\x55\xc0\x8f\xa6\x94\xc2\x98\x3d\x8f\x74\x69\x81\x97\x8e\x74\xb1\x71\x3a\x13\x92\xd0\x62\xea\xc3\xee\x61\x2f\x2d\x1a\x88\x2b\x88\x86\x70\xf0\xd4\x6f\x30\x0d\x85\x3a\x94\xfa\xe5\x15\x52\x35\xbe\x9e\x1b\x83\x2a\x85\xb6\x03\x6d\x9d\xf0\xc4\xd9\xbd\x4e\x60\x87\x53\x3f\x84\x99\xd9\xc3\xa9\x46\x5f\x18\xaf\x5e\x97\x62\xad\xdc\x14\xe5\xc3\xf3\x5e\x03\x00\xe4\xb9\x86\xba\x5e\x9f\x1b\xa3\xf6\x63\x97\x3a\xf0\x5f\x52\xf1\xcb\x4e\xec\xfd\x4d\xea\x32\xdf\xb3\xb4\x93\xa3\xf9\xed\xe5\x6d\xb2\x87\x01\x8c\x74\xe1\x1f\x3e\x72\x0d\xa4\x81\x55\x5a\xa4\xc0\xd4\x1a\x84\xe2\x5a\x39\xe1\x08\x15\xc1\x02\x73\x56\x89\x60\x66\x69\x51\xef\xd0\x48\x7f\x8d\xef\xab\x88\x42\xa7\x22\x13\x98\x42\xd5\xbc\xfd\x7c\x21\x2a\xc4\xb4\x57\x9e\x00\xbc\x30\xbd\x30\x77\x6a\xe0\xfb\xf7\x97\x0e\xfc\xba\xde\x6e\xd4\xad\xae\x27\x87\x67\xad\xc5\x42\x57\x98\x6e\x63\xad\xab\x9a\x5b\x64\x84\x27\x0d\x7b\xea\xd1\x67\xdb\xe7\x81\x6b\xb3\x06\x9e\x97\xb6\x4b\x92\x5e\xbf\x71\x12\xd1\xc0\x4f\x23\x78\x03\x2b\x26\xba\x35\x5f\x2a\x7f\x25\xef\xb6\xf6\xce\xe1\xed\x1d\x94\x5f\x1d\x7e\xdb\xd9\x37\x55\xae\x9d\x34\x2f\x31\x63\xa5\x6c\x77\xf7\xf7\xf2\x0c\x25\x72\xd2\x76\x8b\xb0\x40\x62\xc7\x8f\xe5\x02\xad\x42\x7f\xcb\x09\x7d\xa2\x5d\x02\x52\xa8\xf2\x5b\xa3\xf1\xa2\xda\x0c\x99\xdb\xbd\xff\xe0\x19\xd8\x2c\x4f\x98\x09\x9c\x1d\x82\x7f\x6a\xbf\x32\x5a\xfb\xfe\x44\x58\x74\x03\x8c\xe1\x11\xd7\x09\xb4\x0f\xd4\xee\xa9\x36\x0f\xa2\xbe\xec\xb5\xd1\xd7\xaf\xd5\x83\xef\x60\x07\x66\xcf\x24\xec\x87\xa4\xb5\xc1\x04\xae\xb6\x20\xa4\xa5\x1f\x75\x84\x56\x1b\x47\x87\xed\x22\x02\x93\x12\xfc\xeb\x90\x1c\x38\x0d\x94\x33\x82\xcb\x9b\x99\x0f\x9a\xc9\x15\x5b\xbb\xf6\xae\x05\xad\x6a\x5d\x7f\x2c\x6e\xf3\x3c\xd1\xc6\xa3\x68\x9b\xc0\xd8\xb7\x78\x37\xf8\x4f\x00\x00\x00\xff\xff\x09\x5c\x57\xbb\x3e\x11\x00\x00")

func assetsDnsDaemonsetYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsDaemonsetYaml,
		"assets/dns/daemonset.yaml",
	)
}

func assetsDnsDaemonsetYaml() (*asset, error) {
	bytes, err := assetsDnsDaemonsetYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/daemonset.yaml", size: 4414, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0xfd, 0x1b, 0x97, 0xac, 0x3a, 0x0, 0x59, 0xe7, 0x97, 0xb9, 0xc1, 0x5, 0xe3, 0x3f, 0x5e, 0xe1, 0x2f, 0x7, 0x92, 0xe, 0xe5, 0xd8, 0x1d, 0xc1, 0x4a, 0x42, 0x22, 0x38, 0x49, 0x5f, 0x1}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x7c\x8f\xb1\x4a\x04\x41\x0c\x86\xfb\x79\x8a\xbc\xc0\xae\xd8\x1d\xd3\xa9\x85\xfd\x09\xf6\xb9\x99\x9c\x1b\x77\x27\x19\x92\xcc\x16\x3e\xbd\x2c\x8a\x08\xe2\xb5\x81\x7c\xdf\xff\xad\x2c\x35\xc3\xd3\x36\x3c\xc8\xce\xba\xd1\x23\x4b\x65\x79\x4b\xd8\xf9\x95\xcc\x59\x25\x83\x5d\xb0\xcc\x38\x62\x51\xe3\x0f\x0c\x56\x99\xd7\x93\xcf\xac\x77\xfb\x7d\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xaa\xf8\xd4\x54\x38\xd4\x0e\x92\x8f\xcb\x3b\x95\xf0\x9c\x26\xf8\xd2\xbd\x90\xed\x5c\xe8\xa1\x14\x1d\x12\x3f\x7f\xdd\xb4\x51\x2c\x34\x7c\x5a\x4f\xfe\x7d\xf6\x8e\x85\x32\x68\x27\xf1\x85\xaf\xf1\x9b\x6c\xba\xd1\x99\xae\x87\xf9\x4f\xc7\x7f\x6b\x00\xb0\xf3\xb3\xe9\xe8\x37\xba\xd2\x67\x00\x00\x00\xff\xff\x5b\x52\x00\xaa\x17\x01\x00\x00")

func assetsDnsMetricsClusterRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleBindingYaml,
		"assets/dns/metrics/cluster-role-binding.yaml",
	)
}

func assetsDnsMetricsClusterRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role-binding.yaml", size: 279, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x79, 0x95, 0x6f, 0xa4, 0xd5, 0xed, 0x48, 0x27, 0x41, 0x56, 0x5c, 0xea, 0x5c, 0x89, 0xdc, 0xc1, 0x44, 0x91, 0xd4, 0xb, 0x18, 0x85, 0x79, 0x75, 0xaa, 0x6e, 0xb5, 0x98, 0xbe, 0xc6, 0x33, 0x43}}
	return a, nil
}

var _assetsDnsMetricsClusterRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x34\xcd\x31\x4b\x34\x41\x0c\x87\xf1\x7e\x3e\x45\xe0\xad\x77\x5f\xec\x64\x5a\x05\x3b\x0b\x05\xfb\xec\xce\xdf\xdb\x70\x3b\xc9\x90\x64\x0e\xf4\xd3\x8b\x70\xb6\x0f\x3f\x78\xfe\xd1\xd3\x39\x23\xe1\xe4\x76\x22\x48\x81\x86\x46\xdb\x17\x0d\xb7\x8e\x3c\x30\x83\xd2\x28\x76\xe7\x01\x7a\x7e\x7d\xa7\x8e\x74\xd9\x83\xa0\x6d\x98\x68\x16\x1e\xf2\x01\x0f\x31\xad\xe4\x1b\xef\x2b\xcf\x3c\xcc\xe5\x9b\x53\x4c\xd7\xeb\x63\xac\x62\xff\x6f\x0f\xe5\x2a\xda\xea\xdf\xf0\xcd\x4e\x94\x8e\xe4\xc6\xc9\xb5\x10\x29\x77\x54\x6a\x1a\x4b\x37\x95\x34\x17\xbd\x14\x9f\x27\xa2\x96\x85\x78\xc8\x8b\xdb\x1c\xf1\x4b\x17\xb2\x01\xe7\x34\x5f\x6d\x40\xe3\x90\xcf\x5c\xc5\x0a\x91\x23\x6c\xfa\x8e\x3b\x6b\x1a\x88\x42\x74\x83\x6f\xf7\x74\x41\x96\x9f\x00\x00\x00\xff\xff\x9f\xa8\x4d\x6c\xf6\x00\x00\x00")

func assetsDnsMetricsClusterRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsClusterRoleYaml,
		"assets/dns/metrics/cluster-role.yaml",
	)
}

func assetsDnsMetricsClusterRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsClusterRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/cluster-role.yaml", size: 246, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x64, 0xdb, 0xe0, 0x95, 0x65, 0xae, 0x53, 0x96, 0x3a, 0x5f, 0x5e, 0x8b, 0x69, 0xe2, 0x7d, 0x5, 0xbf, 0x1f, 0x3a, 0xf, 0xff, 0xd0, 0x6b, 0x23, 0x4f, 0xfd, 0x11, 0x7f, 0x57, 0xd4, 0x4a, 0x8b}}
	return a, nil
}

var _assetsDnsMetricsRoleBindingYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x94\xce\xb1\x4e\xc4\x40\x0c\x04\xd0\x7e\xbf\xc2\x3f\x90\x20\xba\xd3\x76\xd0\xd0\x1f\x12\xbd\x6f\xd7\x97\x98\x64\xed\x95\xed\x4d\xc1\xd7\x23\xa4\x48\x54\x20\x5d\x3b\x9a\xd1\x1b\xec\xfc\x41\xe6\xac\x92\xc1\x6e\x58\x66\x1c\xb1\xaa\xf1\x17\x06\xab\xcc\xdb\xc5\x67\xd6\xa7\xe3\x39\x6d\x2c\x35\xc3\x55\x77\x7a\x65\xa9\x2c\x4b\x6a\x14\x58\x31\x30\x27\x00\xc1\x46\x19\xba\x69\xa3\x58\x69\xf8\xb4\x5d\xfc\x8c\xbd\x63\xa1\x0c\xda\x49\x7c\xe5\x7b\x4c\x55\x3c\x99\xee\x74\xa5\xfb\xcf\x14\x3b\xbf\x99\x8e\xfe\x8f\x9f\x00\x7e\xf9\xbf\x34\x1f\xb7\x4f\x2a\xe1\x39\x4d\x67\xfb\x9d\xec\xe0\x42\x2f\xa5\xe8\x90\x78\xf0\x65\x53\xe1\x50\x63\x59\x20\x7d\x07\x00\x00\xff\xff\xb9\xd9\xab\x8d\x25\x01\x00\x00")

func assetsDnsMetricsRoleBindingYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleBindingYaml,
		"assets/dns/metrics/role-binding.yaml",
	)
}

func assetsDnsMetricsRoleBindingYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleBindingYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role-binding.yaml", size: 293, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xc, 0x7d, 0xc7, 0x45, 0x33, 0xc4, 0xd8, 0xf, 0x8d, 0x89, 0x8d, 0x6, 0x47, 0xa7, 0xa, 0x6b, 0x17, 0xf5, 0x5f, 0x5a, 0x2f, 0xd8, 0xf9, 0x6, 0x71, 0xaa, 0x78, 0x8d, 0xb5, 0x7a, 0xf6, 0x99}}
	return a, nil
}

var _assetsDnsMetricsRoleYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x4c\x8e\xb1\x4e\xec\x40\x0c\x45\xfb\xf9\x0a\x6b\x5f\x9d\x7d\xa2\x5b\x4d\x8d\x44\x47\x01\x12\xbd\x77\xe6\x42\xac\x24\xe3\x91\xed\x04\xc1\xd7\xa3\xcd\x06\x89\xca\xf7\x1e\x59\x3e\xfe\x47\x2f\x3a\xc3\xa9\x01\x15\x95\xae\x5f\xd4\x4d\x17\xc4\x88\xd5\x29\x94\xbc\x18\x77\xd0\xe3\xf3\x2b\x2d\x08\x93\xe2\x84\x56\xbb\x4a\x8b\xc4\x5d\xde\x60\x2e\xda\x32\xd9\x95\xcb\x99\xd7\x18\xd5\xe4\x9b\x43\xb4\x9d\xa7\x8b\x9f\x45\xff\x6f\x0f\x69\x92\x56\xf3\x2e\x4a\x0b\x82\x2b\x07\xe7\x44\xd4\x78\x41\xfe\xe3\x1b\xa6\x8b\x1f\xd8\x3b\x17\x64\xd2\x8e\xe6\xa3\xbc\xc7\x50\x9b\x27\x5b\x67\x78\x4e\x03\x71\x97\x27\xd3\xb5\xfb\xed\xca\x40\xa7\x53\x22\x32\xb8\xae\x56\x70\x30\x87\x6d\x52\xe0\x7b\xf9\xfd\xf8\xde\xba\xd6\x5b\xd8\x60\xd7\x63\xf9\x03\xb1\xcf\x59\xfc\x1e\x3e\x39\xca\x98\x7e\x02\x00\x00\xff\xff\x29\x39\xda\x05\x1c\x01\x00\x00")

func assetsDnsMetricsRoleYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsMetricsRoleYaml,
		"assets/dns/metrics/role.yaml",
	)
}

func assetsDnsMetricsRoleYaml() (*asset, error) {
	bytes, err := assetsDnsMetricsRoleYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/metrics/role.yaml", size: 284, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x8c, 0xf2, 0x4e, 0x40, 0x91, 0xd8, 0x5e, 0x1c, 0x98, 0xb6, 0x2f, 0x11, 0x2a, 0x15, 0x8f, 0xe4, 0x7c, 0xfe, 0xc6, 0x31, 0xf3, 0xb2, 0xa0, 0x38, 0xb2, 0x3f, 0x15, 0x5a, 0x33, 0x12, 0xd2, 0x88}}
	return a, nil
}

var _assetsDnsNamespaceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x64\x90\xcd\x4e\xc4\x30\x0c\x84\xef\x79\x8a\x51\x38\x2f\x3f\xd7\xbc\x03\x5c\x90\xb8\xbb\x8d\x97\x35\x4d\xed\x2a\x76\xcb\xeb\xa3\xb2\x15\xac\xb4\xc7\x68\x46\xf3\x7d\xf1\x24\x5a\x0b\xde\x68\x66\x5f\x68\xe4\x44\x8b\x7c\x70\x77\x31\x2d\xd8\x5e\xd2\xcc\x41\x95\x82\x4a\x02\x48\xd5\x82\x42\x4c\x7d\x7f\x02\xb6\xb0\xfa\x45\xce\xf1\x28\xf6\xa4\x56\xf9\xe4\xdc\x78\x0c\xeb\x05\x39\x27\x40\x69\xe6\xf2\x5f\x3b\x55\xf5\x04\x34\x1a\xb8\x1d\x13\x0f\x70\x0e\x6c\xd4\x56\x46\x18\x68\x33\xa9\xa8\xbc\xb0\x56\xd1\x4f\x98\x62\x5a\x07\x06\xd5\x59\x7c\x97\x42\x5c\x28\x8e\x82\xef\xf1\xdf\x38\x68\x11\xbf\xd7\xea\xab\x9e\x1a\x6f\xdc\x0a\xf2\x73\x3e\x98\xd4\x9a\x7d\xdf\x78\xcd\xa6\x12\xd6\x77\x62\x18\x9a\xd9\x84\xb3\x75\xbc\x73\xdf\x64\xe4\xd7\x6b\x0a\x1b\xbe\x78\x0c\x87\xec\x16\xe2\xbf\xbf\xbb\x1e\xed\x8e\x3a\xb6\xd5\x83\xfb\xcd\x70\x41\x8e\xbe\x72\x4e\x3f\x01\x00\x00\xff\xff\x82\x6d\x29\x03\x71\x01\x00\x00")

func assetsDnsNamespaceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsNamespaceYaml,
		"assets/dns/namespace.yaml",
	)
}

func assetsDnsNamespaceYaml() (*asset, error) {
	bytes, err := assetsDnsNamespaceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/namespace.yaml", size: 369, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xe, 0xab, 0x50, 0x84, 0x61, 0x5f, 0x41, 0xf4, 0x17, 0x3b, 0x6, 0x84, 0xc0, 0x5f, 0x4f, 0xbb, 0xd8, 0x1d, 0xae, 0x26, 0x3e, 0x1f, 0x29, 0x2c, 0x84, 0x6d, 0x5e, 0xc1, 0x87, 0x97, 0x5f, 0xc9}}
	return a, nil
}

var _assetsDnsServiceAccountYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x2c\xc9\xb1\x09\xc4\x30\x0c\x05\xd0\xde\x53\x68\x81\x2b\xae\x55\x77\x33\x1c\xa4\x17\xf2\x0f\x11\xc1\xb2\xb1\x14\xcf\x1f\x02\xe9\x1e\xbc\xd3\xbc\x32\xfd\x31\x97\x29\x7e\xaa\xfd\xf2\x2c\x32\x6c\xc3\x0c\xeb\xce\xb4\xbe\xa5\x21\xa5\x4a\x0a\x17\x22\x97\x06\xa6\xea\xf1\x3a\x86\x28\x98\xfa\x80\xc7\x61\x7b\x7e\x9e\xba\x03\x00\x00\xff\xff\x8e\x2c\xf1\x2e\x55\x00\x00\x00")

func assetsDnsServiceAccountYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceAccountYaml,
		"assets/dns/service-account.yaml",
	)
}

func assetsDnsServiceAccountYaml() (*asset, error) {
	bytes, err := assetsDnsServiceAccountYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service-account.yaml", size: 85, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0x57, 0x12, 0x50, 0x4d, 0x67, 0x2f, 0x1b, 0x74, 0xa0, 0xa4, 0xbb, 0xa7, 0x59, 0xe9, 0x5a, 0xc6, 0xc1, 0x1a, 0xf8, 0x5f, 0xff, 0x5, 0xdb, 0xc, 0x10, 0x8b, 0xc1, 0x0, 0xcc, 0xf, 0x9f, 0x3a}}
	return a, nil
}

var _assetsDnsServiceYaml = []byte("\x1f\x8b\x08\x00\x00\x00\x00\x00\x00\xff\x84\xce\x3d\x4b\x04\x31\x10\xc6\xf1\x3e\x9f\xe2\x81\x6b\x3d\xe1\x10\x0b\xd3\x6a\x63\xb7\xe0\x4b\x3f\x97\x1d\x8e\xe0\xe4\x85\x99\xd9\x13\xbf\xbd\x18\xe1\xdc\x15\xc1\x26\x90\xe4\xcf\x8f\xe7\x2d\xd7\x39\xe2\x89\xf5\x9c\x13\x07\xea\xf9\x95\xd5\x72\xab\x11\xe7\x43\xd8\xa1\x52\xe1\xab\x71\x5a\xa7\xc4\xa0\x3a\x43\xe8\xc8\x62\x20\x65\x18\x3b\xc8\xa1\x4b\xf5\x5c\x38\x58\xe7\x14\x03\xb0\x43\x92\xc5\x9c\xf5\x71\xc2\x7b\x16\xc1\x91\x41\x8b\xb7\x42\x9e\x13\x89\x7c\xa0\x50\xa5\x13\xcf\xd7\x23\x36\x16\x4e\xde\x14\xd9\x7e\x8b\x40\x6f\xea\xf6\x85\xee\xc7\x8c\x88\xb9\x5a\x00\xbe\x3f\x22\x6e\x6f\xc6\xc5\x49\x4f\xec\xd3\x78\xba\x04\xda\xbc\xa5\x26\x11\x2f\x0f\xd3\x16\xd8\x7b\xea\xff\x22\x3f\xd1\x05\x7a\xbe\x5f\x43\x85\x5d\x73\x5a\xaf\xb9\x3b\xfc\x41\x6d\xb2\x0d\xf5\x19\x00\x00\xff\xff\xc5\xcb\x88\xa8\x7d\x01\x00\x00")

func assetsDnsServiceYamlBytes() ([]byte, error) {
	return bindataRead(
		_assetsDnsServiceYaml,
		"assets/dns/service.yaml",
	)
}

func assetsDnsServiceYaml() (*asset, error) {
	bytes, err := assetsDnsServiceYamlBytes()
	if err != nil {
		return nil, err
	}

	info := bindataFileInfo{name: "assets/dns/service.yaml", size: 381, mode: os.FileMode(420), modTime: time.Unix(1, 0)}
	a := &asset{bytes: bytes, info: info, digest: [32]uint8{0xa9, 0x6d, 0x77, 0x15, 0x61, 0x5f, 0x22, 0x3d, 0xd7, 0x33, 0xf2, 0xcf, 0xe0, 0xbd, 0x5d, 0xc6, 0xf1, 0x17, 0x84, 0xff, 0x81, 0xdb, 0x33, 0xd0, 0x30, 0x3b, 0xe3, 0x8e, 0x8e, 0x39, 0x8d, 0x48}}
	return a, nil
}

// Asset loads and returns the asset for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func Asset(name string) ([]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("Asset %s can't read by error: %v", name, err)
		}
		return a.bytes, nil
	}
	return nil, fmt.Errorf("Asset %s not found", name)
}

// AssetString returns the asset contents as a string (instead of a []byte).
func AssetString(name string) (string, error) {
	data, err := Asset(name)
	return string(data), err
}

// MustAsset is like Asset but panics when Asset would return an error.
// It simplifies safe initialization of global variables.
func MustAsset(name string) []byte {
	a, err := Asset(name)
	if err != nil {
		panic("asset: Asset(" + name + "): " + err.Error())
	}

	return a
}

// MustAssetString is like AssetString but panics when Asset would return an
// error. It simplifies safe initialization of global variables.
func MustAssetString(name string) string {
	return string(MustAsset(name))
}

// AssetInfo loads and returns the asset info for the given name.
// It returns an error if the asset could not be found or
// could not be loaded.
func AssetInfo(name string) (os.FileInfo, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return nil, fmt.Errorf("AssetInfo %s can't read by error: %v", name, err)
		}
		return a.info, nil
	}
	return nil, fmt.Errorf("AssetInfo %s not found", name)
}

// AssetDigest returns the digest of the file with the given name. It returns an
// error if the asset could not be found or the digest could not be loaded.
func AssetDigest(name string) ([sha256.Size]byte, error) {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	if f, ok := _bindata[canonicalName]; ok {
		a, err := f()
		if err != nil {
			return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s can't read by error: %v", name, err)
		}
		return a.digest, nil
	}
	return [sha256.Size]byte{}, fmt.Errorf("AssetDigest %s not found", name)
}

// Digests returns a map of all known files and their checksums.
func Digests() (map[string][sha256.Size]byte, error) {
	mp := make(map[string][sha256.Size]byte, len(_bindata))
	for name := range _bindata {
		a, err := _bindata[name]()
		if err != nil {
			return nil, err
		}
		mp[name] = a.digest
	}
	return mp, nil
}

// AssetNames returns the names of the assets.
func AssetNames() []string {
	names := make([]string, 0, len(_bindata))
	for name := range _bindata {
		names = append(names, name)
	}
	return names
}

// _bindata is a table, holding each asset generator, mapped to its name.
var _bindata = map[string]func() (*asset, error){
	"assets/dns/cluster-role-binding.yaml": assetsDnsClusterRoleBindingYaml,

	"assets/dns/cluster-role.yaml": assetsDnsClusterRoleYaml,

	"assets/dns/configmap.yaml": assetsDnsConfigmapYaml,

	"assets/dns/daemonset.yaml": assetsDnsDaemonsetYaml,

	"assets/dns/metrics/cluster-role-binding.yaml": assetsDnsMetricsClusterRoleBindingYaml,

	"assets/dns/metrics/cluster-role.yaml": assetsDnsMetricsClusterRoleYaml,

	"assets/dns/metrics/role-binding.yaml": assetsDnsMetricsRoleBindingYaml,

	"assets/dns/metrics/role.yaml": assetsDnsMetricsRoleYaml,

	"assets/dns/namespace.yaml": assetsDnsNamespaceYaml,

	"assets/dns/service-account.yaml": assetsDnsServiceAccountYaml,

	"assets/dns/service.yaml": assetsDnsServiceYaml,
}

// AssetDir returns the file names below a certain
// directory embedded in the file by go-bindata.
// For example if you run go-bindata on data/... and data contains the
// following hierarchy:
//     data/
//       foo.txt
//       img/
//         a.png
//         b.png
// then AssetDir("data") would return []string{"foo.txt", "img"},
// AssetDir("data/img") would return []string{"a.png", "b.png"},
// AssetDir("foo.txt") and AssetDir("notexist") would return an error, and
// AssetDir("") will return []string{"data"}.
func AssetDir(name string) ([]string, error) {
	node := _bintree
	if len(name) != 0 {
		canonicalName := strings.Replace(name, "\\", "/", -1)
		pathList := strings.Split(canonicalName, "/")
		for _, p := range pathList {
			node = node.Children[p]
			if node == nil {
				return nil, fmt.Errorf("Asset %s not found", name)
			}
		}
	}
	if node.Func != nil {
		return nil, fmt.Errorf("Asset %s not found", name)
	}
	rv := make([]string, 0, len(node.Children))
	for childName := range node.Children {
		rv = append(rv, childName)
	}
	return rv, nil
}

type bintree struct {
	Func     func() (*asset, error)
	Children map[string]*bintree
}

var _bintree = &bintree{nil, map[string]*bintree{
	"assets": {nil, map[string]*bintree{
		"dns": {nil, map[string]*bintree{
			"cluster-role-binding.yaml": {assetsDnsClusterRoleBindingYaml, map[string]*bintree{}},
			"cluster-role.yaml":         {assetsDnsClusterRoleYaml, map[string]*bintree{}},
			"configmap.yaml":            {assetsDnsConfigmapYaml, map[string]*bintree{}},
			"daemonset.yaml":            {assetsDnsDaemonsetYaml, map[string]*bintree{}},
			"metrics": {nil, map[string]*bintree{
				"cluster-role-binding.yaml": {assetsDnsMetricsClusterRoleBindingYaml, map[string]*bintree{}},
				"cluster-role.yaml":         {assetsDnsMetricsClusterRoleYaml, map[string]*bintree{}},
				"role-binding.yaml":         {assetsDnsMetricsRoleBindingYaml, map[string]*bintree{}},
				"role.yaml":                 {assetsDnsMetricsRoleYaml, map[string]*bintree{}},
			}},
			"namespace.yaml":       {assetsDnsNamespaceYaml, map[string]*bintree{}},
			"service-account.yaml": {assetsDnsServiceAccountYaml, map[string]*bintree{}},
			"service.yaml":         {assetsDnsServiceYaml, map[string]*bintree{}},
		}},
	}},
}}

// RestoreAsset restores an asset under the given directory.
func RestoreAsset(dir, name string) error {
	data, err := Asset(name)
	if err != nil {
		return err
	}
	info, err := AssetInfo(name)
	if err != nil {
		return err
	}
	err = os.MkdirAll(_filePath(dir, filepath.Dir(name)), os.FileMode(0755))
	if err != nil {
		return err
	}
	err = ioutil.WriteFile(_filePath(dir, name), data, info.Mode())
	if err != nil {
		return err
	}
	return os.Chtimes(_filePath(dir, name), info.ModTime(), info.ModTime())
}

// RestoreAssets restores an asset under the given directory recursively.
func RestoreAssets(dir, name string) error {
	children, err := AssetDir(name)
	// File
	if err != nil {
		return RestoreAsset(dir, name)
	}
	// Dir
	for _, child := range children {
		err = RestoreAssets(dir, filepath.Join(name, child))
		if err != nil {
			return err
		}
	}
	return nil
}

func _filePath(dir, name string) string {
	canonicalName := strings.Replace(name, "\\", "/", -1)
	return filepath.Join(append([]string{dir}, strings.Split(canonicalName, "/")...)...)
}
