package v1alpha1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_LogEntry = map[string]string{
	"":        "LogEntry records events",
	"time":    "Start time of check action.",
	"success": "Success indicates if the log entry indicates a success or failure.",
	"reason":  "Reason for status in a machine readable format.",
	"message": "Message explaining status in a human readable format.",
	"latency": "Latency records how long the action mentioned in the entry took.",
}

func (LogEntry) SwaggerDoc() map[string]string {
	return map_LogEntry
}

var map_OutageEntry = map[string]string{
	"":      "OutageEntry records time period of an outage",
	"start": "Start of outage detected",
	"end":   "End of outage detected",
}

func (OutageEntry) SwaggerDoc() map[string]string {
	return map_OutageEntry
}

var map_PodNetworkConnectivityCheck = map[string]string{
	"":       "PodNetworkConnectivityCheck",
	"spec":   "Spec defines the source and target of the connectivity check",
	"status": "Status contains the observed status of the connectivity check",
}

func (PodNetworkConnectivityCheck) SwaggerDoc() map[string]string {
	return map_PodNetworkConnectivityCheck
}

var map_PodNetworkConnectivityCheckCondition = map[string]string{
	"":                   "PodNetworkConnectivityCheckCondition represents the overall status of the pod network connectivity.",
	"type":               "Type of the condition",
	"status":             "Status of the condition",
	"reason":             "Reason for the condition's last status transition in a machine readable format.",
	"message":            "Message indicating details about last transition in a human readable format.",
	"lastTransitionTime": "Last time the condition transitioned from one status to another.",
}

func (PodNetworkConnectivityCheckCondition) SwaggerDoc() map[string]string {
	return map_PodNetworkConnectivityCheckCondition
}

var map_PodNetworkConnectivityCheckList = map[string]string{
	"":      "PodNetworkConnectivityCheckList is a collection of PodNetworkConnectivityCheck",
	"items": "Items contains the items",
}

func (PodNetworkConnectivityCheckList) SwaggerDoc() map[string]string {
	return map_PodNetworkConnectivityCheckList
}

var map_PodNetworkConnectivityCheckSpec = map[string]string{
	"sourcePod":      "SourcePod names the pod from which the condition will be checked",
	"targetEndpoint": "EndpointAddress to check. A TCP address of the form host:port. Note that if host is a DNS name, then the check would fail if the DNS name cannot be resolved. Specify an IP address for host to bypass DNS name lookup.",
}

func (PodNetworkConnectivityCheckSpec) SwaggerDoc() map[string]string {
	return map_PodNetworkConnectivityCheckSpec
}

var map_PodNetworkConnectivityCheckStatus = map[string]string{
	"successes":  "Successes contains logs successful check actions",
	"failures":   "Failures contains logs of unsuccessful check actions",
	"outages":    "Outages contains logs of time periods of outages",
	"conditions": "Conditions summarize the status of the check",
}

func (PodNetworkConnectivityCheckStatus) SwaggerDoc() map[string]string {
	return map_PodNetworkConnectivityCheckStatus
}

// AUTO-GENERATED FUNCTIONS END HERE
