// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/talent/v4beta1/job_service.proto

package talent

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// An enum that specifies the job attributes that are returned in the
// [MatchingJob.job][google.cloud.talent.v4beta1.SearchJobsResponse.MatchingJob.job]
// or [ListJobsResponse.jobs][google.cloud.talent.v4beta1.ListJobsResponse.jobs]
// fields.
type JobView int32

const (
	// Default value.
	JobView_JOB_VIEW_UNSPECIFIED JobView = 0
	// A ID only view of job, with following attributes:
	// [Job.name][google.cloud.talent.v4beta1.Job.name],
	// [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id],
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code].
	JobView_JOB_VIEW_ID_ONLY JobView = 1
	// A minimal view of the job, with the following attributes:
	// [Job.name][google.cloud.talent.v4beta1.Job.name],
	// [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id],
	// [Job.title][google.cloud.talent.v4beta1.Job.title],
	// [Job.company][google.cloud.talent.v4beta1.Job.company],
	// [Job.DerivedInfo.locations][google.cloud.talent.v4beta1.Job.DerivedInfo.locations],
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code].
	JobView_JOB_VIEW_MINIMAL JobView = 2
	// A small view of the job, with the following attributes in the search
	// results: [Job.name][google.cloud.talent.v4beta1.Job.name],
	// [Job.requisition_id][google.cloud.talent.v4beta1.Job.requisition_id],
	// [Job.title][google.cloud.talent.v4beta1.Job.title],
	// [Job.company][google.cloud.talent.v4beta1.Job.company],
	// [Job.DerivedInfo.locations][google.cloud.talent.v4beta1.Job.DerivedInfo.locations],
	// [Job.visibility][google.cloud.talent.v4beta1.Job.visibility],
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code],
	// [Job.description][google.cloud.talent.v4beta1.Job.description].
	JobView_JOB_VIEW_SMALL JobView = 3
	// All available attributes are included in the search results.
	JobView_JOB_VIEW_FULL JobView = 4
)

var JobView_name = map[int32]string{
	0: "JOB_VIEW_UNSPECIFIED",
	1: "JOB_VIEW_ID_ONLY",
	2: "JOB_VIEW_MINIMAL",
	3: "JOB_VIEW_SMALL",
	4: "JOB_VIEW_FULL",
}

var JobView_value = map[string]int32{
	"JOB_VIEW_UNSPECIFIED": 0,
	"JOB_VIEW_ID_ONLY":     1,
	"JOB_VIEW_MINIMAL":     2,
	"JOB_VIEW_SMALL":       3,
	"JOB_VIEW_FULL":        4,
}

func (x JobView) String() string {
	return proto.EnumName(JobView_name, int32(x))
}

func (JobView) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{0}
}

// A string-represented enumeration of the job search mode. The service
// operate differently for different modes of service.
type SearchJobsRequest_SearchMode int32

const (
	// The mode of the search method isn't specified.
	SearchJobsRequest_SEARCH_MODE_UNSPECIFIED SearchJobsRequest_SearchMode = 0
	// The job search matches against all jobs, and featured jobs
	// (jobs with promotionValue > 0) are not specially handled.
	SearchJobsRequest_JOB_SEARCH SearchJobsRequest_SearchMode = 1
	// The job search matches only against featured jobs (jobs with a
	// promotionValue > 0). This method doesn't return any jobs having a
	// promotionValue <= 0. The search results order is determined by the
	// promotionValue (jobs with a higher promotionValue are returned higher up
	// in the search results), with relevance being used as a tiebreaker.
	SearchJobsRequest_FEATURED_JOB_SEARCH SearchJobsRequest_SearchMode = 2
)

var SearchJobsRequest_SearchMode_name = map[int32]string{
	0: "SEARCH_MODE_UNSPECIFIED",
	1: "JOB_SEARCH",
	2: "FEATURED_JOB_SEARCH",
}

var SearchJobsRequest_SearchMode_value = map[string]int32{
	"SEARCH_MODE_UNSPECIFIED": 0,
	"JOB_SEARCH":              1,
	"FEATURED_JOB_SEARCH":     2,
}

func (x SearchJobsRequest_SearchMode) String() string {
	return proto.EnumName(SearchJobsRequest_SearchMode_name, int32(x))
}

func (SearchJobsRequest_SearchMode) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{7, 0}
}

// Controls whether highly similar jobs are returned next to each other in
// the search results. Jobs are identified as highly similar based on
// their titles, job categories, and locations. Highly similar results are
// clustered so that only one representative job of the cluster is
// displayed to the job seeker higher up in the results, with the other jobs
// being displayed lower down in the results.
type SearchJobsRequest_DiversificationLevel int32

const (
	// The diversification level isn't specified.
	SearchJobsRequest_DIVERSIFICATION_LEVEL_UNSPECIFIED SearchJobsRequest_DiversificationLevel = 0
	// Disables diversification. Jobs that would normally be pushed to the last
	// page would not have their positions altered. This may result in highly
	// similar jobs appearing in sequence in the search results.
	SearchJobsRequest_DISABLED SearchJobsRequest_DiversificationLevel = 1
	// Default diversifying behavior. The result list is ordered so that
	// highly similar results are pushed to the end of the last page of search
	// results.
	SearchJobsRequest_SIMPLE SearchJobsRequest_DiversificationLevel = 2
)

var SearchJobsRequest_DiversificationLevel_name = map[int32]string{
	0: "DIVERSIFICATION_LEVEL_UNSPECIFIED",
	1: "DISABLED",
	2: "SIMPLE",
}

var SearchJobsRequest_DiversificationLevel_value = map[string]int32{
	"DIVERSIFICATION_LEVEL_UNSPECIFIED": 0,
	"DISABLED":                          1,
	"SIMPLE":                            2,
}

func (x SearchJobsRequest_DiversificationLevel) String() string {
	return proto.EnumName(SearchJobsRequest_DiversificationLevel_name, int32(x))
}

func (SearchJobsRequest_DiversificationLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{7, 1}
}

// The importance level for
// [CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression].
type SearchJobsRequest_CustomRankingInfo_ImportanceLevel int32

const (
	// Default value if the importance level isn't specified.
	SearchJobsRequest_CustomRankingInfo_IMPORTANCE_LEVEL_UNSPECIFIED SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 0
	// The given ranking expression is of None importance, existing relevance
	// score (determined by API algorithm) dominates job's final ranking
	// position.
	SearchJobsRequest_CustomRankingInfo_NONE SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 1
	// The given ranking expression is of Low importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_LOW SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 2
	// The given ranking expression is of Mild importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_MILD SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 3
	// The given ranking expression is of Medium importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_MEDIUM SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 4
	// The given ranking expression is of High importance in terms of job's
	// final ranking position compared to existing relevance
	// score (determined by API algorithm).
	SearchJobsRequest_CustomRankingInfo_HIGH SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 5
	// The given ranking expression is of Extreme importance, and dominates
	// job's final ranking position with existing relevance
	// score (determined by API algorithm) ignored.
	SearchJobsRequest_CustomRankingInfo_EXTREME SearchJobsRequest_CustomRankingInfo_ImportanceLevel = 6
)

var SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name = map[int32]string{
	0: "IMPORTANCE_LEVEL_UNSPECIFIED",
	1: "NONE",
	2: "LOW",
	3: "MILD",
	4: "MEDIUM",
	5: "HIGH",
	6: "EXTREME",
}

var SearchJobsRequest_CustomRankingInfo_ImportanceLevel_value = map[string]int32{
	"IMPORTANCE_LEVEL_UNSPECIFIED": 0,
	"NONE":                         1,
	"LOW":                          2,
	"MILD":                         3,
	"MEDIUM":                       4,
	"HIGH":                         5,
	"EXTREME":                      6,
}

func (x SearchJobsRequest_CustomRankingInfo_ImportanceLevel) String() string {
	return proto.EnumName(SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name, int32(x))
}

func (SearchJobsRequest_CustomRankingInfo_ImportanceLevel) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{7, 0, 0}
}

// Input only.
//
// Create job request.
type CreateJobRequest struct {
	// Required.
	//
	// The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenant/foo".
	//
	// Tenant id is optional and a default tenant is created if unspecified, for
	// example, "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The Job to be created.
	Job                  *Job     `protobuf:"bytes,2,opt,name=job,proto3" json:"job,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateJobRequest) Reset()         { *m = CreateJobRequest{} }
func (m *CreateJobRequest) String() string { return proto.CompactTextString(m) }
func (*CreateJobRequest) ProtoMessage()    {}
func (*CreateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{0}
}

func (m *CreateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateJobRequest.Unmarshal(m, b)
}
func (m *CreateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateJobRequest.Marshal(b, m, deterministic)
}
func (m *CreateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateJobRequest.Merge(m, src)
}
func (m *CreateJobRequest) XXX_Size() int {
	return xxx_messageInfo_CreateJobRequest.Size(m)
}
func (m *CreateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateJobRequest proto.InternalMessageInfo

func (m *CreateJobRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

// Input only.
//
// Get job request.
type GetJobRequest struct {
	// Required.
	//
	// The resource name of the job to retrieve.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}", for
	// example, "projects/api-test-project/tenants/foo/jobs/1234".
	//
	// Tenant id is optional and the default tenant is used if unspecified, for
	// example, "projects/api-test-project/jobs/1234".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetJobRequest) Reset()         { *m = GetJobRequest{} }
func (m *GetJobRequest) String() string { return proto.CompactTextString(m) }
func (*GetJobRequest) ProtoMessage()    {}
func (*GetJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{1}
}

func (m *GetJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetJobRequest.Unmarshal(m, b)
}
func (m *GetJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetJobRequest.Marshal(b, m, deterministic)
}
func (m *GetJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetJobRequest.Merge(m, src)
}
func (m *GetJobRequest) XXX_Size() int {
	return xxx_messageInfo_GetJobRequest.Size(m)
}
func (m *GetJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetJobRequest proto.InternalMessageInfo

func (m *GetJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Input only.
//
// Update job request.
type UpdateJobRequest struct {
	// Required.
	//
	// The Job to be updated.
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// Optional but strongly recommended to be provided for the best service
	// experience.
	//
	// If [update_mask][google.cloud.talent.v4beta1.UpdateJobRequest.update_mask]
	// is provided, only the specified fields in
	// [job][google.cloud.talent.v4beta1.UpdateJobRequest.job] are updated.
	// Otherwise all the fields are updated.
	//
	// A field mask to restrict the fields that are updated. Only
	// top level fields of [Job][google.cloud.talent.v4beta1.Job] are supported.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *UpdateJobRequest) Reset()         { *m = UpdateJobRequest{} }
func (m *UpdateJobRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateJobRequest) ProtoMessage()    {}
func (*UpdateJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{2}
}

func (m *UpdateJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateJobRequest.Unmarshal(m, b)
}
func (m *UpdateJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateJobRequest.Marshal(b, m, deterministic)
}
func (m *UpdateJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateJobRequest.Merge(m, src)
}
func (m *UpdateJobRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateJobRequest.Size(m)
}
func (m *UpdateJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateJobRequest proto.InternalMessageInfo

func (m *UpdateJobRequest) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (m *UpdateJobRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

// Input only.
//
// Delete job request.
type DeleteJobRequest struct {
	// Required.
	//
	// The resource name of the job to be deleted.
	//
	// The format is
	// "projects/{project_id}/tenants/{tenant_id}/jobs/{job_id}", for
	// example, "projects/api-test-project/tenants/foo/jobs/1234".
	//
	// Tenant id is optional and the default tenant is used if unspecified, for
	// example, "projects/api-test-project/jobs/1234".
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteJobRequest) Reset()         { *m = DeleteJobRequest{} }
func (m *DeleteJobRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteJobRequest) ProtoMessage()    {}
func (*DeleteJobRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{3}
}

func (m *DeleteJobRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteJobRequest.Unmarshal(m, b)
}
func (m *DeleteJobRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteJobRequest.Marshal(b, m, deterministic)
}
func (m *DeleteJobRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteJobRequest.Merge(m, src)
}
func (m *DeleteJobRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteJobRequest.Size(m)
}
func (m *DeleteJobRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteJobRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteJobRequest proto.InternalMessageInfo

func (m *DeleteJobRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Input only.
//
// Batch delete jobs request.
type BatchDeleteJobsRequest struct {
	// Required.
	//
	// The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenant/foo".
	//
	// Tenant id is optional and the default tenant is used if unspecified, for
	// example, "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The filter string specifies the jobs to be deleted.
	//
	// Supported operator: =, AND
	//
	// The fields eligible for filtering are:
	//
	// * `companyName` (Required)
	// * `requisitionId` (Required)
	//
	// Sample Query: companyName = "projects/api-test-project/companies/123" AND
	// requisitionId = "req-1"
	Filter               string   `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchDeleteJobsRequest) Reset()         { *m = BatchDeleteJobsRequest{} }
func (m *BatchDeleteJobsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchDeleteJobsRequest) ProtoMessage()    {}
func (*BatchDeleteJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{4}
}

func (m *BatchDeleteJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchDeleteJobsRequest.Unmarshal(m, b)
}
func (m *BatchDeleteJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchDeleteJobsRequest.Marshal(b, m, deterministic)
}
func (m *BatchDeleteJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchDeleteJobsRequest.Merge(m, src)
}
func (m *BatchDeleteJobsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchDeleteJobsRequest.Size(m)
}
func (m *BatchDeleteJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchDeleteJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchDeleteJobsRequest proto.InternalMessageInfo

func (m *BatchDeleteJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchDeleteJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

// Input only.
//
// List jobs request.
type ListJobsRequest struct {
	// Required.
	//
	// The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenant/foo".
	//
	// Tenant id is optional and the default tenant is used if unspecified, for
	// example, "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The filter string specifies the jobs to be enumerated.
	//
	// Supported operator: =, AND
	//
	// The fields eligible for filtering are:
	//
	// * `companyName` (Required)
	// * `requisitionId` (Optional)
	// * `status` (Optional) Available values: OPEN, EXPIRED, ALL. Defaults to
	// OPEN if no value is specified.
	//
	// Sample Query:
	//
	// * companyName = "projects/api-test-project/tenants/foo/companies/bar"
	// * companyName = "projects/api-test-project/tenants/foo/companies/bar" AND
	// requisitionId = "req-1"
	// * companyName = "projects/api-test-project/tenants/foo/companies/bar" AND
	// status = "EXPIRED"
	Filter string `protobuf:"bytes,2,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional.
	//
	// The starting point of a query result.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional.
	//
	// The maximum number of jobs to be returned per page of results.
	//
	// If [job_view][google.cloud.talent.v4beta1.ListJobsRequest.job_view] is set
	// to
	// [JobView.JOB_VIEW_ID_ONLY][google.cloud.talent.v4beta1.JobView.JOB_VIEW_ID_ONLY],
	// the maximum allowed page size is 1000. Otherwise, the maximum allowed page
	// size is 100.
	//
	// Default is 100 if empty or a number < 1 is specified.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional.
	//
	// The desired job attributes returned for jobs in the
	// search response. Defaults to
	// [JobView.JOB_VIEW_FULL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_FULL]
	// if no value is specified.
	JobView              JobView  `protobuf:"varint,5,opt,name=job_view,json=jobView,proto3,enum=google.cloud.talent.v4beta1.JobView" json:"job_view,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListJobsRequest) Reset()         { *m = ListJobsRequest{} }
func (m *ListJobsRequest) String() string { return proto.CompactTextString(m) }
func (*ListJobsRequest) ProtoMessage()    {}
func (*ListJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{5}
}

func (m *ListJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsRequest.Unmarshal(m, b)
}
func (m *ListJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsRequest.Marshal(b, m, deterministic)
}
func (m *ListJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsRequest.Merge(m, src)
}
func (m *ListJobsRequest) XXX_Size() int {
	return xxx_messageInfo_ListJobsRequest.Size(m)
}
func (m *ListJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsRequest proto.InternalMessageInfo

func (m *ListJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListJobsRequest) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *ListJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListJobsRequest) GetJobView() JobView {
	if m != nil {
		return m.JobView
	}
	return JobView_JOB_VIEW_UNSPECIFIED
}

// Output only.
//
// List jobs response.
type ListJobsResponse struct {
	// The Jobs for a given company.
	//
	// The maximum number of items returned is based on the limit field
	// provided in the request.
	Jobs []*Job `protobuf:"bytes,1,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// A token to retrieve the next page of results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata             *ResponseMetadata `protobuf:"bytes,3,opt,name=metadata,proto3" json:"metadata,omitempty"`
	XXX_NoUnkeyedLiteral struct{}          `json:"-"`
	XXX_unrecognized     []byte            `json:"-"`
	XXX_sizecache        int32             `json:"-"`
}

func (m *ListJobsResponse) Reset()         { *m = ListJobsResponse{} }
func (m *ListJobsResponse) String() string { return proto.CompactTextString(m) }
func (*ListJobsResponse) ProtoMessage()    {}
func (*ListJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{6}
}

func (m *ListJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListJobsResponse.Unmarshal(m, b)
}
func (m *ListJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListJobsResponse.Marshal(b, m, deterministic)
}
func (m *ListJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListJobsResponse.Merge(m, src)
}
func (m *ListJobsResponse) XXX_Size() int {
	return xxx_messageInfo_ListJobsResponse.Size(m)
}
func (m *ListJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListJobsResponse proto.InternalMessageInfo

func (m *ListJobsResponse) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *ListJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *ListJobsResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// Input only.
//
// The Request body of the `SearchJobs` call.
type SearchJobsRequest struct {
	// Required.
	//
	// The resource name of the tenant to search within.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenant/foo".
	//
	// Tenant id is optional and the default tenant is used if unspecified, for
	// example, "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional.
	//
	// Mode of a search.
	//
	// Defaults to
	// [SearchMode.JOB_SEARCH][google.cloud.talent.v4beta1.SearchJobsRequest.SearchMode.JOB_SEARCH].
	SearchMode SearchJobsRequest_SearchMode `protobuf:"varint,2,opt,name=search_mode,json=searchMode,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_SearchMode" json:"search_mode,omitempty"`
	// Required.
	//
	// The meta information collected about the job searcher, used to improve the
	// search quality of the service.. The identifiers, (such as `user_id`) are
	// provided by users, and must be unique and consistent.
	RequestMetadata *RequestMetadata `protobuf:"bytes,3,opt,name=request_metadata,json=requestMetadata,proto3" json:"request_metadata,omitempty"`
	// Optional.
	//
	// Query used to search against jobs, such as keyword, location filters, etc.
	JobQuery *JobQuery `protobuf:"bytes,4,opt,name=job_query,json=jobQuery,proto3" json:"job_query,omitempty"`
	// Optional.
	//
	// Controls whether to broaden the search when it produces sparse results.
	// Broadened queries append results to the end of the matching results
	// list.
	//
	// Defaults to false.
	EnableBroadening bool `protobuf:"varint,5,opt,name=enable_broadening,json=enableBroadening,proto3" json:"enable_broadening,omitempty"`
	// Optional.
	//
	// Controls if the search job request requires the return of a precise
	// count of the first 300 results. Setting this to `true` ensures
	// consistency in the number of results per page. Best practice is to set this
	// value to true if a client allows users to jump directly to a
	// non-sequential search results page.
	//
	// Enabling this flag may adversely impact performance.
	//
	// Defaults to false.
	RequirePreciseResultSize bool `protobuf:"varint,6,opt,name=require_precise_result_size,json=requirePreciseResultSize,proto3" json:"require_precise_result_size,omitempty"`
	// Optional.
	//
	// An expression specifies a histogram request against matching jobs.
	//
	// Expression syntax is an aggregation function call with histogram facets and
	// other options.
	//
	// Available aggregation function calls are:
	// * `count(string_histogram_facet)`: Count the number of matching entities,
	// for each distinct attribute value.
	// * `count(numeric_histogram_facet, list of buckets)`: Count the number of
	// matching entities within each bucket.
	//
	// Data types:
	//
	// * Histogram facet: facet names with format [a-zA-Z][a-zA-Z0-9_]+.
	// * String: string like "any string with backslash escape for quote(\")."
	// * Number: whole number and floating point number like 10, -1 and -0.01.
	// * List: list of elements with comma(,) separator surrounded by square
	// brackets, for example, [1, 2, 3] and ["one", "two", "three"].
	//
	// Built-in constants:
	//
	// * MIN (minimum number similar to java Double.MIN_VALUE)
	// * MAX (maximum number similar to java Double.MAX_VALUE)
	//
	// Built-in functions:
	//
	// * bucket(start, end[, label]): bucket built-in function creates a bucket
	// with range of [start, end). Note that the end is exclusive, for example,
	// bucket(1, MAX, "positive number") or bucket(1, 10).
	//
	// Job histogram facets:
	//
	// * company_display_name: histogram by
	// [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name].
	// * employment_type: histogram by
	// [Job.employment_types][google.cloud.talent.v4beta1.Job.employment_types],
	// for example,
	//   "FULL_TIME", "PART_TIME".
	// * company_size: histogram by
	// [CompanySize][google.cloud.talent.v4beta1.CompanySize], for example,
	// "SMALL", "MEDIUM", "BIG".
	// * publish_time_in_month: histogram by the
	// [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
	//   in months.
	//   Must specify list of numeric buckets in spec.
	// * publish_time_in_year: histogram by the
	// [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
	//   in years.
	//   Must specify list of numeric buckets in spec.
	// * degree_types: histogram by the
	// [Job.degree_types][google.cloud.talent.v4beta1.Job.degree_types], for
	// example,
	//   "Bachelors", "Masters".
	// * job_level: histogram by the
	// [Job.job_level][google.cloud.talent.v4beta1.Job.job_level], for example,
	// "Entry
	//   Level".
	// * country: histogram by the country code of jobs, for example, "US", "FR".
	// * admin1: histogram by the admin1 code of jobs, which is a global
	//   placeholder referring to the state, province, or the particular term a
	//   country uses to define the geographic structure below the country level,
	//   for example, "CA", "IL".
	// * city: histogram by a combination of the "city name, admin1 code". For
	//   example,  "Mountain View, CA", "New York, NY".
	// * admin1_country: histogram by a combination of the "admin1 code, country",
	//   for example, "CA, US", "IL, US".
	// * city_coordinate: histogram by the city center's GPS coordinates (latitude
	//   and longitude), for example, 37.4038522,-122.0987765. Since the
	//   coordinates of a city center can change, customers may need to refresh
	//   them periodically.
	// * locale: histogram by the
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code], for
	// example, "en-US",
	//   "fr-FR".
	// * language: histogram by the language subtag of the
	// [Job.language_code][google.cloud.talent.v4beta1.Job.language_code],
	//   for example, "en", "fr".
	// * category: histogram by the
	// [JobCategory][google.cloud.talent.v4beta1.JobCategory], for example,
	//   "COMPUTER_AND_IT", "HEALTHCARE".
	// * base_compensation_unit: histogram by the
	//   [CompensationInfo.CompensationUnit][google.cloud.talent.v4beta1.CompensationInfo.CompensationUnit]
	//   of base salary, for example, "WEEKLY", "MONTHLY".
	// * base_compensation: histogram by the base salary. Must specify list of
	//   numeric buckets to group results by.
	// * annualized_base_compensation: histogram by the base annualized salary.
	//   Must specify list of numeric buckets to group results by.
	// * annualized_total_compensation: histogram by the total annualized salary.
	//   Must specify list of numeric buckets to group results by.
	// * string_custom_attribute: histogram by string
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
	//   Values can be accessed via square bracket notations like
	//   string_custom_attribute["key1"].
	// * numeric_custom_attribute: histogram by numeric
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes].
	//   Values can be accessed via square bracket notations like
	//   numeric_custom_attribute["key1"]. Must specify list of numeric buckets to
	//   group results by.
	//
	// Example expressions:
	//
	// * `count(admin1)`
	// * `count(base_compensation, [bucket(1000, 10000), bucket(10000, 100000),
	// bucket(100000, MAX)])`
	// * `count(string_custom_attribute["some-string-custom-attribute"])`
	// * `count(numeric_custom_attribute["some-numeric-custom-attribute"],
	//   [bucket(MIN, 0, "negative"), bucket(0, MAX, "non-negative"])`
	HistogramQueries []*HistogramQuery `protobuf:"bytes,7,rep,name=histogram_queries,json=histogramQueries,proto3" json:"histogram_queries,omitempty"`
	// Optional.
	//
	// The desired job attributes returned for jobs in the search response.
	// Defaults to
	// [JobView.JOB_VIEW_SMALL][google.cloud.talent.v4beta1.JobView.JOB_VIEW_SMALL]
	// if no value is specified.
	JobView JobView `protobuf:"varint,8,opt,name=job_view,json=jobView,proto3,enum=google.cloud.talent.v4beta1.JobView" json:"job_view,omitempty"`
	// Optional.
	//
	// An integer that specifies the current offset (that is, starting result
	// location, amongst the jobs deemed by the API as relevant) in search
	// results. This field is only considered if
	// [page_token][google.cloud.talent.v4beta1.SearchJobsRequest.page_token] is
	// unset.
	//
	// For example, 0 means to  return results starting from the first matching
	// job, and 10 means to return from the 11th job. This can be used for
	// pagination, (for example, pageSize = 10 and offset = 10 means to return
	// from the second page).
	Offset int32 `protobuf:"varint,9,opt,name=offset,proto3" json:"offset,omitempty"`
	// Optional.
	//
	// A limit on the number of jobs returned in the search results.
	// Increasing this value above the default value of 10 can increase search
	// response time. The value can be between 1 and 100.
	PageSize int32 `protobuf:"varint,10,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional.
	//
	// The token specifying the current offset within
	// search results. See
	// [SearchJobsResponse.next_page_token][google.cloud.talent.v4beta1.SearchJobsResponse.next_page_token]
	// for an explanation of how to obtain the next set of query results.
	PageToken string `protobuf:"bytes,11,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional.
	//
	// The criteria determining how search results are sorted. Default is
	// "relevance desc".
	//
	// Supported options are:
	//
	// * "relevance desc": By relevance descending, as determined by the API
	//   algorithms. Relevance thresholding of query results is only available
	//   with this ordering.
	// * "posting`_`publish`_`time desc": By
	// [Job.posting_publish_time][google.cloud.talent.v4beta1.Job.posting_publish_time]
	//   descending.
	// * "posting`_`update`_`time desc": By
	// [Job.posting_update_time][google.cloud.talent.v4beta1.Job.posting_update_time]
	//   descending.
	// * "title": By [Job.title][google.cloud.talent.v4beta1.Job.title] ascending.
	// * "title desc": By [Job.title][google.cloud.talent.v4beta1.Job.title]
	// descending.
	// * "annualized`_`base`_`compensation": By job's
	//   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range]
	//   ascending. Jobs whose annualized base compensation is unspecified are put
	//   at the end of search results.
	// * "annualized`_`base`_`compensation desc": By job's
	//   [CompensationInfo.annualized_base_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_base_compensation_range]
	//   descending. Jobs whose annualized base compensation is unspecified are
	//   put at the end of search results.
	// * "annualized`_`total`_`compensation": By job's
	//   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range]
	//   ascending. Jobs whose annualized base compensation is unspecified are put
	//   at the end of search results.
	// * "annualized`_`total`_`compensation desc": By job's
	//   [CompensationInfo.annualized_total_compensation_range][google.cloud.talent.v4beta1.CompensationInfo.annualized_total_compensation_range]
	//   descending. Jobs whose annualized base compensation is unspecified are
	//   put at the end of search results.
	// * "custom`_`ranking desc": By the relevance score adjusted to the
	//   [SearchJobsRequest.CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression]
	//   with weight factor assigned by
	//   [SearchJobsRequest.CustomRankingInfo.importance_level][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.importance_level]
	//   in descending order.
	// * "location`_`distance": By the distance between the location on jobs and
	//   locations specified in the
	//   [JobQuery.location_filters][google.cloud.talent.v4beta1.JobQuery.location_filters].
	//   When this order is selected, the
	//   [JobQuery.location_filters][google.cloud.talent.v4beta1.JobQuery.location_filters]
	//   must not be empty. When a job has multiple locations, the location
	//   closest to one of the locations specified in the location filter will be
	//   used to calculate location distance. Distance is calculated by the
	//   distance between two lat/long coordinates, with a precision of 10e-4
	//   degrees (11.3 meters). Jobs that don't have locations specified will be
	//   ranked below jobs having locations. Diversification strategy is still
	//   applied unless explicitly disabled in
	//   [SearchJobsRequest.diversification_level][google.cloud.talent.v4beta1.SearchJobsRequest.diversification_level].
	OrderBy string `protobuf:"bytes,12,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
	// Optional.
	//
	// Controls whether highly similar jobs are returned next to each other in
	// the search results. Jobs are identified as highly similar based on
	// their titles, job categories, and locations. Highly similar results are
	// clustered so that only one representative job of the cluster is
	// displayed to the job seeker higher up in the results, with the other jobs
	// being displayed lower down in the results.
	//
	// Defaults to
	// [DiversificationLevel.SIMPLE][google.cloud.talent.v4beta1.SearchJobsRequest.DiversificationLevel.SIMPLE]
	// if no value is specified.
	DiversificationLevel SearchJobsRequest_DiversificationLevel `protobuf:"varint,13,opt,name=diversification_level,json=diversificationLevel,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_DiversificationLevel" json:"diversification_level,omitempty"`
	// Optional.
	//
	// Controls over how job documents get ranked on top of existing relevance
	// score (determined by API algorithm).
	CustomRankingInfo *SearchJobsRequest_CustomRankingInfo `protobuf:"bytes,14,opt,name=custom_ranking_info,json=customRankingInfo,proto3" json:"custom_ranking_info,omitempty"`
	// Optional.
	//
	// Controls whether to disable exact keyword match on
	// [Job.title][google.cloud.talent.v4beta1.Job.title],
	// [Job.description][google.cloud.talent.v4beta1.Job.description],
	// [Job.company_display_name][google.cloud.talent.v4beta1.Job.company_display_name],
	// [Job.addresses][google.cloud.talent.v4beta1.Job.addresses],
	// [Job.qualifications][google.cloud.talent.v4beta1.Job.qualifications]. When
	// disable keyword match is turned off, a keyword match returns jobs that do
	// not match given category filters when there are matching keywords. For
	// example, for the query "program manager," a result is returned even if the
	// job posting has the title "software developer," which doesn't fall into
	// "program manager" ontology, but does have "program manager" appearing in
	// its description.
	//
	// For queries like "cloud" that don't contain title or
	// location specific ontology, jobs with "cloud" keyword matches are returned
	// regardless of this flag's value.
	//
	// Use
	// [Company.keyword_searchable_job_custom_attributes][google.cloud.talent.v4beta1.Company.keyword_searchable_job_custom_attributes]
	// if company-specific globally matched custom field/attribute string values
	// are needed. Enabling keyword match improves recall of subsequent search
	// requests.
	//
	// Defaults to false.
	DisableKeywordMatch  bool     `protobuf:"varint,16,opt,name=disable_keyword_match,json=disableKeywordMatch,proto3" json:"disable_keyword_match,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchJobsRequest) Reset()         { *m = SearchJobsRequest{} }
func (m *SearchJobsRequest) String() string { return proto.CompactTextString(m) }
func (*SearchJobsRequest) ProtoMessage()    {}
func (*SearchJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{7}
}

func (m *SearchJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsRequest.Unmarshal(m, b)
}
func (m *SearchJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsRequest.Marshal(b, m, deterministic)
}
func (m *SearchJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsRequest.Merge(m, src)
}
func (m *SearchJobsRequest) XXX_Size() int {
	return xxx_messageInfo_SearchJobsRequest.Size(m)
}
func (m *SearchJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsRequest proto.InternalMessageInfo

func (m *SearchJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *SearchJobsRequest) GetSearchMode() SearchJobsRequest_SearchMode {
	if m != nil {
		return m.SearchMode
	}
	return SearchJobsRequest_SEARCH_MODE_UNSPECIFIED
}

func (m *SearchJobsRequest) GetRequestMetadata() *RequestMetadata {
	if m != nil {
		return m.RequestMetadata
	}
	return nil
}

func (m *SearchJobsRequest) GetJobQuery() *JobQuery {
	if m != nil {
		return m.JobQuery
	}
	return nil
}

func (m *SearchJobsRequest) GetEnableBroadening() bool {
	if m != nil {
		return m.EnableBroadening
	}
	return false
}

func (m *SearchJobsRequest) GetRequirePreciseResultSize() bool {
	if m != nil {
		return m.RequirePreciseResultSize
	}
	return false
}

func (m *SearchJobsRequest) GetHistogramQueries() []*HistogramQuery {
	if m != nil {
		return m.HistogramQueries
	}
	return nil
}

func (m *SearchJobsRequest) GetJobView() JobView {
	if m != nil {
		return m.JobView
	}
	return JobView_JOB_VIEW_UNSPECIFIED
}

func (m *SearchJobsRequest) GetOffset() int32 {
	if m != nil {
		return m.Offset
	}
	return 0
}

func (m *SearchJobsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *SearchJobsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *SearchJobsRequest) GetOrderBy() string {
	if m != nil {
		return m.OrderBy
	}
	return ""
}

func (m *SearchJobsRequest) GetDiversificationLevel() SearchJobsRequest_DiversificationLevel {
	if m != nil {
		return m.DiversificationLevel
	}
	return SearchJobsRequest_DIVERSIFICATION_LEVEL_UNSPECIFIED
}

func (m *SearchJobsRequest) GetCustomRankingInfo() *SearchJobsRequest_CustomRankingInfo {
	if m != nil {
		return m.CustomRankingInfo
	}
	return nil
}

func (m *SearchJobsRequest) GetDisableKeywordMatch() bool {
	if m != nil {
		return m.DisableKeywordMatch
	}
	return false
}

// Input only.
//
// Custom ranking information for
// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
type SearchJobsRequest_CustomRankingInfo struct {
	// Required.
	//
	// Controls over how important the score of
	// [CustomRankingInfo.ranking_expression][google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo.ranking_expression]
	// gets applied to job's final ranking position.
	//
	// An error is thrown if not specified.
	ImportanceLevel SearchJobsRequest_CustomRankingInfo_ImportanceLevel `protobuf:"varint,1,opt,name=importance_level,json=importanceLevel,proto3,enum=google.cloud.talent.v4beta1.SearchJobsRequest_CustomRankingInfo_ImportanceLevel" json:"importance_level,omitempty"`
	// Required.
	//
	// Controls over how job documents get ranked on top of existing relevance
	// score (determined by API algorithm). The product of ranking expression
	// and relevance score is used to determine job's final ranking position.
	//
	// The syntax for this expression is a subset of Google SQL syntax.
	//
	// Supported operators are: +, -, *, /, where the left and right side of
	// the operator is either a numeric
	// [Job.custom_attributes][google.cloud.talent.v4beta1.Job.custom_attributes]
	// key, integer/double value or an expression that can be evaluated to a
	// number.
	//
	// Parenthesis are supported to adjust calculation precedence. The
	// expression must be < 100 characters in length.
	//
	// Sample ranking expression
	// (year + 25) * 0.25 - (freshness / 0.5)
	RankingExpression    string   `protobuf:"bytes,2,opt,name=ranking_expression,json=rankingExpression,proto3" json:"ranking_expression,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *SearchJobsRequest_CustomRankingInfo) Reset()         { *m = SearchJobsRequest_CustomRankingInfo{} }
func (m *SearchJobsRequest_CustomRankingInfo) String() string { return proto.CompactTextString(m) }
func (*SearchJobsRequest_CustomRankingInfo) ProtoMessage()    {}
func (*SearchJobsRequest_CustomRankingInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{7, 0}
}

func (m *SearchJobsRequest_CustomRankingInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.Unmarshal(m, b)
}
func (m *SearchJobsRequest_CustomRankingInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.Marshal(b, m, deterministic)
}
func (m *SearchJobsRequest_CustomRankingInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.Merge(m, src)
}
func (m *SearchJobsRequest_CustomRankingInfo) XXX_Size() int {
	return xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.Size(m)
}
func (m *SearchJobsRequest_CustomRankingInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsRequest_CustomRankingInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsRequest_CustomRankingInfo proto.InternalMessageInfo

func (m *SearchJobsRequest_CustomRankingInfo) GetImportanceLevel() SearchJobsRequest_CustomRankingInfo_ImportanceLevel {
	if m != nil {
		return m.ImportanceLevel
	}
	return SearchJobsRequest_CustomRankingInfo_IMPORTANCE_LEVEL_UNSPECIFIED
}

func (m *SearchJobsRequest_CustomRankingInfo) GetRankingExpression() string {
	if m != nil {
		return m.RankingExpression
	}
	return ""
}

// Output only.
//
// Response for SearchJob method.
type SearchJobsResponse struct {
	// The Job entities that match the specified
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	MatchingJobs []*SearchJobsResponse_MatchingJob `protobuf:"bytes,1,rep,name=matching_jobs,json=matchingJobs,proto3" json:"matching_jobs,omitempty"`
	// The histogram results that match with specified
	// [SearchJobsRequest.histogram_queries][google.cloud.talent.v4beta1.SearchJobsRequest.histogram_queries].
	HistogramQueryResults []*HistogramQueryResult `protobuf:"bytes,2,rep,name=histogram_query_results,json=histogramQueryResults,proto3" json:"histogram_query_results,omitempty"`
	// The token that specifies the starting position of the next page of results.
	// This field is empty if there are no more results.
	NextPageToken string `protobuf:"bytes,3,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// The location filters that the service applied to the specified query. If
	// any filters are lat-lng based, the
	// [Location.location_type][google.cloud.talent.v4beta1.Location.location_type]
	// is
	// [Location.LocationType.LOCATION_TYPE_UNSPECIFIED][google.cloud.talent.v4beta1.Location.LocationType.LOCATION_TYPE_UNSPECIFIED].
	LocationFilters []*Location `protobuf:"bytes,4,rep,name=location_filters,json=locationFilters,proto3" json:"location_filters,omitempty"`
	// An estimation of the number of jobs that match the specified query.
	//
	// This number isn't guaranteed to be accurate. For accurate results,
	// see
	// [SearchJobsRequest.require_precise_result_size][google.cloud.talent.v4beta1.SearchJobsRequest.require_precise_result_size].
	EstimatedTotalSize int32 `protobuf:"varint,5,opt,name=estimated_total_size,json=estimatedTotalSize,proto3" json:"estimated_total_size,omitempty"`
	// The precise result count, which is available only if the client set
	// [SearchJobsRequest.require_precise_result_size][google.cloud.talent.v4beta1.SearchJobsRequest.require_precise_result_size]
	// to `true`, or if the response is the last page of results. Otherwise, the
	// value is `-1`.
	TotalSize int32 `protobuf:"varint,6,opt,name=total_size,json=totalSize,proto3" json:"total_size,omitempty"`
	// Additional information for the API invocation, such as the request
	// tracking id.
	Metadata *ResponseMetadata `protobuf:"bytes,7,opt,name=metadata,proto3" json:"metadata,omitempty"`
	// If query broadening is enabled, we may append additional results from the
	// broadened query. This number indicates how many of the jobs returned in the
	// jobs field are from the broadened query. These results are always at the
	// end of the jobs list. In particular, a value of 0, or if the field isn't
	// set, all the jobs in the jobs list are from the original
	// (without broadening) query. If this field is non-zero, subsequent requests
	// with offset after this result set should contain all broadened results.
	BroadenedQueryJobsCount int32 `protobuf:"varint,8,opt,name=broadened_query_jobs_count,json=broadenedQueryJobsCount,proto3" json:"broadened_query_jobs_count,omitempty"`
	// The spell checking result, and correction.
	SpellCorrection      *SpellingCorrection `protobuf:"bytes,9,opt,name=spell_correction,json=spellCorrection,proto3" json:"spell_correction,omitempty"`
	XXX_NoUnkeyedLiteral struct{}            `json:"-"`
	XXX_unrecognized     []byte              `json:"-"`
	XXX_sizecache        int32               `json:"-"`
}

func (m *SearchJobsResponse) Reset()         { *m = SearchJobsResponse{} }
func (m *SearchJobsResponse) String() string { return proto.CompactTextString(m) }
func (*SearchJobsResponse) ProtoMessage()    {}
func (*SearchJobsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{8}
}

func (m *SearchJobsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsResponse.Unmarshal(m, b)
}
func (m *SearchJobsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsResponse.Marshal(b, m, deterministic)
}
func (m *SearchJobsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsResponse.Merge(m, src)
}
func (m *SearchJobsResponse) XXX_Size() int {
	return xxx_messageInfo_SearchJobsResponse.Size(m)
}
func (m *SearchJobsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsResponse proto.InternalMessageInfo

func (m *SearchJobsResponse) GetMatchingJobs() []*SearchJobsResponse_MatchingJob {
	if m != nil {
		return m.MatchingJobs
	}
	return nil
}

func (m *SearchJobsResponse) GetHistogramQueryResults() []*HistogramQueryResult {
	if m != nil {
		return m.HistogramQueryResults
	}
	return nil
}

func (m *SearchJobsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

func (m *SearchJobsResponse) GetLocationFilters() []*Location {
	if m != nil {
		return m.LocationFilters
	}
	return nil
}

func (m *SearchJobsResponse) GetEstimatedTotalSize() int32 {
	if m != nil {
		return m.EstimatedTotalSize
	}
	return 0
}

func (m *SearchJobsResponse) GetTotalSize() int32 {
	if m != nil {
		return m.TotalSize
	}
	return 0
}

func (m *SearchJobsResponse) GetMetadata() *ResponseMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (m *SearchJobsResponse) GetBroadenedQueryJobsCount() int32 {
	if m != nil {
		return m.BroadenedQueryJobsCount
	}
	return 0
}

func (m *SearchJobsResponse) GetSpellCorrection() *SpellingCorrection {
	if m != nil {
		return m.SpellCorrection
	}
	return nil
}

// Output only.
//
// Job entry with metadata inside
// [SearchJobsResponse][google.cloud.talent.v4beta1.SearchJobsResponse].
type SearchJobsResponse_MatchingJob struct {
	// Job resource that matches the specified
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	Job *Job `protobuf:"bytes,1,opt,name=job,proto3" json:"job,omitempty"`
	// A summary of the job with core information that's displayed on the search
	// results listing page.
	JobSummary string `protobuf:"bytes,2,opt,name=job_summary,json=jobSummary,proto3" json:"job_summary,omitempty"`
	// Contains snippets of text from the
	// [Job.title][google.cloud.talent.v4beta1.Job.title] field most closely
	// matching a search query's keywords, if available. The matching query
	// keywords are enclosed in HTML bold tags.
	JobTitleSnippet string `protobuf:"bytes,3,opt,name=job_title_snippet,json=jobTitleSnippet,proto3" json:"job_title_snippet,omitempty"`
	// Contains snippets of text from the
	// [Job.description][google.cloud.talent.v4beta1.Job.description] and
	// similar fields that most closely match a search query's keywords, if
	// available. All HTML tags in the original fields are stripped when
	// returned in this field, and matching query keywords are enclosed in HTML
	// bold tags.
	SearchTextSnippet string `protobuf:"bytes,4,opt,name=search_text_snippet,json=searchTextSnippet,proto3" json:"search_text_snippet,omitempty"`
	// Commute information which is generated based on specified
	//  [CommuteFilter][google.cloud.talent.v4beta1.CommuteFilter].
	CommuteInfo          *SearchJobsResponse_CommuteInfo `protobuf:"bytes,5,opt,name=commute_info,json=commuteInfo,proto3" json:"commute_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                        `json:"-"`
	XXX_unrecognized     []byte                          `json:"-"`
	XXX_sizecache        int32                           `json:"-"`
}

func (m *SearchJobsResponse_MatchingJob) Reset()         { *m = SearchJobsResponse_MatchingJob{} }
func (m *SearchJobsResponse_MatchingJob) String() string { return proto.CompactTextString(m) }
func (*SearchJobsResponse_MatchingJob) ProtoMessage()    {}
func (*SearchJobsResponse_MatchingJob) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{8, 0}
}

func (m *SearchJobsResponse_MatchingJob) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsResponse_MatchingJob.Unmarshal(m, b)
}
func (m *SearchJobsResponse_MatchingJob) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsResponse_MatchingJob.Marshal(b, m, deterministic)
}
func (m *SearchJobsResponse_MatchingJob) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsResponse_MatchingJob.Merge(m, src)
}
func (m *SearchJobsResponse_MatchingJob) XXX_Size() int {
	return xxx_messageInfo_SearchJobsResponse_MatchingJob.Size(m)
}
func (m *SearchJobsResponse_MatchingJob) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsResponse_MatchingJob.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsResponse_MatchingJob proto.InternalMessageInfo

func (m *SearchJobsResponse_MatchingJob) GetJob() *Job {
	if m != nil {
		return m.Job
	}
	return nil
}

func (m *SearchJobsResponse_MatchingJob) GetJobSummary() string {
	if m != nil {
		return m.JobSummary
	}
	return ""
}

func (m *SearchJobsResponse_MatchingJob) GetJobTitleSnippet() string {
	if m != nil {
		return m.JobTitleSnippet
	}
	return ""
}

func (m *SearchJobsResponse_MatchingJob) GetSearchTextSnippet() string {
	if m != nil {
		return m.SearchTextSnippet
	}
	return ""
}

func (m *SearchJobsResponse_MatchingJob) GetCommuteInfo() *SearchJobsResponse_CommuteInfo {
	if m != nil {
		return m.CommuteInfo
	}
	return nil
}

// Output only.
//
// Commute details related to this job.
type SearchJobsResponse_CommuteInfo struct {
	// Location used as the destination in the commute calculation.
	JobLocation *Location `protobuf:"bytes,1,opt,name=job_location,json=jobLocation,proto3" json:"job_location,omitempty"`
	// The number of seconds required to travel to the job location from the
	// query location. A duration of 0 seconds indicates that the job isn't
	// reachable within the requested duration, but was returned as part of an
	// expanded query.
	TravelDuration       *duration.Duration `protobuf:"bytes,2,opt,name=travel_duration,json=travelDuration,proto3" json:"travel_duration,omitempty"`
	XXX_NoUnkeyedLiteral struct{}           `json:"-"`
	XXX_unrecognized     []byte             `json:"-"`
	XXX_sizecache        int32              `json:"-"`
}

func (m *SearchJobsResponse_CommuteInfo) Reset()         { *m = SearchJobsResponse_CommuteInfo{} }
func (m *SearchJobsResponse_CommuteInfo) String() string { return proto.CompactTextString(m) }
func (*SearchJobsResponse_CommuteInfo) ProtoMessage()    {}
func (*SearchJobsResponse_CommuteInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{8, 1}
}

func (m *SearchJobsResponse_CommuteInfo) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_SearchJobsResponse_CommuteInfo.Unmarshal(m, b)
}
func (m *SearchJobsResponse_CommuteInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_SearchJobsResponse_CommuteInfo.Marshal(b, m, deterministic)
}
func (m *SearchJobsResponse_CommuteInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_SearchJobsResponse_CommuteInfo.Merge(m, src)
}
func (m *SearchJobsResponse_CommuteInfo) XXX_Size() int {
	return xxx_messageInfo_SearchJobsResponse_CommuteInfo.Size(m)
}
func (m *SearchJobsResponse_CommuteInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_SearchJobsResponse_CommuteInfo.DiscardUnknown(m)
}

var xxx_messageInfo_SearchJobsResponse_CommuteInfo proto.InternalMessageInfo

func (m *SearchJobsResponse_CommuteInfo) GetJobLocation() *Location {
	if m != nil {
		return m.JobLocation
	}
	return nil
}

func (m *SearchJobsResponse_CommuteInfo) GetTravelDuration() *duration.Duration {
	if m != nil {
		return m.TravelDuration
	}
	return nil
}

// Request to create a batch of jobs.
type BatchCreateJobsRequest struct {
	// Required.
	//
	// The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenant/foo".
	//
	// Tenant id is optional and a default tenant is created if unspecified, for
	// example, "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The jobs to be created.
	Jobs                 []*Job   `protobuf:"bytes,2,rep,name=jobs,proto3" json:"jobs,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *BatchCreateJobsRequest) Reset()         { *m = BatchCreateJobsRequest{} }
func (m *BatchCreateJobsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchCreateJobsRequest) ProtoMessage()    {}
func (*BatchCreateJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{9}
}

func (m *BatchCreateJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchCreateJobsRequest.Unmarshal(m, b)
}
func (m *BatchCreateJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchCreateJobsRequest.Marshal(b, m, deterministic)
}
func (m *BatchCreateJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchCreateJobsRequest.Merge(m, src)
}
func (m *BatchCreateJobsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchCreateJobsRequest.Size(m)
}
func (m *BatchCreateJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchCreateJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchCreateJobsRequest proto.InternalMessageInfo

func (m *BatchCreateJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchCreateJobsRequest) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

// Request to update a batch of jobs.
type BatchUpdateJobsRequest struct {
	// Required.
	//
	// The resource name of the tenant under which the job is created.
	//
	// The format is "projects/{project_id}/tenants/{tenant_id}", for example,
	// "projects/api-test-project/tenant/foo".
	//
	// Tenant id is optional and the default tenant is used if unspecified, for
	// example, "projects/api-test-project".
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required.
	//
	// The jobs to be updated.
	Jobs []*Job `protobuf:"bytes,2,rep,name=jobs,proto3" json:"jobs,omitempty"`
	// Optional but strongly recommended to be provided for the best service
	// experience, also increase latency when checking status of batch operation.
	//
	// If
	// [update_mask][google.cloud.talent.v4beta1.BatchUpdateJobsRequest.update_mask]
	// is provided, only the specified fields in
	// [Job][google.cloud.talent.v4beta1.Job] are updated. Otherwise all the
	// fields are updated.
	//
	// A field mask to restrict the fields that are updated. Only
	// top level fields of [Job][google.cloud.talent.v4beta1.Job] are supported.
	//
	// If
	// [update_mask][google.cloud.talent.v4beta1.BatchUpdateJobsRequest.update_mask]
	// is provided, The [Job][google.cloud.talent.v4beta1.Job] inside
	// [JobResult][] will only contains fields that is updated, plus the Id of the
	// Job. Otherwise,  [Job][google.cloud.talent.v4beta1.Job] will include all
	// fields, which can yield a very large response.
	UpdateMask           *field_mask.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	XXX_NoUnkeyedLiteral struct{}              `json:"-"`
	XXX_unrecognized     []byte                `json:"-"`
	XXX_sizecache        int32                 `json:"-"`
}

func (m *BatchUpdateJobsRequest) Reset()         { *m = BatchUpdateJobsRequest{} }
func (m *BatchUpdateJobsRequest) String() string { return proto.CompactTextString(m) }
func (*BatchUpdateJobsRequest) ProtoMessage()    {}
func (*BatchUpdateJobsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0dfa8e10f7799e35, []int{10}
}

func (m *BatchUpdateJobsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_BatchUpdateJobsRequest.Unmarshal(m, b)
}
func (m *BatchUpdateJobsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_BatchUpdateJobsRequest.Marshal(b, m, deterministic)
}
func (m *BatchUpdateJobsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_BatchUpdateJobsRequest.Merge(m, src)
}
func (m *BatchUpdateJobsRequest) XXX_Size() int {
	return xxx_messageInfo_BatchUpdateJobsRequest.Size(m)
}
func (m *BatchUpdateJobsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_BatchUpdateJobsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_BatchUpdateJobsRequest proto.InternalMessageInfo

func (m *BatchUpdateJobsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *BatchUpdateJobsRequest) GetJobs() []*Job {
	if m != nil {
		return m.Jobs
	}
	return nil
}

func (m *BatchUpdateJobsRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func init() {
	proto.RegisterEnum("google.cloud.talent.v4beta1.JobView", JobView_name, JobView_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.SearchJobsRequest_SearchMode", SearchJobsRequest_SearchMode_name, SearchJobsRequest_SearchMode_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.SearchJobsRequest_DiversificationLevel", SearchJobsRequest_DiversificationLevel_name, SearchJobsRequest_DiversificationLevel_value)
	proto.RegisterEnum("google.cloud.talent.v4beta1.SearchJobsRequest_CustomRankingInfo_ImportanceLevel", SearchJobsRequest_CustomRankingInfo_ImportanceLevel_name, SearchJobsRequest_CustomRankingInfo_ImportanceLevel_value)
	proto.RegisterType((*CreateJobRequest)(nil), "google.cloud.talent.v4beta1.CreateJobRequest")
	proto.RegisterType((*GetJobRequest)(nil), "google.cloud.talent.v4beta1.GetJobRequest")
	proto.RegisterType((*UpdateJobRequest)(nil), "google.cloud.talent.v4beta1.UpdateJobRequest")
	proto.RegisterType((*DeleteJobRequest)(nil), "google.cloud.talent.v4beta1.DeleteJobRequest")
	proto.RegisterType((*BatchDeleteJobsRequest)(nil), "google.cloud.talent.v4beta1.BatchDeleteJobsRequest")
	proto.RegisterType((*ListJobsRequest)(nil), "google.cloud.talent.v4beta1.ListJobsRequest")
	proto.RegisterType((*ListJobsResponse)(nil), "google.cloud.talent.v4beta1.ListJobsResponse")
	proto.RegisterType((*SearchJobsRequest)(nil), "google.cloud.talent.v4beta1.SearchJobsRequest")
	proto.RegisterType((*SearchJobsRequest_CustomRankingInfo)(nil), "google.cloud.talent.v4beta1.SearchJobsRequest.CustomRankingInfo")
	proto.RegisterType((*SearchJobsResponse)(nil), "google.cloud.talent.v4beta1.SearchJobsResponse")
	proto.RegisterType((*SearchJobsResponse_MatchingJob)(nil), "google.cloud.talent.v4beta1.SearchJobsResponse.MatchingJob")
	proto.RegisterType((*SearchJobsResponse_CommuteInfo)(nil), "google.cloud.talent.v4beta1.SearchJobsResponse.CommuteInfo")
	proto.RegisterType((*BatchCreateJobsRequest)(nil), "google.cloud.talent.v4beta1.BatchCreateJobsRequest")
	proto.RegisterType((*BatchUpdateJobsRequest)(nil), "google.cloud.talent.v4beta1.BatchUpdateJobsRequest")
}

func init() {
	proto.RegisterFile("google/cloud/talent/v4beta1/job_service.proto", fileDescriptor_0dfa8e10f7799e35)
}

var fileDescriptor_0dfa8e10f7799e35 = []byte{
	// 1964 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xb4, 0x58, 0xcd, 0x73, 0xdb, 0xd6,
	0x11, 0x2f, 0xa8, 0x2f, 0x6a, 0x69, 0x89, 0xd0, 0xb3, 0x62, 0x33, 0x54, 0xd2, 0xc8, 0x70, 0xed,
	0xaa, 0x72, 0x45, 0x26, 0x4c, 0x3a, 0x9d, 0xc6, 0x93, 0x69, 0x25, 0x12, 0x8a, 0xe0, 0x92, 0x92,
	0x0a, 0x4a, 0xb6, 0xab, 0x83, 0x11, 0x90, 0x7c, 0xa4, 0x20, 0x81, 0x78, 0x08, 0xf0, 0x48, 0x5b,
	0x49, 0x7d, 0x69, 0xff, 0x84, 0x1e, 0x3b, 0x93, 0x43, 0x7a, 0xed, 0xa1, 0x87, 0xde, 0xda, 0xe9,
	0x4c, 0x67, 0x7a, 0xef, 0x21, 0xc7, 0x4e, 0x6f, 0xfd, 0x0f, 0xfa, 0x0f, 0x74, 0xde, 0x07, 0xc0,
	0x0f, 0xd1, 0xfc, 0xb0, 0xc7, 0x37, 0xbc, 0xdd, 0xdf, 0xee, 0xdb, 0xdd, 0xb7, 0x6f, 0xdf, 0x2e,
	0x60, 0xa7, 0x45, 0x48, 0xcb, 0xc5, 0xf9, 0xba, 0x4b, 0x3a, 0x8d, 0x3c, 0xb5, 0x5d, 0xec, 0xd1,
	0x7c, 0xf7, 0x93, 0x1a, 0xa6, 0xf6, 0x47, 0xf9, 0x0b, 0x52, 0xb3, 0x42, 0x1c, 0x74, 0x9d, 0x3a,
	0xce, 0xf9, 0x01, 0xa1, 0x04, 0x6d, 0x08, 0x78, 0x8e, 0xc3, 0x73, 0x02, 0x9e, 0x93, 0xf0, 0xec,
	0x7b, 0x52, 0x97, 0xed, 0x3b, 0x79, 0xdb, 0xf3, 0x08, 0xb5, 0xa9, 0x43, 0xbc, 0x50, 0x88, 0x66,
	0x7f, 0x38, 0x6e, 0xa7, 0x9a, 0x4d, 0xeb, 0xe7, 0x12, 0xb8, 0x35, 0x0e, 0x58, 0x27, 0xed, 0x36,
	0xf1, 0x24, 0xf2, 0x47, 0xe3, 0x90, 0x4d, 0xc7, 0xa5, 0x38, 0x88, 0x76, 0x7f, 0x30, 0x0e, 0x7a,
	0xee, 0x84, 0x94, 0xb4, 0x02, 0xbb, 0x2d, 0xc1, 0xf7, 0x26, 0x04, 0x45, 0xc2, 0xee, 0x4a, 0x98,
	0x4b, 0xbc, 0x56, 0xd0, 0xf1, 0x3c, 0xc7, 0x6b, 0xe5, 0x89, 0x8f, 0x83, 0x01, 0xb7, 0xbf, 0x2f,
	0x41, 0x7c, 0x55, 0xeb, 0x34, 0xf3, 0x8d, 0x8e, 0x00, 0x48, 0xfe, 0xc6, 0x30, 0x1f, 0xb7, 0x7d,
	0x7a, 0x25, 0x99, 0x9b, 0xc3, 0xcc, 0xa6, 0x83, 0xdd, 0x86, 0xd5, 0xb6, 0xc3, 0x4b, 0x81, 0xd0,
	0x9e, 0x81, 0x5a, 0x0c, 0xb0, 0x4d, 0xf1, 0x23, 0x52, 0x33, 0xf1, 0x97, 0x1d, 0x1c, 0x52, 0x74,
	0x0b, 0x16, 0x7d, 0x3b, 0xc0, 0x1e, 0xcd, 0x28, 0x9b, 0xca, 0xd6, 0xb2, 0x29, 0x57, 0xa8, 0x00,
	0x73, 0x17, 0xa4, 0x96, 0x49, 0x6c, 0x2a, 0x5b, 0xa9, 0xc2, 0x66, 0x6e, 0xcc, 0x51, 0xe6, 0x98,
	0x36, 0x06, 0xd6, 0xee, 0xc2, 0xca, 0xe7, 0x98, 0xf6, 0x29, 0x47, 0x30, 0xef, 0xd9, 0x6d, 0x2c,
	0x55, 0xf3, 0x6f, 0xed, 0x77, 0x0a, 0xa8, 0xa7, 0x7e, 0x63, 0xd0, 0x0a, 0xb9, 0x9b, 0x32, 0xc3,
	0x6e, 0xe8, 0x21, 0xa4, 0x3a, 0x5c, 0x0f, 0x77, 0x51, 0x5a, 0x9a, 0x8d, 0x64, 0xa3, 0x28, 0xe4,
	0xf6, 0x59, 0x14, 0x2a, 0x76, 0x78, 0x69, 0x82, 0x80, 0xb3, 0x6f, 0xed, 0x3e, 0xa8, 0x25, 0xec,
	0xe2, 0x01, 0x23, 0x46, 0x59, 0x7b, 0x00, 0xb7, 0xf6, 0x58, 0xba, 0xc5, 0xe0, 0x70, 0x52, 0xe0,
	0x6e, 0xc1, 0xa2, 0xc8, 0x26, 0x6e, 0xd1, 0xb2, 0x29, 0x57, 0xda, 0xdf, 0x15, 0x48, 0x97, 0x9d,
	0x90, 0xbe, 0x81, 0x0e, 0xf4, 0x3e, 0x80, 0x6f, 0xb7, 0xb0, 0x45, 0xc9, 0x25, 0xf6, 0x32, 0x73,
	0x9c, 0xb7, 0xcc, 0x28, 0x27, 0x8c, 0x80, 0x36, 0x80, 0x2f, 0xac, 0xd0, 0xf9, 0x0a, 0x67, 0xe6,
	0x37, 0x95, 0xad, 0x05, 0x33, 0xc9, 0x08, 0x55, 0xe7, 0x2b, 0x8c, 0x7e, 0x0e, 0x49, 0x76, 0x45,
	0xbb, 0x0e, 0x7e, 0x9e, 0x59, 0xd8, 0x54, 0xb6, 0x56, 0x0b, 0x3f, 0x98, 0x14, 0xe7, 0xc7, 0x0e,
	0x7e, 0x6e, 0x2e, 0x5d, 0x88, 0x0f, 0xed, 0xaf, 0x0a, 0xa8, 0x3d, 0x07, 0x42, 0x9f, 0x78, 0x21,
	0x46, 0x9f, 0xc0, 0xfc, 0x05, 0xa9, 0x85, 0x19, 0x65, 0x73, 0x6e, 0xaa, 0x93, 0xe3, 0x68, 0x74,
	0x1f, 0xd2, 0x1e, 0x7e, 0x41, 0xad, 0x3e, 0x67, 0x84, 0xa3, 0x2b, 0x8c, 0x7c, 0x1c, 0x3b, 0x64,
	0x40, 0xb2, 0x8d, 0xa9, 0xdd, 0xb0, 0xa9, 0xcd, 0xbd, 0x4d, 0x15, 0x76, 0xc6, 0xee, 0x10, 0x99,
	0x55, 0x91, 0x42, 0x66, 0x2c, 0xae, 0x7d, 0x93, 0x82, 0xb5, 0x2a, 0xb6, 0x83, 0xfa, 0xf9, 0x34,
	0x07, 0x70, 0x06, 0xa9, 0x90, 0x83, 0xad, 0x36, 0x69, 0x60, 0x6e, 0xdc, 0x6a, 0xe1, 0x67, 0x63,
	0xf7, 0xbe, 0xa6, 0x5c, 0x52, 0x2a, 0xa4, 0x81, 0x4d, 0x08, 0xe3, 0x6f, 0xf4, 0x04, 0xd4, 0x40,
	0x20, 0xac, 0x21, 0xe7, 0x7e, 0x3c, 0xc1, 0x39, 0x2e, 0x14, 0xfb, 0x96, 0x0e, 0x06, 0x09, 0x68,
	0x0f, 0x96, 0xd9, 0x09, 0x7f, 0xd9, 0xc1, 0xc1, 0x15, 0x3f, 0xfe, 0x54, 0xe1, 0xde, 0xa4, 0x03,
	0xf9, 0x15, 0x03, 0x9b, 0x2c, 0x33, 0xf8, 0x17, 0x7a, 0x00, 0x6b, 0xd8, 0xb3, 0x6b, 0x2e, 0xb6,
	0x6a, 0x01, 0xb1, 0x1b, 0x98, 0xd5, 0x29, 0x9e, 0x2e, 0x49, 0x53, 0x15, 0x8c, 0xbd, 0x98, 0x8e,
	0x3e, 0x83, 0x0d, 0x66, 0x83, 0x13, 0x60, 0xcb, 0x0f, 0x70, 0xdd, 0x09, 0xb1, 0x15, 0xe0, 0xb0,
	0xe3, 0x52, 0x91, 0x81, 0x8b, 0x5c, 0x2c, 0x23, 0x21, 0xc7, 0x02, 0x61, 0x72, 0x00, 0xcf, 0xc8,
	0xa7, 0xb0, 0x16, 0x17, 0x53, 0x6e, 0xb5, 0x83, 0xc3, 0xcc, 0x12, 0x4f, 0xa4, 0x07, 0x63, 0xed,
	0x3e, 0x88, 0xa4, 0x84, 0xf5, 0xea, 0x79, 0xff, 0xda, 0xc1, 0xe1, 0x40, 0xae, 0x27, 0x5f, 0x23,
	0xd7, 0x59, 0x5e, 0x90, 0x66, 0x33, 0xc4, 0x34, 0xb3, 0xcc, 0xaf, 0x91, 0x5c, 0x0d, 0xde, 0x30,
	0x18, 0xba, 0x61, 0x83, 0xb7, 0x33, 0x35, 0x7c, 0x3b, 0xdf, 0x85, 0x24, 0x09, 0x1a, 0x38, 0xb0,
	0x6a, 0x57, 0x99, 0x1b, 0x9c, 0xb9, 0xc4, 0xd7, 0x7b, 0x57, 0xe8, 0x05, 0xbc, 0xd3, 0x70, 0xba,
	0x38, 0x08, 0x9d, 0xa6, 0x53, 0xe7, 0x05, 0xdf, 0x72, 0x71, 0x17, 0xbb, 0x99, 0x15, 0x6e, 0x7c,
	0x71, 0xc6, 0xc4, 0x2b, 0x0d, 0xea, 0x2a, 0x33, 0x55, 0xe6, 0x7a, 0x63, 0x04, 0x15, 0xf9, 0x70,
	0xb3, 0xde, 0x09, 0x29, 0x69, 0x5b, 0x81, 0xed, 0x5d, 0x3a, 0x5e, 0xcb, 0x72, 0xbc, 0x26, 0xc9,
	0xac, 0xf2, 0xec, 0xf9, 0xc5, 0x8c, 0xfb, 0x16, 0xb9, 0x26, 0x53, 0x28, 0x32, 0xbc, 0x26, 0x31,
	0xd7, 0xea, 0xc3, 0x24, 0x54, 0x60, 0xbe, 0x86, 0x3c, 0xc5, 0x2e, 0xf1, 0xd5, 0x73, 0x12, 0xb0,
	0x27, 0x8a, 0xd6, 0xcf, 0x33, 0x2a, 0x4f, 0x97, 0x9b, 0x92, 0xf9, 0x4b, 0xc1, 0xab, 0x30, 0x56,
	0xf6, 0x2f, 0x09, 0x58, 0xbb, 0xa6, 0x1c, 0x7d, 0x0d, 0xaa, 0xd3, 0xf6, 0x49, 0x40, 0x6d, 0xaf,
	0x8e, 0x65, 0xc0, 0x14, 0x1e, 0xb0, 0xe3, 0x37, 0x35, 0x3c, 0x67, 0xc4, 0x8a, 0x45, 0xf4, 0xd2,
	0xce, 0x20, 0x01, 0xed, 0x00, 0x8a, 0x22, 0x86, 0x5f, 0xf8, 0x01, 0x0e, 0x43, 0x87, 0x44, 0x55,
	0x6c, 0x4d, 0x72, 0xf4, 0x98, 0xa1, 0x85, 0x90, 0x1e, 0x52, 0x89, 0x36, 0xe1, 0x3d, 0xa3, 0x72,
	0x7c, 0x64, 0x9e, 0xec, 0x1e, 0x16, 0x75, 0xab, 0xac, 0x3f, 0xd6, 0xcb, 0xd6, 0xe9, 0x61, 0xf5,
	0x58, 0x2f, 0x1a, 0xfb, 0x86, 0x5e, 0x52, 0xbf, 0x87, 0x92, 0x30, 0x7f, 0x78, 0x74, 0xa8, 0xab,
	0x0a, 0x5a, 0x82, 0xb9, 0xf2, 0xd1, 0x13, 0x35, 0xc1, 0x48, 0x15, 0xa3, 0x5c, 0x52, 0xe7, 0x10,
	0xc0, 0x62, 0x45, 0x2f, 0x19, 0xa7, 0x15, 0x75, 0x9e, 0x51, 0x0f, 0x8c, 0xcf, 0x0f, 0xd4, 0x05,
	0x94, 0x82, 0x25, 0xfd, 0xe9, 0x89, 0xa9, 0x57, 0x74, 0x75, 0x51, 0x33, 0x01, 0x7a, 0x35, 0x08,
	0x6d, 0xc0, 0xed, 0xaa, 0xbe, 0x6b, 0x16, 0x0f, 0xac, 0xca, 0x51, 0x49, 0x1f, 0xda, 0x6a, 0x15,
	0xe0, 0xd1, 0xd1, 0x9e, 0x25, 0x00, 0xaa, 0x82, 0x6e, 0xc3, 0xcd, 0x7d, 0x7d, 0xf7, 0xe4, 0xd4,
	0xd4, 0x4b, 0x56, 0x1f, 0x23, 0xa1, 0x3d, 0x81, 0xf5, 0x51, 0xe9, 0x85, 0xee, 0xc1, 0x9d, 0x92,
	0xf1, 0x58, 0x37, 0xab, 0xc6, 0xbe, 0x51, 0xdc, 0x3d, 0x31, 0x8e, 0x0e, 0x47, 0xba, 0x74, 0x03,
	0x92, 0x25, 0xa3, 0xba, 0xbb, 0x57, 0xd6, 0x4b, 0xaa, 0xc2, 0x7c, 0xa8, 0x1a, 0x95, 0xe3, 0xb2,
	0xae, 0x26, 0xb4, 0x7f, 0x25, 0x01, 0xf5, 0x9f, 0x8c, 0x7c, 0x60, 0xbe, 0x80, 0x15, 0x9e, 0x1e,
	0x2c, 0xd0, 0x7d, 0x2f, 0xcd, 0xc3, 0xa9, 0x4f, 0x58, 0xe8, 0xc9, 0x55, 0xa4, 0x12, 0xf6, 0x08,
	0xdd, 0x68, 0xf7, 0x16, 0x21, 0x72, 0xe0, 0xf6, 0x60, 0x19, 0xba, 0x92, 0x55, 0x2c, 0xcc, 0x24,
	0xf8, 0x5e, 0x1f, 0xcd, 0x52, 0x8c, 0xb8, 0xa4, 0xf9, 0xce, 0xf9, 0x08, 0xea, 0xc8, 0x77, 0x6f,
	0x6e, 0xd4, 0xbb, 0x77, 0x0c, 0xaa, 0x4b, 0x64, 0x21, 0x90, 0xad, 0x69, 0x66, 0x9e, 0xdb, 0x32,
	0xbe, 0xa0, 0x97, 0xa5, 0x90, 0x99, 0x8e, 0xc4, 0xf7, 0x85, 0x34, 0xfa, 0x10, 0xd6, 0x71, 0x48,
	0x9d, 0xb6, 0x4d, 0x71, 0xc3, 0xa2, 0x84, 0xda, 0xae, 0xa8, 0x61, 0x0b, 0xbc, 0x86, 0xa1, 0x98,
	0x77, 0xc2, 0x58, 0x51, 0x35, 0xeb, 0xc3, 0x2d, 0x72, 0xdc, 0x32, 0x8d, 0xd9, 0xfd, 0x4f, 0xf3,
	0xd2, 0x1b, 0x3d, 0xcd, 0xe8, 0x21, 0x64, 0xe5, 0x63, 0x83, 0x1b, 0xf2, 0x00, 0xd8, 0x49, 0x5b,
	0x75, 0xd2, 0xf1, 0x28, 0xaf, 0xdf, 0x0b, 0xe6, 0xed, 0x18, 0xc1, 0x03, 0xca, 0x0e, 0xae, 0xc8,
	0xd8, 0xe8, 0x0c, 0xd4, 0xd0, 0xc7, 0xae, 0x6b, 0xd5, 0x49, 0x10, 0xe0, 0x3a, 0xf3, 0x99, 0xd7,
	0xec, 0x54, 0x21, 0x3f, 0x3e, 0x45, 0x98, 0x90, 0xe3, 0xb5, 0x8a, 0xb1, 0x98, 0x99, 0xe6, 0x8a,
	0x7a, 0x84, 0xec, 0x37, 0x09, 0x48, 0xf5, 0xe5, 0xcd, 0x6b, 0x75, 0xa9, 0x1f, 0x40, 0x8a, 0x4f,
	0x46, 0x9d, 0x76, 0xdb, 0x0e, 0xae, 0x64, 0x81, 0x80, 0x0b, 0x52, 0xab, 0x0a, 0x0a, 0xda, 0x86,
	0x35, 0x06, 0xa0, 0x0e, 0x75, 0xb1, 0x15, 0x7a, 0x8e, 0xef, 0x63, 0x2a, 0xb3, 0x22, 0x7d, 0x41,
	0x6a, 0x27, 0x8c, 0x5e, 0x15, 0x64, 0x94, 0x83, 0x9b, 0xb2, 0x2d, 0xa1, 0x2c, 0x8d, 0x22, 0xf4,
	0xbc, 0xa8, 0x3a, 0x82, 0x75, 0x82, 0x5f, 0xd0, 0x08, 0xff, 0x0c, 0x6e, 0xb0, 0x19, 0xa8, 0x43,
	0xb1, 0x28, 0xeb, 0x0b, 0xdc, 0xf2, 0x99, 0xef, 0x4e, 0x51, 0xe8, 0xe0, 0x15, 0x3d, 0x55, 0xef,
	0x2d, 0xb2, 0x7f, 0x50, 0x20, 0xd5, 0xc7, 0x44, 0x07, 0x70, 0x83, 0xf9, 0x12, 0x25, 0x9f, 0x8c,
	0xd4, 0x94, 0x39, 0xcb, 0xe2, 0x14, 0x2d, 0xd0, 0x1e, 0xa4, 0x69, 0x60, 0x77, 0xb1, 0x6b, 0x45,
	0x23, 0x90, 0x6c, 0xf0, 0xdf, 0xbd, 0xd6, 0xe0, 0x97, 0x24, 0xc0, 0x5c, 0x15, 0x12, 0xd1, 0x5a,
	0x6b, 0xca, 0xde, 0x3d, 0x9e, 0x79, 0x26, 0xb6, 0x7d, 0x51, 0x37, 0x9b, 0x98, 0xa5, 0x9b, 0xd5,
	0xfe, 0xa8, 0xc8, 0x8d, 0xe2, 0xb1, 0xe6, 0xed, 0x6c, 0x34, 0x3c, 0xf1, 0xcc, 0xcd, 0x32, 0xf1,
	0x6c, 0x77, 0x61, 0x49, 0xb6, 0x39, 0x28, 0x03, 0xeb, 0xac, 0xa6, 0x3f, 0x36, 0xf4, 0x27, 0x43,
	0xe5, 0x79, 0x1d, 0xd4, 0x98, 0x63, 0x94, 0xac, 0xa3, 0xc3, 0xf2, 0xaf, 0x55, 0x65, 0x80, 0x5a,
	0x31, 0x0e, 0x8d, 0xca, 0x6e, 0x59, 0x4d, 0x20, 0x04, 0xab, 0x31, 0xb5, 0x5a, 0xd9, 0x2d, 0x97,
	0xd5, 0x39, 0xb4, 0x06, 0x2b, 0x31, 0x6d, 0xff, 0xb4, 0x5c, 0x56, 0xe7, 0x0b, 0xdf, 0xaa, 0x00,
	0x8f, 0x48, 0xad, 0x2a, 0x7e, 0x0d, 0xa0, 0xbf, 0x29, 0xb0, 0x1c, 0x1f, 0x08, 0x1a, 0x5f, 0x33,
	0x86, 0x87, 0xd5, 0xec, 0xc4, 0x40, 0x69, 0xcf, 0x7e, 0xfb, 0xdd, 0x7f, 0x7f, 0x9f, 0x78, 0xaa,
	0x3d, 0x88, 0x47, 0xf0, 0xaf, 0x45, 0xc8, 0x3f, 0xf3, 0x03, 0x72, 0x81, 0xeb, 0x34, 0xcc, 0x6f,
	0xe7, 0x29, 0xf6, 0x6c, 0x8f, 0x7d, 0xbd, 0x64, 0x03, 0x7a, 0xf8, 0xa9, 0xb2, 0x7d, 0x76, 0x5f,
	0xbb, 0x33, 0x46, 0x22, 0xc6, 0xa1, 0x3f, 0x2b, 0xb0, 0x28, 0x66, 0x5c, 0xb4, 0x3d, 0xd6, 0x98,
	0x81, 0x41, 0x78, 0x0a, 0xc3, 0x9f, 0x72, 0xc3, 0x4d, 0xd4, 0x67, 0x38, 0x1b, 0x40, 0x47, 0x9a,
	0xcd, 0xad, 0xc9, 0x6f, 0xbf, 0x3c, 0xbb, 0x8b, 0xee, 0xbc, 0x1a, 0x2e, 0x41, 0xe8, 0x9f, 0x0a,
	0x2c, 0xc7, 0x99, 0x39, 0x21, 0xe2, 0xc3, 0x83, 0xf9, 0x14, 0x86, 0x37, 0xb9, 0xe1, 0x5f, 0x14,
	0xf2, 0x3d, 0x4b, 0x2e, 0x48, 0x2d, 0x37, 0xd1, 0x78, 0x16, 0xf5, 0xed, 0xc2, 0xbd, 0xf1, 0x52,
	0x3d, 0x2c, 0xfa, 0x93, 0x02, 0xcb, 0xf1, 0x14, 0x3e, 0xc1, 0x8d, 0xe1, 0xd1, 0x3e, 0x7b, 0xeb,
	0xda, 0x25, 0xd1, 0xdb, 0x3e, 0xbd, 0x8a, 0xa2, 0xbe, 0x3d, 0x5b, 0xd4, 0xb7, 0xa7, 0x88, 0xfa,
	0x3f, 0x14, 0x48, 0x46, 0xd3, 0x32, 0x1a, 0x3f, 0xd8, 0x0d, 0xfd, 0x15, 0xc8, 0xee, 0x4c, 0x89,
	0x16, 0xd5, 0x79, 0x54, 0xe6, 0x4c, 0x4c, 0xf9, 0xc1, 0xcc, 0x79, 0x45, 0xbe, 0xa3, 0xef, 0x14,
	0x48, 0x0f, 0xfd, 0xfd, 0x40, 0x1f, 0x8f, 0x35, 0x6e, 0xf4, 0xbf, 0x92, 0x57, 0x86, 0x3f, 0xe4,
	0xa6, 0xb7, 0xb5, 0x9f, 0xce, 0x72, 0x5b, 0x6b, 0xbd, 0x3d, 0x58, 0x0e, 0xe5, 0xb5, 0x9d, 0xc9,
	0x37, 0xb7, 0x4f, 0x06, 0xfd, 0x5b, 0x89, 0xda, 0x62, 0xee, 0x50, 0x6e, 0xb6, 0x59, 0x21, 0x9b,
	0x9f, 0xf1, 0xf5, 0xd4, 0x5c, 0xee, 0x64, 0x53, 0x2b, 0xcc, 0xe2, 0xa4, 0x78, 0xcb, 0x99, 0x7f,
	0x3b, 0xda, 0xd6, 0x64, 0xff, 0x62, 0x38, 0xfa, 0x9f, 0xd2, 0xdf, 0x46, 0xef, 0x93, 0x60, 0xd7,
	0xc5, 0x01, 0x7d, 0xfb, 0x5e, 0xfe, 0x86, 0x7b, 0xd9, 0xd5, 0x3e, 0x9d, 0xdd, 0xcb, 0xc8, 0x48,
	0xe6, 0xed, 0x4f, 0xb4, 0x0f, 0xa7, 0xf5, 0xb6, 0x4f, 0x0c, 0xfd, 0x27, 0xca, 0xd4, 0xde, 0x5b,
	0x3f, 0x4d, 0xa6, 0x5e, 0xeb, 0x0c, 0xb2, 0xef, 0x47, 0x42, 0x7d, 0xff, 0x69, 0x73, 0x47, 0xd1,
	0x7f, 0x5a, 0xad, 0xcb, 0xbd, 0xf4, 0x5f, 0x23, 0x61, 0xc5, 0x56, 0xcc, 0xc5, 0xc2, 0xd4, 0x09,
	0x1b, 0xcb, 0xf4, 0xfc, 0xeb, 0xb5, 0x18, 0xd3, 0xf8, 0x77, 0xad, 0x21, 0x79, 0x7b, 0xfe, 0x89,
	0xad, 0x66, 0xf3, 0x2f, 0x96, 0xd9, 0x7b, 0x09, 0x1f, 0xd4, 0x49, 0x7b, 0x9c, 0x43, 0x7b, 0xe9,
	0x5e, 0x13, 0x71, 0xcc, 0xaa, 0xc8, 0xb1, 0x72, 0xb6, 0x2b, 0xf1, 0x2d, 0xe2, 0xda, 0x5e, 0x2b,
	0x47, 0x82, 0x56, 0xbe, 0x85, 0x3d, 0x5e, 0x63, 0xf2, 0x82, 0x65, 0xfb, 0x4e, 0x38, 0xf2, 0xcf,
	0xfc, 0x43, 0xb1, 0xfc, 0x36, 0x31, 0x57, 0x3c, 0xa9, 0xd6, 0x16, 0xb9, 0xcc, 0xc7, 0xff, 0x0f,
	0x00, 0x00, 0xff, 0xff, 0xd5, 0x0c, 0xd9, 0x51, 0xe1, 0x18, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// JobServiceClient is the client API for JobService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type JobServiceClient interface {
	// Creates a new job.
	//
	// Typically, the job becomes searchable within 10 seconds, but it may take
	// up to 5 minutes.
	CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Retrieves the specified job, whose status is OPEN or recently EXPIRED
	// within the last 90 days.
	GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Updates specified job.
	//
	// Typically, updated contents become visible in search results within 10
	// seconds, but it may take up to 5 minutes.
	UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error)
	// Deletes the specified job.
	//
	// Typically, the job becomes unsearchable within 10 seconds, but it may take
	// up to 5 minutes.
	DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Lists jobs by filter.
	ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error)
	// Deletes a list of [Job][google.cloud.talent.v4beta1.Job]s by filter.
	BatchDeleteJobs(ctx context.Context, in *BatchDeleteJobsRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs present in
	// the database, and only returns jobs that the caller has permission to
	// search against.
	SearchJobs(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This API call is intended for the use case of targeting passive job
	// seekers (for example, job seekers who have signed up to receive email
	// alerts about potential job opportunities), and has different algorithmic
	// adjustments that are targeted to passive job seekers.
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs present in
	// the database, and only returns jobs the caller has permission to search
	// against.
	SearchJobsForAlert(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error)
	// Begins executing a batch create jobs operation.
	BatchCreateJobs(ctx context.Context, in *BatchCreateJobsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Begins executing a batch update jobs operation.
	BatchUpdateJobs(ctx context.Context, in *BatchUpdateJobsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
}

type jobServiceClient struct {
	cc *grpc.ClientConn
}

func NewJobServiceClient(cc *grpc.ClientConn) JobServiceClient {
	return &jobServiceClient{cc}
}

func (c *jobServiceClient) CreateJob(ctx context.Context, in *CreateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/CreateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) GetJob(ctx context.Context, in *GetJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/GetJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) UpdateJob(ctx context.Context, in *UpdateJobRequest, opts ...grpc.CallOption) (*Job, error) {
	out := new(Job)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/UpdateJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) DeleteJob(ctx context.Context, in *DeleteJobRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/DeleteJob", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) ListJobs(ctx context.Context, in *ListJobsRequest, opts ...grpc.CallOption) (*ListJobsResponse, error) {
	out := new(ListJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/ListJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchDeleteJobs(ctx context.Context, in *BatchDeleteJobsRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/BatchDeleteJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchJobs(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error) {
	out := new(SearchJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/SearchJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) SearchJobsForAlert(ctx context.Context, in *SearchJobsRequest, opts ...grpc.CallOption) (*SearchJobsResponse, error) {
	out := new(SearchJobsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/SearchJobsForAlert", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchCreateJobs(ctx context.Context, in *BatchCreateJobsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/BatchCreateJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *jobServiceClient) BatchUpdateJobs(ctx context.Context, in *BatchUpdateJobsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.talent.v4beta1.JobService/BatchUpdateJobs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// JobServiceServer is the server API for JobService service.
type JobServiceServer interface {
	// Creates a new job.
	//
	// Typically, the job becomes searchable within 10 seconds, but it may take
	// up to 5 minutes.
	CreateJob(context.Context, *CreateJobRequest) (*Job, error)
	// Retrieves the specified job, whose status is OPEN or recently EXPIRED
	// within the last 90 days.
	GetJob(context.Context, *GetJobRequest) (*Job, error)
	// Updates specified job.
	//
	// Typically, updated contents become visible in search results within 10
	// seconds, but it may take up to 5 minutes.
	UpdateJob(context.Context, *UpdateJobRequest) (*Job, error)
	// Deletes the specified job.
	//
	// Typically, the job becomes unsearchable within 10 seconds, but it may take
	// up to 5 minutes.
	DeleteJob(context.Context, *DeleteJobRequest) (*empty.Empty, error)
	// Lists jobs by filter.
	ListJobs(context.Context, *ListJobsRequest) (*ListJobsResponse, error)
	// Deletes a list of [Job][google.cloud.talent.v4beta1.Job]s by filter.
	BatchDeleteJobs(context.Context, *BatchDeleteJobsRequest) (*empty.Empty, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs present in
	// the database, and only returns jobs that the caller has permission to
	// search against.
	SearchJobs(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error)
	// Searches for jobs using the provided
	// [SearchJobsRequest][google.cloud.talent.v4beta1.SearchJobsRequest].
	//
	// This API call is intended for the use case of targeting passive job
	// seekers (for example, job seekers who have signed up to receive email
	// alerts about potential job opportunities), and has different algorithmic
	// adjustments that are targeted to passive job seekers.
	//
	// This call constrains the
	// [visibility][google.cloud.talent.v4beta1.Job.visibility] of jobs present in
	// the database, and only returns jobs the caller has permission to search
	// against.
	SearchJobsForAlert(context.Context, *SearchJobsRequest) (*SearchJobsResponse, error)
	// Begins executing a batch create jobs operation.
	BatchCreateJobs(context.Context, *BatchCreateJobsRequest) (*longrunning.Operation, error)
	// Begins executing a batch update jobs operation.
	BatchUpdateJobs(context.Context, *BatchUpdateJobsRequest) (*longrunning.Operation, error)
}

func RegisterJobServiceServer(s *grpc.Server, srv JobServiceServer) {
	s.RegisterService(&_JobService_serviceDesc, srv)
}

func _JobService_CreateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).CreateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/CreateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).CreateJob(ctx, req.(*CreateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_GetJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).GetJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/GetJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).GetJob(ctx, req.(*GetJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_UpdateJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).UpdateJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/UpdateJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).UpdateJob(ctx, req.(*UpdateJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_DeleteJob_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteJobRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).DeleteJob(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/DeleteJob",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).DeleteJob(ctx, req.(*DeleteJobRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_ListJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).ListJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/ListJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).ListJobs(ctx, req.(*ListJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchDeleteJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchDeleteJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchDeleteJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/BatchDeleteJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchDeleteJobs(ctx, req.(*BatchDeleteJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/SearchJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchJobs(ctx, req.(*SearchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_SearchJobsForAlert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).SearchJobsForAlert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/SearchJobsForAlert",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).SearchJobsForAlert(ctx, req.(*SearchJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchCreateJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchCreateJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchCreateJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/BatchCreateJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchCreateJobs(ctx, req.(*BatchCreateJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _JobService_BatchUpdateJobs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(BatchUpdateJobsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(JobServiceServer).BatchUpdateJobs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.talent.v4beta1.JobService/BatchUpdateJobs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(JobServiceServer).BatchUpdateJobs(ctx, req.(*BatchUpdateJobsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _JobService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.talent.v4beta1.JobService",
	HandlerType: (*JobServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CreateJob",
			Handler:    _JobService_CreateJob_Handler,
		},
		{
			MethodName: "GetJob",
			Handler:    _JobService_GetJob_Handler,
		},
		{
			MethodName: "UpdateJob",
			Handler:    _JobService_UpdateJob_Handler,
		},
		{
			MethodName: "DeleteJob",
			Handler:    _JobService_DeleteJob_Handler,
		},
		{
			MethodName: "ListJobs",
			Handler:    _JobService_ListJobs_Handler,
		},
		{
			MethodName: "BatchDeleteJobs",
			Handler:    _JobService_BatchDeleteJobs_Handler,
		},
		{
			MethodName: "SearchJobs",
			Handler:    _JobService_SearchJobs_Handler,
		},
		{
			MethodName: "SearchJobsForAlert",
			Handler:    _JobService_SearchJobsForAlert_Handler,
		},
		{
			MethodName: "BatchCreateJobs",
			Handler:    _JobService_BatchCreateJobs_Handler,
		},
		{
			MethodName: "BatchUpdateJobs",
			Handler:    _JobService_BatchUpdateJobs_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/talent/v4beta1/job_service.proto",
}
