// Code generated by protoc-gen-go. DO NOT EDIT.
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

package datatransfer

import (
	context "context"
	fmt "fmt"
	math "math"

	proto "github.com/golang/protobuf/proto"
	duration "github.com/golang/protobuf/ptypes/duration"
	empty "github.com/golang/protobuf/ptypes/empty"
	timestamp "github.com/golang/protobuf/ptypes/timestamp"
	wrappers "github.com/golang/protobuf/ptypes/wrappers"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	field_mask "google.golang.org/genproto/protobuf/field_mask"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion3 // please upgrade the proto package

// Parameter type.
type DataSourceParameter_Type int32

const (
	// Type unspecified.
	DataSourceParameter_TYPE_UNSPECIFIED DataSourceParameter_Type = 0
	// String parameter.
	DataSourceParameter_STRING DataSourceParameter_Type = 1
	// Integer parameter (64-bits).
	// Will be serialized to json as string.
	DataSourceParameter_INTEGER DataSourceParameter_Type = 2
	// Double precision floating point parameter.
	DataSourceParameter_DOUBLE DataSourceParameter_Type = 3
	// Boolean parameter.
	DataSourceParameter_BOOLEAN DataSourceParameter_Type = 4
	// Deprecated. This field has no effect.
	DataSourceParameter_RECORD DataSourceParameter_Type = 5
	// Page ID for a Google+ Page.
	DataSourceParameter_PLUS_PAGE DataSourceParameter_Type = 6
)

var DataSourceParameter_Type_name = map[int32]string{
	0: "TYPE_UNSPECIFIED",
	1: "STRING",
	2: "INTEGER",
	3: "DOUBLE",
	4: "BOOLEAN",
	5: "RECORD",
	6: "PLUS_PAGE",
}

var DataSourceParameter_Type_value = map[string]int32{
	"TYPE_UNSPECIFIED": 0,
	"STRING":           1,
	"INTEGER":          2,
	"DOUBLE":           3,
	"BOOLEAN":          4,
	"RECORD":           5,
	"PLUS_PAGE":        6,
}

func (x DataSourceParameter_Type) String() string {
	return proto.EnumName(DataSourceParameter_Type_name, int32(x))
}

func (DataSourceParameter_Type) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{0, 0}
}

// The type of authorization needed for this data source.
type DataSource_AuthorizationType int32

const (
	// Type unspecified.
	DataSource_AUTHORIZATION_TYPE_UNSPECIFIED DataSource_AuthorizationType = 0
	// Use OAuth 2 authorization codes that can be exchanged
	// for a refresh token on the backend.
	DataSource_AUTHORIZATION_CODE DataSource_AuthorizationType = 1
	// Return an authorization code for a given Google+ page that can then be
	// exchanged for a refresh token on the backend.
	DataSource_GOOGLE_PLUS_AUTHORIZATION_CODE DataSource_AuthorizationType = 2
)

var DataSource_AuthorizationType_name = map[int32]string{
	0: "AUTHORIZATION_TYPE_UNSPECIFIED",
	1: "AUTHORIZATION_CODE",
	2: "GOOGLE_PLUS_AUTHORIZATION_CODE",
}

var DataSource_AuthorizationType_value = map[string]int32{
	"AUTHORIZATION_TYPE_UNSPECIFIED": 0,
	"AUTHORIZATION_CODE":             1,
	"GOOGLE_PLUS_AUTHORIZATION_CODE": 2,
}

func (x DataSource_AuthorizationType) String() string {
	return proto.EnumName(DataSource_AuthorizationType_name, int32(x))
}

func (DataSource_AuthorizationType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{1, 0}
}

// Represents how the data source supports data auto refresh.
type DataSource_DataRefreshType int32

const (
	// The data source won't support data auto refresh, which is default value.
	DataSource_DATA_REFRESH_TYPE_UNSPECIFIED DataSource_DataRefreshType = 0
	// The data source supports data auto refresh, and runs will be scheduled
	// for the past few days. Does not allow custom values to be set for each
	// transfer config.
	DataSource_SLIDING_WINDOW DataSource_DataRefreshType = 1
	// The data source supports data auto refresh, and runs will be scheduled
	// for the past few days. Allows custom values to be set for each transfer
	// config.
	DataSource_CUSTOM_SLIDING_WINDOW DataSource_DataRefreshType = 2
)

var DataSource_DataRefreshType_name = map[int32]string{
	0: "DATA_REFRESH_TYPE_UNSPECIFIED",
	1: "SLIDING_WINDOW",
	2: "CUSTOM_SLIDING_WINDOW",
}

var DataSource_DataRefreshType_value = map[string]int32{
	"DATA_REFRESH_TYPE_UNSPECIFIED": 0,
	"SLIDING_WINDOW":                1,
	"CUSTOM_SLIDING_WINDOW":         2,
}

func (x DataSource_DataRefreshType) String() string {
	return proto.EnumName(DataSource_DataRefreshType_name, int32(x))
}

func (DataSource_DataRefreshType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{1, 1}
}

// Represents which runs should be pulled.
type ListTransferRunsRequest_RunAttempt int32

const (
	// All runs should be returned.
	ListTransferRunsRequest_RUN_ATTEMPT_UNSPECIFIED ListTransferRunsRequest_RunAttempt = 0
	// Only latest run per day should be returned.
	ListTransferRunsRequest_LATEST ListTransferRunsRequest_RunAttempt = 1
)

var ListTransferRunsRequest_RunAttempt_name = map[int32]string{
	0: "RUN_ATTEMPT_UNSPECIFIED",
	1: "LATEST",
}

var ListTransferRunsRequest_RunAttempt_value = map[string]int32{
	"RUN_ATTEMPT_UNSPECIFIED": 0,
	"LATEST":                  1,
}

func (x ListTransferRunsRequest_RunAttempt) String() string {
	return proto.EnumName(ListTransferRunsRequest_RunAttempt_name, int32(x))
}

func (ListTransferRunsRequest_RunAttempt) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{13, 0}
}

// Represents a data source parameter with validation rules, so that
// parameters can be rendered in the UI. These parameters are given to us by
// supported data sources, and include all needed information for rendering
// and validation.
// Thus, whoever uses this api can decide to generate either generic ui,
// or custom data source specific forms.
type DataSourceParameter struct {
	// Parameter identifier.
	ParamId string `protobuf:"bytes,1,opt,name=param_id,json=paramId,proto3" json:"param_id,omitempty"`
	// Parameter display name in the user interface.
	DisplayName string `protobuf:"bytes,2,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// Parameter description.
	Description string `protobuf:"bytes,3,opt,name=description,proto3" json:"description,omitempty"`
	// Parameter type.
	Type DataSourceParameter_Type `protobuf:"varint,4,opt,name=type,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSourceParameter_Type" json:"type,omitempty"`
	// Is parameter required.
	Required bool `protobuf:"varint,5,opt,name=required,proto3" json:"required,omitempty"`
	// Deprecated. This field has no effect.
	Repeated bool `protobuf:"varint,6,opt,name=repeated,proto3" json:"repeated,omitempty"`
	// Regular expression which can be used for parameter validation.
	ValidationRegex string `protobuf:"bytes,7,opt,name=validation_regex,json=validationRegex,proto3" json:"validation_regex,omitempty"`
	// All possible values for the parameter.
	AllowedValues []string `protobuf:"bytes,8,rep,name=allowed_values,json=allowedValues,proto3" json:"allowed_values,omitempty"`
	// For integer and double values specifies minimum allowed value.
	MinValue *wrappers.DoubleValue `protobuf:"bytes,9,opt,name=min_value,json=minValue,proto3" json:"min_value,omitempty"`
	// For integer and double values specifies maxminum allowed value.
	MaxValue *wrappers.DoubleValue `protobuf:"bytes,10,opt,name=max_value,json=maxValue,proto3" json:"max_value,omitempty"`
	// Deprecated. This field has no effect.
	Fields []*DataSourceParameter `protobuf:"bytes,11,rep,name=fields,proto3" json:"fields,omitempty"`
	// Description of the requirements for this field, in case the user input does
	// not fulfill the regex pattern or min/max values.
	ValidationDescription string `protobuf:"bytes,12,opt,name=validation_description,json=validationDescription,proto3" json:"validation_description,omitempty"`
	// URL to a help document to further explain the naming requirements.
	ValidationHelpUrl string `protobuf:"bytes,13,opt,name=validation_help_url,json=validationHelpUrl,proto3" json:"validation_help_url,omitempty"`
	// Cannot be changed after initial creation.
	Immutable bool `protobuf:"varint,14,opt,name=immutable,proto3" json:"immutable,omitempty"`
	// Deprecated. This field has no effect.
	Recurse              bool     `protobuf:"varint,15,opt,name=recurse,proto3" json:"recurse,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataSourceParameter) Reset()         { *m = DataSourceParameter{} }
func (m *DataSourceParameter) String() string { return proto.CompactTextString(m) }
func (*DataSourceParameter) ProtoMessage()    {}
func (*DataSourceParameter) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{0}
}

func (m *DataSourceParameter) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataSourceParameter.Unmarshal(m, b)
}
func (m *DataSourceParameter) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataSourceParameter.Marshal(b, m, deterministic)
}
func (m *DataSourceParameter) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataSourceParameter.Merge(m, src)
}
func (m *DataSourceParameter) XXX_Size() int {
	return xxx_messageInfo_DataSourceParameter.Size(m)
}
func (m *DataSourceParameter) XXX_DiscardUnknown() {
	xxx_messageInfo_DataSourceParameter.DiscardUnknown(m)
}

var xxx_messageInfo_DataSourceParameter proto.InternalMessageInfo

func (m *DataSourceParameter) GetParamId() string {
	if m != nil {
		return m.ParamId
	}
	return ""
}

func (m *DataSourceParameter) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *DataSourceParameter) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DataSourceParameter) GetType() DataSourceParameter_Type {
	if m != nil {
		return m.Type
	}
	return DataSourceParameter_TYPE_UNSPECIFIED
}

func (m *DataSourceParameter) GetRequired() bool {
	if m != nil {
		return m.Required
	}
	return false
}

func (m *DataSourceParameter) GetRepeated() bool {
	if m != nil {
		return m.Repeated
	}
	return false
}

func (m *DataSourceParameter) GetValidationRegex() string {
	if m != nil {
		return m.ValidationRegex
	}
	return ""
}

func (m *DataSourceParameter) GetAllowedValues() []string {
	if m != nil {
		return m.AllowedValues
	}
	return nil
}

func (m *DataSourceParameter) GetMinValue() *wrappers.DoubleValue {
	if m != nil {
		return m.MinValue
	}
	return nil
}

func (m *DataSourceParameter) GetMaxValue() *wrappers.DoubleValue {
	if m != nil {
		return m.MaxValue
	}
	return nil
}

func (m *DataSourceParameter) GetFields() []*DataSourceParameter {
	if m != nil {
		return m.Fields
	}
	return nil
}

func (m *DataSourceParameter) GetValidationDescription() string {
	if m != nil {
		return m.ValidationDescription
	}
	return ""
}

func (m *DataSourceParameter) GetValidationHelpUrl() string {
	if m != nil {
		return m.ValidationHelpUrl
	}
	return ""
}

func (m *DataSourceParameter) GetImmutable() bool {
	if m != nil {
		return m.Immutable
	}
	return false
}

func (m *DataSourceParameter) GetRecurse() bool {
	if m != nil {
		return m.Recurse
	}
	return false
}

// Represents data source metadata. Metadata is sufficient to
// render UI and request proper OAuth tokens.
type DataSource struct {
	// Output only. Data source resource name.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Data source id.
	DataSourceId string `protobuf:"bytes,2,opt,name=data_source_id,json=dataSourceId,proto3" json:"data_source_id,omitempty"`
	// User friendly data source name.
	DisplayName string `protobuf:"bytes,3,opt,name=display_name,json=displayName,proto3" json:"display_name,omitempty"`
	// User friendly data source description string.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Data source client id which should be used to receive refresh token.
	ClientId string `protobuf:"bytes,5,opt,name=client_id,json=clientId,proto3" json:"client_id,omitempty"`
	// Api auth scopes for which refresh token needs to be obtained. These are
	// scopes needed by a data source to prepare data and ingest them into
	// BigQuery, e.g., https://www.googleapis.com/auth/bigquery
	Scopes []string `protobuf:"bytes,6,rep,name=scopes,proto3" json:"scopes,omitempty"`
	// Deprecated. This field has no effect.
	TransferType TransferType `protobuf:"varint,7,opt,name=transfer_type,json=transferType,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferType" json:"transfer_type,omitempty"` // Deprecated: Do not use.
	// Deprecated. This field has no effect.
	SupportsMultipleTransfers bool `protobuf:"varint,8,opt,name=supports_multiple_transfers,json=supportsMultipleTransfers,proto3" json:"supports_multiple_transfers,omitempty"` // Deprecated: Do not use.
	// The number of seconds to wait for an update from the data source
	// before the Data Transfer Service marks the transfer as FAILED.
	UpdateDeadlineSeconds int32 `protobuf:"varint,9,opt,name=update_deadline_seconds,json=updateDeadlineSeconds,proto3" json:"update_deadline_seconds,omitempty"`
	// Default data transfer schedule.
	// Examples of valid schedules include:
	// `1st,3rd monday of month 15:30`,
	// `every wed,fri of jan,jun 13:15`, and
	// `first sunday of quarter 00:00`.
	DefaultSchedule string `protobuf:"bytes,10,opt,name=default_schedule,json=defaultSchedule,proto3" json:"default_schedule,omitempty"`
	// Specifies whether the data source supports a user defined schedule, or
	// operates on the default schedule.
	// When set to `true`, user can override default schedule.
	SupportsCustomSchedule bool `protobuf:"varint,11,opt,name=supports_custom_schedule,json=supportsCustomSchedule,proto3" json:"supports_custom_schedule,omitempty"`
	// Data source parameters.
	Parameters []*DataSourceParameter `protobuf:"bytes,12,rep,name=parameters,proto3" json:"parameters,omitempty"`
	// Url for the help document for this data source.
	HelpUrl string `protobuf:"bytes,13,opt,name=help_url,json=helpUrl,proto3" json:"help_url,omitempty"`
	// Indicates the type of authorization.
	AuthorizationType DataSource_AuthorizationType `protobuf:"varint,14,opt,name=authorization_type,json=authorizationType,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSource_AuthorizationType" json:"authorization_type,omitempty"`
	// Specifies whether the data source supports automatic data refresh for the
	// past few days, and how it's supported.
	// For some data sources, data might not be complete until a few days later,
	// so it's useful to refresh data automatically.
	DataRefreshType DataSource_DataRefreshType `protobuf:"varint,15,opt,name=data_refresh_type,json=dataRefreshType,proto3,enum=google.cloud.bigquery.datatransfer.v1.DataSource_DataRefreshType" json:"data_refresh_type,omitempty"`
	// Default data refresh window on days.
	// Only meaningful when `data_refresh_type` = `SLIDING_WINDOW`.
	DefaultDataRefreshWindowDays int32 `protobuf:"varint,16,opt,name=default_data_refresh_window_days,json=defaultDataRefreshWindowDays,proto3" json:"default_data_refresh_window_days,omitempty"`
	// Disables backfilling and manual run scheduling
	// for the data source.
	ManualRunsDisabled bool `protobuf:"varint,17,opt,name=manual_runs_disabled,json=manualRunsDisabled,proto3" json:"manual_runs_disabled,omitempty"`
	// The minimum interval for scheduler to schedule runs.
	MinimumScheduleInterval *duration.Duration `protobuf:"bytes,18,opt,name=minimum_schedule_interval,json=minimumScheduleInterval,proto3" json:"minimum_schedule_interval,omitempty"`
	// Partner's legal name of this data source
	PartnerLegalName string `protobuf:"bytes,22,opt,name=partner_legal_name,json=partnerLegalName,proto3" json:"partner_legal_name,omitempty"`
	// Redirect URL to complete transfer config setup for 3rd party data sources.
	RedirectUrl          string   `protobuf:"bytes,23,opt,name=redirect_url,json=redirectUrl,proto3" json:"redirect_url,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DataSource) Reset()         { *m = DataSource{} }
func (m *DataSource) String() string { return proto.CompactTextString(m) }
func (*DataSource) ProtoMessage()    {}
func (*DataSource) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{1}
}

func (m *DataSource) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DataSource.Unmarshal(m, b)
}
func (m *DataSource) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DataSource.Marshal(b, m, deterministic)
}
func (m *DataSource) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DataSource.Merge(m, src)
}
func (m *DataSource) XXX_Size() int {
	return xxx_messageInfo_DataSource.Size(m)
}
func (m *DataSource) XXX_DiscardUnknown() {
	xxx_messageInfo_DataSource.DiscardUnknown(m)
}

var xxx_messageInfo_DataSource proto.InternalMessageInfo

func (m *DataSource) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

func (m *DataSource) GetDataSourceId() string {
	if m != nil {
		return m.DataSourceId
	}
	return ""
}

func (m *DataSource) GetDisplayName() string {
	if m != nil {
		return m.DisplayName
	}
	return ""
}

func (m *DataSource) GetDescription() string {
	if m != nil {
		return m.Description
	}
	return ""
}

func (m *DataSource) GetClientId() string {
	if m != nil {
		return m.ClientId
	}
	return ""
}

func (m *DataSource) GetScopes() []string {
	if m != nil {
		return m.Scopes
	}
	return nil
}

// Deprecated: Do not use.
func (m *DataSource) GetTransferType() TransferType {
	if m != nil {
		return m.TransferType
	}
	return TransferType_TRANSFER_TYPE_UNSPECIFIED
}

// Deprecated: Do not use.
func (m *DataSource) GetSupportsMultipleTransfers() bool {
	if m != nil {
		return m.SupportsMultipleTransfers
	}
	return false
}

func (m *DataSource) GetUpdateDeadlineSeconds() int32 {
	if m != nil {
		return m.UpdateDeadlineSeconds
	}
	return 0
}

func (m *DataSource) GetDefaultSchedule() string {
	if m != nil {
		return m.DefaultSchedule
	}
	return ""
}

func (m *DataSource) GetSupportsCustomSchedule() bool {
	if m != nil {
		return m.SupportsCustomSchedule
	}
	return false
}

func (m *DataSource) GetParameters() []*DataSourceParameter {
	if m != nil {
		return m.Parameters
	}
	return nil
}

func (m *DataSource) GetHelpUrl() string {
	if m != nil {
		return m.HelpUrl
	}
	return ""
}

func (m *DataSource) GetAuthorizationType() DataSource_AuthorizationType {
	if m != nil {
		return m.AuthorizationType
	}
	return DataSource_AUTHORIZATION_TYPE_UNSPECIFIED
}

func (m *DataSource) GetDataRefreshType() DataSource_DataRefreshType {
	if m != nil {
		return m.DataRefreshType
	}
	return DataSource_DATA_REFRESH_TYPE_UNSPECIFIED
}

func (m *DataSource) GetDefaultDataRefreshWindowDays() int32 {
	if m != nil {
		return m.DefaultDataRefreshWindowDays
	}
	return 0
}

func (m *DataSource) GetManualRunsDisabled() bool {
	if m != nil {
		return m.ManualRunsDisabled
	}
	return false
}

func (m *DataSource) GetMinimumScheduleInterval() *duration.Duration {
	if m != nil {
		return m.MinimumScheduleInterval
	}
	return nil
}

func (m *DataSource) GetPartnerLegalName() string {
	if m != nil {
		return m.PartnerLegalName
	}
	return ""
}

func (m *DataSource) GetRedirectUrl() string {
	if m != nil {
		return m.RedirectUrl
	}
	return ""
}

// A request to get data source info.
type GetDataSourceRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/dataSources/{data_source_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetDataSourceRequest) Reset()         { *m = GetDataSourceRequest{} }
func (m *GetDataSourceRequest) String() string { return proto.CompactTextString(m) }
func (*GetDataSourceRequest) ProtoMessage()    {}
func (*GetDataSourceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{2}
}

func (m *GetDataSourceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetDataSourceRequest.Unmarshal(m, b)
}
func (m *GetDataSourceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetDataSourceRequest.Marshal(b, m, deterministic)
}
func (m *GetDataSourceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetDataSourceRequest.Merge(m, src)
}
func (m *GetDataSourceRequest) XXX_Size() int {
	return xxx_messageInfo_GetDataSourceRequest.Size(m)
}
func (m *GetDataSourceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetDataSourceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetDataSourceRequest proto.InternalMessageInfo

func (m *GetDataSourceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// Request to list supported data sources and their data transfer settings.
type ListDataSourcesRequest struct {
	// The BigQuery project id for which data sources should be returned.
	// Must be in the form: `projects/{project_id}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListDataSourcesRequest` list results. For multiple-page
	// results, `ListDataSourcesResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize             int32    `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDataSourcesRequest) Reset()         { *m = ListDataSourcesRequest{} }
func (m *ListDataSourcesRequest) String() string { return proto.CompactTextString(m) }
func (*ListDataSourcesRequest) ProtoMessage()    {}
func (*ListDataSourcesRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{3}
}

func (m *ListDataSourcesRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDataSourcesRequest.Unmarshal(m, b)
}
func (m *ListDataSourcesRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDataSourcesRequest.Marshal(b, m, deterministic)
}
func (m *ListDataSourcesRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDataSourcesRequest.Merge(m, src)
}
func (m *ListDataSourcesRequest) XXX_Size() int {
	return xxx_messageInfo_ListDataSourcesRequest.Size(m)
}
func (m *ListDataSourcesRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDataSourcesRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListDataSourcesRequest proto.InternalMessageInfo

func (m *ListDataSourcesRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListDataSourcesRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListDataSourcesRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// Returns list of supported data sources and their metadata.
type ListDataSourcesResponse struct {
	// List of supported data sources and their transfer settings.
	DataSources []*DataSource `protobuf:"bytes,1,rep,name=data_sources,json=dataSources,proto3" json:"data_sources,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListDataSourcesRequest.page_token`
	// to request the next page of list results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListDataSourcesResponse) Reset()         { *m = ListDataSourcesResponse{} }
func (m *ListDataSourcesResponse) String() string { return proto.CompactTextString(m) }
func (*ListDataSourcesResponse) ProtoMessage()    {}
func (*ListDataSourcesResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{4}
}

func (m *ListDataSourcesResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListDataSourcesResponse.Unmarshal(m, b)
}
func (m *ListDataSourcesResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListDataSourcesResponse.Marshal(b, m, deterministic)
}
func (m *ListDataSourcesResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListDataSourcesResponse.Merge(m, src)
}
func (m *ListDataSourcesResponse) XXX_Size() int {
	return xxx_messageInfo_ListDataSourcesResponse.Size(m)
}
func (m *ListDataSourcesResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListDataSourcesResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListDataSourcesResponse proto.InternalMessageInfo

func (m *ListDataSourcesResponse) GetDataSources() []*DataSource {
	if m != nil {
		return m.DataSources
	}
	return nil
}

func (m *ListDataSourcesResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to create a data transfer configuration. If new credentials are
// needed for this transfer configuration, an authorization code must be
// provided. If an authorization code is provided, the transfer configuration
// will be associated with the user id corresponding to the
// authorization code. Otherwise, the transfer configuration will be associated
// with the calling user.
type CreateTransferConfigRequest struct {
	// The BigQuery project id where the transfer configuration should be created.
	// Must be in the format projects/{project_id}/locations/{location_id}
	// If specified location and location of the destination bigquery dataset
	// do not match - the request will fail.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Data transfer configuration to create.
	TransferConfig *TransferConfig `protobuf:"bytes,2,opt,name=transfer_config,json=transferConfig,proto3" json:"transfer_config,omitempty"`
	// Optional OAuth2 authorization code to use with this transfer configuration.
	// This is required if new credentials are needed, as indicated by
	// `CheckValidCreds`.
	// In order to obtain authorization_code, please make a
	// request to
	// https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?client_id=<datatransferapiclientid>&scope=<data_source_scopes>&redirect_uri=<redirect_uri>
	//
	// * client_id should be OAuth client_id of BigQuery DTS API for the given
	//   data source returned by ListDataSources method.
	// * data_source_scopes are the scopes returned by ListDataSources method.
	// * redirect_uri is an optional parameter. If not specified, then
	//   authorization code is posted to the opener of authorization flow window.
	//   Otherwise it will be sent to the redirect uri. A special value of
	//   urn:ietf:wg:oauth:2.0:oob means that authorization code should be
	//   returned in the title bar of the browser, with the page text prompting
	//   the user to copy the code and paste it in the application.
	AuthorizationCode string `protobuf:"bytes,3,opt,name=authorization_code,json=authorizationCode,proto3" json:"authorization_code,omitempty"`
	// Optional version info. If users want to find a very recent access token,
	// that is, immediately after approving access, users have to set the
	// version_info claim in the token request. To obtain the version_info, users
	// must use the "none+gsession" response type. which be return a
	// version_info back in the authorization response which be be put in a JWT
	// claim in the token request.
	VersionInfo          string   `protobuf:"bytes,5,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CreateTransferConfigRequest) Reset()         { *m = CreateTransferConfigRequest{} }
func (m *CreateTransferConfigRequest) String() string { return proto.CompactTextString(m) }
func (*CreateTransferConfigRequest) ProtoMessage()    {}
func (*CreateTransferConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{5}
}

func (m *CreateTransferConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CreateTransferConfigRequest.Unmarshal(m, b)
}
func (m *CreateTransferConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CreateTransferConfigRequest.Marshal(b, m, deterministic)
}
func (m *CreateTransferConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CreateTransferConfigRequest.Merge(m, src)
}
func (m *CreateTransferConfigRequest) XXX_Size() int {
	return xxx_messageInfo_CreateTransferConfigRequest.Size(m)
}
func (m *CreateTransferConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CreateTransferConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CreateTransferConfigRequest proto.InternalMessageInfo

func (m *CreateTransferConfigRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *CreateTransferConfigRequest) GetTransferConfig() *TransferConfig {
	if m != nil {
		return m.TransferConfig
	}
	return nil
}

func (m *CreateTransferConfigRequest) GetAuthorizationCode() string {
	if m != nil {
		return m.AuthorizationCode
	}
	return ""
}

func (m *CreateTransferConfigRequest) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

// A request to update a transfer configuration. To update the user id of the
// transfer configuration, an authorization code needs to be provided.
type UpdateTransferConfigRequest struct {
	// Data transfer configuration to create.
	TransferConfig *TransferConfig `protobuf:"bytes,1,opt,name=transfer_config,json=transferConfig,proto3" json:"transfer_config,omitempty"`
	// Optional OAuth2 authorization code to use with this transfer configuration.
	// If it is provided, the transfer configuration will be associated with the
	// authorizing user.
	// In order to obtain authorization_code, please make a
	// request to
	// https://www.gstatic.com/bigquerydatatransfer/oauthz/auth?client_id=<datatransferapiclientid>&scope=<data_source_scopes>&redirect_uri=<redirect_uri>
	//
	// * client_id should be OAuth client_id of BigQuery DTS API for the given
	//   data source returned by ListDataSources method.
	// * data_source_scopes are the scopes returned by ListDataSources method.
	// * redirect_uri is an optional parameter. If not specified, then
	//   authorization code is posted to the opener of authorization flow window.
	//   Otherwise it will be sent to the redirect uri. A special value of
	//   urn:ietf:wg:oauth:2.0:oob means that authorization code should be
	//   returned in the title bar of the browser, with the page text prompting
	//   the user to copy the code and paste it in the application.
	AuthorizationCode string `protobuf:"bytes,3,opt,name=authorization_code,json=authorizationCode,proto3" json:"authorization_code,omitempty"`
	// Required list of fields to be updated in this request.
	UpdateMask *field_mask.FieldMask `protobuf:"bytes,4,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Optional version info. If users want to find a very recent access token,
	// that is, immediately after approving access, users have to set the
	// version_info claim in the token request. To obtain the version_info, users
	// must use the "none+gsession" response type. which be return a
	// version_info back in the authorization response which be be put in a JWT
	// claim in the token request.
	VersionInfo          string   `protobuf:"bytes,5,opt,name=version_info,json=versionInfo,proto3" json:"version_info,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *UpdateTransferConfigRequest) Reset()         { *m = UpdateTransferConfigRequest{} }
func (m *UpdateTransferConfigRequest) String() string { return proto.CompactTextString(m) }
func (*UpdateTransferConfigRequest) ProtoMessage()    {}
func (*UpdateTransferConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{6}
}

func (m *UpdateTransferConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_UpdateTransferConfigRequest.Unmarshal(m, b)
}
func (m *UpdateTransferConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_UpdateTransferConfigRequest.Marshal(b, m, deterministic)
}
func (m *UpdateTransferConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_UpdateTransferConfigRequest.Merge(m, src)
}
func (m *UpdateTransferConfigRequest) XXX_Size() int {
	return xxx_messageInfo_UpdateTransferConfigRequest.Size(m)
}
func (m *UpdateTransferConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_UpdateTransferConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_UpdateTransferConfigRequest proto.InternalMessageInfo

func (m *UpdateTransferConfigRequest) GetTransferConfig() *TransferConfig {
	if m != nil {
		return m.TransferConfig
	}
	return nil
}

func (m *UpdateTransferConfigRequest) GetAuthorizationCode() string {
	if m != nil {
		return m.AuthorizationCode
	}
	return ""
}

func (m *UpdateTransferConfigRequest) GetUpdateMask() *field_mask.FieldMask {
	if m != nil {
		return m.UpdateMask
	}
	return nil
}

func (m *UpdateTransferConfigRequest) GetVersionInfo() string {
	if m != nil {
		return m.VersionInfo
	}
	return ""
}

// A request to get data transfer information.
type GetTransferConfigRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTransferConfigRequest) Reset()         { *m = GetTransferConfigRequest{} }
func (m *GetTransferConfigRequest) String() string { return proto.CompactTextString(m) }
func (*GetTransferConfigRequest) ProtoMessage()    {}
func (*GetTransferConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{7}
}

func (m *GetTransferConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTransferConfigRequest.Unmarshal(m, b)
}
func (m *GetTransferConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTransferConfigRequest.Marshal(b, m, deterministic)
}
func (m *GetTransferConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTransferConfigRequest.Merge(m, src)
}
func (m *GetTransferConfigRequest) XXX_Size() int {
	return xxx_messageInfo_GetTransferConfigRequest.Size(m)
}
func (m *GetTransferConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTransferConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTransferConfigRequest proto.InternalMessageInfo

func (m *GetTransferConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to delete data transfer information. All associated transfer runs
// and log messages will be deleted as well.
type DeleteTransferConfigRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTransferConfigRequest) Reset()         { *m = DeleteTransferConfigRequest{} }
func (m *DeleteTransferConfigRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTransferConfigRequest) ProtoMessage()    {}
func (*DeleteTransferConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{8}
}

func (m *DeleteTransferConfigRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTransferConfigRequest.Unmarshal(m, b)
}
func (m *DeleteTransferConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTransferConfigRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTransferConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTransferConfigRequest.Merge(m, src)
}
func (m *DeleteTransferConfigRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTransferConfigRequest.Size(m)
}
func (m *DeleteTransferConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTransferConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTransferConfigRequest proto.InternalMessageInfo

func (m *DeleteTransferConfigRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to get data transfer run information.
type GetTransferRunRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *GetTransferRunRequest) Reset()         { *m = GetTransferRunRequest{} }
func (m *GetTransferRunRequest) String() string { return proto.CompactTextString(m) }
func (*GetTransferRunRequest) ProtoMessage()    {}
func (*GetTransferRunRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{9}
}

func (m *GetTransferRunRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_GetTransferRunRequest.Unmarshal(m, b)
}
func (m *GetTransferRunRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_GetTransferRunRequest.Marshal(b, m, deterministic)
}
func (m *GetTransferRunRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GetTransferRunRequest.Merge(m, src)
}
func (m *GetTransferRunRequest) XXX_Size() int {
	return xxx_messageInfo_GetTransferRunRequest.Size(m)
}
func (m *GetTransferRunRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GetTransferRunRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GetTransferRunRequest proto.InternalMessageInfo

func (m *GetTransferRunRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to delete data transfer run information.
type DeleteTransferRunRequest struct {
	// The field will contain name of the resource requested, for example:
	// `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *DeleteTransferRunRequest) Reset()         { *m = DeleteTransferRunRequest{} }
func (m *DeleteTransferRunRequest) String() string { return proto.CompactTextString(m) }
func (*DeleteTransferRunRequest) ProtoMessage()    {}
func (*DeleteTransferRunRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{10}
}

func (m *DeleteTransferRunRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_DeleteTransferRunRequest.Unmarshal(m, b)
}
func (m *DeleteTransferRunRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_DeleteTransferRunRequest.Marshal(b, m, deterministic)
}
func (m *DeleteTransferRunRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_DeleteTransferRunRequest.Merge(m, src)
}
func (m *DeleteTransferRunRequest) XXX_Size() int {
	return xxx_messageInfo_DeleteTransferRunRequest.Size(m)
}
func (m *DeleteTransferRunRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_DeleteTransferRunRequest.DiscardUnknown(m)
}

var xxx_messageInfo_DeleteTransferRunRequest proto.InternalMessageInfo

func (m *DeleteTransferRunRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to list data transfers configured for a BigQuery project.
type ListTransferConfigsRequest struct {
	// The BigQuery project id for which data sources
	// should be returned: `projects/{project_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When specified, only configurations of requested data sources are returned.
	DataSourceIds []string `protobuf:"bytes,2,rep,name=data_source_ids,json=dataSourceIds,proto3" json:"data_source_ids,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransfersRequest` list results. For multiple-page
	// results, `ListTransfersResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize             int32    `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTransferConfigsRequest) Reset()         { *m = ListTransferConfigsRequest{} }
func (m *ListTransferConfigsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTransferConfigsRequest) ProtoMessage()    {}
func (*ListTransferConfigsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{11}
}

func (m *ListTransferConfigsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferConfigsRequest.Unmarshal(m, b)
}
func (m *ListTransferConfigsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferConfigsRequest.Marshal(b, m, deterministic)
}
func (m *ListTransferConfigsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferConfigsRequest.Merge(m, src)
}
func (m *ListTransferConfigsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTransferConfigsRequest.Size(m)
}
func (m *ListTransferConfigsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferConfigsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferConfigsRequest proto.InternalMessageInfo

func (m *ListTransferConfigsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferConfigsRequest) GetDataSourceIds() []string {
	if m != nil {
		return m.DataSourceIds
	}
	return nil
}

func (m *ListTransferConfigsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferConfigsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

// The returned list of pipelines in the project.
type ListTransferConfigsResponse struct {
	// Output only. The stored pipeline transfer configurations.
	TransferConfigs []*TransferConfig `protobuf:"bytes,1,rep,name=transfer_configs,json=transferConfigs,proto3" json:"transfer_configs,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListTransferConfigsRequest.page_token`
	// to request the next page of list results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTransferConfigsResponse) Reset()         { *m = ListTransferConfigsResponse{} }
func (m *ListTransferConfigsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTransferConfigsResponse) ProtoMessage()    {}
func (*ListTransferConfigsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{12}
}

func (m *ListTransferConfigsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferConfigsResponse.Unmarshal(m, b)
}
func (m *ListTransferConfigsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferConfigsResponse.Marshal(b, m, deterministic)
}
func (m *ListTransferConfigsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferConfigsResponse.Merge(m, src)
}
func (m *ListTransferConfigsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTransferConfigsResponse.Size(m)
}
func (m *ListTransferConfigsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferConfigsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferConfigsResponse proto.InternalMessageInfo

func (m *ListTransferConfigsResponse) GetTransferConfigs() []*TransferConfig {
	if m != nil {
		return m.TransferConfigs
	}
	return nil
}

func (m *ListTransferConfigsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to list data transfer runs. UI can use this method to show/filter
// specific data transfer runs. The data source can use this method to request
// all scheduled transfer runs.
type ListTransferRunsRequest struct {
	// Name of transfer configuration for which transfer runs should be retrieved.
	// Format of transfer configuration resource name is:
	// `projects/{project_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// When specified, only transfer runs with requested states are returned.
	States []TransferState `protobuf:"varint,2,rep,packed,name=states,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferState" json:"states,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransferRunsRequest` list results. For multiple-page
	// results, `ListTransferRunsResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Indicates how run attempts are to be pulled.
	RunAttempt           ListTransferRunsRequest_RunAttempt `protobuf:"varint,5,opt,name=run_attempt,json=runAttempt,proto3,enum=google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest_RunAttempt" json:"run_attempt,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                           `json:"-"`
	XXX_unrecognized     []byte                             `json:"-"`
	XXX_sizecache        int32                              `json:"-"`
}

func (m *ListTransferRunsRequest) Reset()         { *m = ListTransferRunsRequest{} }
func (m *ListTransferRunsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTransferRunsRequest) ProtoMessage()    {}
func (*ListTransferRunsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{13}
}

func (m *ListTransferRunsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferRunsRequest.Unmarshal(m, b)
}
func (m *ListTransferRunsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferRunsRequest.Marshal(b, m, deterministic)
}
func (m *ListTransferRunsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferRunsRequest.Merge(m, src)
}
func (m *ListTransferRunsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTransferRunsRequest.Size(m)
}
func (m *ListTransferRunsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferRunsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferRunsRequest proto.InternalMessageInfo

func (m *ListTransferRunsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferRunsRequest) GetStates() []TransferState {
	if m != nil {
		return m.States
	}
	return nil
}

func (m *ListTransferRunsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferRunsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTransferRunsRequest) GetRunAttempt() ListTransferRunsRequest_RunAttempt {
	if m != nil {
		return m.RunAttempt
	}
	return ListTransferRunsRequest_RUN_ATTEMPT_UNSPECIFIED
}

// The returned list of pipelines in the project.
type ListTransferRunsResponse struct {
	// Output only. The stored pipeline transfer runs.
	TransferRuns []*TransferRun `protobuf:"bytes,1,rep,name=transfer_runs,json=transferRuns,proto3" json:"transfer_runs,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `ListTransferRunsRequest.page_token`
	// to request the next page of list results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTransferRunsResponse) Reset()         { *m = ListTransferRunsResponse{} }
func (m *ListTransferRunsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTransferRunsResponse) ProtoMessage()    {}
func (*ListTransferRunsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{14}
}

func (m *ListTransferRunsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferRunsResponse.Unmarshal(m, b)
}
func (m *ListTransferRunsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferRunsResponse.Marshal(b, m, deterministic)
}
func (m *ListTransferRunsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferRunsResponse.Merge(m, src)
}
func (m *ListTransferRunsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTransferRunsResponse.Size(m)
}
func (m *ListTransferRunsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferRunsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferRunsResponse proto.InternalMessageInfo

func (m *ListTransferRunsResponse) GetTransferRuns() []*TransferRun {
	if m != nil {
		return m.TransferRuns
	}
	return nil
}

func (m *ListTransferRunsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to get user facing log messages associated with data transfer run.
type ListTransferLogsRequest struct {
	// Transfer run name in the form:
	// `projects/{project_id}/transferConfigs/{config_Id}/runs/{run_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Pagination token, which can be used to request a specific page
	// of `ListTransferLogsRequest` list results. For multiple-page
	// results, `ListTransferLogsResponse` outputs
	// a `next_page` token, which can be used as the
	// `page_token` value to request the next page of list results.
	PageToken string `protobuf:"bytes,4,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Page size. The default page size is the maximum value of 1000 results.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Message types to return. If not populated - INFO, WARNING and ERROR
	// messages are returned.
	MessageTypes         []TransferMessage_MessageSeverity `protobuf:"varint,6,rep,packed,name=message_types,json=messageTypes,proto3,enum=google.cloud.bigquery.datatransfer.v1.TransferMessage_MessageSeverity" json:"message_types,omitempty"`
	XXX_NoUnkeyedLiteral struct{}                          `json:"-"`
	XXX_unrecognized     []byte                            `json:"-"`
	XXX_sizecache        int32                             `json:"-"`
}

func (m *ListTransferLogsRequest) Reset()         { *m = ListTransferLogsRequest{} }
func (m *ListTransferLogsRequest) String() string { return proto.CompactTextString(m) }
func (*ListTransferLogsRequest) ProtoMessage()    {}
func (*ListTransferLogsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{15}
}

func (m *ListTransferLogsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferLogsRequest.Unmarshal(m, b)
}
func (m *ListTransferLogsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferLogsRequest.Marshal(b, m, deterministic)
}
func (m *ListTransferLogsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferLogsRequest.Merge(m, src)
}
func (m *ListTransferLogsRequest) XXX_Size() int {
	return xxx_messageInfo_ListTransferLogsRequest.Size(m)
}
func (m *ListTransferLogsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferLogsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferLogsRequest proto.InternalMessageInfo

func (m *ListTransferLogsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ListTransferLogsRequest) GetPageToken() string {
	if m != nil {
		return m.PageToken
	}
	return ""
}

func (m *ListTransferLogsRequest) GetPageSize() int32 {
	if m != nil {
		return m.PageSize
	}
	return 0
}

func (m *ListTransferLogsRequest) GetMessageTypes() []TransferMessage_MessageSeverity {
	if m != nil {
		return m.MessageTypes
	}
	return nil
}

// The returned list transfer run messages.
type ListTransferLogsResponse struct {
	// Output only. The stored pipeline transfer messages.
	TransferMessages []*TransferMessage `protobuf:"bytes,1,rep,name=transfer_messages,json=transferMessages,proto3" json:"transfer_messages,omitempty"`
	// Output only. The next-pagination token. For multiple-page list results,
	// this token can be used as the
	// `GetTransferRunLogRequest.page_token`
	// to request the next page of list results.
	NextPageToken        string   `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *ListTransferLogsResponse) Reset()         { *m = ListTransferLogsResponse{} }
func (m *ListTransferLogsResponse) String() string { return proto.CompactTextString(m) }
func (*ListTransferLogsResponse) ProtoMessage()    {}
func (*ListTransferLogsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{16}
}

func (m *ListTransferLogsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ListTransferLogsResponse.Unmarshal(m, b)
}
func (m *ListTransferLogsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ListTransferLogsResponse.Marshal(b, m, deterministic)
}
func (m *ListTransferLogsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ListTransferLogsResponse.Merge(m, src)
}
func (m *ListTransferLogsResponse) XXX_Size() int {
	return xxx_messageInfo_ListTransferLogsResponse.Size(m)
}
func (m *ListTransferLogsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ListTransferLogsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ListTransferLogsResponse proto.InternalMessageInfo

func (m *ListTransferLogsResponse) GetTransferMessages() []*TransferMessage {
	if m != nil {
		return m.TransferMessages
	}
	return nil
}

func (m *ListTransferLogsResponse) GetNextPageToken() string {
	if m != nil {
		return m.NextPageToken
	}
	return ""
}

// A request to determine whether the user has valid credentials. This method
// is used to limit the number of OAuth popups in the user interface. The
// user id is inferred from the API call context.
// If the data source has the Google+ authorization type, this method
// returns false, as it cannot be determined whether the credentials are
// already valid merely based on the user id.
type CheckValidCredsRequest struct {
	// The data source in the form:
	// `projects/{project_id}/dataSources/{data_source_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckValidCredsRequest) Reset()         { *m = CheckValidCredsRequest{} }
func (m *CheckValidCredsRequest) String() string { return proto.CompactTextString(m) }
func (*CheckValidCredsRequest) ProtoMessage()    {}
func (*CheckValidCredsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{17}
}

func (m *CheckValidCredsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckValidCredsRequest.Unmarshal(m, b)
}
func (m *CheckValidCredsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckValidCredsRequest.Marshal(b, m, deterministic)
}
func (m *CheckValidCredsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckValidCredsRequest.Merge(m, src)
}
func (m *CheckValidCredsRequest) XXX_Size() int {
	return xxx_messageInfo_CheckValidCredsRequest.Size(m)
}
func (m *CheckValidCredsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckValidCredsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_CheckValidCredsRequest proto.InternalMessageInfo

func (m *CheckValidCredsRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A response indicating whether the credentials exist and are valid.
type CheckValidCredsResponse struct {
	// If set to `true`, the credentials exist and are valid.
	HasValidCreds        bool     `protobuf:"varint,1,opt,name=has_valid_creds,json=hasValidCreds,proto3" json:"has_valid_creds,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *CheckValidCredsResponse) Reset()         { *m = CheckValidCredsResponse{} }
func (m *CheckValidCredsResponse) String() string { return proto.CompactTextString(m) }
func (*CheckValidCredsResponse) ProtoMessage()    {}
func (*CheckValidCredsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{18}
}

func (m *CheckValidCredsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_CheckValidCredsResponse.Unmarshal(m, b)
}
func (m *CheckValidCredsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_CheckValidCredsResponse.Marshal(b, m, deterministic)
}
func (m *CheckValidCredsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CheckValidCredsResponse.Merge(m, src)
}
func (m *CheckValidCredsResponse) XXX_Size() int {
	return xxx_messageInfo_CheckValidCredsResponse.Size(m)
}
func (m *CheckValidCredsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_CheckValidCredsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_CheckValidCredsResponse proto.InternalMessageInfo

func (m *CheckValidCredsResponse) GetHasValidCreds() bool {
	if m != nil {
		return m.HasValidCreds
	}
	return false
}

// A request to schedule transfer runs for a time range.
type ScheduleTransferRunsRequest struct {
	// Transfer configuration name in the form:
	// `projects/{project_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// User labels to add to the scheduled runs.
	Labels map[string]string `protobuf:"bytes,6,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Start time of the range of transfer runs. For example,
	// `"2017-05-25T00:00:00+00:00"`.
	StartTime *timestamp.Timestamp `protobuf:"bytes,2,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the range of transfer runs. For example,
	// `"2017-05-30T00:00:00+00:00"`.
	EndTime              *timestamp.Timestamp `protobuf:"bytes,3,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *ScheduleTransferRunsRequest) Reset()         { *m = ScheduleTransferRunsRequest{} }
func (m *ScheduleTransferRunsRequest) String() string { return proto.CompactTextString(m) }
func (*ScheduleTransferRunsRequest) ProtoMessage()    {}
func (*ScheduleTransferRunsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{19}
}

func (m *ScheduleTransferRunsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScheduleTransferRunsRequest.Unmarshal(m, b)
}
func (m *ScheduleTransferRunsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScheduleTransferRunsRequest.Marshal(b, m, deterministic)
}
func (m *ScheduleTransferRunsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleTransferRunsRequest.Merge(m, src)
}
func (m *ScheduleTransferRunsRequest) XXX_Size() int {
	return xxx_messageInfo_ScheduleTransferRunsRequest.Size(m)
}
func (m *ScheduleTransferRunsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleTransferRunsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleTransferRunsRequest proto.InternalMessageInfo

func (m *ScheduleTransferRunsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *ScheduleTransferRunsRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

func (m *ScheduleTransferRunsRequest) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *ScheduleTransferRunsRequest) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// A response to schedule transfer runs for a time range.
type ScheduleTransferRunsResponse struct {
	// The transfer runs that were scheduled.
	Runs                 []*TransferRun `protobuf:"bytes,1,rep,name=runs,proto3" json:"runs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *ScheduleTransferRunsResponse) Reset()         { *m = ScheduleTransferRunsResponse{} }
func (m *ScheduleTransferRunsResponse) String() string { return proto.CompactTextString(m) }
func (*ScheduleTransferRunsResponse) ProtoMessage()    {}
func (*ScheduleTransferRunsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{20}
}

func (m *ScheduleTransferRunsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_ScheduleTransferRunsResponse.Unmarshal(m, b)
}
func (m *ScheduleTransferRunsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_ScheduleTransferRunsResponse.Marshal(b, m, deterministic)
}
func (m *ScheduleTransferRunsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ScheduleTransferRunsResponse.Merge(m, src)
}
func (m *ScheduleTransferRunsResponse) XXX_Size() int {
	return xxx_messageInfo_ScheduleTransferRunsResponse.Size(m)
}
func (m *ScheduleTransferRunsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_ScheduleTransferRunsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_ScheduleTransferRunsResponse proto.InternalMessageInfo

func (m *ScheduleTransferRunsResponse) GetRuns() []*TransferRun {
	if m != nil {
		return m.Runs
	}
	return nil
}

// A request to start manual transfer runs.
type StartManualTransferRunsRequest struct {
	// Transfer configuration name in the form:
	// `projects/{project_id}/transferConfigs/{config_id}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// User labels to add to the backfilled runs.
	Labels map[string]string `protobuf:"bytes,2,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The requested time specification - this can be a time range or a specific
	// run_time.
	//
	// Types that are valid to be assigned to Time:
	//	*StartManualTransferRunsRequest_RequestedTimeRange
	//	*StartManualTransferRunsRequest_RequestedRunTime
	Time                 isStartManualTransferRunsRequest_Time `protobuf_oneof:"time"`
	XXX_NoUnkeyedLiteral struct{}                              `json:"-"`
	XXX_unrecognized     []byte                                `json:"-"`
	XXX_sizecache        int32                                 `json:"-"`
}

func (m *StartManualTransferRunsRequest) Reset()         { *m = StartManualTransferRunsRequest{} }
func (m *StartManualTransferRunsRequest) String() string { return proto.CompactTextString(m) }
func (*StartManualTransferRunsRequest) ProtoMessage()    {}
func (*StartManualTransferRunsRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{21}
}

func (m *StartManualTransferRunsRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartManualTransferRunsRequest.Unmarshal(m, b)
}
func (m *StartManualTransferRunsRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartManualTransferRunsRequest.Marshal(b, m, deterministic)
}
func (m *StartManualTransferRunsRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartManualTransferRunsRequest.Merge(m, src)
}
func (m *StartManualTransferRunsRequest) XXX_Size() int {
	return xxx_messageInfo_StartManualTransferRunsRequest.Size(m)
}
func (m *StartManualTransferRunsRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_StartManualTransferRunsRequest.DiscardUnknown(m)
}

var xxx_messageInfo_StartManualTransferRunsRequest proto.InternalMessageInfo

func (m *StartManualTransferRunsRequest) GetParent() string {
	if m != nil {
		return m.Parent
	}
	return ""
}

func (m *StartManualTransferRunsRequest) GetLabels() map[string]string {
	if m != nil {
		return m.Labels
	}
	return nil
}

type isStartManualTransferRunsRequest_Time interface {
	isStartManualTransferRunsRequest_Time()
}

type StartManualTransferRunsRequest_RequestedTimeRange struct {
	RequestedTimeRange *StartManualTransferRunsRequest_TimeRange `protobuf:"bytes,3,opt,name=requested_time_range,json=requestedTimeRange,proto3,oneof"`
}

type StartManualTransferRunsRequest_RequestedRunTime struct {
	RequestedRunTime *timestamp.Timestamp `protobuf:"bytes,4,opt,name=requested_run_time,json=requestedRunTime,proto3,oneof"`
}

func (*StartManualTransferRunsRequest_RequestedTimeRange) isStartManualTransferRunsRequest_Time() {}

func (*StartManualTransferRunsRequest_RequestedRunTime) isStartManualTransferRunsRequest_Time() {}

func (m *StartManualTransferRunsRequest) GetTime() isStartManualTransferRunsRequest_Time {
	if m != nil {
		return m.Time
	}
	return nil
}

func (m *StartManualTransferRunsRequest) GetRequestedTimeRange() *StartManualTransferRunsRequest_TimeRange {
	if x, ok := m.GetTime().(*StartManualTransferRunsRequest_RequestedTimeRange); ok {
		return x.RequestedTimeRange
	}
	return nil
}

func (m *StartManualTransferRunsRequest) GetRequestedRunTime() *timestamp.Timestamp {
	if x, ok := m.GetTime().(*StartManualTransferRunsRequest_RequestedRunTime); ok {
		return x.RequestedRunTime
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*StartManualTransferRunsRequest) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*StartManualTransferRunsRequest_RequestedTimeRange)(nil),
		(*StartManualTransferRunsRequest_RequestedRunTime)(nil),
	}
}

// A specification for a time range, this will request transfer runs with
// run_time between start_time (inclusive) and end_time (exclusive).
type StartManualTransferRunsRequest_TimeRange struct {
	// Start time of the range of transfer runs. For example,
	// `"2017-05-25T00:00:00+00:00"`. The start_time must be strictly less than
	// the end_time. Creates transfer runs where run_time is in the range betwen
	// start_time (inclusive) and end_time (exlusive).
	StartTime *timestamp.Timestamp `protobuf:"bytes,1,opt,name=start_time,json=startTime,proto3" json:"start_time,omitempty"`
	// End time of the range of transfer runs. For example,
	// `"2017-05-30T00:00:00+00:00"`. The end_time must not be in the future.
	// Creates transfer runs where run_time is in the range betwen start_time
	// (inclusive) and end_time (exlusive).
	EndTime              *timestamp.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	XXX_NoUnkeyedLiteral struct{}             `json:"-"`
	XXX_unrecognized     []byte               `json:"-"`
	XXX_sizecache        int32                `json:"-"`
}

func (m *StartManualTransferRunsRequest_TimeRange) Reset() {
	*m = StartManualTransferRunsRequest_TimeRange{}
}
func (m *StartManualTransferRunsRequest_TimeRange) String() string { return proto.CompactTextString(m) }
func (*StartManualTransferRunsRequest_TimeRange) ProtoMessage()    {}
func (*StartManualTransferRunsRequest_TimeRange) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{21, 0}
}

func (m *StartManualTransferRunsRequest_TimeRange) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartManualTransferRunsRequest_TimeRange.Unmarshal(m, b)
}
func (m *StartManualTransferRunsRequest_TimeRange) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartManualTransferRunsRequest_TimeRange.Marshal(b, m, deterministic)
}
func (m *StartManualTransferRunsRequest_TimeRange) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartManualTransferRunsRequest_TimeRange.Merge(m, src)
}
func (m *StartManualTransferRunsRequest_TimeRange) XXX_Size() int {
	return xxx_messageInfo_StartManualTransferRunsRequest_TimeRange.Size(m)
}
func (m *StartManualTransferRunsRequest_TimeRange) XXX_DiscardUnknown() {
	xxx_messageInfo_StartManualTransferRunsRequest_TimeRange.DiscardUnknown(m)
}

var xxx_messageInfo_StartManualTransferRunsRequest_TimeRange proto.InternalMessageInfo

func (m *StartManualTransferRunsRequest_TimeRange) GetStartTime() *timestamp.Timestamp {
	if m != nil {
		return m.StartTime
	}
	return nil
}

func (m *StartManualTransferRunsRequest_TimeRange) GetEndTime() *timestamp.Timestamp {
	if m != nil {
		return m.EndTime
	}
	return nil
}

// A response to start manual transfer runs.
type StartManualTransferRunsResponse struct {
	// The transfer runs that were created.
	Runs                 []*TransferRun `protobuf:"bytes,1,rep,name=runs,proto3" json:"runs,omitempty"`
	XXX_NoUnkeyedLiteral struct{}       `json:"-"`
	XXX_unrecognized     []byte         `json:"-"`
	XXX_sizecache        int32          `json:"-"`
}

func (m *StartManualTransferRunsResponse) Reset()         { *m = StartManualTransferRunsResponse{} }
func (m *StartManualTransferRunsResponse) String() string { return proto.CompactTextString(m) }
func (*StartManualTransferRunsResponse) ProtoMessage()    {}
func (*StartManualTransferRunsResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{22}
}

func (m *StartManualTransferRunsResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_StartManualTransferRunsResponse.Unmarshal(m, b)
}
func (m *StartManualTransferRunsResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_StartManualTransferRunsResponse.Marshal(b, m, deterministic)
}
func (m *StartManualTransferRunsResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_StartManualTransferRunsResponse.Merge(m, src)
}
func (m *StartManualTransferRunsResponse) XXX_Size() int {
	return xxx_messageInfo_StartManualTransferRunsResponse.Size(m)
}
func (m *StartManualTransferRunsResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_StartManualTransferRunsResponse.DiscardUnknown(m)
}

var xxx_messageInfo_StartManualTransferRunsResponse proto.InternalMessageInfo

func (m *StartManualTransferRunsResponse) GetRuns() []*TransferRun {
	if m != nil {
		return m.Runs
	}
	return nil
}

// A request to enable data transfer service for a project.
type EnableDataTransferServiceRequest struct {
	// The name of the project resource in the form:
	// `projects/{project_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *EnableDataTransferServiceRequest) Reset()         { *m = EnableDataTransferServiceRequest{} }
func (m *EnableDataTransferServiceRequest) String() string { return proto.CompactTextString(m) }
func (*EnableDataTransferServiceRequest) ProtoMessage()    {}
func (*EnableDataTransferServiceRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{23}
}

func (m *EnableDataTransferServiceRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_EnableDataTransferServiceRequest.Unmarshal(m, b)
}
func (m *EnableDataTransferServiceRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_EnableDataTransferServiceRequest.Marshal(b, m, deterministic)
}
func (m *EnableDataTransferServiceRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_EnableDataTransferServiceRequest.Merge(m, src)
}
func (m *EnableDataTransferServiceRequest) XXX_Size() int {
	return xxx_messageInfo_EnableDataTransferServiceRequest.Size(m)
}
func (m *EnableDataTransferServiceRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_EnableDataTransferServiceRequest.DiscardUnknown(m)
}

var xxx_messageInfo_EnableDataTransferServiceRequest proto.InternalMessageInfo

func (m *EnableDataTransferServiceRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A request to determine whether data transfer is enabled for the project.
type IsDataTransferServiceEnabledRequest struct {
	// The name of the project resource in the form:
	// `projects/{project_id}`
	Name                 string   `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsDataTransferServiceEnabledRequest) Reset()         { *m = IsDataTransferServiceEnabledRequest{} }
func (m *IsDataTransferServiceEnabledRequest) String() string { return proto.CompactTextString(m) }
func (*IsDataTransferServiceEnabledRequest) ProtoMessage()    {}
func (*IsDataTransferServiceEnabledRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{24}
}

func (m *IsDataTransferServiceEnabledRequest) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IsDataTransferServiceEnabledRequest.Unmarshal(m, b)
}
func (m *IsDataTransferServiceEnabledRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IsDataTransferServiceEnabledRequest.Marshal(b, m, deterministic)
}
func (m *IsDataTransferServiceEnabledRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsDataTransferServiceEnabledRequest.Merge(m, src)
}
func (m *IsDataTransferServiceEnabledRequest) XXX_Size() int {
	return xxx_messageInfo_IsDataTransferServiceEnabledRequest.Size(m)
}
func (m *IsDataTransferServiceEnabledRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_IsDataTransferServiceEnabledRequest.DiscardUnknown(m)
}

var xxx_messageInfo_IsDataTransferServiceEnabledRequest proto.InternalMessageInfo

func (m *IsDataTransferServiceEnabledRequest) GetName() string {
	if m != nil {
		return m.Name
	}
	return ""
}

// A response to indicate whether data transfer service is enabled
// for the project.
type IsDataTransferServiceEnabledResponse struct {
	// Indicates whether the data transfer service is enabled for the project.
	Enabled bool `protobuf:"varint,1,opt,name=enabled,proto3" json:"enabled,omitempty"`
	// A string that contains additional information about why the service is
	// deemed not enabled. This is only available when `enable` is false.
	Reason               string   `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
	XXX_NoUnkeyedLiteral struct{} `json:"-"`
	XXX_unrecognized     []byte   `json:"-"`
	XXX_sizecache        int32    `json:"-"`
}

func (m *IsDataTransferServiceEnabledResponse) Reset()         { *m = IsDataTransferServiceEnabledResponse{} }
func (m *IsDataTransferServiceEnabledResponse) String() string { return proto.CompactTextString(m) }
func (*IsDataTransferServiceEnabledResponse) ProtoMessage()    {}
func (*IsDataTransferServiceEnabledResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_8edec8f64c27b8a4, []int{25}
}

func (m *IsDataTransferServiceEnabledResponse) XXX_Unmarshal(b []byte) error {
	return xxx_messageInfo_IsDataTransferServiceEnabledResponse.Unmarshal(m, b)
}
func (m *IsDataTransferServiceEnabledResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	return xxx_messageInfo_IsDataTransferServiceEnabledResponse.Marshal(b, m, deterministic)
}
func (m *IsDataTransferServiceEnabledResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_IsDataTransferServiceEnabledResponse.Merge(m, src)
}
func (m *IsDataTransferServiceEnabledResponse) XXX_Size() int {
	return xxx_messageInfo_IsDataTransferServiceEnabledResponse.Size(m)
}
func (m *IsDataTransferServiceEnabledResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_IsDataTransferServiceEnabledResponse.DiscardUnknown(m)
}

var xxx_messageInfo_IsDataTransferServiceEnabledResponse proto.InternalMessageInfo

func (m *IsDataTransferServiceEnabledResponse) GetEnabled() bool {
	if m != nil {
		return m.Enabled
	}
	return false
}

func (m *IsDataTransferServiceEnabledResponse) GetReason() string {
	if m != nil {
		return m.Reason
	}
	return ""
}

func init() {
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSourceParameter_Type", DataSourceParameter_Type_name, DataSourceParameter_Type_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSource_AuthorizationType", DataSource_AuthorizationType_name, DataSource_AuthorizationType_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.DataSource_DataRefreshType", DataSource_DataRefreshType_name, DataSource_DataRefreshType_value)
	proto.RegisterEnum("google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest_RunAttempt", ListTransferRunsRequest_RunAttempt_name, ListTransferRunsRequest_RunAttempt_value)
	proto.RegisterType((*DataSourceParameter)(nil), "google.cloud.bigquery.datatransfer.v1.DataSourceParameter")
	proto.RegisterType((*DataSource)(nil), "google.cloud.bigquery.datatransfer.v1.DataSource")
	proto.RegisterType((*GetDataSourceRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetDataSourceRequest")
	proto.RegisterType((*ListDataSourcesRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListDataSourcesRequest")
	proto.RegisterType((*ListDataSourcesResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListDataSourcesResponse")
	proto.RegisterType((*CreateTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.CreateTransferConfigRequest")
	proto.RegisterType((*UpdateTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.UpdateTransferConfigRequest")
	proto.RegisterType((*GetTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetTransferConfigRequest")
	proto.RegisterType((*DeleteTransferConfigRequest)(nil), "google.cloud.bigquery.datatransfer.v1.DeleteTransferConfigRequest")
	proto.RegisterType((*GetTransferRunRequest)(nil), "google.cloud.bigquery.datatransfer.v1.GetTransferRunRequest")
	proto.RegisterType((*DeleteTransferRunRequest)(nil), "google.cloud.bigquery.datatransfer.v1.DeleteTransferRunRequest")
	proto.RegisterType((*ListTransferConfigsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferConfigsRequest")
	proto.RegisterType((*ListTransferConfigsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferConfigsResponse")
	proto.RegisterType((*ListTransferRunsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferRunsRequest")
	proto.RegisterType((*ListTransferRunsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferRunsResponse")
	proto.RegisterType((*ListTransferLogsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest")
	proto.RegisterType((*ListTransferLogsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ListTransferLogsResponse")
	proto.RegisterType((*CheckValidCredsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.CheckValidCredsRequest")
	proto.RegisterType((*CheckValidCredsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.CheckValidCredsResponse")
	proto.RegisterType((*ScheduleTransferRunsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsRequest.LabelsEntry")
	proto.RegisterType((*ScheduleTransferRunsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.ScheduleTransferRunsResponse")
	proto.RegisterType((*StartManualTransferRunsRequest)(nil), "google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest")
	proto.RegisterMapType((map[string]string)(nil), "google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.LabelsEntry")
	proto.RegisterType((*StartManualTransferRunsRequest_TimeRange)(nil), "google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsRequest.TimeRange")
	proto.RegisterType((*StartManualTransferRunsResponse)(nil), "google.cloud.bigquery.datatransfer.v1.StartManualTransferRunsResponse")
	proto.RegisterType((*EnableDataTransferServiceRequest)(nil), "google.cloud.bigquery.datatransfer.v1.EnableDataTransferServiceRequest")
	proto.RegisterType((*IsDataTransferServiceEnabledRequest)(nil), "google.cloud.bigquery.datatransfer.v1.IsDataTransferServiceEnabledRequest")
	proto.RegisterType((*IsDataTransferServiceEnabledResponse)(nil), "google.cloud.bigquery.datatransfer.v1.IsDataTransferServiceEnabledResponse")
}

func init() {
	proto.RegisterFile("google/cloud/bigquery/datatransfer/v1/datatransfer.proto", fileDescriptor_8edec8f64c27b8a4)
}

var fileDescriptor_8edec8f64c27b8a4 = []byte{
	// 2778 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0xc4, 0x5a, 0x4b, 0x70, 0xdb, 0xc6,
	0xf9, 0x0f, 0xa8, 0xf7, 0x47, 0x3d, 0xa8, 0x8d, 0x2c, 0xc1, 0x94, 0x93, 0xc8, 0x48, 0xec, 0x28,
	0xfa, 0xe7, 0x4f, 0x46, 0x74, 0xec, 0xbf, 0x2d, 0xff, 0x63, 0x97, 0x22, 0x29, 0x99, 0xa9, 0x2c,
	0x29, 0x20, 0x65, 0xa7, 0x1a, 0x4f, 0x10, 0x98, 0x58, 0x51, 0x88, 0x41, 0x00, 0xc1, 0x02, 0xb2,
	0x95, 0x8e, 0x7b, 0x48, 0x73, 0x68, 0x3a, 0x99, 0xce, 0x74, 0x72, 0x48, 0x67, 0x3a, 0xbd, 0xf4,
	0xd2, 0xa4, 0xa7, 0xde, 0x7a, 0x69, 0x6f, 0x3d, 0xe5, 0xda, 0xe9, 0x25, 0x87, 0x76, 0x26, 0xed,
	0x4c, 0xaf, 0x9d, 0xe9, 0xa5, 0xc7, 0xce, 0x2e, 0x16, 0x7c, 0x82, 0x24, 0x48, 0x79, 0xda, 0x93,
	0xb9, 0xfb, 0xbd, 0xf6, 0xfb, 0x7d, 0x0f, 0xec, 0xb7, 0x16, 0x5c, 0xaf, 0x5a, 0x56, 0xd5, 0xc0,
	0xe9, 0x8a, 0x61, 0x79, 0x5a, 0xfa, 0xa1, 0x5e, 0xfd, 0xd0, 0xc3, 0xce, 0x69, 0x5a, 0x53, 0x5d,
	0xd5, 0x75, 0x54, 0x93, 0x1c, 0x61, 0x27, 0x7d, 0xb2, 0xde, 0xb2, 0x4e, 0xd9, 0x8e, 0xe5, 0x5a,
	0xe8, 0x92, 0x2f, 0x99, 0x62, 0x92, 0xa9, 0x40, 0x32, 0xd5, 0xc2, 0x79, 0xb2, 0x9e, 0xbc, 0xc0,
	0x0d, 0xa8, 0xb6, 0x9e, 0x56, 0x4d, 0xd3, 0x72, 0x55, 0x57, 0xb7, 0x4c, 0xe2, 0x2b, 0x49, 0xbe,
	0x19, 0xcd, 0x7c, 0xab, 0xe9, 0xe4, 0x8b, 0x5c, 0x8a, 0xad, 0x1e, 0x7a, 0x47, 0x69, 0xcd, 0x73,
	0x98, 0x5a, 0x4e, 0x5f, 0x6e, 0xa7, 0xe3, 0x9a, 0xed, 0x9e, 0x72, 0xe2, 0x4a, 0x3b, 0xf1, 0x48,
	0xc7, 0x86, 0xa6, 0xd4, 0x54, 0xf2, 0x88, 0x73, 0xbc, 0xd4, 0xce, 0xe1, 0xea, 0x35, 0x4c, 0x5c,
	0xb5, 0x66, 0x77, 0xb3, 0xff, 0xd8, 0x51, 0x6d, 0x1b, 0x3b, 0x81, 0x57, 0x4b, 0x4d, 0x3e, 0x57,
	0x0c, 0x1d, 0x9b, 0xae, 0x4f, 0x90, 0xbe, 0x1c, 0x87, 0xe7, 0xf3, 0xaa, 0xab, 0x96, 0x2c, 0xcf,
	0xa9, 0xe0, 0x7d, 0xd5, 0x51, 0x6b, 0xd8, 0xc5, 0x0e, 0x3a, 0x0f, 0x93, 0x36, 0x5d, 0x28, 0xba,
	0x26, 0x0a, 0x2b, 0xc2, 0xea, 0x94, 0x3c, 0xc1, 0xd6, 0x45, 0x0d, 0x5d, 0x84, 0x69, 0x4d, 0x27,
	0xb6, 0xa1, 0x9e, 0x2a, 0xa6, 0x5a, 0xc3, 0x62, 0x8c, 0x91, 0xe3, 0x7c, 0x6f, 0x57, 0xad, 0x61,
	0xb4, 0x02, 0x71, 0x0d, 0x93, 0x8a, 0xa3, 0xdb, 0x14, 0x03, 0x71, 0x84, 0x73, 0x34, 0xb6, 0x50,
	0x09, 0x46, 0xdd, 0x53, 0x1b, 0x8b, 0xa3, 0x2b, 0xc2, 0xea, 0x6c, 0xe6, 0x76, 0x2a, 0x52, 0xe8,
	0x52, 0x21, 0x27, 0x4d, 0x95, 0x4f, 0x6d, 0x2c, 0x33, 0x65, 0x28, 0x09, 0x93, 0x0e, 0xfe, 0xd0,
	0xd3, 0x1d, 0xac, 0x89, 0x63, 0x2b, 0xc2, 0xea, 0xa4, 0x5c, 0x5f, 0xfb, 0x34, 0x1b, 0xab, 0x2e,
	0xd6, 0xc4, 0xf1, 0x80, 0xe6, 0xaf, 0xd1, 0x6b, 0x90, 0x38, 0x51, 0x0d, 0x5d, 0x63, 0x11, 0x53,
	0x1c, 0x5c, 0xc5, 0x4f, 0xc4, 0x09, 0x76, 0xe6, 0xb9, 0xc6, 0xbe, 0x4c, 0xb7, 0xd1, 0x25, 0x98,
	0x55, 0x0d, 0xc3, 0x7a, 0x8c, 0x35, 0xe5, 0x44, 0x35, 0x3c, 0x4c, 0xc4, 0xc9, 0x95, 0x91, 0xd5,
	0x29, 0x79, 0x86, 0xef, 0xde, 0x63, 0x9b, 0xe8, 0x06, 0x4c, 0xd5, 0x74, 0xd3, 0x67, 0x11, 0xa7,
	0x56, 0x84, 0xd5, 0x78, 0xe6, 0x42, 0xe0, 0x63, 0x10, 0xa3, 0x54, 0xde, 0xf2, 0x1e, 0x1a, 0x98,
	0x49, 0xc8, 0x93, 0x35, 0xdd, 0x64, 0xbf, 0x98, 0xa8, 0xfa, 0x84, 0x8b, 0x42, 0x24, 0x51, 0xf5,
	0x89, 0x2f, 0x2a, 0xc3, 0x38, 0x4b, 0x1d, 0x22, 0xc6, 0x57, 0x46, 0x56, 0xe3, 0x99, 0x8d, 0xe1,
	0x61, 0x95, 0xb9, 0x26, 0x74, 0x15, 0x16, 0x9b, 0xb0, 0x69, 0x8e, 0xea, 0x34, 0x43, 0xe8, 0x5c,
	0x83, 0x9a, 0x6f, 0x8a, 0x6f, 0x0a, 0x9e, 0x6f, 0x12, 0x3b, 0xc6, 0x86, 0xad, 0x78, 0x8e, 0x21,
	0xce, 0x30, 0x99, 0xf9, 0x06, 0xe9, 0x0e, 0x36, 0xec, 0x03, 0xc7, 0x40, 0x17, 0x60, 0x4a, 0xaf,
	0xd5, 0x3c, 0x57, 0x7d, 0x68, 0x60, 0x71, 0x96, 0xc5, 0xa7, 0xb1, 0x81, 0x44, 0x98, 0x70, 0x70,
	0xc5, 0x73, 0x08, 0x16, 0xe7, 0x18, 0x2d, 0x58, 0x4a, 0x3a, 0x8c, 0xd2, 0x04, 0x40, 0x0b, 0x90,
	0x28, 0x7f, 0x6f, 0xbf, 0xa0, 0x1c, 0xec, 0x96, 0xf6, 0x0b, 0xb9, 0xe2, 0x56, 0xb1, 0x90, 0x4f,
	0x3c, 0x87, 0x00, 0xc6, 0x4b, 0x65, 0xb9, 0xb8, 0xbb, 0x9d, 0x10, 0x50, 0x1c, 0x26, 0x8a, 0xbb,
	0xe5, 0xc2, 0x76, 0x41, 0x4e, 0xc4, 0x28, 0x21, 0xbf, 0x77, 0xb0, 0xb9, 0x53, 0x48, 0x8c, 0x50,
	0xc2, 0xe6, 0xde, 0xde, 0x4e, 0x21, 0xbb, 0x9b, 0x18, 0xa5, 0x04, 0xb9, 0x90, 0xdb, 0x93, 0xf3,
	0x89, 0x31, 0x34, 0x03, 0x53, 0xfb, 0x3b, 0x07, 0x25, 0x65, 0x3f, 0xbb, 0x5d, 0x48, 0x8c, 0x4b,
	0x7f, 0x02, 0x80, 0x06, 0x52, 0x08, 0xc1, 0x28, 0x4b, 0x7f, 0xbf, 0x3a, 0xd8, 0x6f, 0xf4, 0x0a,
	0xcc, 0x52, 0x6c, 0x15, 0xc2, 0x58, 0x68, 0xed, 0xf8, 0xc5, 0x31, 0xad, 0xd5, 0xe5, 0x42, 0x0a,
	0x68, 0xa4, 0x6f, 0x01, 0x8d, 0x76, 0x16, 0xd0, 0x32, 0x4c, 0xf9, 0x85, 0x4c, 0xad, 0x8c, 0x31,
	0xfa, 0xa4, 0xbf, 0x51, 0xd4, 0xd0, 0x22, 0x8c, 0x93, 0x8a, 0x65, 0x63, 0x22, 0x8e, 0xb3, 0xec,
	0xe4, 0x2b, 0xf4, 0x00, 0x66, 0x82, 0xb8, 0x2b, 0xac, 0xfc, 0x26, 0x58, 0xf9, 0x5d, 0x89, 0x98,
	0x27, 0x65, 0xfe, 0x9b, 0x22, 0xbe, 0x19, 0x13, 0x05, 0x79, 0xda, 0x6d, 0xda, 0x41, 0x9b, 0xb0,
	0x4c, 0x3c, 0xdb, 0xb6, 0x1c, 0x97, 0x28, 0x35, 0xcf, 0x70, 0x75, 0xdb, 0xc0, 0x4a, 0xc0, 0x41,
	0x0b, 0x45, 0x58, 0x9d, 0x64, 0x62, 0xe7, 0x03, 0xb6, 0xbb, 0x9c, 0x2b, 0x50, 0x4c, 0xd0, 0x35,
	0x58, 0xf2, 0x6c, 0x4d, 0x75, 0xb1, 0xa2, 0x61, 0x55, 0x33, 0x74, 0x13, 0x2b, 0x04, 0x57, 0x2c,
	0x53, 0x23, 0xac, 0x8c, 0xc6, 0xe4, 0x73, 0x3e, 0x39, 0xcf, 0xa9, 0x25, 0x9f, 0x48, 0x4b, 0x58,
	0xc3, 0x47, 0xaa, 0x67, 0xb8, 0x0a, 0xa9, 0x1c, 0x63, 0xcd, 0x33, 0xfc, 0xe2, 0x99, 0x92, 0xe7,
	0xf8, 0x7e, 0x89, 0x6f, 0xa3, 0xeb, 0x20, 0xd6, 0x8f, 0x59, 0xf1, 0x88, 0x6b, 0xd5, 0x1a, 0x22,
	0x71, 0x96, 0x5d, 0x8b, 0x01, 0x3d, 0xc7, 0xc8, 0x75, 0xc9, 0x43, 0x00, 0x3b, 0x28, 0x10, 0x22,
	0x4e, 0x9f, 0xb9, 0xc6, 0x9a, 0xb4, 0xd1, 0x86, 0xdb, 0x56, 0x25, 0x13, 0xc7, 0xbc, 0x36, 0x1c,
	0x40, 0xaa, 0xe7, 0x1e, 0x5b, 0x8e, 0xfe, 0x91, 0x5f, 0x4e, 0x2c, 0x74, 0xb3, 0x2c, 0x74, 0xb9,
	0x81, 0xcd, 0xa7, 0xb2, 0xcd, 0xba, 0x58, 0xf7, 0x9c, 0x57, 0xdb, 0xb7, 0x50, 0x0d, 0xe6, 0x59,
	0x26, 0x3b, 0xf8, 0xc8, 0xc1, 0xe4, 0xd8, 0x37, 0x39, 0xc7, 0x4c, 0x66, 0x07, 0x37, 0x49, 0x7f,
	0xca, 0xbe, 0x26, 0x66, 0x70, 0x4e, 0x6b, 0xdd, 0x40, 0x5b, 0xb0, 0x12, 0x84, 0xaf, 0xc5, 0xec,
	0x63, 0xdd, 0xd4, 0xac, 0xc7, 0x8a, 0xa6, 0x9e, 0x12, 0x31, 0xc1, 0xe2, 0x7f, 0x81, 0xf3, 0x35,
	0xa9, 0xbc, 0xcf, 0x98, 0xf2, 0xea, 0x29, 0x41, 0x6f, 0xc0, 0x42, 0x4d, 0x35, 0x3d, 0xd5, 0x50,
	0x1c, 0xcf, 0x24, 0x8a, 0xa6, 0x13, 0xda, 0x3f, 0x34, 0x71, 0x9e, 0xc5, 0x15, 0xf9, 0x34, 0xd9,
	0x33, 0x49, 0x9e, 0x53, 0xd0, 0x01, 0x9c, 0xaf, 0xe9, 0xa6, 0x5e, 0xf3, 0x1a, 0x59, 0xa0, 0xe8,
	0xa6, 0x8b, 0x9d, 0x13, 0xd5, 0x10, 0x11, 0x6b, 0xbf, 0xe7, 0x3b, 0xdb, 0x2f, 0xff, 0xba, 0xcb,
	0x4b, 0x5c, 0x36, 0x48, 0x91, 0x22, 0x97, 0x44, 0xaf, 0x03, 0xb2, 0x55, 0xc7, 0x35, 0xb1, 0xa3,
	0x18, 0xb8, 0xaa, 0x1a, 0x7e, 0xa5, 0x2f, 0xb2, 0xc0, 0x26, 0x38, 0x65, 0x87, 0x12, 0x58, 0xb9,
	0x5f, 0x84, 0x69, 0x07, 0x6b, 0xba, 0x83, 0x2b, 0x2e, 0x4b, 0x80, 0x25, 0xbf, 0xde, 0x83, 0xbd,
	0x03, 0xc7, 0x90, 0x08, 0xcc, 0x77, 0x04, 0x0e, 0x49, 0xf0, 0x62, 0xf6, 0xa0, 0x7c, 0x67, 0x4f,
	0x2e, 0x1e, 0x66, 0xcb, 0xc5, 0xbd, 0x5d, 0x25, 0xa4, 0x07, 0x2e, 0x02, 0x6a, 0xe5, 0xc9, 0xed,
	0xe5, 0x0b, 0x09, 0x81, 0xca, 0x6e, 0xef, 0xed, 0x6d, 0xef, 0x14, 0x14, 0xd6, 0xe4, 0x42, 0x78,
	0x62, 0x52, 0x05, 0xe6, 0xda, 0x42, 0x87, 0x2e, 0xc2, 0x0b, 0xf9, 0x6c, 0x39, 0xab, 0xc8, 0x85,
	0x2d, 0xb9, 0x50, 0xba, 0x13, 0x66, 0x11, 0xc1, 0x6c, 0x69, 0xa7, 0x98, 0x2f, 0xee, 0x6e, 0x2b,
	0xf7, 0x8b, 0xbb, 0xf9, 0xbd, 0xfb, 0x09, 0x01, 0x9d, 0x87, 0x73, 0xb9, 0x83, 0x52, 0x79, 0xef,
	0xae, 0xd2, 0x46, 0x8a, 0x49, 0x6b, 0xb0, 0xb0, 0x8d, 0xdd, 0x46, 0xb6, 0xc8, 0xf8, 0x43, 0x0f,
	0x13, 0x37, 0xac, 0xc1, 0x4a, 0x06, 0x2c, 0xee, 0xe8, 0xa4, 0x89, 0x99, 0x04, 0xdc, 0x8b, 0x30,
	0x6e, 0xab, 0x0e, 0x36, 0x5d, 0xce, 0xcf, 0x57, 0xe8, 0x05, 0x5a, 0xb3, 0x55, 0xac, 0xb8, 0xd6,
	0x23, 0x1c, 0xdc, 0x44, 0xa6, 0xe8, 0x4e, 0x99, 0x6e, 0xd0, 0x36, 0xca, 0xc8, 0x44, 0xff, 0xc8,
	0xbf, 0x8c, 0x8c, 0xc9, 0x93, 0x74, 0xa3, 0xa4, 0x7f, 0x84, 0xa5, 0x2f, 0x04, 0x58, 0xea, 0x30,
	0x47, 0x6c, 0xcb, 0x24, 0x18, 0x95, 0x61, 0xba, 0xa9, 0xd5, 0x13, 0x51, 0x60, 0xdd, 0x60, 0x7d,
	0xe0, 0xda, 0x90, 0xe3, 0x8d, 0x6f, 0x03, 0x41, 0x97, 0x61, 0xce, 0xc4, 0x4f, 0x5c, 0xa5, 0xe9,
	0xc8, 0xfe, 0x17, 0x64, 0x86, 0x6e, 0xef, 0x07, 0xc7, 0x96, 0xfe, 0x2e, 0xc0, 0x72, 0xce, 0xa1,
	0xb7, 0x97, 0xa0, 0x75, 0xe6, 0x2c, 0xf3, 0x48, 0xaf, 0xf6, 0x43, 0xe3, 0x3d, 0x98, 0xab, 0x7f,
	0x00, 0x2a, 0x4c, 0x82, 0xe9, 0x8f, 0x67, 0xae, 0x0e, 0xf8, 0x09, 0xe0, 0xe6, 0x66, 0xdd, 0x96,
	0x35, 0xfa, 0xdf, 0xf6, 0x56, 0x55, 0xb1, 0xb4, 0xe0, 0x03, 0xd7, 0xda, 0x65, 0x72, 0x96, 0xc6,
	0xf2, 0xfe, 0x04, 0x3b, 0x84, 0x32, 0xea, 0xe6, 0x91, 0xc5, 0xbf, 0x63, 0x71, 0xbe, 0x57, 0x34,
	0x8f, 0x2c, 0xe9, 0xb3, 0x18, 0x2c, 0x1f, 0xb0, 0x96, 0x1f, 0xee, 0x69, 0x88, 0x47, 0xc2, 0x7f,
	0xd1, 0xa3, 0x9b, 0x10, 0xe7, 0xdf, 0x2f, 0x7a, 0x7d, 0x67, 0x19, 0x15, 0xcf, 0x24, 0x3b, 0x1a,
	0xc8, 0x16, 0xbd, 0x5c, 0xdd, 0x55, 0xc9, 0x23, 0x19, 0x7c, 0x76, 0xfa, 0x3b, 0x0a, 0x1c, 0x29,
	0x10, 0xb7, 0xb1, 0x1b, 0x0e, 0x45, 0x58, 0xc1, 0xac, 0xc3, 0x72, 0x1e, 0x1b, 0xb8, 0x1b, 0x7a,
	0x61, 0x22, 0xff, 0x03, 0xe7, 0x9a, 0x4c, 0xc8, 0x9e, 0xd9, 0x8b, 0x39, 0x05, 0x62, 0xab, 0xfe,
	0x3e, 0xfc, 0x3f, 0x13, 0x20, 0x49, 0x4b, 0xaa, 0xf5, 0x38, 0x7d, 0xab, 0xf8, 0x32, 0xcc, 0xb5,
	0x5e, 0xac, 0x88, 0x18, 0xf3, 0xef, 0xdd, 0xcd, 0x37, 0x2b, 0x72, 0xa6, 0x6a, 0xff, 0x95, 0x00,
	0xcb, 0xa1, 0x47, 0xe3, 0x15, 0xff, 0x3e, 0x24, 0xda, 0x32, 0x2d, 0xa8, 0xfa, 0x21, 0x53, 0x6d,
	0xae, 0x35, 0xd5, 0xa2, 0x57, 0xff, 0x9f, 0x63, 0x7e, 0x5f, 0x6a, 0xc2, 0xbc, 0x2f, 0x82, 0x3b,
	0x30, 0x4e, 0x5c, 0xd5, 0xc5, 0x3e, 0x70, 0xb3, 0x99, 0x37, 0x07, 0x3c, 0x73, 0x89, 0x0a, 0xcb,
	0x5c, 0xc7, 0x59, 0x70, 0x46, 0x1f, 0x40, 0xdc, 0xf1, 0x4c, 0x45, 0x75, 0x5d, 0x3a, 0x04, 0xb3,
	0x24, 0x9f, 0xcd, 0x14, 0x23, 0x1e, 0xa7, 0x8b, 0xdb, 0x29, 0xd9, 0x33, 0xb3, 0xbe, 0x42, 0x19,
	0x9c, 0xfa, 0x6f, 0xe9, 0x2a, 0x40, 0x83, 0x82, 0x96, 0x61, 0x49, 0x3e, 0xd8, 0x55, 0xb2, 0xe5,
	0x72, 0xe1, 0xee, 0x7e, 0xb9, 0x73, 0x56, 0xd8, 0xc9, 0x96, 0x0b, 0xa5, 0x72, 0x42, 0x90, 0x7e,
	0x2e, 0x80, 0xd8, 0x69, 0x89, 0xe7, 0xc1, 0xfd, 0xa6, 0x4b, 0x34, 0xbd, 0x65, 0xf0, 0x24, 0xc8,
	0x0c, 0x08, 0x28, 0x2d, 0x94, 0xfa, 0xfd, 0x99, 0x1a, 0x88, 0x1c, 0xfe, 0x6f, 0x84, 0xd6, 0xf0,
	0xef, 0x58, 0xd5, 0x01, 0x3f, 0x83, 0xa3, 0x3d, 0x03, 0x36, 0xd6, 0x16, 0xb0, 0x47, 0x30, 0x53,
	0xc3, 0x84, 0x30, 0xf1, 0xd3, 0x60, 0xa8, 0x98, 0xcd, 0x6c, 0x0d, 0xe8, 0xf0, 0x5d, 0x5f, 0x47,
	0x8a, 0xff, 0x5b, 0xc2, 0x27, 0xd8, 0xd1, 0xdd, 0x53, 0x79, 0x9a, 0x2b, 0xa7, 0xd7, 0x0b, 0x42,
	0xab, 0x50, 0xec, 0x74, 0x8e, 0x43, 0x5f, 0x81, 0xf9, 0x3a, 0xf4, 0x5c, 0x2a, 0x80, 0xff, 0xda,
	0x70, 0xa7, 0x91, 0xeb, 0x35, 0xcd, 0x37, 0xa2, 0x87, 0xe1, 0x75, 0x58, 0xcc, 0x1d, 0xe3, 0xca,
	0xa3, 0x7b, 0x74, 0x98, 0xcd, 0x39, 0x58, 0x23, 0xbd, 0x1a, 0x5f, 0x16, 0x96, 0x3a, 0xb8, 0xb9,
	0x57, 0x97, 0x61, 0xee, 0x58, 0x25, 0x0a, 0x1b, 0x8a, 0x95, 0x0a, 0x25, 0x31, 0xc9, 0x49, 0x79,
	0xe6, 0x58, 0x25, 0x0d, 0x7e, 0xe9, 0xeb, 0x18, 0x2c, 0x07, 0x17, 0xcd, 0x41, 0x4a, 0xff, 0x08,
	0xc6, 0x0d, 0xf5, 0x21, 0x36, 0xfc, 0xc0, 0xc5, 0x33, 0xbb, 0x11, 0xa1, 0xea, 0x61, 0x2b, 0xb5,
	0xc3, 0x14, 0x16, 0x4c, 0xd7, 0x39, 0x95, 0xb9, 0x76, 0x74, 0x03, 0x80, 0xb8, 0xaa, 0xe3, 0x2a,
	0xae, 0xce, 0x9f, 0x85, 0xc2, 0x3e, 0x7d, 0xe5, 0xe0, 0xe9, 0x4a, 0x9e, 0x62, 0xdc, 0x74, 0x8d,
	0xae, 0xc2, 0x24, 0x36, 0x35, 0x5f, 0x70, 0xa4, 0xaf, 0xe0, 0x04, 0x36, 0x35, 0xba, 0x4a, 0xde,
	0x80, 0x78, 0xd3, 0x41, 0x50, 0x02, 0x46, 0x1e, 0xe1, 0x53, 0xee, 0x3d, 0xfd, 0x89, 0x16, 0x60,
	0xcc, 0x7f, 0x48, 0xf1, 0x23, 0xe8, 0x2f, 0x36, 0x62, 0xd7, 0x05, 0xe9, 0x08, 0x2e, 0x84, 0xfb,
	0xc7, 0x83, 0xb2, 0x05, 0xa3, 0x67, 0x2c, 0x6e, 0x26, 0x2f, 0xfd, 0x76, 0x14, 0x5e, 0x2c, 0x51,
	0x3f, 0xef, 0xb2, 0xd9, 0x63, 0x90, 0xb8, 0xe9, 0xf5, 0xb8, 0xc5, 0xd8, 0x21, 0xde, 0x89, 0x1a,
	0xb7, 0x9e, 0xe6, 0x42, 0x43, 0xf7, 0x43, 0x01, 0x16, 0x1c, 0x9f, 0x8e, 0xfd, 0x30, 0x28, 0x8e,
	0x6a, 0x56, 0x83, 0x60, 0xec, 0x3d, 0x1b, 0xcb, 0x34, 0x66, 0x32, 0x55, 0x7b, 0xe7, 0x39, 0x19,
	0xd5, 0xcd, 0xd5, 0x77, 0xd1, 0xdb, 0xd0, 0xd8, 0xa5, 0xad, 0xd5, 0xcf, 0x87, 0xd1, 0x7e, 0xf9,
	0x70, 0xe7, 0x39, 0x39, 0x51, 0x97, 0x93, 0x3d, 0x93, 0xa5, 0xc6, 0x53, 0x98, 0x6a, 0x28, 0x6e,
	0xcd, 0x4c, 0x61, 0xd8, 0xcc, 0x8c, 0xfd, 0x27, 0x32, 0x73, 0x73, 0x1c, 0x46, 0xa9, 0x35, 0x49,
	0x87, 0x97, 0xba, 0xe2, 0xf9, 0x8c, 0x93, 0xf4, 0x1a, 0xac, 0x14, 0x4c, 0x3a, 0x0f, 0xd3, 0xb9,
	0xa4, 0xfe, 0xc5, 0xc7, 0xce, 0x89, 0xde, 0x7b, 0x1c, 0xbb, 0x01, 0x2f, 0x17, 0x49, 0x88, 0x8c,
	0xaf, 0x4c, 0xeb, 0x25, 0xfa, 0x2e, 0xbc, 0xd2, 0x5b, 0x94, 0xbb, 0x28, 0xc2, 0x04, 0xf6, 0xb7,
	0x78, 0x53, 0x0c, 0x96, 0xb4, 0x6c, 0x1c, 0xac, 0x12, 0x2b, 0x68, 0xcf, 0x7c, 0x95, 0xf9, 0xf6,
	0xa2, 0xff, 0xa4, 0xdd, 0xa6, 0x18, 0xfd, 0x45, 0x80, 0x99, 0x96, 0x41, 0x13, 0xdd, 0x8c, 0x08,
	0x58, 0xd8, 0x78, 0x9a, 0x1c, 0x7c, 0xd4, 0x93, 0xde, 0xfb, 0xf8, 0x8f, 0x7f, 0xfb, 0x3c, 0xf6,
	0x2e, 0x4a, 0xa7, 0x4f, 0xd6, 0xd3, 0xdf, 0xa7, 0x30, 0xbc, 0x65, 0x3b, 0xd6, 0x07, 0xb8, 0xe2,
	0x92, 0xf4, 0x5a, 0xda, 0xb0, 0x2a, 0xfe, 0xff, 0x44, 0xa4, 0xd7, 0xd2, 0x4d, 0x33, 0x61, 0x7a,
	0xed, 0xe9, 0xe1, 0x25, 0xf4, 0x72, 0xa8, 0x48, 0x2b, 0x1b, 0xfa, 0x87, 0x00, 0x73, 0x6d, 0xf3,
	0x2a, 0x7a, 0x6b, 0x80, 0x8b, 0x55, 0xe7, 0x58, 0x9d, 0xbc, 0x35, 0xac, 0xb8, 0x1f, 0xbe, 0x36,
	0x97, 0xfd, 0xc6, 0xd6, 0xc5, 0xe9, 0xa7, 0xcd, 0xee, 0xd4, 0x5d, 0xee, 0x10, 0x69, 0x61, 0x43,
	0xbf, 0x88, 0xc1, 0x42, 0xd8, 0x20, 0x8c, 0x36, 0x23, 0x1e, 0xbc, 0xc7, 0x14, 0x9d, 0x1c, 0xee,
	0x5e, 0x2f, 0x7d, 0x2a, 0x30, 0xa7, 0x3f, 0x16, 0xa4, 0x2b, 0x51, 0xbc, 0x6e, 0x9b, 0x02, 0x36,
	0xda, 0xe7, 0xd9, 0xc3, 0x0d, 0xe9, 0xd5, 0x6e, 0x50, 0xf4, 0x93, 0x45, 0xbf, 0x8f, 0xc1, 0x42,
	0xd8, 0xf8, 0x1c, 0x19, 0x9f, 0x1e, 0xb3, 0xf7, 0xb0, 0xf8, 0x7c, 0xe5, 0xe3, 0xf3, 0x4b, 0x21,
	0x93, 0x63, 0x7e, 0xb5, 0x9d, 0x39, 0xd5, 0xab, 0x30, 0xda, 0x1c, 0x4e, 0xaf, 0x3d, 0xed, 0xc4,
	0xeb, 0xed, 0xcc, 0xff, 0x45, 0xd2, 0x1b, 0x41, 0x17, 0xfa, 0x46, 0x80, 0x85, 0xb0, 0x01, 0x3a,
	0x32, 0x7e, 0x3d, 0xa6, 0xef, 0xe4, 0x62, 0xc7, 0x97, 0xa4, 0x50, 0xb3, 0xdd, 0x53, 0xe9, 0x88,
	0xe1, 0xf3, 0xfe, 0xda, 0x95, 0xbe, 0x7d, 0xa2, 0xd3, 0x85, 0xc3, 0xd7, 0xd6, 0x5e, 0x0d, 0x15,
	0xeb, 0x64, 0x45, 0xff, 0x14, 0x60, 0xbe, 0xe3, 0x35, 0x01, 0xdd, 0x8e, 0xde, 0x15, 0x9f, 0x69,
	0x5a, 0x70, 0xaf, 0xd1, 0x70, 0x5e, 0xa3, 0xc8, 0x5e, 0x7f, 0x12, 0x83, 0xe7, 0x43, 0xe6, 0x7c,
	0x94, 0x1d, 0x62, 0x04, 0x6d, 0x7d, 0xbe, 0x48, 0x6e, 0x9e, 0x45, 0x05, 0xef, 0x98, 0xad, 0x30,
	0x0c, 0xd6, 0x3b, 0xea, 0x30, 0xf4, 0x6f, 0x15, 0xe8, 0x37, 0x31, 0x58, 0x08, 0xbb, 0x01, 0x47,
	0xce, 0xec, 0x1e, 0xe3, 0x41, 0x32, 0x77, 0x26, 0x1d, 0x1c, 0x89, 0x9f, 0xf8, 0x7d, 0xe2, 0x13,
	0x41, 0xda, 0xec, 0x8f, 0x45, 0x58, 0x35, 0x07, 0x0f, 0xfa, 0x54, 0xeb, 0x86, 0xb0, 0x76, 0x78,
	0x53, 0xba, 0xd6, 0x45, 0x51, 0x7f, 0xe1, 0x1f, 0xc5, 0x04, 0xf4, 0xbb, 0x18, 0x2c, 0x75, 0xb9,
	0x92, 0xa1, 0xc2, 0x33, 0xb9, 0x22, 0x27, 0xb7, 0xce, 0xaa, 0x86, 0x63, 0xf7, 0x53, 0x1f, 0xbb,
	0x1f, 0x0b, 0x52, 0x61, 0x48, 0xec, 0x1a, 0x06, 0x02, 0xf8, 0x6e, 0x49, 0x37, 0x06, 0x80, 0xaf,
	0x43, 0x1e, 0xfd, 0x4b, 0x80, 0xd9, 0xd6, 0x97, 0x45, 0xf4, 0xff, 0x83, 0xf7, 0x9a, 0xc6, 0x03,
	0x63, 0x72, 0x88, 0x0b, 0xaf, 0xe4, 0x32, 0x5c, 0x4c, 0xb4, 0x31, 0x78, 0x97, 0x49, 0xd3, 0xbb,
	0x32, 0x6d, 0x36, 0x6f, 0xa0, 0x54, 0xb4, 0x66, 0x13, 0x48, 0xa0, 0x6f, 0x05, 0x98, 0xef, 0x78,
	0x27, 0x8d, 0xdc, 0x69, 0xbb, 0xbd, 0xb0, 0x76, 0xfd, 0x80, 0x70, 0x27, 0xd7, 0xce, 0xe4, 0xe4,
	0xda, 0xa0, 0x4e, 0x7e, 0x1a, 0x83, 0x44, 0xfb, 0xab, 0x19, 0xba, 0x75, 0xb6, 0x87, 0xbd, 0xe4,
	0xed, 0xa1, 0xe5, 0x79, 0x25, 0xb4, 0x06, 0x7c, 0xd0, 0x3a, 0x60, 0xce, 0xd5, 0x03, 0x1e, 0x25,
	0xf3, 0x99, 0x04, 0xfa, 0xaa, 0x0d, 0x8b, 0x1d, 0xab, 0x3a, 0x1c, 0x16, 0x4d, 0x8f, 0x7b, 0x43,
	0x61, 0xd1, 0xfc, 0x7e, 0x26, 0x7d, 0xee, 0x77, 0x85, 0xcf, 0x04, 0x54, 0x1c, 0x06, 0x8d, 0x20,
	0xd2, 0x75, 0x0a, 0x55, 0x7e, 0x78, 0x1b, 0xbd, 0x15, 0x15, 0x9c, 0x50, 0x05, 0xe8, 0x8b, 0x18,
	0xcc, 0xb5, 0xbd, 0x8d, 0x45, 0x1e, 0x5b, 0xc2, 0x5f, 0xe0, 0x22, 0x8f, 0x2d, 0x5d, 0x9e, 0xe4,
	0xa4, 0x4f, 0x7c, 0xa0, 0x7e, 0x20, 0xdd, 0x1e, 0x70, 0x54, 0xdb, 0xa8, 0xb4, 0x6a, 0xa4, 0x7d,
	0xf3, 0xba, 0x74, 0x25, 0xc2, 0xf4, 0x16, 0x22, 0x89, 0xfe, 0x20, 0xc0, 0xf9, 0xae, 0x83, 0x39,
	0xda, 0x8e, 0xe8, 0x64, 0xbf, 0xd1, 0xbe, 0x6b, 0x1b, 0xd9, 0x62, 0x20, 0x7c, 0x47, 0xba, 0xd9,
	0x0f, 0x84, 0xa7, 0x1b, 0xb8, 0x9b, 0x0d, 0xea, 0xc6, 0x97, 0x31, 0xb8, 0xd0, 0x6b, 0xd8, 0x47,
	0x6f, 0x47, 0xf4, 0x24, 0xc2, 0x63, 0x43, 0xf2, 0xbb, 0xcf, 0x44, 0x17, 0xcf, 0x03, 0x8b, 0x21,
	0xa0, 0x4b, 0xb7, 0xfa, 0x23, 0xa0, 0xf7, 0xd0, 0x47, 0xb3, 0xe0, 0x15, 0xe9, 0xa5, 0x30, 0x25,
	0x54, 0xb0, 0xc1, 0x95, 0xbc, 0xfc, 0x75, 0xf6, 0xe5, 0xe0, 0xc8, 0x2d, 0x27, 0xf6, 0x9d, 0x52,
	0x6d, 0x9d, 0xa4, 0x2a, 0x56, 0x6d, 0xf3, 0xaf, 0x02, 0xbc, 0x56, 0xb1, 0x6a, 0xd1, 0x7c, 0xdd,
	0x9c, 0x6f, 0x3e, 0xda, 0x3e, 0x0d, 0xf2, 0xbe, 0x70, 0xf8, 0x0e, 0x97, 0xad, 0x5a, 0x86, 0x6a,
	0x56, 0x53, 0x96, 0x53, 0x4d, 0x57, 0xb1, 0xc9, 0x52, 0x20, 0xdd, 0xb0, 0xd6, 0xe7, 0x0f, 0x21,
	0x6f, 0x36, 0xaf, 0x7f, 0x1d, 0xbb, 0xb4, 0xed, 0xeb, 0xcc, 0xb1, 0xf3, 0x6c, 0xea, 0xd5, 0x77,
	0xd8, 0x79, 0x9a, 0xcd, 0xa7, 0xee, 0xad, 0x7f, 0x1d, 0xf0, 0x3d, 0x60, 0x7c, 0x0f, 0x02, 0xbe,
	0x07, 0xcd, 0x7c, 0x0f, 0xee, 0xad, 0x3f, 0x1c, 0x67, 0xa7, 0xb9, 0xf2, 0xef, 0x00, 0x00, 0x00,
	0xff, 0xff, 0xe0, 0x91, 0x00, 0xff, 0x14, 0x2a, 0x00, 0x00,
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// DataTransferServiceClient is the client API for DataTransferService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type DataTransferServiceClient interface {
	// Retrieves a supported data source and returns its settings,
	// which can be used for UI rendering.
	GetDataSource(ctx context.Context, in *GetDataSourceRequest, opts ...grpc.CallOption) (*DataSource, error)
	// Lists supported data sources and returns their settings,
	// which can be used for UI rendering.
	ListDataSources(ctx context.Context, in *ListDataSourcesRequest, opts ...grpc.CallOption) (*ListDataSourcesResponse, error)
	// Creates a new data transfer configuration.
	CreateTransferConfig(ctx context.Context, in *CreateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Updates a data transfer configuration.
	// All fields must be set, even if they are not updated.
	UpdateTransferConfig(ctx context.Context, in *UpdateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Deletes a data transfer configuration,
	// including any associated transfer runs and logs.
	DeleteTransferConfig(ctx context.Context, in *DeleteTransferConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns information about a data transfer config.
	GetTransferConfig(ctx context.Context, in *GetTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error)
	// Returns information about all data transfers in the project.
	ListTransferConfigs(ctx context.Context, in *ListTransferConfigsRequest, opts ...grpc.CallOption) (*ListTransferConfigsResponse, error)
	// Creates transfer runs for a time range [start_time, end_time].
	// For each date - or whatever granularity the data source supports - in the
	// range, one transfer run is created.
	// Note that runs are created per UTC time in the time range.
	// DEPRECATED: use StartManualTransferRuns instead.
	ScheduleTransferRuns(ctx context.Context, in *ScheduleTransferRunsRequest, opts ...grpc.CallOption) (*ScheduleTransferRunsResponse, error)
	// Start manual transfer runs to be executed now with schedule_time equal to
	// current time. The transfer runs can be created for a time range where the
	// run_time is between start_time (inclusive) and end_time (exclusive), or for
	// a specific run_time.
	StartManualTransferRuns(ctx context.Context, in *StartManualTransferRunsRequest, opts ...grpc.CallOption) (*StartManualTransferRunsResponse, error)
	// Returns information about the particular transfer run.
	GetTransferRun(ctx context.Context, in *GetTransferRunRequest, opts ...grpc.CallOption) (*TransferRun, error)
	// Deletes the specified transfer run.
	DeleteTransferRun(ctx context.Context, in *DeleteTransferRunRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns information about running and completed jobs.
	ListTransferRuns(ctx context.Context, in *ListTransferRunsRequest, opts ...grpc.CallOption) (*ListTransferRunsResponse, error)
	// Returns user facing log messages for the data transfer run.
	ListTransferLogs(ctx context.Context, in *ListTransferLogsRequest, opts ...grpc.CallOption) (*ListTransferLogsResponse, error)
	// Returns true if valid credentials exist for the given data source and
	// requesting user.
	// Some data sources doesn't support service account, so we need to talk to
	// them on behalf of the end user. This API just checks whether we have OAuth
	// token for the particular user, which is a pre-requisite before user can
	// create a transfer config.
	CheckValidCreds(ctx context.Context, in *CheckValidCredsRequest, opts ...grpc.CallOption) (*CheckValidCredsResponse, error)
	// Enables data transfer service for a given project. This
	// method requires the additional scope of
	// 'https://www.googleapis.com/auth/cloudplatformprojects'
	// to manage the cloud project permissions.
	EnableDataTransferService(ctx context.Context, in *EnableDataTransferServiceRequest, opts ...grpc.CallOption) (*empty.Empty, error)
	// Returns true if data transfer is enabled for a project.
	IsDataTransferServiceEnabled(ctx context.Context, in *IsDataTransferServiceEnabledRequest, opts ...grpc.CallOption) (*IsDataTransferServiceEnabledResponse, error)
}

type dataTransferServiceClient struct {
	cc *grpc.ClientConn
}

func NewDataTransferServiceClient(cc *grpc.ClientConn) DataTransferServiceClient {
	return &dataTransferServiceClient{cc}
}

func (c *dataTransferServiceClient) GetDataSource(ctx context.Context, in *GetDataSourceRequest, opts ...grpc.CallOption) (*DataSource, error) {
	out := new(DataSource)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetDataSource", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListDataSources(ctx context.Context, in *ListDataSourcesRequest, opts ...grpc.CallOption) (*ListDataSourcesResponse, error) {
	out := new(ListDataSourcesResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListDataSources", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CreateTransferConfig(ctx context.Context, in *CreateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CreateTransferConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) UpdateTransferConfig(ctx context.Context, in *UpdateTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/UpdateTransferConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteTransferConfig(ctx context.Context, in *DeleteTransferConfigRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetTransferConfig(ctx context.Context, in *GetTransferConfigRequest, opts ...grpc.CallOption) (*TransferConfig, error) {
	out := new(TransferConfig)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferConfigs(ctx context.Context, in *ListTransferConfigsRequest, opts ...grpc.CallOption) (*ListTransferConfigsResponse, error) {
	out := new(ListTransferConfigsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferConfigs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Deprecated: Do not use.
func (c *dataTransferServiceClient) ScheduleTransferRuns(ctx context.Context, in *ScheduleTransferRunsRequest, opts ...grpc.CallOption) (*ScheduleTransferRunsResponse, error) {
	out := new(ScheduleTransferRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ScheduleTransferRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) StartManualTransferRuns(ctx context.Context, in *StartManualTransferRunsRequest, opts ...grpc.CallOption) (*StartManualTransferRunsResponse, error) {
	out := new(StartManualTransferRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/StartManualTransferRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) GetTransferRun(ctx context.Context, in *GetTransferRunRequest, opts ...grpc.CallOption) (*TransferRun, error) {
	out := new(TransferRun)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) DeleteTransferRun(ctx context.Context, in *DeleteTransferRunRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferRun", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferRuns(ctx context.Context, in *ListTransferRunsRequest, opts ...grpc.CallOption) (*ListTransferRunsResponse, error) {
	out := new(ListTransferRunsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferRuns", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) ListTransferLogs(ctx context.Context, in *ListTransferLogsRequest, opts ...grpc.CallOption) (*ListTransferLogsResponse, error) {
	out := new(ListTransferLogsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferLogs", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) CheckValidCreds(ctx context.Context, in *CheckValidCredsRequest, opts ...grpc.CallOption) (*CheckValidCredsResponse, error) {
	out := new(CheckValidCredsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CheckValidCreds", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) EnableDataTransferService(ctx context.Context, in *EnableDataTransferServiceRequest, opts ...grpc.CallOption) (*empty.Empty, error) {
	out := new(empty.Empty)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/EnableDataTransferService", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *dataTransferServiceClient) IsDataTransferServiceEnabled(ctx context.Context, in *IsDataTransferServiceEnabledRequest, opts ...grpc.CallOption) (*IsDataTransferServiceEnabledResponse, error) {
	out := new(IsDataTransferServiceEnabledResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.bigquery.datatransfer.v1.DataTransferService/IsDataTransferServiceEnabled", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// DataTransferServiceServer is the server API for DataTransferService service.
type DataTransferServiceServer interface {
	// Retrieves a supported data source and returns its settings,
	// which can be used for UI rendering.
	GetDataSource(context.Context, *GetDataSourceRequest) (*DataSource, error)
	// Lists supported data sources and returns their settings,
	// which can be used for UI rendering.
	ListDataSources(context.Context, *ListDataSourcesRequest) (*ListDataSourcesResponse, error)
	// Creates a new data transfer configuration.
	CreateTransferConfig(context.Context, *CreateTransferConfigRequest) (*TransferConfig, error)
	// Updates a data transfer configuration.
	// All fields must be set, even if they are not updated.
	UpdateTransferConfig(context.Context, *UpdateTransferConfigRequest) (*TransferConfig, error)
	// Deletes a data transfer configuration,
	// including any associated transfer runs and logs.
	DeleteTransferConfig(context.Context, *DeleteTransferConfigRequest) (*empty.Empty, error)
	// Returns information about a data transfer config.
	GetTransferConfig(context.Context, *GetTransferConfigRequest) (*TransferConfig, error)
	// Returns information about all data transfers in the project.
	ListTransferConfigs(context.Context, *ListTransferConfigsRequest) (*ListTransferConfigsResponse, error)
	// Creates transfer runs for a time range [start_time, end_time].
	// For each date - or whatever granularity the data source supports - in the
	// range, one transfer run is created.
	// Note that runs are created per UTC time in the time range.
	// DEPRECATED: use StartManualTransferRuns instead.
	ScheduleTransferRuns(context.Context, *ScheduleTransferRunsRequest) (*ScheduleTransferRunsResponse, error)
	// Start manual transfer runs to be executed now with schedule_time equal to
	// current time. The transfer runs can be created for a time range where the
	// run_time is between start_time (inclusive) and end_time (exclusive), or for
	// a specific run_time.
	StartManualTransferRuns(context.Context, *StartManualTransferRunsRequest) (*StartManualTransferRunsResponse, error)
	// Returns information about the particular transfer run.
	GetTransferRun(context.Context, *GetTransferRunRequest) (*TransferRun, error)
	// Deletes the specified transfer run.
	DeleteTransferRun(context.Context, *DeleteTransferRunRequest) (*empty.Empty, error)
	// Returns information about running and completed jobs.
	ListTransferRuns(context.Context, *ListTransferRunsRequest) (*ListTransferRunsResponse, error)
	// Returns user facing log messages for the data transfer run.
	ListTransferLogs(context.Context, *ListTransferLogsRequest) (*ListTransferLogsResponse, error)
	// Returns true if valid credentials exist for the given data source and
	// requesting user.
	// Some data sources doesn't support service account, so we need to talk to
	// them on behalf of the end user. This API just checks whether we have OAuth
	// token for the particular user, which is a pre-requisite before user can
	// create a transfer config.
	CheckValidCreds(context.Context, *CheckValidCredsRequest) (*CheckValidCredsResponse, error)
	// Enables data transfer service for a given project. This
	// method requires the additional scope of
	// 'https://www.googleapis.com/auth/cloudplatformprojects'
	// to manage the cloud project permissions.
	EnableDataTransferService(context.Context, *EnableDataTransferServiceRequest) (*empty.Empty, error)
	// Returns true if data transfer is enabled for a project.
	IsDataTransferServiceEnabled(context.Context, *IsDataTransferServiceEnabledRequest) (*IsDataTransferServiceEnabledResponse, error)
}

func RegisterDataTransferServiceServer(s *grpc.Server, srv DataTransferServiceServer) {
	s.RegisterService(&_DataTransferService_serviceDesc, srv)
}

func _DataTransferService_GetDataSource_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetDataSourceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetDataSource(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetDataSource",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetDataSource(ctx, req.(*GetDataSourceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListDataSources_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListDataSourcesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListDataSources(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListDataSources",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListDataSources(ctx, req.(*ListDataSourcesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CreateTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CreateTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CreateTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CreateTransferConfig(ctx, req.(*CreateTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_UpdateTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).UpdateTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/UpdateTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).UpdateTransferConfig(ctx, req.(*UpdateTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteTransferConfig(ctx, req.(*DeleteTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetTransferConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetTransferConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetTransferConfig(ctx, req.(*GetTransferConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferConfigs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferConfigsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferConfigs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferConfigs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferConfigs(ctx, req.(*ListTransferConfigsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ScheduleTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ScheduleTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ScheduleTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ScheduleTransferRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ScheduleTransferRuns(ctx, req.(*ScheduleTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_StartManualTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(StartManualTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).StartManualTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/StartManualTransferRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).StartManualTransferRuns(ctx, req.(*StartManualTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_GetTransferRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetTransferRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).GetTransferRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/GetTransferRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).GetTransferRun(ctx, req.(*GetTransferRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_DeleteTransferRun_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteTransferRunRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).DeleteTransferRun(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/DeleteTransferRun",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).DeleteTransferRun(ctx, req.(*DeleteTransferRunRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferRuns_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferRunsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferRuns(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferRuns",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferRuns(ctx, req.(*ListTransferRunsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_ListTransferLogs_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListTransferLogsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).ListTransferLogs(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/ListTransferLogs",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).ListTransferLogs(ctx, req.(*ListTransferLogsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_CheckValidCreds_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckValidCredsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).CheckValidCreds(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/CheckValidCreds",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).CheckValidCreds(ctx, req.(*CheckValidCredsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_EnableDataTransferService_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(EnableDataTransferServiceRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).EnableDataTransferService(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/EnableDataTransferService",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).EnableDataTransferService(ctx, req.(*EnableDataTransferServiceRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _DataTransferService_IsDataTransferServiceEnabled_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(IsDataTransferServiceEnabledRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(DataTransferServiceServer).IsDataTransferServiceEnabled(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.bigquery.datatransfer.v1.DataTransferService/IsDataTransferServiceEnabled",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(DataTransferServiceServer).IsDataTransferServiceEnabled(ctx, req.(*IsDataTransferServiceEnabledRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _DataTransferService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.bigquery.datatransfer.v1.DataTransferService",
	HandlerType: (*DataTransferServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetDataSource",
			Handler:    _DataTransferService_GetDataSource_Handler,
		},
		{
			MethodName: "ListDataSources",
			Handler:    _DataTransferService_ListDataSources_Handler,
		},
		{
			MethodName: "CreateTransferConfig",
			Handler:    _DataTransferService_CreateTransferConfig_Handler,
		},
		{
			MethodName: "UpdateTransferConfig",
			Handler:    _DataTransferService_UpdateTransferConfig_Handler,
		},
		{
			MethodName: "DeleteTransferConfig",
			Handler:    _DataTransferService_DeleteTransferConfig_Handler,
		},
		{
			MethodName: "GetTransferConfig",
			Handler:    _DataTransferService_GetTransferConfig_Handler,
		},
		{
			MethodName: "ListTransferConfigs",
			Handler:    _DataTransferService_ListTransferConfigs_Handler,
		},
		{
			MethodName: "ScheduleTransferRuns",
			Handler:    _DataTransferService_ScheduleTransferRuns_Handler,
		},
		{
			MethodName: "StartManualTransferRuns",
			Handler:    _DataTransferService_StartManualTransferRuns_Handler,
		},
		{
			MethodName: "GetTransferRun",
			Handler:    _DataTransferService_GetTransferRun_Handler,
		},
		{
			MethodName: "DeleteTransferRun",
			Handler:    _DataTransferService_DeleteTransferRun_Handler,
		},
		{
			MethodName: "ListTransferRuns",
			Handler:    _DataTransferService_ListTransferRuns_Handler,
		},
		{
			MethodName: "ListTransferLogs",
			Handler:    _DataTransferService_ListTransferLogs_Handler,
		},
		{
			MethodName: "CheckValidCreds",
			Handler:    _DataTransferService_CheckValidCreds_Handler,
		},
		{
			MethodName: "EnableDataTransferService",
			Handler:    _DataTransferService_EnableDataTransferService_Handler,
		},
		{
			MethodName: "IsDataTransferServiceEnabled",
			Handler:    _DataTransferService_IsDataTransferServiceEnabled_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/bigquery/datatransfer/v1/datatransfer.proto",
}
