package commitmentplans

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans instead.
// UsageHistoryClient is the these APIs allow end users to operate on Azure Machine Learning Commitment Plans resources
// and their child Commitment Association resources. They support CRUD operations for commitment plans, get and list
// operations for commitment associations, moving commitment associations between commitment plans, and retrieving
// commitment plan usage history.
type UsageHistoryClient struct {
	BaseClient
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans instead.
// NewUsageHistoryClient creates an instance of the UsageHistoryClient client.
func NewUsageHistoryClient(subscriptionID string) UsageHistoryClient {
	return NewUsageHistoryClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans instead.
// NewUsageHistoryClientWithBaseURI creates an instance of the UsageHistoryClient client.
func NewUsageHistoryClientWithBaseURI(baseURI string, subscriptionID string) UsageHistoryClient {
	return UsageHistoryClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans instead.
// List retrieve the usage history for an Azure ML commitment plan.
//
// resourceGroupName is the resource group name. commitmentPlanName is the Azure ML commitment plan name. skipToken
// is continuation token for pagination.
func (client UsageHistoryClient) List(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (result PlanUsageHistoryListResultPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, resourceGroupName, commitmentPlanName, skipToken)
	if err != nil {
		err = autorest.NewErrorWithError(err, "commitmentplans.UsageHistoryClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.puhlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "commitmentplans.UsageHistoryClient", "List", resp, "Failure sending request")
		return
	}

	result.puhlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "commitmentplans.UsageHistoryClient", "List", resp, "Failure responding to request")
	}

	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans instead.
// ListPreparer prepares the List request.
func (client UsageHistoryClient) ListPreparer(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"commitmentPlanName": autorest.Encode("path", commitmentPlanName),
		"resourceGroupName":  autorest.Encode("path", resourceGroupName),
		"subscriptionId":     autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(skipToken) > 0 {
		queryParameters["$skipToken"] = autorest.Encode("query", skipToken)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.MachineLearning/commitmentPlans/{commitmentPlanName}/usageHistory", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans instead.
// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client UsageHistoryClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans instead.
// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client UsageHistoryClient) ListResponder(resp *http.Response) (result PlanUsageHistoryListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client UsageHistoryClient) listNextResults(lastResults PlanUsageHistoryListResult) (result PlanUsageHistoryListResult, err error) {
	req, err := lastResults.planUsageHistoryListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "commitmentplans.UsageHistoryClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "commitmentplans.UsageHistoryClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "commitmentplans.UsageHistoryClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// Deprecated: Please use package github.com/Azure/azure-sdk-for-go/services/preview/machinelearning/mgmt/2016-05-01-preview/commitmentplans instead.
// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client UsageHistoryClient) ListComplete(ctx context.Context, resourceGroupName string, commitmentPlanName string, skipToken string) (result PlanUsageHistoryListResultIterator, err error) {
	result.page, err = client.List(ctx, resourceGroupName, commitmentPlanName, skipToken)
	return
}
