package batchai

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"net/http"
)

// JobsClient is the the Azure BatchAI Management API.
type JobsClient struct {
	BaseClient
}

// NewJobsClient creates an instance of the JobsClient client.
func NewJobsClient(subscriptionID string) JobsClient {
	return NewJobsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewJobsClientWithBaseURI creates an instance of the JobsClient client.
func NewJobsClientWithBaseURI(baseURI string, subscriptionID string) JobsClient {
	return JobsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Create creates a Job in the given Experiment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// workspaceName - the name of the workspace. Workspace names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// experimentName - the name of the experiment. Experiment names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// jobName - the name of the job within the specified resource group. Job names can only contain a combination
// of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64
// characters long.
// parameters - the parameters to provide for job creation.
func (client JobsClient) Create(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string, parameters JobCreateParameters) (result JobsCreateFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "workspaceName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: experimentName,
			Constraints: []validation.Constraint{{Target: "experimentName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "experimentName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "experimentName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: jobName,
			Constraints: []validation.Constraint{{Target: "jobName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "jobName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "jobName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.JobBaseProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.Cluster", Name: validation.Null, Rule: true,
					Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.Cluster.ID", Name: validation.Null, Rule: true, Chain: nil}}},
					{Target: "parameters.JobBaseProperties.NodeCount", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.JobBaseProperties.ContainerSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.ContainerSettings.ImageSourceRegistry", Name: validation.Null, Rule: true,
							Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.ContainerSettings.ImageSourceRegistry.Image", Name: validation.Null, Rule: true, Chain: nil},
								{Target: "parameters.JobBaseProperties.ContainerSettings.ImageSourceRegistry.Credentials", Name: validation.Null, Rule: false,
									Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.ContainerSettings.ImageSourceRegistry.Credentials.Username", Name: validation.Null, Rule: true, Chain: nil},
										{Target: "parameters.JobBaseProperties.ContainerSettings.ImageSourceRegistry.Credentials.PasswordSecretReference", Name: validation.Null, Rule: false,
											Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.ContainerSettings.ImageSourceRegistry.Credentials.PasswordSecretReference.SourceVault", Name: validation.Null, Rule: true,
												Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.ContainerSettings.ImageSourceRegistry.Credentials.PasswordSecretReference.SourceVault.ID", Name: validation.Null, Rule: true, Chain: nil}}},
												{Target: "parameters.JobBaseProperties.ContainerSettings.ImageSourceRegistry.Credentials.PasswordSecretReference.SecretURL", Name: validation.Null, Rule: true, Chain: nil},
											}},
									}},
							}},
						}},
					{Target: "parameters.JobBaseProperties.PyTorchSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.PyTorchSettings.PythonScriptFilePath", Name: validation.Null, Rule: true, Chain: nil}}},
					{Target: "parameters.JobBaseProperties.TensorFlowSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.TensorFlowSettings.PythonScriptFilePath", Name: validation.Null, Rule: true, Chain: nil}}},
					{Target: "parameters.JobBaseProperties.Caffe2Settings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.Caffe2Settings.PythonScriptFilePath", Name: validation.Null, Rule: true, Chain: nil}}},
					{Target: "parameters.JobBaseProperties.ChainerSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.ChainerSettings.PythonScriptFilePath", Name: validation.Null, Rule: true, Chain: nil}}},
					{Target: "parameters.JobBaseProperties.CustomMpiSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.CustomMpiSettings.CommandLine", Name: validation.Null, Rule: true, Chain: nil}}},
					{Target: "parameters.JobBaseProperties.HorovodSettings", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.HorovodSettings.PythonScriptFilePath", Name: validation.Null, Rule: true, Chain: nil}}},
					{Target: "parameters.JobBaseProperties.JobPreparation", Name: validation.Null, Rule: false,
						Chain: []validation.Constraint{{Target: "parameters.JobBaseProperties.JobPreparation.CommandLine", Name: validation.Null, Rule: true, Chain: nil}}},
					{Target: "parameters.JobBaseProperties.StdOutErrPathPrefix", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("batchai.JobsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, resourceGroupName, workspaceName, experimentName, jobName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Create", nil, "Failure preparing request")
		return
	}

	result, err = client.CreateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Create", result.Response(), "Failure sending request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client JobsClient) CreatePreparer(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string, parameters JobCreateParameters) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"experimentName":    autorest.Encode("path", experimentName),
		"jobName":           autorest.Encode("path", jobName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client JobsClient) CreateSender(req *http.Request) (future JobsCreateFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client JobsClient) CreateResponder(resp *http.Response) (result Job, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete deletes a Job.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// workspaceName - the name of the workspace. Workspace names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// experimentName - the name of the experiment. Experiment names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// jobName - the name of the job within the specified resource group. Job names can only contain a combination
// of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64
// characters long.
func (client JobsClient) Delete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result JobsDeleteFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "workspaceName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: experimentName,
			Constraints: []validation.Constraint{{Target: "experimentName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "experimentName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "experimentName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: jobName,
			Constraints: []validation.Constraint{{Target: "jobName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "jobName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "jobName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("batchai.JobsClient", "Delete", err.Error())
	}

	req, err := client.DeletePreparer(ctx, resourceGroupName, workspaceName, experimentName, jobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client JobsClient) DeletePreparer(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"experimentName":    autorest.Encode("path", experimentName),
		"jobName":           autorest.Encode("path", jobName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client JobsClient) DeleteSender(req *http.Request) (future JobsDeleteFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client JobsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get gets information about a Job.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// workspaceName - the name of the workspace. Workspace names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// experimentName - the name of the experiment. Experiment names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// jobName - the name of the job within the specified resource group. Job names can only contain a combination
// of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64
// characters long.
func (client JobsClient) Get(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result Job, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "workspaceName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: experimentName,
			Constraints: []validation.Constraint{{Target: "experimentName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "experimentName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "experimentName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: jobName,
			Constraints: []validation.Constraint{{Target: "jobName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "jobName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "jobName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("batchai.JobsClient", "Get", err.Error())
	}

	req, err := client.GetPreparer(ctx, resourceGroupName, workspaceName, experimentName, jobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client JobsClient) GetPreparer(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"experimentName":    autorest.Encode("path", experimentName),
		"jobName":           autorest.Encode("path", jobName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client JobsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client JobsClient) GetResponder(resp *http.Response) (result Job, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByExperiment gets a list of Jobs within the specified Experiment.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// workspaceName - the name of the workspace. Workspace names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// experimentName - the name of the experiment. Experiment names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// maxResults - the maximum number of items to return in the response. A maximum of 1000 files can be returned.
func (client JobsClient) ListByExperiment(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, maxResults *int32) (result JobListResultPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "workspaceName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: experimentName,
			Constraints: []validation.Constraint{{Target: "experimentName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "experimentName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "experimentName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: maxResults,
			Constraints: []validation.Constraint{{Target: "maxResults", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "maxResults", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "maxResults", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("batchai.JobsClient", "ListByExperiment", err.Error())
	}

	result.fn = client.listByExperimentNextResults
	req, err := client.ListByExperimentPreparer(ctx, resourceGroupName, workspaceName, experimentName, maxResults)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListByExperiment", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByExperimentSender(req)
	if err != nil {
		result.jlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListByExperiment", resp, "Failure sending request")
		return
	}

	result.jlr, err = client.ListByExperimentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListByExperiment", resp, "Failure responding to request")
	}

	return
}

// ListByExperimentPreparer prepares the ListByExperiment request.
func (client JobsClient) ListByExperimentPreparer(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, maxResults *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"experimentName":    autorest.Encode("path", experimentName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if maxResults != nil {
		queryParameters["maxresults"] = autorest.Encode("query", *maxResults)
	} else {
		queryParameters["maxresults"] = autorest.Encode("query", 1000)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByExperimentSender sends the ListByExperiment request. The method will close the
// http.Response Body if it receives an error.
func (client JobsClient) ListByExperimentSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByExperimentResponder handles the response to the ListByExperiment request. The method always
// closes the http.Response Body.
func (client JobsClient) ListByExperimentResponder(resp *http.Response) (result JobListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByExperimentNextResults retrieves the next set of results, if any.
func (client JobsClient) listByExperimentNextResults(lastResults JobListResult) (result JobListResult, err error) {
	req, err := lastResults.jobListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "batchai.JobsClient", "listByExperimentNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByExperimentSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "batchai.JobsClient", "listByExperimentNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByExperimentResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "listByExperimentNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByExperimentComplete enumerates all values, automatically crossing page boundaries as required.
func (client JobsClient) ListByExperimentComplete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, maxResults *int32) (result JobListResultIterator, err error) {
	result.page, err = client.ListByExperiment(ctx, resourceGroupName, workspaceName, experimentName, maxResults)
	return
}

// ListOutputFiles list all directories and files inside the given directory of the Job's output directory (if the
// output directory is on Azure File Share or Azure Storage Container).
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// workspaceName - the name of the workspace. Workspace names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// experimentName - the name of the experiment. Experiment names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// jobName - the name of the job within the specified resource group. Job names can only contain a combination
// of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64
// characters long.
// outputdirectoryid - id of the job output directory. This is the OutputDirectory-->id parameter that is given
// by the user during Create Job.
// directory - the path to the directory.
// linkexpiryinminutes - the number of minutes after which the download link will expire.
// maxResults - the maximum number of items to return in the response. A maximum of 1000 files can be returned.
func (client JobsClient) ListOutputFiles(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string, outputdirectoryid string, directory string, linkexpiryinminutes *int32, maxResults *int32) (result FileListResultPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "workspaceName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: experimentName,
			Constraints: []validation.Constraint{{Target: "experimentName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "experimentName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "experimentName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: jobName,
			Constraints: []validation.Constraint{{Target: "jobName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "jobName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "jobName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: linkexpiryinminutes,
			Constraints: []validation.Constraint{{Target: "linkexpiryinminutes", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "linkexpiryinminutes", Name: validation.InclusiveMaximum, Rule: int64(600), Chain: nil},
					{Target: "linkexpiryinminutes", Name: validation.InclusiveMinimum, Rule: 5, Chain: nil},
				}}}},
		{TargetValue: maxResults,
			Constraints: []validation.Constraint{{Target: "maxResults", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "maxResults", Name: validation.InclusiveMaximum, Rule: int64(1000), Chain: nil},
					{Target: "maxResults", Name: validation.InclusiveMinimum, Rule: 1, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("batchai.JobsClient", "ListOutputFiles", err.Error())
	}

	result.fn = client.listOutputFilesNextResults
	req, err := client.ListOutputFilesPreparer(ctx, resourceGroupName, workspaceName, experimentName, jobName, outputdirectoryid, directory, linkexpiryinminutes, maxResults)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListOutputFiles", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListOutputFilesSender(req)
	if err != nil {
		result.flr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListOutputFiles", resp, "Failure sending request")
		return
	}

	result.flr, err = client.ListOutputFilesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListOutputFiles", resp, "Failure responding to request")
	}

	return
}

// ListOutputFilesPreparer prepares the ListOutputFiles request.
func (client JobsClient) ListOutputFilesPreparer(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string, outputdirectoryid string, directory string, linkexpiryinminutes *int32, maxResults *int32) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"experimentName":    autorest.Encode("path", experimentName),
		"jobName":           autorest.Encode("path", jobName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version":       APIVersion,
		"outputdirectoryid": autorest.Encode("query", outputdirectoryid),
	}
	if len(directory) > 0 {
		queryParameters["directory"] = autorest.Encode("query", directory)
	} else {
		queryParameters["directory"] = autorest.Encode("query", ".")
	}
	if linkexpiryinminutes != nil {
		queryParameters["linkexpiryinminutes"] = autorest.Encode("query", *linkexpiryinminutes)
	} else {
		queryParameters["linkexpiryinminutes"] = autorest.Encode("query", 60)
	}
	if maxResults != nil {
		queryParameters["maxresults"] = autorest.Encode("query", *maxResults)
	} else {
		queryParameters["maxresults"] = autorest.Encode("query", 1000)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/listOutputFiles", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListOutputFilesSender sends the ListOutputFiles request. The method will close the
// http.Response Body if it receives an error.
func (client JobsClient) ListOutputFilesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListOutputFilesResponder handles the response to the ListOutputFiles request. The method always
// closes the http.Response Body.
func (client JobsClient) ListOutputFilesResponder(resp *http.Response) (result FileListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listOutputFilesNextResults retrieves the next set of results, if any.
func (client JobsClient) listOutputFilesNextResults(lastResults FileListResult) (result FileListResult, err error) {
	req, err := lastResults.fileListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "batchai.JobsClient", "listOutputFilesNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListOutputFilesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "batchai.JobsClient", "listOutputFilesNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListOutputFilesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "listOutputFilesNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListOutputFilesComplete enumerates all values, automatically crossing page boundaries as required.
func (client JobsClient) ListOutputFilesComplete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string, outputdirectoryid string, directory string, linkexpiryinminutes *int32, maxResults *int32) (result FileListResultIterator, err error) {
	result.page, err = client.ListOutputFiles(ctx, resourceGroupName, workspaceName, experimentName, jobName, outputdirectoryid, directory, linkexpiryinminutes, maxResults)
	return
}

// ListRemoteLoginInformation gets a list of currently existing nodes which were used for the Job execution. The
// returned information contains the node ID, its public IP and SSH port.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// workspaceName - the name of the workspace. Workspace names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// experimentName - the name of the experiment. Experiment names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// jobName - the name of the job within the specified resource group. Job names can only contain a combination
// of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64
// characters long.
func (client JobsClient) ListRemoteLoginInformation(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result RemoteLoginInformationListResultPage, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "workspaceName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: experimentName,
			Constraints: []validation.Constraint{{Target: "experimentName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "experimentName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "experimentName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: jobName,
			Constraints: []validation.Constraint{{Target: "jobName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "jobName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "jobName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("batchai.JobsClient", "ListRemoteLoginInformation", err.Error())
	}

	result.fn = client.listRemoteLoginInformationNextResults
	req, err := client.ListRemoteLoginInformationPreparer(ctx, resourceGroupName, workspaceName, experimentName, jobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListRemoteLoginInformation", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListRemoteLoginInformationSender(req)
	if err != nil {
		result.rlilr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListRemoteLoginInformation", resp, "Failure sending request")
		return
	}

	result.rlilr, err = client.ListRemoteLoginInformationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "ListRemoteLoginInformation", resp, "Failure responding to request")
	}

	return
}

// ListRemoteLoginInformationPreparer prepares the ListRemoteLoginInformation request.
func (client JobsClient) ListRemoteLoginInformationPreparer(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"experimentName":    autorest.Encode("path", experimentName),
		"jobName":           autorest.Encode("path", jobName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/listRemoteLoginInformation", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListRemoteLoginInformationSender sends the ListRemoteLoginInformation request. The method will close the
// http.Response Body if it receives an error.
func (client JobsClient) ListRemoteLoginInformationSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListRemoteLoginInformationResponder handles the response to the ListRemoteLoginInformation request. The method always
// closes the http.Response Body.
func (client JobsClient) ListRemoteLoginInformationResponder(resp *http.Response) (result RemoteLoginInformationListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listRemoteLoginInformationNextResults retrieves the next set of results, if any.
func (client JobsClient) listRemoteLoginInformationNextResults(lastResults RemoteLoginInformationListResult) (result RemoteLoginInformationListResult, err error) {
	req, err := lastResults.remoteLoginInformationListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "batchai.JobsClient", "listRemoteLoginInformationNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListRemoteLoginInformationSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "batchai.JobsClient", "listRemoteLoginInformationNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListRemoteLoginInformationResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "listRemoteLoginInformationNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListRemoteLoginInformationComplete enumerates all values, automatically crossing page boundaries as required.
func (client JobsClient) ListRemoteLoginInformationComplete(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result RemoteLoginInformationListResultIterator, err error) {
	result.page, err = client.ListRemoteLoginInformation(ctx, resourceGroupName, workspaceName, experimentName, jobName)
	return
}

// Terminate terminates a job.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// workspaceName - the name of the workspace. Workspace names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// experimentName - the name of the experiment. Experiment names can only contain a combination of alphanumeric
// characters along with dash (-) and underscore (_). The name must be from 1 through 64 characters long.
// jobName - the name of the job within the specified resource group. Job names can only contain a combination
// of alphanumeric characters along with dash (-) and underscore (_). The name must be from 1 through 64
// characters long.
func (client JobsClient) Terminate(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (result JobsTerminateFuture, err error) {
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._]+$`, Chain: nil}}},
		{TargetValue: workspaceName,
			Constraints: []validation.Constraint{{Target: "workspaceName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "workspaceName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "workspaceName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: experimentName,
			Constraints: []validation.Constraint{{Target: "experimentName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "experimentName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "experimentName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}},
		{TargetValue: jobName,
			Constraints: []validation.Constraint{{Target: "jobName", Name: validation.MaxLength, Rule: 64, Chain: nil},
				{Target: "jobName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "jobName", Name: validation.Pattern, Rule: `^[-\w_]+$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("batchai.JobsClient", "Terminate", err.Error())
	}

	req, err := client.TerminatePreparer(ctx, resourceGroupName, workspaceName, experimentName, jobName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Terminate", nil, "Failure preparing request")
		return
	}

	result, err = client.TerminateSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "batchai.JobsClient", "Terminate", result.Response(), "Failure sending request")
		return
	}

	return
}

// TerminatePreparer prepares the Terminate request.
func (client JobsClient) TerminatePreparer(ctx context.Context, resourceGroupName string, workspaceName string, experimentName string, jobName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"experimentName":    autorest.Encode("path", experimentName),
		"jobName":           autorest.Encode("path", jobName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"workspaceName":     autorest.Encode("path", workspaceName),
	}

	const APIVersion = "2018-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.BatchAI/workspaces/{workspaceName}/experiments/{experimentName}/jobs/{jobName}/terminate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// TerminateSender sends the Terminate request. The method will close the
// http.Response Body if it receives an error.
func (client JobsClient) TerminateSender(req *http.Request) (future JobsTerminateFuture, err error) {
	var resp *http.Response
	resp, err = autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	err = autorest.Respond(resp, azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted))
	if err != nil {
		return
	}
	future.Future, err = azure.NewFutureFromResponse(resp)
	return
}

// TerminateResponder handles the response to the Terminate request. The method always
// closes the http.Response Body.
func (client JobsClient) TerminateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
