package fabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ScaleUnitNodesClient is the fabric Admin Client
type ScaleUnitNodesClient struct {
	BaseClient
}

// NewScaleUnitNodesClient creates an instance of the ScaleUnitNodesClient client.
func NewScaleUnitNodesClient(subscriptionID string) ScaleUnitNodesClient {
	return NewScaleUnitNodesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewScaleUnitNodesClientWithBaseURI creates an instance of the ScaleUnitNodesClient client.
func NewScaleUnitNodesClientWithBaseURI(baseURI string, subscriptionID string) ScaleUnitNodesClient {
	return ScaleUnitNodesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get a specific scale unit node.
//
// location is location of the resource. scaleUnitNode is name of the scale unit node.
func (client ScaleUnitNodesClient) Get(ctx context.Context, location string, scaleUnitNode string) (result ScaleUnitNode, err error) {
	req, err := client.GetPreparer(ctx, location, scaleUnitNode)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ScaleUnitNodesClient) GetPreparer(ctx context.Context, location string, scaleUnitNode string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"scaleUnitNode":  autorest.Encode("path", scaleUnitNode),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ScaleUnitNodesClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ScaleUnitNodesClient) GetResponder(resp *http.Response) (result ScaleUnitNode, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get a list of all scale unit nodes in a location.
//
// location is location of the resource. filter is oData filter parameter.
func (client ScaleUnitNodesClient) List(ctx context.Context, location string, filter string) (result ScaleUnitNodeListPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, location, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.sunl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "List", resp, "Failure sending request")
		return
	}

	result.sunl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ScaleUnitNodesClient) ListPreparer(ctx context.Context, location string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ScaleUnitNodesClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ScaleUnitNodesClient) ListResponder(resp *http.Response) (result ScaleUnitNodeList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ScaleUnitNodesClient) listNextResults(lastResults ScaleUnitNodeList) (result ScaleUnitNodeList, err error) {
	req, err := lastResults.scaleUnitNodeListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ScaleUnitNodesClient) ListComplete(ctx context.Context, location string, filter string) (result ScaleUnitNodeListIterator, err error) {
	result.page, err = client.List(ctx, location, filter)
	return
}

// PowerOff power off a scale unit node.
//
// location is location of the resource. scaleUnitNode is name of the scale unit node.
func (client ScaleUnitNodesClient) PowerOff(ctx context.Context, location string, scaleUnitNode string) (result ScaleUnitNodesPowerOffFuture, err error) {
	req, err := client.PowerOffPreparer(ctx, location, scaleUnitNode)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "PowerOff", nil, "Failure preparing request")
		return
	}

	result, err = client.PowerOffSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "PowerOff", result.Response(), "Failure sending request")
		return
	}

	return
}

// PowerOffPreparer prepares the PowerOff request.
func (client ScaleUnitNodesClient) PowerOffPreparer(ctx context.Context, location string, scaleUnitNode string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"scaleUnitNode":  autorest.Encode("path", scaleUnitNode),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/PowerOff", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PowerOffSender sends the PowerOff request. The method will close the
// http.Response Body if it receives an error.
func (client ScaleUnitNodesClient) PowerOffSender(req *http.Request) (future ScaleUnitNodesPowerOffFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusInternalServerError))
	return
}

// PowerOffResponder handles the response to the PowerOff request. The method always
// closes the http.Response Body.
func (client ScaleUnitNodesClient) PowerOffResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusInternalServerError),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// PowerOn power on a scale unit node.
//
// location is location of the resource. scaleUnitNode is name of the scale unit node.
func (client ScaleUnitNodesClient) PowerOn(ctx context.Context, location string, scaleUnitNode string) (result ScaleUnitNodesPowerOnFuture, err error) {
	req, err := client.PowerOnPreparer(ctx, location, scaleUnitNode)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "PowerOn", nil, "Failure preparing request")
		return
	}

	result, err = client.PowerOnSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "PowerOn", result.Response(), "Failure sending request")
		return
	}

	return
}

// PowerOnPreparer prepares the PowerOn request.
func (client ScaleUnitNodesClient) PowerOnPreparer(ctx context.Context, location string, scaleUnitNode string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"scaleUnitNode":  autorest.Encode("path", scaleUnitNode),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/PowerOn", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PowerOnSender sends the PowerOn request. The method will close the
// http.Response Body if it receives an error.
func (client ScaleUnitNodesClient) PowerOnSender(req *http.Request) (future ScaleUnitNodesPowerOnFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusInternalServerError))
	return
}

// PowerOnResponder handles the response to the PowerOn request. The method always
// closes the http.Response Body.
func (client ScaleUnitNodesClient) PowerOnResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusInternalServerError),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StartMaintenanceMode start maintenance mode for a scale unit node.
//
// location is location of the resource. scaleUnitNode is name of the scale unit node.
func (client ScaleUnitNodesClient) StartMaintenanceMode(ctx context.Context, location string, scaleUnitNode string) (result ScaleUnitNodesStartMaintenanceModeFuture, err error) {
	req, err := client.StartMaintenanceModePreparer(ctx, location, scaleUnitNode)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "StartMaintenanceMode", nil, "Failure preparing request")
		return
	}

	result, err = client.StartMaintenanceModeSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "StartMaintenanceMode", result.Response(), "Failure sending request")
		return
	}

	return
}

// StartMaintenanceModePreparer prepares the StartMaintenanceMode request.
func (client ScaleUnitNodesClient) StartMaintenanceModePreparer(ctx context.Context, location string, scaleUnitNode string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"scaleUnitNode":  autorest.Encode("path", scaleUnitNode),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/StartMaintenanceMode", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StartMaintenanceModeSender sends the StartMaintenanceMode request. The method will close the
// http.Response Body if it receives an error.
func (client ScaleUnitNodesClient) StartMaintenanceModeSender(req *http.Request) (future ScaleUnitNodesStartMaintenanceModeFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusInternalServerError))
	return
}

// StartMaintenanceModeResponder handles the response to the StartMaintenanceMode request. The method always
// closes the http.Response Body.
func (client ScaleUnitNodesClient) StartMaintenanceModeResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusInternalServerError),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// StopMaintenanceMode stop maintenance mode for a scale unit node.
//
// location is location of the resource. scaleUnitNode is name of the scale unit node.
func (client ScaleUnitNodesClient) StopMaintenanceMode(ctx context.Context, location string, scaleUnitNode string) (result ScaleUnitNodesStopMaintenanceModeFuture, err error) {
	req, err := client.StopMaintenanceModePreparer(ctx, location, scaleUnitNode)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "StopMaintenanceMode", nil, "Failure preparing request")
		return
	}

	result, err = client.StopMaintenanceModeSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.ScaleUnitNodesClient", "StopMaintenanceMode", result.Response(), "Failure sending request")
		return
	}

	return
}

// StopMaintenanceModePreparer prepares the StopMaintenanceMode request.
func (client ScaleUnitNodesClient) StopMaintenanceModePreparer(ctx context.Context, location string, scaleUnitNode string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"scaleUnitNode":  autorest.Encode("path", scaleUnitNode),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/scaleUnitNodes/{scaleUnitNode}/StopMaintenanceMode", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// StopMaintenanceModeSender sends the StopMaintenanceMode request. The method will close the
// http.Response Body if it receives an error.
func (client ScaleUnitNodesClient) StopMaintenanceModeSender(req *http.Request) (future ScaleUnitNodesStopMaintenanceModeFuture, err error) {
	sender := autorest.DecorateSender(client, azure.DoRetryWithRegistration(client.Client))
	future.Future = azure.NewFuture(req)
	future.req = req
	_, err = future.Done(sender)
	if err != nil {
		return
	}
	err = autorest.Respond(future.Response(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusInternalServerError))
	return
}

// StopMaintenanceModeResponder handles the response to the StopMaintenanceMode request. The method always
// closes the http.Response Body.
func (client ScaleUnitNodesClient) StopMaintenanceModeResponder(resp *http.Response) (result OperationStatus, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusInternalServerError),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
