package blueprint

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ArtifactsClient is the blueprint Client
type ArtifactsClient struct {
	BaseClient
}

// NewArtifactsClient creates an instance of the ArtifactsClient client.
func NewArtifactsClient() ArtifactsClient {
	return NewArtifactsClientWithBaseURI(DefaultBaseURI)
}

// NewArtifactsClientWithBaseURI creates an instance of the ArtifactsClient client.
func NewArtifactsClientWithBaseURI(baseURI string) ArtifactsClient {
	return ArtifactsClient{NewWithBaseURI(baseURI)}
}

// CreateOrUpdate create or update Blueprint artifact.
// Parameters:
// managementGroupName - managementGroup where blueprint stores.
// blueprintName - name of the blueprint.
// artifactName - name of the artifact.
// artifact - blueprint artifact to save.
func (client ArtifactsClient) CreateOrUpdate(ctx context.Context, managementGroupName string, blueprintName string, artifactName string, artifact BasicArtifact) (result ArtifactModel, err error) {
	req, err := client.CreateOrUpdatePreparer(ctx, managementGroupName, blueprintName, artifactName, artifact)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ArtifactsClient) CreateOrUpdatePreparer(ctx context.Context, managementGroupName string, blueprintName string, artifactName string, artifact BasicArtifact) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"artifactName":        autorest.Encode("path", artifactName),
		"blueprintName":       autorest.Encode("path", blueprintName),
		"managementGroupName": autorest.Encode("path", managementGroupName),
	}

	const APIVersion = "2017-11-11-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}", pathParameters),
		autorest.WithJSON(artifact),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ArtifactsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ArtifactsClient) CreateOrUpdateResponder(resp *http.Response) (result ArtifactModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete delete a Blueprint artifact.
// Parameters:
// managementGroupName - managementGroup where blueprint stores.
// blueprintName - name of the blueprint.
// artifactName - name of the artifact.
func (client ArtifactsClient) Delete(ctx context.Context, managementGroupName string, blueprintName string, artifactName string) (result ArtifactModel, err error) {
	req, err := client.DeletePreparer(ctx, managementGroupName, blueprintName, artifactName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ArtifactsClient) DeletePreparer(ctx context.Context, managementGroupName string, blueprintName string, artifactName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"artifactName":        autorest.Encode("path", artifactName),
		"blueprintName":       autorest.Encode("path", blueprintName),
		"managementGroupName": autorest.Encode("path", managementGroupName),
	}

	const APIVersion = "2017-11-11-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ArtifactsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ArtifactsClient) DeleteResponder(resp *http.Response) (result ArtifactModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get a Blueprint artifact.
// Parameters:
// managementGroupName - managementGroup where blueprint stores.
// blueprintName - name of the blueprint.
// artifactName - name of the artifact.
func (client ArtifactsClient) Get(ctx context.Context, managementGroupName string, blueprintName string, artifactName string) (result ArtifactModel, err error) {
	req, err := client.GetPreparer(ctx, managementGroupName, blueprintName, artifactName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ArtifactsClient) GetPreparer(ctx context.Context, managementGroupName string, blueprintName string, artifactName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"artifactName":        autorest.Encode("path", artifactName),
		"blueprintName":       autorest.Encode("path", blueprintName),
		"managementGroupName": autorest.Encode("path", managementGroupName),
	}

	const APIVersion = "2017-11-11-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts/{artifactName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ArtifactsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ArtifactsClient) GetResponder(resp *http.Response) (result ArtifactModel, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List list artifacts for a given Blueprint.
// Parameters:
// managementGroupName - managementGroup where blueprint stores.
// blueprintName - name of the blueprint.
func (client ArtifactsClient) List(ctx context.Context, managementGroupName string, blueprintName string) (result ArtifactListPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, managementGroupName, blueprintName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.al.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "List", resp, "Failure sending request")
		return
	}

	result.al, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client ArtifactsClient) ListPreparer(ctx context.Context, managementGroupName string, blueprintName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"blueprintName":       autorest.Encode("path", blueprintName),
		"managementGroupName": autorest.Encode("path", managementGroupName),
	}

	const APIVersion = "2017-11-11-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupName}/providers/Microsoft.Blueprint/blueprints/{blueprintName}/artifacts", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client ArtifactsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client ArtifactsClient) ListResponder(resp *http.Response) (result ArtifactList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client ArtifactsClient) listNextResults(lastResults ArtifactList) (result ArtifactList, err error) {
	req, err := lastResults.artifactListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "blueprint.ArtifactsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client ArtifactsClient) ListComplete(ctx context.Context, managementGroupName string, blueprintName string) (result ArtifactListIterator, err error) {
	result.page, err = client.List(ctx, managementGroupName, blueprintName)
	return
}
