/*
Copyright Red Hat, Inc.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by client-gen. DO NOT EDIT.

package internalversion

import (
	"context"
	"time"

	operators "github.com/operator-framework/api/pkg/operators"
	scheme "github.com/operator-framework/operator-lifecycle-manager/pkg/api/client/clientset/internalversion/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	rest "k8s.io/client-go/rest"
)

// ClusterServiceVersionsGetter has a method to return a ClusterServiceVersionInterface.
// A group's client should implement this interface.
type ClusterServiceVersionsGetter interface {
	ClusterServiceVersions(namespace string) ClusterServiceVersionInterface
}

// ClusterServiceVersionInterface has methods to work with ClusterServiceVersion resources.
type ClusterServiceVersionInterface interface {
	Create(ctx context.Context, clusterServiceVersion *operators.ClusterServiceVersion, opts v1.CreateOptions) (*operators.ClusterServiceVersion, error)
	Update(ctx context.Context, clusterServiceVersion *operators.ClusterServiceVersion, opts v1.UpdateOptions) (*operators.ClusterServiceVersion, error)
	UpdateStatus(ctx context.Context, clusterServiceVersion *operators.ClusterServiceVersion, opts v1.UpdateOptions) (*operators.ClusterServiceVersion, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*operators.ClusterServiceVersion, error)
	List(ctx context.Context, opts v1.ListOptions) (*operators.ClusterServiceVersionList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *operators.ClusterServiceVersion, err error)
	ClusterServiceVersionExpansion
}

// clusterServiceVersions implements ClusterServiceVersionInterface
type clusterServiceVersions struct {
	client rest.Interface
	ns     string
}

// newClusterServiceVersions returns a ClusterServiceVersions
func newClusterServiceVersions(c *OperatorsClient, namespace string) *clusterServiceVersions {
	return &clusterServiceVersions{
		client: c.RESTClient(),
		ns:     namespace,
	}
}

// Get takes name of the clusterServiceVersion, and returns the corresponding clusterServiceVersion object, and an error if there is any.
func (c *clusterServiceVersions) Get(ctx context.Context, name string, options v1.GetOptions) (result *operators.ClusterServiceVersion, err error) {
	result = &operators.ClusterServiceVersion{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("clusterserviceversions").
		Name(name).
		VersionedParams(&options, scheme.ParameterCodec).
		Do(ctx).
		Into(result)
	return
}

// List takes label and field selectors, and returns the list of ClusterServiceVersions that match those selectors.
func (c *clusterServiceVersions) List(ctx context.Context, opts v1.ListOptions) (result *operators.ClusterServiceVersionList, err error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	result = &operators.ClusterServiceVersionList{}
	err = c.client.Get().
		Namespace(c.ns).
		Resource("clusterserviceversions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Do(ctx).
		Into(result)
	return
}

// Watch returns a watch.Interface that watches the requested clusterServiceVersions.
func (c *clusterServiceVersions) Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error) {
	var timeout time.Duration
	if opts.TimeoutSeconds != nil {
		timeout = time.Duration(*opts.TimeoutSeconds) * time.Second
	}
	opts.Watch = true
	return c.client.Get().
		Namespace(c.ns).
		Resource("clusterserviceversions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Timeout(timeout).
		Watch(ctx)
}

// Create takes the representation of a clusterServiceVersion and creates it.  Returns the server's representation of the clusterServiceVersion, and an error, if there is any.
func (c *clusterServiceVersions) Create(ctx context.Context, clusterServiceVersion *operators.ClusterServiceVersion, opts v1.CreateOptions) (result *operators.ClusterServiceVersion, err error) {
	result = &operators.ClusterServiceVersion{}
	err = c.client.Post().
		Namespace(c.ns).
		Resource("clusterserviceversions").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterServiceVersion).
		Do(ctx).
		Into(result)
	return
}

// Update takes the representation of a clusterServiceVersion and updates it. Returns the server's representation of the clusterServiceVersion, and an error, if there is any.
func (c *clusterServiceVersions) Update(ctx context.Context, clusterServiceVersion *operators.ClusterServiceVersion, opts v1.UpdateOptions) (result *operators.ClusterServiceVersion, err error) {
	result = &operators.ClusterServiceVersion{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("clusterserviceversions").
		Name(clusterServiceVersion.Name).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterServiceVersion).
		Do(ctx).
		Into(result)
	return
}

// UpdateStatus was generated because the type contains a Status member.
// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
func (c *clusterServiceVersions) UpdateStatus(ctx context.Context, clusterServiceVersion *operators.ClusterServiceVersion, opts v1.UpdateOptions) (result *operators.ClusterServiceVersion, err error) {
	result = &operators.ClusterServiceVersion{}
	err = c.client.Put().
		Namespace(c.ns).
		Resource("clusterserviceversions").
		Name(clusterServiceVersion.Name).
		SubResource("status").
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(clusterServiceVersion).
		Do(ctx).
		Into(result)
	return
}

// Delete takes name of the clusterServiceVersion and deletes it. Returns an error if one occurs.
func (c *clusterServiceVersions) Delete(ctx context.Context, name string, opts v1.DeleteOptions) error {
	return c.client.Delete().
		Namespace(c.ns).
		Resource("clusterserviceversions").
		Name(name).
		Body(&opts).
		Do(ctx).
		Error()
}

// DeleteCollection deletes a collection of objects.
func (c *clusterServiceVersions) DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error {
	var timeout time.Duration
	if listOpts.TimeoutSeconds != nil {
		timeout = time.Duration(*listOpts.TimeoutSeconds) * time.Second
	}
	return c.client.Delete().
		Namespace(c.ns).
		Resource("clusterserviceversions").
		VersionedParams(&listOpts, scheme.ParameterCodec).
		Timeout(timeout).
		Body(&opts).
		Do(ctx).
		Error()
}

// Patch applies the patch and returns the patched clusterServiceVersion.
func (c *clusterServiceVersions) Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *operators.ClusterServiceVersion, err error) {
	result = &operators.ClusterServiceVersion{}
	err = c.client.Patch(pt).
		Namespace(c.ns).
		Resource("clusterserviceversions").
		Name(name).
		SubResource(subresources...).
		VersionedParams(&opts, scheme.ParameterCodec).
		Body(data).
		Do(ctx).
		Into(result)
	return
}
