package fabric

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// LogicalSubnetsClient is the fabric Admin Client
type LogicalSubnetsClient struct {
	BaseClient
}

// NewLogicalSubnetsClient creates an instance of the LogicalSubnetsClient client.
func NewLogicalSubnetsClient(subscriptionID string) LogicalSubnetsClient {
	return NewLogicalSubnetsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewLogicalSubnetsClientWithBaseURI creates an instance of the LogicalSubnetsClient client.
func NewLogicalSubnetsClientWithBaseURI(baseURI string, subscriptionID string) LogicalSubnetsClient {
	return LogicalSubnetsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get a list of all volumes at a location.
//
// location is location of the resource. logicalNetwork is name of the logical network. logicalSubnet is name of
// the logical subnet.
func (client LogicalSubnetsClient) Get(ctx context.Context, location string, logicalNetwork string, logicalSubnet string) (result LogicalSubnet, err error) {
	req, err := client.GetPreparer(ctx, location, logicalNetwork, logicalSubnet)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client LogicalSubnetsClient) GetPreparer(ctx context.Context, location string, logicalNetwork string, logicalSubnet string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"logicalNetwork": autorest.Encode("path", logicalNetwork),
		"logicalSubnet":  autorest.Encode("path", logicalSubnet),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/logicalNetworks/{logicalNetwork}/logicalSubnets/{logicalSubnet}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client LogicalSubnetsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client LogicalSubnetsClient) GetResponder(resp *http.Response) (result LogicalSubnet, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List get a list of all logical subnets.
//
// location is location of the resource. logicalNetwork is name of the logical network. filter is oData filter
// parameter.
func (client LogicalSubnetsClient) List(ctx context.Context, location string, logicalNetwork string, filter string) (result LogicalSubnetListPage, err error) {
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, location, logicalNetwork, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.lsl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "List", resp, "Failure sending request")
		return
	}

	result.lsl, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client LogicalSubnetsClient) ListPreparer(ctx context.Context, location string, logicalNetwork string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"location":       autorest.Encode("path", location),
		"logicalNetwork": autorest.Encode("path", logicalNetwork),
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2016-05-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/System.{location}/providers/Microsoft.Fabric.Admin/fabricLocations/{location}/logicalNetworks/{logicalNetwork}/logicalSubnets", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client LogicalSubnetsClient) ListSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client LogicalSubnetsClient) ListResponder(resp *http.Response) (result LogicalSubnetList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client LogicalSubnetsClient) listNextResults(lastResults LogicalSubnetList) (result LogicalSubnetList, err error) {
	req, err := lastResults.logicalSubnetListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "fabric.LogicalSubnetsClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client LogicalSubnetsClient) ListComplete(ctx context.Context, location string, logicalNetwork string, filter string) (result LogicalSubnetListIterator, err error) {
	result.page, err = client.List(ctx, location, logicalNetwork, filter)
	return
}
