package servicefabricmesh

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ReplicaClient is the service Fabric Mesh Management Client
type ReplicaClient struct {
	BaseClient
}

// NewReplicaClient creates an instance of the ReplicaClient client.
func NewReplicaClient(subscriptionID string) ReplicaClient {
	return NewReplicaClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewReplicaClientWithBaseURI creates an instance of the ReplicaClient client.
func NewReplicaClientWithBaseURI(baseURI string, subscriptionID string) ReplicaClient {
	return ReplicaClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets the information about the specified replica of a given service of an application. The information includes
// the runtime properties of the replica instance.
// Parameters:
// resourceGroupName - azure resource group name
// applicationName - the identity of the application.
// serviceName - the identity of the service.
// replicaName - the identity of the service replica.
func (client ReplicaClient) Get(ctx context.Context, resourceGroupName string, applicationName string, serviceName string, replicaName string) (result ServiceReplicaDescription, err error) {
	req, err := client.GetPreparer(ctx, resourceGroupName, applicationName, serviceName, replicaName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ReplicaClient) GetPreparer(ctx context.Context, resourceGroupName string, applicationName string, serviceName string, replicaName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationName":   applicationName,
		"replicaName":       replicaName,
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       serviceName,
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/applications/{applicationName}/services/{serviceName}/replicas/{replicaName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicaClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ReplicaClient) GetResponder(resp *http.Response) (result ServiceReplicaDescription, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByServiceName gets the information about all replicas of a given service of an application. The information
// includes the runtime properties of the replica instance.
// Parameters:
// resourceGroupName - azure resource group name
// applicationName - the identity of the application.
// serviceName - the identity of the service.
func (client ReplicaClient) ListByServiceName(ctx context.Context, resourceGroupName string, applicationName string, serviceName string) (result ServiceReplicaListPage, err error) {
	result.fn = client.listByServiceNameNextResults
	req, err := client.ListByServiceNamePreparer(ctx, resourceGroupName, applicationName, serviceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "ListByServiceName", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByServiceNameSender(req)
	if err != nil {
		result.srl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "ListByServiceName", resp, "Failure sending request")
		return
	}

	result.srl, err = client.ListByServiceNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "ListByServiceName", resp, "Failure responding to request")
	}

	return
}

// ListByServiceNamePreparer prepares the ListByServiceName request.
func (client ReplicaClient) ListByServiceNamePreparer(ctx context.Context, resourceGroupName string, applicationName string, serviceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"applicationName":   applicationName,
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"serviceName":       serviceName,
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2018-07-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ServiceFabricMesh/applications/{applicationName}/services/{serviceName}/replicas", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByServiceNameSender sends the ListByServiceName request. The method will close the
// http.Response Body if it receives an error.
func (client ReplicaClient) ListByServiceNameSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req,
		azure.DoRetryWithRegistration(client.Client))
}

// ListByServiceNameResponder handles the response to the ListByServiceName request. The method always
// closes the http.Response Body.
func (client ReplicaClient) ListByServiceNameResponder(resp *http.Response) (result ServiceReplicaList, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByServiceNameNextResults retrieves the next set of results, if any.
func (client ReplicaClient) listByServiceNameNextResults(lastResults ServiceReplicaList) (result ServiceReplicaList, err error) {
	req, err := lastResults.serviceReplicaListPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "listByServiceNameNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByServiceNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "listByServiceNameNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByServiceNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "servicefabricmesh.ReplicaClient", "listByServiceNameNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByServiceNameComplete enumerates all values, automatically crossing page boundaries as required.
func (client ReplicaClient) ListByServiceNameComplete(ctx context.Context, resourceGroupName string, applicationName string, serviceName string) (result ServiceReplicaListIterator, err error) {
	result.page, err = client.ListByServiceName(ctx, resourceGroupName, applicationName, serviceName)
	return
}
