package datadogapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/preview/datadog/mgmt/2020-02-01-preview/datadog"
	"github.com/Azure/go-autorest/autorest"
)

// MarketplaceAgreementsClientAPI contains the set of methods on the MarketplaceAgreementsClient type.
type MarketplaceAgreementsClientAPI interface {
	Create(ctx context.Context, body *datadog.AgreementResource) (result datadog.AgreementResource, err error)
	List(ctx context.Context) (result datadog.AgreementResourceListResponsePage, err error)
	ListComplete(ctx context.Context) (result datadog.AgreementResourceListResponseIterator, err error)
}

var _ MarketplaceAgreementsClientAPI = (*datadog.MarketplaceAgreementsClient)(nil)

// APIKeysClientAPI contains the set of methods on the APIKeysClient type.
type APIKeysClientAPI interface {
	GetDefaultKey(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.APIKey, err error)
	List(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.APIKeyListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.APIKeyListResponseIterator, err error)
	SetDefaultKey(ctx context.Context, resourceGroupName string, monitorName string, body *datadog.APIKey) (result autorest.Response, err error)
}

var _ APIKeysClientAPI = (*datadog.APIKeysClient)(nil)

// HostsClientAPI contains the set of methods on the HostsClient type.
type HostsClientAPI interface {
	List(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.HostListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.HostListResponseIterator, err error)
}

var _ HostsClientAPI = (*datadog.HostsClient)(nil)

// LinkedResourcesClientAPI contains the set of methods on the LinkedResourcesClient type.
type LinkedResourcesClientAPI interface {
	List(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.LinkedResourceListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.LinkedResourceListResponseIterator, err error)
}

var _ LinkedResourcesClientAPI = (*datadog.LinkedResourcesClient)(nil)

// MonitoredResourcesClientAPI contains the set of methods on the MonitoredResourcesClient type.
type MonitoredResourcesClientAPI interface {
	List(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.MonitoredResourceListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.MonitoredResourceListResponseIterator, err error)
}

var _ MonitoredResourcesClientAPI = (*datadog.MonitoredResourcesClient)(nil)

// OperationsClientAPI contains the set of methods on the OperationsClient type.
type OperationsClientAPI interface {
	List(ctx context.Context) (result datadog.OperationListResultPage, err error)
	ListComplete(ctx context.Context) (result datadog.OperationListResultIterator, err error)
}

var _ OperationsClientAPI = (*datadog.OperationsClient)(nil)

// MonitorsClientAPI contains the set of methods on the MonitorsClient type.
type MonitorsClientAPI interface {
	Create(ctx context.Context, resourceGroupName string, monitorName string, body *datadog.MonitorResource) (result datadog.MonitorsCreateFuture, err error)
	Delete(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.MonitorsDeleteFuture, err error)
	Get(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.MonitorResource, err error)
	List(ctx context.Context) (result datadog.MonitorResourceListResponsePage, err error)
	ListComplete(ctx context.Context) (result datadog.MonitorResourceListResponseIterator, err error)
	ListByResourceGroup(ctx context.Context, resourceGroupName string) (result datadog.MonitorResourceListResponsePage, err error)
	ListByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result datadog.MonitorResourceListResponseIterator, err error)
	Update(ctx context.Context, resourceGroupName string, monitorName string, body *datadog.MonitorResourceUpdateParameters) (result datadog.MonitorResource, err error)
}

var _ MonitorsClientAPI = (*datadog.MonitorsClient)(nil)

// RefreshSetPasswordClientAPI contains the set of methods on the RefreshSetPasswordClient type.
type RefreshSetPasswordClientAPI interface {
	Get(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.SetPasswordLink, err error)
}

var _ RefreshSetPasswordClientAPI = (*datadog.RefreshSetPasswordClient)(nil)

// TagRulesClientAPI contains the set of methods on the TagRulesClient type.
type TagRulesClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, monitorName string, ruleSetName string, body *datadog.MonitoringTagRules) (result datadog.MonitoringTagRules, err error)
	Get(ctx context.Context, resourceGroupName string, monitorName string, ruleSetName string) (result datadog.MonitoringTagRules, err error)
	List(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.MonitoringTagRulesListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.MonitoringTagRulesListResponseIterator, err error)
}

var _ TagRulesClientAPI = (*datadog.TagRulesClient)(nil)

// SingleSignOnConfigurationsClientAPI contains the set of methods on the SingleSignOnConfigurationsClient type.
type SingleSignOnConfigurationsClientAPI interface {
	CreateOrUpdate(ctx context.Context, resourceGroupName string, monitorName string, configurationName string, body *datadog.SingleSignOnResource) (result datadog.SingleSignOnConfigurationsCreateOrUpdateFuture, err error)
	Get(ctx context.Context, resourceGroupName string, monitorName string, configurationName string) (result datadog.SingleSignOnResource, err error)
	List(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.SingleSignOnResourceListResponsePage, err error)
	ListComplete(ctx context.Context, resourceGroupName string, monitorName string) (result datadog.SingleSignOnResourceListResponseIterator, err error)
}

var _ SingleSignOnConfigurationsClientAPI = (*datadog.SingleSignOnConfigurationsClient)(nil)
