package anomalydetector

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// TimeGranularity enumerates the values for time granularity.
type TimeGranularity string

const (
	// Daily ...
	Daily TimeGranularity = "daily"
	// Hourly ...
	Hourly TimeGranularity = "hourly"
	// Monthly ...
	Monthly TimeGranularity = "monthly"
	// PerMinute ...
	PerMinute TimeGranularity = "minutely"
	// PerSecond ...
	PerSecond TimeGranularity = "secondly"
	// Weekly ...
	Weekly TimeGranularity = "weekly"
	// Yearly ...
	Yearly TimeGranularity = "yearly"
)

// PossibleTimeGranularityValues returns an array of possible values for the TimeGranularity const type.
func PossibleTimeGranularityValues() []TimeGranularity {
	return []TimeGranularity{Daily, Hourly, Monthly, PerMinute, PerSecond, Weekly, Yearly}
}
