package operationalinsights

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// PurgeState enumerates the values for purge state.
type PurgeState string

const (
	// Completed ...
	Completed PurgeState = "completed"
	// Pending ...
	Pending PurgeState = "pending"
)

// PossiblePurgeStateValues returns an array of possible values for the PurgeState const type.
func PossiblePurgeStateValues() []PurgeState {
	return []PurgeState{Completed, Pending}
}

// SearchSortEnum enumerates the values for search sort enum.
type SearchSortEnum string

const (
	// Asc ...
	Asc SearchSortEnum = "asc"
	// Desc ...
	Desc SearchSortEnum = "desc"
)

// PossibleSearchSortEnumValues returns an array of possible values for the SearchSortEnum const type.
func PossibleSearchSortEnumValues() []SearchSortEnum {
	return []SearchSortEnum{Asc, Desc}
}

// SkuNameEnum enumerates the values for sku name enum.
type SkuNameEnum string

const (
	// CapacityReservation ...
	CapacityReservation SkuNameEnum = "CapacityReservation"
	// Free ...
	Free SkuNameEnum = "Free"
	// PerGB2018 ...
	PerGB2018 SkuNameEnum = "PerGB2018"
	// PerNode ...
	PerNode SkuNameEnum = "PerNode"
	// Premium ...
	Premium SkuNameEnum = "Premium"
	// Standalone ...
	Standalone SkuNameEnum = "Standalone"
	// Standard ...
	Standard SkuNameEnum = "Standard"
)

// PossibleSkuNameEnumValues returns an array of possible values for the SkuNameEnum const type.
func PossibleSkuNameEnumValues() []SkuNameEnum {
	return []SkuNameEnum{CapacityReservation, Free, PerGB2018, PerNode, Premium, Standalone, Standard}
}

// StorageInsightState enumerates the values for storage insight state.
type StorageInsightState string

const (
	// ERROR ...
	ERROR StorageInsightState = "ERROR"
	// OK ...
	OK StorageInsightState = "OK"
)

// PossibleStorageInsightStateValues returns an array of possible values for the StorageInsightState const type.
func PossibleStorageInsightStateValues() []StorageInsightState {
	return []StorageInsightState{ERROR, OK}
}
