// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type StopAppReplicationInput struct {
	_ struct{} `type:"structure"`

	// ID of the application to stop replicating.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s StopAppReplicationInput) String() string {
	return awsutil.Prettify(s)
}

type StopAppReplicationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StopAppReplicationOutput) String() string {
	return awsutil.Prettify(s)
}

const opStopAppReplication = "StopAppReplication"

// StopAppReplicationRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Stops replicating an application.
//
//    // Example sending a request using StopAppReplicationRequest.
//    req := client.StopAppReplicationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/StopAppReplication
func (c *Client) StopAppReplicationRequest(input *StopAppReplicationInput) StopAppReplicationRequest {
	op := &aws.Operation{
		Name:       opStopAppReplication,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopAppReplicationInput{}
	}

	req := c.newRequest(op, input, &StopAppReplicationOutput{})
	return StopAppReplicationRequest{Request: req, Input: input, Copy: c.StopAppReplicationRequest}
}

// StopAppReplicationRequest is the request type for the
// StopAppReplication API operation.
type StopAppReplicationRequest struct {
	*aws.Request
	Input *StopAppReplicationInput
	Copy  func(*StopAppReplicationInput) StopAppReplicationRequest
}

// Send marshals and sends the StopAppReplication API request.
func (r StopAppReplicationRequest) Send(ctx context.Context) (*StopAppReplicationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StopAppReplicationResponse{
		StopAppReplicationOutput: r.Request.Data.(*StopAppReplicationOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StopAppReplicationResponse is the response type for the
// StopAppReplication API operation.
type StopAppReplicationResponse struct {
	*StopAppReplicationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StopAppReplication request.
func (r *StopAppReplicationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
