package web

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// StaticSitesClient is the webSite Management Client
type StaticSitesClient struct {
	BaseClient
}

// NewStaticSitesClient creates an instance of the StaticSitesClient client.
func NewStaticSitesClient(subscriptionID string) StaticSitesClient {
	return NewStaticSitesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewStaticSitesClientWithBaseURI creates an instance of the StaticSitesClient client using a custom endpoint.  Use
// this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewStaticSitesClientWithBaseURI(baseURI string, subscriptionID string) StaticSitesClient {
	return StaticSitesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdateStaticSite description for Creates a new static site in an existing resource group, or updates an
// existing static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site to create or update.
// staticSiteEnvelope - a JSON representation of the staticsite properties. See example.
func (client StaticSitesClient) CreateOrUpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSiteARMResource) (result StaticSiteARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSite", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSitePreparer(ctx, resourceGroupName, name, staticSiteEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateStaticSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSite", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateStaticSitePreparer prepares the CreateOrUpdateStaticSite request.
func (client StaticSitesClient) CreateOrUpdateStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSiteARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}", pathParameters),
		autorest.WithJSON(staticSiteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteSender sends the CreateOrUpdateStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateStaticSiteResponder handles the response to the CreateOrUpdateStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteResponder(resp *http.Response) (result StaticSiteARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettings description for Creates or updates the function app settings of a
// static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// prID - the stage site identifier.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, prID string, appSettings StringDictionary) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSiteBuildFunctionAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildFunctionAppSettings", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSiteBuildFunctionAppSettingsPreparer(ctx, resourceGroupName, name, prID, appSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildFunctionAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateStaticSiteBuildFunctionAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildFunctionAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteBuildFunctionAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteBuildFunctionAppSettings", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettingsPreparer prepares the CreateOrUpdateStaticSiteBuildFunctionAppSettings request.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, prID string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"prId":              autorest.Encode("path", prID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/config/functionappsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettingsSender sends the CreateOrUpdateStaticSiteBuildFunctionAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateStaticSiteBuildFunctionAppSettingsResponder handles the response to the CreateOrUpdateStaticSiteBuildFunctionAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteBuildFunctionAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSiteCustomDomain description for Creates a new static site custom domain in an existing resource
// group and static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// domainName - the custom domain to create.
func (client StaticSitesClient) CreateOrUpdateStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string) (result StaticSiteCustomDomainOverviewARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSiteCustomDomain")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSiteCustomDomain", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSiteCustomDomainPreparer(ctx, resourceGroupName, name, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteCustomDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateStaticSiteCustomDomainSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteCustomDomain", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteCustomDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteCustomDomain", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateStaticSiteCustomDomainPreparer prepares the CreateOrUpdateStaticSiteCustomDomain request.
func (client StaticSitesClient) CreateOrUpdateStaticSiteCustomDomainPreparer(ctx context.Context, resourceGroupName string, name string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteCustomDomainSender sends the CreateOrUpdateStaticSiteCustomDomain request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteCustomDomainSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateStaticSiteCustomDomainResponder handles the response to the CreateOrUpdateStaticSiteCustomDomain request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteCustomDomainResponder(resp *http.Response) (result StaticSiteCustomDomainOverviewARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateStaticSiteFunctionAppSettings description for Creates or updates the function app settings of a static
// site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateOrUpdateStaticSiteFunctionAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateOrUpdateStaticSiteFunctionAppSettings", err.Error())
	}

	req, err := client.CreateOrUpdateStaticSiteFunctionAppSettingsPreparer(ctx, resourceGroupName, name, appSettings)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteFunctionAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateStaticSiteFunctionAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteFunctionAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateStaticSiteFunctionAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateOrUpdateStaticSiteFunctionAppSettings", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdateStaticSiteFunctionAppSettingsPreparer prepares the CreateOrUpdateStaticSiteFunctionAppSettings request.
func (client StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, appSettings StringDictionary) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/config/functionappsettings", pathParameters),
		autorest.WithJSON(appSettings),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateStaticSiteFunctionAppSettingsSender sends the CreateOrUpdateStaticSiteFunctionAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateStaticSiteFunctionAppSettingsResponder handles the response to the CreateOrUpdateStaticSiteFunctionAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateOrUpdateStaticSiteFunctionAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateUserRolesInvitationLink description for Creates an invitation link for a user with the role
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) CreateUserRolesInvitationLink(ctx context.Context, resourceGroupName string, name string, staticSiteUserRolesInvitationEnvelope StaticSiteUserInvitationRequestResource) (result StaticSiteUserInvitationResponseResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.CreateUserRolesInvitationLink")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "CreateUserRolesInvitationLink", err.Error())
	}

	req, err := client.CreateUserRolesInvitationLinkPreparer(ctx, resourceGroupName, name, staticSiteUserRolesInvitationEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateUserRolesInvitationLink", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateUserRolesInvitationLinkSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateUserRolesInvitationLink", resp, "Failure sending request")
		return
	}

	result, err = client.CreateUserRolesInvitationLinkResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "CreateUserRolesInvitationLink", resp, "Failure responding to request")
	}

	return
}

// CreateUserRolesInvitationLinkPreparer prepares the CreateUserRolesInvitationLink request.
func (client StaticSitesClient) CreateUserRolesInvitationLinkPreparer(ctx context.Context, resourceGroupName string, name string, staticSiteUserRolesInvitationEnvelope StaticSiteUserInvitationRequestResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/createUserInvitation", pathParameters),
		autorest.WithJSON(staticSiteUserRolesInvitationEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateUserRolesInvitationLinkSender sends the CreateUserRolesInvitationLink request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) CreateUserRolesInvitationLinkSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateUserRolesInvitationLinkResponder handles the response to the CreateUserRolesInvitationLink request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) CreateUserRolesInvitationLinkResponder(resp *http.Response) (result StaticSiteUserInvitationResponseResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// DeleteStaticSite description for Deletes a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site to delete.
func (client StaticSitesClient) DeleteStaticSite(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeleteStaticSite")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeleteStaticSite", err.Error())
	}

	req, err := client.DeleteStaticSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteStaticSiteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSite", resp, "Failure responding to request")
	}

	return
}

// DeleteStaticSitePreparer prepares the DeleteStaticSite request.
func (client StaticSitesClient) DeleteStaticSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStaticSiteSender sends the DeleteStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeleteStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteStaticSiteResponder handles the response to the DeleteStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeleteStaticSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteStaticSiteBuild description for Deletes a static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// prID - the stage site identifier.
func (client StaticSitesClient) DeleteStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, prID string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeleteStaticSiteBuild")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeleteStaticSiteBuild", err.Error())
	}

	req, err := client.DeleteStaticSiteBuildPreparer(ctx, resourceGroupName, name, prID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteStaticSiteBuildSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteBuild", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteStaticSiteBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteBuild", resp, "Failure responding to request")
	}

	return
}

// DeleteStaticSiteBuildPreparer prepares the DeleteStaticSiteBuild request.
func (client StaticSitesClient) DeleteStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, prID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"prId":              autorest.Encode("path", prID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStaticSiteBuildSender sends the DeleteStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeleteStaticSiteBuildSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteStaticSiteBuildResponder handles the response to the DeleteStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeleteStaticSiteBuildResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteStaticSiteCustomDomain description for Deletes a custom domain.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// domainName - the custom domain to delete.
func (client StaticSitesClient) DeleteStaticSiteCustomDomain(ctx context.Context, resourceGroupName string, name string, domainName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeleteStaticSiteCustomDomain")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeleteStaticSiteCustomDomain", err.Error())
	}

	req, err := client.DeleteStaticSiteCustomDomainPreparer(ctx, resourceGroupName, name, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteCustomDomain", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteStaticSiteCustomDomainSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteCustomDomain", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteStaticSiteCustomDomainResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteCustomDomain", resp, "Failure responding to request")
	}

	return
}

// DeleteStaticSiteCustomDomainPreparer prepares the DeleteStaticSiteCustomDomain request.
func (client StaticSitesClient) DeleteStaticSiteCustomDomainPreparer(ctx context.Context, resourceGroupName string, name string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStaticSiteCustomDomainSender sends the DeleteStaticSiteCustomDomain request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeleteStaticSiteCustomDomainSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteStaticSiteCustomDomainResponder handles the response to the DeleteStaticSiteCustomDomain request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeleteStaticSiteCustomDomainResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteStaticSiteUser description for Deletes the user entry from the static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the staticsite.
// authprovider - the auth provider for this user.
// userid - the user id of the user.
func (client StaticSitesClient) DeleteStaticSiteUser(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DeleteStaticSiteUser")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DeleteStaticSiteUser", err.Error())
	}

	req, err := client.DeleteStaticSiteUserPreparer(ctx, resourceGroupName, name, authprovider, userid)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteUser", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteStaticSiteUserSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteUser", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteStaticSiteUserResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DeleteStaticSiteUser", resp, "Failure responding to request")
	}

	return
}

// DeleteStaticSiteUserPreparer prepares the DeleteStaticSiteUser request.
func (client StaticSitesClient) DeleteStaticSiteUserPreparer(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authprovider":      autorest.Encode("path", authprovider),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"userid":            autorest.Encode("path", userid),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteStaticSiteUserSender sends the DeleteStaticSiteUser request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DeleteStaticSiteUserSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteStaticSiteUserResponder handles the response to the DeleteStaticSiteUser request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DeleteStaticSiteUserResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DetachStaticSite description for Detaches a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site to detach.
func (client StaticSitesClient) DetachStaticSite(ctx context.Context, resourceGroupName string, name string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.DetachStaticSite")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "DetachStaticSite", err.Error())
	}

	req, err := client.DetachStaticSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.DetachStaticSiteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.DetachStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "DetachStaticSite", resp, "Failure responding to request")
	}

	return
}

// DetachStaticSitePreparer prepares the DetachStaticSite request.
func (client StaticSitesClient) DetachStaticSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/detach", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DetachStaticSiteSender sends the DetachStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) DetachStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DetachStaticSiteResponder handles the response to the DetachStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) DetachStaticSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// GetStaticSite description for Gets the details of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) GetStaticSite(ctx context.Context, resourceGroupName string, name string) (result StaticSiteARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSite", err.Error())
	}

	req, err := client.GetStaticSitePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.GetStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSite", resp, "Failure responding to request")
	}

	return
}

// GetStaticSitePreparer prepares the GetStaticSite request.
func (client StaticSitesClient) GetStaticSitePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSiteSender sends the GetStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSiteResponder handles the response to the GetStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSiteResponder(resp *http.Response) (result StaticSiteARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStaticSiteBuild description for Gets the details of a static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// prID - the stage site identifier.
func (client StaticSitesClient) GetStaticSiteBuild(ctx context.Context, resourceGroupName string, name string, prID string) (result StaticSiteBuildARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSiteBuild")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSiteBuild", err.Error())
	}

	req, err := client.GetStaticSiteBuildPreparer(ctx, resourceGroupName, name, prID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuild", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSiteBuildSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuild", resp, "Failure sending request")
		return
	}

	result, err = client.GetStaticSiteBuildResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuild", resp, "Failure responding to request")
	}

	return
}

// GetStaticSiteBuildPreparer prepares the GetStaticSiteBuild request.
func (client StaticSitesClient) GetStaticSiteBuildPreparer(ctx context.Context, resourceGroupName string, name string, prID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"prId":              autorest.Encode("path", prID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSiteBuildSender sends the GetStaticSiteBuild request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSiteBuildSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSiteBuildResponder handles the response to the GetStaticSiteBuild request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSiteBuildResponder(resp *http.Response) (result StaticSiteBuildARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetStaticSiteBuilds description for Gets all static site builds for a particular static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) GetStaticSiteBuilds(ctx context.Context, resourceGroupName string, name string) (result StaticSiteBuildCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSiteBuilds")
		defer func() {
			sc := -1
			if result.ssbc.Response.Response != nil {
				sc = result.ssbc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSiteBuilds", err.Error())
	}

	result.fn = client.getStaticSiteBuildsNextResults
	req, err := client.GetStaticSiteBuildsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuilds", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSiteBuildsSender(req)
	if err != nil {
		result.ssbc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuilds", resp, "Failure sending request")
		return
	}

	result.ssbc, err = client.GetStaticSiteBuildsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSiteBuilds", resp, "Failure responding to request")
	}

	return
}

// GetStaticSiteBuildsPreparer prepares the GetStaticSiteBuilds request.
func (client StaticSitesClient) GetStaticSiteBuildsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSiteBuildsSender sends the GetStaticSiteBuilds request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSiteBuildsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSiteBuildsResponder handles the response to the GetStaticSiteBuilds request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSiteBuildsResponder(resp *http.Response) (result StaticSiteBuildCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getStaticSiteBuildsNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) getStaticSiteBuildsNextResults(ctx context.Context, lastResults StaticSiteBuildCollection) (result StaticSiteBuildCollection, err error) {
	req, err := lastResults.staticSiteBuildCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSiteBuildsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetStaticSiteBuildsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSiteBuildsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetStaticSiteBuildsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSiteBuildsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetStaticSiteBuildsComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) GetStaticSiteBuildsComplete(ctx context.Context, resourceGroupName string, name string) (result StaticSiteBuildCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSiteBuilds")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetStaticSiteBuilds(ctx, resourceGroupName, name)
	return
}

// GetStaticSitesByResourceGroup description for Gets all static sites in the specified resource group.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
func (client StaticSitesClient) GetStaticSitesByResourceGroup(ctx context.Context, resourceGroupName string) (result StaticSiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSitesByResourceGroup")
		defer func() {
			sc := -1
			if result.ssc.Response.Response != nil {
				sc = result.ssc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "GetStaticSitesByResourceGroup", err.Error())
	}

	result.fn = client.getStaticSitesByResourceGroupNextResults
	req, err := client.GetStaticSitesByResourceGroupPreparer(ctx, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSitesByResourceGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetStaticSitesByResourceGroupSender(req)
	if err != nil {
		result.ssc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSitesByResourceGroup", resp, "Failure sending request")
		return
	}

	result.ssc, err = client.GetStaticSitesByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "GetStaticSitesByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// GetStaticSitesByResourceGroupPreparer prepares the GetStaticSitesByResourceGroup request.
func (client StaticSitesClient) GetStaticSitesByResourceGroupPreparer(ctx context.Context, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetStaticSitesByResourceGroupSender sends the GetStaticSitesByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) GetStaticSitesByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetStaticSitesByResourceGroupResponder handles the response to the GetStaticSitesByResourceGroup request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) GetStaticSitesByResourceGroupResponder(resp *http.Response) (result StaticSiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getStaticSitesByResourceGroupNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) getStaticSitesByResourceGroupNextResults(ctx context.Context, lastResults StaticSiteCollection) (result StaticSiteCollection, err error) {
	req, err := lastResults.staticSiteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSitesByResourceGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetStaticSitesByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSitesByResourceGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetStaticSitesByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "getStaticSitesByResourceGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetStaticSitesByResourceGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) GetStaticSitesByResourceGroupComplete(ctx context.Context, resourceGroupName string) (result StaticSiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.GetStaticSitesByResourceGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.GetStaticSitesByResourceGroup(ctx, resourceGroupName)
	return
}

// List description for Get all Static Sites for a subscription.
func (client StaticSitesClient) List(ctx context.Context) (result StaticSiteCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.List")
		defer func() {
			sc := -1
			if result.ssc.Response.Response != nil {
				sc = result.ssc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.ssc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "List", resp, "Failure sending request")
		return
	}

	result.ssc, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "List", resp, "Failure responding to request")
	}

	return
}

// ListPreparer prepares the List request.
func (client StaticSitesClient) ListPreparer(ctx context.Context) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Web/staticSites", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListResponder(resp *http.Response) (result StaticSiteCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listNextResults(ctx context.Context, lastResults StaticSiteCollection) (result StaticSiteCollection, err error) {
	req, err := lastResults.staticSiteCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListComplete(ctx context.Context) (result StaticSiteCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx)
	return
}

// ListStaticSiteBuildFunctionAppSettings description for Gets the application settings of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// prID - the stage site identifier.
func (client StaticSitesClient) ListStaticSiteBuildFunctionAppSettings(ctx context.Context, resourceGroupName string, name string, prID string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteBuildFunctionAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteBuildFunctionAppSettings", err.Error())
	}

	req, err := client.ListStaticSiteBuildFunctionAppSettingsPreparer(ctx, resourceGroupName, name, prID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctionAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteBuildFunctionAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctionAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteBuildFunctionAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctionAppSettings", resp, "Failure responding to request")
	}

	return
}

// ListStaticSiteBuildFunctionAppSettingsPreparer prepares the ListStaticSiteBuildFunctionAppSettings request.
func (client StaticSitesClient) ListStaticSiteBuildFunctionAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string, prID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"prId":              autorest.Encode("path", prID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/listFunctionAppSettings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteBuildFunctionAppSettingsSender sends the ListStaticSiteBuildFunctionAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteBuildFunctionAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteBuildFunctionAppSettingsResponder handles the response to the ListStaticSiteBuildFunctionAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteBuildFunctionAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteBuildFunctions description for Gets the functions of a particular static site build.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// prID - the stage site identifier.
func (client StaticSitesClient) ListStaticSiteBuildFunctions(ctx context.Context, resourceGroupName string, name string, prID string) (result StaticSiteFunctionOverviewCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteBuildFunctions")
		defer func() {
			sc := -1
			if result.ssfoc.Response.Response != nil {
				sc = result.ssfoc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteBuildFunctions", err.Error())
	}

	result.fn = client.listStaticSiteBuildFunctionsNextResults
	req, err := client.ListStaticSiteBuildFunctionsPreparer(ctx, resourceGroupName, name, prID)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteBuildFunctionsSender(req)
	if err != nil {
		result.ssfoc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctions", resp, "Failure sending request")
		return
	}

	result.ssfoc, err = client.ListStaticSiteBuildFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteBuildFunctions", resp, "Failure responding to request")
	}

	return
}

// ListStaticSiteBuildFunctionsPreparer prepares the ListStaticSiteBuildFunctions request.
func (client StaticSitesClient) ListStaticSiteBuildFunctionsPreparer(ctx context.Context, resourceGroupName string, name string, prID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"prId":              autorest.Encode("path", prID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/builds/{prId}/functions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteBuildFunctionsSender sends the ListStaticSiteBuildFunctions request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteBuildFunctionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteBuildFunctionsResponder handles the response to the ListStaticSiteBuildFunctions request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteBuildFunctionsResponder(resp *http.Response) (result StaticSiteFunctionOverviewCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStaticSiteBuildFunctionsNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listStaticSiteBuildFunctionsNextResults(ctx context.Context, lastResults StaticSiteFunctionOverviewCollection) (result StaticSiteFunctionOverviewCollection, err error) {
	req, err := lastResults.staticSiteFunctionOverviewCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteBuildFunctionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStaticSiteBuildFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteBuildFunctionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStaticSiteBuildFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteBuildFunctionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStaticSiteBuildFunctionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListStaticSiteBuildFunctionsComplete(ctx context.Context, resourceGroupName string, name string, prID string) (result StaticSiteFunctionOverviewCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteBuildFunctions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStaticSiteBuildFunctions(ctx, resourceGroupName, name, prID)
	return
}

// ListStaticSiteCustomDomains description for Gets all static site custom domains for a particular static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site resource to search in.
func (client StaticSitesClient) ListStaticSiteCustomDomains(ctx context.Context, resourceGroupName string, name string) (result StaticSiteCustomDomainOverviewCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteCustomDomains")
		defer func() {
			sc := -1
			if result.sscdoc.Response.Response != nil {
				sc = result.sscdoc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteCustomDomains", err.Error())
	}

	result.fn = client.listStaticSiteCustomDomainsNextResults
	req, err := client.ListStaticSiteCustomDomainsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteCustomDomains", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteCustomDomainsSender(req)
	if err != nil {
		result.sscdoc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteCustomDomains", resp, "Failure sending request")
		return
	}

	result.sscdoc, err = client.ListStaticSiteCustomDomainsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteCustomDomains", resp, "Failure responding to request")
	}

	return
}

// ListStaticSiteCustomDomainsPreparer prepares the ListStaticSiteCustomDomains request.
func (client StaticSitesClient) ListStaticSiteCustomDomainsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteCustomDomainsSender sends the ListStaticSiteCustomDomains request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteCustomDomainsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteCustomDomainsResponder handles the response to the ListStaticSiteCustomDomains request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteCustomDomainsResponder(resp *http.Response) (result StaticSiteCustomDomainOverviewCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStaticSiteCustomDomainsNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listStaticSiteCustomDomainsNextResults(ctx context.Context, lastResults StaticSiteCustomDomainOverviewCollection) (result StaticSiteCustomDomainOverviewCollection, err error) {
	req, err := lastResults.staticSiteCustomDomainOverviewCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteCustomDomainsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStaticSiteCustomDomainsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteCustomDomainsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStaticSiteCustomDomainsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteCustomDomainsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStaticSiteCustomDomainsComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListStaticSiteCustomDomainsComplete(ctx context.Context, resourceGroupName string, name string) (result StaticSiteCustomDomainOverviewCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteCustomDomains")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStaticSiteCustomDomains(ctx, resourceGroupName, name)
	return
}

// ListStaticSiteFunctionAppSettings description for Gets the application settings of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ListStaticSiteFunctionAppSettings(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteFunctionAppSettings")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteFunctionAppSettings", err.Error())
	}

	req, err := client.ListStaticSiteFunctionAppSettingsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctionAppSettings", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteFunctionAppSettingsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctionAppSettings", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteFunctionAppSettingsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctionAppSettings", resp, "Failure responding to request")
	}

	return
}

// ListStaticSiteFunctionAppSettingsPreparer prepares the ListStaticSiteFunctionAppSettings request.
func (client StaticSitesClient) ListStaticSiteFunctionAppSettingsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listFunctionAppSettings", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteFunctionAppSettingsSender sends the ListStaticSiteFunctionAppSettings request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteFunctionAppSettingsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteFunctionAppSettingsResponder handles the response to the ListStaticSiteFunctionAppSettings request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteFunctionAppSettingsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteFunctions description for Gets the functions of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ListStaticSiteFunctions(ctx context.Context, resourceGroupName string, name string) (result StaticSiteFunctionOverviewCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteFunctions")
		defer func() {
			sc := -1
			if result.ssfoc.Response.Response != nil {
				sc = result.ssfoc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteFunctions", err.Error())
	}

	result.fn = client.listStaticSiteFunctionsNextResults
	req, err := client.ListStaticSiteFunctionsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctions", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteFunctionsSender(req)
	if err != nil {
		result.ssfoc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctions", resp, "Failure sending request")
		return
	}

	result.ssfoc, err = client.ListStaticSiteFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteFunctions", resp, "Failure responding to request")
	}

	return
}

// ListStaticSiteFunctionsPreparer prepares the ListStaticSiteFunctions request.
func (client StaticSitesClient) ListStaticSiteFunctionsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/functions", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteFunctionsSender sends the ListStaticSiteFunctions request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteFunctionsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteFunctionsResponder handles the response to the ListStaticSiteFunctions request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteFunctionsResponder(resp *http.Response) (result StaticSiteFunctionOverviewCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStaticSiteFunctionsNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listStaticSiteFunctionsNextResults(ctx context.Context, lastResults StaticSiteFunctionOverviewCollection) (result StaticSiteFunctionOverviewCollection, err error) {
	req, err := lastResults.staticSiteFunctionOverviewCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteFunctionsNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStaticSiteFunctionsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteFunctionsNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStaticSiteFunctionsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteFunctionsNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStaticSiteFunctionsComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListStaticSiteFunctionsComplete(ctx context.Context, resourceGroupName string, name string) (result StaticSiteFunctionOverviewCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteFunctions")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStaticSiteFunctions(ctx, resourceGroupName, name)
	return
}

// ListStaticSiteSecrets description for Lists the secrets for an existing static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ListStaticSiteSecrets(ctx context.Context, resourceGroupName string, name string) (result StringDictionary, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteSecrets")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteSecrets", err.Error())
	}

	req, err := client.ListStaticSiteSecretsPreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteSecrets", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteSecretsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteSecrets", resp, "Failure sending request")
		return
	}

	result, err = client.ListStaticSiteSecretsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteSecrets", resp, "Failure responding to request")
	}

	return
}

// ListStaticSiteSecretsPreparer prepares the ListStaticSiteSecrets request.
func (client StaticSitesClient) ListStaticSiteSecretsPreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/listSecrets", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteSecretsSender sends the ListStaticSiteSecrets request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteSecretsSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteSecretsResponder handles the response to the ListStaticSiteSecrets request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteSecretsResponder(resp *http.Response) (result StringDictionary, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListStaticSiteUsers description for Gets the list of users of a static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// authprovider - the auth provider for the users.
func (client StaticSitesClient) ListStaticSiteUsers(ctx context.Context, resourceGroupName string, name string, authprovider string) (result StaticSiteUserCollectionPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteUsers")
		defer func() {
			sc := -1
			if result.ssuc.Response.Response != nil {
				sc = result.ssuc.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ListStaticSiteUsers", err.Error())
	}

	result.fn = client.listStaticSiteUsersNextResults
	req, err := client.ListStaticSiteUsersPreparer(ctx, resourceGroupName, name, authprovider)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteUsers", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListStaticSiteUsersSender(req)
	if err != nil {
		result.ssuc.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteUsers", resp, "Failure sending request")
		return
	}

	result.ssuc, err = client.ListStaticSiteUsersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ListStaticSiteUsers", resp, "Failure responding to request")
	}

	return
}

// ListStaticSiteUsersPreparer prepares the ListStaticSiteUsers request.
func (client StaticSitesClient) ListStaticSiteUsersPreparer(ctx context.Context, resourceGroupName string, name string, authprovider string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authprovider":      autorest.Encode("path", authprovider),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/listUsers", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListStaticSiteUsersSender sends the ListStaticSiteUsers request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ListStaticSiteUsersSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListStaticSiteUsersResponder handles the response to the ListStaticSiteUsers request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ListStaticSiteUsersResponder(resp *http.Response) (result StaticSiteUserCollection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listStaticSiteUsersNextResults retrieves the next set of results, if any.
func (client StaticSitesClient) listStaticSiteUsersNextResults(ctx context.Context, lastResults StaticSiteUserCollection) (result StaticSiteUserCollection, err error) {
	req, err := lastResults.staticSiteUserCollectionPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteUsersNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListStaticSiteUsersSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteUsersNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListStaticSiteUsersResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "listStaticSiteUsersNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListStaticSiteUsersComplete enumerates all values, automatically crossing page boundaries as required.
func (client StaticSitesClient) ListStaticSiteUsersComplete(ctx context.Context, resourceGroupName string, name string, authprovider string) (result StaticSiteUserCollectionIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ListStaticSiteUsers")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListStaticSiteUsers(ctx, resourceGroupName, name, authprovider)
	return
}

// ResetStaticSiteAPIKey description for Resets the api key for an existing static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
func (client StaticSitesClient) ResetStaticSiteAPIKey(ctx context.Context, resourceGroupName string, name string, resetPropertiesEnvelope StaticSiteResetPropertiesARMResource) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ResetStaticSiteAPIKey")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ResetStaticSiteAPIKey", err.Error())
	}

	req, err := client.ResetStaticSiteAPIKeyPreparer(ctx, resourceGroupName, name, resetPropertiesEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ResetStaticSiteAPIKey", nil, "Failure preparing request")
		return
	}

	resp, err := client.ResetStaticSiteAPIKeySender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ResetStaticSiteAPIKey", resp, "Failure sending request")
		return
	}

	result, err = client.ResetStaticSiteAPIKeyResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ResetStaticSiteAPIKey", resp, "Failure responding to request")
	}

	return
}

// ResetStaticSiteAPIKeyPreparer prepares the ResetStaticSiteAPIKey request.
func (client StaticSitesClient) ResetStaticSiteAPIKeyPreparer(ctx context.Context, resourceGroupName string, name string, resetPropertiesEnvelope StaticSiteResetPropertiesARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/resetapikey", pathParameters),
		autorest.WithJSON(resetPropertiesEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ResetStaticSiteAPIKeySender sends the ResetStaticSiteAPIKey request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ResetStaticSiteAPIKeySender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ResetStaticSiteAPIKeyResponder handles the response to the ResetStaticSiteAPIKey request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ResetStaticSiteAPIKeyResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// UpdateStaticSite description for Creates a new static site in an existing resource group, or updates an existing
// static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site to create or update.
// staticSiteEnvelope - a JSON representation of the staticsite properties. See example.
func (client StaticSitesClient) UpdateStaticSite(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSitePatchResource) (result StaticSiteARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.UpdateStaticSite")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "UpdateStaticSite", err.Error())
	}

	req, err := client.UpdateStaticSitePreparer(ctx, resourceGroupName, name, staticSiteEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateStaticSiteSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSite", resp, "Failure responding to request")
	}

	return
}

// UpdateStaticSitePreparer prepares the UpdateStaticSite request.
func (client StaticSitesClient) UpdateStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, staticSiteEnvelope StaticSitePatchResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}", pathParameters),
		autorest.WithJSON(staticSiteEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateStaticSiteSender sends the UpdateStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) UpdateStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateStaticSiteResponder handles the response to the UpdateStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) UpdateStaticSiteResponder(resp *http.Response) (result StaticSiteARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// UpdateStaticSiteUser description for Updates a user entry with the listed roles
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// authprovider - the auth provider for this user.
// userid - the user id of the user.
// staticSiteUserEnvelope - a JSON representation of the StaticSiteUser properties. See example.
func (client StaticSitesClient) UpdateStaticSiteUser(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, staticSiteUserEnvelope StaticSiteUserARMResource) (result StaticSiteUserARMResource, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.UpdateStaticSiteUser")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "UpdateStaticSiteUser", err.Error())
	}

	req, err := client.UpdateStaticSiteUserPreparer(ctx, resourceGroupName, name, authprovider, userid, staticSiteUserEnvelope)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSiteUser", nil, "Failure preparing request")
		return
	}

	resp, err := client.UpdateStaticSiteUserSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSiteUser", resp, "Failure sending request")
		return
	}

	result, err = client.UpdateStaticSiteUserResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "UpdateStaticSiteUser", resp, "Failure responding to request")
	}

	return
}

// UpdateStaticSiteUserPreparer prepares the UpdateStaticSiteUser request.
func (client StaticSitesClient) UpdateStaticSiteUserPreparer(ctx context.Context, resourceGroupName string, name string, authprovider string, userid string, staticSiteUserEnvelope StaticSiteUserARMResource) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"authprovider":      autorest.Encode("path", authprovider),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"userid":            autorest.Encode("path", userid),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPatch(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/authproviders/{authprovider}/users/{userid}", pathParameters),
		autorest.WithJSON(staticSiteUserEnvelope),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// UpdateStaticSiteUserSender sends the UpdateStaticSiteUser request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) UpdateStaticSiteUserSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// UpdateStaticSiteUserResponder handles the response to the UpdateStaticSiteUser request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) UpdateStaticSiteUserResponder(resp *http.Response) (result StaticSiteUserARMResource, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ValidateCustomDomainCanBeAddedToStaticSite description for Validates a particular custom domain can be added to a
// static site.
// Parameters:
// resourceGroupName - name of the resource group to which the resource belongs.
// name - name of the static site.
// domainName - the custom domain to validate.
func (client StaticSitesClient) ValidateCustomDomainCanBeAddedToStaticSite(ctx context.Context, resourceGroupName string, name string, domainName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/StaticSitesClient.ValidateCustomDomainCanBeAddedToStaticSite")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: resourceGroupName,
			Constraints: []validation.Constraint{{Target: "resourceGroupName", Name: validation.MaxLength, Rule: 90, Chain: nil},
				{Target: "resourceGroupName", Name: validation.MinLength, Rule: 1, Chain: nil},
				{Target: "resourceGroupName", Name: validation.Pattern, Rule: `^[-\w\._\(\)]+[^\.]$`, Chain: nil}}}}); err != nil {
		return result, validation.NewError("web.StaticSitesClient", "ValidateCustomDomainCanBeAddedToStaticSite", err.Error())
	}

	req, err := client.ValidateCustomDomainCanBeAddedToStaticSitePreparer(ctx, resourceGroupName, name, domainName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ValidateCustomDomainCanBeAddedToStaticSite", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateCustomDomainCanBeAddedToStaticSiteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ValidateCustomDomainCanBeAddedToStaticSite", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateCustomDomainCanBeAddedToStaticSiteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "web.StaticSitesClient", "ValidateCustomDomainCanBeAddedToStaticSite", resp, "Failure responding to request")
	}

	return
}

// ValidateCustomDomainCanBeAddedToStaticSitePreparer prepares the ValidateCustomDomainCanBeAddedToStaticSite request.
func (client StaticSitesClient) ValidateCustomDomainCanBeAddedToStaticSitePreparer(ctx context.Context, resourceGroupName string, name string, domainName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"domainName":        autorest.Encode("path", domainName),
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2019-08-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Web/staticSites/{name}/customDomains/{domainName}/validate", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateCustomDomainCanBeAddedToStaticSiteSender sends the ValidateCustomDomainCanBeAddedToStaticSite request. The method will close the
// http.Response Body if it receives an error.
func (client StaticSitesClient) ValidateCustomDomainCanBeAddedToStaticSiteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ValidateCustomDomainCanBeAddedToStaticSiteResponder handles the response to the ValidateCustomDomainCanBeAddedToStaticSite request. The method always
// closes the http.Response Body.
func (client StaticSitesClient) ValidateCustomDomainCanBeAddedToStaticSiteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}
