package machinelearningservices

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/date"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/machinelearningservices/mgmt/2018-03-01-preview/machinelearningservices"

// ComputeType enumerates the values for compute type.
type ComputeType string

const (
	// ComputeTypeAKS ...
	ComputeTypeAKS ComputeType = "AKS"
	// ComputeTypeBatchAI ...
	ComputeTypeBatchAI ComputeType = "BatchAI"
	// ComputeTypeDataFactory ...
	ComputeTypeDataFactory ComputeType = "DataFactory"
	// ComputeTypeHDInsight ...
	ComputeTypeHDInsight ComputeType = "HDInsight"
	// ComputeTypeVirtualMachine ...
	ComputeTypeVirtualMachine ComputeType = "VirtualMachine"
)

// PossibleComputeTypeValues returns an array of possible values for the ComputeType const type.
func PossibleComputeTypeValues() []ComputeType {
	return []ComputeType{ComputeTypeAKS, ComputeTypeBatchAI, ComputeTypeDataFactory, ComputeTypeHDInsight, ComputeTypeVirtualMachine}
}

// ComputeTypeBasicCompute enumerates the values for compute type basic compute.
type ComputeTypeBasicCompute string

const (
	// ComputeTypeAKS1 ...
	ComputeTypeAKS1 ComputeTypeBasicCompute = "AKS"
	// ComputeTypeBatchAI1 ...
	ComputeTypeBatchAI1 ComputeTypeBasicCompute = "BatchAI"
	// ComputeTypeCompute ...
	ComputeTypeCompute ComputeTypeBasicCompute = "Compute"
	// ComputeTypeDataFactory1 ...
	ComputeTypeDataFactory1 ComputeTypeBasicCompute = "DataFactory"
	// ComputeTypeHDInsight1 ...
	ComputeTypeHDInsight1 ComputeTypeBasicCompute = "HDInsight"
	// ComputeTypeVirtualMachine1 ...
	ComputeTypeVirtualMachine1 ComputeTypeBasicCompute = "VirtualMachine"
)

// PossibleComputeTypeBasicComputeValues returns an array of possible values for the ComputeTypeBasicCompute const type.
func PossibleComputeTypeBasicComputeValues() []ComputeTypeBasicCompute {
	return []ComputeTypeBasicCompute{ComputeTypeAKS1, ComputeTypeBatchAI1, ComputeTypeCompute, ComputeTypeDataFactory1, ComputeTypeHDInsight1, ComputeTypeVirtualMachine1}
}

// ComputeTypeBasicComputeSecrets enumerates the values for compute type basic compute secrets.
type ComputeTypeBasicComputeSecrets string

const (
	// ComputeTypeBasicComputeSecretsComputeTypeAKS ...
	ComputeTypeBasicComputeSecretsComputeTypeAKS ComputeTypeBasicComputeSecrets = "AKS"
	// ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets ...
	ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets ComputeTypeBasicComputeSecrets = "ComputeSecrets"
	// ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine ...
	ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine ComputeTypeBasicComputeSecrets = "VirtualMachine"
)

// PossibleComputeTypeBasicComputeSecretsValues returns an array of possible values for the ComputeTypeBasicComputeSecrets const type.
func PossibleComputeTypeBasicComputeSecretsValues() []ComputeTypeBasicComputeSecrets {
	return []ComputeTypeBasicComputeSecrets{ComputeTypeBasicComputeSecretsComputeTypeAKS, ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets, ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine}
}

// ProvisioningState enumerates the values for provisioning state.
type ProvisioningState string

const (
	// Canceled ...
	Canceled ProvisioningState = "Canceled"
	// Creating ...
	Creating ProvisioningState = "Creating"
	// Deleting ...
	Deleting ProvisioningState = "Deleting"
	// Failed ...
	Failed ProvisioningState = "Failed"
	// Succeeded ...
	Succeeded ProvisioningState = "Succeeded"
	// Unknown ...
	Unknown ProvisioningState = "Unknown"
	// Updating ...
	Updating ProvisioningState = "Updating"
)

// PossibleProvisioningStateValues returns an array of possible values for the ProvisioningState const type.
func PossibleProvisioningStateValues() []ProvisioningState {
	return []ProvisioningState{Canceled, Creating, Deleting, Failed, Succeeded, Unknown, Updating}
}

// ResourceIdentityType enumerates the values for resource identity type.
type ResourceIdentityType string

const (
	// SystemAssigned ...
	SystemAssigned ResourceIdentityType = "SystemAssigned"
)

// PossibleResourceIdentityTypeValues returns an array of possible values for the ResourceIdentityType const type.
func PossibleResourceIdentityTypeValues() []ResourceIdentityType {
	return []ResourceIdentityType{SystemAssigned}
}

// Status enumerates the values for status.
type Status string

const (
	// Disabled ...
	Disabled Status = "Disabled"
	// Enabled ...
	Enabled Status = "Enabled"
)

// PossibleStatusValues returns an array of possible values for the Status const type.
func PossibleStatusValues() []Status {
	return []Status{Disabled, Enabled}
}

// AKS a Machine Learning compute based on AKS.
type AKS struct {
	// Properties - AKS properties
	Properties *AKSProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeBatchAI1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AKS.
func (a AKS) MarshalJSON() ([]byte, error) {
	a.ComputeType = ComputeTypeAKS1
	objectMap := make(map[string]interface{})
	if a.Properties != nil {
		objectMap["properties"] = a.Properties
	}
	if a.ComputeLocation != nil {
		objectMap["computeLocation"] = a.ComputeLocation
	}
	if a.Description != nil {
		objectMap["description"] = a.Description
	}
	if a.ResourceID != nil {
		objectMap["resourceId"] = a.ResourceID
	}
	if a.ComputeType != "" {
		objectMap["computeType"] = a.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for AKS.
func (a AKS) AsAKS() (*AKS, bool) {
	return &a, true
}

// AsBatchAI is the BasicCompute implementation for AKS.
func (a AKS) AsBatchAI() (*BatchAI, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for AKS.
func (a AKS) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for AKS.
func (a AKS) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for AKS.
func (a AKS) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for AKS.
func (a AKS) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for AKS.
func (a AKS) AsBasicCompute() (BasicCompute, bool) {
	return &a, true
}

// AksComputeSecrets secrets related to a Machine Learning compute based on AKS.
type AksComputeSecrets struct {
	// UserKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	UserKubeConfig *string `json:"userKubeConfig,omitempty"`
	// AdminKubeConfig - Content of kubeconfig file that can be used to connect to the Kubernetes cluster.
	AdminKubeConfig *string `json:"adminKubeConfig,omitempty"`
	// ImagePullSecretName - Image registry pull secret.
	ImagePullSecretName *string `json:"imagePullSecretName,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for AksComputeSecrets.
func (acs AksComputeSecrets) MarshalJSON() ([]byte, error) {
	acs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeAKS
	objectMap := make(map[string]interface{})
	if acs.UserKubeConfig != nil {
		objectMap["userKubeConfig"] = acs.UserKubeConfig
	}
	if acs.AdminKubeConfig != nil {
		objectMap["adminKubeConfig"] = acs.AdminKubeConfig
	}
	if acs.ImagePullSecretName != nil {
		objectMap["imagePullSecretName"] = acs.ImagePullSecretName
	}
	if acs.ComputeType != "" {
		objectMap["computeType"] = acs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return &acs, true
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for AksComputeSecrets.
func (acs AksComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &acs, true
}

// AKSProperties AKS properties
type AKSProperties struct {
	// ClusterFqdn - Cluster full qualified domain name
	ClusterFqdn *string `json:"clusterFqdn,omitempty"`
	// SystemServices - System services
	SystemServices *[]SystemService `json:"systemServices,omitempty"`
	// AgentCount - Number of agents
	AgentCount *int32 `json:"agentCount,omitempty"`
	// AgentVMSize - Agent virtual machine size
	AgentVMSize *string `json:"agentVMSize,omitempty"`
	// SslConfiguration - SSL configuration
	SslConfiguration *SslConfiguration `json:"sslConfiguration,omitempty"`
}

// BatchAI a Machine Learning compute based on Azure BatchAI.
type BatchAI struct {
	// Properties - BatchAI properties
	Properties *BatchAIProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeBatchAI1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for BatchAI.
func (ba BatchAI) MarshalJSON() ([]byte, error) {
	ba.ComputeType = ComputeTypeBatchAI1
	objectMap := make(map[string]interface{})
	if ba.Properties != nil {
		objectMap["properties"] = ba.Properties
	}
	if ba.ComputeLocation != nil {
		objectMap["computeLocation"] = ba.ComputeLocation
	}
	if ba.Description != nil {
		objectMap["description"] = ba.Description
	}
	if ba.ResourceID != nil {
		objectMap["resourceId"] = ba.ResourceID
	}
	if ba.ComputeType != "" {
		objectMap["computeType"] = ba.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for BatchAI.
func (ba BatchAI) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsBatchAI is the BasicCompute implementation for BatchAI.
func (ba BatchAI) AsBatchAI() (*BatchAI, bool) {
	return &ba, true
}

// AsVirtualMachine is the BasicCompute implementation for BatchAI.
func (ba BatchAI) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for BatchAI.
func (ba BatchAI) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for BatchAI.
func (ba BatchAI) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for BatchAI.
func (ba BatchAI) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for BatchAI.
func (ba BatchAI) AsBasicCompute() (BasicCompute, bool) {
	return &ba, true
}

// BatchAIProperties batchAI properties
type BatchAIProperties struct {
	// VMSize - Virtual Machine Size
	VMSize *string `json:"vmSize,omitempty"`
	// VMPriority - Virtual Machine priority
	VMPriority *string `json:"vmPriority,omitempty"`
	// ScaleSettings - Scale settings for BatchAI
	ScaleSettings *ScaleSettings `json:"scaleSettings,omitempty"`
}

// BasicCompute machine Learning compute object.
type BasicCompute interface {
	AsAKS() (*AKS, bool)
	AsBatchAI() (*BatchAI, bool)
	AsVirtualMachine() (*VirtualMachine, bool)
	AsHDInsight() (*HDInsight, bool)
	AsDataFactory() (*DataFactory, bool)
	AsCompute() (*Compute, bool)
}

// Compute machine Learning compute object.
type Compute struct {
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeBatchAI1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

func unmarshalBasicCompute(body []byte) (BasicCompute, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeAKS1):
		var a AKS
		err := json.Unmarshal(body, &a)
		return a, err
	case string(ComputeTypeBatchAI1):
		var ba BatchAI
		err := json.Unmarshal(body, &ba)
		return ba, err
	case string(ComputeTypeVirtualMachine1):
		var VM VirtualMachine
		err := json.Unmarshal(body, &VM)
		return VM, err
	case string(ComputeTypeHDInsight1):
		var hi HDInsight
		err := json.Unmarshal(body, &hi)
		return hi, err
	case string(ComputeTypeDataFactory1):
		var df DataFactory
		err := json.Unmarshal(body, &df)
		return df, err
	default:
		var c Compute
		err := json.Unmarshal(body, &c)
		return c, err
	}
}
func unmarshalBasicComputeArray(body []byte) ([]BasicCompute, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	cArray := make([]BasicCompute, len(rawMessages))

	for index, rawMessage := range rawMessages {
		c, err := unmarshalBasicCompute(*rawMessage)
		if err != nil {
			return nil, err
		}
		cArray[index] = c
	}
	return cArray, nil
}

// MarshalJSON is the custom marshaler for Compute.
func (c Compute) MarshalJSON() ([]byte, error) {
	c.ComputeType = ComputeTypeCompute
	objectMap := make(map[string]interface{})
	if c.ComputeLocation != nil {
		objectMap["computeLocation"] = c.ComputeLocation
	}
	if c.Description != nil {
		objectMap["description"] = c.Description
	}
	if c.ResourceID != nil {
		objectMap["resourceId"] = c.ResourceID
	}
	if c.ComputeType != "" {
		objectMap["computeType"] = c.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for Compute.
func (c Compute) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsBatchAI is the BasicCompute implementation for Compute.
func (c Compute) AsBatchAI() (*BatchAI, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for Compute.
func (c Compute) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for Compute.
func (c Compute) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for Compute.
func (c Compute) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for Compute.
func (c Compute) AsCompute() (*Compute, bool) {
	return &c, true
}

// AsBasicCompute is the BasicCompute implementation for Compute.
func (c Compute) AsBasicCompute() (BasicCompute, bool) {
	return &c, true
}

// ComputeResource machine Learning compute object wrapped into ARM resource envelope.
type ComputeResource struct {
	autorest.Response `json:"-"`
	// Properties - Compute properties
	Properties BasicCompute `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ComputeResource.
func (cr ComputeResource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	objectMap["properties"] = cr.Properties
	if cr.Identity != nil {
		objectMap["identity"] = cr.Identity
	}
	if cr.Location != nil {
		objectMap["location"] = cr.Location
	}
	if cr.Tags != nil {
		objectMap["tags"] = cr.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ComputeResource struct.
func (cr *ComputeResource) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				properties, err := unmarshalBasicCompute(*v)
				if err != nil {
					return err
				}
				cr.Properties = properties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				cr.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				cr.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				cr.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				cr.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				cr.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				cr.Tags = tags
			}
		}
	}

	return nil
}

// BasicComputeSecrets secrets related to a Machine Learning compute. Might differ for every type of compute.
type BasicComputeSecrets interface {
	AsAksComputeSecrets() (*AksComputeSecrets, bool)
	AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool)
	AsComputeSecrets() (*ComputeSecrets, bool)
}

// ComputeSecrets secrets related to a Machine Learning compute. Might differ for every type of compute.
type ComputeSecrets struct {
	autorest.Response `json:"-"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

func unmarshalBasicComputeSecrets(body []byte) (BasicComputeSecrets, error) {
	var m map[string]interface{}
	err := json.Unmarshal(body, &m)
	if err != nil {
		return nil, err
	}

	switch m["computeType"] {
	case string(ComputeTypeBasicComputeSecretsComputeTypeAKS):
		var acs AksComputeSecrets
		err := json.Unmarshal(body, &acs)
		return acs, err
	case string(ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine):
		var vms VirtualMachineSecrets
		err := json.Unmarshal(body, &vms)
		return vms, err
	default:
		var cs ComputeSecrets
		err := json.Unmarshal(body, &cs)
		return cs, err
	}
}
func unmarshalBasicComputeSecretsArray(body []byte) ([]BasicComputeSecrets, error) {
	var rawMessages []*json.RawMessage
	err := json.Unmarshal(body, &rawMessages)
	if err != nil {
		return nil, err
	}

	csArray := make([]BasicComputeSecrets, len(rawMessages))

	for index, rawMessage := range rawMessages {
		cs, err := unmarshalBasicComputeSecrets(*rawMessage)
		if err != nil {
			return nil, err
		}
		csArray[index] = cs
	}
	return csArray, nil
}

// MarshalJSON is the custom marshaler for ComputeSecrets.
func (cs ComputeSecrets) MarshalJSON() ([]byte, error) {
	cs.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets
	objectMap := make(map[string]interface{})
	if cs.ComputeType != "" {
		objectMap["computeType"] = cs.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return nil, false
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return nil, false
}

// AsComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return &cs, true
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for ComputeSecrets.
func (cs ComputeSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &cs, true
}

// ComputeSecretsModel ...
type ComputeSecretsModel struct {
	autorest.Response `json:"-"`
	Value             BasicComputeSecrets `json:"value,omitempty"`
}

// UnmarshalJSON is the custom unmarshaler for ComputeSecretsModel struct.
func (csm *ComputeSecretsModel) UnmarshalJSON(body []byte) error {
	cs, err := unmarshalBasicComputeSecrets(body)
	if err != nil {
		return err
	}
	csm.Value = cs

	return nil
}

// DataFactory a DataFactory compute.
type DataFactory struct {
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeBatchAI1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for DataFactory.
func (df DataFactory) MarshalJSON() ([]byte, error) {
	df.ComputeType = ComputeTypeDataFactory1
	objectMap := make(map[string]interface{})
	if df.ComputeLocation != nil {
		objectMap["computeLocation"] = df.ComputeLocation
	}
	if df.Description != nil {
		objectMap["description"] = df.Description
	}
	if df.ResourceID != nil {
		objectMap["resourceId"] = df.ResourceID
	}
	if df.ComputeType != "" {
		objectMap["computeType"] = df.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsBatchAI is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsBatchAI() (*BatchAI, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsDataFactory() (*DataFactory, bool) {
	return &df, true
}

// AsCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for DataFactory.
func (df DataFactory) AsBasicCompute() (BasicCompute, bool) {
	return &df, true
}

// Error wrapper for error response to follow ARM guidelines.
type Error struct {
	// Error - The error response.
	Error *ErrorResponse `json:"error,omitempty"`
}

// ErrorDetail error detail information.
type ErrorDetail struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
}

// ErrorResponse error response information.
type ErrorResponse struct {
	// Code - Error code.
	Code *string `json:"code,omitempty"`
	// Message - Error message.
	Message *string `json:"message,omitempty"`
	// Details - An array of error detail objects.
	Details *[]ErrorDetail `json:"details,omitempty"`
}

// HDInsight a HDInsight compute.
type HDInsight struct {
	Properties *HDInsightProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeBatchAI1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for HDInsight.
func (hi HDInsight) MarshalJSON() ([]byte, error) {
	hi.ComputeType = ComputeTypeHDInsight1
	objectMap := make(map[string]interface{})
	if hi.Properties != nil {
		objectMap["properties"] = hi.Properties
	}
	if hi.ComputeLocation != nil {
		objectMap["computeLocation"] = hi.ComputeLocation
	}
	if hi.Description != nil {
		objectMap["description"] = hi.Description
	}
	if hi.ResourceID != nil {
		objectMap["resourceId"] = hi.ResourceID
	}
	if hi.ComputeType != "" {
		objectMap["computeType"] = hi.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsBatchAI is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsBatchAI() (*BatchAI, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsVirtualMachine() (*VirtualMachine, bool) {
	return nil, false
}

// AsHDInsight is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsHDInsight() (*HDInsight, bool) {
	return &hi, true
}

// AsDataFactory is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for HDInsight.
func (hi HDInsight) AsBasicCompute() (BasicCompute, bool) {
	return &hi, true
}

// HDInsightProperties ...
type HDInsightProperties struct {
	// SSHPort - Port open for ssh connections on the master node of the cluster.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// Address - Public IP address of the master node of the cluster.
	Address *string `json:"address,omitempty"`
	// AdministratorAccount - Admin credentials for master node of the cluster
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
}

// Identity identity for the resource.
type Identity struct {
	// PrincipalID - READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty"`
	// TenantID - READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty"`
	// Type - The identity type. Possible values include: 'SystemAssigned'
	Type ResourceIdentityType `json:"type,omitempty"`
}

// ListWorkspaceKeysResult ...
type ListWorkspaceKeysResult struct {
	autorest.Response `json:"-"`
	// UserStorageKey - READ-ONLY
	UserStorageKey *string `json:"userStorageKey,omitempty"`
	// UserStorageResourceID - READ-ONLY
	UserStorageResourceID *string `json:"userStorageResourceId,omitempty"`
	// AppInsightsInstrumentationKey - READ-ONLY
	AppInsightsInstrumentationKey *string `json:"appInsightsInstrumentationKey,omitempty"`
	// ContainerRegistryCredentials - READ-ONLY
	ContainerRegistryCredentials *RegistryListCredentialsResult `json:"containerRegistryCredentials,omitempty"`
}

// MachineLearningComputeCreateOrUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeCreateOrUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MachineLearningComputeCreateOrUpdateFuture) Result(client MachineLearningComputeClient) (cr ComputeResource, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeCreateOrUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeCreateOrUpdateFuture")
		return
	}
	sender := autorest.DecorateSender(client, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
	if cr.Response.Response, err = future.GetResult(sender); err == nil && cr.Response.Response.StatusCode != http.StatusNoContent {
		cr, err = client.CreateOrUpdateResponder(cr.Response.Response)
		if err != nil {
			err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeCreateOrUpdateFuture", "Result", cr.Response.Response, "Failure responding to request")
		}
	}
	return
}

// MachineLearningComputeDeleteFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MachineLearningComputeDeleteFuture) Result(client MachineLearningComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// MachineLearningComputeSystemUpdateFuture an abstraction for monitoring and retrieving the results of a
// long-running operation.
type MachineLearningComputeSystemUpdateFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *MachineLearningComputeSystemUpdateFuture) Result(client MachineLearningComputeClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.MachineLearningComputeSystemUpdateFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.MachineLearningComputeSystemUpdateFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// Operation azure Machine Learning workspace REST API operation
type Operation struct {
	// Name - Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
	// Display - Display name of operation
	Display *OperationDisplay `json:"display,omitempty"`
}

// OperationDisplay display name of operation
type OperationDisplay struct {
	// Provider - The resource provider name: Microsoft.MachineLearningExperimentation
	Provider *string `json:"provider,omitempty"`
	// Resource - The resource on which the operation is performed.
	Resource *string `json:"resource,omitempty"`
	// Operation - The operation that users can perform.
	Operation *string `json:"operation,omitempty"`
	// Description - The description for the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult an array of operations supported by the resource provider.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - List of AML workspace operations supported by the AML workspace resource provider.
	Value *[]Operation `json:"value,omitempty"`
}

// PaginatedComputeResourcesList paginated list of Machine Learning compute objects wrapped in ARM resource
// envelope.
type PaginatedComputeResourcesList struct {
	autorest.Response `json:"-"`
	// Value - An array of Machine Learning compute objects wrapped in ARM resource envelope.
	Value *[]ComputeResource `json:"value,omitempty"`
	// NextLink - A continuation link (absolute URI) to the next page of results in the list.
	NextLink *string `json:"nextLink,omitempty"`
}

// PaginatedComputeResourcesListIterator provides access to a complete listing of ComputeResource values.
type PaginatedComputeResourcesListIterator struct {
	i    int
	page PaginatedComputeResourcesListPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PaginatedComputeResourcesListIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedComputeResourcesListIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PaginatedComputeResourcesListIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PaginatedComputeResourcesListIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PaginatedComputeResourcesListIterator) Response() PaginatedComputeResourcesList {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PaginatedComputeResourcesListIterator) Value() ComputeResource {
	if !iter.page.NotDone() {
		return ComputeResource{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PaginatedComputeResourcesListIterator type.
func NewPaginatedComputeResourcesListIterator(page PaginatedComputeResourcesListPage) PaginatedComputeResourcesListIterator {
	return PaginatedComputeResourcesListIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (pcrl PaginatedComputeResourcesList) IsEmpty() bool {
	return pcrl.Value == nil || len(*pcrl.Value) == 0
}

// paginatedComputeResourcesListPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (pcrl PaginatedComputeResourcesList) paginatedComputeResourcesListPreparer(ctx context.Context) (*http.Request, error) {
	if pcrl.NextLink == nil || len(to.String(pcrl.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(pcrl.NextLink)))
}

// PaginatedComputeResourcesListPage contains a page of ComputeResource values.
type PaginatedComputeResourcesListPage struct {
	fn   func(context.Context, PaginatedComputeResourcesList) (PaginatedComputeResourcesList, error)
	pcrl PaginatedComputeResourcesList
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PaginatedComputeResourcesListPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PaginatedComputeResourcesListPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.pcrl)
	if err != nil {
		return err
	}
	page.pcrl = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PaginatedComputeResourcesListPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PaginatedComputeResourcesListPage) NotDone() bool {
	return !page.pcrl.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PaginatedComputeResourcesListPage) Response() PaginatedComputeResourcesList {
	return page.pcrl
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PaginatedComputeResourcesListPage) Values() []ComputeResource {
	if page.pcrl.IsEmpty() {
		return nil
	}
	return *page.pcrl.Value
}

// Creates a new instance of the PaginatedComputeResourcesListPage type.
func NewPaginatedComputeResourcesListPage(getNextPage func(context.Context, PaginatedComputeResourcesList) (PaginatedComputeResourcesList, error)) PaginatedComputeResourcesListPage {
	return PaginatedComputeResourcesListPage{fn: getNextPage}
}

// Password ...
type Password struct {
	// Name - READ-ONLY
	Name *string `json:"name,omitempty"`
	// Value - READ-ONLY
	Value *string `json:"value,omitempty"`
}

// RegistryListCredentialsResult ...
type RegistryListCredentialsResult struct {
	// Location - READ-ONLY
	Location *string `json:"location,omitempty"`
	// Username - READ-ONLY
	Username  *string     `json:"username,omitempty"`
	Passwords *[]Password `json:"passwords,omitempty"`
}

// Resource azure Resource Manager resource envelope.
type Resource struct {
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Resource.
func (r Resource) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if r.Identity != nil {
		objectMap["identity"] = r.Identity
	}
	if r.Location != nil {
		objectMap["location"] = r.Location
	}
	if r.Tags != nil {
		objectMap["tags"] = r.Tags
	}
	return json.Marshal(objectMap)
}

// ScaleSettings scale settings for BatchAI Compute
type ScaleSettings struct {
	// MaxNodeCount - Max number of nodes to use
	MaxNodeCount *int32 `json:"maxNodeCount,omitempty"`
	// MinNodeCount - Min number of nodes to use
	MinNodeCount *int32 `json:"minNodeCount,omitempty"`
	// AutoScaleEnabled - Enable or disable auto scale
	AutoScaleEnabled *bool `json:"autoScaleEnabled,omitempty"`
}

// ServicePrincipalCredentials service principal credentials.
type ServicePrincipalCredentials struct {
	// ClientID - Client Id
	ClientID *string `json:"clientId,omitempty"`
	// ClientSecret - Client secret
	ClientSecret *string `json:"clientSecret,omitempty"`
}

// SslConfiguration the SSL configuration for scoring
type SslConfiguration struct {
	// Status - Enable or disable SSL for scoring. Possible values include: 'Disabled', 'Enabled'
	Status Status `json:"status,omitempty"`
	// Cert - Cert data
	Cert *string `json:"cert,omitempty"`
	// Key - Key data
	Key *string `json:"key,omitempty"`
	// Cname - CNAME of the cert
	Cname *string `json:"cname,omitempty"`
}

// SystemService a system service running on a compute.
type SystemService struct {
	// SystemServiceType - READ-ONLY; The type of this system service.
	SystemServiceType *string `json:"systemServiceType,omitempty"`
	// PublicIPAddress - READ-ONLY; Public IP address
	PublicIPAddress *string `json:"publicIpAddress,omitempty"`
	// Version - READ-ONLY; The version for this type.
	Version *string `json:"version,omitempty"`
}

// VirtualMachine a Machine Learning compute based on Azure Virtual Machines.
type VirtualMachine struct {
	Properties *VirtualMachineProperties `json:"properties,omitempty"`
	// ComputeLocation - Location for the underlying compute
	ComputeLocation *string `json:"computeLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provision state of the cluster. Valid values are Unknown, Updating, Provisioning, Succeeded, and Failed. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
	// Description - The description of the Machine Learning compute.
	Description *string `json:"description,omitempty"`
	// CreatedOn - READ-ONLY; The date and time when the compute was created.
	CreatedOn *date.Time `json:"createdOn,omitempty"`
	// ModifiedOn - READ-ONLY; The date and time when the compute was last modified.
	ModifiedOn *date.Time `json:"modifiedOn,omitempty"`
	// ResourceID - ARM resource id of the compute
	ResourceID *string `json:"resourceId,omitempty"`
	// ProvisioningErrors - READ-ONLY; Errors during provisioning
	ProvisioningErrors *[]Error `json:"provisioningErrors,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeCompute', 'ComputeTypeAKS1', 'ComputeTypeBatchAI1', 'ComputeTypeVirtualMachine1', 'ComputeTypeHDInsight1', 'ComputeTypeDataFactory1'
	ComputeType ComputeTypeBasicCompute `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachine.
func (VM VirtualMachine) MarshalJSON() ([]byte, error) {
	VM.ComputeType = ComputeTypeVirtualMachine1
	objectMap := make(map[string]interface{})
	if VM.Properties != nil {
		objectMap["properties"] = VM.Properties
	}
	if VM.ComputeLocation != nil {
		objectMap["computeLocation"] = VM.ComputeLocation
	}
	if VM.Description != nil {
		objectMap["description"] = VM.Description
	}
	if VM.ResourceID != nil {
		objectMap["resourceId"] = VM.ResourceID
	}
	if VM.ComputeType != "" {
		objectMap["computeType"] = VM.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAKS is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsAKS() (*AKS, bool) {
	return nil, false
}

// AsBatchAI is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsBatchAI() (*BatchAI, bool) {
	return nil, false
}

// AsVirtualMachine is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsVirtualMachine() (*VirtualMachine, bool) {
	return &VM, true
}

// AsHDInsight is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsHDInsight() (*HDInsight, bool) {
	return nil, false
}

// AsDataFactory is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsDataFactory() (*DataFactory, bool) {
	return nil, false
}

// AsCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsCompute() (*Compute, bool) {
	return nil, false
}

// AsBasicCompute is the BasicCompute implementation for VirtualMachine.
func (VM VirtualMachine) AsBasicCompute() (BasicCompute, bool) {
	return &VM, true
}

// VirtualMachineProperties ...
type VirtualMachineProperties struct {
	// VirtualMachineSize - Virtual Machine size
	VirtualMachineSize *string `json:"virtualMachineSize,omitempty"`
	// SSHPort - Port open for ssh connections.
	SSHPort *int32 `json:"sshPort,omitempty"`
	// Address - Public IP address of the virtual machine.
	Address *string `json:"address,omitempty"`
	// AdministratorAccount - Admin credentials for virtual machine
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
}

// VirtualMachineSecrets secrets related to a Machine Learning compute based on AKS.
type VirtualMachineSecrets struct {
	// AdministratorAccount - Admin credentials for virtual machine.
	AdministratorAccount *VirtualMachineSSHCredentials `json:"administratorAccount,omitempty"`
	// ComputeType - Possible values include: 'ComputeTypeBasicComputeSecretsComputeTypeComputeSecrets', 'ComputeTypeBasicComputeSecretsComputeTypeAKS', 'ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine'
	ComputeType ComputeTypeBasicComputeSecrets `json:"computeType,omitempty"`
}

// MarshalJSON is the custom marshaler for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) MarshalJSON() ([]byte, error) {
	vms.ComputeType = ComputeTypeBasicComputeSecretsComputeTypeVirtualMachine
	objectMap := make(map[string]interface{})
	if vms.AdministratorAccount != nil {
		objectMap["administratorAccount"] = vms.AdministratorAccount
	}
	if vms.ComputeType != "" {
		objectMap["computeType"] = vms.ComputeType
	}
	return json.Marshal(objectMap)
}

// AsAksComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsAksComputeSecrets() (*AksComputeSecrets, bool) {
	return nil, false
}

// AsVirtualMachineSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsVirtualMachineSecrets() (*VirtualMachineSecrets, bool) {
	return &vms, true
}

// AsComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsComputeSecrets() (*ComputeSecrets, bool) {
	return nil, false
}

// AsBasicComputeSecrets is the BasicComputeSecrets implementation for VirtualMachineSecrets.
func (vms VirtualMachineSecrets) AsBasicComputeSecrets() (BasicComputeSecrets, bool) {
	return &vms, true
}

// VirtualMachineSSHCredentials admin credentials for virtual machine
type VirtualMachineSSHCredentials struct {
	// Username - Username of admin account
	Username *string `json:"username,omitempty"`
	// Password - Password of admin account
	Password *string `json:"password,omitempty"`
	// PublicKeyData - Public key data
	PublicKeyData *string `json:"publicKeyData,omitempty"`
	// PrivateKeyData - Private key data
	PrivateKeyData *string `json:"privateKeyData,omitempty"`
}

// Workspace an object that represents a machine learning workspace.
type Workspace struct {
	autorest.Response `json:"-"`
	// WorkspaceProperties - The properties of the machine learning workspace.
	*WorkspaceProperties `json:"properties,omitempty"`
	// ID - READ-ONLY; Specifies the resource ID.
	ID *string `json:"id,omitempty"`
	// Name - READ-ONLY; Specifies the name of the resource.
	Name *string `json:"name,omitempty"`
	// Identity - The identity of the resource.
	Identity *Identity `json:"identity,omitempty"`
	// Location - Specifies the location of the resource.
	Location *string `json:"location,omitempty"`
	// Type - READ-ONLY; Specifies the type of the resource.
	Type *string `json:"type,omitempty"`
	// Tags - Contains resource tags defined as key/value pairs.
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for Workspace.
func (w Workspace) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if w.WorkspaceProperties != nil {
		objectMap["properties"] = w.WorkspaceProperties
	}
	if w.Identity != nil {
		objectMap["identity"] = w.Identity
	}
	if w.Location != nil {
		objectMap["location"] = w.Location
	}
	if w.Tags != nil {
		objectMap["tags"] = w.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Workspace struct.
func (w *Workspace) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var workspaceProperties WorkspaceProperties
				err = json.Unmarshal(*v, &workspaceProperties)
				if err != nil {
					return err
				}
				w.WorkspaceProperties = &workspaceProperties
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				w.ID = &ID
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				w.Name = &name
			}
		case "identity":
			if v != nil {
				var identity Identity
				err = json.Unmarshal(*v, &identity)
				if err != nil {
					return err
				}
				w.Identity = &identity
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				w.Location = &location
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				w.Type = &typeVar
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				w.Tags = tags
			}
		}
	}

	return nil
}

// WorkspaceListResult the result of a request to list machine learning workspaces.
type WorkspaceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of machine learning workspaces. Since this list may be incomplete, the nextLink field should be used to request the next list of machine learning workspaces.
	Value *[]Workspace `json:"value,omitempty"`
	// NextLink - The URI that can be used to request the next list of machine learning workspaces.
	NextLink *string `json:"nextLink,omitempty"`
}

// WorkspaceListResultIterator provides access to a complete listing of Workspace values.
type WorkspaceListResultIterator struct {
	i    int
	page WorkspaceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *WorkspaceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *WorkspaceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter WorkspaceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter WorkspaceListResultIterator) Response() WorkspaceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter WorkspaceListResultIterator) Value() Workspace {
	if !iter.page.NotDone() {
		return Workspace{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the WorkspaceListResultIterator type.
func NewWorkspaceListResultIterator(page WorkspaceListResultPage) WorkspaceListResultIterator {
	return WorkspaceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (wlr WorkspaceListResult) IsEmpty() bool {
	return wlr.Value == nil || len(*wlr.Value) == 0
}

// workspaceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (wlr WorkspaceListResult) workspaceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if wlr.NextLink == nil || len(to.String(wlr.NextLink)) < 1 {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(wlr.NextLink)))
}

// WorkspaceListResultPage contains a page of Workspace values.
type WorkspaceListResultPage struct {
	fn  func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)
	wlr WorkspaceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *WorkspaceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/WorkspaceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	next, err := page.fn(ctx, page.wlr)
	if err != nil {
		return err
	}
	page.wlr = next
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *WorkspaceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page WorkspaceListResultPage) NotDone() bool {
	return !page.wlr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page WorkspaceListResultPage) Response() WorkspaceListResult {
	return page.wlr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page WorkspaceListResultPage) Values() []Workspace {
	if page.wlr.IsEmpty() {
		return nil
	}
	return *page.wlr.Value
}

// Creates a new instance of the WorkspaceListResultPage type.
func NewWorkspaceListResultPage(getNextPage func(context.Context, WorkspaceListResult) (WorkspaceListResult, error)) WorkspaceListResultPage {
	return WorkspaceListResultPage{fn: getNextPage}
}

// WorkspaceProperties the properties of a machine learning workspace.
type WorkspaceProperties struct {
	// WorkspaceID - READ-ONLY; The immutable id associated with this workspace.
	WorkspaceID *string `json:"workspaceId,omitempty"`
	// Description - The description of this workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - The friendly name for this workspace. This name in mutable
	FriendlyName *string `json:"friendlyName,omitempty"`
	// CreationTime - READ-ONLY; The creation time of the machine learning workspace in ISO8601 format.
	CreationTime *date.Time `json:"creationTime,omitempty"`
	// BatchaiWorkspace - ARM id of the Batch AI workspace associated with this workspace. This cannot be changed once the workspace has been created
	BatchaiWorkspace *string `json:"batchaiWorkspace,omitempty"`
	// KeyVault - ARM id of the key vault associated with this workspace. This cannot be changed once the workspace has been created
	KeyVault *string `json:"keyVault,omitempty"`
	// ApplicationInsights - ARM id of the application insights associated with this workspace. This cannot be changed once the workspace has been created
	ApplicationInsights *string `json:"applicationInsights,omitempty"`
	// ContainerRegistry - ARM id of the container registry associated with this workspace. This cannot be changed once the workspace has been created
	ContainerRegistry *string `json:"containerRegistry,omitempty"`
	// StorageAccount - ARM id of the storage account associated with this workspace. This cannot be changed once the workspace has been created
	StorageAccount *string `json:"storageAccount,omitempty"`
	// DiscoveryURL - Url for the discovery service to identify regional endpoints for machine learning experimentation services
	DiscoveryURL *string `json:"discoveryUrl,omitempty"`
	// ProvisioningState - READ-ONLY; The current deployment state of workspace resource. The provisioningState is to indicate states for resource provisioning. Possible values include: 'Unknown', 'Updating', 'Creating', 'Deleting', 'Succeeded', 'Failed', 'Canceled'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// WorkspacePropertiesUpdateParameters the parameters for updating the properties of a machine learning
// workspace.
type WorkspacePropertiesUpdateParameters struct {
	// Description - The description of this workspace.
	Description *string `json:"description,omitempty"`
	// FriendlyName - The friendly name for this workspace.
	FriendlyName *string `json:"friendlyName,omitempty"`
}

// WorkspacesDeleteFuture an abstraction for monitoring and retrieving the results of a long-running
// operation.
type WorkspacesDeleteFuture struct {
	azure.Future
}

// Result returns the result of the asynchronous operation.
// If the operation has not completed it will return an error.
func (future *WorkspacesDeleteFuture) Result(client WorkspacesClient) (ar autorest.Response, err error) {
	var done bool
	done, err = future.DoneWithContext(context.Background(), client)
	if err != nil {
		err = autorest.NewErrorWithError(err, "machinelearningservices.WorkspacesDeleteFuture", "Result", future.Response(), "Polling failure")
		return
	}
	if !done {
		err = azure.NewAsyncOpIncompleteError("machinelearningservices.WorkspacesDeleteFuture")
		return
	}
	ar.Response = future.Response()
	return
}

// WorkspaceUpdateParameters the parameters for updating a machine learning workspace.
type WorkspaceUpdateParameters struct {
	// Tags - The resource tags for the machine learning workspace.
	Tags map[string]*string `json:"tags"`
	// WorkspacePropertiesUpdateParameters - The properties that the machine learning workspace will be updated with.
	*WorkspacePropertiesUpdateParameters `json:"properties,omitempty"`
}

// MarshalJSON is the custom marshaler for WorkspaceUpdateParameters.
func (wup WorkspaceUpdateParameters) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if wup.Tags != nil {
		objectMap["tags"] = wup.Tags
	}
	if wup.WorkspacePropertiesUpdateParameters != nil {
		objectMap["properties"] = wup.WorkspacePropertiesUpdateParameters
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for WorkspaceUpdateParameters struct.
func (wup *WorkspaceUpdateParameters) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				wup.Tags = tags
			}
		case "properties":
			if v != nil {
				var workspacePropertiesUpdateParameters WorkspacePropertiesUpdateParameters
				err = json.Unmarshal(*v, &workspacePropertiesUpdateParameters)
				if err != nil {
					return err
				}
				wup.WorkspacePropertiesUpdateParameters = &workspacePropertiesUpdateParameters
			}
		}
	}

	return nil
}
