// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sagemaker

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateDomainInput struct {
	_ struct{} `type:"structure"`

	// A collection of settings.
	DefaultUserSettings *UserSettings `type:"structure"`

	// The domain ID.
	//
	// DomainId is a required field
	DomainId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s UpdateDomainInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDomainInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateDomainInput"}

	if s.DomainId == nil {
		invalidParams.Add(aws.NewErrParamRequired("DomainId"))
	}
	if s.DefaultUserSettings != nil {
		if err := s.DefaultUserSettings.Validate(); err != nil {
			invalidParams.AddNested("DefaultUserSettings", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateDomainOutput struct {
	_ struct{} `type:"structure"`

	// The domain Amazon Resource Name (ARN).
	DomainArn *string `type:"string"`
}

// String returns the string representation
func (s UpdateDomainOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateDomain = "UpdateDomain"

// UpdateDomainRequest returns a request value for making API operation for
// Amazon SageMaker Service.
//
// Updates a domain. Changes will impact all of the people in the domain.
//
//    // Example sending a request using UpdateDomainRequest.
//    req := client.UpdateDomainRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sagemaker-2017-07-24/UpdateDomain
func (c *Client) UpdateDomainRequest(input *UpdateDomainInput) UpdateDomainRequest {
	op := &aws.Operation{
		Name:       opUpdateDomain,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateDomainInput{}
	}

	req := c.newRequest(op, input, &UpdateDomainOutput{})
	return UpdateDomainRequest{Request: req, Input: input, Copy: c.UpdateDomainRequest}
}

// UpdateDomainRequest is the request type for the
// UpdateDomain API operation.
type UpdateDomainRequest struct {
	*aws.Request
	Input *UpdateDomainInput
	Copy  func(*UpdateDomainInput) UpdateDomainRequest
}

// Send marshals and sends the UpdateDomain API request.
func (r UpdateDomainRequest) Send(ctx context.Context) (*UpdateDomainResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateDomainResponse{
		UpdateDomainOutput: r.Request.Data.(*UpdateDomainOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateDomainResponse is the response type for the
// UpdateDomain API operation.
type UpdateDomainResponse struct {
	*UpdateDomainOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateDomain request.
func (r *UpdateDomainResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
