// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package codegurureviewer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type ListRepositoryAssociationsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of repository association results returned by ListRepositoryAssociations
	// in paginated output. When this parameter is used, ListRepositoryAssociations
	// only returns maxResults results in a single page along with a nextToken response
	// element. The remaining results of the initial request can be seen by sending
	// another ListRepositoryAssociations request with the returned nextToken value.
	// This value can be between 1 and 100. If this parameter is not used, then
	// ListRepositoryAssociations returns up to 100 results and a nextToken value
	// if applicable.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// List of names to use as a filter.
	Names []string `location:"querystring" locationName:"Name" min:"1" type:"list"`

	// The nextToken value returned from a previous paginated ListRepositoryAssociations
	// request where maxResults was used and the results exceeded the value of that
	// parameter. Pagination continues from the end of the previous results that
	// returned the nextToken value.
	//
	// This token should be treated as an opaque identifier that is only used to
	// retrieve the next items in a list and not for other programmatic purposes.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// List of owners to use as a filter. For AWS CodeCommit, the owner is the AWS
	// account id. For GitHub, it is the GitHub account name.
	Owners []string `location:"querystring" locationName:"Owner" min:"1" type:"list"`

	// List of provider types to use as a filter.
	ProviderTypes []ProviderType `location:"querystring" locationName:"ProviderType" min:"1" type:"list"`

	// List of states to use as a filter.
	States []RepositoryAssociationState `location:"querystring" locationName:"State" min:"1" type:"list"`
}

// String returns the string representation
func (s ListRepositoryAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListRepositoryAssociationsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListRepositoryAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Names != nil && len(s.Names) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Names", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("NextToken", 1))
	}
	if s.Owners != nil && len(s.Owners) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Owners", 1))
	}
	if s.ProviderTypes != nil && len(s.ProviderTypes) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ProviderTypes", 1))
	}
	if s.States != nil && len(s.States) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("States", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRepositoryAssociationsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.MaxResults != nil {
		v := *s.MaxResults

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "MaxResults", protocol.Int64Value(v), metadata)
	}
	if s.Names != nil {
		v := s.Names

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "Name", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Owners != nil {
		v := s.Owners

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "Owner", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.ProviderTypes != nil {
		v := s.ProviderTypes

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "ProviderType", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.States != nil {
		v := s.States

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.QueryTarget, "State", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	return nil
}

type ListRepositoryAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The nextToken value to include in a future ListRecommendations request. When
	// the results of a ListRecommendations request exceed maxResults, this value
	// can be used to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// A list of repository associations that meet the criteria of the request.
	RepositoryAssociationSummaries []RepositoryAssociationSummary `type:"list"`
}

// String returns the string representation
func (s ListRepositoryAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ListRepositoryAssociationsOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.NextToken != nil {
		v := *s.NextToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "NextToken", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.RepositoryAssociationSummaries != nil {
		v := s.RepositoryAssociationSummaries

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "RepositoryAssociationSummaries", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	return nil
}

const opListRepositoryAssociations = "ListRepositoryAssociations"

// ListRepositoryAssociationsRequest returns a request value for making API operation for
// Amazon CodeGuru Reviewer.
//
// Lists repository associations. You can optionally filter on one or more of
// the following recommendation properties: provider types, states, names, and
// owners.
//
//    // Example sending a request using ListRepositoryAssociationsRequest.
//    req := client.ListRepositoryAssociationsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/codeguru-reviewer-2019-09-19/ListRepositoryAssociations
func (c *Client) ListRepositoryAssociationsRequest(input *ListRepositoryAssociationsInput) ListRepositoryAssociationsRequest {
	op := &aws.Operation{
		Name:       opListRepositoryAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/associations",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRepositoryAssociationsInput{}
	}

	req := c.newRequest(op, input, &ListRepositoryAssociationsOutput{})
	return ListRepositoryAssociationsRequest{Request: req, Input: input, Copy: c.ListRepositoryAssociationsRequest}
}

// ListRepositoryAssociationsRequest is the request type for the
// ListRepositoryAssociations API operation.
type ListRepositoryAssociationsRequest struct {
	*aws.Request
	Input *ListRepositoryAssociationsInput
	Copy  func(*ListRepositoryAssociationsInput) ListRepositoryAssociationsRequest
}

// Send marshals and sends the ListRepositoryAssociations API request.
func (r ListRepositoryAssociationsRequest) Send(ctx context.Context) (*ListRepositoryAssociationsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListRepositoryAssociationsResponse{
		ListRepositoryAssociationsOutput: r.Request.Data.(*ListRepositoryAssociationsOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListRepositoryAssociationsRequestPaginator returns a paginator for ListRepositoryAssociations.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListRepositoryAssociationsRequest(input)
//   p := codegurureviewer.NewListRepositoryAssociationsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListRepositoryAssociationsPaginator(req ListRepositoryAssociationsRequest) ListRepositoryAssociationsPaginator {
	return ListRepositoryAssociationsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListRepositoryAssociationsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListRepositoryAssociationsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListRepositoryAssociationsPaginator struct {
	aws.Pager
}

func (p *ListRepositoryAssociationsPaginator) CurrentPage() *ListRepositoryAssociationsOutput {
	return p.Pager.CurrentPage().(*ListRepositoryAssociationsOutput)
}

// ListRepositoryAssociationsResponse is the response type for the
// ListRepositoryAssociations API operation.
type ListRepositoryAssociationsResponse struct {
	*ListRepositoryAssociationsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListRepositoryAssociations request.
func (r *ListRepositoryAssociationsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
