// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package alexaforbusiness

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteRoomSkillParameterInput struct {
	_ struct{} `type:"structure"`

	// The room skill parameter key for which to remove details.
	//
	// ParameterKey is a required field
	ParameterKey *string `min:"1" type:"string" required:"true"`

	// The ARN of the room from which to remove the room skill parameter details.
	RoomArn *string `type:"string"`

	// The ID of the skill from which to remove the room skill parameter details.
	//
	// SkillId is a required field
	SkillId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteRoomSkillParameterInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteRoomSkillParameterInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteRoomSkillParameterInput"}

	if s.ParameterKey == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParameterKey"))
	}
	if s.ParameterKey != nil && len(*s.ParameterKey) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParameterKey", 1))
	}

	if s.SkillId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SkillId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteRoomSkillParameterOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s DeleteRoomSkillParameterOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteRoomSkillParameter = "DeleteRoomSkillParameter"

// DeleteRoomSkillParameterRequest returns a request value for making API operation for
// Alexa For Business.
//
// Deletes room skill parameter details by room, skill, and parameter key ID.
//
//    // Example sending a request using DeleteRoomSkillParameterRequest.
//    req := client.DeleteRoomSkillParameterRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/alexaforbusiness-2017-11-09/DeleteRoomSkillParameter
func (c *Client) DeleteRoomSkillParameterRequest(input *DeleteRoomSkillParameterInput) DeleteRoomSkillParameterRequest {
	op := &aws.Operation{
		Name:       opDeleteRoomSkillParameter,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteRoomSkillParameterInput{}
	}

	req := c.newRequest(op, input, &DeleteRoomSkillParameterOutput{})
	return DeleteRoomSkillParameterRequest{Request: req, Input: input, Copy: c.DeleteRoomSkillParameterRequest}
}

// DeleteRoomSkillParameterRequest is the request type for the
// DeleteRoomSkillParameter API operation.
type DeleteRoomSkillParameterRequest struct {
	*aws.Request
	Input *DeleteRoomSkillParameterInput
	Copy  func(*DeleteRoomSkillParameterInput) DeleteRoomSkillParameterRequest
}

// Send marshals and sends the DeleteRoomSkillParameter API request.
func (r DeleteRoomSkillParameterRequest) Send(ctx context.Context) (*DeleteRoomSkillParameterResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteRoomSkillParameterResponse{
		DeleteRoomSkillParameterOutput: r.Request.Data.(*DeleteRoomSkillParameterOutput),
		response:                       &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteRoomSkillParameterResponse is the response type for the
// DeleteRoomSkillParameter API operation.
type DeleteRoomSkillParameterResponse struct {
	*DeleteRoomSkillParameterOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteRoomSkillParameter request.
func (r *DeleteRoomSkillParameterResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
