package page

// Code generated by cdproto-gen. DO NOT EDIT.

import (
	"errors"

	"github.com/chromedp/cdproto/cdp"
	"github.com/chromedp/cdproto/network"
	"github.com/mailru/easyjson"
	"github.com/mailru/easyjson/jlexer"
	"github.com/mailru/easyjson/jwriter"
)

// FrameResource information about the Resource on the page.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameResource
type FrameResource struct {
	URL          string               `json:"url"`                    // Resource URL.
	Type         network.ResourceType `json:"type"`                   // Type of this resource.
	MimeType     string               `json:"mimeType"`               // Resource mimeType as determined by the browser.
	LastModified *cdp.TimeSinceEpoch  `json:"lastModified,omitempty"` // last-modified timestamp as reported by server.
	ContentSize  float64              `json:"contentSize,omitempty"`  // Resource content size.
	Failed       bool                 `json:"failed,omitempty"`       // True if the resource failed to load.
	Canceled     bool                 `json:"canceled,omitempty"`     // True if the resource was canceled during loading.
}

// FrameResourceTree information about the Frame hierarchy along with their
// cached resources.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameResourceTree
type FrameResourceTree struct {
	Frame       *cdp.Frame           `json:"frame"`                 // Frame information for this tree item.
	ChildFrames []*FrameResourceTree `json:"childFrames,omitempty"` // Child frames.
	Resources   []*FrameResource     `json:"resources"`             // Information about frame resources.
}

// FrameTree information about the Frame hierarchy.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FrameTree
type FrameTree struct {
	Frame       *cdp.Frame   `json:"frame"`                 // Frame information for this tree item.
	ChildFrames []*FrameTree `json:"childFrames,omitempty"` // Child frames.
}

// ScriptIdentifier unique script identifier.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScriptIdentifier
type ScriptIdentifier string

// String returns the ScriptIdentifier as string value.
func (t ScriptIdentifier) String() string {
	return string(t)
}

// TransitionType transition type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-TransitionType
type TransitionType string

// String returns the TransitionType as string value.
func (t TransitionType) String() string {
	return string(t)
}

// TransitionType values.
const (
	TransitionTypeLink             TransitionType = "link"
	TransitionTypeTyped            TransitionType = "typed"
	TransitionTypeAddressBar       TransitionType = "address_bar"
	TransitionTypeAutoBookmark     TransitionType = "auto_bookmark"
	TransitionTypeAutoSubframe     TransitionType = "auto_subframe"
	TransitionTypeManualSubframe   TransitionType = "manual_subframe"
	TransitionTypeGenerated        TransitionType = "generated"
	TransitionTypeAutoToplevel     TransitionType = "auto_toplevel"
	TransitionTypeFormSubmit       TransitionType = "form_submit"
	TransitionTypeReload           TransitionType = "reload"
	TransitionTypeKeyword          TransitionType = "keyword"
	TransitionTypeKeywordGenerated TransitionType = "keyword_generated"
	TransitionTypeOther            TransitionType = "other"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t TransitionType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t TransitionType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *TransitionType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch TransitionType(in.String()) {
	case TransitionTypeLink:
		*t = TransitionTypeLink
	case TransitionTypeTyped:
		*t = TransitionTypeTyped
	case TransitionTypeAddressBar:
		*t = TransitionTypeAddressBar
	case TransitionTypeAutoBookmark:
		*t = TransitionTypeAutoBookmark
	case TransitionTypeAutoSubframe:
		*t = TransitionTypeAutoSubframe
	case TransitionTypeManualSubframe:
		*t = TransitionTypeManualSubframe
	case TransitionTypeGenerated:
		*t = TransitionTypeGenerated
	case TransitionTypeAutoToplevel:
		*t = TransitionTypeAutoToplevel
	case TransitionTypeFormSubmit:
		*t = TransitionTypeFormSubmit
	case TransitionTypeReload:
		*t = TransitionTypeReload
	case TransitionTypeKeyword:
		*t = TransitionTypeKeyword
	case TransitionTypeKeywordGenerated:
		*t = TransitionTypeKeywordGenerated
	case TransitionTypeOther:
		*t = TransitionTypeOther

	default:
		in.AddError(errors.New("unknown TransitionType value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *TransitionType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// NavigationEntry navigation history entry.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-NavigationEntry
type NavigationEntry struct {
	ID             int64          `json:"id"`             // Unique id of the navigation history entry.
	URL            string         `json:"url"`            // URL of the navigation history entry.
	UserTypedURL   string         `json:"userTypedURL"`   // URL that the user typed in the url bar.
	Title          string         `json:"title"`          // Title of the navigation history entry.
	TransitionType TransitionType `json:"transitionType"` // Transition type.
}

// ScreencastFrameMetadata screencast frame metadata.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ScreencastFrameMetadata
type ScreencastFrameMetadata struct {
	OffsetTop       float64             `json:"offsetTop"`           // Top offset in DIP.
	PageScaleFactor float64             `json:"pageScaleFactor"`     // Page scale factor.
	DeviceWidth     float64             `json:"deviceWidth"`         // Device screen width in DIP.
	DeviceHeight    float64             `json:"deviceHeight"`        // Device screen height in DIP.
	ScrollOffsetX   float64             `json:"scrollOffsetX"`       // Position of horizontal scroll in CSS pixels.
	ScrollOffsetY   float64             `json:"scrollOffsetY"`       // Position of vertical scroll in CSS pixels.
	Timestamp       *cdp.TimeSinceEpoch `json:"timestamp,omitempty"` // Frame swap timestamp.
}

// DialogType javascript dialog type.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-DialogType
type DialogType string

// String returns the DialogType as string value.
func (t DialogType) String() string {
	return string(t)
}

// DialogType values.
const (
	DialogTypeAlert        DialogType = "alert"
	DialogTypeConfirm      DialogType = "confirm"
	DialogTypePrompt       DialogType = "prompt"
	DialogTypeBeforeunload DialogType = "beforeunload"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t DialogType) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t DialogType) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *DialogType) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch DialogType(in.String()) {
	case DialogTypeAlert:
		*t = DialogTypeAlert
	case DialogTypeConfirm:
		*t = DialogTypeConfirm
	case DialogTypePrompt:
		*t = DialogTypePrompt
	case DialogTypeBeforeunload:
		*t = DialogTypeBeforeunload

	default:
		in.AddError(errors.New("unknown DialogType value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *DialogType) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// AppManifestError error while paring app manifest.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AppManifestError
type AppManifestError struct {
	Message  string `json:"message"`  // Error message.
	Critical int64  `json:"critical"` // If criticial, this is a non-recoverable parse error.
	Line     int64  `json:"line"`     // Error line.
	Column   int64  `json:"column"`   // Error column.
}

// AppManifestParsedProperties parsed app manifest properties.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-AppManifestParsedProperties
type AppManifestParsedProperties struct {
	Scope string `json:"scope"` // Computed scope value
}

// LayoutViewport layout viewport position and dimensions.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-LayoutViewport
type LayoutViewport struct {
	PageX        int64 `json:"pageX"`        // Horizontal offset relative to the document (CSS pixels).
	PageY        int64 `json:"pageY"`        // Vertical offset relative to the document (CSS pixels).
	ClientWidth  int64 `json:"clientWidth"`  // Width (CSS pixels), excludes scrollbar if present.
	ClientHeight int64 `json:"clientHeight"` // Height (CSS pixels), excludes scrollbar if present.
}

// VisualViewport visual viewport position, dimensions, and scale.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-VisualViewport
type VisualViewport struct {
	OffsetX      float64 `json:"offsetX"`        // Horizontal offset relative to the layout viewport (CSS pixels).
	OffsetY      float64 `json:"offsetY"`        // Vertical offset relative to the layout viewport (CSS pixels).
	PageX        float64 `json:"pageX"`          // Horizontal offset relative to the document (CSS pixels).
	PageY        float64 `json:"pageY"`          // Vertical offset relative to the document (CSS pixels).
	ClientWidth  float64 `json:"clientWidth"`    // Width (CSS pixels), excludes scrollbar if present.
	ClientHeight float64 `json:"clientHeight"`   // Height (CSS pixels), excludes scrollbar if present.
	Scale        float64 `json:"scale"`          // Scale relative to the ideal viewport (size at width=device-width).
	Zoom         float64 `json:"zoom,omitempty"` // Page zoom factor (CSS to device independent pixels ratio).
}

// Viewport viewport for capturing screenshot.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-Viewport
type Viewport struct {
	X      float64 `json:"x"`      // X offset in device independent pixels (dip).
	Y      float64 `json:"y"`      // Y offset in device independent pixels (dip).
	Width  float64 `json:"width"`  // Rectangle width in device independent pixels (dip).
	Height float64 `json:"height"` // Rectangle height in device independent pixels (dip).
	Scale  float64 `json:"scale"`  // Page scale factor.
}

// FontFamilies generic font families collection.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FontFamilies
type FontFamilies struct {
	Standard   string `json:"standard,omitempty"`   // The standard font-family.
	Fixed      string `json:"fixed,omitempty"`      // The fixed font-family.
	Serif      string `json:"serif,omitempty"`      // The serif font-family.
	SansSerif  string `json:"sansSerif,omitempty"`  // The sansSerif font-family.
	Cursive    string `json:"cursive,omitempty"`    // The cursive font-family.
	Fantasy    string `json:"fantasy,omitempty"`    // The fantasy font-family.
	Pictograph string `json:"pictograph,omitempty"` // The pictograph font-family.
}

// FontSizes default font sizes.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-FontSizes
type FontSizes struct {
	Standard int64 `json:"standard,omitempty"` // Default standard font size.
	Fixed    int64 `json:"fixed,omitempty"`    // Default fixed font size.
}

// ClientNavigationReason [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ClientNavigationReason
type ClientNavigationReason string

// String returns the ClientNavigationReason as string value.
func (t ClientNavigationReason) String() string {
	return string(t)
}

// ClientNavigationReason values.
const (
	ClientNavigationReasonFormSubmissionGet     ClientNavigationReason = "formSubmissionGet"
	ClientNavigationReasonFormSubmissionPost    ClientNavigationReason = "formSubmissionPost"
	ClientNavigationReasonHTTPHeaderRefresh     ClientNavigationReason = "httpHeaderRefresh"
	ClientNavigationReasonScriptInitiated       ClientNavigationReason = "scriptInitiated"
	ClientNavigationReasonMetaTagRefresh        ClientNavigationReason = "metaTagRefresh"
	ClientNavigationReasonPageBlockInterstitial ClientNavigationReason = "pageBlockInterstitial"
	ClientNavigationReasonReload                ClientNavigationReason = "reload"
	ClientNavigationReasonAnchorClick           ClientNavigationReason = "anchorClick"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ClientNavigationReason) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ClientNavigationReason) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ClientNavigationReason) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch ClientNavigationReason(in.String()) {
	case ClientNavigationReasonFormSubmissionGet:
		*t = ClientNavigationReasonFormSubmissionGet
	case ClientNavigationReasonFormSubmissionPost:
		*t = ClientNavigationReasonFormSubmissionPost
	case ClientNavigationReasonHTTPHeaderRefresh:
		*t = ClientNavigationReasonHTTPHeaderRefresh
	case ClientNavigationReasonScriptInitiated:
		*t = ClientNavigationReasonScriptInitiated
	case ClientNavigationReasonMetaTagRefresh:
		*t = ClientNavigationReasonMetaTagRefresh
	case ClientNavigationReasonPageBlockInterstitial:
		*t = ClientNavigationReasonPageBlockInterstitial
	case ClientNavigationReasonReload:
		*t = ClientNavigationReasonReload
	case ClientNavigationReasonAnchorClick:
		*t = ClientNavigationReasonAnchorClick

	default:
		in.AddError(errors.New("unknown ClientNavigationReason value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ClientNavigationReason) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// InstallabilityErrorArgument [no description].
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-InstallabilityErrorArgument
type InstallabilityErrorArgument struct {
	Name  string `json:"name"`  // Argument name (e.g. name:'minimum-icon-size-in-pixels').
	Value string `json:"value"` // Argument value (e.g. value:'64').
}

// InstallabilityError the installability error.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-InstallabilityError
type InstallabilityError struct {
	ErrorID        string                         `json:"errorId"`        // The error id (e.g. 'manifest-missing-suitable-icon').
	ErrorArguments []*InstallabilityErrorArgument `json:"errorArguments"` // The list of error arguments (e.g. {name:'minimum-icon-size-in-pixels', value:'64'}).
}

// ReferrerPolicy the referring-policy used for the navigation.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#type-ReferrerPolicy
type ReferrerPolicy string

// String returns the ReferrerPolicy as string value.
func (t ReferrerPolicy) String() string {
	return string(t)
}

// ReferrerPolicy values.
const (
	ReferrerPolicyNoReferrer                  ReferrerPolicy = "noReferrer"
	ReferrerPolicyNoReferrerWhenDowngrade     ReferrerPolicy = "noReferrerWhenDowngrade"
	ReferrerPolicyOrigin                      ReferrerPolicy = "origin"
	ReferrerPolicyOriginWhenCrossOrigin       ReferrerPolicy = "originWhenCrossOrigin"
	ReferrerPolicySameOrigin                  ReferrerPolicy = "sameOrigin"
	ReferrerPolicyStrictOrigin                ReferrerPolicy = "strictOrigin"
	ReferrerPolicyStrictOriginWhenCrossOrigin ReferrerPolicy = "strictOriginWhenCrossOrigin"
	ReferrerPolicyUnsafeURL                   ReferrerPolicy = "unsafeUrl"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ReferrerPolicy) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ReferrerPolicy) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ReferrerPolicy) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch ReferrerPolicy(in.String()) {
	case ReferrerPolicyNoReferrer:
		*t = ReferrerPolicyNoReferrer
	case ReferrerPolicyNoReferrerWhenDowngrade:
		*t = ReferrerPolicyNoReferrerWhenDowngrade
	case ReferrerPolicyOrigin:
		*t = ReferrerPolicyOrigin
	case ReferrerPolicyOriginWhenCrossOrigin:
		*t = ReferrerPolicyOriginWhenCrossOrigin
	case ReferrerPolicySameOrigin:
		*t = ReferrerPolicySameOrigin
	case ReferrerPolicyStrictOrigin:
		*t = ReferrerPolicyStrictOrigin
	case ReferrerPolicyStrictOriginWhenCrossOrigin:
		*t = ReferrerPolicyStrictOriginWhenCrossOrigin
	case ReferrerPolicyUnsafeURL:
		*t = ReferrerPolicyUnsafeURL

	default:
		in.AddError(errors.New("unknown ReferrerPolicy value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ReferrerPolicy) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// FileChooserOpenedMode input mode.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#event-fileChooserOpened
type FileChooserOpenedMode string

// String returns the FileChooserOpenedMode as string value.
func (t FileChooserOpenedMode) String() string {
	return string(t)
}

// FileChooserOpenedMode values.
const (
	FileChooserOpenedModeSelectSingle   FileChooserOpenedMode = "selectSingle"
	FileChooserOpenedModeSelectMultiple FileChooserOpenedMode = "selectMultiple"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t FileChooserOpenedMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t FileChooserOpenedMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *FileChooserOpenedMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch FileChooserOpenedMode(in.String()) {
	case FileChooserOpenedModeSelectSingle:
		*t = FileChooserOpenedModeSelectSingle
	case FileChooserOpenedModeSelectMultiple:
		*t = FileChooserOpenedModeSelectMultiple

	default:
		in.AddError(errors.New("unknown FileChooserOpenedMode value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *FileChooserOpenedMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// DownloadProgressState download status.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#event-downloadProgress
type DownloadProgressState string

// String returns the DownloadProgressState as string value.
func (t DownloadProgressState) String() string {
	return string(t)
}

// DownloadProgressState values.
const (
	DownloadProgressStateInProgress DownloadProgressState = "inProgress"
	DownloadProgressStateCompleted  DownloadProgressState = "completed"
	DownloadProgressStateCanceled   DownloadProgressState = "canceled"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t DownloadProgressState) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t DownloadProgressState) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *DownloadProgressState) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch DownloadProgressState(in.String()) {
	case DownloadProgressStateInProgress:
		*t = DownloadProgressStateInProgress
	case DownloadProgressStateCompleted:
		*t = DownloadProgressStateCompleted
	case DownloadProgressStateCanceled:
		*t = DownloadProgressStateCanceled

	default:
		in.AddError(errors.New("unknown DownloadProgressState value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *DownloadProgressState) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// CaptureScreenshotFormat image compression format (defaults to png).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-captureScreenshot
type CaptureScreenshotFormat string

// String returns the CaptureScreenshotFormat as string value.
func (t CaptureScreenshotFormat) String() string {
	return string(t)
}

// CaptureScreenshotFormat values.
const (
	CaptureScreenshotFormatJpeg CaptureScreenshotFormat = "jpeg"
	CaptureScreenshotFormatPng  CaptureScreenshotFormat = "png"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t CaptureScreenshotFormat) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t CaptureScreenshotFormat) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *CaptureScreenshotFormat) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch CaptureScreenshotFormat(in.String()) {
	case CaptureScreenshotFormatJpeg:
		*t = CaptureScreenshotFormatJpeg
	case CaptureScreenshotFormatPng:
		*t = CaptureScreenshotFormatPng

	default:
		in.AddError(errors.New("unknown CaptureScreenshotFormat value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *CaptureScreenshotFormat) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// CaptureSnapshotFormat format (defaults to mhtml).
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-captureSnapshot
type CaptureSnapshotFormat string

// String returns the CaptureSnapshotFormat as string value.
func (t CaptureSnapshotFormat) String() string {
	return string(t)
}

// CaptureSnapshotFormat values.
const (
	CaptureSnapshotFormatMhtml CaptureSnapshotFormat = "mhtml"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t CaptureSnapshotFormat) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t CaptureSnapshotFormat) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *CaptureSnapshotFormat) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch CaptureSnapshotFormat(in.String()) {
	case CaptureSnapshotFormatMhtml:
		*t = CaptureSnapshotFormatMhtml

	default:
		in.AddError(errors.New("unknown CaptureSnapshotFormat value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *CaptureSnapshotFormat) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// PrintToPDFTransferMode return as stream.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-printToPDF
type PrintToPDFTransferMode string

// String returns the PrintToPDFTransferMode as string value.
func (t PrintToPDFTransferMode) String() string {
	return string(t)
}

// PrintToPDFTransferMode values.
const (
	PrintToPDFTransferModeReturnAsBase64 PrintToPDFTransferMode = "ReturnAsBase64"
	PrintToPDFTransferModeReturnAsStream PrintToPDFTransferMode = "ReturnAsStream"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t PrintToPDFTransferMode) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t PrintToPDFTransferMode) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *PrintToPDFTransferMode) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch PrintToPDFTransferMode(in.String()) {
	case PrintToPDFTransferModeReturnAsBase64:
		*t = PrintToPDFTransferModeReturnAsBase64
	case PrintToPDFTransferModeReturnAsStream:
		*t = PrintToPDFTransferModeReturnAsStream

	default:
		in.AddError(errors.New("unknown PrintToPDFTransferMode value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *PrintToPDFTransferMode) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// ScreencastFormat image compression format.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-startScreencast
type ScreencastFormat string

// String returns the ScreencastFormat as string value.
func (t ScreencastFormat) String() string {
	return string(t)
}

// ScreencastFormat values.
const (
	ScreencastFormatJpeg ScreencastFormat = "jpeg"
	ScreencastFormatPng  ScreencastFormat = "png"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t ScreencastFormat) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t ScreencastFormat) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *ScreencastFormat) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch ScreencastFormat(in.String()) {
	case ScreencastFormatJpeg:
		*t = ScreencastFormatJpeg
	case ScreencastFormatPng:
		*t = ScreencastFormatPng

	default:
		in.AddError(errors.New("unknown ScreencastFormat value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *ScreencastFormat) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}

// SetWebLifecycleStateState target lifecycle state.
//
// See: https://chromedevtools.github.io/devtools-protocol/tot/Page#method-setWebLifecycleState
type SetWebLifecycleStateState string

// String returns the SetWebLifecycleStateState as string value.
func (t SetWebLifecycleStateState) String() string {
	return string(t)
}

// SetWebLifecycleStateState values.
const (
	SetWebLifecycleStateStateFrozen SetWebLifecycleStateState = "frozen"
	SetWebLifecycleStateStateActive SetWebLifecycleStateState = "active"
)

// MarshalEasyJSON satisfies easyjson.Marshaler.
func (t SetWebLifecycleStateState) MarshalEasyJSON(out *jwriter.Writer) {
	out.String(string(t))
}

// MarshalJSON satisfies json.Marshaler.
func (t SetWebLifecycleStateState) MarshalJSON() ([]byte, error) {
	return easyjson.Marshal(t)
}

// UnmarshalEasyJSON satisfies easyjson.Unmarshaler.
func (t *SetWebLifecycleStateState) UnmarshalEasyJSON(in *jlexer.Lexer) {
	switch SetWebLifecycleStateState(in.String()) {
	case SetWebLifecycleStateStateFrozen:
		*t = SetWebLifecycleStateStateFrozen
	case SetWebLifecycleStateStateActive:
		*t = SetWebLifecycleStateStateActive

	default:
		in.AddError(errors.New("unknown SetWebLifecycleStateState value"))
	}
}

// UnmarshalJSON satisfies json.Unmarshaler.
func (t *SetWebLifecycleStateState) UnmarshalJSON(buf []byte) error {
	return easyjson.Unmarshal(buf, t)
}
