// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package resourcegroupsiface provides an interface to enable mocking the AWS Resource Groups service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package resourcegroupsiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/resourcegroups"
)

// ResourceGroupsAPI provides an interface to enable mocking the
// resourcegroups.ResourceGroups service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//    // myFunc uses an SDK service client to make a request to
//    // AWS Resource Groups.
//    func myFunc(svc resourcegroupsiface.ResourceGroupsAPI) bool {
//        // Make svc.CreateGroup request
//    }
//
//    func main() {
//        sess := session.New()
//        svc := resourcegroups.New(sess)
//
//        myFunc(svc)
//    }
//
// In your _test.go file:
//
//    // Define a mock struct to be used in your unit tests of myFunc.
//    type mockResourceGroupsClient struct {
//        resourcegroupsiface.ResourceGroupsAPI
//    }
//    func (m *mockResourceGroupsClient) CreateGroup(input *resourcegroups.CreateGroupInput) (*resourcegroups.CreateGroupOutput, error) {
//        // mock response/functionality
//    }
//
//    func TestMyFunc(t *testing.T) {
//        // Setup Test
//        mockSvc := &mockResourceGroupsClient{}
//
//        myfunc(mockSvc)
//
//        // Verify myFunc's functionality
//    }
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type ResourceGroupsAPI interface {
	CreateGroup(*resourcegroups.CreateGroupInput) (*resourcegroups.CreateGroupOutput, error)
	CreateGroupWithContext(aws.Context, *resourcegroups.CreateGroupInput, ...request.Option) (*resourcegroups.CreateGroupOutput, error)
	CreateGroupRequest(*resourcegroups.CreateGroupInput) (*request.Request, *resourcegroups.CreateGroupOutput)

	DeleteGroup(*resourcegroups.DeleteGroupInput) (*resourcegroups.DeleteGroupOutput, error)
	DeleteGroupWithContext(aws.Context, *resourcegroups.DeleteGroupInput, ...request.Option) (*resourcegroups.DeleteGroupOutput, error)
	DeleteGroupRequest(*resourcegroups.DeleteGroupInput) (*request.Request, *resourcegroups.DeleteGroupOutput)

	GetGroup(*resourcegroups.GetGroupInput) (*resourcegroups.GetGroupOutput, error)
	GetGroupWithContext(aws.Context, *resourcegroups.GetGroupInput, ...request.Option) (*resourcegroups.GetGroupOutput, error)
	GetGroupRequest(*resourcegroups.GetGroupInput) (*request.Request, *resourcegroups.GetGroupOutput)

	GetGroupQuery(*resourcegroups.GetGroupQueryInput) (*resourcegroups.GetGroupQueryOutput, error)
	GetGroupQueryWithContext(aws.Context, *resourcegroups.GetGroupQueryInput, ...request.Option) (*resourcegroups.GetGroupQueryOutput, error)
	GetGroupQueryRequest(*resourcegroups.GetGroupQueryInput) (*request.Request, *resourcegroups.GetGroupQueryOutput)

	GetTags(*resourcegroups.GetTagsInput) (*resourcegroups.GetTagsOutput, error)
	GetTagsWithContext(aws.Context, *resourcegroups.GetTagsInput, ...request.Option) (*resourcegroups.GetTagsOutput, error)
	GetTagsRequest(*resourcegroups.GetTagsInput) (*request.Request, *resourcegroups.GetTagsOutput)

	ListGroupResources(*resourcegroups.ListGroupResourcesInput) (*resourcegroups.ListGroupResourcesOutput, error)
	ListGroupResourcesWithContext(aws.Context, *resourcegroups.ListGroupResourcesInput, ...request.Option) (*resourcegroups.ListGroupResourcesOutput, error)
	ListGroupResourcesRequest(*resourcegroups.ListGroupResourcesInput) (*request.Request, *resourcegroups.ListGroupResourcesOutput)

	ListGroupResourcesPages(*resourcegroups.ListGroupResourcesInput, func(*resourcegroups.ListGroupResourcesOutput, bool) bool) error
	ListGroupResourcesPagesWithContext(aws.Context, *resourcegroups.ListGroupResourcesInput, func(*resourcegroups.ListGroupResourcesOutput, bool) bool, ...request.Option) error

	ListGroups(*resourcegroups.ListGroupsInput) (*resourcegroups.ListGroupsOutput, error)
	ListGroupsWithContext(aws.Context, *resourcegroups.ListGroupsInput, ...request.Option) (*resourcegroups.ListGroupsOutput, error)
	ListGroupsRequest(*resourcegroups.ListGroupsInput) (*request.Request, *resourcegroups.ListGroupsOutput)

	ListGroupsPages(*resourcegroups.ListGroupsInput, func(*resourcegroups.ListGroupsOutput, bool) bool) error
	ListGroupsPagesWithContext(aws.Context, *resourcegroups.ListGroupsInput, func(*resourcegroups.ListGroupsOutput, bool) bool, ...request.Option) error

	SearchResources(*resourcegroups.SearchResourcesInput) (*resourcegroups.SearchResourcesOutput, error)
	SearchResourcesWithContext(aws.Context, *resourcegroups.SearchResourcesInput, ...request.Option) (*resourcegroups.SearchResourcesOutput, error)
	SearchResourcesRequest(*resourcegroups.SearchResourcesInput) (*request.Request, *resourcegroups.SearchResourcesOutput)

	SearchResourcesPages(*resourcegroups.SearchResourcesInput, func(*resourcegroups.SearchResourcesOutput, bool) bool) error
	SearchResourcesPagesWithContext(aws.Context, *resourcegroups.SearchResourcesInput, func(*resourcegroups.SearchResourcesOutput, bool) bool, ...request.Option) error

	Tag(*resourcegroups.TagInput) (*resourcegroups.TagOutput, error)
	TagWithContext(aws.Context, *resourcegroups.TagInput, ...request.Option) (*resourcegroups.TagOutput, error)
	TagRequest(*resourcegroups.TagInput) (*request.Request, *resourcegroups.TagOutput)

	Untag(*resourcegroups.UntagInput) (*resourcegroups.UntagOutput, error)
	UntagWithContext(aws.Context, *resourcegroups.UntagInput, ...request.Option) (*resourcegroups.UntagOutput, error)
	UntagRequest(*resourcegroups.UntagInput) (*request.Request, *resourcegroups.UntagOutput)

	UpdateGroup(*resourcegroups.UpdateGroupInput) (*resourcegroups.UpdateGroupOutput, error)
	UpdateGroupWithContext(aws.Context, *resourcegroups.UpdateGroupInput, ...request.Option) (*resourcegroups.UpdateGroupOutput, error)
	UpdateGroupRequest(*resourcegroups.UpdateGroupInput) (*request.Request, *resourcegroups.UpdateGroupOutput)

	UpdateGroupQuery(*resourcegroups.UpdateGroupQueryInput) (*resourcegroups.UpdateGroupQueryOutput, error)
	UpdateGroupQueryWithContext(aws.Context, *resourcegroups.UpdateGroupQueryInput, ...request.Option) (*resourcegroups.UpdateGroupQueryOutput, error)
	UpdateGroupQueryRequest(*resourcegroups.UpdateGroupQueryInput) (*request.Request, *resourcegroups.UpdateGroupQueryOutput)
}

var _ ResourceGroupsAPI = (*resourcegroups.ResourceGroups)(nil)
