// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/openshift/hive/pkg/apis/hive/v1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// ClusterStateLister helps list ClusterStates.
// All objects returned here must be treated as read-only.
type ClusterStateLister interface {
	// List lists all ClusterStates in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ClusterState, err error)
	// ClusterStates returns an object that can list and get ClusterStates.
	ClusterStates(namespace string) ClusterStateNamespaceLister
	ClusterStateListerExpansion
}

// clusterStateLister implements the ClusterStateLister interface.
type clusterStateLister struct {
	indexer cache.Indexer
}

// NewClusterStateLister returns a new ClusterStateLister.
func NewClusterStateLister(indexer cache.Indexer) ClusterStateLister {
	return &clusterStateLister{indexer: indexer}
}

// List lists all ClusterStates in the indexer.
func (s *clusterStateLister) List(selector labels.Selector) (ret []*v1.ClusterState, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterState))
	})
	return ret, err
}

// ClusterStates returns an object that can list and get ClusterStates.
func (s *clusterStateLister) ClusterStates(namespace string) ClusterStateNamespaceLister {
	return clusterStateNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// ClusterStateNamespaceLister helps list and get ClusterStates.
// All objects returned here must be treated as read-only.
type ClusterStateNamespaceLister interface {
	// List lists all ClusterStates in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.ClusterState, err error)
	// Get retrieves the ClusterState from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.ClusterState, error)
	ClusterStateNamespaceListerExpansion
}

// clusterStateNamespaceLister implements the ClusterStateNamespaceLister
// interface.
type clusterStateNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all ClusterStates in the indexer for a given namespace.
func (s clusterStateNamespaceLister) List(selector labels.Selector) (ret []*v1.ClusterState, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1.ClusterState))
	})
	return ret, err
}

// Get retrieves the ClusterState from the indexer for a given namespace and name.
func (s clusterStateNamespaceLister) Get(name string) (*v1.ClusterState, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1.Resource("clusterstate"), name)
	}
	return obj.(*v1.ClusterState), nil
}
