// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package iam

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

type SetDefaultPolicyVersionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the IAM policy whose default version you
	// want to set.
	//
	// For more information about ARNs, see Amazon Resource Names (ARNs) and AWS
	// Service Namespaces (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html)
	// in the AWS General Reference.
	//
	// PolicyArn is a required field
	PolicyArn *string `min:"20" type:"string" required:"true"`

	// The version of the policy to set as the default (operative) version.
	//
	// For more information about managed policy versions, see Versioning for Managed
	// Policies (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-versions.html)
	// in the IAM User Guide.
	//
	// VersionId is a required field
	VersionId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SetDefaultPolicyVersionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "SetDefaultPolicyVersionInput"}

	if s.PolicyArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("PolicyArn"))
	}
	if s.PolicyArn != nil && len(*s.PolicyArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("PolicyArn", 20))
	}

	if s.VersionId == nil {
		invalidParams.Add(aws.NewErrParamRequired("VersionId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type SetDefaultPolicyVersionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s SetDefaultPolicyVersionOutput) String() string {
	return awsutil.Prettify(s)
}

const opSetDefaultPolicyVersion = "SetDefaultPolicyVersion"

// SetDefaultPolicyVersionRequest returns a request value for making API operation for
// AWS Identity and Access Management.
//
// Sets the specified version of the specified policy as the policy's default
// (operative) version.
//
// This operation affects all users, groups, and roles that the policy is attached
// to. To list the users, groups, and roles that the policy is attached to,
// use the ListEntitiesForPolicy API.
//
// For information about managed policies, see Managed Policies and Inline Policies
// (https://docs.aws.amazon.com/IAM/latest/UserGuide/policies-managed-vs-inline.html)
// in the IAM User Guide.
//
//    // Example sending a request using SetDefaultPolicyVersionRequest.
//    req := client.SetDefaultPolicyVersionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/iam-2010-05-08/SetDefaultPolicyVersion
func (c *Client) SetDefaultPolicyVersionRequest(input *SetDefaultPolicyVersionInput) SetDefaultPolicyVersionRequest {
	op := &aws.Operation{
		Name:       opSetDefaultPolicyVersion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SetDefaultPolicyVersionInput{}
	}

	req := c.newRequest(op, input, &SetDefaultPolicyVersionOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return SetDefaultPolicyVersionRequest{Request: req, Input: input, Copy: c.SetDefaultPolicyVersionRequest}
}

// SetDefaultPolicyVersionRequest is the request type for the
// SetDefaultPolicyVersion API operation.
type SetDefaultPolicyVersionRequest struct {
	*aws.Request
	Input *SetDefaultPolicyVersionInput
	Copy  func(*SetDefaultPolicyVersionInput) SetDefaultPolicyVersionRequest
}

// Send marshals and sends the SetDefaultPolicyVersion API request.
func (r SetDefaultPolicyVersionRequest) Send(ctx context.Context) (*SetDefaultPolicyVersionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &SetDefaultPolicyVersionResponse{
		SetDefaultPolicyVersionOutput: r.Request.Data.(*SetDefaultPolicyVersionOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// SetDefaultPolicyVersionResponse is the response type for the
// SetDefaultPolicyVersion API operation.
type SetDefaultPolicyVersionResponse struct {
	*SetDefaultPolicyVersionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// SetDefaultPolicyVersion request.
func (r *SetDefaultPolicyVersionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
