// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package efs

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/restjson"
)

type ModifyMountTargetSecurityGroupsInput struct {
	_ struct{} `type:"structure"`

	// The ID of the mount target whose security groups you want to modify.
	//
	// MountTargetId is a required field
	MountTargetId *string `location:"uri" locationName:"MountTargetId" type:"string" required:"true"`

	// An array of up to five VPC security group IDs.
	SecurityGroups []string `type:"list"`
}

// String returns the string representation
func (s ModifyMountTargetSecurityGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyMountTargetSecurityGroupsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ModifyMountTargetSecurityGroupsInput"}

	if s.MountTargetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("MountTargetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ModifyMountTargetSecurityGroupsInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.SecurityGroups != nil {
		v := s.SecurityGroups

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "SecurityGroups", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddValue(protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v1)})
		}
		ls0.End()

	}
	if s.MountTargetId != nil {
		v := *s.MountTargetId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "MountTargetId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type ModifyMountTargetSecurityGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s ModifyMountTargetSecurityGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s ModifyMountTargetSecurityGroupsOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opModifyMountTargetSecurityGroups = "ModifyMountTargetSecurityGroups"

// ModifyMountTargetSecurityGroupsRequest returns a request value for making API operation for
// Amazon Elastic File System.
//
// Modifies the set of security groups in effect for a mount target.
//
// When you create a mount target, Amazon EFS also creates a new network interface.
// For more information, see CreateMountTarget. This operation replaces the
// security groups in effect for the network interface associated with a mount
// target, with the SecurityGroups provided in the request. This operation requires
// that the network interface of the mount target has been created and the lifecycle
// state of the mount target is not deleted.
//
// The operation requires permissions for the following actions:
//
//    * elasticfilesystem:ModifyMountTargetSecurityGroups action on the mount
//    target's file system.
//
//    * ec2:ModifyNetworkInterfaceAttribute action on the mount target's network
//    interface.
//
//    // Example sending a request using ModifyMountTargetSecurityGroupsRequest.
//    req := client.ModifyMountTargetSecurityGroupsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/elasticfilesystem-2015-02-01/ModifyMountTargetSecurityGroups
func (c *Client) ModifyMountTargetSecurityGroupsRequest(input *ModifyMountTargetSecurityGroupsInput) ModifyMountTargetSecurityGroupsRequest {
	op := &aws.Operation{
		Name:       opModifyMountTargetSecurityGroups,
		HTTPMethod: "PUT",
		HTTPPath:   "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
	}

	if input == nil {
		input = &ModifyMountTargetSecurityGroupsInput{}
	}

	req := c.newRequest(op, input, &ModifyMountTargetSecurityGroupsOutput{})
	req.Handlers.Unmarshal.Remove(restjson.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)
	return ModifyMountTargetSecurityGroupsRequest{Request: req, Input: input, Copy: c.ModifyMountTargetSecurityGroupsRequest}
}

// ModifyMountTargetSecurityGroupsRequest is the request type for the
// ModifyMountTargetSecurityGroups API operation.
type ModifyMountTargetSecurityGroupsRequest struct {
	*aws.Request
	Input *ModifyMountTargetSecurityGroupsInput
	Copy  func(*ModifyMountTargetSecurityGroupsInput) ModifyMountTargetSecurityGroupsRequest
}

// Send marshals and sends the ModifyMountTargetSecurityGroups API request.
func (r ModifyMountTargetSecurityGroupsRequest) Send(ctx context.Context) (*ModifyMountTargetSecurityGroupsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ModifyMountTargetSecurityGroupsResponse{
		ModifyMountTargetSecurityGroupsOutput: r.Request.Data.(*ModifyMountTargetSecurityGroupsOutput),
		response:                              &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ModifyMountTargetSecurityGroupsResponse is the response type for the
// ModifyMountTargetSecurityGroups API operation.
type ModifyMountTargetSecurityGroupsResponse struct {
	*ModifyMountTargetSecurityGroupsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ModifyMountTargetSecurityGroups request.
func (r *ModifyMountTargetSecurityGroupsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
