// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appsync

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type GetGraphqlApiInput struct {
	_ struct{} `type:"structure"`

	// The API ID for the GraphQL API.
	//
	// ApiId is a required field
	ApiId *string `location:"uri" locationName:"apiId" type:"string" required:"true"`
}

// String returns the string representation
func (s GetGraphqlApiInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetGraphqlApiInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetGraphqlApiInput"}

	if s.ApiId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ApiId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGraphqlApiInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ApiId != nil {
		v := *s.ApiId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "apiId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type GetGraphqlApiOutput struct {
	_ struct{} `type:"structure"`

	// The GraphqlApi object.
	GraphqlApi *GraphqlApi `locationName:"graphqlApi" type:"structure"`
}

// String returns the string representation
func (s GetGraphqlApiOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetGraphqlApiOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.GraphqlApi != nil {
		v := s.GraphqlApi

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "graphqlApi", v, metadata)
	}
	return nil
}

const opGetGraphqlApi = "GetGraphqlApi"

// GetGraphqlApiRequest returns a request value for making API operation for
// AWS AppSync.
//
// Retrieves a GraphqlApi object.
//
//    // Example sending a request using GetGraphqlApiRequest.
//    req := client.GetGraphqlApiRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi
func (c *Client) GetGraphqlApiRequest(input *GetGraphqlApiInput) GetGraphqlApiRequest {
	op := &aws.Operation{
		Name:       opGetGraphqlApi,
		HTTPMethod: "GET",
		HTTPPath:   "/v1/apis/{apiId}",
	}

	if input == nil {
		input = &GetGraphqlApiInput{}
	}

	req := c.newRequest(op, input, &GetGraphqlApiOutput{})
	return GetGraphqlApiRequest{Request: req, Input: input, Copy: c.GetGraphqlApiRequest}
}

// GetGraphqlApiRequest is the request type for the
// GetGraphqlApi API operation.
type GetGraphqlApiRequest struct {
	*aws.Request
	Input *GetGraphqlApiInput
	Copy  func(*GetGraphqlApiInput) GetGraphqlApiRequest
}

// Send marshals and sends the GetGraphqlApi API request.
func (r GetGraphqlApiRequest) Send(ctx context.Context) (*GetGraphqlApiResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetGraphqlApiResponse{
		GetGraphqlApiOutput: r.Request.Data.(*GetGraphqlApiOutput),
		response:            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetGraphqlApiResponse is the response type for the
// GetGraphqlApi API operation.
type GetGraphqlApiResponse struct {
	*GetGraphqlApiOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetGraphqlApi request.
func (r *GetGraphqlApiResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
