// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package apigateway

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

// Request to describe a collection of DomainName resources.
type GetDomainNamesInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of returned results per page. The default value is 25
	// and the maximum value is 500.
	Limit *int64 `location:"querystring" locationName:"limit" type:"integer"`

	// The current pagination position in the paged result set.
	Position *string `location:"querystring" locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetDomainNamesInput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDomainNamesInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Limit != nil {
		v := *s.Limit

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "limit", protocol.Int64Value(v), metadata)
	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.QueryTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

// Represents a collection of DomainName resources.
//
// Use Client-Side Certificate (https://docs.aws.amazon.com/apigateway/latest/developerguide/how-to-custom-domains.html)
type GetDomainNamesOutput struct {
	_ struct{} `type:"structure"`

	// The current page of elements from this collection.
	Items []DomainName `locationName:"item" type:"list"`

	Position *string `locationName:"position" type:"string"`
}

// String returns the string representation
func (s GetDomainNamesOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s GetDomainNamesOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Items != nil {
		v := s.Items

		metadata := protocol.Metadata{}
		ls0 := e.List(protocol.BodyTarget, "item", metadata)
		ls0.Start()
		for _, v1 := range v {
			ls0.ListAddFields(v1)
		}
		ls0.End()

	}
	if s.Position != nil {
		v := *s.Position

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "position", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

const opGetDomainNames = "GetDomainNames"

// GetDomainNamesRequest returns a request value for making API operation for
// Amazon API Gateway.
//
// Represents a collection of DomainName resources.
//
//    // Example sending a request using GetDomainNamesRequest.
//    req := client.GetDomainNamesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
func (c *Client) GetDomainNamesRequest(input *GetDomainNamesInput) GetDomainNamesRequest {
	op := &aws.Operation{
		Name:       opGetDomainNames,
		HTTPMethod: "GET",
		HTTPPath:   "/domainnames",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"position"},
			OutputTokens:    []string{"position"},
			LimitToken:      "limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetDomainNamesInput{}
	}

	req := c.newRequest(op, input, &GetDomainNamesOutput{})
	return GetDomainNamesRequest{Request: req, Input: input, Copy: c.GetDomainNamesRequest}
}

// GetDomainNamesRequest is the request type for the
// GetDomainNames API operation.
type GetDomainNamesRequest struct {
	*aws.Request
	Input *GetDomainNamesInput
	Copy  func(*GetDomainNamesInput) GetDomainNamesRequest
}

// Send marshals and sends the GetDomainNames API request.
func (r GetDomainNamesRequest) Send(ctx context.Context) (*GetDomainNamesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetDomainNamesResponse{
		GetDomainNamesOutput: r.Request.Data.(*GetDomainNamesOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewGetDomainNamesRequestPaginator returns a paginator for GetDomainNames.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.GetDomainNamesRequest(input)
//   p := apigateway.NewGetDomainNamesRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewGetDomainNamesPaginator(req GetDomainNamesRequest) GetDomainNamesPaginator {
	return GetDomainNamesPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *GetDomainNamesInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// GetDomainNamesPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type GetDomainNamesPaginator struct {
	aws.Pager
}

func (p *GetDomainNamesPaginator) CurrentPage() *GetDomainNamesOutput {
	return p.Pager.CurrentPage().(*GetDomainNamesOutput)
}

// GetDomainNamesResponse is the response type for the
// GetDomainNames API operation.
type GetDomainNamesResponse struct {
	*GetDomainNamesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetDomainNames request.
func (r *GetDomainNamesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
