// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package lightsail

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DeleteAutoSnapshotInput struct {
	_ struct{} `type:"structure"`

	// The date of the automatic snapshot to delete in YYYY-MM-DD format.
	//
	// Use the get auto snapshots operation to get the available automatic snapshots
	// for a resource.
	//
	// Date is a required field
	Date *string `locationName:"date" type:"string" required:"true"`

	// The name of the source resource from which to delete the automatic snapshot.
	//
	// ResourceName is a required field
	ResourceName *string `locationName:"resourceName" type:"string" required:"true"`
}

// String returns the string representation
func (s DeleteAutoSnapshotInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAutoSnapshotInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DeleteAutoSnapshotInput"}

	if s.Date == nil {
		invalidParams.Add(aws.NewErrParamRequired("Date"))
	}

	if s.ResourceName == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DeleteAutoSnapshotOutput struct {
	_ struct{} `type:"structure"`

	// An array of objects that describe the result of your request.
	Operations []Operation `locationName:"operations" type:"list"`
}

// String returns the string representation
func (s DeleteAutoSnapshotOutput) String() string {
	return awsutil.Prettify(s)
}

const opDeleteAutoSnapshot = "DeleteAutoSnapshot"

// DeleteAutoSnapshotRequest returns a request value for making API operation for
// Amazon Lightsail.
//
// Deletes an automatic snapshot for an instance or disk.
//
//    // Example sending a request using DeleteAutoSnapshotRequest.
//    req := client.DeleteAutoSnapshotRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/lightsail-2016-11-28/DeleteAutoSnapshot
func (c *Client) DeleteAutoSnapshotRequest(input *DeleteAutoSnapshotInput) DeleteAutoSnapshotRequest {
	op := &aws.Operation{
		Name:       opDeleteAutoSnapshot,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteAutoSnapshotInput{}
	}

	req := c.newRequest(op, input, &DeleteAutoSnapshotOutput{})
	return DeleteAutoSnapshotRequest{Request: req, Input: input, Copy: c.DeleteAutoSnapshotRequest}
}

// DeleteAutoSnapshotRequest is the request type for the
// DeleteAutoSnapshot API operation.
type DeleteAutoSnapshotRequest struct {
	*aws.Request
	Input *DeleteAutoSnapshotInput
	Copy  func(*DeleteAutoSnapshotInput) DeleteAutoSnapshotRequest
}

// Send marshals and sends the DeleteAutoSnapshot API request.
func (r DeleteAutoSnapshotRequest) Send(ctx context.Context) (*DeleteAutoSnapshotResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DeleteAutoSnapshotResponse{
		DeleteAutoSnapshotOutput: r.Request.Data.(*DeleteAutoSnapshotOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DeleteAutoSnapshotResponse is the response type for the
// DeleteAutoSnapshot API operation.
type DeleteAutoSnapshotResponse struct {
	*DeleteAutoSnapshotOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DeleteAutoSnapshot request.
func (r *DeleteAutoSnapshotResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
