// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package computeoptimizer

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetEnrollmentStatusInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s GetEnrollmentStatusInput) String() string {
	return awsutil.Prettify(s)
}

type GetEnrollmentStatusOutput struct {
	_ struct{} `type:"structure"`

	// Confirms the enrollment status of member accounts within the organization,
	// if the account is a master account of an organization.
	MemberAccountsEnrolled *bool `locationName:"memberAccountsEnrolled" type:"boolean"`

	// The enrollment status of the account.
	Status Status `locationName:"status" type:"string" enum:"true"`

	// The reason for the enrollment status of the account.
	//
	// For example, an account might show a status of Pending because member accounts
	// of an organization require more time to be enrolled in the service.
	StatusReason *string `locationName:"statusReason" type:"string"`
}

// String returns the string representation
func (s GetEnrollmentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetEnrollmentStatus = "GetEnrollmentStatus"

// GetEnrollmentStatusRequest returns a request value for making API operation for
// AWS Compute Optimizer.
//
// Returns the enrollment (opt in) status of an account to the AWS Compute Optimizer
// service.
//
// If the account is a master account of an organization, this operation also
// confirms the enrollment status of member accounts within the organization.
//
//    // Example sending a request using GetEnrollmentStatusRequest.
//    req := client.GetEnrollmentStatusRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/compute-optimizer-2019-11-01/GetEnrollmentStatus
func (c *Client) GetEnrollmentStatusRequest(input *GetEnrollmentStatusInput) GetEnrollmentStatusRequest {
	op := &aws.Operation{
		Name:       opGetEnrollmentStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetEnrollmentStatusInput{}
	}

	req := c.newRequest(op, input, &GetEnrollmentStatusOutput{})
	return GetEnrollmentStatusRequest{Request: req, Input: input, Copy: c.GetEnrollmentStatusRequest}
}

// GetEnrollmentStatusRequest is the request type for the
// GetEnrollmentStatus API operation.
type GetEnrollmentStatusRequest struct {
	*aws.Request
	Input *GetEnrollmentStatusInput
	Copy  func(*GetEnrollmentStatusInput) GetEnrollmentStatusRequest
}

// Send marshals and sends the GetEnrollmentStatus API request.
func (r GetEnrollmentStatusRequest) Send(ctx context.Context) (*GetEnrollmentStatusResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetEnrollmentStatusResponse{
		GetEnrollmentStatusOutput: r.Request.Data.(*GetEnrollmentStatusOutput),
		response:                  &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetEnrollmentStatusResponse is the response type for the
// GetEnrollmentStatus API operation.
type GetEnrollmentStatusResponse struct {
	*GetEnrollmentStatusOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetEnrollmentStatus request.
func (r *GetEnrollmentStatusResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
