package serialconsoleapi

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/azure-sdk-for-go/services/serialconsole/mgmt/2018-05-01/serialconsole"
)

// ListClientAPI contains the set of methods on the ListClient type.
type ListClientAPI interface {
	Operations(ctx context.Context) (result serialconsole.Operations, err error)
}

var _ ListClientAPI = (*serialconsole.ListClient)(nil)

// ListConsoleClientAPI contains the set of methods on the ListConsoleClient type.
type ListConsoleClientAPI interface {
	Disabled(ctx context.Context) (result serialconsole.GetDisabledResult, err error)
}

var _ ListConsoleClientAPI = (*serialconsole.ListConsoleClient)(nil)

// ConsoleClientAPI contains the set of methods on the ConsoleClient type.
type ConsoleClientAPI interface {
	DisableConsole(ctx context.Context) (result serialconsole.SetDisabledResult, err error)
	EnableConsole(ctx context.Context) (result serialconsole.SetDisabledResult, err error)
}

var _ ConsoleClientAPI = (*serialconsole.ConsoleClient)(nil)
