// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package outposts

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opCreateOutpost = "CreateOutpost"

// CreateOutpostRequest generates a "aws/request.Request" representing the
// client's request for the CreateOutpost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateOutpost for more information on using the CreateOutpost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateOutpostRequest method.
//    req, resp := client.CreateOutpostRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost
func (c *Outposts) CreateOutpostRequest(input *CreateOutpostInput) (req *request.Request, output *CreateOutpostOutput) {
	op := &request.Operation{
		Name:       opCreateOutpost,
		HTTPMethod: "POST",
		HTTPPath:   "/outposts",
	}

	if input == nil {
		input = &CreateOutpostInput{}
	}

	output = &CreateOutpostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateOutpost API operation for AWS Outposts.
//
// Creates an Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation CreateOutpost for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * NotFoundException
//   The specified request is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
//   * ServiceQuotaExceededException
//   You have exceeded a service quota.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/CreateOutpost
func (c *Outposts) CreateOutpost(input *CreateOutpostInput) (*CreateOutpostOutput, error) {
	req, out := c.CreateOutpostRequest(input)
	return out, req.Send()
}

// CreateOutpostWithContext is the same as CreateOutpost with the addition of
// the ability to pass a context and additional request options.
//
// See CreateOutpost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) CreateOutpostWithContext(ctx aws.Context, input *CreateOutpostInput, opts ...request.Option) (*CreateOutpostOutput, error) {
	req, out := c.CreateOutpostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOutpost = "GetOutpost"

// GetOutpostRequest generates a "aws/request.Request" representing the
// client's request for the GetOutpost operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOutpost for more information on using the GetOutpost
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOutpostRequest method.
//    req, resp := client.GetOutpostRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost
func (c *Outposts) GetOutpostRequest(input *GetOutpostInput) (req *request.Request, output *GetOutpostOutput) {
	op := &request.Operation{
		Name:       opGetOutpost,
		HTTPMethod: "GET",
		HTTPPath:   "/outposts/{OutpostId}",
	}

	if input == nil {
		input = &GetOutpostInput{}
	}

	output = &GetOutpostOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOutpost API operation for AWS Outposts.
//
// Gets information about the specified Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation GetOutpost for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * NotFoundException
//   The specified request is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpost
func (c *Outposts) GetOutpost(input *GetOutpostInput) (*GetOutpostOutput, error) {
	req, out := c.GetOutpostRequest(input)
	return out, req.Send()
}

// GetOutpostWithContext is the same as GetOutpost with the addition of
// the ability to pass a context and additional request options.
//
// See GetOutpost for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) GetOutpostWithContext(ctx aws.Context, input *GetOutpostInput, opts ...request.Option) (*GetOutpostOutput, error) {
	req, out := c.GetOutpostRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetOutpostInstanceTypes = "GetOutpostInstanceTypes"

// GetOutpostInstanceTypesRequest generates a "aws/request.Request" representing the
// client's request for the GetOutpostInstanceTypes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetOutpostInstanceTypes for more information on using the GetOutpostInstanceTypes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetOutpostInstanceTypesRequest method.
//    req, resp := client.GetOutpostInstanceTypesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes
func (c *Outposts) GetOutpostInstanceTypesRequest(input *GetOutpostInstanceTypesInput) (req *request.Request, output *GetOutpostInstanceTypesOutput) {
	op := &request.Operation{
		Name:       opGetOutpostInstanceTypes,
		HTTPMethod: "GET",
		HTTPPath:   "/outposts/{OutpostId}/instanceTypes",
	}

	if input == nil {
		input = &GetOutpostInstanceTypesInput{}
	}

	output = &GetOutpostInstanceTypesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetOutpostInstanceTypes API operation for AWS Outposts.
//
// Lists the instance types for the specified Outpost.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation GetOutpostInstanceTypes for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * NotFoundException
//   The specified request is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/GetOutpostInstanceTypes
func (c *Outposts) GetOutpostInstanceTypes(input *GetOutpostInstanceTypesInput) (*GetOutpostInstanceTypesOutput, error) {
	req, out := c.GetOutpostInstanceTypesRequest(input)
	return out, req.Send()
}

// GetOutpostInstanceTypesWithContext is the same as GetOutpostInstanceTypes with the addition of
// the ability to pass a context and additional request options.
//
// See GetOutpostInstanceTypes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) GetOutpostInstanceTypesWithContext(ctx aws.Context, input *GetOutpostInstanceTypesInput, opts ...request.Option) (*GetOutpostInstanceTypesOutput, error) {
	req, out := c.GetOutpostInstanceTypesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListOutposts = "ListOutposts"

// ListOutpostsRequest generates a "aws/request.Request" representing the
// client's request for the ListOutposts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListOutposts for more information on using the ListOutposts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListOutpostsRequest method.
//    req, resp := client.ListOutpostsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts
func (c *Outposts) ListOutpostsRequest(input *ListOutpostsInput) (req *request.Request, output *ListOutpostsOutput) {
	op := &request.Operation{
		Name:       opListOutposts,
		HTTPMethod: "GET",
		HTTPPath:   "/outposts",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListOutpostsInput{}
	}

	output = &ListOutpostsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListOutposts API operation for AWS Outposts.
//
// List the Outposts for your AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation ListOutposts for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListOutposts
func (c *Outposts) ListOutposts(input *ListOutpostsInput) (*ListOutpostsOutput, error) {
	req, out := c.ListOutpostsRequest(input)
	return out, req.Send()
}

// ListOutpostsWithContext is the same as ListOutposts with the addition of
// the ability to pass a context and additional request options.
//
// See ListOutposts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListOutpostsWithContext(ctx aws.Context, input *ListOutpostsInput, opts ...request.Option) (*ListOutpostsOutput, error) {
	req, out := c.ListOutpostsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListOutpostsPages iterates over the pages of a ListOutposts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListOutposts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListOutposts operation.
//    pageNum := 0
//    err := client.ListOutpostsPages(params,
//        func(page *outposts.ListOutpostsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Outposts) ListOutpostsPages(input *ListOutpostsInput, fn func(*ListOutpostsOutput, bool) bool) error {
	return c.ListOutpostsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListOutpostsPagesWithContext same as ListOutpostsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListOutpostsPagesWithContext(ctx aws.Context, input *ListOutpostsInput, fn func(*ListOutpostsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListOutpostsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListOutpostsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListOutpostsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSites = "ListSites"

// ListSitesRequest generates a "aws/request.Request" representing the
// client's request for the ListSites operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSites for more information on using the ListSites
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListSitesRequest method.
//    req, resp := client.ListSitesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites
func (c *Outposts) ListSitesRequest(input *ListSitesInput) (req *request.Request, output *ListSitesOutput) {
	op := &request.Operation{
		Name:       opListSites,
		HTTPMethod: "GET",
		HTTPPath:   "/sites",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSitesInput{}
	}

	output = &ListSitesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSites API operation for AWS Outposts.
//
// Lists the sites for the specified AWS account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Outposts's
// API operation ListSites for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   A parameter is not valid.
//
//   * AccessDeniedException
//   You do not have permission to perform this operation.
//
//   * InternalServerException
//   An internal error has occurred.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/outposts-2019-12-03/ListSites
func (c *Outposts) ListSites(input *ListSitesInput) (*ListSitesOutput, error) {
	req, out := c.ListSitesRequest(input)
	return out, req.Send()
}

// ListSitesWithContext is the same as ListSites with the addition of
// the ability to pass a context and additional request options.
//
// See ListSites for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListSitesWithContext(ctx aws.Context, input *ListSitesInput, opts ...request.Option) (*ListSitesOutput, error) {
	req, out := c.ListSitesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSitesPages iterates over the pages of a ListSites operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSites method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListSites operation.
//    pageNum := 0
//    err := client.ListSitesPages(params,
//        func(page *outposts.ListSitesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *Outposts) ListSitesPages(input *ListSitesInput, fn func(*ListSitesOutput, bool) bool) error {
	return c.ListSitesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSitesPagesWithContext same as ListSitesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Outposts) ListSitesPagesWithContext(ctx aws.Context, input *ListSitesInput, fn func(*ListSitesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSitesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSitesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSitesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

// You do not have permission to perform this operation.
type AccessDeniedException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s AccessDeniedException) OrigErr() error {
	return nil
}

func (s AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s AccessDeniedException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s AccessDeniedException) RequestID() string {
	return s.respMetadata.RequestID
}

type CreateOutpostInput struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `min:"1" type:"string"`

	// The ID of the Availability Zone.
	AvailabilityZoneId *string `min:"1" type:"string"`

	// The Outpost description.
	Description *string `min:"1" type:"string"`

	// The name of the Outpost.
	Name *string `min:"1" type:"string"`

	// The ID of the site.
	//
	// SiteId is a required field
	SiteId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s CreateOutpostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOutpostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateOutpostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateOutpostInput"}
	if s.AvailabilityZone != nil && len(*s.AvailabilityZone) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZone", 1))
	}
	if s.AvailabilityZoneId != nil && len(*s.AvailabilityZoneId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AvailabilityZoneId", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SiteId == nil {
		invalidParams.Add(request.NewErrParamRequired("SiteId"))
	}
	if s.SiteId != nil && len(*s.SiteId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SiteId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *CreateOutpostInput) SetAvailabilityZone(v string) *CreateOutpostInput {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *CreateOutpostInput) SetAvailabilityZoneId(v string) *CreateOutpostInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateOutpostInput) SetDescription(v string) *CreateOutpostInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateOutpostInput) SetName(v string) *CreateOutpostInput {
	s.Name = &v
	return s
}

// SetSiteId sets the SiteId field's value.
func (s *CreateOutpostInput) SetSiteId(v string) *CreateOutpostInput {
	s.SiteId = &v
	return s
}

type CreateOutpostOutput struct {
	_ struct{} `type:"structure"`

	// Information about an Outpost.
	Outpost *Outpost `type:"structure"`
}

// String returns the string representation
func (s CreateOutpostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateOutpostOutput) GoString() string {
	return s.String()
}

// SetOutpost sets the Outpost field's value.
func (s *CreateOutpostOutput) SetOutpost(v *Outpost) *CreateOutpostOutput {
	s.Outpost = v
	return s
}

type GetOutpostInput struct {
	_ struct{} `type:"structure"`

	// The ID of the Outpost.
	//
	// OutpostId is a required field
	OutpostId *string `location:"uri" locationName:"OutpostId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOutpostInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutpostInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutpostInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOutpostInput"}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetOutpostId sets the OutpostId field's value.
func (s *GetOutpostInput) SetOutpostId(v string) *GetOutpostInput {
	s.OutpostId = &v
	return s
}

type GetOutpostInstanceTypesInput struct {
	_ struct{} `type:"structure"`

	// The maximum page size.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`

	// The ID of the Outpost.
	//
	// OutpostId is a required field
	OutpostId *string `location:"uri" locationName:"OutpostId" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetOutpostInstanceTypesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutpostInstanceTypesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetOutpostInstanceTypesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetOutpostInstanceTypesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.OutpostId == nil {
		invalidParams.Add(request.NewErrParamRequired("OutpostId"))
	}
	if s.OutpostId != nil && len(*s.OutpostId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("OutpostId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetOutpostInstanceTypesInput) SetMaxResults(v int64) *GetOutpostInstanceTypesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutpostInstanceTypesInput) SetNextToken(v string) *GetOutpostInstanceTypesInput {
	s.NextToken = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *GetOutpostInstanceTypesInput) SetOutpostId(v string) *GetOutpostInstanceTypesInput {
	s.OutpostId = &v
	return s
}

type GetOutpostInstanceTypesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the instance types.
	InstanceTypes []*InstanceTypeItem `type:"list"`

	// The pagination token.
	NextToken *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Outpost.
	OutpostArn *string `min:"1" type:"string"`

	// The ID of the Outpost.
	OutpostId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetOutpostInstanceTypesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutpostInstanceTypesOutput) GoString() string {
	return s.String()
}

// SetInstanceTypes sets the InstanceTypes field's value.
func (s *GetOutpostInstanceTypesOutput) SetInstanceTypes(v []*InstanceTypeItem) *GetOutpostInstanceTypesOutput {
	s.InstanceTypes = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetOutpostInstanceTypesOutput) SetNextToken(v string) *GetOutpostInstanceTypesOutput {
	s.NextToken = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *GetOutpostInstanceTypesOutput) SetOutpostArn(v string) *GetOutpostInstanceTypesOutput {
	s.OutpostArn = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *GetOutpostInstanceTypesOutput) SetOutpostId(v string) *GetOutpostInstanceTypesOutput {
	s.OutpostId = &v
	return s
}

type GetOutpostOutput struct {
	_ struct{} `type:"structure"`

	// Information about an Outpost.
	Outpost *Outpost `type:"structure"`
}

// String returns the string representation
func (s GetOutpostOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s GetOutpostOutput) GoString() string {
	return s.String()
}

// SetOutpost sets the Outpost field's value.
func (s *GetOutpostOutput) SetOutpost(v *Outpost) *GetOutpostOutput {
	s.Outpost = v
	return s
}

// Information about an instance type.
type InstanceTypeItem struct {
	_ struct{} `type:"structure"`

	// The instance type.
	InstanceType *string `type:"string"`
}

// String returns the string representation
func (s InstanceTypeItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTypeItem) GoString() string {
	return s.String()
}

// SetInstanceType sets the InstanceType field's value.
func (s *InstanceTypeItem) SetInstanceType(v string) *InstanceTypeItem {
	s.InstanceType = &v
	return s
}

// An internal error has occurred.
type InternalServerException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s InternalServerException) OrigErr() error {
	return nil
}

func (s InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s InternalServerException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s InternalServerException) RequestID() string {
	return s.respMetadata.RequestID
}

type ListOutpostsInput struct {
	_ struct{} `type:"structure"`

	// The maximum page size.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListOutpostsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutpostsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListOutpostsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListOutpostsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListOutpostsInput) SetMaxResults(v int64) *ListOutpostsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutpostsInput) SetNextToken(v string) *ListOutpostsInput {
	s.NextToken = &v
	return s
}

type ListOutpostsOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `min:"1" type:"string"`

	// Information about the Outposts.
	Outposts []*Outpost `type:"list"`
}

// String returns the string representation
func (s ListOutpostsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListOutpostsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListOutpostsOutput) SetNextToken(v string) *ListOutpostsOutput {
	s.NextToken = &v
	return s
}

// SetOutposts sets the Outposts field's value.
func (s *ListOutpostsOutput) SetOutposts(v []*Outpost) *ListOutpostsOutput {
	s.Outposts = v
	return s
}

type ListSitesInput struct {
	_ struct{} `type:"structure"`

	// The maximum page size.
	MaxResults *int64 `location:"querystring" locationName:"MaxResults" min:"1" type:"integer"`

	// The pagination token.
	NextToken *string `location:"querystring" locationName:"NextToken" min:"1" type:"string"`
}

// String returns the string representation
func (s ListSitesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSitesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListSitesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListSitesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListSitesInput) SetMaxResults(v int64) *ListSitesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListSitesInput) SetNextToken(v string) *ListSitesInput {
	s.NextToken = &v
	return s
}

type ListSitesOutput struct {
	_ struct{} `type:"structure"`

	// The pagination token.
	NextToken *string `min:"1" type:"string"`

	// Information about the sites.
	Sites []*Site `type:"list"`
}

// String returns the string representation
func (s ListSitesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ListSitesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListSitesOutput) SetNextToken(v string) *ListSitesOutput {
	s.NextToken = &v
	return s
}

// SetSites sets the Sites field's value.
func (s *ListSitesOutput) SetSites(v []*Site) *ListSitesOutput {
	s.Sites = v
	return s
}

// The specified request is not valid.
type NotFoundException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s NotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s NotFoundException) GoString() string {
	return s.String()
}

func newErrorNotFoundException(v protocol.ResponseMetadata) error {
	return &NotFoundException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s NotFoundException) Code() string {
	return "NotFoundException"
}

// Message returns the exception's message.
func (s NotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s NotFoundException) OrigErr() error {
	return nil
}

func (s NotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s NotFoundException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s NotFoundException) RequestID() string {
	return s.respMetadata.RequestID
}

// Information about an Outpost.
type Outpost struct {
	_ struct{} `type:"structure"`

	// The Availability Zone.
	AvailabilityZone *string `min:"1" type:"string"`

	// The ID of the Availability Zone.
	AvailabilityZoneId *string `min:"1" type:"string"`

	// The Outpost description.
	Description *string `min:"1" type:"string"`

	// The life cycle status.
	LifeCycleStatus *string `type:"string"`

	// The name of the Outpost.
	Name *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the Outpost.
	OutpostArn *string `min:"1" type:"string"`

	// The ID of the Outpost.
	OutpostId *string `min:"1" type:"string"`

	// The AWS account ID of the Outpost owner.
	OwnerId *string `min:"12" type:"string"`

	// The ID of the site.
	SiteId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Outpost) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Outpost) GoString() string {
	return s.String()
}

// SetAvailabilityZone sets the AvailabilityZone field's value.
func (s *Outpost) SetAvailabilityZone(v string) *Outpost {
	s.AvailabilityZone = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *Outpost) SetAvailabilityZoneId(v string) *Outpost {
	s.AvailabilityZoneId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Outpost) SetDescription(v string) *Outpost {
	s.Description = &v
	return s
}

// SetLifeCycleStatus sets the LifeCycleStatus field's value.
func (s *Outpost) SetLifeCycleStatus(v string) *Outpost {
	s.LifeCycleStatus = &v
	return s
}

// SetName sets the Name field's value.
func (s *Outpost) SetName(v string) *Outpost {
	s.Name = &v
	return s
}

// SetOutpostArn sets the OutpostArn field's value.
func (s *Outpost) SetOutpostArn(v string) *Outpost {
	s.OutpostArn = &v
	return s
}

// SetOutpostId sets the OutpostId field's value.
func (s *Outpost) SetOutpostId(v string) *Outpost {
	s.OutpostId = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *Outpost) SetOwnerId(v string) *Outpost {
	s.OwnerId = &v
	return s
}

// SetSiteId sets the SiteId field's value.
func (s *Outpost) SetSiteId(v string) *Outpost {
	s.SiteId = &v
	return s
}

// You have exceeded a service quota.
type ServiceQuotaExceededException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ServiceQuotaExceededException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ServiceQuotaExceededException) RequestID() string {
	return s.respMetadata.RequestID
}

// Information about a site.
type Site struct {
	_ struct{} `type:"structure"`

	// The ID of the AWS account.
	AccountId *string `min:"12" type:"string"`

	// The description of the site.
	Description *string `min:"1" type:"string"`

	// The name of the site.
	Name *string `min:"1" type:"string"`

	// The ID of the site.
	SiteId *string `min:"1" type:"string"`
}

// String returns the string representation
func (s Site) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s Site) GoString() string {
	return s.String()
}

// SetAccountId sets the AccountId field's value.
func (s *Site) SetAccountId(v string) *Site {
	s.AccountId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Site) SetDescription(v string) *Site {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *Site) SetName(v string) *Site {
	s.Name = &v
	return s
}

// SetSiteId sets the SiteId field's value.
func (s *Site) SetSiteId(v string) *Site {
	s.SiteId = &v
	return s
}

// A parameter is not valid.
type ValidationException struct {
	_            struct{} `type:"structure"`
	respMetadata protocol.ResponseMetadata

	Message_ *string `locationName:"Message" min:"1" type:"string"`
}

// String returns the string representation
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		respMetadata: v,
	}
}

// Code returns the exception type name.
func (s ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s ValidationException) OrigErr() error {
	return nil
}

func (s ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s ValidationException) StatusCode() int {
	return s.respMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s ValidationException) RequestID() string {
	return s.respMetadata.RequestID
}
