describe("same_site_compatible_test", function()
  it("returns true for nil user agent", function()
    local same_site = require("util.same_site")
    assert.True(same_site.same_site_none_compatible(nil))
  end)
  it("returns false for chrome 4", function()
    local same_site = require("util.same_site")
    assert.False(same_site.same_site_none_compatible("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2704.103 Safari/537.36"))
  end)
  it("returns false for chrome 5", function()
    local same_site = require("util.same_site")
    assert.False(same_site.same_site_none_compatible("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2704.103 Safari/537.36"))
  end)
  it("returns false for chrome 6", function()
    local same_site = require("util.same_site")
    assert.False(same_site.same_site_none_compatible("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/41.0.2704.103 Safari/537.36"))
  end)
  it("returns false for iPhone OS 12", function()
    local same_site = require("util.same_site")
    assert.False(same_site.same_site_none_compatible("Mozilla/5.0 (iPhone; CPU iPhone OS 12_0 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.75 Mobile/14E5239e Safari/602.1"))
  end)
  it("returns false for iPad OS 12", function()
    local same_site = require("util.same_site")
    assert.False(same_site.same_site_none_compatible("Mozilla/5.0 (iPad; CPU OS 12_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0 Mobile/15E148 Safari/604.1"))
  end)
  it("returns false for Mac 10.14 Safari", function()
    local same_site = require("util.same_site")
    assert.False(same_site.same_site_none_compatible("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/12.1.2 Safari/605.1.15"))
  end)

  it("returns true for chrome 7", function()
    local same_site = require("util.same_site")
    assert.True(same_site.same_site_none_compatible("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.2704.103 Safari/537.36"))
  end)
  it("returns true for chrome 8", function()
    local same_site = require("util.same_site")
    assert.True(same_site.same_site_none_compatible("Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/80.0.2704.103 Safari/537.36"))
  end)
  it("returns true for iPhone OS 13", function()
    local same_site = require("util.same_site")
    assert.True(same_site.same_site_none_compatible("Mozilla/5.0 (iPhone; CPU iPhone OS 13_0 like Mac OS X) AppleWebKit/602.1.50 (KHTML, like Gecko) CriOS/56.0.2924.75 Mobile/14E5239e Safari/602.1"))
  end)
  it("returns true for iPad OS 13", function()
    local same_site = require("util.same_site")
    assert.True(same_site.same_site_none_compatible("Mozilla/5.0 (iPad; CPU OS 13_0 like Mac OS X) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0 Mobile/15E148 Safari/604.1"))
  end)
  it("returns true for Mac 10.15 Safari", function()
    local same_site = require("util.same_site")
    assert.True(same_site.same_site_none_compatible("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_2) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/13.0.4 Safari/605.1.15"))
  end)
  it("returns true for Mac 10.14 Chrome", function()
    local same_site = require("util.same_site")
    assert.True(same_site.same_site_none_compatible("Mozilla/5.0 (Macintosh; Intel Mac OS X 10_14_6) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/79.0.3945.117 Safari/537.36"))
  end)
end)
