# Kubernetes Enhancement Proposals (KEPs)

A Kubernetes Enhancement Proposal (KEP) is a way to propose, communicate and coordinate on new efforts for the Kubernetes project. For this reason, the `ingress-nginx` project is adopting it.

## Quick start for the KEP process

Follow the process outlined in the [KEP template](YYYYMMDD-kep-template.md)

### Do I have to use the KEP process?

No... but we hope that you will.
Over time having a rich set of KEPs in one place will make it easier for people to track what is going on in the community and find a structured historic record.

KEPs are only required when the changes are wide ranging and impact most of the project.

### Why would I want to use the KEP process?

Our aim with KEPs is to clearly communicate new efforts to the Kubernetes contributor community.
As such, we want to build a well curated set of clear proposals in a common format with useful metadata.

Benefits to KEP users (in the limit):

* Exposure on a kubernetes blessed web site that is findable via web search engines.
* Cross indexing of KEPs so that users can find connections and the current status of any KEP.
* A clear process with approvers and reviewers for making decisions.
  This will lead to more structured decisions that stick as there is a discoverable record around the decisions.

We are inspired by IETF RFCs, Python PEPs, and Rust RFCs.
