/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.atomix.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path("/atomix")
@ApplicationScoped
public class AtomixResource {

    private static final Logger LOG = Logger.getLogger(AtomixResource.class);

    private static final String COMPONENT_ATOMIX_MAP = "atomix-map";
    private static final String COMPONENT_ATOMIX_MESSAGING = "atomix-messaging";
    private static final String COMPONENT_ATOMIX_MULTIMAP = "atomix-multimap";
    private static final String COMPONENT_ATOMIX_QUEUE = "atomix-queue";
    private static final String COMPONENT_ATOMIX_SET = "atomix-set";
    private static final String COMPONENT_ATOMIX_VALUE = "atomix-value";
    @Inject
    CamelContext context;

    @Path("/load/component/atomix-map")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentAtomixMap() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_ATOMIX_MAP) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_ATOMIX_MAP);
        return Response.status(500, COMPONENT_ATOMIX_MAP + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/atomix-messaging")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentAtomixMessaging() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_ATOMIX_MESSAGING) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_ATOMIX_MESSAGING);
        return Response.status(500, COMPONENT_ATOMIX_MESSAGING + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/atomix-multimap")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentAtomixMultimap() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_ATOMIX_MULTIMAP) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_ATOMIX_MULTIMAP);
        return Response.status(500, COMPONENT_ATOMIX_MULTIMAP + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/atomix-queue")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentAtomixQueue() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_ATOMIX_QUEUE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_ATOMIX_QUEUE);
        return Response.status(500, COMPONENT_ATOMIX_QUEUE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/atomix-set")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentAtomixSet() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_ATOMIX_SET) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_ATOMIX_SET);
        return Response.status(500, COMPONENT_ATOMIX_SET + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/atomix-value")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentAtomixValue() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_ATOMIX_VALUE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_ATOMIX_VALUE);
        return Response.status(500, COMPONENT_ATOMIX_VALUE + " could not be loaded from the Camel context").build();
    }
}
