/*
Licensed to the Apache Software Foundation (ASF) under one or more
contributor license agreements.  See the NOTICE file distributed with
this work for additional information regarding copyright ownership.
The ASF licenses this file to You under the Apache License, Version 2.0
(the "License"); you may not use this file except in compliance with
the License.  You may obtain a copy of the License at

   http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1alpha1

import (
	v1alpha1 "github.com/apache/camel-k/pkg/apis/camel/v1alpha1"
	"k8s.io/apimachinery/pkg/api/errors"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/tools/cache"
)

// KameletBindingLister helps list KameletBindings.
// All objects returned here must be treated as read-only.
type KameletBindingLister interface {
	// List lists all KameletBindings in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.KameletBinding, err error)
	// KameletBindings returns an object that can list and get KameletBindings.
	KameletBindings(namespace string) KameletBindingNamespaceLister
	KameletBindingListerExpansion
}

// kameletBindingLister implements the KameletBindingLister interface.
type kameletBindingLister struct {
	indexer cache.Indexer
}

// NewKameletBindingLister returns a new KameletBindingLister.
func NewKameletBindingLister(indexer cache.Indexer) KameletBindingLister {
	return &kameletBindingLister{indexer: indexer}
}

// List lists all KameletBindings in the indexer.
func (s *kameletBindingLister) List(selector labels.Selector) (ret []*v1alpha1.KameletBinding, err error) {
	err = cache.ListAll(s.indexer, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.KameletBinding))
	})
	return ret, err
}

// KameletBindings returns an object that can list and get KameletBindings.
func (s *kameletBindingLister) KameletBindings(namespace string) KameletBindingNamespaceLister {
	return kameletBindingNamespaceLister{indexer: s.indexer, namespace: namespace}
}

// KameletBindingNamespaceLister helps list and get KameletBindings.
// All objects returned here must be treated as read-only.
type KameletBindingNamespaceLister interface {
	// List lists all KameletBindings in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1alpha1.KameletBinding, err error)
	// Get retrieves the KameletBinding from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1alpha1.KameletBinding, error)
	KameletBindingNamespaceListerExpansion
}

// kameletBindingNamespaceLister implements the KameletBindingNamespaceLister
// interface.
type kameletBindingNamespaceLister struct {
	indexer   cache.Indexer
	namespace string
}

// List lists all KameletBindings in the indexer for a given namespace.
func (s kameletBindingNamespaceLister) List(selector labels.Selector) (ret []*v1alpha1.KameletBinding, err error) {
	err = cache.ListAllByNamespace(s.indexer, s.namespace, selector, func(m interface{}) {
		ret = append(ret, m.(*v1alpha1.KameletBinding))
	})
	return ret, err
}

// Get retrieves the KameletBinding from the indexer for a given namespace and name.
func (s kameletBindingNamespaceLister) Get(name string) (*v1alpha1.KameletBinding, error) {
	obj, exists, err := s.indexer.GetByKey(s.namespace + "/" + name)
	if err != nil {
		return nil, err
	}
	if !exists {
		return nil, errors.NewNotFound(v1alpha1.Resource("kameletbinding"), name)
	}
	return obj.(*v1alpha1.KameletBinding), nil
}
