/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.ignite.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path("/ignite")
@ApplicationScoped
public class IgniteResource {

    private static final Logger LOG = Logger.getLogger(IgniteResource.class);

    private static final String COMPONENT_IGNITE_CACHE = "ignite-cache";
    private static final String COMPONENT_IGNITE_COMPUTE = "ignite-compute";
    private static final String COMPONENT_IGNITE_EVENTS = "ignite-events";
    private static final String COMPONENT_IGNITE_IDGEN = "ignite-idgen";
    private static final String COMPONENT_IGNITE_MESSAGING = "ignite-messaging";
    private static final String COMPONENT_IGNITE_QUEUE = "ignite-queue";
    private static final String COMPONENT_IGNITE_SET = "ignite-set";
    @Inject
    CamelContext context;

    @Path("/load/component/ignite-cache")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIgniteCache() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IGNITE_CACHE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IGNITE_CACHE);
        return Response.status(500, COMPONENT_IGNITE_CACHE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/ignite-compute")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIgniteCompute() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IGNITE_COMPUTE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IGNITE_COMPUTE);
        return Response.status(500, COMPONENT_IGNITE_COMPUTE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/ignite-events")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIgniteEvents() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IGNITE_EVENTS) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IGNITE_EVENTS);
        return Response.status(500, COMPONENT_IGNITE_EVENTS + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/ignite-idgen")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIgniteIdgen() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IGNITE_IDGEN) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IGNITE_IDGEN);
        return Response.status(500, COMPONENT_IGNITE_IDGEN + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/ignite-messaging")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIgniteMessaging() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IGNITE_MESSAGING) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IGNITE_MESSAGING);
        return Response.status(500, COMPONENT_IGNITE_MESSAGING + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/ignite-queue")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIgniteQueue() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IGNITE_QUEUE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IGNITE_QUEUE);
        return Response.status(500, COMPONENT_IGNITE_QUEUE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/ignite-set")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentIgniteSet() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_IGNITE_SET) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_IGNITE_SET);
        return Response.status(500, COMPONENT_IGNITE_SET + " could not be loaded from the Camel context").build();
    }
}
