/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.quarkus.component.hazelcast.it;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.apache.camel.CamelContext;
import org.jboss.logging.Logger;

@Path("/hazelcast")
@ApplicationScoped
public class HazelcastResource {

    private static final Logger LOG = Logger.getLogger(HazelcastResource.class);

    private static final String COMPONENT_HAZELCAST_ATOMICVALUE = "hazelcast-atomicvalue";
    private static final String COMPONENT_HAZELCAST_INSTANCE = "hazelcast-instance";
    private static final String COMPONENT_HAZELCAST_LIST = "hazelcast-list";
    private static final String COMPONENT_HAZELCAST_MAP = "hazelcast-map";
    private static final String COMPONENT_HAZELCAST_MULTIMAP = "hazelcast-multimap";
    private static final String COMPONENT_HAZELCAST_QUEUE = "hazelcast-queue";
    private static final String COMPONENT_HAZELCAST_REPLICATEDMAP = "hazelcast-replicatedmap";
    private static final String COMPONENT_HAZELCAST_RINGBUFFER = "hazelcast-ringbuffer";
    private static final String COMPONENT_HAZELCAST_SEDA = "hazelcast-seda";
    private static final String COMPONENT_HAZELCAST_SET = "hazelcast-set";
    private static final String COMPONENT_HAZELCAST_TOPIC = "hazelcast-topic";
    @Inject
    CamelContext context;

    @Path("/load/component/hazelcast-atomicvalue")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastAtomicvalue() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_ATOMICVALUE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_ATOMICVALUE);
        return Response.status(500, COMPONENT_HAZELCAST_ATOMICVALUE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-instance")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastInstance() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_INSTANCE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_INSTANCE);
        return Response.status(500, COMPONENT_HAZELCAST_INSTANCE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-list")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastList() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_LIST) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_LIST);
        return Response.status(500, COMPONENT_HAZELCAST_LIST + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-map")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastMap() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_MAP) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_MAP);
        return Response.status(500, COMPONENT_HAZELCAST_MAP + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-multimap")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastMultimap() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_MULTIMAP) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_MULTIMAP);
        return Response.status(500, COMPONENT_HAZELCAST_MULTIMAP + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-queue")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastQueue() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_QUEUE) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_QUEUE);
        return Response.status(500, COMPONENT_HAZELCAST_QUEUE + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-replicatedmap")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastReplicatedmap() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_REPLICATEDMAP) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_REPLICATEDMAP);
        return Response.status(500, COMPONENT_HAZELCAST_REPLICATEDMAP + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-ringbuffer")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastRingbuffer() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_RINGBUFFER) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_RINGBUFFER);
        return Response.status(500, COMPONENT_HAZELCAST_RINGBUFFER + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-seda")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastSeda() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_SEDA) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_SEDA);
        return Response.status(500, COMPONENT_HAZELCAST_SEDA + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-set")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastSet() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_SET) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_SET);
        return Response.status(500, COMPONENT_HAZELCAST_SET + " could not be loaded from the Camel context").build();
    }

    @Path("/load/component/hazelcast-topic")
    @GET
    @Produces(MediaType.TEXT_PLAIN)
    public Response loadComponentHazelcastTopic() throws Exception {
        /* This is an autogenerated test */
        if (context.getComponent(COMPONENT_HAZELCAST_TOPIC) != null) {
            return Response.ok().build();
        }
        LOG.warnf("Could not load [%s] from the Camel context", COMPONENT_HAZELCAST_TOPIC);
        return Response.status(500, COMPONENT_HAZELCAST_TOPIC + " could not be loaded from the Camel context").build();
    }
}
