/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.camel.component.jira;

public interface JiraConstants {

    String JIRA = "jira";
    String ACCESS_TOKEN = "accessToken";
    String VERIFICATION_CODE = "verificationCode";
    String JIRA_URL = "jiraUrl";
    String PRIVATE_KEY = "privateKey";
    String CONSUMER_KEY = "consumerKey";
    String ISSUE_ASSIGNEE = "IssueAssignee";
    String ISSUE_COMPONENTS = "IssueComponents";
    String ISSUE_COMMENT = "IssueComment";
    String ISSUE_KEY = "IssueKey";
    String ISSUE_PRIORITY_ID = "IssuePriorityId";
    String ISSUE_PRIORITY_NAME = "IssuePriorityName";
    String ISSUE_PROJECT_KEY = "ProjectKey";
    String ISSUE_SUMMARY = "IssueSummary";
    String ISSUE_TRANSITION_ID = "IssueTransitionId";
    String ISSUE_TYPE_ID = "IssueTypeId";
    String ISSUE_TYPE_NAME = "IssueTypeName";
    String ISSUE_WATCHERS_ADD = "IssueWatchersAdd";
    String ISSUE_WATCHERS_REMOVE = "IssueWatchersRemove";
    String JIRA_REST_CLIENT_FACTORY = "JiraRestClientFactory";
    String PARENT_ISSUE_KEY = "ParentIssueKey";
    String CHILD_ISSUE_KEY = "ChildIssueKey";
    String LINK_TYPE = "linkType";
    String MINUTES_SPENT = "minutesSpent";
}
